<%
/*
 *       Name            :      EgaddudlayerpJson.jsp
 *       Purpose         :		IC - Layer - Add New Layer Process page
 *       CreationDate    :      01/10/2001
 */
%>

<%@ include file="../../../admin/EgTrackerAJSON.jsp"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page import="net.sf.json.JSONObject"%>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json;charset=UTF-8");

	JSONObject rootJSON = new JSONObject();
	rootJSON.put("success","true");

	String layer = request.getParameter("layer");
	
	layer = layer.trim();
	layer = layer.toUpperCase();

	/* code for auditlog starts */
	AuditLogThread auditLogThread = new AuditLogThread();	
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",_user.getLoginID());
	auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
	auditLogThread.setValue("Session_id",session.getId());
	auditLogThread.setValue("Module","Integration Console");
	auditLogThread.setValue("Activity","Layer");
	/* code for auditlog starts */
	egurkha.LayerBean layerBean = new egurkha.LayerBean(true);

	if(layerBean.doesLayerExist(layer))
	{
		rootJSON.put("AlertType","Error");
		rootJSON.put("AlertTitle",_mapping.getTextDescription("admin.error.Add Layer"));
		String msg = _mapping.getTextDescription("admin.error.You are trying to add a layer which is already existing")+". ";
		msg += _mapping.getTextDescription("admin.error.Please enter a unique layer");
		rootJSON.put("AlertMsg",msg);
		
		/* code for auditlog starts */
		auditLogThread.setCurrentValue("Layer Name",layer);
		auditLogThread.setValue("Description","Layer has not been created as it already exists");
		auditLogThread.sendItToDB();
		/* code for auditlog ends */
	}
	else
	{
		layerBean.addLayer(layer);
		/* code for auditlog starts */
		auditLogThread.setCurrentValue("Layer Name",layer);
		auditLogThread.setValue("Description","Layer has been added");
		auditLogThread.sendItToDB();
		/* code for auditlog endss */

		rootJSON.put("AlertType","Result");
		rootJSON.put("AlertTitle",_mapping.getTextDescription("admin.ic.Integration Console - Layer"));
		rootJSON.put("AlertMsg",_mapping.getTextDescription("admin.ic.Layer has been added successfully"));
	}
	out.println(rootJSON);
%>



