<%
/*
 *       Name            :      EgUDLayer.jsp
 *       Purpose         :		IC - Layer 
 *       CreationDate    :      01/10/2001
 */
%>

<%@ include file="../../../admin/EgTrackerAJSON.jsp"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import="egurkha.*" %>
<%@ page import="com.egurkha.ini.IniUI"%>
<%@ page import="net.sf.json.JSONObject"%>
<%@ page import="net.sf.json.JSONArray"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json;charset=UTF-8");

	JSONObject rootJSON = new JSONObject();
	rootJSON.put("success","true");

	String egTitleSearchStr = request.getParameter("searchStr");
	boolean isSearchResult =(egTitleSearchStr!=null && !egTitleSearchStr.trim().equals(""));
	ArrayList searchList = new ArrayList();
	if (isSearchResult)
	{
		StringTokenizer st = new StringTokenizer(egTitleSearchStr);
		while (st.hasMoreTokens())
		{
			String thisToken = st.nextToken().trim();
			if (thisToken.equals(""))
				continue;
			searchList.add(thisToken);
		}
	}

	EgServicesInfo servicesInfo = new EgServicesInfo("manager");
	LayerBean layerBean = new LayerBean();
	ArrayList layers = layerBean.getAllLayers();
	ArrayList userLayers = new ArrayList();
	ArrayList minusTypes = new ArrayList();
	ArrayList ora_layers = layerBean.getLayersForServer("Oracle_server");
	boolean isLayersExist = false;
	isLayersExist = (layers != null && layers.size()>0)?true:false;

	//New Code to show Host,Tcp and Network layer -- Mahe
	String str_temp = "";
	
	for(int i=0;i<ora_layers.size();i++)
	{
		str_temp = (String) ora_layers.get(i);
		if(str_temp.equalsIgnoreCase("HOST") || str_temp.equalsIgnoreCase("NETWORK") || str_temp.equalsIgnoreCase("TCP"))
		{
			ora_layers.remove(i);
			i--;
		}
	}
	//End of new code
	for(int i=0; i<layers.size(); i++)
	{
		String layer = (String) layers.get(i);
		if(layer != null && ( layer.endsWith("_EX") || layer.endsWith("_ex") ) )
		{
			userLayers.add(layer);
			layers.remove(i);
			i--;
		}
	}
	boolean isUDLayersExist = false;
	if (userLayers != null && userLayers.size() ==0)
	{
		rootJSON.put("noUDLayersFound",true);
	}
	else
	{
		isUDLayersExist = true;
	}
	if (!servicesInfo.isAllowExistingTypesInIC())
	{
		layers = new ArrayList();
	}
	for(int i=0; i<layers.size(); i++)
	{
		String layer = (String) layers.get(i);
		if (isSearchResult && !doesExist(searchList,_mapping.getLayerDescription(layer)))
		{
			minusTypes.add(layer);
			continue;
		}
	}

	for(int i=0; i<userLayers.size(); i++)
	{
		String layer = (String) userLayers.get(i);
		if (isSearchResult && !doesExist(searchList,layer))
		{
			minusTypes.add(layer);
		}
	}
	layers.removeAll(minusTypes);
	userLayers.removeAll(minusTypes);
	if (isUDLayersExist && userLayers.size() == 0)
	{
		rootJSON.put("noSrchUDLayersFound",true);
	}

	if (servicesInfo.isAllowExistingTypesInIC())
	{
		/*** Replication starts here ***/
		Collections.sort(layers);

		if(!isLayersExist)
		{
			rootJSON.put("noPDLayersFound",true);
		}
		else
		{
			rootJSON.put("showPDLayers",true);
			boolean searchItemFound = false;
			ArrayList layerList = new ArrayList();
			for(int i=0; i<layers.size(); i++)
			{
				boolean border=(i+1)<layers.size();
				String layer = (String) layers.get(i);
				if (isSearchResult && !doesExist(searchList,_mapping.getLayerDescription(layer)))
				{
					continue;
				}
				searchItemFound=true;
				layerList.add(layer);
			}

			String userLanguage = _user.getLanguage();
			IniUI  iniUI = IniUI.getInstance();
			if (userLanguage == null)
				userLanguage = iniUI.getDefaultLanguage();
					
			MappingNameSorter sorter = new MappingNameSorter(userLanguage);
			layerList = sorter.getSortedLayerList(layerList);	

			JSONArray pdLayers = new JSONArray();
			JSONArray clonePdLayers = new JSONArray();
			JSONObject obj = new JSONObject();
			for (int j=0;j<layerList.size();j++)
			{
				EgName nameObj = (EgName)layerList.get(j);
				String tmpVal = nameObj.getActualName();	
				String tmpDis = nameObj.getLocalName();
				obj = new JSONObject();
				obj.put("Layer",tmpDis);
				obj.put("ActualValue",tmpVal);
				pdLayers.add(obj);
				clonePdLayers.add(obj);
			}

			// The following block add the comp type to associated layers' disp name those have common displayname @see layer "Outside View of VMs"
			EgTablesInfo tablesInfo = new EgTablesInfo("manager");
			for (int a=0; a<pdLayers.size(); a++)
			{
				JSONObject nameObj1 = (JSONObject)pdLayers.get(a);
				String tmpVal1 = (String)nameObj1.get("ActualValue");
				String tmpDis1 = (String)nameObj1.get("Layer");
				for (int b=0; b<clonePdLayers.size(); b++)
				{
					JSONObject nameObj2 = (JSONObject)clonePdLayers.get(b);
					String tmpVal2 = (String)nameObj2.get("ActualValue");
					String tmpDis2 = (String)nameObj2.get("Layer");
					if (tmpVal1.equalsIgnoreCase(tmpVal2))
					{
						continue;
					}
					if (tmpDis1.equalsIgnoreCase(tmpDis2))
					{
						ArrayList serverTyps = tablesInfo.getServersForLayer(tmpVal2);
						//"serverTyps" may has many comp types, so we consider the first element to differentiate
						if(serverTyps != null && serverTyps.size() > 0)
						{
							String compTypes = "";
							List sortedCTypeList = new ArrayList();
							for (int x=0; x<serverTyps.size(); x++)
							{
								sortedCTypeList.add(_mapping.getComponentTypeDescription(serverTyps.get(x).toString()));
							}
							Collections.sort(sortedCTypeList);
							
							for (int s=0; s<sortedCTypeList.size(); s++)
							{
								compTypes += sortedCTypeList.get(s).toString()+", ";
							}
							if (compTypes.endsWith(", "))
							{
								compTypes = compTypes.substring(0,compTypes.length()-2);
							}
							JSONObject nameObj3 = new JSONObject();
							nameObj3.put("ActualValue",tmpVal2);
							nameObj3.put("Layer",tmpDis2+" ("+compTypes+")");
							clonePdLayers.remove(b);
							clonePdLayers.add(b,nameObj3);
						}
					}
				}
			}
			rootJSON.put("pdLayers",clonePdLayers);
			if (!searchItemFound&&egTitleSearchStr!=null&&!egTitleSearchStr.equals(""))
			{
				rootJSON.put("showPDLayers",false);
				rootJSON.put("noSrchPDLayersFound",true);
			}
		}
	}
//UDLAYER LIST
	if (userLayers.size()>0)
	{
		rootJSON.put("showUDLayers",true);
		boolean searchItemFound=false;
		JSONArray udLayers = new JSONArray();
		JSONObject obj = new JSONObject();
		for(int i=0; i<userLayers.size(); i++)
		{
			boolean border=(i+1)<userLayers.size();
			String layer = (String) userLayers.get(i);
			if (isSearchResult && !doesExist(searchList,layer))
			{
				continue;
			}
			searchItemFound=true;
			obj = new JSONObject();
			obj.put("Layer","<b>"+layer+"</b>");
			obj.put("ActualValue",layer);
			udLayers.add(obj);
		}
		rootJSON.put("udLayers",udLayers);
		if (!searchItemFound && egTitleSearchStr!=null && !egTitleSearchStr.equals(""))
		{
			rootJSON.put("noSrchUDLayersFound",true);
		}
	}
	else
	{
		rootJSON.put("noUDLayersFound",true);
	}
	out.println(rootJSON);
%>
<%!
	private boolean doesExist(List searchList, String layer)
	{
		Iterator i = searchList.iterator();
		while(i.hasNext())
		{
			String nextStr = (String) i.next();
			//System.out.println("nextStr"+nextStr);
			if (layer.indexOf(nextStr)!=-1||(layer.toUpperCase().indexOf(nextStr.toUpperCase()))!=-1)
			{
				return true;
			}
		}
		return false;
	}
%>
<%	
		session.setAttribute("adminLastAccessedURL","/final/admin/EgUDLayer.jsp?"+request.getQueryString());
%>



