<%
/*
 *       Name            :       EgDuplicateLayerJson.jsp
 *       Purpose         :       For duplicating IC Layer.
 */
%>

<%@ include file="../../../admin/EgTrackerAJSON.jsp"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import="egurkha.LayerBean"%>
<%@ page import="net.sf.json.JSONObject"%>
<%@ page import="com.egurkha.admin.AuditLogThread"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json;charset=UTF-8");
%>
<%
	AuditLogThread auditLogThread = new AuditLogThread();
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",_user.getLoginID());
	auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
	auditLogThread.setValue("Session_id",session.getId());
	auditLogThread.setValue("Module","Integration Console");
	auditLogThread.setValue("Activity","Duplicate Layer");

	JSONObject rootJSON = new JSONObject();
	rootJSON.put("success","true");

	LayerBean layerBean = new LayerBean(true);
	String layer=request.getParameter("LayerName");
	String duplayer=request.getParameter("duplicate");
	if(layerBean.doesLayerExist(duplayer))
	{
		rootJSON.put("AlertType","Error");
		rootJSON.put("AlertTitle",_mapping.getTextDescription("admin.error.Add a Layer"));
		String msg = _mapping.getTextDescription("admin.error.You are trying to add a layer which already exists");
		msg += "<br>"+_mapping.getTextDescription("admin.error.Please enter a unique layer name");
		rootJSON.put("AlertMsg",msg);
		out.println(rootJSON);

		auditLogThread.setCurrentValue("Layer name","$layer$:"+duplayer);
		auditLogThread.setValue("Description","Attempt has been made to add a layer which already exists");
		auditLogThread.sendItToDB();
		return;
	}
	UpdateAndTransmitICInfo updateICInfo = new UpdateAndTransmitICInfo();	
	ArrayList testName=new ArrayList((new com.eg.EgTablesInfo("manager")).getTestsForLayer(layer));
	String test="";
	String mes="";
	IniFile ini_table = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir()+"/manager/config/eg_tables.ini",true);
	for(int i=0;i<testName.size();i++)
	{
		test=(String)testName.get(i);
		if(!updateICInfo.setTestsForLayer(duplayer,test))
			return;
		List mesName = new ArrayList(Arrays.asList((new com.eg.EgDbInfo("manager")).getMeasurementsForTest(test)));
		for(int j=0;j<mesName.size();j++)
		{
			mes=(String)mesName.get(j);
			String first=ini_table.getValue("MEASUREMENT_LAYER_TABLE",test+":"+mes);
			ini_table.setValue("MEASUREMENT_LAYER_TABLE",test+":"+mes,first+","+duplayer);
		}
	}
	ini_table.saveFile();
	EgConfigFilesSync.releaseInstance(ini_table);

	//For eg_udlayers.ini
	IniFile ini_udlayer=EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir()+"/manager/config/eg_udlayers.ini",true);
	ini_udlayer.setValue("UD_LAYERS",duplayer,duplayer);

	String[] strDupLayers = ini_udlayer.getVariables("IC_DUPLICATE_LAYERS");
	if (strDupLayers == null || strDupLayers.length == 0)
	{
			ini_udlayer.setValue("IC_DUPLICATE_LAYERS",layer,duplayer);
	}
	else
	{
		ArrayList aListDupLayers = new ArrayList(Arrays.asList(strDupLayers));
		if (aListDupLayers.contains(layer))
		{
			String str = ini_udlayer.getValue("IC_DUPLICATE_LAYERS",layer);
			if(str==null || str.length()==0)
				str=duplayer;
			else
				str = str + "," + duplayer;
			ini_udlayer.setValue("IC_DUPLICATE_LAYERS",layer,str);
		}
		else
		{
			ini_udlayer.setValue("IC_DUPLICATE_LAYERS",layer,duplayer);
		}
	}

	ini_udlayer.saveFile();
	EgConfigFilesSync.releaseInstance(ini_udlayer);

	rootJSON.put("AlertType","Result");
	rootJSON.put("AlertTitle",_mapping.getTextDescription("admin.ic.Integration Console - Layer"));
	rootJSON.put("AlertMsg",_mapping.getTextDescription("admin.ic.Layer has been added successfully"));

	auditLogThread.setCurrentValue("Layer name","$layer$:"+duplayer);
	auditLogThread.setValue("Description","Layer has been added successfully");
	auditLogThread.sendItToDB();

	out.println(rootJSON);
%>
