<%
/**
 *			Name		:	EgDelUDLayerJson.jsp
 *			Purpose		:	IC - Layer - Delete layer
 *			CreationDate	:	01/10/2001
 */
%>

<%@ include file="../../../admin/EgTrackerAJSON.jsp"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import = "egurkha.ServiceBean"%>
<%@ page import = "egurkha.LayerBean"%>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page import = "com.eg.EgConfigFilesSync"%>
<%@ page import="net.sf.json.JSONObject"%>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json;charset=UTF-8");

	JSONObject rootJSON = new JSONObject();
	rootJSON.put("success","true");

	ServiceBean serviceBean = new ServiceBean();
	String layer = request.getParameter("layer");
	/* code for auditlog starts */
	AuditLogThread auditLogThread = new AuditLogThread();
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",_user.getLoginID());
	auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
	auditLogThread.setValue("Session_id",session.getId());
	auditLogThread.setValue("Module","Integration Console");
	auditLogThread.setValue("Activity","Layer");
	/* code for auditlog ends */
	LayerBean layerBean = new LayerBean(true);
	if(!layerBean.isLayerUserDefined(layer))
	{
		rootJSON.put("AlertType","Error");
		rootJSON.put("AlertTitle",_mapping.getTextDescription("admin.error.Delete Layer"));
		rootJSON.put("AlertMsg",_mapping.getTextDescription("admin.error.You are trying to delete a layer which is not user-defined")+".");
		
		/* code for auditlog starts */
		auditLogThread.setCurrentValue("Layer Name",layer);
		auditLogThread.setValue("Description","Layer "+"$layer$:"+layer+" cannot be deleted"+"."+" Hence this is not an user defined layer");
		auditLogThread.sendItToDB();
		/* code for auditlog ends */
		
		out.println(rootJSON);
		return;
	}
//	else if(layerBean.isLayerInUse(layer))
//	{
//		rootJSON.put("AlertType","Error");
//		rootJSON.put("AlertTitle",_mapping.getTextDescription("admin.error.Delete Layer"));
//		String msg = _mapping.getTextDescription("admin.error.You are trying to delete a layer which is currently associated with one or more component types")+". ";
//		msg += _mapping.getTextDescription("admin.error.Please disassociate this layer for all components and try again")+".";
//		rootJSON.put("AlertMsg",msg);
//
//		/* code for auditlog starts */
//		if(layer.endsWith("_ex"))
//			auditLogThread.setValue("Description","Layer "+layer+" cannot be deleted"+"."+" Hence one or more components types have been managed");
//		else
//			auditLogThread.setValue("Description","Layer "+"$layer$:"+layer+" cannot be deleted"+"."+" Hence one or more components types have been managed");
//		auditLogThread.sendItToDB();
//		/* code for auditlog ends */
//
//		out.println(rootJSON);
//		return;
//	}
	else
	{
		//The following line is to ensure that the stopDiscovery & startDiscovery runs inside a sync block
		IniFile infraIni = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_infrastructure.ini");
		serviceBean.stopDiscovery();
		// The following block first dissociating the layer from all its associated servers
		EgTablesInfo tablesInfo = new EgTablesInfo("manager");
		ArrayList servers = tablesInfo.getServersForLayer(layer, true);
		ArrayList layList = new ArrayList();
		layList.add(layer);
		DeleteMailFilterElements delMailFilterElements = new DeleteMailFilterElements();
		if (servers != null)
		{
			for (int s=0; s<servers.size(); s++)
			{
				String server = servers.get(s).toString();
				ArrayList layersList = layerBean.getLayersForServer(server);
				String layers = "";
				for (int l=layersList.size()-1; l>=0; l--)
				{
					String layerStr = layersList.get(l).toString();
					if (layerStr.equals(layer))
						continue;
					layers += layerStr +",";
				}
				layerBean.updateLayersForServer(server, layers);
			}
		}
		// Now deleting the layer
		layerBean.deleteLayer(layer);
		serviceBean.startDiscovery("1");
		EgConfigFilesSync.releaseInstance(infraIni);
		UpdateAndTransmitICInfo updateICInfo = new UpdateAndTransmitICInfo();
		updateICInfo.deleteLayerFromDb(layer);		
		for (int k=0; k<servers.size(); k++)
		{
			String serverVal = servers.get(k).toString();
			delMailFilterElements.deleteLayersForSerevr(serverVal,layList);
		}
		/* code for auditlog starts */
		auditLogThread.setCurrentValue("Layer Name",layer);
		if(layer.endsWith("_ex"))
			auditLogThread.setValue("Description","Layer "+layer+" has been deleted");
		else
			auditLogThread.setValue("Description","Layer "+"$layer$:"+layer+" has been deleted");
		auditLogThread.sendItToDB();
		/* code for auditlog ends */
	
		rootJSON.put("AlertType","Result");
		rootJSON.put("AlertTitle",_mapping.getTextDescription("admin.error.Delete Layer"));
		rootJSON.put("AlertMsg",_mapping.getTextDescription("admin.ic.Layer has been deleted successfully"));

		out.println(rootJSON);
	}
%>






