<%
/*
 *       Name            :       EgUDServerJson.jsp
 *       CreationDate    :       01/10/2001
 */
%>

<%@ include file="../../../admin/EgTrackerAJSON.jsp"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%@ page import="egurkha.*" %>
<%@ page import="com.eg.EgInstallInfo"%>
<%@ page import="com.eg.EgURLEncoder"%>
<%@ page import="com.eg.EgMappingInfo"%>
<%@ page import="com.eg.EgName"%>
<%@ page import="com.eg.MappingNameSorter"%>
<%@ page import="com.eg.EgServicesInfo"%>
<%@ page import="com.eg.EgUsersInfo"%>
<%@ page import="com.egurkha.ini.IniUI"%>

<%@ page import="net.sf.json.JSONObject"%>
<%@ page import="net.sf.json.JSONArray"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json;charset=UTF-8");

	JSONObject rootJSON = new JSONObject();
	rootJSON.put("success","true");

	EgMappingInfo mapping = new EgMappingInfo(_user.getLanguage());
	String egTitleSearchStr = request.getParameter("searchStr");
	boolean isSearchResult =(egTitleSearchStr!=null && !egTitleSearchStr.equals(""));
	ArrayList searchList = new ArrayList();
	if (isSearchResult)
	{
		StringTokenizer st = new StringTokenizer(egTitleSearchStr);
		while (st.hasMoreTokens())
		{
			String thisToken = st.nextToken().trim();
			if (thisToken.equals(""))
				continue;
			searchList.add(thisToken);
		}
	}

	
	ServerBean serverBean = new ServerBean();
	Hashtable allSrvMap = serverBean.getAllServerMap();
	ArrayList pdServers = (ArrayList)allSrvMap.get("PDSERVERS");	//predefined servers
	ArrayList udServers = (ArrayList)allSrvMap.get("UDSERVERS");	//user defined servers
	
	EgUsersInfo usersInfo = new EgUsersInfo();
	if(usersInfo.isUserBasedLicense())
	{
		ArrayList userTypes = usersInfo.getAllUserBasedCompTypes();
		pdServers.removeAll(userTypes);
	}
	if(pdServers != null && pdServers.size()>0)
	{
		for(int i=pdServers.size()-1;i>=0;i--)
		{
			if(pdServers.get(i).toString().startsWith("Agg_"))
				pdServers.remove(i);
		}
	}
	if(udServers != null && udServers.size()>0)
	{
		for(int i=udServers.size()-1;i>=0;i--)
		{
			if(udServers.get(i).toString().startsWith("Agg_"))
				udServers.remove(i);
		}
	}

	EgServicesInfo servicesInfo = new EgServicesInfo("manager");
	if (!servicesInfo.isAllowExistingTypesInIC())
	{
		pdServers = new ArrayList();
	}
	ArrayList bt = EgInstallInfo.getBasicTypes();
	ArrayList minusTypes = new ArrayList();
	boolean searchItemFound = false;

	//boolean isAggregateSupported = false;
	//isAggregateSupported = EgInstallInfo.isAggregationSupported();

	for(int i=0; i<pdServers.size(); i++)
	{
		String server = (String) pdServers.get(i);
		if (isSearchResult && !doesExist(searchList, server, mapping))
		{
			minusTypes.add(server);
			continue;
		}
		
		if(server.equalsIgnoreCase("Site_servers"))
		{
			minusTypes.add(server);
			continue;
		}
		/*if(server.equalsIgnoreCase("Oracle_server"))
		{
			minusTypes.add(server);
			continue;
		}*/
		//if(!isAggregateSupported && server.startsWith("Agg_"))
		if(server.startsWith("Agg_"))
		{
			minusTypes.add(server);
			continue;
		}
		/*
		if (serverBean.isServerUserDefined(server))
		{
			udServers.add(server);
			continue;
		}
		*/
		if (bt.contains(server))
		{
			minusTypes.add(server);
			continue;
		}
	}

	for(int i=0; i<udServers.size(); i++)
	{
		boolean arrange=false;
		String server = (String) udServers.get(i);
		if (isSearchResult && !doesExist(searchList, server, mapping))
		{
			minusTypes.add(server);
			continue;
		}
	}
	pdServers.removeAll(minusTypes);
	udServers.removeAll(minusTypes);
	Collections.sort(pdServers,String.CASE_INSENSITIVE_ORDER);
	Collections.sort(udServers,String.CASE_INSENSITIVE_ORDER);
	if (servicesInfo.isAllowExistingTypesInIC())
	{
		ArrayList tmpPdServers = new ArrayList(); 
		for(int i=0; i<pdServers.size(); i++)
		{
			
			String server = (String) pdServers.get(i);
			if (isSearchResult && !doesExist(searchList, server, mapping))
			{
			continue;
			}
			searchItemFound=true;
			if(server.equalsIgnoreCase("Site_servers"))
				continue;
			//if(server.equalsIgnoreCase("Oracle_server"))
				//continue;
			/*
			if (serverBean.isServerUserDefined(server))
			{
				udServers.add(server);
				continue;
			}
			*/
			if (bt.contains(server))
				continue;
			

			String modifybut="";
	/*		boolean modifyImage=false;
			if(server.endsWith("_ex"))
			{
				modifybut="";
				modifyImage=true;
			}else
			{
				modifybut="id=input_disabled disabled";
			}
	*/
			tmpPdServers.add(server);
		}
		String userLanguage = _user.getLanguage();
		IniUI  iniUI = IniUI.getInstance();
		if (userLanguage == null)
			userLanguage = iniUI.getDefaultLanguage();
			
		MappingNameSorter sorter = new MappingNameSorter(userLanguage);
		tmpPdServers = sorter.getSortedCompTypeList(tmpPdServers);
		JSONArray pdServArr = new JSONArray();
		for(int j=0;j<tmpPdServers.size();j++)
		{
			EgName nameObj = (EgName)tmpPdServers.get(j);
			String tmpVal = nameObj.getActualName();
			String tmpDis = nameObj.getLocalName();
			//if(tmpVal.startsWith("Agg_") && !isAggregateSupported)
			if(tmpVal.startsWith("Agg_"))
			{
				continue;
			}
			JSONObject obj = new JSONObject();
			obj.put("ComponentType","<b>"+tmpDis+"</b>");
			obj.put("ActualValue",tmpVal);
			pdServArr.add(obj);
		}	
		rootJSON.put("preDefindGrid",pdServArr);
		rootJSON.put("showPreDefinedComps",true);
		if (!searchItemFound && egTitleSearchStr!=null&&!egTitleSearchStr.equals(""))
		{ 
			rootJSON.put("noPDTypesFoundForSearch",true);
			rootJSON.put("showPreDefinedComps",false);
		}
	}
	else
	{
		rootJSON.put("showPreDefinedComps",false);
	}
	if (udServers.size()>0)
	{
		searchItemFound=false;
		JSONArray udServArr = new JSONArray();
		for(int i=0; i<udServers.size(); i++)
		{
			String server = (String) udServers.get(i);
			//if(server.startsWith("Agg_") && !isAggregateSupported)
			if(server.startsWith("Agg_"))
			{
				continue;
			}
			if (isSearchResult && !doesExist(searchList, server, mapping))
			{
			continue;
			}
			searchItemFound=true;
			
			String modifybut="";
			boolean modifyImage=false;
			
			JSONObject obj = new JSONObject();
			obj.put("ComponentType","<b>"+server+"</b>");
			obj.put("ActualValue",server);
			udServArr.add(obj);
		}
		rootJSON.put("usrDefinedGrid",udServArr);
		rootJSON.put("showUserDefinedComps",true);
		if (!searchItemFound&&egTitleSearchStr!=null&&!egTitleSearchStr.equals(""))
		{
			rootJSON.put("noUDTypesFoundForSearch",true);
			rootJSON.put("showUserDefinedComps",false);
		}
	}
	else
	{
		rootJSON.put("showUserDefinedComps",false);
	}
	out.println(rootJSON);
%>

<%!
	private boolean doesExist(List searchList, String server, EgMappingInfo mapp)
	{
		Iterator i = searchList.iterator();
		server = mapp.getComponentTypeDescription(server);
		while(i.hasNext())
		{
			String nextStr = (String) i.next();
			if (server.indexOf(nextStr)!=-1||(server.toUpperCase().indexOf(nextStr.toUpperCase()))!=-1)
			{
				return true;
			}
		}
		return false;
	}
%>

<%
		session.setAttribute("adminLastAccessedURL","/final/admin/EgUDServer.jsp?"+request.getQueryString());
%>






