
<%
/*
 *       Name            :      EgConfigUDServer.jsp
 *       Purpose         :		IC - Component - Config Layer
 *       CreationDate    :      01/10/2001
 */
%>

<%@ include file="../../../admin/EgTrackerAJSON.jsp"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import = "egurkha.*" %>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import="net.sf.json.JSONObject"%>
<%@ page import="net.sf.json.JSONArray"%>


<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json;charset=UTF-8");
%>

<%
	EgServicesInfo servicesInfo = new EgServicesInfo("manager");
	String server = request.getParameter("server");
	LayerBean layerBean = new LayerBean();
	EgAggregateInfo aggregateInfo=new EgAggregateInfo("manager");
	Vector aggTypes = aggregateInfo.getAggregateTypes();
	ArrayList layers = layerBean.getLayersForServer(server);
	ArrayList allLayers = layerBean.getAllLayers();

	String userLanguage = _user.getLanguage();
	IniUI iniUI = IniUI.getInstance();
	if (userLanguage == null)
	{
		userLanguage = iniUI.getDefaultLanguage();
	}
	MappingNameSorter sorter = new MappingNameSorter(userLanguage);

	if(aggTypes!=null && aggTypes.contains(server))
	{
		allLayers = layerBean.getAllLayers(server);
	}
	if (!servicesInfo.isAllowExistingTypesInIC())
	{
		if (allLayers != null)
		{
			for (int i=allLayers.size()-1; i>=0 ;i--)
			{
				String layer = (String)allLayers.get(i);
				layer = layer.toLowerCase().trim();
				if (!layer.endsWith("_ex"))
				{
					allLayers.remove(i);
				}
			}
		}
	}

	JSONObject rootJSON = new JSONObject();
	rootJSON.put("success","true");

	JSONObject hiddens = new JSONObject();
	JSONArray assoList = new JSONArray();//associated
	JSONArray cloneAssoList = new JSONArray();
	JSONObject obj = new JSONObject();

	String layerList = "";
	for(int i=layers.size()-1; i>=0 ; i--)
	{
		String layer = (String) layers.get(i);
		layerList += layer + ",";
		obj.put("valueField",layer);
		obj.put("displayField",_mapping.getLayerDescription(layer));
		assoList.add(obj);
		cloneAssoList.add(obj);
	}

	// The following block add the comp type to associated layers' disp name those have common displayname @see layer "Outside View of VMs"
	EgTablesInfo tablesInfo = new EgTablesInfo("manager");
	for (int a=0; a<assoList.size(); a++)
	{
		JSONObject nameObj1 = (JSONObject)assoList.get(a);
		String tmpVal1 = (String)nameObj1.get("valueField");
		String tmpDis1 = (String)nameObj1.get("displayField");
		for (int b=0; b<cloneAssoList.size(); b++)
		{
			JSONObject nameObj2 = (JSONObject)cloneAssoList.get(b);
			String tmpVal2 = (String)nameObj2.get("valueField");
			String tmpDis2 = (String)nameObj2.get("displayField");
			if (tmpVal1.equalsIgnoreCase(tmpVal2))
			{
				continue;
			}
			if (tmpDis1.equalsIgnoreCase(tmpDis2))
			{
				ArrayList serverTyps = tablesInfo.getServersForLayer(tmpVal2);
				//"serverTyps" may has many comp types, so we consider the first element to differentiate
				String compTyps = _mapping.getComponentTypeDescription(serverTyps.get(0).toString());
				JSONObject nameObj3 = new JSONObject();
				nameObj3.put("valueField",tmpVal2);
				nameObj3.put("displayField",tmpDis2+" ("+compTyps+")");
				cloneAssoList.remove(b);
				cloneAssoList.add(b,nameObj3);
			}
		}
	}

	rootJSON.put("assoLayers",cloneAssoList);
	if(layerList.length() > 0)
		layerList = layerList.substring(0, layerList.length()-1);
	
	hiddens.put("layerlist",layerList);

	ArrayList disLayers = new ArrayList();
	for(int i=0; i<allLayers.size(); i++)
	{
		String layer = (String) allLayers.get(i);
		layer = layer.trim();
		if (layer.length() == 0) continue;
		if(layers.indexOf(layer) >= 0)
			continue;
		disLayers.add(layer);
	}
	disLayers = sorter.getSortedLayerList(disLayers);//dissociated
	// The following block add the comp type to dissocited layers' disp name those have common displayname @see layer "Outside View of VMs"
	ArrayList cloneDisLayers = (ArrayList)disLayers.clone();
	for (int a=0; a<disLayers.size(); a++)
	{
		EgName nameObj1 = (EgName)disLayers.get(a);
		String tmpVal1 = nameObj1.getActualName();
		String tmpDis1 = nameObj1.getLocalName();
		for (int b=0; b<cloneDisLayers.size(); b++)
		{			
			EgName nameObj2 = (EgName)disLayers.get(b);
			String tmpVal2 = nameObj2.getActualName();
			String tmpDis2 = nameObj2.getLocalName();
			if (tmpVal1.equalsIgnoreCase(tmpVal2))
			{
				continue;
			}
			if (tmpDis1.equalsIgnoreCase(tmpDis2))
			{
				ArrayList serverTyps = tablesInfo.getServersForLayer(tmpVal2);
				//"serverTyps" may has many comp types, so we consider the first element to differentiate
				String compTyps = _mapping.getComponentTypeDescription(serverTyps.get(0).toString());
				EgName nameObj3 = new EgName(tmpVal2,tmpDis2+" ("+compTyps+")");
				cloneDisLayers.remove(b);
				cloneDisLayers.add(b,nameObj3);
			}
		}
	}
	disLayers = new ArrayList(cloneDisLayers);

	JSONArray dissoList = new JSONArray();
	for (int j=0;j<disLayers.size();j++)
	{
		EgName nameObj = (EgName)disLayers.get(j);
		String tmpVal = nameObj.getActualName();
		String tmpDis = nameObj.getLocalName();
		obj.put("valueField",tmpVal);
		obj.put("displayField",tmpDis);
		dissoList.add(obj);
	}
	rootJSON.put("disoLayers",dissoList);

	hiddens.put("server",server);//fassociate, fdissociate
	rootJSON.put("hiddens",hiddens);
	rootJSON.put("serverDispValue",_mapping.getComponentTypeDescription(server));
	out.println(rootJSON);
%>



