<%
/*
 *		Name			:	Egbackupconfigp.jsp
 *		Purpose			:	Process page for EgBackupConfig.jsp
 *		CreationDate	:	01/10/2001
 */
%>

<%@ include file="../../../admin/EgTrackerAJSON.jsp"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import = "net.sf.json.JSONObject"%>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page import = "egurkha.BackupBean"%>
<%@ page import = "com.eg.EgConfigFilesSync"%>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json;charset=UTF-8");
%>

<%
	egurkha.ServiceBean serviceBean = new egurkha.ServiceBean();
	JSONObject rootJSON = new JSONObject();
	rootJSON.put("success","true");
	/* code for auditlog starts */
	AuditLogThread auditLogThread = new AuditLogThread();
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",_user.getLoginID());
	auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
	auditLogThread.setValue("Session_id",session.getId());
	auditLogThread.setValue("Module","Integration Console");
	/* code for auditlog ends */
	String type = request.getParameter("type");
	
	if(type.equals("revert"))
	{
		if(BackupBean.revert())
		{
			rootJSON.put("AlertType","Result");
			rootJSON.put("AlertTitle",_mapping.getTextDescription("admin.ic.Backup / Revert"));
			rootJSON.put("AlertMsg",_mapping.getTextDescription("admin.ic.The old configurations have been reverted back successfully")+".");
			//The following line is to ensure that the stopDiscovery & startDiscovery runs inside a sync block
			IniFile infraIni = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_infrastructure.ini");
			serviceBean.stopDiscovery();
			serviceBean.startDiscovery("1");
			EgConfigFilesSync.releaseInstance(infraIni);
			/* code for auditlog starts */
			auditLogThread.setValue("Activity","Revert configuration");
			auditLogThread.setValue("Description","Old configuration has been reverted back");
			auditLogThread.sendItToDB();
			/* code for auditlog ends */
		}
		else
		{
			rootJSON.put("AlertType","Error");
			rootJSON.put("AlertTitle",_mapping.getTextDescription("admin.ic.Backup / Revert"));
			String msg = _mapping.getTextDescription("admin.ic.Possible reasons")+"<br>";

			if(!BackupBean.dbFailed)
			{
				msg += _mapping.getTextDescription("admin.ic.Backup does not exist")+". "+_mapping.getTextDescription("admin.ic.Backup needs to be taken before reverting back settings");
				/* code for auditlog starts */
				auditLogThread.setValue("Activity","Revert configuration");
				auditLogThread.setValue("Description","Backup does not exist");
				auditLogThread.sendItToDB();
				/* code for auditlog ends */
			}
			else
			{
				msg += _mapping.getTextDescription("admin.ic.Database connection failed")+". "+_mapping.getTextDescription("admin.ic.Please check if the database is up and try again");
				/* code for auditlog starts */
				auditLogThread.setValue("Activity","Revert configuration");
				auditLogThread.setValue("Description","Database connection failed while revert backing configuration");
				auditLogThread.sendItToDB();
				/* code for auditlog ends */
			}
			rootJSON.put("AlertMsg",msg);
		}
	}
	else if(type.equals("backup"))
	{
		BackupBean.getBackup();

		rootJSON.put("AlertType","Result");
		rootJSON.put("AlertTitle",_mapping.getTextDescription("admin.ic.Backup / Revert"));
		rootJSON.put("AlertMsg",_mapping.getTextDescription("admin.ic.The current configurations have been backed up successfully")+".");
		/* code for auditlog starts */
		auditLogThread.setValue("Activity","Backup configuration");
		auditLogThread.setValue("Description","Backup has been taken for the current configurations");
		auditLogThread.sendItToDB();
		/* code for auditlog ends */
	}
	out.println(rootJSON);
%>







