<%
/*
 *   File		:	EgconfiggrouppJson.jsp
 *   Purpose	:	Processing page for groups
*/
%>
<%@ include file="../../../admin/EgTrackerAJSON.jsp" %>

<%@ page import = "java.util.*" %>
<%@ page import = "net.sf.json.*" %>

<%@ page import = "com.eg.IniFile" %>
<%@ page import = "com.eg.EgTopoInfo" %>
<%@ page import = "com.eg.EgGroupInfoAdmin" %>
<%@ page import = "com.eg.EgStateZone" %>
<%@ page import = "com.eg.EgInstallInfo" %>
<%@ page import = "com.eg.EgAggregateInfo"%>
<%@ page import = "com.eg.EgConfigFilesSync"%>
<%@ page import = "com.egurkha.util.StringUtils" %>
<%@ page import = "com.eg.DeleteMailFilterElements"%>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page import = "com.egurkha.admin.EgComponentGroup"%>
<%@ page import = "com.egurkha.monitor.EgComponentUserMappingBean"%>

<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"  autoFlush="true"%>

<jsp:useBean id = "ecumb" scope = "page" class = "com.egurkha.monitor.EgComponentUserMappingBean"/>

<%
	JSONObject rootJson = new JSONObject();
	JSONObject screenLabels = new JSONObject();

	EgGroupInfoAdmin groupinfo = new EgGroupInfoAdmin();
	EgTopoInfo topoInfo = new EgTopoInfo("manager");
	EgComponentGroup compGroup = new EgComponentGroup();


	boolean addMode = false;
	boolean modifyMode = false;
	boolean deleteMode = false;


	rootJson.put("isUpdated","true");

	/* code for auditlog starts */
	AuditLogThread auditLogThread = new AuditLogThread();	
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",_user.getLoginID());
	auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
	auditLogThread.setValue("Session_id",session.getId());
	auditLogThread.setValue("Module","Component Groups");
	/* code for auditlog ends */

	String mode = request.getParameter("mode");
	String zone = request.getParameter("zone");
	String group = request.getParameter("group");
	String deleteGroups = request.getParameter("deleteGroups");

	mode = (mode != null && mode.length() > 0 && !mode.trim().equals("")) ? mode : "add";
	zone = (zone != null && zone.length() > 0 && !zone.trim().equals("")) ? zone : "all";
	group = (group != null && group.length() > 0 && !group.trim().equals("")) ? group : "";
	deleteGroups = (deleteGroups != null && deleteGroups.length() > 0 && !deleteGroups.trim().equals("")) ? deleteGroups : "";


	if(mode.equals("add"))
	{
		addMode = true;
	}
	else if(mode.equals("modify"))
	{
		modifyMode = true;
	}
	else if(mode.equals("delete"))
	{
		deleteMode = true;
	}

	if(deleteMode)
	{
		if(!deleteGroups.equals(""))
		{
			if(deleteGroups.endsWith(","))
			{
				deleteGroups = deleteGroups.substring(0,deleteGroups.length()-1);
			}
			compGroup.deleteGroups(deleteGroups,null,null,null);

			// audit for delete groups
			auditLogThread.setValue("Activity","Delete Group(s)");
			auditLogThread.setValue("Description","Group(s) "+deleteGroups+" has been deleted");
			auditLogThread.sendItToDB();

			IniFile aggregateInfoSync = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_aggregate.ini");
			//EgAggregateInfo aggInfo = new EgAggregateInfo("manager");
			String ca_variables[] = aggregateInfoSync.getVariables("COMPONENT_ASSOCIATION");
			if(ca_variables != null)
			{
				String delGroups[] = StringUtils.getTokens(deleteGroups,",");
				ArrayList deletedGroups= new ArrayList(Arrays.asList(delGroups));
				for(int i=0;i<ca_variables.length;i++)
				{
					String ca_variable = ca_variables[i];
					String group_name = ca_variable.substring(ca_variable.lastIndexOf("#")+1);
					if(deletedGroups.contains(group_name))
					{
						aggregateInfoSync.deleteValue("COMPONENT_ASSOCIATION",ca_variable);
						aggregateInfoSync.deleteValue("ANCHOR_COMPONENT",ca_variable);
					}
				}
			}
			aggregateInfoSync.saveFile();
			EgConfigFilesSync.releaseInstance(aggregateInfoSync);

			rootJson.put("isUpdated","true");
			rootJson.put("updateUrl","EgComponentGroups.jsp");
		}
	}
	else
	{
		Vector sess_vec = new Vector();
		if(!group.equals(""))
		{
			boolean isSame = false;
			String otherhost = request.getParameter("otherhost");
			String hostList = request.getParameter("chosenHosts");
			String existingHosts = request.getParameter("existingHosts");

			hostList = (hostList != null && hostList.length() > 0 && !hostList.trim().equals("")) ? hostList : "";
			otherhost = (otherhost != null && otherhost.length() > 0 && !otherhost.trim().equals("")) ? otherhost : "";
			existingHosts = (existingHosts != null && existingHosts.length() > 0 && !existingHosts.trim().equals("")) ? existingHosts : "";

			if(hostList.endsWith(","))
				hostList = hostList.substring(0,hostList.length()-1);

			if(otherhost.endsWith(","))
				otherhost = otherhost.substring(0,otherhost.length()-1);

			if(existingHosts.endsWith(","))
				existingHosts = existingHosts.substring(0,existingHosts.length()-1);

			List currList = new ArrayList();
			List prevList = new ArrayList();

			if(!existingHosts.equals(""))
			{
				StringTokenizer st = new StringTokenizer(existingHosts,",");
				while(st.hasMoreTokens())
				{
					String p = st.nextToken().trim();
					if(!p.equals(""))
						prevList.add(p);
				}
			}

			if(!hostList.equals(""))
			{
				StringTokenizer st = new StringTokenizer(hostList,",");
				while(st.hasMoreTokens())
				{
					String x = st.nextToken().trim();
					if(!x.equals(""))
					{
						int ind = prevList.indexOf(x);
						if (ind > -1)
							prevList.remove(ind);
						else
							currList.add(x);
					}
				}
			}
			currList = new ArrayList(new HashSet(currList));
			prevList = new ArrayList(new HashSet(prevList));

			int currListSize = currList.size();
			int prevListSize = prevList.size();

			boolean error = false;
			String errorComps = "";
			String [] segments = topoInfo.getVariables("TOPOLOGY_SEGMENTS");
			if(segments != null)
			{
				for(int a = 0; a < segments.length; a++)
				{
					String [] segComps = topoInfo.getVariables(segments[a]);
					ArrayList segmentComps = new ArrayList();
					for (int b = 0; b < segComps.length; b++)
					{
						if(segComps[b].startsWith("Group:"))
						{
							if(!segComps[b].equals("Group:"+group+":NULL"))
							{
								ArrayList al = groupinfo.getAllComponentsUnderGroup(segComps[b]);
								if(al != null)
								{
									segmentComps.addAll(al);
								}
							}
							segmentComps.add(segComps[b]);
						}
						else
						{
							segmentComps.add(segComps[b]);
						}
					}
					segmentComps = new ArrayList(new HashSet(segmentComps));
					if(segmentComps.contains("Group:"+group+":NULL"))
					{
						for(int i = 0; i < currListSize; i++)
						{
							String comp = (String) currList.get(i);
							if(segmentComps.contains(comp))
							{
								error = true;
								errorComps += comp + ",";
							}
						}
					}
				}
			}

			if(errorComps.endsWith(","))
				errorComps = errorComps.substring(0,errorComps.length()-1);
			ArrayList disAssociateServers = new ArrayList(prevList);

			if(!error)
			{
				if(currListSize == prevListSize && currList.containsAll(prevList))
					isSame = true;

				if(currList.size() > 0)
				{
					String asso_Servs = "";
					Collections.sort(currList);
					for(int i = 0; i < currListSize; i++)
					{
						String value = (String) currList.get(i);
						String type = value.substring(0,value.indexOf(":"));
						String comp = value.substring(value.indexOf(":"));
						type = _mapping.getComponentTypeDescription(type);
						value = type + comp;
						if (value.endsWith(":NULL"))
						{
							int ind = value.lastIndexOf(":");
							if (ind > -1)
								value = value.substring(0,ind);
						}
						asso_Servs += "$ctype$:"+value+",";
					}
					if(asso_Servs.endsWith(","))
						asso_Servs = asso_Servs.substring(0,asso_Servs.length()-1);
					auditLogThread.setCurrentValue("Associated servers",asso_Servs);
				}

				if(prevList.size() > 0)
				{
					String disso_Servs = "";
					Collections.sort(prevList);
					for(int i = 0; i < prevListSize; i++)
					{
						String value = (String) prevList.get(i);
						String type = value.substring(0,value.indexOf(":"));
						String comp = value.substring(value.indexOf(":"));
						type = _mapping.getComponentTypeDescription(type);
						value = type + comp;
						if (value.endsWith(":NULL"))
						{
							int ind = value.lastIndexOf(":");
							if (ind > -1)
								value = value.substring(0,ind);
						}
						disso_Servs += "$ctype$:"+value+",";
					}
					if(disso_Servs.endsWith(","))
						disso_Servs = disso_Servs.substring(0,disso_Servs.length()-1);
					auditLogThread.setCurrentValue("Disassociated servers",disso_Servs);
				}

				if(addMode)
				{
					auditLogThread.setValue("Activity","Add Group");
					auditLogThread.setValue("Description","Group "+group + " has been created");
				}
				else 
				{
					auditLogThread.setValue("Activity","Modify Group");
					auditLogThread.setValue("Description","Group "+group +" has been modified");
				}
			}
			else
			{
				if(addMode)
				{
					auditLogThread.setValue("Activity","Add Group");
					auditLogThread.setValue("Description","Group "+group + " has been not created");
				}
				else
				{
					auditLogThread.setValue("Activity","Modify Group");
					auditLogThread.setValue("Description","Group "+group +" has been not modified");
				}
			}

			if(!isSame) 
				auditLogThread.sendItToDB();
			// Code for audit log ends.

			// Process for aggregate component in group
			if(!error)
			{
				if(EgInstallInfo.isAggregationSupported())
				{
					boolean changed = false;
					boolean remove_entry = false;

					EgAggregateInfo aggregateInfo = new EgAggregateInfo("manager");
					String[] variables = aggregateInfo.getVariables("COMPONENT_ASSOCIATION");
					String[] variables_uica = aggregateInfo.getVariables("UI_COMPONENT_ASSOCIATION");
					String s_components = request.getParameter("chosenHosts");

					s_components = (s_components != null && s_components.length() > 0 && !s_components.trim().equals("")) ? s_components : "";

					if(s_components.endsWith(","))
						s_components = s_components.substring(0,s_components.length() -1);


					ArrayList componentsUnderGroup = new ArrayList();
					if(s_components != null && (s_components=s_components.trim()).length()>0)
					{
						String currentList[] = StringUtils.getTokens(s_components,",");
						for(int i=0;i<currentList.length;i++)
						{
							String comp = (String) currentList[i];
							if(!comp.startsWith("Agg_"))
							{
								componentsUnderGroup.add(comp);
							}
						}
					}

					Set set = new HashSet();
					if(variables != null && variables.length > 0)
					{
						set.addAll(Arrays.asList(variables));
					}
					if(variables_uica != null && variables_uica.length > 0)
					{
						set.addAll(Arrays.asList(variables_uica));
					}

					IniFile aggregateInfoSync = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir()+"/manager/config/eg_aggregate.ini",true);
					variables = (String[])set.toArray(new String[set.size()]);

					for(int i = 0; i < variables.length; i++)
					{
						String ca = variables[i];
						if(ca.endsWith("#group#"+group) || ca.endsWith("#Group#"+group))
						{
							String aggComp = ca.substring(0,ca.indexOf("#"));
							List associatedComps = aggregateInfo.getAssociatedComponents(aggComp, true);
							if(associatedComps != null && !associatedComps.isEmpty())
							{
								remove_entry = false;
								for(int j = 0;j<associatedComps.size();j++)
								{
									String associatedComp = (String)associatedComps.get(j);
									if(componentsUnderGroup.contains(associatedComp))
									{
										remove_entry = false;
										break;
									}
									remove_entry = true;
									changed = true;
								}
								if(remove_entry)
								{
									aggregateInfoSync.deleteValue("UI_COMPONENT_ASSOCIATION",ca);
									aggregateInfoSync.deleteValue("COMPONENT_ASSOCIATION",ca);
									aggregateInfoSync.deleteValue("ANCHOR_COMPONENT",ca);
								}
							}
						}
					}
					if(changed)
					{
						//aggregateInfo.saveFile();   // Saving Aggregate
					}
					if(aggregateInfo.isAutoAssociateComponentToAnchor())
					{
						//aggregateInfo = new EgAggregateInfo("manager");
						changed = false;
						Hashtable anchorHt = aggregateInfo.getAnchorComponentsOfElement("group",group);//ht from associated components of anchor components created from selected group
						if(anchorHt != null && !anchorHt.isEmpty())
						{
							Hashtable zht = new Hashtable();//ht from components of selected group
							Iterator itr = componentsUnderGroup.iterator();
							while(itr.hasNext())
							{
								String s = (String)itr.next();
								String type = "Agg_"+s.substring(0,s.indexOf(":"));
								if(zht.containsKey(type))
								{
									ArrayList alist = (ArrayList)zht.get(type);
									alist.add(s);
								}
								else
								{
									ArrayList alist = new ArrayList();
									alist.add(s);
									zht.put(type,alist);
								}
							}
							itr = anchorHt.keySet().iterator();
							while(itr.hasNext())
							{
								String s = (String)itr.next();
								List comps_in_anchor = (List)anchorHt.get(s);
								String type = s.substring(0,s.indexOf(":"));
								ArrayList comps_in_group = (ArrayList)zht.get(type);
								if(comps_in_group.size() > comps_in_anchor.size())
								{
									//if selected group has component, but anchor has not, add this into [AGGREGATE_COMPONENTS]
									comps_in_group.removeAll(comps_in_anchor);
									for(int i=0;i<comps_in_group.size();i++)
									{
										changed = true;
										aggregateInfoSync.setValue("AGGREGATE_COMPONENTS",s+"#"+(String)comps_in_group.get(i),"associated");
									}
								}
								else if(comps_in_group.size() < comps_in_anchor.size())
								{
									//if selected group does not have component, but anchor coponent does, remove this from [AGGREGATE_COMPONENTS]
									comps_in_anchor.removeAll(comps_in_group);
									for(int i=0;i<comps_in_anchor.size();i++)
									{
										changed = true;
										aggregateInfoSync.deleteValue("AGGREGATE_COMPONENTS",s+"#"+(String)comps_in_anchor.get(i));
									}
								}
							}
							if(changed)
							{
								//aggregateInfo.saveFile();
							}
						}
					}
					aggregateInfoSync.saveFile();
					EgConfigFilesSync.releaseInstance(aggregateInfoSync);
				}

				// Process of writing components in groups.ini
				if(currListSize > 0)
				{
					boolean changed = false;

					IniFile grpIni = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_group.ini", true);
					IniFile topoIni = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_topology.ini", true);

					String[] grpDetails = grpIni.getVariables("GROUP_DETAILS");
					if(grpDetails != null && grpDetails.length > 0)
					{
						for(int i = 0; i < grpDetails.length; i++)
						{
							String groupName = grpIni.getValue("GROUP_DETAILS", grpDetails[i]);
							if(groupName != null && groupName.equals(group))
							{
								grpIni.deleteValue("GROUP_DETAILS", (String)grpDetails[i]);
							}
						}
					}
					for(int i = 0; i < currListSize; i++)
					{
						changed = true;
						String cmp = (String) currList.get(i);
						cmp = cmp + "#" + group;
						grpIni.setValue("GROUP_DETAILS",cmp,group);
					}
					grpIni.setValue("LIST_OF_GROUPS", group, group);

					if(changed)
						topoIni.setValue("TOPOINI_UPDATE","update","true");

					grpIni.saveFile();
					EgConfigFilesSync.releaseInstance(grpIni);
					topoIni.saveFile();
					EgConfigFilesSync.releaseInstance(topoIni);
				}
				if(disAssociateServers != null && disAssociateServers.size() > 0)
				{
					DeleteMailFilterElements delMailFilterElements = new DeleteMailFilterElements();
					delMailFilterElements.removeElementsFromMailFilter(null,disAssociateServers);
				}

				sess_vec.removeAllElements();
				sess_vec.addElement(_mapping.getTextDescription("admin.group.Add/Modify Group"));
				sess_vec.addElement("EgDispGroups.jsp");
				sess_vec.addElement(_mapping.getTextDescription("admin.group.Add/Modify Group"));
				sess_vec.addElement(_mapping.getTextDescription("admin.group.Group has been added/modified successfully")+".");
				session.putValue("vec_Results",sess_vec);

				session.setAttribute("groupMessage", "Group '"+group+ "' has been updated");
				EgStateZone.updateZoneGroupStatus();

				String uiFile = "eg_ui.ini";
				String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
				IniFile egUISave = new IniFile(s_iniFile_dir + uiFile);
				String showUsers = egUISave.getValue("ALARM_HISTORY","Show_Users");
				String curr_date=null;
				if(showUsers!=null && (showUsers.equalsIgnoreCase("true") || showUsers.equalsIgnoreCase("yes")))
				{
					curr_date=String.valueOf(new java.util.Date());
					if(ecumb.hashLastComponentUserUpdated!=null && ecumb.hashLastComponentUserUpdated.size()>0)
					{
						ecumb.hashLastComponentUserUpdated.put("Updated",(String)curr_date);
					}
					else
					{
						ecumb.hashLastComponentUserUpdated=new Hashtable();
						ecumb.hashLastComponentUserUpdated.put("Updated",(String)curr_date);
					}
				}
				rootJson.put("isUpdated","true");
				rootJson.put("updateUrl","EgComponentGroups.jsp");
			}
			if(error)
			{
				rootJson.put("error","true");
				rootJson.put("isUpdated","false");
			}
		}
	}
	rootJson.put("success","true");
	rootJson.put("screenLabels",screenLabels);
	out.println(rootJson.toString());




%>




