<%
/*******************************************************************************
*	Name            :       EgDispGroupsJSON.jsp
*	Purpose         :       Display Groups
*	Design Changes	:		Jaiwin

					:  All,none : Delete links has been changed
						Vijay 9/7/2007
*******************************************************************************/
%>
<%@ include file="../../../admin/EgTrackerAJSON.jsp" %>
<%@ page import = "com.eg.EgGroupInfoAdmin"%>
<%@ page import = "com.eg.EgURLEncoder"%>
<%@ page import = "com.eg.EgDiscInfo"%>

<%@ page import="net.sf.json.*"%>

<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>

<%
    	JSONObject rootJson = new JSONObject();
	JSONObject screenLabels = new JSONObject();

	JSONArray groupArr = new JSONArray();
	JSONObject groupObj = new JSONObject();
	
	JSONArray serviceArr = new JSONArray();
	JSONObject serviceObj = new JSONObject();
	JSONArray segmentArr = new JSONArray();
	JSONObject segmentObj = new JSONObject();
	JSONArray zoneArr = new JSONArray();
	JSONObject zoneObj = new JSONObject();

	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	
	EgDiscInfo egDisc = new EgDiscInfo("manager");
	EgTopoInfo topoinfo = new EgTopoInfo("manager");	//removal of physical topology
	EgGroupInfoAdmin groupinfo = new EgGroupInfoAdmin();
	String strVarArr[] = groupinfo.getGroupNames();
	if (strVarArr==null)
		strVarArr=new String[0];
	session.setAttribute("existing_names",strVarArr);
	String egTitleSearchStr = request.getParameter("egTitleSearchStr");
	boolean isSearchResult =egTitleSearchStr!=null&&!egTitleSearchStr.equals("");
	ArrayList searchList = new ArrayList();
	if (isSearchResult)
	{
		StringTokenizer st = new StringTokenizer(egTitleSearchStr);
		while (st.hasMoreTokens())
		{
			String thisToken = st.nextToken().trim();
			if (thisToken.equals(""))
				continue;
			searchList.add(thisToken);
		}
	}

	session.setAttribute("egBackComplete","/final/admin/EgComponentGroups.jsp");
	session.setAttribute("egTitlehref", "/final/admin/EgComponentGroups.jsp");
	session.setAttribute("egPageDesc","EgDispGroups.jsp");

	String lastvalue="";
	String tdname="form_border";
	Vector searchVec=new Vector();
	if(strVarArr.length > 0)
	{
		boolean searchItemFound = false;
		boolean showtd=false;
		String thisGroup="";
		for(int i=0;i<strVarArr.length;i++)
		{
			thisGroup = strVarArr[i];
			//out.println(isSearchResult);
			if (isSearchResult && !doesExist(searchList, thisGroup))
			{
				continue;
			}
			else
			{
				searchVec.add(thisGroup);
			}
			searchItemFound=true;
		}
		int x=searchVec.size();
		if(x!=0)
		{
			lastvalue=(String)searchVec.get(x-1);
		}
		if(searchVec.size()!=0)
		{

		screenLabels.put("SelectAll",_mapping.getTextDescription("admin.common.Select all"));
		screenLabels.put("DeSelectAll",_mapping.getTextDescription("admin.common.Deselect all"));
		screenLabels.put("DeleteSelected",_mapping.getTextDescription("admin.common.Delete selected"));
		}

		List resultList = new ArrayList();
		for(int i=0;i<strVarArr.length;i++)
		{
			thisGroup = strVarArr[i];
			if (isSearchResult && !doesExist(searchList, thisGroup))
				continue;
			resultList.add(thisGroup);
		}
		Collections.sort(resultList,String.CASE_INSENSITIVE_ORDER);
		for(int i=0;i<resultList.size();i++)
		{
			//boolean border = (i+1)<strVarArr.length;
			thisGroup = (String) resultList.get(i);
			if (isSearchResult && !doesExist(searchList, thisGroup))
				continue;

			String thiszone = groupinfo.getZoneNameForComponent("Group:"+thisGroup+":NULL");
			if (thiszone==null)
				thiszone="-1";

			searchItemFound=true;
			String relSegment = groupinfo.getSegmentNameForGroup(thisGroup);
			Iterator serviceIter = groupinfo.getServicesForGroup(thisGroup);
			boolean serRelated = serviceIter.hasNext();
			boolean segRelated = (relSegment!=null && !relSegment.equals(""));
			boolean isDisabled = serRelated || segRelated;
			String disabledStr = isDisabled?"DISABLED":"";

			//relSegment = relSegment+", segment_1, segment_2, segment_3, segment_4, segment_5, segment_6, segment_7, segment_8, segment_9, segment_10, segment_11, segment_12, segment_13, segment_14, segment_1, segment_2, segment_3, segment_4, segment_5, segment_6, segment_7, segment_8, segment_9, segment_10, segment_11, segment_12, segment_13, segment_14";
			

			boolean zone_associated = false;
			if(thiszone != null && !thiszone.equals("-1"))
			{
				zone_associated = true;
			}
			rootJson.put("zoneAssociated",zone_associated);
			rootJson.put("isDisabled",isDisabled);
			String modifyUrl = "EgConfigGroup.jsp?qctr=0&group="+EgURLEncoder.encode(thisGroup,"UTF-8");
			//rootJson.put("modifyUrl",modifyUrl);
			
			//String thisGroupBold = "<b>"+thisGroup+"</b>";
			groupObj.put("Groupname",thisGroup);
			//groupArr.add(groupObj);

			//groupObj.put("modifyUrl",modifyUrl);
			//groupObj.put("zone_associated",zone_associated);
			//groupObj.put("isDisabled",isDisabled);
			//groupObj.put("segRelated",segRelated);
			screenLabels.put("deleteConfirmMessage",_mapping.getTextDescription("admin.group.Are you sure you want to delete '"+thisGroup+"' group? This change is permanent and this cannot be recovered")+'.');
			
			String tmpStr = "<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" width=\"100%\" align=\"center\">";
			if(isDisabled || zone_associated)
			{
				//tmpStr=tmpStr+"<tr height='6'></tr><tr><td width='100%' align='left' nowrap style='font-size:8pt;font-weight:normal;'><i>This group is associated with the following</i></td></tr><tr height='5'></tr>";
			}
			else
			{
				//tmpStr=tmpStr+"<tr height='6'></tr><tr><td width='100%' align='left' nowrap style='font-size:8pt;font-weight:normal;'><i>This group is not associated with any zone/service/segment</i></td></tr><tr height='5'></tr>";
				tmpStr=tmpStr+" - ";
			}
			if (isDisabled || zone_associated)
			{
				groupObj.put("isDisabled","true");
				boolean segm=false;
				boolean zone=false;
				if(serviceIter.hasNext())
				{
					segm=true;
					zone=true;
					
					tmpStr = tmpStr + "<tr><td style='font-size:8pt;font-weight:normal;vertical-align:middle' width=55><i>Service</i>";
					tmpStr = tmpStr+"</td><td width='5' class='eg_subcontent'>:</td><td><table cellpadding='0'><tr>";
					int cc=0;
					while (serviceIter.hasNext())
					{
						String thisSrv = (String) serviceIter.next();
						String sitezone = groupinfo.getZoneNameForService(thisSrv);
						sitezone = (sitezone==null)?"-1":sitezone;
						if(cc!=0)
						{
							tmpStr = tmpStr +"<td class='eg_subcontent'>,</td>";
						}
						ArrayList seg = topoinfo.getSegmentsForSite(thisSrv,true);
						if(segRelated)
						{
							StringTokenizer st = new StringTokenizer(relSegment,",");
							
							while(st.hasMoreTokens())
							{
								String segtok = st.nextToken();
								if(seg.contains(segtok))
								{
									tmpStr = tmpStr +"<td><a class='eg_monlink' href=\"/final/admin/EgComponentServices.jsp?site="+EgURLEncoder.encode(thisSrv,"UTF-8")+"&zone="+sitezone+"&modify=true&comefrom=dispGroups&returnToMain=true&segment="+EgURLEncoder.encode(segtok,"UTF-8")+"&mainUrl=EgComponentGroups.jsp\" id='mouse' style='font-weight:normal;text-decoration:none;vertical-align:middle'>&nbsp;"+thisSrv+"</a></td>";
									cc++;
								}
								
							}
						}
						else
						{
							tmpStr = tmpStr +"<td><a class='eg_monlink' href=\"/final/admin/EgComponentServices.jsp?site="+EgURLEncoder.encode(thisSrv,"UTF-8")+"&zone="+sitezone+"&modify=true&comefrom=dispGroups&returnToMain=true&segment=Independent_servers&mainUrl=EgComponentGroups.jsp\" id='mouse' style='font-weight:normal;text-decoration:none;vertical-align:middle'>&nbsp;"+thisSrv+"</a></td>";
							cc++;		
						}
					}
					tmpStr=tmpStr+"</tr></table>";
					tmpStr = tmpStr + "</td></tr><tr height='5'></tr>";
					//tmpStr = tmpStr + "<tr><td>&nbsp;</td></tr>";
				}
				if(segRelated)
				{
					zone=true;
					tmpStr = tmpStr + "<tr><td style='font-size:8pt;font-weight:normal;vertical-align:middle' width=55>";
					if(relSegment.indexOf(",")>-1)
						tmpStr = tmpStr +"<i>Segments</i>";
					else
						tmpStr = tmpStr +"<i>Segment</i>";

					tmpStr = tmpStr+"</td><td width='5' class='eg_subcontent'>:</td><td><table cellpadding='0'><tr>";
					StringTokenizer stt = new StringTokenizer(relSegment,",");
					int cc=0;
					int tokCount = stt.countTokens();
					while(stt.hasMoreTokens())
					{
						String sToken = stt.nextToken();
						String segZone = groupinfo.getZoneNameForComponent("Segment:"+sToken+":NULL");
						if (segZone==null)
							segZone="-1";
						
						tmpStr=tmpStr+"<td><a class='eg_monlink' href=\"/final/admin/EgComponentSegments.jsp?qctr=0&segment="+EgURLEncoder.encode(sToken,"UTF-8")+"&zone="+segZone+"&comeFrom=dispGroups&mode=modify&returnToMain=true&mainUrl=EgComponentGroups.jsp\" id='mouse' style='font-weight:normal;text-decoration:none;vertical-align:middle'>&nbsp;"+sToken+"</a></td>";
						if(cc!=(tokCount-1))
						{
							tmpStr = tmpStr +"<td class='eg_subcontent'>,</td>";
						}
						cc = cc+1;
					}
					tmpStr=tmpStr+"</tr></table>";
					tmpStr=tmpStr+"</td></tr><tr height='5'></tr>";
					//tmpStr = tmpStr + "<tr><td>&nbsp;</td></tr>";
				}

				if(zone_associated)
				{
					//thiszone = thiszone+", zone_3,  zone_4, zzone_5, zone_6, zone_7, zone_8, zone_9, zone-10, zone_11, zone_12, zone_13, zone_14, zone_15, zone_16, zone_3,  zone_4, zzone_5, zone_6, zone_7, zone_8, zone_9, zone-10, zone_11, zone_12, zone_13, zone_14, zone_15, zone_16";

					tmpStr = tmpStr + "<tr><td style='font-size:8pt;font-weight:normal;vertical-align:middle' width=55><i>Zone</i>";
					tmpStr = tmpStr+"</td><td width='5' class='eg_subcontent'>:</td><td>";
					tmpStr = tmpStr+"<a class='eg_monlink' href=\"/final/admin/EgComponentZones.jsp?zone="+EgURLEncoder.encode(thiszone,"UTF-8")+"&comefrom=dispGroups&mode=modify&returnToMain=true&mainUrl=EgComponentGroups.jsp\" id='mouse' style='font-weight:normal;text-decoration:none;vertical-align:middle'>&nbsp;"+thiszone+"</a></td></tr><tr height='5'></tr>";
					//tmpStr = tmpStr + "<tr><td>&nbsp;</td></tr>";
				}
			}
			else
			{
				groupObj.put("isDisabled","false");
			}
			tmpStr = tmpStr + "</tr></table>";
			groupObj.put("associations",tmpStr);
			
			groupArr.add(groupObj);
			String renameUrl = "rename.jsp?from=group&old_name="+EgURLEncoder.encode(thisGroup,"UTF-8");
		}
		if (!searchItemFound&&egTitleSearchStr!=null&&!egTitleSearchStr.equals(""))
		{
			screenLabels.put("searchResult",_mapping.getTextDescription("admin.group.No groups found for your search")+".");
			screenLabels.put("searchKey",egTitleSearchStr);
		}
		rootJson.put("NoExtFound","false");
	}
	else
	{
		screenLabels.put("noGroup",_mapping.getTextDescription("admin.group.There are no groups available currently"));		
		rootJson.put("NoExtFound","true");
	}

	String disableAddGrp = "false";
	String[] ComponentsType = egDisc.getServerTypes();
	List allMgrComps = new ArrayList();
	if(ComponentsType != null && ComponentsType.length > 0)
	{
		for(int z = 0; z < ComponentsType.length; z++)
		{
			String[] s_arr = egDisc.getAllServersOfType(ComponentsType[z]);

			if(s_arr.length > 0)
			{
				for (int count=0; count < s_arr.length; count++)
				{
					allMgrComps.add(s_arr[count].toString());
				}
			}
		}
	}

	if(allMgrComps.size() > 0)
	{
		List allGrpComps = Arrays.asList(groupinfo.getAllComponentsFromGroups());
		if(allGrpComps.containsAll(allMgrComps))
			disableAddGrp = "true";
	}
	else
	{
		disableAddGrp = "true";
	}
	rootJson.put("disableAddGrp",disableAddGrp);

%>
					
<%!
	private boolean doesExist(List searchList, String thisGroup)
	{
		Iterator i = searchList.iterator();
		while(i.hasNext())
		{
			String nextStr = (String) i.next();
			if (thisGroup.indexOf(nextStr)!=-1||(thisGroup.toUpperCase().indexOf(nextStr.toUpperCase()))!=-1)
				return true;
		}
		return false;
	}
%>
<%
	if(request.getQueryString()!=null)
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/EgComponentGroups.jsp?"+request.getQueryString());
	}
	else
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/EgComponentGroups.jsp");
	}

	screenLabels.put("deleteforSelectedMessage",_mapping.getTextDescription("admin.group.Are you sure you want to delete the selected group(s)?"));
	screenLabels.put("no group selected",_mapping.getTextDescription("admin.group.No group(s) have been selected"));
	screenLabels.put("deleteiconMsg1",_mapping.getTextDescription("admin.group.Are you sure you want to delete "));
	screenLabels.put("deleteiconMsg2",_mapping.getTextDescription("admin.group.group?"));
	
	// Rename labels
	screenLabels.put("sameName",_mapping.getTextDescription("admin.group.Group names are identical")+". "+_mapping.getTextDescription("admin.group.Please use a different name"));
	screenLabels.put("admin.common.space not allowed",_mapping.getTextDescription("admin.common.Space is not allowed"));
	screenLabels.put("admin.common.special characters not allowed",_mapping.getTextDescription("admin.common.Special characters are not allowed"));
	screenLabels.put("admin.common.field value cannot be blank",_mapping.getTextDescription("admin.common.Field value cannot be blank"));
	screenLabels.put("admin.common.DBL not allowed",_mapping.getTextDescription("admin.common.Group name is not allowed in DBL(Chinese,Korean,Japanese),since manager is SingleByte"));

	rootJson.put("isDouble",EgDbInfo.doubleByteEnabled);
	rootJson.put("screenLabels",screenLabels);
	rootJson.put("gridValues",groupArr);
	out.println(rootJson.toString());
%>