<%
/*
 *   File		:	EgConfigGroupsJson.jsp
 *   Purpose	:	Load the components into itemselector by the result of combinations of zones selected
*/
%>
<%@ include file = "../../../admin/EgTrackerAJSON.jsp" %>

<%@ page import = "java.util.*"%>
<%@ page import = "net.sf.json.*"%>

<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.eg.EgDiscInfo"%>
<%@ page import = "com.eg.EgGroupInfoAdmin"%>
<%@ page import = "com.eg.EgTopoInfo" %>
<%@ page import = "com.eg.EgInstallInfo"%>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import = "com.eg.EgAggregateInfo"%>
<%@ page import = "com.eg.MappingNameSorter"%>

<%@ page language = "java" contentType = "text/html; charset=UTF-8" pageEncoding = "UTF-8" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>
<%
	JSONObject rootJson = new JSONObject();
	JSONObject screenLabels = new JSONObject();

	EgGroupInfoAdmin grpInfo = new EgGroupInfoAdmin();
	EgDiscInfo egDisc = new EgDiscInfo("manager");
	EgTopoInfo topoInfo = new EgTopoInfo("manager");
	EgAggregateInfo egAgg = new EgAggregateInfo("manager");

	IniFile grpIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_group.ini");

	String[] s_arr = null;
	String[] zoneComps = grpIni.getVariables("ZONE_DETAILS");
	String[] groupComps = grpIni.getVariables("GROUP_DETAILS");
	String[] listOfGrps = grpIni.getVariables("LIST_OF_GROUPS");
	String[] listOfZones = grpIni.getVariables("LIST_OF_ZONES");

	boolean hasAll = false;
	boolean hasZone = false;
	boolean addMode = false;
	boolean isValidate = false;
	boolean hasDefault = false;

	boolean isDouble=EgDbInfo.doubleByteEnabled;

	List zoneList = new ArrayList();
	List zoneInComp =  new ArrayList();
	List managedHosts = new ArrayList();
	ArrayList zonesWithComps = new ArrayList();
	List zoneCompsList = Arrays.asList(zoneComps);
	List groupCompsList = Arrays.asList(groupComps);
	List groupsNameList = Arrays.asList(listOfGrps);
	ArrayList zoneNamesList = new ArrayList(Arrays.asList(listOfZones));

	String mode = request.getParameter("mode");
	String zone = request.getParameter("zone");
	String group = request.getParameter("group");
	String action = request.getParameter("action");
	String validate = request.getParameter("validate");
	String compType = request.getParameter("comptype");

	mode = (mode != null && mode.length() > 0 && !mode.trim().equals(""))? mode : "add"; 
	zone = (zone != null && zone.length() > 0 && !zone.trim().equals("")) ? zone : "all";
	group = (group != null && group.length() > 0 && !group.trim().equals("")) ? group : "";
	action = (action != null && action.length() > 0 && !action.trim().equals("")) ? action : "";
	validate = (validate != null && validate.length() > 0 && !validate.trim().equals("")) ? validate : "false";
	compType = (compType != null && compType.length() > 0 && !compType.trim().equals("")) ? compType : "-1";

	if(mode.equals("add"))
	{
		addMode = true;
	}

	StringTokenizer stq = new StringTokenizer(zone,",");
	while(stq.hasMoreTokens())
	{
		String zon = stq.nextToken();
		if(zon.equals("all"))
		{
			hasAll = true;
		}
		else if(zon.equals("-1"))
		{
			hasDefault = true;
		}
		else if(!zoneList.contains(zon))
		{
			hasZone = true;
			zoneList.add(zon);
		}
	}

	if(validate.equals("true"))
	{
		if(!group.equals(""))
		{
			isValidate = true;
		}
	}

	// Group name combo 
	JSONArray grpComboArray = new JSONArray();
	if(!addMode)
	{
		JSONObject jsonObj = new JSONObject();
		String[] grpNames = grpInfo.getGroupNames();
		if(grpNames != null)
		{
			for(int i = 0; i < grpNames.length; i++)
			{
				jsonObj.put("displayField",grpNames[i]);
				jsonObj.put("valueField",grpNames[i]);
				grpComboArray.add(jsonObj);
			}
		}
	}
	rootJson.put("ExistingGroupNames",grpComboArray);

	// Validate group name
	if(addMode && isValidate)
	{
		if(IniUI.isEgReservedKeyword(group) || group.toLowerCase().equals("all"))
		{
			
			screenLabels.put("isValid","false");
			screenLabels.put("admin.common.ErroInAddingGroup","'"+group +"' "+_mapping.getTextDescription("admin.error.is an eG defined keyword")+"."+_mapping.getTextDescription("admin.error.Choose another name"));
		}
		if(groupsNameList.contains(group))  // group name already exist
		{
			screenLabels.put("isValid","false");
			screenLabels.put("admin.common.ErroInAddingGroup","'"+group +"'"+" "+_mapping.getTextDescription("admin.error.already exists")+"."+_mapping.getTextDescription("admin.error.Choose another name."));
		}
	}

	// Aggregate components
//	String aggCompArr[]=null;
//	Vector aggComp = egAgg.getAggregateTypes();
//	Vector aggCompFilter = new Vector();
//	if(aggComp != null && aggComp.size() > 0)
//	{
//		for(int i = 0; i < aggComp.size(); i++)
//		{
//			String aggType = (String)aggComp.get(i);
//			aggCompArr = egDisc.getAllServersOfType(aggType);
//			for(int j = 0; j < aggCompArr.length; j++)
//			{
//				aggCompFilter.add(aggCompArr[j]);
//			}
//		}
//	}

	List otherHosts = grpInfo.getManagerIndependentComps();

	// Get all comps under group, and remove for default
	for(int a = 0; a < groupComps.length; a++)
	{
		String data = groupComps[a];
		String comp = data.substring(0,data.lastIndexOf("#"));
		String grp = data.substring(data.lastIndexOf("#")+1);
		if(grp != null && grp.trim().length() > 0)
		{
			if(grp.equals(group))
			{
				managedHosts.add(comp);
			}
		}
	}

//	String [] segments = topoInfo.getVariables("TOPOLOGY_SEGMENTS");
//	if(segments != null)
//	{
//		for(int a = 0; a < segments.length; a++)
//		{
//			String [] segComps = topoInfo.getVariables(segments[a]);
//			ArrayList segmentComps = new ArrayList();
//			for (int b = 0; b < segComps.length; b++)
//			{
//				if(!segmentComps.contains(segComps[b]))
//					segmentComps.add(segComps[b]);
//			}
//		}
//	}

	// Get all hosts under zones, and remove for default
	if (zoneComps!=null)
	{
		for (int i=0; i<zoneComps.length; i++)
		{
			String thisComp = zoneComps[i];
			if(thisComp.startsWith("Zone:") || thisComp.startsWith("Segment:") || thisComp.startsWith("Service:") || thisComp.startsWith("Group:"))
				continue;
			String comp = thisComp.substring(0, thisComp.lastIndexOf("#"));
			String zoneName = thisComp.substring(thisComp.lastIndexOf("#")+1);

			if(!zonesWithComps.contains(zoneName))
				zonesWithComps.add(zoneName);

			if(hasAll)
			{
				if(!zoneInComp.contains(comp))
					zoneInComp.add(comp);
			}
			else
			{
				if(hasZone)
				{
					if(zoneList.contains(zoneName))
					{
						if(!zoneInComp.contains(comp))
							zoneInComp.add(comp);
					}
				}
			}
			otherHosts.remove(comp);
		}
//		zoneInComp.removeAll(allSegComps);
	}
//	otherHosts.removeAll(allSegComps);

	zoneNamesList.retainAll(zonesWithComps);

	Collections.sort(zoneNamesList,String.CASE_INSENSITIVE_ORDER);

	JSONArray zoneComboArray = new JSONArray();
	JSONObject json = new JSONObject();

	if(!(otherHosts.size() > 0 && zoneNamesList.size() == 0))
	{
		json.put("displayField","--All--");
		json.put("valueField","all");
		zoneComboArray.add(json);
	}

	if(otherHosts.size() > 0)
	{
		json.put("displayField","--Default--");
		json.put("valueField","-1");
		zoneComboArray.add(json);
	}

	for(int i = 0; i < zoneNamesList.size(); i++)
	{
		String zoneName = (String) zoneNamesList.get(i);
		json.put("displayField",zoneName);
		json.put("valueField",zoneName);
		zoneComboArray.add(json);
	}
	rootJson.put("ExistingZoneNames",zoneComboArray);

	String userLanguage = _user.getLanguage();
	IniUI iniUI = IniUI.getInstance();
	if (userLanguage == null)
		userLanguage = iniUI.getDefaultLanguage();
	com.eg.MappingNameSorter sorter = new com.eg.MappingNameSorter(userLanguage);

	if(hasAll)
	{
		otherHosts.addAll(zoneInComp);
//		if(action != null && action.equals("combo"))
//			managedHosts.clear();
	}
	else
	{
		if(!hasDefault && hasZone)
		{
			otherHosts.clear();
			otherHosts.addAll(zoneInComp);
//			if(action != null && action.equals("combo"))
//				managedHosts.clear();
		}
		else if(hasDefault && hasZone)
		{
			otherHosts.addAll(zoneInComp);
//			if(action != null && action.equals("combo"))
//				managedHosts.clear();
		}
	}
	otherHosts.removeAll(managedHosts);
	otherHosts = sorter.getSortedCompTypesWithNick(otherHosts);
	managedHosts = sorter.getSortedCompTypesWithNick(managedHosts);

	// Data for ItemSelector
	JSONArray commonHosts = new JSONArray();
	JSONArray ctArray = new JSONArray();
	JSONArray managedHostsArr = new JSONArray();
	JSONArray otherHostsArr = new JSONArray();
	JSONObject commonObject = new JSONObject();
	JSONObject ctObject = new JSONObject();

	String otherhost="";
	String existingHosts = "";

	// Hosts associated with this group
	StringBuffer sb = new StringBuffer();
	for(int x=0;x < managedHosts.size();x++)
	{
		String hostCompdis = (String)managedHosts.get(x);
		String hostCompTypedis="";
		String hostCompNamedis="";
		existingHosts += hostCompdis+",";
		if(hostCompdis.indexOf(':')!=-1)
		{
			int z=hostCompdis.indexOf(':');
			hostCompTypedis=hostCompdis.substring(0,z);
			hostCompNamedis=hostCompdis.substring(z);
			if (hostCompNamedis.endsWith(":NULL"))
				hostCompNamedis=hostCompNamedis.substring(0, hostCompNamedis.lastIndexOf(":"));
			sb.append(hostCompTypedis+":"+hostCompNamedis);
			if ((x+1) < managedHosts.size())
				sb.append(",");
		}
		managedHostsArr.add((String)managedHosts.get(x));
		hostCompTypedis = _mapping.getComponentTypeDescription(hostCompTypedis);
		String displayVal = hostCompTypedis+hostCompNamedis;

		commonObject.put("displayField",displayVal);
		commonObject.put("valueField",(String)managedHosts.get(x));
		commonHosts.add(commonObject);

	}

	ArrayList type = new ArrayList();
	ctObject.put("displayField","Choose one");
	ctObject.put("valueField","-1");
	ctArray.add(ctObject);

	// Hosts not associated with this group
	for(int x=0;x < otherHosts.size();x++)
	{
		String hostComp=(String)otherHosts.get(x);
		otherhost += hostComp+",";
//		if(aggCompFilter.contains(hostComp))
//			continue;
		String hostCompType="";
		String hostCompName="";
		if(hostComp.indexOf(':')!=-1)
		{
			int z=hostComp.indexOf(':');
			hostCompType=hostComp.substring(0,z);
			hostCompName=hostComp.substring(z);
			if (hostCompName.endsWith(":NULL"))
				hostCompName=hostCompName.substring(0, hostCompName.lastIndexOf(":"));
		}
		otherHostsArr.add(otherHosts.get(x));
		hostCompType = _mapping.getComponentTypeDescription(hostCompType);
		String displayVal = hostCompType+hostCompName;

		if(compType.equals(hostCompType))
		{
			commonObject.put("displayField",displayVal);
			commonObject.put("valueField",otherHosts.get(x));
			commonHosts.add(commonObject);
		}

		if(!type.contains(hostCompType))
		{
//			ctObject.put("displayField",hostCompType);
//			ctObject.put("valueField",hostCompType);
//			ctArray.add(ctObject);
			type.add(hostCompType);
		}
	}

	if(type != null && type.size() > 0)
	{
		Collections.sort(type,String.CASE_INSENSITIVE_ORDER);
		for(int i = 0; i < type.size(); i++)
		{
			ctObject.put("displayField",(String)type.get(i));
			ctObject.put("valueField",(String)type.get(i));
			ctArray.add(ctObject);
		}
	}

	if(otherhost != null && otherhost.length()>0 && otherhost.indexOf(",") !=-1)
	{
		otherhost = otherhost.substring(0,otherhost.lastIndexOf(","));
	}
	rootJson.put("notExistingHosts",otherhost);

	if(existingHosts != null && existingHosts.length()>0 && existingHosts.indexOf(",") !=-1)
	{
		existingHosts = existingHosts.substring(0,existingHosts.lastIndexOf(","));
	}
	rootJson.put("existingHosts",existingHosts);

	if(addMode)
	{
		screenLabels.put("admin.common.buttonText",_mapping.getTextDescription("admin.common.Add"));
	}
	else
	{
		screenLabels.put("admin.common.buttonText",_mapping.getTextDescription("admin.common.Update"));
	}

	//Alert message for Validations
	screenLabels.put("admin.common.Please enter a name",_mapping.getTextDescription("admin.common.Please enter a group name"));
	screenLabels.put("admin.common.Please select a component",_mapping.getTextDescription("admin.common.Please select component type"));
	screenLabels.put("admin.common.Please associate atleast one component to a group",_mapping.getTextDescription("admin.common.Please associate atleast one component to a group"));
	screenLabels.put("admin.common.space not allowed",_mapping.getTextDescription("admin.common.Space is not allowed in group name"));
	screenLabels.put("admin.common.special characters not allowed",_mapping.getTextDescription("admin.common.Special characters are not allowed in group name"));
	screenLabels.put("admin.common.DBL not allowed",_mapping.getTextDescription("admin.group.Group name is not allowed in DBL(Chinese,Korean,Japanese),since manager is SingleByte"));
	screenLabels.put("admin.common.updated successfully",_mapping.getTextDescription("admin.common.has been updated successfully")+".");
	screenLabels.put("admin.common.added successfully",_mapping.getTextDescription("admin.common.has been added successfully")+".");
//	screenLabels.put("admin.common.not updated successfully",_mapping.getTextDescription("admin.common.The component(s) you are trying to add to the group is/are already in association with a segment in which the group appears")+".");
	screenLabels.put("admin.common.not updated successfully",_mapping.getTextDescription("admin.common.This group and the component(s) you are trying to add to it belong to the same segment")+".");
	// Process page for adding group
	rootJson.put("isDouble",isDouble);
	rootJson.put("addModifyMode",mode);
	rootJson.put("oldGroupName",group);
	rootJson.put("otherHosts",otherHostsArr);
	rootJson.put("screenLabels",screenLabels);
	rootJson.put("managedHosts",managedHostsArr);
	rootJson.put("componentType",ctArray);
	rootJson.put("itemSelectorValue",commonHosts);
	rootJson.put("updateUrl","Egconfiggroupp.jsp?");
	out.println(rootJson.toString());
%>

