<%
/******************************************************************************
*	Name            :       EgShowServerGroups.jsp
*	Purpose         :		Displays list of configured Groups.
*	Design Changes	:		Jaiwin
*******************************************************************************/
%>

<%@ page import = "java.util.*" %>
<%@ include file="../../../admin/EgTrackerAJSON.jsp" %>
<%@ page import ="com.eg.EgURLEncoder" %>
<%@ page import ="com.eg.EgServerGroupBean" %>
<%@ page import="com.eg.EgRoleInfo"%>
<%@ page import="com.egurkha.util.StringUtils"%>
<%@ page import= "net.sf.json.*"%>

<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	JSONObject rootJson = new JSONObject();
	JSONObject hiddenObj = new JSONObject();
	JSONObject screenLabels = new JSONObject();

	EgRoleInfo ri = EgRoleInfo.getInstance(session.getId(),(String)session.getAttribute("sess_userid"));
	EgServerGroupBean descGrp = new EgServerGroupBean();
	Vector vecc = descGrp.getAllServerGroups();
	List listManagedComponents = ri.getAllServers();

	Vector vec = new Vector();
	Vector vecViewData = new Vector();
	String serGroup = "";
	//String ServerType = request.getParameter("ServerType");
	String ServerType = (String)session.getAttribute("ServerType");
	String test=request.getParameter("test");
	if (ServerType == null)
	{
		ServerType = "Groups";
	}
	String testName = null;
	if (ServerType != null && !ServerType.equalsIgnoreCase("Groups"))
	{
		ServerType = (String) session.getAttribute("ServerType");
		testName = (String) session.getAttribute("TestName");
	}
	String[] arr_length = new String[vecc.size()];
	//ServerType = (String) session.getAttribute("ServerType");
	//String testName = (String) session.getAttribute("TestName");
	String[] subjectGroups = (String[]) vecc.toArray(arr_length);

	if(subjectGroups != null && subjectGroups.length > 0)
	{
		for(int j=0;j<subjectGroups.length;j++)
		{
			serGroup = descGrp.getServerType(subjectGroups[j]);
			if(serGroup.equals(ServerType))
			{
				vec.add(subjectGroups[j]);
			}
		}
	}
	if (testName == null || testName.length() == 0)
	{
		for(int i=0;i<listManagedComponents.size();i++)
		{
			String strComp = (String) listManagedComponents.get(i);
			Vector vecAccessGroups = descGrp.getServerGroup(strComp.substring(strComp.indexOf(":")+1));

			if(vecAccessGroups != null && vecAccessGroups.size() > 0)
			{
				for(int a=0;a<vecAccessGroups.size();a++)
				{
					String tempVal = (String) vecAccessGroups.get(a);
					if(!vec.contains(tempVal))
					{
						vec.add(tempVal);
					}
				}
			}
		}
		//vec = vecc;
	}

	String TestNameForGroup = (String)session.getAttribute("TestNameForPolicy");
	String ServTypeForGroup = (String)session.getAttribute("serverTypeForPolicy");
	session.setAttribute("egPageDesc","EgShowServerGroups.jsp");	session.setAttribute("egTitlehref","/final/admin/EgConfigServerGroups.jsp?from=add&test="+TestNameForGroup+"&serv="+ServTypeForGroup); 
	screenLabels.put("title","THRESHOLD COMPONENT GROUPS");

	if (ServerType != null && ServerType.equalsIgnoreCase("Groups"))
	{
		screenLabels.put("admin.threshold.To modify threshold rules Click here",_mapping.getTextDescription("admin.threshold.To modify threshold rules Click here"));
	}
	else
	{
		screenLabels.put("admin.threshold.To add/modify threshold rules Click here",_mapping.getTextDescription("admin.threshold.To add/modify threshold rules Click here"));
	}
		rootJson.put("url_for_rulePage","EgShowThresholdPolicies.jsp?ServerType="+ServerType);

	if(vec != null && vec.size() > 0)
	{
		for(int i=0;i<vec.size();i++)
		{
			String groupName = (String) vec.get(i);
			Vector allComps = descGrp.getComponentNames(groupName);
			Vector allCompWithType = new Vector();
			String serverName = descGrp.getServerType(groupName);
			if(allComps != null && allComps.size() > 0)
			{
				for(int ac= 0;ac<allComps.size();ac++)
				{
					String tmpComp = (String) allComps.get(ac);
					String strCompWithType = serverName+":"+tmpComp;
					if(!allCompWithType.contains(strCompWithType))
					{
						allCompWithType.add(strCompWithType);
					}
				}
			}
			if(!listManagedComponents.containsAll(allCompWithType))
			{
				vecViewData.add(groupName);
			}
		}
	}

	vec.removeAll(vecViewData);
	JSONArray grpDataArr = new JSONArray();
	JSONArray grpDataGridArr = new JSONArray();
	if ((vec != null && vec.size() > 0) || (vecViewData != null && vecViewData.size() > 0))
	{
		rootJson.put("isNoData",false);
		Collections.sort(vec,String.CASE_INSENSITIVE_ORDER);
		JSONObject grpDataGridObj = new JSONObject();
		JSONArray grpDataViewArr = new JSONArray();

		for(int i=0;i<vec.size();i++)
		{
			JSONObject grpDataViewObj = new JSONObject();
			JSONObject grpDataObj = new JSONObject();
			String groupName = (String) vec.get(i);
			boolean border= (i+1) < vec.size();
			String associatedRules = "";
			String tmpAssoRules = descGrp.getPolicyForServerGroups(groupName);
			if (!StringUtils.isNull(tmpAssoRules))
			{
				List tmpAssoRuleList = StringUtils.egTokenizer(tmpAssoRules,",");
				List tmpList = new ArrayList();
				for(int a=0; a<tmpAssoRuleList.size(); a++)
				{
					String tmpString = (String) tmpAssoRuleList.get(a);
					if (!tmpList.contains(tmpString))
					{
						tmpList.add(tmpString);
						associatedRules +=","+tmpString;
					}
				}

				if (associatedRules.startsWith(","))
				{
					associatedRules = associatedRules.substring(1);
				}
			}
			if(StringUtils.isNull(associatedRules))
			{
				associatedRules = "-";
			}
			grpDataGridObj.put("ComponentGroup",groupName);
			grpDataGridObj.put("AssociatedRules",associatedRules);
			grpDataGridObj.put("modifyUrl","GroupThreshold/data/EgConfigServerGroupsJson.jsp?groupName="+EgURLEncoder.encode(groupName,"UTF-8")+"&mode=modify");
			grpDataGridObj.put("deleteUrl","GroupThreshold/data/EgshowservergroupspJson.jsp?group="+EgURLEncoder.encode(groupName,"UTF-8")+"&mode=delete");
			grpDataGridObj.put("isView",true);

			grpDataObj.put("Grp_Name"+i,groupName);
			grpDataObj.put("Grp_Modify"+i,"GroupThreshold/data/EgConfigServerGroups.jsp?groupName="+EgURLEncoder.encode(groupName,"UTF-8")+"&mode=modify");

			grpDataViewObj.put("Grp_View_"+i,"GroupThreshold/data/EgConfigServerGroups.jsp?groupName="+EgURLEncoder.encode(groupName,"UTF-8")+"&mode=view");
			grpDataViewArr.add(grpDataViewObj);

			grpDataArr.add(grpDataObj);
			grpDataGridArr.add(grpDataGridObj);
		}
		rootJson.put("grpDataArr",grpDataArr);
		if(vecViewData != null && vecViewData.size() > 0)
		{
			for(int i=0;i<vecViewData.size();i++)
			{
				JSONObject grpDataViewObj = new JSONObject();
				String viewGrpName = (String) vecViewData.get(i);
				String associatedRules = "";
				String tmpAssoRules = descGrp.getPolicyForServerGroups(viewGrpName);
				if (!StringUtils.isNull(tmpAssoRules))
				{
					List tmpAssoRuleList = StringUtils.egTokenizer(tmpAssoRules,",");
					List tmpList = new ArrayList();
					for(int a=0; a<tmpAssoRuleList.size(); a++)
					{
						String tmpString = (String) tmpAssoRuleList.get(a);
						if (!tmpList.contains(tmpString))
						{
							tmpList.add(tmpString);
							associatedRules +=","+tmpString;
						}
					}

					if (associatedRules.startsWith(","))
					{
						associatedRules = associatedRules.substring(1);
					}
				}
				if(StringUtils.isNull(associatedRules))
				{
					associatedRules = "-";
				}
				grpDataGridObj.put("ComponentGroup",viewGrpName);
				grpDataGridObj.put("AssociatedRules",associatedRules);
				grpDataGridObj.put("modifyUrl","none");
				grpDataGridObj.put("deleteUrl","none");
				grpDataGridObj.put("isView",true);

				grpDataViewObj.put("Grp_View_"+i,"GroupThreshold/data/EgConfigServerGroups.jsp?groupName="+EgURLEncoder.encode(viewGrpName,"UTF-8")+"&mode=view");
				grpDataViewArr.add(grpDataViewObj);
				grpDataGridArr.add(grpDataGridObj);
			}
			rootJson.put("grpDataViewArr",grpDataViewArr);
		}
		rootJson.put("grpDataGridArr",grpDataGridArr);
	}
	else
	{
		rootJson.put("isNoData",true);
		screenLabels.put("No_data",_mapping.getTextDescription("admin.threshold.There are no component group currently available"));
	}
	hiddenObj.put("test",test);
	rootJson.put("hiddenObj",hiddenObj);
	rootJson.put("screenLabels",screenLabels);
	out.println(rootJson.toString());

if(request.getQueryString()!=null)
session.setAttribute("adminLastAccessedURL","/final/admin/EgGroupThreshold.jsp?"+request.getQueryString());
else session.setAttribute("adminLastAccessedURL","/final/admin/EgGroupThreshold.jsp");

%>

