<%
/************************************************************************************************************
*	Name			:	deletegroupsexternalpJson.jsp 
*	Purpose			:	To delete external agents which do not manage any hosts
***********************************************************************************************************/
%>
<%@ include file = "../../../admin/EgTrackerAJSON.jsp"%>
<%@ page import = "com.eg.AgentConfig"%>
<%@ page import = "com.eg.EgExternalInfo"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "java.util.Vector"%>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page import = "net.sf.json.*"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json");
%>

<jsp:useBean id="trans" scope="page" class="egurkha.TransactionBean"/>

<%
	JSONObject rootJson = new JSONObject();
	JSONObject resultMsg = new JSONObject();

	/* code for auditlog starts */
	AuditLogThread auditLogThread = new AuditLogThread();
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",_user.getLoginID());
	auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
	auditLogThread.setValue("Session_id",session.getId());
	auditLogThread.setValue("Module","Delete Agents");
	/* code for auditlog ends */

	//trans.createFile("eg_external.ini","save");
	trans.createSyncFile("eg_external.ini","save");
	AgentConfig agentConfig = AgentConfig.getAgentConfig();
	EgExternalInfo externalInfo = new EgExternalInfo("manager");
	Vector allInternalHosts = externalInfo.getAllAgents();
	rootJson.put("allInternalHosts",allInternalHosts);

	Vector sessionVector = new Vector();
	String from = request.getParameter("from");
	boolean flagNotDel = false;

	if(from != null && from.equalsIgnoreCase("deleteExternalAgentsPage"))
	{
		auditLogThread.setValue("Activity","External Agents");
		String externalAgentsStr = request.getParameter("externalAgents");
		String externalAgentsArr[] = StringUtils.getTokens(externalAgentsStr,",");
		if(externalAgentsArr != null && externalAgentsArr.length > 0 )
		{
			for(int e=0;e<externalAgentsArr.length;e++)
			{
				String s_eagent = externalAgentsArr[e];
				if (allInternalHosts != null && allInternalHosts.contains(s_eagent))
				{
					flagNotDel = true;
					JSONObject errorMsg = new JSONObject();
					rootJson.put("requestStatus","failed");
					errorMsg.put("title",_mapping.getTextDescription("admin.error.Delete external agent"));
					errorMsg.put("message1",_mapping.getTextDescription("admin.error.This external agent has been used as an internal agent to one or more hosts")+"."+_mapping.getTextDescription("admin.error.It needs to be disassociated as the internal agent from the host(s)")+"."+_mapping.getTextDescription("admin.error.Go to the Components Add/Modify page to perform this action before deleting this agent")+".");

					rootJson.put("error",errorMsg);

					/* auditlog - start */
					auditLogThread.setValue("Activity","Add/Delete");
					auditLogThread.setCurrentValue("ColumnName","External Agent Not Deleted");
					auditLogThread.setCurrentValue("Host/Nick name",externalAgentsStr);
					auditLogThread.setValue("Description","External agent has not been deleted since it is assigned as an internal agent to one or more hosts");
					auditLogThread.sendItToDB();
					/* auditlog - end */
				}
			}
		}
		if (!flagNotDel)
		{
			auditLogThread.setValue("Activity","External Agents");
			if(externalAgentsStr != null && !externalAgentsStr.equalsIgnoreCase("null") && externalAgentsStr.trim().length()>0)
			{
				String externalAgents[] = StringUtils.getTokens(externalAgentsStr,",");
				for(int i=0;i<externalAgents.length;i++)
				{
					if (allInternalHosts == null || !allInternalHosts.contains(externalAgents[i]))
					{
						trans.deleteSpecValue(EgExternalInfo.emulationByExtAgent, externalAgents[i]);
						trans.deleteSpecValue(EgExternalInfo.extAgentsSection, externalAgents[i]);
						agentConfig.removeAgentElement(externalAgents[i]);
						auditLogThread.setCurrentValue("Agent Names",externalAgents[i]);

					}
				}
			}
			rootJson.put("requestStatus","success");
			resultMsg.put("title",_mapping.getTextDescription("admin.common.Delete External Agents"));
			resultMsg.put("message1",_mapping.getTextDescription("admin.common.External agent(s) deleted from eG system")+".");
			rootJson.put("result",resultMsg);

			auditLogThread.setValue("Description","External agents have been deleted from eG system");
		}
	}
	trans.saveFile();
	trans.releaseInstance();
	auditLogThread.sendItToDB();

	System.out.println("rootJson____"+rootJson);
	out.println(rootJson.toString());
%>



