<%
/*******************************************************************************
 *      File name               :       EgNewExtAgentsJson.jsp
 *      Purpose                 :       To Add and Delete External Agents.
 ******************************************************************************/
%>
<%@ include file = "../../../admin/EgTrackerAJSON.jsp" %>
<%@ page import = "com.eg.EgInstallInfo" %>
<%@ page import = "com.eg.EgExternalInfo" %>
<%@ page import = "com.eg.EgServicesInfo"%>
<%@ page import = "com.eg.EgSpecsInfo"%>
<%@ page import = "com.eg.EgDbInfo"%>
<%@ page import = "com.egurkha.*" %>
<%@ page import = "com.egurkha.util.*" %>
<%@ page import = "java.util.*" %>
<%@ page import = "net.sf.json.*"%>
<%@ page language = "java" contentType = "text/html; charset=UTF-8" pageEncoding = "UTF-8" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json");
%>

<%
	JSONObject rootJson = new JSONObject();
	JSONObject screenLabels = new JSONObject();
	egurkha.TransactionBean trans = new egurkha.TransactionBean();

	EgServicesInfo servicesInfo = new EgServicesInfo("manager");
	EgDiscInfo discInfo = new EgDiscInfo("manager");
	EgExternalInfo extInfo = new EgExternalInfo("manager");
	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
	String[] rmtAgents = extInfo.getAllRemoteAgents();
	List rmtList = Arrays.asList(rmtAgents);

	JSONArray rmtAgentsArr = new JSONArray();
	for(int i = 0; i < rmtList.size(); i++)
	{
		String agent = (String) rmtList.get(i);
		rmtAgentsArr.add(agent);
	}

	boolean isAllowHostName = servicesInfo.isAllowHostNames();
	rootJson.put("isAllowHostName",isAllowHostName);
	String modify = request.getParameter("modify");
	String btype = request.getParameter("Btype");
	trans.createFile("eg_external.ini");
	boolean isDouble = EgDbInfo.doubleByteEnabled;

	String hostIp = null;
	String hostName = null;
	String eAgent = request.getParameter("eagent");
	String defaultAgent =  specsInfo.getEGServer();
	boolean extClientEmulate = false;
	boolean enableNickNameEdit = false;
	JSONObject hostValue = new JSONObject();

	if (StringUtils.isNull(eAgent))
	{
		hostIp = EgConstants.BLANK_STRING;
		hostName = EgConstants.BLANK_STRING;
		hostValue.put("hostIPValue",hostIp);
		hostValue.put("hostNameValue",hostName);
	}
	else
	{
		hostName = eAgent;
		hostIp = extInfo.getIpForAgent(eAgent);
		ArrayList allComponentNicks = discInfo.getAllComponentNicks();
		if(!allComponentNicks.contains(defaultAgent))
		{
			allComponentNicks.add(defaultAgent);
		}
		if(!allComponentNicks.contains(hostName.toLowerCase()))
		{
			enableNickNameEdit = true;
		}
		hostValue.put("hostIPValue",hostIp);
		hostValue.put("hostNameValue",hostName);
	}
	rootJson.put("hostValue",hostValue);
	rootJson.put("enableNickNameEdit",enableNickNameEdit);

	screenLabels.put("admin.external.Host IP",_mapping.getTextDescription("admin.server.Host IP/Name"));
	screenLabels.put("admin.external.Please enter host IP",_mapping.getTextDescription("admin.external.Please enter host IP"));
	screenLabels.put("admin.external.Please enter host IP/host name",_mapping.getTextDescription("admin.external.Please enter host IP/host name"));
	screenLabels.put("admin.external.This host/nick name is used by another external agent",_mapping.getTextDescription("admin.external.This host/nick name is used by another external agent"));
	screenLabels.put("admin.external.Please enter host name",_mapping.getTextDescription("admin.external.Please enter host name"));
	screenLabels.put("admin.external.Host name",_mapping.getTextDescription("admin.server.Nick name"));
	screenLabels.put("admin.external.Client emulation",_mapping.getTextDescription("admin.external.Client emulation"));

	/*
	 * If client emulation is enabled
	 */
	if (EgInstallInfo.isClientEmulationEnabled)
	{

		boolean emulationEnabled = false;
		String agentName = request.getParameter("eagent");
		if (!StringUtils.isNull(agentName) && !agentName.equalsIgnoreCase("null"))
		{
			emulationEnabled = extInfo.isClientEmulationEnabled(agentName);
		}
		extClientEmulate = emulationEnabled;
		
		String emulateYes = null;
		String emulateNo = null;
		if (emulationEnabled)
		{
			emulateYes = "checked";
			emulateNo = EgConstants.BLANK_STRING;
			rootJson.put("emulateYes","Yes");
			rootJson.put("old_emulate","true");
		}
		else
		{
			emulateYes = EgConstants.BLANK_STRING;
			emulateNo = "checked";
			rootJson.put("emulateYes","No");
			rootJson.put("old_emulate","false");
		}
		boolean emuUpdate = !(emulationEnabled && extInfo.isEmulatedAgentAssigned(hostName));
		rootJson.put("emuUpdate",emuUpdate);
		
		screenLabels.put("admin.external.Client emulation",_mapping.getTextDescription("admin.external.Client emulation"));	
		screenLabels.put("admin.common.Yes",_mapping.getTextDescription("admin.common.Yes"));	
		screenLabels.put("admin.common.No",_mapping.getTextDescription("admin.common.No"));	
	}
				
	/*
	 * End
	 */
	 if(!rmtList.contains(eAgent))
	 {
		rootJson.put("rmtnothaveagent","Yes");
		screenLabels.put("admin.external.Add as Remote agent",_mapping.getTextDescription("admin.external.Add as Remote agent"));
		screenLabels.put("admin.common.Yes",_mapping.getTextDescription("admin.common.Yes"));
		screenLabels.put("admin.common.No",_mapping.getTextDescription("admin.common.No"));
	 }
	 else
	 {
		rootJson.put("rmtnothaveagent","No");
	 }
	screenLabels.put("admin.common.Update",_mapping.getTextDescription("admin.common.Update"));

	if(request.getQueryString()!=null)
	session.setAttribute("adminLastAccessedURL","/final/admin/EgExternalAgents.jsp?"+request.getQueryString());
	else session.setAttribute("adminLastAccessedURL","/final/admin/EgExternalAgents.jsp");

	rootJson.put("rmtAgentsArr",rmtAgentsArr);
	rootJson.put("eagent",eAgent);
	rootJson.put("mode","add");
	rootJson.put("screenLabels",screenLabels);

	out.println(rootJson.toString());
%>



