<%
/**
 *	File name		:	EgConfigExtAgentsJson.jsp
 *	Purpose         :   To configure hosts to external agents. 
 */
%>

<%@ include file = "../../../admin/EgTrackerAJSON.jsp" %>
<%@ page import = "java.util.*"%>
<%@ page import = "com.eg.EgDiscInfo"%>
<%@ page import = "net.sf.json.*"%>

<%@ page language = "java" contentType = "text/html; charset=UTF-8" pageEncoding = "UTF-8" %>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json");
%>

<jsp:useBean id="trans" scope="page" class="egurkha.TransactionBean"/>

<%
	JSONObject rootJson = new JSONObject();
	JSONObject screenLabels = new JSONObject();

	screenLabels.put("admin.test.Please choose an external agent",_mapping.getTextDescription("admin.test.Please choose an external agent"));
	screenLabels.put("admin.test.External agent",_mapping.getTextDescription("admin.test.External agent"));
	screenLabels.put("admin.external.No managed hosts selected",_mapping.getTextDescription("admin.external.No managed hosts selected"));
	screenLabels.put("admin.external.No external agent hosts selected",_mapping.getTextDescription("admin.external.No external agent hosts selected"));
	screenLabels.put("admin.external.HOSTS MANAGED",_mapping.getTextDescription("admin.external.HOSTS MANAGED"));
	screenLabels.put("admin.external.HOSTS MANAGED BY THIS AGENT",_mapping.getTextDescription("admin.external.HOSTS MANAGED BY THIS AGENT"));
	screenLabels.put("admin.remote.Update",_mapping.getTextDescription("admin.remote.Update"));
	screenLabels.put("admin.external.HOSTS MANAGED BY OTHER EXTERNAL AGENTS",_mapping.getTextDescription("admin.external.HOSTS MANAGED BY OTHER EXTERNAL AGENTS"));
	screenLabels.put("admin.external.Please choose atleast one agent to manage or unmanage",_mapping.getTextDescription("admin.external.Please choose atleast one agent to manage or unmanage"));

	Vector v_managed_servers = new Vector();
	Vector v_eagent_servers = new Vector();	

	String s_eagent = request.getParameter("eagent");
	String s_tmp = "";
	String s_val = "";
	s_eagent=(s_eagent==null)?"null":s_eagent;
	if(s_eagent!=null && !s_eagent.equals("null"))
	{
		trans.createFile("eg_external.ini");
		String [] s_eagent_servers = trans.getVariables("Test_Mapping_Section");
		for(int i=0;i < s_eagent_servers.length;i++)
		{
			s_tmp = s_eagent_servers[i];
			s_val = trans.getStrValue("Test_Mapping_Section",s_tmp);
			if(s_val.indexOf(",") > -1 && (s_val.indexOf(","+s_eagent+",") > -1 || s_val.startsWith(s_eagent+",") || s_val.endsWith(","+s_eagent)))
			{
				v_eagent_servers.addElement(s_tmp);
			}
			else if(s_val.equals(s_eagent))
			{
				v_eagent_servers.addElement(s_tmp);
			}
			else
			{
				continue;
			}
		}
		EgDiscInfo egdisc = new EgDiscInfo("manager");
		v_managed_servers = egdisc.getAllHosts();

		for(int k=0; k<v_eagent_servers.size(); k++)
		{
			if(v_managed_servers.contains(v_eagent_servers.elementAt(k)))
			{
				v_managed_servers.removeElement(v_eagent_servers.elementAt(k));
			}
		}
		com.eg.EgTesterInfo testerInfo = new com.eg.EgTesterInfo("manager");
		if(!testerInfo.externalAgentRunsAllAggTests())
		{
			Hashtable ht = egdisc.getIpNickMap();
			if(ht != null && ht.containsKey("0.0.0.0"))
			{
				String nicks = (String)ht.get("0.0.0.0");
				String a_nick[] = com.egurkha.util.StringUtils.getTokens(nicks,":");
				List agg_nicks = Arrays.asList(a_nick);
				v_eagent_servers.removeAll(agg_nicks);
				v_managed_servers.removeAll(agg_nicks);
				nicks = null;
				a_nick = null;
				agg_nicks = null;
			}
		}

		// To show only emulater types hosts for emulation enabled external agents.
		EgExternalInfo externalInfo = new EgExternalInfo("manager");
		boolean isEmulatedAgent = externalInfo.isClientEmulationEnabled(s_eagent);
		ArrayList emulTypes = new ArrayList();
		emulTypes.add("Emulated_client");
		emulTypes.add("Citrix_XcLogon_Emulation");
		emulTypes.add("Hrzn_Logon_Emulation");
		emulTypes.add("Xchg_Logon_Emulation");
		emulTypes.add("Hrzn_Web_Logon_Emulation");
		ArrayList managedEmulHosts = egdisc.getAllHostsOfTypes(emulTypes);
		if (isEmulatedAgent)
		{		
			v_eagent_servers.retainAll(managedEmulHosts);
			v_managed_servers.retainAll(managedEmulHosts);
		}
		else
		{
			v_eagent_servers.removeAll(managedEmulHosts);
			v_managed_servers.removeAll(managedEmulHosts);
		}
	}

	String reqFrom = request.getParameter("from");
	reqFrom = (reqFrom != null)?reqFrom:"";

	JSONArray externalAgentsArray = new JSONArray();
	JSONObject externalValue = new JSONObject();

	externalValue.put("displayField","Choose an external agent");
	externalValue.put("valueField",-1);
	externalAgentsArray.add(externalValue);

	trans.createFile("eg_external.ini");
	String[] s_eagents = trans.getVariables("Eg_External_Agents");
	if(s_eagents != null)
		Arrays.sort(s_eagents,String.CASE_INSENSITIVE_ORDER);
	for(int i=0;i < s_eagents.length;i++)
	{
		externalValue.put("displayField",s_eagents[i]);
		externalValue.put("valueField",s_eagents[i]);
		externalAgentsArray.add(externalValue);
	}
	rootJson.put("externalAgentsArray",externalAgentsArray);

	JSONArray ManagedHostByThisAgnt = new JSONArray();
	JSONObject ManagedHostByThisAgntObj = new JSONObject();

	String existingAgents = "";
	if(v_eagent_servers.size() > 0)
	{
		Collections.sort(v_eagent_servers,String.CASE_INSENSITIVE_ORDER);
		for(int j=0;j < v_eagent_servers.size();j++)
		{
			String str_temp = (String) v_eagent_servers.elementAt(j);
			ManagedHostByThisAgntObj.put("displayField",str_temp);
			ManagedHostByThisAgntObj.put("valueField",str_temp);
			ManagedHostByThisAgnt.add(ManagedHostByThisAgntObj);

			existingAgents += str_temp + ",";
		}
		if(existingAgents.indexOf(",")!=-1)
		{
			existingAgents = existingAgents.substring(0,existingAgents.lastIndexOf(","));
			rootJson.put("existingAgents",existingAgents);
		}
	}
	rootJson.put("ManagedHostByThisAgent",ManagedHostByThisAgnt);

	JSONArray ManagedHostByOthrAgnt = new JSONArray();
	JSONObject ManagedHostByOthrAgntObj = new JSONObject();

	if(v_managed_servers.size() > 0)
	{
		Collections.sort(v_managed_servers,String.CASE_INSENSITIVE_ORDER);
		for(int x=0;x < v_managed_servers.size();x++)
		{
			ManagedHostByOthrAgntObj.put("displayField",v_managed_servers.elementAt(x));
			ManagedHostByOthrAgntObj.put("valueField",v_managed_servers.elementAt(x));
			ManagedHostByOthrAgnt.add(ManagedHostByOthrAgntObj);
		}
	}
	rootJson.put("ManagedHostByOthrAgnt",ManagedHostByOthrAgnt);
	rootJson.put("screenLabels",screenLabels);

	if(request.getQueryString()!=null)
	session.setAttribute("adminLastAccessedURL","/final/admin/EgExternalAgents.jsp?"+request.getQueryString()+"&fromAssignExt=true");
	else session.setAttribute("adminLastAccessedURL","/final/admin/EgExternalAgents.jsp?eagent=null&fromAssignExt=true");

	v_eagent_servers.removeAllElements();
	v_managed_servers.removeAllElements();

	//System.out.println("rootJson______"+rootJson);
	out.println(rootJson.toString());
%>



