<%
/************************************************************************************************************
*	Name			:	DeleteExternalAgentsJson.jsp
*	Purpose			:	To delete external agents which do not manage any hosts
***********************************************************************************************************/
%>
<%@ include file = "../../../admin/EgTrackerAJSON.jsp"%>
<%@ page import = "com.eg.EgSpecsInfo"%>
<%@ page import = "com.eg.EgExternalInfo"%>
<%@ page import = "com.egurkha.admin.ExternalAgent"%>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "net.sf.json.*"%>

<%@ page language = "java" contentType = "text/html; charset=UTF-8" pageEncoding = "UTF-8" %>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json");
%>

<jsp:useBean id="trans" scope="page" class="egurkha.TransactionBean"/>

<%
	JSONObject rootJson = new JSONObject();
	JSONObject screenLabels = new JSONObject();

	String delAgent = request.getParameter("eagent");
	ExternalAgent externAgnt = new ExternalAgent();
	boolean isUsed = externAgnt.checkIfAgentIsUsedForGrid(delAgent);
	rootJson.put("AssoDissAgnt",isUsed);

	trans.createFile("eg_external.ini");
	String[] externalAgents = trans.getVariables("Eg_External_Agents");
	String [] externalAgentHosts = trans.getVariables(EgExternalInfo.testMapSection);

	Vector deleteExternalAgents = null;
	if(externalAgents != null && externalAgents.length>0)
	{
		deleteExternalAgents = new Vector(Arrays.asList(externalAgents));
		deleteExternalAgents.remove(new EgSpecsInfo("manager").getEGServer());
	}
	else
		deleteExternalAgents = new Vector();

	for(int a=deleteExternalAgents.size()-1;a>=0;a--)
	{
		String externalAgent = (String) deleteExternalAgents.get(a);
		for (int i=0; i<externalAgentHosts.length; i++)
		{
			String externalAgentsToNick = trans.getStrValue(EgExternalInfo.testMapSection, externalAgentHosts[i]);
			if (externalAgentsToNick.indexOf(",") > -1
				&& (externalAgentsToNick.indexOf(externalAgent+",") > -1 || externalAgentsToNick.startsWith(externalAgent+",")
				|| externalAgentsToNick.endsWith(externalAgent)))
			{
				deleteExternalAgents.remove(externalAgent);
			}
			else if(externalAgentsToNick.equals(externalAgent))
			{
				deleteExternalAgents.remove(externalAgent);
			}
		}
	}

	trans.saveFile();
	if(deleteExternalAgents.size()>0)
		Collections.sort(deleteExternalAgents,String.CASE_INSENSITIVE_ORDER);

	screenLabels.put("admin.common.Please enter a Search String",_mapping.getTextDescription("admin.common.Please enter a Search String"));
	screenLabels.put("admin.common.No external agent(s) found for your search",_mapping.getTextDescription("admin.common.No external agent(s) found for your search"));
	screenLabels.put("admin.common.Please select external agent(s)",_mapping.getTextDescription("admin.common.Please select external agent(s)"));
	screenLabels.put("admin.common.External agents which are not associated to any hosts",_mapping.getTextDescription("admin.common.External agents which are not associated to any hosts"));
	screenLabels.put("admin.common.Delete",_mapping.getTextDescription("admin.common.Delete"));

	JSONArray externalAgentArray = new JSONArray();
	JSONObject externalObj = new JSONObject();
	for(int i=0;i<deleteExternalAgents.size();i++)
	{
		String externalAgent = (String) deleteExternalAgents.get(i);
		externalObj.put("displayField",externalAgent);
		externalObj.put("valueField",externalAgent);
		externalAgentArray.add(externalObj);
	}

	JSONArray searchArr = new JSONArray();
	JSONObject searchObj = new JSONObject();
	String searchAgents = request.getParameter("compsearch");
	for (int j=0;j<deleteExternalAgents.size();j++)
	{
		String deleteExt = (String)deleteExternalAgents.get(j);
		if(searchAgents != null && ((deleteExt.toUpperCase()).indexOf(searchAgents.toUpperCase()) > -1 ))
		{
			searchObj.put("displayField",deleteExt);
			searchObj.put("valueField",deleteExt);
			searchArr.add(searchObj);
		}
	}
	rootJson.put("searchArr",searchArr);
	rootJson.put("from","deleteExternalAgentsPage");
	rootJson.put("screenLabels",screenLabels);
	rootJson.put("externalAgentArray",externalAgentArray);

	if(request.getQueryString()!=null)
	session.setAttribute("adminLastAccessedURL","/final/admin/EgExternalAgents.jsp?"+request.getQueryString()+"&fromDeleteExt=true");
	else session.setAttribute("adminLastAccessedURL","/final/admin/EgExternalAgents.jsp?eagent=null&fromDeleteExt=true");

	System.out.println("rootJson____"+rootJson);
	out.println(rootJson.toString());
%>



