<%
/*
 *   File		:	EgEnableDisableDDJson.jsp
 *   Purpose	:	To enable and disable detailed diagnosis (DD) for a test
*/
%>

<%@ include file = "../../../admin/EgTrackerAJSON.jsp" %>
<%@ page import = "com.eg.EgRoleInfo" %>
<%@ page import = "com.eg.MappingNameSorter"%>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import = "com.eg.EgName"%>
<%@ page import = "com.eg.EgSpecsInfo" %>
<%@ page import = "com.eg.EgMemInfo" %>
<%@ page import = "net.sf.json.*"%>
<%@ page language = "java" contentType = "text/html; charset=UTF-8" pageEncoding = "UTF-8" %>

<%
	JSONObject rootJson = new JSONObject();
	JSONObject screenLabels = new JSONObject();

	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json");
%>

<jsp:useBean id="prgBean" scope="page" class="egurkha.EgTestParamBean"/>

<%!
	String licenseCheck = new String("license");
%>

<%
	boolean ddEnabled = false;
	synchronized(licenseCheck)
	{
		ddEnabled = EgMemInfo.ddEnabled;
	}

	IniUI iniUI = IniUI.getInstance();
	String userLanguage = iniUI.getDefaultLanguage();
	if (_user != null)
	{
		userLanguage = _user.getLanguage();
	}
	MappingNameSorter sorter = new MappingNameSorter(userLanguage);

	String componentType = request.getParameter("componentType");
	EgRoleInfo ri = EgRoleInfo.getInstance(session.getId(),(String)session.getAttribute("sess_userid"));
	String[] componentTypes = ri.getServerTypes();
	ArrayList serverList = null;
	if (componentTypes != null && componentTypes.length > 0)
	{
		serverList = new ArrayList(Arrays.asList(componentTypes));
		serverList.remove("Site_servers");
	}
	
	ArrayList aListEnabledTestForCompType = null;
	ArrayList aListDDEnabledTests = new ArrayList();
	ArrayList aListDDDisabledTests = new ArrayList();

	if (componentType != null && !componentType.equals("-1") && ddEnabled)
	{
		EgSpecsInfo egSpecs = new EgSpecsInfo("manager");
		aListEnabledTestForCompType = egSpecs.getEnabledTests(componentType,false);

		IniFile egSpecsIni = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_specs.ini");
		String defaultTestMappingSection = "DEFAULT_TEST_MAPPING";
		ArrayList aListTests = new ArrayList();
		String strTests = egSpecsIni.getValue(defaultTestMappingSection,componentType);

		StringTokenizer strTokens = new StringTokenizer(strTests,",");
		while (strTokens.hasMoreTokens())
		{
			String strToken = strTokens.nextToken().trim();
			if (EgInstallInfo.isConfigTest(strToken)) continue;
			aListTests.add(strToken);
		}

		prgBean.createFile("eg_format.ini");
		String[] tests = prgBean.getVariables("FORMAT");
		for (int i=0;i<tests.length;i++)
		{
			String temp = tests[i];
			int idx = temp.indexOf(":");
			String enabledTest = temp.substring(0,idx);

			if (aListTests != null && !aListTests.contains(enabledTest))
			{
				continue;
			}

			if (aListEnabledTestForCompType != null && 
				!aListEnabledTestForCompType.contains(enabledTest))
			{
				continue;
			}

			if (!aListDDEnabledTests.contains(enabledTest))
			{
				aListDDEnabledTests.add(enabledTest);
			}
		}
		//to display the list in DD disabled list
		prgBean.createFile("eg_testinfo.ini");
		tests = prgBean.getVariables("Disable_DD");
		for (int k=0;k<tests.length;k++)
		{
			String temp = tests[k];

			if (aListTests != null && !aListTests.contains(temp))
			{
				continue;
			}

			if (!aListDDDisabledTests.contains(temp))
			{
				aListDDDisabledTests.add(temp);
			}
		}

		if (!aListDDDisabledTests.isEmpty())
		{
			aListDDEnabledTests.removeAll(aListDDDisabledTests);
		}
	}

	if (ddEnabled)
	{
		screenLabels.put("admin.server.Component type",_mapping.getTextDescription("admin.server.Component type"));
		screenLabels.put("admin.test.DD ENABLED TESTS",_mapping.getTextDescription("admin.test.DD ENABLED TESTS"));
		screenLabels.put("admin.test.DD DISABLED TESTS",_mapping.getTextDescription("admin.test.DD DISABLED TESTS"));
		screenLabels.put("admin.common.Update",_mapping.getTextDescription("admin.common.Update"));
		screenLabels.put("admin.test.Please choose a component type",_mapping.getTextDescription("admin.test.Please choose a component type"));

		JSONArray compType = new JSONArray();
		JSONObject compObj = new JSONObject();
		if (componentTypes != null && componentTypes.length > 0)
		{
			compObj.put("displayField",_mapping.getTextDescription("admin.common.Choose one"));
			compObj.put("valueField","-1");
			compType.add(compObj);

			serverList = sorter.getSortedCompTypeList(serverList);
			//get the actual and display names of component types
			for (int j=0;j<serverList.size();j++)
			{
				EgName nameObj = (EgName)serverList.get(j);
				String tmpVal = nameObj.getActualName();
				if (tmpVal.startsWith("Agg_"))
				{
					continue;
				}
				String tmpDis = nameObj.getLocalName();
				compObj.put("displayField",tmpDis);
				compObj.put("valueField",tmpVal);
				compType.add(compObj);
			}
		}
		else
		{
			compObj.put("displayField",_mapping.getTextDescription("admin.common.Not Applicable"));
			compObj.put("valueField","-1");
			compType.add(compObj);
		}
		aListDDEnabledTests = sorter.getSortedTestList(aListDDEnabledTests);

		JSONArray enableTests = new JSONArray();
		JSONArray commonTests = new JSONArray();
		JSONObject commonObject = new JSONObject();
		for (int i=0;i<aListDDEnabledTests.size();i++)
		{
			EgName name = (EgName)aListDDEnabledTests.get(i);
			String enableValue = name.getActualName();
			String enableDisplay = name.getLocalName();
			enableTests.add(enableValue);

			commonObject.put("displayField",enableDisplay);
			commonObject.put("valueField",enableValue);
			commonTests.add(commonObject);
		}
		aListDDDisabledTests = sorter.getSortedTestList(aListDDDisabledTests);

		JSONArray disableTests = new JSONArray();
		for (int j=0;j<aListDDDisabledTests.size();j++)
		{
			EgName name = (EgName)aListDDDisabledTests.get(j);
			String disableValue = name.getActualName();
			String disableDisplay = name.getLocalName();
			disableTests.add(disableValue);

			commonObject.put("displayField",disableDisplay);
			commonObject.put("valueField",disableValue);
			commonTests.add(commonObject);
		}
		rootJson.put("screenLabels",screenLabels);
		rootJson.put("compType",compType);
		rootJson.put("itemSelectorValue",commonTests);
		rootJson.put("enableTests",enableTests);
		rootJson.put("disableTests",disableTests);
	}
	session.setAttribute("adminLastAccessedURL","/final/admin/EgEnableDisableDD.jsp?componentType="+componentType);

	System.out.println("rootJson_______"+rootJson);
	out.println(rootJson.toString());
%>



