<!DOCTYPE html>

<%@ page errorPage="EgProbs.jsp"%>

<%@ page import="egurkha.EgDBConnectUI"%>
<%@ page import="java.util.*"%>
<%@ page import="java.sql.*"%>
<%@ page import="com.egurkha.util.StringUtils"%>
<%@ page import="com.eg.EgInstallInfo" %>
<%@ page import="com.eg.IniFile"%>

<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%!
	String[] categoryDisplayField = {
		"Performance test tables",
		"Configuration test tables",
		"DDD tables",
		"Thresh tables",
		"Trend tables",
		"Aggregate test tables",
		"Performance rating test tables",
		"Other tables"
	};

	String[] categoryValueField = {
		"perfTestTables",
		"confTestTables",
		"dddTables",
		"threshTables",
		"trendTables",
		"aggTestTables",
		"perfRxTestTables",
		"otherTables"
	};

	private ArrayList getData(String strQuery)
	{
		ArrayList aListData = new ArrayList();

		EgDBConnectUI dbconnect = new EgDBConnectUI();
		Connection conn = null;
		Statement stmt = null;
		ResultSet rs = null;

		try
		{
			conn = dbconnect.getConnection();
			stmt = conn.createStatement();
			rs = stmt.executeQuery(strQuery);

			ResultSetMetaData rsmd = rs.getMetaData();
			int numberOfColumns = rsmd.getColumnCount();

			while (rs.next())
			{
				for (int i=1;i<=numberOfColumns;i++)
				{
					String strTable = rs.getString(i);
					aListData.add(strTable);
				}
			}
		}
		catch(Exception e)
		{
			//e.printStackTrace();
			dbconnect.changeConn();
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
				}
				if (stmt != null)
				{
					stmt.close();
				}
				dbconnect.releaseConnection();
			}
			catch(Exception e1)
			{
				//e1.printStackTrace();
			}
			rs = null;
			stmt = null;
			conn = null;
		}

		return aListData;
	}
%>

<%
	String whoami = request.getParameter("whoami");
	String pwd = request.getParameter("pwd");
	String tempStr = request.getParameter("temp");

	if (tempStr == null)
	{
		String fromToolKit = request.getParameter("fromToolKit");
		if (fromToolKit == null || fromToolKit.equals("null"))
		{
			session.setAttribute("reqFrom","ViewTopServers");
			String redirectURL = "EgToolKit.jsp?whoami=egurkha&pwd=admin";
			response.sendRedirect(redirectURL);
		}

		String comeFrom = request.getParameter("comeFrom");
		if (!StringUtils.isNull(comeFrom) && comeFrom.equals("ViewTopServers"))
		{
			session.setAttribute("treeViewSrc","ViewTopServers");
		}
	}

	String strCategory = request.getParameter("category");
	String strPrevCategory = request.getParameter("previousCategory");
	String strTableName = request.getParameter("tablename");

	String dbType = "mssql";
	IniFile dbFilePtr = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_db.ini");
	String dbServerType = dbFilePtr.getValue("DB_PROPERTIES","DB_Server_Type");
	if (dbServerType.equals("EgOracleAdapter"))
	{
		dbType = "oracle";
	}
%>

<html>

<head>
<link rel="stylesheet" href="eg_styles/eg_adminstyle.css" />
</head>

<body>

<script type="text/javascript">

function submitForm()
{
	document.myForm1.action = "EgViewTopServers.jsp";
	document.myForm1.submit();
}

</script>

<form name="myForm1" method="post">
<input type="hidden" name="whoami" value="<%=whoami%>"/>
<input type="hidden" name="pwd" value="<%=pwd%>"/>
<input type="hidden" name="temp" value="temp"/>
<input type="hidden" name="previousCategory" value="<%=strCategory%>"/>
<br>
<table border="1" width="50%" align="center">
	<tr>
		<td id="subhead" width="50%"><b>Category</b></td>
		<td align="center">
			<select name="category" onchange="javascript:submitForm()" style="width: 300px">
				<option value="-1">Please select a category</option>
<%
	for (int i=0;i<categoryDisplayField.length;i++)
	{
		String strCDF = categoryDisplayField[i];
		String strCVF = categoryValueField[i];
		String selected = "";
		if (strCategory != null && strCategory.equalsIgnoreCase(strCVF))
		{
			selected = "selected";
		}
%>
				<option value="<%=strCVF%>" <%=selected%>><%=strCDF%></option>
<%
	}
%>
			</select>
		</td>
	</tr>

<%
	if (strCategory != null && !strCategory.equals("-1"))
	{
		ArrayList aListTables = null;

		String whereClause = "";
		String dbVersionName = com.eg.EgDbInfo.getDBVersion();
		String colName = "name";
		String tableName = "sys.tables";
		if(dbVersionName!=null && (dbVersionName.indexOf("SQL")>-1 && (dbVersionName.indexOf("2005")>-1 || dbVersionName.indexOf("2000")>-1))){
			tableName = "information_schema.tables";
			colName = "table_name";
		}

		if (strCategory.equalsIgnoreCase(categoryValueField[0]))
		{
			if (dbType.equalsIgnoreCase("mssql"))
			{
				whereClause = " where "+colName+" like '%_Test' or "+colName+" like '%_TEST' or "+colName+" like '%_ex'";
			}
			else //oracle
			{
				whereClause = " where tname like '%_Test' or tname like '%_TEST' or tname like '%_ex'";
			}
		}
		else if (strCategory.equalsIgnoreCase(categoryValueField[1]))
		{
			if (dbType.equalsIgnoreCase("mssql"))
			{
				whereClause = " where "+colName+" like '%_cf' or "+colName+" like '%_cf_ex'";
			}
			else //oracle
			{
				whereClause = " where tname like '%_cf' or tname like '%_cf_ex'";
			}
		}
		else if (strCategory.equalsIgnoreCase(categoryValueField[2]))
		{
			if (dbType.equalsIgnoreCase("mssql"))
			{
				whereClause = " where "+colName+" like '%_DDD'";
			}
			else //oracle
			{
				whereClause = " where tname like '%_DDD'";
			}
		}
		else if (strCategory.equalsIgnoreCase(categoryValueField[3]))
		{
			if (dbType.equalsIgnoreCase("mssql"))
			{
				whereClause = " where "+colName+" like '%_THRESH'";
			}
			else //oracle
			{
				whereClause = " where tname like '%_THRESH'";
			}
		}
		else if (strCategory.equalsIgnoreCase(categoryValueField[4]))
		{
			if (dbType.equalsIgnoreCase("mssql"))
			{
				whereClause = " where "+colName+" like '%_TREND'";
			}
			else //oracle
			{
				whereClause = " where tname like '%_TREND'";
			}
		}
		else if (strCategory.equalsIgnoreCase(categoryValueField[5]))
		{
			if (dbType.equalsIgnoreCase("mssql"))
			{
				whereClause = " where "+colName+" like '%_ag' or "+colName+" like '%_agx'";
			}
			else //oracle
			{
				whereClause = " where tname like '%_ag' or tname like '%_agx'";
			}
		}
		else if (strCategory.equalsIgnoreCase(categoryValueField[6]))
		{
			if (dbType.equalsIgnoreCase("mssql"))
			{
				whereClause = " where "+colName+" like '%_rx'";
			}
			else //oracle
			{
				whereClause = " where tname like '%_rx'";
			}
		}
		else if (strCategory.equalsIgnoreCase(categoryValueField[7]))
		{
			IniFile iniObj = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_dbase.ini");
			Vector var_vec = iniObj.getVariables("DEF_TABLES",true);
			aListTables = new ArrayList(var_vec);
		}

		if (!strCategory.equalsIgnoreCase(categoryValueField[7]))
		{
			String strQuery = "";
			if (dbType.equalsIgnoreCase("mssql"))
			{
				strQuery = "SELECT "+colName+" from " +tableName+" "+ whereClause;
			}
			else //oracle
			{
				strQuery = "SELECT tname from tab " + whereClause;
			}
			aListTables = getData(strQuery);
			if (strCategory.equalsIgnoreCase(categoryValueField[0]))
			{
				aListTables.remove("METATEST");
			}
		}
%>
	<tr>
		<td id="subhead" width="50%"><b>Table</b></td>
		<td align="center">
			<select name="tablename" onchange="javascript:submitForm()" style="width: 300px">
<%
		int i_idx = aListTables.size();
		if (i_idx > 0)
		{
			Collections.sort(aListTables,String.CASE_INSENSITIVE_ORDER);
%>
				<option value="-1">Please select a table</option>
<%
		}
		else
		{
%>
				<option value="-1">Not applicable</option>
<%
		}

		for (int i=0;i<i_idx;i++)
		{
			String strTable = (String)aListTables.get(i);
			String selected = "";
			if (strTable != null && strTable.equals(strTableName))
			{
				selected = "selected";
			}
%>
				<option value="<%=strTable%>" <%=selected%>><%=strTable%></option>
<%
		}
%>
			</select>
		</td>
	</tr>
<%
	}
	else
	{
%>
	<tr>
		<td id="subhead" width="50%"><b>Table</b></td>
		<td align="center">
			<select name="tablename" style="width: 300px">
				<option value="-1">Not applicable</option>
			</select>
		</td>
	</tr>
<%
	}
%>

</table>
</form>

<br>
<br>

<%
	if (strCategory != null && !strCategory.equals("-1") && 
		strPrevCategory != null && strPrevCategory.equalsIgnoreCase(strCategory) && 
		strTableName != null && !strTableName.equals("-1"))
	{
		String strQuery = "select count(1) from " + strTableName;
		ArrayList aListData = getData(strQuery);
%>
<table border="1" width="50%" align="center">
	<tr>
		<th colspan="2"><%=strTableName%></th>
	</tr>
	<tr>
		<th align="left" width="70%"><b>Total number of rows</b></th>
		<th width="30%"><%=(String)aListData.get(0)%></th>
	</tr>
<%
		if (dbType.equalsIgnoreCase("mssql"))
		{
			strQuery = "select TOP(25) trgt_host,count(trgt_host) from " + strTableName + " group by trgt_host order by 2 desc";
		}
		else //oracle
		{
			strQuery = "select * from (select trgt_host,count(trgt_host) from " + strTableName + " group by trgt_host order by 2 desc) WHERE ROWNUM < 26";
		}
		aListData = getData(strQuery);
		if (aListData != null && !aListData.isEmpty())
		{
%>
	<tr>
		<th colspan="2">Top 25 targets by row count</th>
	</tr>
	<tr>
		<th>Target Host</th><th>Record Count</th>
	</tr>
<%
			for (int i=0;i<aListData.size();i=i+2)
			{
				String data1 = (String) aListData.get(i);
				String data2 = (String) aListData.get(i+1);
%>
	<tr>
		<td><%=data1%></td><td><%=data2%></td>
	</tr>
<%
			}
		}
%>
	</table>
<%
	}
%>

<br>
</body>

</html>



