<%
/*****************************************************************************
*	Name		:	EgUpdateInfo.jsp
*	Purpose		:	This page is called from EgTestInfo.jsp. This
				also enlists the info values associated with
				a particular test. Further it allows the admin
				user to enable or disable the info.
*	Version         :       1.0
*	CreationDate	:	10/08/2001
*	LastModified	:     27/02/2002 //sandhya -  ';' expected.
				  10/08/2001
				20/08/2001 - Bharath G
					   - Disallow deletion of last info
					     for a test
				19/12/2001 - Bharath G
					   - Added component_type in the query
					   THIS CODE HAS GENERIC QUERIES
*	Author		:	Bharath G
*	Design Changes	:	Jaiwin
******************************************************************************/
%>

<%@ include file="EgTrackerA.jsp" %>
<%@ page errorPage="EgProbs.jsp"%>
<%@ page import="com.eg.EgServicesInfo"%>
<%@ page import="com.eg.EgExternalInfo"%>
<%@ page import ="egurkha.EgDbAdapterUI"%>
<%@ page import ="com.eg.EgDbAdapterTypeUI"%>
<%@ page import="com.eg.IniFile" %>
<%@ page import="com.egurkha.util.StringUtils"%>
<%@ page import="com.eg.EgThresholdInfo" %>
<%@ page import="com.eg.EgSpecsInfo" %>
<%@ page import="com.eg.EgServerGroupBean" %>
<%@ page import = "com.eg.EgInstallInfo" %>
<%@ page import="com.eg.EgDbInfo"%>
<%@ page import = "com.eg.EgConfigFilesSync"%>
<%@ page import = "com.eg.EgURLEncoder"%>

<%@ taglib prefix = "egui" uri = "../WEB-INF/eg-taglib.tld"%>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	EgDbAdapterUI egDb;
%>

<%@ page import="java.sql.*" %>
<%@ page import="java.util.*" %>
<%@ page import="com.eg.EgTestInfo" %>

<jsp:useBean id="reporterBean" scope="request" class="egurkha.ReporterBean" />
<jsp:useBean id="trans" class="egurkha.TransactionBean" scope="page" />

<%
	//code for db optimization
	EgExternalInfo extInfo =new EgExternalInfo("manager");
	EgServicesInfo egserInfo = new EgServicesInfo("manager");
	boolean uniqueHostSystemData = egserInfo.isUniqueHostSystemData();
	Hashtable hash = extInfo.getInternalAgentMap();
	trans.createFile("eg_thresholds.ini");
	String some = request.getParameter("del1");
	String inf = request.getQueryString();

	String server = request.getParameter("server");
	String test = request.getParameter("test");
	String comp = request.getParameter("comp");
	String selection = request.getParameter("duration");
	String info1="";
	String delete=request.getParameter("delete1");
	Hashtable ht = new Hashtable();

	// user threshold - Thirumal Azhagan
	EgSpecsInfo specs = new EgSpecsInfo("manager");
	EgServerGroupBean descGrp = new EgServerGroupBean();
	EgThresholdInfo egThresh = new EgThresholdInfo("manager");
	String conf = (String) session.getAttribute("conf");
	IniFile iniobj=new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_tests.ini",false);
	if(some != null)
	{
		String subject = "DESCRIPTOR_THRESHOLDS";
		String variable = some+"#"+request.getParameter("inf");
		//trans.deleteValues(subject,variable);
		//trans.saveFile();
		IniFile threshIniWr = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_thresholds.ini");
		threshIniWr.deleteValue(subject,variable);
		threshIniWr.saveFile();
		EgConfigFilesSync.releaseInstance(threshIniWr);
		EgThresholdInfo.setUpdated();
		Vector sess_vec = new Vector();

		sess_vec.addElement(_mapping.getTextDescription("admin.test.Modifying descriptor thresholds"));
		String params = "test="+request.getParameter("test")+"&qctr=5&from=threshinfo&tt=1&thresh=1&server="+request.getParameter("server")+"&comp="+EgURLEncoder.encode(request.getParameter("comp"),"UTF-8");
		sess_vec.addElement("EgUpdateInfo.jsp?"+params);
		sess_vec.addElement(_mapping.getTextDescription("admin.test.Deleting descriptor thresholds"));
		sess_vec.addElement(_mapping.getTextDescription("admin.test.Descriptor thresholds deleted successfully")+"...");
		session.putValue("vec_Results",sess_vec);

		/* code for auditlog starts */
		AuditLogThread auditLogThread = new AuditLogThread();	
		auditLogThread.setValue("Category","Admin");
		auditLogThread.setValue("User_id",_user.getLoginID());
		auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
		auditLogThread.setValue("Session_id",session.getId());
		auditLogThread.setValue("Module","Threshold");
		auditLogThread.setValue("Activity","Configure Thresholds");
		auditLogThread.setValue("Description",some + " "+"descriptor thresholds deleted");
		auditLogThread.sendItToDB();
		/* code for auditlog ends */
%>
		<jsp:forward page="EgResults.jsp" />
<%
	}
%>
<%
	String ip = (String)session.getValue("compname");
	String action=request.getParameter("action");
	String value=request.getParameter("value");
	String source = request.getParameter("from");
	ResultSet rs = null;
	Hashtable tempMeasureLast = new Hashtable();
	ArrayList measLastTestsList = new ArrayList();
	ArrayList measLastInfosList = new ArrayList();

	if(source.equals("testinfo") && !selection.equals("Any time"))
	{
		tempMeasureLast = (Hashtable) session.getAttribute("tempMeasureLast");
		if(tempMeasureLast != null && tempMeasureLast.size() > 0)
		{
			Iterator itrTemp =(tempMeasureLast.keySet()).iterator();
			while(itrTemp.hasNext())
			{
				String tempTest = (String)itrTemp.next();
				measLastTestsList.add(tempTest);
			}
			if(measLastTestsList.contains(test))
			{
				String measInfo = (String) tempMeasureLast.get(test);
				String[] measStrInfo = tokenizeInfo(measInfo);
				for(int j=0; j<measStrInfo.length; j++)
				{
					String tempVal = measStrInfo[j];
					if(tempVal.indexOf("0eGHash1") > -1 )
					{
						String strMeasInfo = tempVal.substring(0,tempVal.indexOf("0eGHash1"));
						String strMeasInfoDisable = tempVal.substring(tempVal.indexOf("0eGHash1")+8);
						measLastInfosList.add(strMeasInfo.trim());
						measLastInfosList.add(strMeasInfoDisable.trim());
					}
					else
					{
						measLastInfosList.add(tempVal.trim());
					}
				}
			}
		}
	}

	String whoami = "manager";
	EgTestInfo testInfo = new EgTestInfo(whoami);
%>

<html>
<head>
<title>Server Type Test List</title>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">

<egui:skin ui = "admin"/>

<!-- <link rel="stylesheet" href="eg_styles/eg_adminstyle.css">  -->
<script language="JavaScript">

function isNetscape()
{
	// get browser info.
	appName= navigator.appName;
	appLongVer = navigator.appVersion;
	appVer = appLongVer.substring(0, 1);

	// check for Navigator ver 4+. 
	if ((appName == "Netscape") && (appVer >= 4)) return true;
	return false;
}

function isIE()
{
	// get browser info. 
	appName= navigator.appName;
	appLongVer = navigator.appVersion;
	appVer = appLongVer.substring(0, 1);

	// check for IE ver 4+. 
	if ((appName == "Microsoft Internet Explorer") && (appVer >= 4)) return true;
	return false;
}

temp=new Array();
function deleteThresh(info)
{
	var comp = "<%=comp%>";
	var server = comp.substring(0,comp.indexOf(":"));
	var test = "<%= test %>";
	var ip = comp.substring(comp.indexOf(":")+1,comp.lastIndexOf(":"));
	var port = comp.substring(comp.lastIndexOf(":")+1);
	var variable = test+":"+ip+":"+port;

	var tmpInfo = info;
	if (info.indexOf("#") > -1)
	{
		do
		{	
			info=info.replace('#','0eGHash1');
		}while(info.indexOf("#")>-1);
	}
	document.forms[0].action = "EgUpdateInfo.jsp?delete1=true&server="+server+"&test="+test+"&comp="+encodeURIComponent(comp)+"&from=threshinfo&qctr=5&tt=1&del1="+encodeURIComponent(variable)+"&inf="+encodeURIComponent(info);
	
	document.forms[0].delete1.value="true";
	var a = confirm('<egui:intnl text="admin.common.Are you sure you want to delete descriptor thresholds for"/> '+ tmpInfo + " ?");
	if(a)
	{
		document.forms[0].submit();
	}
}

function call(info,configInfo)
{
	if (info.indexOf("#") > -1)
	{
		do
		{	
			info=info.replace('#','0eGHash1');
		}while(info.indexOf("#")>-1);
	}
	
	var comp = "<%=comp%>";
	var test = "<%= test %>";
	var server = comp.substring(0,comp.indexOf(":"));
	var port = "";
	var ip = "";
	var chk = configInfo;

	if(server == "Oracle_server")
	{
		port = comp.substring(comp.indexOf(":")+1,comp.lastIndexOf(":"));
	}
	else
		port = comp.substring(comp.lastIndexOf(":")+1);
	
	if(server == "Oracle_server")
	{
		var idx = comp.split(":");
		if(idx.length == 4)
			var ip = comp.substring(comp.indexOf(":")+1);
		else
			var ip = comp.substring(comp.indexOf(":")+1,comp.lastIndexOf(":"));
	}
	else
	{
		if(port == "NULL")
			ip = comp.substring(comp.indexOf(":")+1);//,comp.lastIndexOf(":")); // commented by thirumal 
		else
			ip = comp.substring(comp.indexOf(":")+1);
	}

	var withoutport = "EgConfigThresh.jsp?comptype="+server+"&compname="+ip+"&qctr=1&rctr=0&t_name="+test+"&server="+server+"&abc=1&threshinfo="+info+"&comp=<%= comp %>&conf=<%=conf%>&configInfo="+chk+"&click1=refine&doRemoveElementFromStack=no";
	var withport = "EgConfigThresh.jsp?comptype="+server+"&compname="+ip+"&qctr=1&rctr=0&t_name="+test+"&server="+server+"&abc=1&threshinfo="+info+"&comp=<%= comp %>&conf=<%=conf%>&configInfo="+chk+"&click1=refine&doRemoveElementFromStack=no";

	if(port == "NULL")
	{
		window.location.href= encodeURI(withoutport)+"&without=1";
	}
	else
	{
		window.location.href=encodeURI(withport)+"&with=1";
	}
}

function populate()
{
	var srcinfo = document.list.sourceinfo.value; //karthick
	if(!(srcinfo=="threshinfo"))
	{
		sendAlert();
	}
	else
	{
		//alert("send alert not called");
	}
	var thisForm = document.list;
}

function sendAlert()
{
	var count = document.list.elements.length;
	var flag1 = 'false';
	var flag2 = 'false';
	var infoCount = 0;
	var delCount = 0;
	for(var i=2; i<(count-4); i=i+3)
	{
		var val1 = document.list.elements[i].checked;
		var val2 = document.list.elements[i+1].value;
		infoCount++;
		if(val1 == false)
			delCount++;
		if(val1 == false && val2 == 'yes')
			flag1 = 'true';
		if(val1 == true && val2 == 'no')
			flag2 = 'true';
	}
	checkit();
	var initialCheckList = document.list.initiallySelectedDesc.value;
	var currentCheckList = document.list.selectedDesc.value;
	if (initialCheckList == currentCheckList)
	{
		alert("<egui:intnl text='admin.test.No changes to update'/>");
		flag1 = 'false';
		falg2 = 'false';
	}
	
	if(flag1 == 'true')
	{
		if(delCount > 0) // && infoCount > 0)
		{
			/*	var msg= 'You are trying to delete descriptor(s) for which all \n' +
					 'data would be deleted from the eG database \n' +
					 'permanently. If the descriptor is enabled again, it \n' +
					 'will be indexed by the eG manager. The descriptor\n' +
					 'would appear only after the agent indexing is \n' +
					 'complete.'+
					 '\n\nDo you want to proceed ?'
			*/
			var msg = "<egui:intnl text='admin.test.You are trying to delete descriptor(s) for which all data would be deleted from the eG database permanently'/>.\n<egui:intnl text='admin.test.If the descriptor is enabled again, it will be indexed by the eG manager'/>.\n<egui:intnl text='admin.test.The descriptor would appear only after the agent indexing is complete'/>.\n\n<egui:intnl text='admin.test.Do you want to proceed'/> ?";

			var result = confirm(msg);
			if(result == true)
			{
				if (isNetscape()) targetObj = document.list.update;
				if (isIE()) targetObj =document.list.update;
				targetObj.disabled = true;
				document.list.submit();
			}
			else
			{	
				document.list.reset();
			}
		}
		else
		{
			var alertMsg ="<egui:intnl text='admin.test.It is not possible for this test to run without any descriptors'/>.\n<egui:intnl text='admin.test.To stop this test disable it using the tests section'/>.";
			alert(alertMsg);
			document.list.reset();
		}
	}
	if(flag2 == 'true')
	{
		if (isNetscape()) targetObj = document.list.update;
		if (isIE()) targetObj =document.list.update;
		targetObj.disabled = true;
		document.list.submit();
	}
}

function checkit()
{
	myForm = window.document.list;
	selectedNow ="";
	for(i=0;i<myForm.elements.length;i++)
	{
		if(myForm[i].type == 'checkbox' && myForm[i].checked)
		{
			if(selectedNow.length==0)
				selectedNow = myForm[i].value;
			else
				selectedNow += "," + myForm[i].value;
		}
	}
	if(selectedNow.length>0)
	{
		myForm.selectedDesc.value = selectedNow;
	}
}
</script>

</head>
<!-- <body bgcolor="#FFFFFF" leftmargin="0" topmargin="20" marginwidth="0" marginheight="20"> -->
<body style="overflow:auto" id="space6" >
	<form name="list" action="Egtestinfop.jsp" method ="post" style="margin:0px">
		<input type="hidden" name="sourceinfo" value="<%=source%>">
		<table border="0" align="center" cellspacing="0" cellpadding="0" width="100%" >
<%
	Object o = request.getParameter("qctr");
	int index = 0;
	if(o != null)
		index = Integer.parseInt(o.toString());
	String tt = request.getParameter("tt");
	if(tt == null)
	{
		if(index == 5)
		{
			session.setAttribute("egBackComplete","EgTestInfo.jsp?server="+ server +"&qctr=1");
		}
		else
		{
			session.setAttribute("egBackComplete","EgTestInfo.jsp?server="+ server +"&comp="+ comp);
		}
	}
	else
	{
		session.setAttribute("egBackComplete","EgConfigThresh.jsp?comptype="+server +"&compname="+ ip +"&qctr=1&rctr=0&server="+server+"&thresh=1&t_name="+ test +"comp="+comp );
	}
	session.setAttribute("egPageDesc","EgUpdateInfo.jsp?from="+source);
%>

			<jsp:include page="listSearch.jsp?title=LIST OF DESCRIPTORS&leftString=&backButton=true&subtitle=false&searchBox=false"/>
			<tr>
				<td width="85%" id="eg_whitebg" align="center" valign="top">
					<table align="center" cellspacing="0" cellpadding="0" border="0" width="85%" >
						<tr>
<%
	egDb=EgDbAdapterTypeUI.getObject();
	boolean isConnected = false;
	String status = egDb.setConnection();
	if(status.equals("CONNECTED"))
	{
		isConnected = true;
	}
	if(isConnected)
	{
		//********Query changed for db optimization******
		int ind = comp.indexOf(":");
		String compTy = comp.substring(0,ind);
		String compA = comp.substring(ind+1)+ ":" + comp.substring(0,ind);
		ind = compA.indexOf(":");
		String s_hostSysName = compA.substring(0, ind);
		if(uniqueHostSystemData && hash.containsKey(s_hostSysName))
			s_hostSysName =(String)hash.get(s_hostSysName);
		String compB =s_hostSysName+ ":NULL:Host_system";
		String query;
		if(EgDbInfo.isSqlAdapter)
		{
			query= "SELECT distinct(info), test_name " +
			"FROM metatest WHERE comp_name + ':' + comp_type in ('" + compA + "','"+compB+"') AND test_name='"+ test +"'";
		}
		else
		{
			query = "SELECT distinct(info), test_name " +
			"FROM metatest WHERE comp_name || ':' || comp_type in ('" + compA + "','"+compB+"') AND test_name='"+ test +"'";
		}
		//***********************************************
		String allInfos=iniobj.getValue("NOTHRESHOLD_DESCRIPTORS",test.trim());
		ArrayList al_nothresh=testInfo.egTokenizer(allInfos,",");
		//Hashtable ht = new Hashtable();
		try
		{
			rs = egDb.SelectExec(query);
			while(rs.next())
			{
				String info = rs.getString(1);
				if(comp.startsWith("Oracle_server"))
				{
					int x = info.indexOf("+");
					info = info.substring(x);
				}
				if(info.length() < 2)
					continue;
				info = info.substring(1);
				if(!source.equalsIgnoreCase("testinfo"))
				{
					if (al_nothresh!=null && al_nothresh.size()>0)
					{
						if (al_nothresh.contains(info))
						{
							continue;
						}
					}
				}
				ht.put(info, new Boolean(true));
			}
			rs.close();
			egDb.releaseConnection(false);
			EgDbAdapterTypeUI.releaseObject(egDb);
		}
		catch(Exception e)
		{
			if(rs != null)
				rs.close();
			egDb.releaseConnection(true);
			EgDbAdapterTypeUI.releaseObject(egDb);
		}

		ArrayList al;
		String tmpcomp=compA.substring(0,compA.lastIndexOf(":"));
		if(source.equalsIgnoreCase("testinfo"))
		{
			al = testInfo.getInfoForTest(tmpcomp, test, server);
			for(int i=0; i<al.size(); i++)
			{
				String info = (String) al.get(i);
				String [] str = tokenizeInfo(info);
				for(int j=0; j<str.length; j++)
				{
					ht.put(str[j], new Boolean(false));
				}
			}
		}
%>
										<td height='22' nowrap width="95%" align="center">
<%
		String displayStr = null;
		if (comp.endsWith(EgConstants.NULL_PORT))
		{
			displayStr = _mapping.getComponentTypeDescription(Server.getServerType(comp)) + ":" + Server.getServerNameWithoutPort(comp, true);
		}
		else
		{
			displayStr = _mapping.getComponentTypeDescription(Server.getServerType(comp))+":"+Server.getServerName(comp);
		}

		if(!ht.isEmpty())
		{
%>
								<table align="center" border="0" cellpadding="0" cellspacing="0" height="22" width="100%">
									<tr>
										<td id="subhead_left" width="7"> <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> </td>
										<td class="eg_subheadbg_lower" style="border-left-width: 0px; border-right-width: 0px;" align="center" width="100%"><egui:intnl text="admin.test.Descriptors supported for"/> <b><egui:intnl test="<%= test %>"/></b>&nbsp;<egui:intnl text="admin.test.for monitoring"/> <b><%= displayStr %></b> </td>
										<td id="subhead_right" width="7"> <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> </td>
									</tr>
								</table>
<%
		}
		else
		{
%>
								<table border="0" cellspacing="0" cellpadding="0" width="85%" align="center">
									<tr>
										<td align="center">
											<img src="/final/admin/eg_images/<%=admin_Skin%>/exclamation-icon.gif">
										</td>
									</tr>
									<tr>
										<td align="center">
								<egui:intnl text="admin.test.No Descriptors available for"/> <b><egui:intnl test="<%= test %>"/></b> <egui:intnl text="admin.test.for "/> <br> <b><%= displayStr %></b>
<%
		}
%>
							</td>
						</tr>
					</table>
<%
		/* BEGIN  code for sorting  */
		Iterator itrht =(ht.keySet()).iterator();
		ArrayList htInfos = new ArrayList();

		while(itrht.hasNext())
		{
			String tmpHtInfo = (String)itrht.next();
			htInfos.add(tmpHtInfo);
		}

		if(source.equals("testinfo") && !selection.equals("Any time"))
		{
			Hashtable htClone = (Hashtable) ht.clone();
			for(int ii = 0; ii < htInfos.size(); ii++)
			{
				String htInfoData = (String) htInfos.get(ii);
				if(!measLastInfosList.contains(htInfoData))
				{
					htClone.remove(htInfoData);
				}
			}
			ht = new Hashtable(htClone);
		}

		Enumeration ee = ht.keys();
		int count = 0;
		int cnt = 1;

		Object infoArray[]= new Object[ht.size()];
		int i=0;
		while(ee.hasMoreElements())
		{
			infoArray[i]= ee.nextElement();
			i++;
		}
		Arrays.sort(infoArray, new Comparator()
			{
				public int compare(Object o1, Object o2)
				{
					return (((String) o1).toLowerCase().compareTo(((String) o2).toLowerCase()));
				}
			});
		/*for(i=0;i<infoArray.length;i++)
		out.println(infoArray[i]);*/
		ArrayList al_disabled = new ArrayList();
		ArrayList al_enabled = new ArrayList();
		// user threshold - thirumal
		String comp_name = comp.substring(comp.indexOf(":")+1,comp.length());

		Vector vec = egThresh.getInfosForThresholds(test,comp_name);
		boolean b_portRelev = specs.isPortRelevantForTest(test);
		Vector serverGroup = descGrp.getServerGroup(comp_name,test,b_portRelev);
		//Vijay write this condition
		if(!ht.isEmpty())
		{
%>
					<table border="0" cellspacing="0" cellpadding="0" width="85%">
						<tr>
								<td height="6"  width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
								<td height="6" id="eg_subcontentbg" width="100%" ><img src="/final/admin/eg_images/spacer.gif" height="6"></td>
								<td height="6" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
						</tr>
						<tr>
							<td colspan="3" valign="top">
								<table align="center" width="100%" cellspacing="0" cellpadding="0" border="0" >
<%
			for(i=0;i<infoArray.length;i++) //while(ee.hasMoreElements())
			{
				boolean border=(i+1)<infoArray.length;
				//out.print(border);
				String confInfo = "no";
				String info = (String)infoArray[i]  ; //(String) ee.nextElement();

				//String info1="";
				//replace \ with \\ for bug 
				if(info.indexOf("\\") >0)
				{
					info1=StringUtils.replace(info,"\\","\\\\");
				}
				else
				{
					info1=info;
				}

				boolean enabled =((Boolean)ht.get(info)).booleanValue(); /* END  code for sorting  */
				String check = "";
				String state = "no";
				if(enabled)
				{
					check = "checked";
					state = "yes";
					al_enabled.add(info);
				}
				else
				{
					al_disabled.add(info);
				}
				count++;
%>
					<!-- Replication starts here -->

									<tr> <!-- This tr is for displaying a gap between each of the tests-->
<%
				if(! (source.equalsIgnoreCase("threshinfo")) )
				{
%>
										<td id="<%=border?"form_border":"form_spacing"%>" class="eg_subcontentbg" nowrap align="center" >
									&nbsp;<input type=checkbox class="eg_input" name='info<%= count %>' value='<%= info %>' <%= check %> ></td>
<%
				}
%>
										<td align='left' height='32'id="<%=border?"form_border":"form_spacing"%>" class="eg_subcontentbg" nowrap>&nbsp; <%= info %>
											<input type=hidden name='tempinfo<%= count %>' value='<%= state %>'>
											<input type='hidden' name='hiddeninfo<%= count %>' value='<%= info %>'></td>
<%
				String tempInfo = info;
				if (tempInfo != null && tempInfo.indexOf("#") > -1)
				{
					tempInfo = StringUtils.replace(tempInfo,"#","0eGHash1");
				}
				String s = test+":"+comp.substring(comp.indexOf(":")+1)+"#"+tempInfo;
				String s1 = trans.getStrValue("DESCRIPTOR_THRESHOLDS", s);
				// user threshold          - Thirumal
				if (s1 == null || s1.length() == 0 && (vec != null && vec.size() > 0))
				{
					if (vec.contains(info) && serverGroup != null && serverGroup.size() > 0)
					{
						String policyName = descGrp.getPolicyForTest((String)serverGroup.get(0),test,info);
						s1 = descGrp.getPolicyValue(policyName);
						if (s1 != null && s1.length() > 0)
							confInfo = "yes";
					}
				} // ends here
%>
										<td id="<%=border?"form_border":"form_spacing"%>" class="eg_subcontentbg" align='right' height='32' nowrap colspan="3">&nbsp;
<%
				if(!(source.equalsIgnoreCase("testinfo")))
				{
%>
<%
					if(!(s1.equals("")) && (s1 != null) && !confInfo.equalsIgnoreCase("yes"))
					{
%>
											&nbsp;<input type="button" name="del<%=cnt%>" value='<egui:intnl text="admin.common.Delete"/>' style="width: 80px;height: 20px;" class="eg_lightbutton" onClick="javascript:deleteThresh('<%= info1 %>')"> &nbsp; 
<%
					}
%>
											&nbsp;<input type="button" name="mod<%=cnt%>" value='<egui:intnl text="admin.common.Modify"/>' style="width: 80px;height: 20px;" class="eg_lightbutton" onClick="javascript:call('<%= info1 %>','<%= confInfo %>')">&nbsp; 
<%
					out.println("</td>");
					cnt++;
				}

				if(source.equalsIgnoreCase("testinfo"))
				{
%>
					<!--<td background="images/bkimg.gif">&nbsp;</td>-->
					<!--<td background="images/bkimg.gif">&nbsp;</td>
					<td background="images/bkimg.gif">&nbsp;</td>
						-->
<%
				}
%>
										</td>
									</tr><!-- The gap tr ends here-->
									<tr>
										<td colspan="3" id="eg_blankspace" class="eg_subcontentbg">&nbsp;</td>
									</tr><!-- The gap tr ends here-->

					<!-- Replication ends here-->
<%
			}
			session.setAttribute("disabledDesc", al_disabled);
			session.setAttribute("enabledDesc", al_enabled);
%>
									<tr>
										<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
										<td id="eg_subcontentbg"  width="100%"  valign="top" ><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
										<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="0px" height="6px" border="0"></td>
									</tr>
<%
			if(!(source.equalsIgnoreCase("threshinfo")) )
			{
%>
									<tr>
										<td colspan="3" class="eg_whitebg">&nbsp;</td>
									</tr>
									<tr>
										<td width="7" height="15" id="form_spacing" nowrap class="eg_whitebg">&nbsp;</td>
<%
				if(!ht.isEmpty())
				{
%>
										<td height="15" align="center" nowrap class="eg_whitebg">&nbsp;<input type="button" name="update" value='<egui:intnl text="admin.common.Update"/>' style="width: 80px;" class="eg_back"  onClick="javascript:populate()" >
										</td>
<%
				}
%>
										<td width="8" height="15" class="eg_whitebg" nowrap>&nbsp;</td>
									</tr>
<%
			}
%>
								</table>
							</td>
						</tr>
					</table>

<%
		//Vijay write this condition
		}
%>
			<input type='hidden' name='server' value='<%= server %>'>
			<input type='hidden' name='comp' value='<%= comp %>'>
			<input type='hidden' name='duration' value='<%= selection %>'>
			<input type='hidden' name='test' value='<%= test %>'>
			<input type="hidden" name="value" value='<%=value%>'>
			<input type="hidden" name="delete1" value='<%=delete%>'>
			<input type='hidden' name='selectedDesc' value=''>
			<input type='hidden' name='initiallySelectedDesc' value=''>
				</form>
<%
	}
%>
					</td>
				</tr>
			</table>
		</td>
	</tr>
</table>
<script language="JavaScript">
	myForm = window.document.list;
	selectedNow ="";
	for(i=0;i<myForm.elements.length;i++)
	{
		if(myForm[i].type == 'checkbox' && myForm[i].checked)
		{
			if(selectedNow.length==0)
				selectedNow = myForm[i].value;
			else
				selectedNow += "," + myForm[i].value;
		}
	}
	if(selectedNow.length>0)
	{
		myForm.initiallySelectedDesc.value = selectedNow;
	}
</script>
</form>
</body>
</html>

<%!
	public String [] tokenizeInfo(String str)
	{
		String [] infoArray = null;
		StringTokenizer st = new StringTokenizer(str, ",");
		int count = st.countTokens();
		infoArray = new String[count];
		for(int i=0; i<count; i++)
		{
			infoArray[i] = st.nextToken();
		}
		return infoArray;
	}
%>
<%
session.setAttribute("adminLastAccessedURL","/final/admin/EgUpdateInfo.jsp?"+request.getQueryString());
%>



