<%
/*******************************************************************************
*   Name						:EgTimeBarJson.jsp
*   Purpose						:To collect Manager Time details 
*   Version						:6.0
*   Created						:21.7.2014
*   Author						:Antony & Team
*******************************************************************************/
%>
<%@ page import = "egurkha.reporter.*"%>
<%@ page import="com.egurkha.*" %>
<%@ page import = "java.util.Date"%>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.eg.EgDateInfo"%>
<%@ page import = "java.util.Calendar"%>
<%@ page import = "java.util.TimeZone"%>
<%@ page import = "com.eg.EgInstallInfo"%>
<%@ page import = "com.egurkha.util.DateUtil"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "com.egurkha.EgTimeZoneConverter"%>
<%@ page import="net.sf.json.*" %>
<%@ page language="java" contentType="application/json; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>

<%
try
{
	IniFile egUI = new IniFile(EgInstallInfo.getInstallDir()+ "/manager/config/eg_ui.ini");
	String currentDateFormat = egUI.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	User user = null;
	String uname=request.getParameter("uname");	
	ErUserData userData = new ErUserData(uname,false);
	if(userData!=null)
	{
		user=userData.usr;
		if(user==null)
		{
			user = userData.getUser(uname);
		}
	}		
	EgDateInfo egDate = new EgDateInfo();

	Date local_date = new Date(egDate.egetUTCDate());
	Calendar cal = Calendar.getInstance();
	cal.setTime(local_date);
	cal.setTimeZone(egDate.getRealTimeZone());
	String temp = (cal.get(cal.MONTH)+1) + "/" + cal.get(cal.DAY_OF_MONTH) + "/" +cal.get(cal.YEAR);
	String dispDate = DateUtil.changeDateFormat(temp,"MM/dd/yyyy",currentDateFormat);
	String mgr_time = cal.get(cal.HOUR_OF_DAY)+":"+cal.get(cal.MINUTE)+":"+cal.get(cal.SECOND);
	TimeZone tz = egDate.getRealTimeZone();
	String tzName = tz.getDisplayName(tz.inDaylightTime(local_date), TimeZone.SHORT);
	EgTimeZoneConverter timeZoneConverter = new EgTimeZoneConverter(dispDate+" "+mgr_time,user);
	String loginUserDateTime = (String)timeZoneConverter.getDate(false);
    Date loginUserDate = (Date)timeZoneConverter.getDate(true);
    TimeZone user_tz = (TimeZone)timeZoneConverter.getTimeZone();
    if( loginUserDateTime != null && !loginUserDateTime.trim().equals(""))
    {
    	dispDate = loginUserDateTime;
		tzName = user_tz.getDisplayName(user_tz.inDaylightTime(loginUserDate), TimeZone.SHORT);
    }

	JSONObject rootJson=new JSONObject();
	rootJson.put("dispDate",dispDate);
	rootJson.put("s_yr",timeZoneConverter.getYear(true));
	rootJson.put("s_mon",timeZoneConverter.getMonth());
	rootJson.put("s_day",timeZoneConverter.getDay());
	rootJson.put("s_hr",timeZoneConverter.getHour());
	rootJson.put("s_min",timeZoneConverter.getMinute());
	rootJson.put("s_sec",timeZoneConverter.getSecond());
	out.println(rootJson.toString());
}
catch(Exception e)
{
	e.printStackTrace();
}
%>
