<%
/***********************************************************************************
*	Name			:	EgSettingsTree.jsp
*	Purpose			:	This page enables the administrator to define the settings for the different activities performed by the eG manager
*	Version			:	5.2
*	CreationDate	:	20/3/2012
*	Author			:	Chittibabu.k
***********************************************************************************/
%>

<%@ include file="EgTrackerA.jsp" %>
<%@ page errorPage="EgProbs.jsp"%>
<%@ taglib prefix = "egui" uri = "../WEB-INF/eg-taglib.tld" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	String treeViewSrc=request.getParameter("treeViewSrc");
	String process =request.getParameter("process");
	
	String highLightNode="";
	if (process==null || process.equalsIgnoreCase("null"))
	{
		treeViewSrc="./EgSettingsHomepage.jsp";
	}

	//egui.jsp
	else if (process.equals("refresh"))
	{	
		treeViewSrc="./egui.jsp?process=refresh&from=monitree";
		highLightNode="Refresh";
	}
	else if(process.equals("alarms"))
	{	
		treeViewSrc="./egui.jsp?process=alarms&from=monitree";
		highLightNode="Alarms";
	}
	else if(process.equals("graphs"))
	{
		treeViewSrc="./egui.jsp?process=graphs&from=monitree";
		highLightNode="Graphs";
	}
	else if(process.equals("othersettings"))
	{
		treeViewSrc="./egui.jsp?process=othersettings&from=monitree";
		highLightNode="Other Settings";
	}
	
	//minmaxConfig.jsp
	else if(process.equals("enable/disable"))
	{
		treeViewSrc="./minmaxConfig.jsp?process=enable/disable&from=monitree";
		highLightNode="Enable/Disable Metrics";
	}
	else if(process.equals("new"))
	{
		treeViewSrc="./minmaxConfig.jsp?process=new&from=monitree";
		highLightNode="Add a New Measure";
	}
	else if(process.equals("existingmeasure"))
	{
		treeViewSrc="./minmaxConfig.jsp?process=existingmeasure&from=monitree";
		highLightNode="Configured Measures";
	}
	else if(process.equals("AllMeasures"))
	{
		treeViewSrc="./minmaxConfig.jsp?process=AllMeasures&from=monitree";
		highLightNode="Measures";
	}

	//managersettings.jsp
	else if(process.equals("general"))
	{
		treeViewSrc="./managerSettings.jsp?process=general&from=mgrstree";
		highLightNode="General";
	}
	else if(process.equals("testconfig"))
	{
		treeViewSrc="./managerSettings.jsp?process=testconfig&from=mgrstree";
		highLightNode="Test Configuration";
	}
	else if(process.equals("logsettings"))
	{
		treeViewSrc="./managerSettings.jsp?process=logsettings&from=mgrstree";
		highLightNode="Log Settings";
	}
	else if(process.equals("discompopup"))
	{
		treeViewSrc="./managerSettings.jsp?process=discompopup&from=mgrstree";
		highLightNode="Discovered Components pop_up";
	}
	else if(process.equals("ttmanagercli"))
	{
		treeViewSrc="./managerSettings.jsp?process=ttmanagercli&from=mgrstree";
		highLightNode="TT Manager CLI";
	}
	else if(process.equals("commandexecution"))
	{
		treeViewSrc="./managerSettings.jsp?process=commandexecution&from=mgrstree";
		highLightNode="Command Execution";
	}
	else if(process.equals("auditing"))
	{
		treeViewSrc="./managerSettings.jsp?process=auditing&from=mgrstree";
		highLightNode="auditing";
	}
	else if(process.equals("thresholdconfig"))
	{
		treeViewSrc="./managerSettings.jsp?process=thresholdconfig&from=mgrstree";
		highLightNode="Threshold Configuration";
	}
	else if(process.equals("advancedmgrsettings"))
	{
		treeViewSrc="./managerSettings.jsp?process=advancedmgrsettings&from=mgrstree";
		highLightNode="Advanced Manager Settings";
	}
	else if(process.equals("capacityplanning"))
	{
		treeViewSrc="./managerSettings.jsp?process=capacityplanning&from=mgrstree";
		highLightNode="Capacity Planning";
	}
	//logo / msg.jsp
	else if(process.equals("loginscreen"))
	{
		treeViewSrc="./EgConfigLogoMsg.jsp?process=loginscreen&from=logotree";
		highLightNode="Login Screen";
	}
	else if(process.equals("monitorinterface"))
	{
		treeViewSrc="./EgConfigLogoMsg.jsp?process=monitorinterface&from=logotree";
		highLightNode="Monitor Interface";
	}
	else if(process.equals("reporterinterface"))
	{
		treeViewSrc="./EgConfigLogoMsg.jsp?process=reporterinterface&from=logotree";
		highLightNode="Reporter Interface";
	}
	else if(process.equals("configmanageinterface"))
	{
		treeViewSrc="./EgConfigLogoMsg.jsp?process=configmanageinterface&from=logotree";
		highLightNode="Configration Management Interface";
	}
	else if(process.equals("audiblealerts"))
	{
		treeViewSrc="./EgConfigLogoMsg.jsp?process=audiblealerts&from=logotree";
		highLightNode="Audible Alerts";
	}
	else if(process.equals("messages"))
	{
		treeViewSrc="./EgConfigLogoMsg.jsp?process=messages&from=logotree";
		highLightNode="Messages";
	}
	
%>
<html>
<head>
<title>
</title>
<egui:skin ui="admin"/>
<script language="javascript" src="/final/admin/eg_scripts/MonitorTree.js"></script>
<script language="JavaScript1.2" src="/final/jquery/jquery.js"></script>
<script language="JavaScript">
function closeMenu()
{
	var menu=document.getElementById("menu");
	menu.style.display='none';
}

function iframeOnLoad()
{
	
	try
	{
		var viewIframe= document.getElementById("MonitorView").contentWindow.document.body;
		var treeIframe=document.getElementById("MonitorTree").contentWindow.document.body;
		
		if(treeIframe!=null)
		{
			treeIframe.onclick=closeMenu;
		}
		if(viewIframe!=null)
		{
			viewIframe.onclick = closeMenu;
		}

		divResize();

	}
	catch(Exception)
	{}
}

function iframeOnLoadTree()
{
	var mainIframe = document.getElementById("MonitorTree");
	var treeUrlObj = document.getElementById("treeUrl");
	if (mainIframe != null && mainIframe != undefined && treeUrlObj!=null )
	{
		mainIframe.src = treeUrlObj.value;
	}

	var MonitorView = document.getElementById("MonitorView");
	var infraViewUrl = document.getElementById("infraViewUrl");
	if (MonitorView != null && MonitorView != undefined && infraViewUrl!=null )
	{
		MonitorView.src = infraViewUrl.value;
	}
}

function closeDetailsDiv()
{
	var detailsDiv=document.getElementById("detailsDiv");
	if(detailsDiv!=null)
	{
		detailsDiv.style.display="none";
	}
}

//----------New Script added by Jaiwin---------

var $j = jQuery.noConflict();

$j(document).ready(function(){
	$j("#expand").click(function(){
		$j(".treeDivMain").toggle();
		divResize();
			var treeDivMainObj=$j(".treeDivMain").css("display");
			if(treeDivMainObj!=null && treeDivMainObj=='none')
			{
				$j(".split_right").attr({src:"/final/admin/eg_images/<%=admin_Skin%>/split_right.gif"});
			}
			else if(treeDivMainObj!=null && treeDivMainObj=='block')
			{
				$j(".split_right").attr({src:"/final/admin/eg_images/<%=admin_Skin%>/split_left.gif"});
			}
	});
	iframeOnLoadTree();
});

function divResize(){

	var winWidth = $j(window).width();
	var winHeight = $j(window).height();

	$j(".mainDiv").width(winWidth);
	$j(".mainDiv").height(winHeight);

	var treeDivMainObj=$j(".treeDivMain").css("display");
	var infraViewDivObj=$j(".infraViewDiv").css("display");

	if (infraViewDivObj!=null && infraViewDivObj=='block' && treeDivMainObj!=null && treeDivMainObj=='block')
	{
		$j(".treeDivMain").width((winWidth*(20/100))-10);
		$j(".treeDivMain").height(winHeight-11);
		$j(".lrImageDiv").height(winHeight-18);

		$j(".treeDivInner").width((winWidth*(20/100))-12);
		$j(".treeDivInner").height(winHeight-35);

		$j(".infraViewDiv").width((winWidth*(80/100))-10);
		$j(".infraViewDiv").height(winHeight-13);

		$j(".infraViewDivIframe").width((winWidth*(80/100))-10);
		$j(".infraViewDivIframe").height(winHeight-13);

		$j(".mainDiv").css("padding", "6px");

		$j("#dividerImgChange").removeClass('dividerRight').addClass('dividerLeft');
	}
	else if (infraViewDivObj!=null && infraViewDivObj=='block' && treeDivMainObj!=null && treeDivMainObj=='none')
	{
		$j(".infraViewDiv").width(winWidth-15);
		$j(".infraViewDiv").height(winHeight-13);

		$j(".infraViewDivIframe").width(winWidth-15);
		$j(".infraViewDivIframe").height(winHeight-13);

		$j(".mainDiv").css("padding", "6px 6px 6px 0px");

		$j(".lrImageDiv").height(winHeight-18);
		$j("#dividerImgChange").removeClass('dividerLeft').addClass('dividerRight');
	}
}

$j(window).resize(function(){
	divResize();
	iframeOnLoad();
});

//----------------------

function getDetailsDivObj()
{
	return document.getElementById("detailsDiv");
}


</SCRIPT>
</head>
<BODY style="overflow:hidden" class="innerbg" leftmargin="0px" marginwidth="0px" marginheight="0px">

<input type="hidden" name="treeUrl" id="treeUrl" value="/final/admin/EgSettingsTreeUI.jsp?highLightNode=<%=highLightNode%>" style="padding:0px;margin:0px"/>
<input type="hidden" name="infraViewUrl" id="infraViewUrl" value="<%=treeViewSrc%>"/>

<div id="menu" style="position:absolute;width:40px;height:20px;visibility:visible;display:none;z-index:1000;">
</div>

<div style="width:900px;height:540px;padding:6px;border:0px solid red;display:inline-block" class="mainDiv">

	<div class="treeDivMain" style="float:left;width:200px;height:500px;border:0px solid green;display:block;position:relative;padding:0px;margin:0px;">
		<div class="eg_subhead" width="100%" style="display:inline;position:relative;border:0px solid blue">
			<table width="100%" cellspacing="0" cellpadding="0" border="0" height="22">
				<tr>
					<td id="subhead_left" width="7"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7"></td>
					<td width="100%" align="center" id="eg_subheadbg" style="border-left-width:0px;border-right-width:0px"> <strong> <egui:intnl text="admin.settings.Settings"/></strong></td>
					<td align="right" valign="middle" id="eg_subheadbg">&nbsp;</td>
					<td id="subhead_right" width="7"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7"></td>
				</tr>
			</table>
		</div>
		
		<div class="linesquare eg_whitebg" style="align:left;padding:0px;margin:0px;">
			<iframe id="MonitorTree" class="treeDivInner" style="width:180px;height:500px;overflow-x:auto;overflow-y:auto;" width="180px" height="500px"  FRAMEBORDER="0" marginheight="0px" scrolling="auto" marginwidth="0px" onload="javascript:iframeOnLoad();"></iframe>
		</div>
	</div>

	<div class="lrImageDiv" style="border:0px solid blue;width:6px;float:left;height:500px">
		<div style="position:relative;top:45%"><img id="expand" src="/final/admin/eg_images/<%=admin_Skin%>/split_left.gif" width="6px" height="50px" border="0"  class="split_right mouse" /></div>
	</div>

	<div class="infraViewDiv linesquare eg_whitebg" style="float:left;width:600px;height:500px;display:block;position:relative;">
		 <iframe id="MonitorView" class="infraViewDivIframe" style="width:600px;height:500px;overflow-x:auto;overflow-y:auto;"  width="600px" height="500px"  FRAMEBORDER="0" marginheight="0px" scrolling="auto" marginwidth="0px" onload="javascript:iframeOnLoad();" ></iframe>
	</div>
</div>

<!-- This div for highlight the node by process  -->
<div id="treeSelectionDiv" name="treeSelectionDiv" style="display:none"></div>
</BODY>
</HTML>



