<%@ include file="../../../admin/EgTrackerAJSON.jsp"%>

<%@ page import = "com.eg.EgCrypt" %>
<%@ page import = "com.eg.EgInstallInfo"%>
<%@ page import = "net.sf.json.*"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
/*
*	This page helps to load the data for Cloud  node in Discovery tree.
*	ini File : eg_services.ini, subject : VCLOUD_DIRECTOR
*/
%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json");

	JSONObject rootJson = new JSONObject();

	String cloudDirectory = "VCLOUD_DIRECTOR";

	IniFile services = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_services.ini");
	String[] vClouds = services.getVariables(cloudDirectory);

	String from = request.getParameter("from");


	JSONArray mComboArray = new JSONArray();

	JSONObject mJson = new JSONObject();
	mJson.put("displayField","View configured vCloud Directors");
	mJson.put("valueField","VIEW");
	mComboArray.add(mJson);

	mJson.put("displayField","Add new vCloud Directors");
	mJson.put("valueField","ADD");
	mComboArray.add(mJson);

	mJson.put("displayField","Modify configured vCloud Directors");
	mJson.put("valueField","MODIFY");
	mComboArray.add(mJson);

	mJson.put("displayField","Delete configured vCloud Directors");
	mJson.put("valueField","DELETE");
	mComboArray.add(mJson);

	rootJson.put("mComboArray",mComboArray);

	rootJson.put("emptyMessage",_mapping.getTextDescription("admin.discovery.No vCloud Director servers are available currently"));

	if(from != null && (from.equals("viewvCloud") || from.equals("delvCloud")))
	{		
		JSONObject columns = new JSONObject();		
		columns.put("IP/Host",_mapping.getTextDescription("admin.discovery.IP/Host"));
		columns.put("SSL",_mapping.getTextDescription("admin.discovery.SSL"));
		columns.put("Discovery Enabled",_mapping.getTextDescription("admin.discovery.Discovery Enabled"));
		columns.put("VM",_mapping.getTextDescription("admin.discovery.VM"));
		columns.put("User",_mapping.getTextDescription("admin.discovery.User"));		
		if (from.equalsIgnoreCase("delvCloud"))
		{
			columns.put("delOption","");
		}		
		if(vClouds != null && vClouds.length > 0)
		{
			JSONArray gridArray = new JSONArray();
			for(int i = 0; i < vClouds.length; i++)
			{
				String ip = vClouds[i];
				String value = services.getValue(cloudDirectory,ip);

				StringTokenizer st = new StringTokenizer(value,"#");
				int counts = st.countTokens();
				if(counts == 5)
				{
					String ssl = st.nextToken();
					String user = st.nextToken();
					String pwd = st.nextToken();
					String discover = st.nextToken();
					String vm=st.nextToken();

					if(ssl != null && (ssl.equalsIgnoreCase("Yes") || ssl.equalsIgnoreCase("True")))
						ssl = "Yes";
					else
						ssl = "No";

					if(discover != null && (discover.equalsIgnoreCase("Yes") || discover.equalsIgnoreCase("True")))
						discover = "Yes";
					else
						discover = "No";
					
					if(vm != null && (vm.equalsIgnoreCase("Yes") || vm.equalsIgnoreCase("True")))
						vm = "Yes";
					else
						vm = "No";


					JSONObject json = new JSONObject();

					json.put("IP/Host",ip);
					json.put("SSL",ssl);
					json.put("Discovery Enabled",discover);
					json.put("VM",vm);
					json.put("User",user);
					if (from.equalsIgnoreCase("delvCloud"))
					{
						json.put("delOption",ip);
					}
					gridArray.add(json);
				}
			}
			rootJson.put("gridArray",gridArray);
			rootJson.put("columns",columns);
			rootJson.put("gridTitle",_mapping.getTextDescription("admin.discovery.vCloud Director Cells"));
		}
	}
	else if(from != null && from.equals("getAllvCloud"))
	{
		JSONArray comboArray = new JSONArray();

		JSONObject json = new JSONObject();
		json.put("displayField","Choose a vCloud Director");
		json.put("valueField","-1");
		comboArray.add(json);

		if(vClouds != null && vClouds.length > 0)
		{
			for(int i = 0; i < vClouds.length; i++)
			{
				String ip = vClouds[i];
				json = new JSONObject();
				json.put("displayField",ip);
				json.put("valueField",ip);
				comboArray.add(json);
			}
		}
		rootJson.put("comboArray",comboArray);
	}
	else if(from != null && from.equals("getvCloudDetails"))
	{
		String ip = request.getParameter("vclouds");
		String value = services.getValue(cloudDirectory,ip);
		if(ip != null && value != null)
		{
			StringTokenizer st = new StringTokenizer(value,"#");
			int counts = st.countTokens();
			if(counts == 5)
			{
				String ssl = st.nextToken();
				String user = st.nextToken();
				String pwd = st.nextToken();
				String discover = st.nextToken();
				String vm=st.nextToken();

				if(ssl != null && (ssl.equalsIgnoreCase("Yes") || ssl.equalsIgnoreCase("True")))
				{
					ssl = "Yes";
				}
				else
				{
					ssl = "No";
				}

				if(discover != null && (discover.equalsIgnoreCase("Yes") || discover.equalsIgnoreCase("True")))
				{
					discover = "Yes";
				}
				else
				{
					discover = "No";
				}
				if(vm != null && (vm.equalsIgnoreCase("Yes") || vm.equalsIgnoreCase("True")))
				{
					vm = "Yes";
				}
				else
				{
					vm = "No";
				}
				pwd = EgCrypt.decrypt(pwd);

				JSONObject json = new JSONObject();
				json.put("ssl",ssl);
				json.put("user",user);
				json.put("pwd",pwd);
				json.put("discover",discover);
				json.put("vm",vm);
				rootJson.put("json",json);
			}
		}
	}

	session.setAttribute("adminLastAccessedURL","/final/admin/EgDiscoveryPane.jsp?selectedNode=node11");

	out.println(rootJson.toString());


%>