
<%@ include file="../../../admin/EgTrackerAJSON.jsp"%>

<%@ page import = "net.sf.json.JSONObject"%>
<%@ page import = "net.sf.json.JSONArray"%>

<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%!
	public ArrayList getvCenterDetails()
	{
		// 1) Going to iterate eg_agents.ini thru remote agents sections
		// 2) Under each remote agent,Collecting all vars & vals
		// 3) If any val has "-virtual_center" param then parse the val to collect the vCenter name and var for ESX name
		IniFile agentsIni = new IniFile(EgConfigInfo.egMgrConfigDir+"eg_agents.ini");
		EgExternalInfo ext = new EgExternalInfo("manager");
		String[] rmtAgents = ext.getAllRemoteAgents();
		int remLen = rmtAgents.length;
		String vCenterParam = "-virtual_center";
		int vCParamLen = vCenterParam.length();
		HashMap vcEsxMap = new HashMap();
		HashMap vCRmtAgentMap = new HashMap();
				
		for (int r=0; r<remLen; r++)
		{
			String rmtAgent = rmtAgents[r];
			String[] allVars =  agentsIni.getVariables(rmtAgent);
			Vector allValues = agentsIni.getAllValues(rmtAgent);
			if (allValues != null)
			{
				int allValuesSize = allValues.size(); 
				for(int a=0; a<allValuesSize; a++)
				{
					String value = allValues.get(a).toString();
					int vCIdx =  value.indexOf(vCenterParam);
					if (vCIdx != -1)
					{
						String vCname =  value.substring(vCIdx+vCParamLen).trim();
						vCname = vCname.substring(0,vCname.indexOf(" ")).trim();
						if (vCname.trim().equalsIgnoreCase("none"))
							continue;
						String esxname = allVars[a];
						if (esxname.endsWith(":NULL"))
						{
							esxname = esxname.substring(0,esxname.indexOf(":NULL"));
						}
						esxname = esxname.substring(esxname.lastIndexOf(":")+1);
						//vcEsxMap
						if (vcEsxMap.containsKey(vCname))
						{
							ArrayList exsList = (ArrayList)vcEsxMap.get(vCname);
							if (!exsList.contains(esxname))
							{
								exsList.add(esxname);
							}
							vcEsxMap.put(vCname,exsList);
						}
						else
						{
							ArrayList exsList = new ArrayList();
							exsList.add(esxname);
							vcEsxMap.put(vCname,exsList);
						}

						//vCRmtAgentMap
						if (vCRmtAgentMap.containsKey(vCname))
						{
							ArrayList rmtList = (ArrayList)vCRmtAgentMap.get(vCname);
							if (!rmtList.contains(rmtAgent))
							{
								rmtList.add(rmtAgent);
							}
							vCRmtAgentMap.put(vCname,rmtList);
						}
						else
						{
							ArrayList rmtList = new ArrayList();
							rmtList.add(rmtAgent);
							vCRmtAgentMap.put(vCname,rmtList);
						}						
					}
				}
			}
		}
		// vcRemEsxMap > vCName={remEsxMap}
		// remEsxMap > remoteAgent= Esx1,Esx2,... // Esx hosts (below this vCenter) managed by this remote agent
		HashMap vcRemEsxMap = new HashMap();
		Iterator it = vcEsxMap.keySet().iterator();
		while(it.hasNext())
		{
			String vc = it.next().toString();
			ArrayList esxList = (ArrayList)vcEsxMap.get(vc);
			HashMap remEsxMap = new HashMap();
			for (int e=0; e<esxList.size(); e++)
			{
				String esx = (String)esxList.get(e);
				String rem = ext.getRemoteAgentForHost(esx);
				if (remEsxMap.containsKey(rem))
				{
					ArrayList tmpEsxList = (ArrayList)remEsxMap.get(rem);
					if (!tmpEsxList.contains(esx))
					{
						tmpEsxList.add(esx);
						remEsxMap.put(rem,tmpEsxList);
					}
				}
				else
				{
					ArrayList tmpEsxList = new ArrayList();
					tmpEsxList.add(esx);
					remEsxMap.put(rem,tmpEsxList);
				}				
			}
			vcRemEsxMap.put(vc,remEsxMap);
		}
		
		ArrayList result = new ArrayList();
		result.add(vcEsxMap);
		result.add(vCRmtAgentMap);
		result.add(vcRemEsxMap);
		
		return result;	
	}
%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	JSONObject rootObj = new JSONObject();
	JSONArray userDetailsGrid = new JSONArray();
	EgExternalInfo extInfo = new EgExternalInfo("manager");
	//For CSV
	List csvData = new ArrayList();
	csvData.add("vCenter - Remote Agents Mapping Report");
	csvData.add("");


	String selVCenter = request.getParameter("vCenter");
	if (selVCenter == null)
		selVCenter = "all";
	
	EgServicesInfo services = new EgServicesInfo("manager");
	String[] vCentersArr = services.getAllVCenters();
	
	JSONArray vCenterArr = new JSONArray();
	JSONObject vCenterObj = new JSONObject();
	vCenterObj.put("valueField","all");
	vCenterObj.put("displayField",_mapping.getTextDescription("admim.user.All"));
	vCenterArr.add(vCenterObj);

	if (vCentersArr != null)
	{
		List vCenterList = Arrays.asList(vCentersArr);
		Collections.sort(vCenterList,String.CASE_INSENSITIVE_ORDER);
		vCentersArr = (String[]) vCenterList.toArray(new String[0]);

		for(int v=0; v<vCentersArr.length; v++)
		{
			vCenterObj = new JSONObject();
			vCenterObj.put("valueField",vCentersArr[v]);
			vCenterObj.put("displayField",vCentersArr[v]);
			vCenterArr.add(vCenterObj);
		}
	}
	rootObj.put("vCenterArr",vCenterArr);
	rootObj.put("selectedVCenter",selVCenter);
	csvData.add("vCenter,"+selVCenter);
	csvData.add("");

	HashMap vcEsxMap = new HashMap();
	HashMap vcRemMap = new HashMap();
	HashMap vcRemEsxMap = new HashMap();
	TreeMap gridMap = new TreeMap();

	if (selVCenter.equals("all"))
	{
		ArrayList resultList = getvCenterDetails();
		vcEsxMap = (HashMap)resultList.get(0);
		vcRemMap = (HashMap)resultList.get(1);
		vcRemEsxMap = (HashMap)resultList.get(2);

		if (vCentersArr != null)
		{
			for (int v=0; v<vCentersArr.length; v++)
			{
				String vCenter = vCentersArr[v];
				if (!vcRemMap.containsKey(vCenter))
				{
					vcRemMap.put(vCenter,new ArrayList());	
				}
				if (!vcEsxMap.containsKey(vCenter))
				{
					vcEsxMap.put(vCenter,new ArrayList());
				}
			}
		}
		gridMap = new TreeMap(vcRemMap);
		session.setAttribute("vCenterInfo",resultList);
	}
	else
	{
		ArrayList resultList = (ArrayList)session.getAttribute("vCenterInfo");
		if (resultList == null || resultList.size() ==0)
		{
			resultList = getvCenterDetails();
		}
		vcEsxMap = (HashMap)resultList.get(0);
		vcRemMap = (HashMap)resultList.get(1);
		vcRemEsxMap = (HashMap)resultList.get(2);
		HashMap tmpMap = new HashMap();
		if (vcRemMap.containsKey(selVCenter))
		{
			ArrayList tmpRemAgnts = (ArrayList)vcRemMap.get(selVCenter);
			tmpMap.put(selVCenter,tmpRemAgnts);
		}
		else
		{
			tmpMap.put(selVCenter,new ArrayList());
		}
		gridMap = new TreeMap(tmpMap);		
	}


	//Iterator itt = vcRemEsxMap.keySet().iterator();
	//while(itt.hasNext())
	//{
		//String vc = itt.next().toString();
		//HashMap remEsx= (HashMap)vcRemEsxMap.get(vc);
	//}

	csvData.add("vCenter,Remote agents count,Remote agents (Managed ESX Hosts count),ESX Hosts Count,ESX Hosts (Remote agent)");
	csvData.add("");
	csvData.add("");

	Iterator it = gridMap.keySet().iterator();
	while(it.hasNext())
	{
		String vCenterName = it.next().toString();
		ArrayList rmtAgentsList = (ArrayList)gridMap.get(vCenterName);
		ArrayList esxAgentsList = (ArrayList)vcEsxMap.get(vCenterName);
		HashMap vcEsxRmtAgentsMap = (HashMap)vcRemEsxMap.get(vCenterName);
		int rmtAgentsSize = rmtAgentsList.size();
		int esxAgentsSize = esxAgentsList.size();
		Collections.sort(rmtAgentsList);
		JSONObject tmpObj = new JSONObject();
		tmpObj.put("vCenterName",vCenterName);
		tmpObj.put("Count",rmtAgentsSize);
		tmpObj.put("isAgentsAssociated",false);
		tmpObj.put("AssignedAgents","-");
		tmpObj.put("AssignedEsx","-");
		tmpObj.put("TotalEsxCount","");
		String tmpCsvRmtAgt = "";
		if (rmtAgentsSize > 0)
		{
			//tmpObj.put("isAgentsAssociated",true);

			JSONArray remAgentsArr = new JSONArray();
			for(int r=0; r<rmtAgentsSize; r++)
			{
				String remAgent = rmtAgentsList.get(r).toString();
				remAgentsArr.add("<a class=\"eg_monlink\" href= '/final/admin/EgRemoteAgents.jsp?from=Discovery&fromAssignRem=true&eagent="+EgURLEncoder.encode(remAgent,"UTF-8")+"' style=\"text-decoration:none\">"+remAgent+"</a>");

				if(r  == 0)
				{
					tmpCsvRmtAgt = remAgent;
				}
				else
				{
					tmpCsvRmtAgt = tmpCsvRmtAgt +", "+remAgent;
				}
			}
			tmpObj.put("AssignedAgents",remAgentsArr);

		}
		else
		{
			tmpCsvRmtAgt = "-";
		}

		String tmpCsvEsxAgt = "";
		if (esxAgentsSize > 0)
		{
			tmpObj.put("isAgentsAssociated",true);
			tmpObj.put("TotalEsxCount",esxAgentsSize);

			JSONArray esxAgentsArr = new JSONArray();
			for(int e=0; e<esxAgentsSize; e++)
			{
				String esxAgent = esxAgentsList.get(e).toString();
				esxAgentsArr.add(" "+esxAgent);
			}
			tmpObj.put("AssignedEsx",esxAgentsArr);
		}
		TreeMap vcEsxRmtAgents =  new TreeMap();
		if(vcEsxRmtAgentsMap != null)
		{
			vcEsxRmtAgents = new TreeMap(vcEsxRmtAgentsMap);
		}
		if (vcEsxRmtAgents.size() > 0)
		{
			StringBuffer sb = new StringBuffer();
			Iterator it2 = vcEsxRmtAgents.keySet().iterator();
			while(it2.hasNext())
			{
				String vcESXRmtAgent = it2.next().toString();
				if (vcESXRmtAgent != null)
				{
					ArrayList vcEsxHostsList = (ArrayList) vcEsxRmtAgents.get(vcESXRmtAgent);
					String tmpEsxList =vcEsxHostsList.toString();
					String tmpString = tmpEsxList.substring(1,tmpEsxList.length()-1);
					sb.append("<br>");
					sb.append("<b style='font-weight:bold'>"+vcESXRmtAgent+" ("+vcEsxHostsList.size()+")</b>");
					sb.append("<br>");
					sb.append(tmpString);
					sb.append("<br>");					
				}
			}
			tmpObj.put("TotalClubEsxHosts",sb.toString());
		}
		userDetailsGrid.add(tmpObj);
		
		// For CSV 
		String remCntTmp=rmtAgentsSize+"";
		if (rmtAgentsSize == 0)
			remCntTmp="-";
		String esxCntTmp=esxAgentsSize+"";
		if (esxAgentsSize == 0)
			esxCntTmp="-";
		if(rmtAgentsSize == 0 && esxAgentsSize==0)
			csvData.add(vCenterName+","+remCntTmp+",,"+esxCntTmp+",");
		
		HashMap remEsxTmpMap = new HashMap();
		if(vcEsxRmtAgentsMap != null)
			remEsxTmpMap =  (HashMap)vcEsxRmtAgentsMap.clone();
		int cnt = (rmtAgentsSize>esxAgentsSize)?rmtAgentsSize:esxAgentsSize;
		for (int c=0; c<cnt; c++)
		{
			String remote = "";
			String esx = "";
			if (rmtAgentsList.size() > c)
				remote = rmtAgentsList.get(c).toString();
			if (esxAgentsList.size() > c)
				esx = esxAgentsList.get(c).toString();
			String rmtAgent = extInfo.getRemoteAgentForHost(esx);
			ArrayList esxHostsList = new ArrayList();
			if(vcEsxRmtAgentsMap != null && remote != null && !remote.trim().equals(""))
			{
				esxHostsList = (ArrayList)vcEsxRmtAgentsMap.get(remote);
			}
			int esxCnt = esxHostsList.size();
			String tmpRemote = remote;
			if(esxCnt >0)
				tmpRemote+=" ("+esxCnt+")";
			if(c==0)
			{
				csvData.add(vCenterName+","+remCntTmp+","+tmpRemote+","+esxCntTmp+","+esx+" ("+rmtAgent+")");
			}
			else
			{
				csvData.add(",,,"+tmpRemote+",,"+esx+" ("+rmtAgent+")");
			}
		}
		csvData.add(",,,,,");		
	}

	session.setAttribute("list",csvData);
	rootObj.put("UserInfo",userDetailsGrid);
	out.println(rootObj.toString());

%>


