<%
/*******************************************************************************
*		Name				:EgShowPercentileAssociatesJSON.jsp
*		Purpose				:Configures the details required for default reports
*		Version				:6.0
*		Created Date		:28/06/2013
*		Modified Date		:28/06/2013
*		Author				:Abdul Khader M
*******************************************************************************/
%>

<%@ include file="../../../admin/EgTrackerAJSON.jsp" %>

<%@ page import="java.util.*"%>

<%@ page import="com.eg.EgName"%>

<%@ page import="com.eg.MappingNameSorter"%>

<%@ page import="com.egurkha.ini.IniUI"%>

<%@ page import="com.eg.EgThresholdInfo" %>
<%@ page import="com.eg.IniFile" %>
<%@ page import="net.sf.json.*" %>

<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	response.setContentType("application/json");
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	JSONObject rootJson = new JSONObject();
	JSONArray testArrayJson = new JSONArray();
	JSONArray mappedTestArrayJson = new JSONArray();
	JSONArray actualMeasuresArrayJson = new JSONArray();
	JSONArray actualMeasuresForTestArrayJson = new JSONArray();
	JSONArray localMeasuresArrayJson = new JSONArray();
	JSONArray localMeasuresForTestArrayJson = new JSONArray();

	JSONArray measuresAndTestArrayJson = new JSONArray();
	JSONArray measuresForTestArrayJson = new JSONArray();
	JSONArray onlyMeasuresArrayJson = new JSONArray();

	IniUI iniUI = IniUI.getInstance();

	String userLanguage = iniUI.getDefaultLanguage();

	if (_user != null)

	{

		userLanguage = _user.getLanguage();

	}

	MappingNameSorter sorter = new MappingNameSorter(userLanguage);



	EgThresholdInfo thresholdInfo = new EgThresholdInfo("manager");

	String strPercentile = request.getParameter("strPercentile");

	if (strPercentile == null)

	{

		strPercentile = "";

	}

	IniFile testsIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_tests.ini");
	String[] tempPercentileTypes = testsIni.getVariables("CAPACITY_PLANNING_PERCENTILE");

	String strPerDef = request.getParameter("perDef");

	if (strPerDef == null)

	{

		strPerDef = "";

	}


	TreeMap tmapPercentileMeasures = new TreeMap();
	if (strPercentile.equalsIgnoreCase("default"))
	{
		ArrayList aListtempPercentileTypes = new ArrayList();
		if (tempPercentileTypes != null && tempPercentileTypes.length > 0)
		{
			aListtempPercentileTypes = new ArrayList(Arrays.asList(tempPercentileTypes));
		}

		String[] capacityTests = testsIni.getVariables("CAPACITY_TESTS");
		ArrayList aListCapacityTestsEnabled = null;
		for (int i=0;i<capacityTests.length;i++)
		{
			String strCapacityTest = capacityTests[i];
			String strValue = testsIni.getValue("CAPACITY_TESTS",strCapacityTest);
			strValue = strValue.trim();
			if (strValue.equalsIgnoreCase("yes"))
			{
				if (aListCapacityTestsEnabled == null)
				{
					aListCapacityTestsEnabled = new ArrayList();
				}

				aListCapacityTestsEnabled.add(strCapacityTest);
			}
		}

		if (aListCapacityTestsEnabled != null)
		{
			for (int i=0;i<aListCapacityTestsEnabled.size();i++)
			{
				String strTest = (String)aListCapacityTestsEnabled.get(i);
				String[] testMeasuresValues = thresholdInfo.getMeasurementsForTest(strTest);
				if (testMeasuresValues == null) continue;
				ArrayList aListTempMeasures = null;

				for (int j=0;j<testMeasuresValues.length;j++)
				{
					String strTestMeasureValue = (String)testMeasuresValues[j];
					String tempPattern = strTest + ":" + strTestMeasureValue;
					if (aListtempPercentileTypes.contains(tempPattern))
					{
						String strValue = testsIni.getValue("CAPACITY_PLANNING_PERCENTILE",tempPattern);
						strValue = strValue.trim();
						if (!strValue.equalsIgnoreCase("default"))
						{
							continue;
						}

						if (aListTempMeasures == null)
						{
							aListTempMeasures = new ArrayList();
						}

						aListTempMeasures.add(strTestMeasureValue);
					}
					else
					{
						if (aListTempMeasures == null)
						{
							aListTempMeasures = new ArrayList();
						}

						aListTempMeasures.add(strTestMeasureValue);
					}
				}

				if (aListTempMeasures != null)
				{
					tmapPercentileMeasures.put(strTest,aListTempMeasures);
				}
			}
		}
	}
	else
	{
		for (int i=0;i<tempPercentileTypes.length;i++)
		{
			String strPattern = tempPercentileTypes[i];
			String strValue = testsIni.getValue("CAPACITY_PLANNING_PERCENTILE",strPattern);

			if (strValue.equalsIgnoreCase(strPercentile))
			{
				String strTestName = strPattern.substring(0,strPattern.indexOf(":"));
				String strMeasure = strPattern.substring(strPattern.indexOf(":")+1);

				ArrayList aListTemp1 = (ArrayList)tmapPercentileMeasures.get(strTestName);
				if (aListTemp1 == null)
				{
					aListTemp1 = new ArrayList();
					aListTemp1.add(strMeasure);
					tmapPercentileMeasures.put(strTestName,aListTemp1);
				}
				else
				{
					aListTemp1.add(strMeasure);
				}
			}
		}
	}
%>

<%
	rootJson.put("percentilePolicy",strPercentile);
	rootJson.put("tmapPercentileMeasures",tmapPercentileMeasures);
%>
<%

	if (tmapPercentileMeasures != null)
	{
		Iterator itrPercentileMeasures = tmapPercentileMeasures.keySet().iterator();

		while (itrPercentileMeasures.hasNext())

		{

			String strTestName = (String)itrPercentileMeasures.next();

			String testDescription = _mapping.getTestDescription(strTestName);

			ArrayList aListMeasures = (ArrayList)tmapPercentileMeasures.get(strTestName);

			aListMeasures = sorter.getSortedTestList(aListMeasures);
			JSONObject jObj = new JSONObject();

			jObj.put("Test",testDescription);

			for (int k=0; k<aListMeasures.size(); k++)
			{
				JSONObject jMeasureObj = new JSONObject();
				EgName egName = (EgName)aListMeasures.get(k);
				String strMeasure = egName.getLocalName();
				String mappedDisplayName = _mapping.getMeasureDescription(testDescription,strMeasure);
			}
			String mappedTestName = _mapping.getTestDescription(strTestName);
			testArrayJson.add(strTestName);
			mappedTestArrayJson.add(mappedTestName);

%>
<%
			rootJson.put("aListMeasures",aListMeasures);
			for (int i=0;i<aListMeasures.size();i=i+2)

			{

				boolean border = true;

				if (i+1 == aListMeasures.size()) border = false;

%>
<%

				for (int j=i;j<i+2;j++)

				{

					if (j < aListMeasures.size())

					{


						EgName egName = (EgName)aListMeasures.get(j);

						String strMeasure = egName.getActualName();
						actualMeasuresArrayJson.add(strMeasure);

						String mappedDisplayName = _mapping.getMeasureDescription(testDescription,strMeasure);

						String strMeasureDisplayName = egName.getLocalName();
						localMeasuresArrayJson.add(strMeasureDisplayName);

						jObj.put("Measures",mappedDisplayName);
						measuresForTestArrayJson.add(jObj);

%>
<%

					}

					else

					{

%>
<%

					}
				}
%>
<%

			}
%>
<%

		}
	}
	String testNameForOnlyMeasures = (String) request.getParameter("testName");

	if (testNameForOnlyMeasures != null)
	{
		ArrayList aListMeasures = (ArrayList)tmapPercentileMeasures.get(testNameForOnlyMeasures);

		aListMeasures = sorter.getSortedTestList(aListMeasures);

		for (int i=0;i<aListMeasures.size();i=i+2)
		{
			boolean border = true;
			if (i+1 == aListMeasures.size()) border = false;

			for (int j=i;j<i+2;j++)
			{
				if (j < aListMeasures.size())
				{
					JSONObject testAndMeasuresObj = new JSONObject();
					EgName egName = (EgName)aListMeasures.get(j);
					String strMeasure = egName.getActualName();
					actualMeasuresForTestArrayJson.add(strMeasure);

					String strMeasureDisplayName = egName.getLocalName();
					String mappedTestNameSecond = _mapping.getTestDescription(testNameForOnlyMeasures);
					String mappedDisplayName = _mapping.getMeasureDescription(testNameForOnlyMeasures,strMeasureDisplayName);
					localMeasuresForTestArrayJson.add(mappedDisplayName);
					testAndMeasuresObj.put("Test",mappedTestNameSecond);
					testAndMeasuresObj.put("Measures",mappedDisplayName);
					measuresAndTestArrayJson.add(testAndMeasuresObj);
				}
			}
		}
	}

	rootJson.put("testArrayJson",testArrayJson);
	rootJson.put("mappedTestArrayJson",mappedTestArrayJson);
	rootJson.put("actualMeasuresArrayJson",actualMeasuresArrayJson);
	rootJson.put("localMeasuresArrayJson",localMeasuresArrayJson);
	rootJson.put("actualMeasuresForTestArrayJson",actualMeasuresForTestArrayJson);
	rootJson.put("localMeasuresForTestArrayJson",localMeasuresForTestArrayJson);
	rootJson.put("measuresAndTestArrayJson",measuresAndTestArrayJson);
	rootJson.put("measuresForTestArrayJson",measuresForTestArrayJson);

	out.println(rootJson);
%>



