<!DOCTYPE html>

<%@ include file="EgTrackerA.jsp" %>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>

<%
	String componentTypeFromSession = "";
	String cpctEnabledTestFromSession = "";
	String testNameFromSession = "";
	String showOnlyFromSession = "";

	if (session.getAttribute("componentType") != null)
	{
		componentTypeFromSession = (String) session.getAttribute("componentType");
	}

	if (session.getAttribute("cpctEnabledTest") != null)
	{
		cpctEnabledTestFromSession = (String) session.getAttribute("cpctEnabledTest");
	}

	if (session.getAttribute("testName") != null)
	{
		testNameFromSession = (String) session.getAttribute("testName");
	}

	if (request.getParameter("showOnly") != null)
	{
		String showOnly = (String) request.getParameter("showOnly");
		if (showOnly.equalsIgnoreCase("3"))
		{
			showOnlyFromSession = "configSysReport";
		}
		else if (showOnly.equalsIgnoreCase("2"))
		{
			showOnlyFromSession = "configTests";
		}
		else if (showOnly.equalsIgnoreCase("1"))
		{
			showOnlyFromSession = "viewPage";
		}
	}
%>

<html>
<head>
	<meta charset="utf-8">
	<title>CAPACITY PLANNING</title>

	<!--Skin color--------->
	<egui:skin ui = "admin"/>

	<!---Components, icons, skin and Core ext script--->
	<script type="text/javascript" src="../extjs/ext-all.js"></script>

	<!-- Fancy Scroll-->
	<script src="/final/scripts/jquery-1.8.2.js"></script>
	<script src="/final/styles/jscrollpane/jquery.jscrollpane.js" ></script>
	<script src="/final/styles/jscrollpane/jquery.mousewheel.js" ></script>
	<script src="/final/styles/jscrollpane/mwheelIntent.js" ></script>
	<link rel="stylesheet" href="/final/styles/jscrollpane/jquery.jscrollpane.css"/>


	<!-- Application folder -->
	<script type = "text/javascript">
		var csrfToken = '<%=strCsrfToken%>';
		var alertForGreater = '<egui:intnl text="admin.percentile.Maximum percentile value should be greater than minimum percentile value"/>';
		var alertForMinConditionCheck = '<egui:intnl text="admin.reports.Major value should be greater than Critical value"/>';
		var alertForMaxConditionCheck = '<egui:intnl text="admin.reports.Critical value should be greater than Major value"/>';
		var alertForAllPolicyApply = '<egui:intnl text="admin.percentile.Do you want to apply this percentile policy to all measures of"/>';
		var alertForAllViewApply = '<egui:intnl text="admin.percentile.Do you want to apply this report view to all measures of"/>';
		var alertForNotNumberInMin = '<egui:intnl text="admin.percentile.Invalid data for minimum value"/>' + ". " + '<egui:intnl text="admin.percentile.Only numbers from 0 to 100 is allowed"/>.';
		var alertForNotNumberInMax = '<egui:intnl text="admin.percentile.Invalid data for maximum value"/>' + ". " + '<egui:intnl text="admin.percentile.Only numbers from 0 to 100 is allowed"/>.';
		var alertForDeleteConfirmation = '<egui:intnl text="admin.percentile.Do you want to delete the percentile policy, "/>';
		var alertForMinimumValue = '<egui:intnl text="admin.percentile.Please enter minimum value"/>';
		var alertForMaximumValue = '<egui:intnl text="admin.percentile.Please enter maximum value"/>';
		var alertForEmpty = '<egui:intnl text="admin.percentile.Field value cannot be blank" />';
		var alertForSpace = '<egui:intnl text="admin.percentile.Space not allowed" />';
		var alertForPolicyName = '<egui:intnl text="admin.percentile.Please enter the percentile policy name"/>';
		var alertForSpaceInPolicyName = '<egui:intnl text="admin.percentile.Space is not allowed in percentile policy"/>';
		var alertForSpecialCharacterInName = '<egui:intnl text="admin.percentile.Special characters are not allowed"/>';
		var alertForPolicyAlreadyExistsOne = '<egui:intnl text="admin.percentile.Percentile policy"/>';
		var alertForPolicyAlreadyExistsTwo = '<egui:intnl text="admin.percentile.already exists"/>.';
		var alertForPolicyAlreadyExistsThree = '<egui:intnl text="admin.percentile.Please provide another name."/>';

		var componentTypeFromSession = '<%= componentTypeFromSession%>';
		var cpctEnabledTestFromSession = '<%= cpctEnabledTestFromSession%>';
		var testNameFromSession = '<%= testNameFromSession%>';
		var showOnlyFromSession = '<%= showOnlyFromSession%>';

		var capPlanTitle = '<egui:intnl text="admin.percentile.Capacity Planning"/>';
		var capPlanDesc = '<egui:intnl text="admin.percentile.This page allows the user to configure capacity planning reports"/>.';
		var policyConfigure = '<egui:intnl text="admin.percentile.Configure Percentile Policy"/>';
		var policyEditDesc = '<egui:intnl text="admin.percentile.This panel allows the user to add/modify/delete/view the percentile policies for capacity planning reports"/>.';
		var policyCombo = '<egui:intnl text="admin.percentile.What would you like to do?"/>';
		var policyText = '<egui:intnl text="admin.percentile.Percentile policy"/>';
		var minimumText = '<egui:intnl text="admin.percentile.Minimum value"/>';
		var maximumText = '<egui:intnl text="admin.percentile.Maximum value"/>';
		var associatesText = '<egui:intnl text="admin.percentile.Associates"/>';
		var updateText = '<egui:intnl text="admin.percentile.Update"/>';
		var addText = '<egui:intnl text="admin.percentile.Add"/>';
		var noDataFound = '<egui:intnl text="admin.percentile.No Data found"/>';

		var policyAddCombo = '<egui:intnl text="admin.percentile.Percentile Policy"/>';
		var minimumAddText = '<egui:intnl text="admin.percentile.Minimum Value"/>';
		var maximumAddText = '<egui:intnl text="admin.percentile.Maximum Value"/>';
		var newPolicy = '<egui:intnl text="admin.percentile.New Percentile Policy"/>';
		var addPolicy = '<egui:intnl text="admin.percentile.Add Percentile Policy"/>';
		var modifyPolicy = '<egui:intnl text="admin.percentile.Modify Percentile Policy"/>';

		var deleteBtnText = '<egui:intnl text="admin.percentile.Delete"/>';
		var backBtnText = '<egui:intnl text="admin.percentile.Back"/>';

		var configSys = '<egui:intnl text="admin.percentile.Configure System Reports"/>';
		var configSysDesc = '<egui:intnl text="admin.percentile.This panel allows the user to configure major and critical values that are used in capacity planning system reports to identify resource bottlenecks"/>.';

		var measureHtml = '<egui:intnl text="admin.percentile.Measurement"/>';
		var conditionHtml = '<egui:intnl text="admin.percentile.Condition"/>';
		var majorValueHtml = '<egui:intnl text="admin.percentile.Major Value"/>';
		var criticalValueHtml = '<egui:intnl text="admin.percentile.Critical Value"/>';
		var cpuUtilizationText = '<egui:intnl text="admin.percentile.CPU utilization (%)"/>';
		var memoryUtilizedText = '<egui:intnl text="admin.percentile.Physical memory utilized (%)"/>';
		var percentUsageText = '<egui:intnl text="admin.percentile.Percent_usage (%)"/>';

		var diskActivityText = '<egui:intnl text="admin.percentile.Disk Activity - Disk busy (%)"/>';
		var bandwidthUsageText = '<egui:intnl text="admin.percentile.Bandwidth usage (%)"/>';
		var updateBtnText = '<egui:intnl text="admin.percentile.Update"/>';

		var configureTestTitle = '<egui:intnl text="admin.percentile.Configure Tests"/>';
		var configTestDesc = '<egui:intnl text="admin.percentile.This panel allows the user to enable/disable tests for capacity planning and associate percentile policy, report view for its measures"/>.';
		var configTestCmpType = '<egui:intnl text="admin.percentile.Component Type"/>';
		var configTestShowTests = '<egui:intnl text="admin.percentile.Show Tests"/>';
		var configTestTestName = '<egui:intnl text="admin.percentile.Test name"/>';
		var configTestEnableorDis = '<egui:intnl text="admin.percentile.Capacity planning"/>';
		var configTestUpdBtn = '<egui:intnl text="admin.percentile.Update"/>';

		var associatesTitle = '<egui:intnl text="admin.percentile.Associates"/>';
		var associatesDesc = '<egui:intnl text="admin.percentile.This panel enables the administrator to view the associations of percentile policy"/>.';
		var associatesPolicyCombo = '<egui:intnl text="admin.percentile.Percentile policy"/>';
		var testText = '<egui:intnl text="admin.percentile.Test"/>';
		var measuresText = '<egui:intnl text="admin.percentile.Measures"/>';
		var backText = '<egui:intnl text="admin.percentile.Back"/>';
		var showAssociatesLabel = '<egui:intnl text="admin.alarm.Show Associates"/>';

		var policySuccess = '<egui:intnl text="admin.percentile.Percentile Policy successfully created"/>.';
		var modifySuccess = '<egui:intnl text="admin.percentile.The selected percentile policy has been successfully modified"/>.';
		var deleteSuccess = '<egui:intnl text="admin.percentile.The selected percentile policy(s) has been successfully deleted"/>.';
		var policyDelete = '<egui:intnl text="admin.percentile.Delete Percentile Policy"/>';
		var policyAssociates = '<egui:intnl text="admin.percentile.Policy has associates"/>';
		var configTestsSuccess = '<egui:intnl text="admin.percentile.Tests has been updated"/>.';
		var configTestsFailure = '<egui:intnl text="admin.percentile.Tests has not been updated"/>.';

		var sysConfigSuccess = '<egui:intnl text="admin.percentile.Configuration has been updated"/>.';
		var sysConfigFailure = '<egui:intnl text="admin.percentile.Configuration has not been updated"/>.';
		var policyNotSelected = '<egui:intnl text="admin.percentile.Please choose a percentile policy"/>';
		var deleteConfirm = '<egui:intnl text="admin.percentile.Do you want to delete the percentile policy(s) ?"/>';
		var defaultPolicy = '<egui:intnl text="admin.percentile.Default percentile policy"/>';

		var probsErrorMessage = '<egui:intnl text="admin.error.Problem encountered while loading the user interface"/>.';
		var requestTimeOut = '<egui:intnl text="admin.error.Response timed out"/>.';
		var errorTitle = '<egui:intnl text="admin.user.Error"/>';
	</script>

	<script type="text/javascript" src="EgReportCustomSetting/app/app.js"></script>

	<script language="javascript">
		Ext.onReady(function(){
			Ext.Ajax.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
			Ext.data.Connection.prototype.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
			Ext.data.ScriptTagProxy.prototype.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};

			Ext.Ajax.on('requestexception', function (conn, response, options) {
				var errorStr = response.responseText;
				if (errorStr != undefined && errorStr != 'undefined' && errorStr.indexOf("customerror") != -1)
				{
					if (errorStr.indexOf("user-session-invalid") != -1)
					{
						callWindow(1);
					}
					else if (errorStr.indexOf("user-deleted") != -1)
					{
						callWindow(2);
					}
					else if (errorStr.indexOf("user-timedout") != -1)
					{
						callWindow(3);
					}
				}
				else
				{
					if (response.status == 302 || (response.timedout != undefined && response.timedout == true))
					{
						Ext.Msg.show({
							title : errorTitle,
							msg : requestTimeOut,
							buttons : Ext.Msg.OK,
							icon : 'iconError'
						});
					}
					else
					{
						console.log(response.responseText);
						Ext.Msg.show({
							title : errorTitle,
							msg : probsErrorMessage,
							buttons : Ext.Msg.OK,
							icon : 'iconError'
						});
					}
				}
			});
		});
	</script>
</head>
<body>

</body>
</html>



