<%
/*******************************************************************************
*	Name			:	EgListDomainGroups.jsp
*	Purpose			:	This jsp is used for list domain groups in replicating users.
*	Version			:
*	CreationDate	:	12/03/2012
*	LastModified	:
*	Author			:	Abdul Khader
*	Design Changes	:
*	Location		:	/final/admin/EgReplicateUser/data
*******************************************************************************/
%>

<%@	include	file="../../../admin/EgTrackerA.jsp" %>
<%@	taglib prefix =	"egui" uri = "../../../WEB-INF/eg-taglib.tld"	%>
<%@	taglib prefix =	"pagingroup" uri = "../../../WEB-INF/PagedGroupControls.tld"%>
<%@	page import="com.egurkha.util.StringUtils"%>
<%@	page import="com.egurkha.ini.IniUI"%>
<%@ page import="com.eg.IniFile" %>
<%@ page import="com.eg.*" %>
<%@ page import = "com.eg.EgDbAdapterTypeUI"%>
<%@ page import = "egurkha.EgDbAdapterUI"%>
<%@	page language="java" contentType="text/html; charset=UTF-8"	pageEncoding="UTF-8" %>
<%@ page import = "java.sql.*" %>
<%@ page import = "java.io.*" %>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	ArrayList ckdGroups = new ArrayList();
	String frmPage = (String)request.getParameter("frmPage");
	String source = (String)session.getAttribute("source");
	String selectedGroup = (String)request.getParameter("selectedGroup");
	String requestStr = (String)request.getParameter("requestStr");
	String checkedGroups = (String)request.getParameter("checkedGroups");
	String listGroups = (String)request.getParameter("listGroups");
	if (checkedGroups == null || checkedGroups.equals("") || checkedGroups.length() == 0)
	{
		ckdGroups = new ArrayList();
	}
	else
	{
		ArrayList tempList = StringUtils.myTokenizer(checkedGroups,"|#|");
		Iterator it = tempList.iterator();
		while(it.hasNext())
		{
			String tok = (String)it.next();
			ckdGroups.add(tok);
		}
	}

	if (selectedGroup == null)
	{
		selectedGroup = "all";
	}

	if (requestStr == null)
	{
		requestStr = "all";
	}

	if (selectedGroup.indexOf("|amp|") != -1)
	{
		selectedGroup = StringUtils.replace(selectedGroup,"|amp|","&");
	}

	if (selectedGroup.indexOf("|hash|") != -1)
	{
		selectedGroup = StringUtils.replace(selectedGroup,"|hash|","#");
	}

	if (source == null || source.equals("null"))
	{
		source = "";
	}

	String hashKey = (String)request.getParameter("hashKey");
	if (hashKey == null)
	{
		hashKey = "";
	}
	if (hashKey.indexOf("|amp|") != -1)
	{
		hashKey = StringUtils.replace(hashKey,"|amp|","&");
	}
	if (hashKey.indexOf("|hash|") != -1)
	{
		hashKey = StringUtils.replace(hashKey,"|hash|","#");
	}
	String isGroupCached = (String)request.getParameter("isGroupCached");
	if (isGroupCached == null)
	{
		isGroupCached = "";
	}
	ArrayList ListGroups = new ArrayList();
	if (frmPage == null)
	{
		frmPage = "main";
	}

	String searchString = (String)request.getParameter("searchString");
	if (searchString == null || searchString.equalsIgnoreCase("null"))
	{
		searchString = "";
	}
	Vector groupExits = new Vector();
	ArrayList e_groups = new ArrayList();
	String domainName = (String)session.getAttribute("domainName");
	String selectedDomain = (String)session.getAttribute("selectedDomain");
	String r_groups = "";

	if (!requestStr.equalsIgnoreCase("SeachGroups"))
	{
		if (frmPage.equalsIgnoreCase("main"))
		{
			ListGroups = (ArrayList)session.getAttribute("listGroups");
			if (ListGroups == null)
			{
				ListGroups = new ArrayList();
			}
		}
		else
		{
			if (isGroupCached != null && isGroupCached.equalsIgnoreCase("yes"))
			{
				Hashtable cachedGroups = (Hashtable)session.getAttribute("cachedGroups");
				if (cachedGroups != null)
				{
					ArrayList data = (ArrayList)cachedGroups.get(hashKey);
					if (data != null) ListGroups.addAll(data);
				}
			}
			else
			{
				if (listGroups != null && listGroups.length() > 0)
				{
					ArrayList tempList = StringUtils.myTokenizer(listGroups,"|$|");
					Iterator it = tempList.iterator();
					while(it.hasNext())
					{
						String tok = (String)it.next();
						if (tok != null && tok.indexOf("|hash|") != -1)
						{
							tok = StringUtils.replace(tok,"|hash|","#");
						}

						if (tok != null && tok.indexOf("|amp|") != -1)
						{
							tok = StringUtils.replace(tok,"|amp|","&");
						}

						if (tok != null && tok.indexOf("|plus|") != -1)
						{
							tok = StringUtils.replace(tok,"|plus|","+");
						}

						if (tok != null && tok.indexOf("|backslash|") != -1)
						{
							tok = StringUtils.replace(tok,"|backslash|","\\");
						}
						ListGroups.add(tok);
					}
				}
			}
		}

		IniFile userMappingIni =  new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_ui.ini");
		//IniFile iniFile=new IniFile(EgInstallInfo.getInstallDir() +"/manager/config/eg_authenticate.ini");
		String str_conn = "";
		String str_query = "";
		boolean	b_state = false;
		String str_uname = "";
		String str_utype = "";
		ResultSet	rs_uname = null;
		EgDbAdapterUI egDb = EgDbAdapterTypeUI.getObject();
		try
		{
			str_conn = egDb.setConnection();
			str_query = "SELECT user_id,user_type FROM user_info  ORDER BY user_id";
			rs_uname = egDb.SelectExec(str_query);
			b_state=egDb.getState();

			while(rs_uname.next())
			{
				str_uname=rs_uname.getString("user_id");
				str_utype=rs_uname.getString("user_type");

				if (str_uname.indexOf("/Grp/") != -1)
				{
					String temp_Usr = userMappingIni.getValue("DBUSER_USER_MAP",str_uname.trim());
					if (temp_Usr != null && temp_Usr.length() > 0)
					{
						str_uname = temp_Usr;
					}
					String grpDelimiter = "/Grp/";
					int idx = str_uname.indexOf(grpDelimiter);
					String str_uname_A = str_uname.substring(0,idx);
					int nextIdx = idx + grpDelimiter.length();
					String str_uname_B = str_uname.substring(nextIdx);
					if (str_uname_A.equalsIgnoreCase(selectedDomain))
					{
						groupExits.add(str_uname_B.trim());
						r_groups = r_groups + str_uname_B.trim() +"|hash|";
					}
				}
			}

			rs_uname.close();
			egDb.releaseConnection(false);
			EgDbAdapterTypeUI.releaseObject(egDb);
		}
		catch(Exception e)
		{
			if (rs_uname != null)
			{
				try { 
					rs_uname.close();
				} catch (Exception bug123) {}
			}

			try
			{
				egDb.releaseConnection(true);
				EgDbAdapterTypeUI.releaseObject(egDb);
			}
			catch(Exception e1)
			{
				System.out.println("Exception while releasing the database connection");
			}
		}
		if (r_groups.endsWith("|hash|"))
		{
			r_groups = r_groups.substring(0,r_groups.length()-6);
			r_groups = r_groups.trim();
		}

		Collections.sort(ListGroups,String.CASE_INSENSITIVE_ORDER);
		Collections.sort(groupExits,String.CASE_INSENSITIVE_ORDER);
		session.setAttribute("userGroups",ListGroups);
		session.setAttribute("createdGroups",groupExits);
		e_groups.addAll(groupExits);
	}

	if (requestStr.equalsIgnoreCase("SeachGroups"))
	{
		ArrayList groups = (ArrayList)session.getAttribute("userGroups");
		Vector createdGroups = (Vector)session.getAttribute("createdGroups");
		if (createdGroups != null)
		{
			groupExits.addAll(createdGroups);
		}
		// Registered domain groups
		if (groupExits != null && groupExits.size() > 0)
		{
			if (!searchString.equals("") && searchString.length() != 0)
			{
				//if (source != null && !source.equalsIgnoreCase("EgReplicate"))
				//{
					for (int i = 0;i<groupExits.size();i++ )
					{
						String grpName = (String)groupExits.get(i);
						if(grpName.indexOf(searchString) != -1 || (grpName.toUpperCase().indexOf(searchString.toUpperCase())) != -1)
						{
							e_groups.add(grpName);
						}
					}
				//}
			}
			else
			{
				e_groups.addAll(groupExits);
			}
		}

		// Available domain groups
		if (groups != null && groups.size() > 0)
		{
			if (!searchString.equals("") && searchString.length() != 0)
			{
				//if (source != null && !source.equalsIgnoreCase("EgReplicate"))
				//{
					for (int i = 0;i<groups.size();i++ )
					{
						String grpName = (String)groups.get(i);
						if(grpName.indexOf(searchString) != -1 || (grpName.toUpperCase().indexOf(searchString.toUpperCase())) != -1)
						{
							ListGroups.add(grpName);
						}
					}
				//}
			}
			else
			{
				ListGroups.addAll(groups);
			}
		}
	}
	// for paging
	String pageNo = request.getParameter("pageNo");
	String defaultPageNo="1";

	if (pageNo == null || pageNo.equals(""))
	{
		pageNo = "1";
	}

	String rows		= null;
	int totalPages	= 1;
	rows = (String)request.getParameter("rows");
	if (rows == null)
	{
		rows = "500";
	}

	if (ListGroups != null && ListGroups.size() > 0)
	{
		if ((ListGroups.size() % Integer.parseInt(rows)) != 0)
		{
			totalPages = ListGroups.size() / Integer.parseInt(rows) + 1;
		}
		else
		{
			totalPages = ListGroups.size() / Integer.parseInt(rows);
		}
	}
	String resultContainerHeight = "395px";
	if (totalPages > 1)
	{
		resultContainerHeight = "352px";
	}
	
%>

<html>
<head>
<title>AD Groups</title>
<meta name="created" content="28/6/2k">
<egui:skin ui="adminindex"/>
<link rel="stylesheet" type="text/css" href="../../../resources/css/ext-all.css" />
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<script language="javascript1.2" src="../../../admin/eg_scripts/ajaxutils.js"></script>
<script language="javascript1.2" src="../../../admin/eg_scripts/validate.js"></script>
<script language="JavaScript1.2" src="../../../scripts/<%=script_src%>"></script>
<script language="JavaScript1.2" src="/final/monitor/eg_scripts/dropdown_menu_hack.js"></script>
<script language="javascript1.2">

//document.oncontextmenu=new Function("return false");
function openRootCauseWindow()
{
	window.open("/final/admin/EgRootCauseAnalyzer.jsp?disName=<%=selectedDomain%>&domainName=<%=domainName%>","eG_" + (new Date()).getTime(),"toolbar=no,menubar=no,location=no,status=no,statusbar=no,scrollbars=yes,self,left=250,top=170,resizable=yes,screenX=0,screenY=0,width=700,height=450");
}

function setSelectedGroup(selectedValue)
{
	var currentWindow = window.parent;
	//var mainWindow = currentWindow.parent;
	if (selectedValue != null && selectedValue.indexOf("|squote|") != -1)
	{
		var idx = parseInt(selectedValue.indexOf("|squote|"));
		while(idx > -1)
		{
			selectedValue = selectedValue.replace("|squote|","'");
			idx=parseInt(selectedValue.indexOf("|squote|"));
		}
	}

	if (selectedValue != null && selectedValue.indexOf("|backslash|") != -1)
	{
		var idx = parseInt(selectedValue.indexOf("|backslash|"));
		while(idx > -1)
		{
			selectedValue = selectedValue.replace("|backslash|","\\");
			idx=parseInt(selectedValue.indexOf("|backslash|"));
		}
	}

	var thisForm = document.egGroup;
	var groupExits = thisForm.groupExits.value;
	if (groupExits != null && groupExits != "")
	{
		var myGrpArray = groupExits.split("|hash|");
		for (i=0;i<myGrpArray.length;i++ )
		{
			if (myGrpArray[i] == selectedValue)
			{
				alert('<egui:intnl text="The selected group has already been registered in the eG system"/>');
				return false;
			}
		}
	}
	//mainWindow.setSelectedGroupName(selectedValue);
	currentWindow.setSelectedGroupName(selectedValue);
}

function multiSelectGroup(selectedValue)
{
	var currentWindow = window.parent;
	if (selectedValue != null && selectedValue.indexOf("|squote|") != -1)
	{
		var idx = parseInt(selectedValue.indexOf("|squote|"));
		while(idx > -1)
		{
			selectedValue = selectedValue.replace("|squote|","'");
			idx=parseInt(selectedValue.indexOf("|squote|"));
		}
	}

	if (selectedValue != null && selectedValue.indexOf("|backslash|") != -1)
	{
		var idx = parseInt(selectedValue.indexOf("|backslash|"));
		while(idx > -1)
		{
			selectedValue = selectedValue.replace("|backslash|","\\");
			idx=parseInt(selectedValue.indexOf("|backslash|"));
		}
	}
	currentWindow.setSelectedGroupName(selectedValue);
}

function searchADGroups()
{	
	var strString = document.getElementById("searchBox").value;
	if (strString == "Search")
	{
		strString = "";
	}
	var parentWindow = window.parent;
	var myArray = parentWindow.groupArray;
	var item = "";
	c = 0;
	if (myArray != null && myArray.length > 0)
	{
		for (i=0;i<myArray.length;i++)
		{
			if (myArray[i] != null && myArray[i] != "undefiend")
			{
				if (c == 0)
				{
					item = item + myArray[i];
				}
				else
				{
					item = item +"|#|"+myArray[i];
				}
				c++;
			}
		}
	}

	try
	{
		var queryString = "searchString="+encodeURIComponent(strString)+"&checkedGroups="+encodeURIComponent(item);
		var urlString = "EgListDomainGroups.jsp?requestStr=SeachGroups&"+queryString;
		var grp_form = document.egGroup;
		grp_form.method = "POST";
		grp_form.action = urlString;
		grp_form.submit();
	}
	catch (e)
	{
	}
}

//groupArray = new Array();
//i = 0;

function addToGroup(obj)
{
	//window.parent.addGroupToArrayInCtrll(obj);
	window.parent.addGroupToArray(obj);
	//addGroupToArrayInDomainList(obj);
}

function hideSearchMenu()
{
	document.getElementById("infoHeader").style.display = "none";
}


if (!Array.prototype.indexOf)
{
	Array.prototype.indexOf = function(elt /*, from*/)
	{
		var len = this.length;
		var from = Number(arguments[1]) || 0;
		from = (from < 0) ? Math.ceil(from) : Math.floor(from);
		if (from < 0)
		{
			from += len;
		}

		for (; from < len; from++)
		{
			if (from in this && this[from] === elt)
			{
				return from;
			}
		}

		return -1;
	};
}

function hideMsgDiv()
{
	var groupDiv = document.getElementById("groupDiv");
	if (groupDiv != null && groupDiv != "undefined")
	{
		groupDiv.style.display = "none";
	}
}

function viewSelectedGroups()
{
	var groupDiv = document.getElementById("groupDiv");
	if (groupDiv != null && groupDiv != "undefined")
	{
		var htmlInput = "<div id='viewSelection' class='div_scroll'  style='overflow-x: auto; overflow-y:auto;width:390px;height:300px'><table align='center' width='100%' class='tableborder_ad' cellpadding='4' cellspacing='0'>";

		if (groupArray.length == 0)
		{
			groupDiv.style.display = "block";
			document.getElementById("setTitle").innerHTML = "List of selected domain groups";
			document.getElementById("errMsg").innerHTML = '<div style="width:300px;">    No groups have been selected.</div>';
			return false;
		}

		var isGroupAvailable = "0";
		for (i=0;i<groupArray.length;i++)
		{
			if (groupArray[i] != null && groupArray[i] != "undefined")
			{
				isGroupAvailable = "1";
				htmlInput = htmlInput + "<tr><td class='tdborder_ad' valign='top' style='width:100%'>"+groupArray[i].replace(/</g,"&lt;").replace(/>/g,"&gt;")+"</td></tr>";
			}
		}

		if (isGroupAvailable == "0")
		{
			groupDiv.style.display = "block";
			document.getElementById("setTitle").innerHTML = "List of selected domain groups";
			document.getElementById("errMsg").innerHTML = '<div style="width:300px;">    No groups have been selected.</div>';
			return false;
		}
		htmlInput = htmlInput +"</table>";
		groupDiv.style.display = "block";
		document.getElementById("setTitle").innerHTML = "List of selected domain groups";
		document.getElementById("errMsg").innerHTML = htmlInput;
	}
}

function applySelection()
{
	var groupDiv = document.getElementById("groupDiv");
	if (groupArray.length == 0)
	{
		groupDiv.style.display = "block";
		document.getElementById("setTitle").innerHTML = "Domain Groups";
		document.getElementById("errMsg").innerHTML = '    No groups have been selected.';
		return false;
	}

	var item = "";
	var displayItem = "";
	c = 0;
	if (groupArray != null && groupArray.length > 0)
	{
		for (i=0;i<groupArray.length;i++)
		{
			if (groupArray[i] != null && groupArray[i] != "undefined")
			{
				if (c == 0)
				{
					item = item + groupArray[i];
					displayItem = displayItem + groupArray[i];
				}
				else
				{
					item = item +"|#|"+groupArray[i];
					displayItem = displayItem +","+groupArray[i];
				}
				c++;
			}
		}
	}
			
	if (item == "" || item == " ")
	{
		groupDiv.style.display = "block";
		document.getElementById("setTitle").innerHTML = "Domain Groups";
		document.getElementById("errMsg").innerHTML = '    No groups have been selected.';
		return false;
	}
	document.getElementById("groupDiv").style.display = "none";
	//var idObj1 = document.getElementById("treeLoad");
	//idObj1.style.display="none";
	window.parent.addData(item,displayItem);
	/*document.getElementById("grpname").value = item;
	document.getElementById("displayGrp").value = displayItem;
	
	document.getElementById("groupDiv").style.display = "none";
	groupArray = [];*/
}

</script>
</head>
<body leftmargin="0" topmargin="0" marginwidth="0" marginheight="0" style="overflow:auto" >
<form name="egGroup" method="post" style="padding:0px;margin:0px">
<input type = "hidden" name = "pageNo"/>
<input type = "hidden" name = "rows" value = "<%= rows %>"/>
<input type = "hidden" name = "frmPage" value = "<%= frmPage %>"/>
<input type = "hidden" name = "source" value = "<%= source %>"/>
<input type = "hidden" name = "selectedGroup" value = "<%= selectedGroup %>"/>
<input type = "hidden" name = "checkedGroups" value = "<%= checkedGroups %>"/>
<input type = "hidden" name = "listGroups" value = "<%= listGroups %>"/>
<input type="hidden" name="groupExits" value="<%=r_groups%>">
<input type="hidden" name="hashKey" value="<%=hashKey%>">
<input type="hidden" name="isGroupCached" value="<%=isGroupCached%>">
<input type="hidden" name="requestStr" value="<%=requestStr%>">
<input type="hidden" name="searchString" value="<%=searchString%>">
<table valign="top" style="vertical-align:top" cellspacing="0" cellpadding="0" width="100%" border="0" >
	<tr>
		<td style="height:422px;vertical-align:top" width="100%">
			<table border="0" cellpadding="8" cellspacing="0" width="98%">
				<tr>
					<td class="eg_blankspace" height="3">&nbsp;</td>
				</tr>
				<tr id="infoHeader">
					<td align="right" width="50%" id="printCount" style="font-size:13px"><b><egui:intnl text="Total domain groups"/>&nbsp;:&nbsp;</b><%=ListGroups.size()%></td>
					<td align="left" width="30%">
						<div class="searchImg" style="border:0px solid red;">
							<div class="rightside" style="display:inline;border:0px solid blue;" onkeypress="if(event.keyCode==13) javascript:searchADGroups();">
								<input class="textBoxImg" type="text" onfocus="if(this.value=='Search') this.value='';" onblur="if(this.value=='') this.value='Search';" value='<%=(searchString!=null && !searchString.equals(""))?searchString:"Search"%>' id="searchBox" name="searchBox"/>
							</div>
							<div class="searchIcon" style="display:inline;border:0px solid red;float:left">
								<a id="eg_strInput" href="javascript:void(0)" name="Go" onclick="javascript:searchADGroups()"><img src="/final/images/gray/search-icon.png" style="text-decoration:none" border="0"  class="png"/></a>
							</div>
						</div>
					</td>
				</tr>
<%
	if (ListGroups != null && (ListGroups.size() > 0 || (e_groups.size() > 0 && source.equalsIgnoreCase("EgReplicate"))))
	{
%>
				<tr>
<%
		if (totalPages > 1)
		{
%>
					<td  colspan="2" align="center">
						<table align="center" border="0" cellpadding="0" cellspacing="0" width="98%">
							<tr>
								<td width="30%" class="eg_7" style="text-align:left;padding:4px;padding-left:18px">
									<b class="eg_7"><egui:intnl text="admin.common.Page"/></b> : <b class="eg_7"><%= pageNo != null ? pageNo : "1" %>&nbsp;<egui:intnl text="admin.common.of"/>&nbsp;<%= totalPages %></b>
								</td>
								<td class="eg_7" style="text-align:left;padding:4px"><egui:intnl text="Please click on the domain group for selection"/>.</td>
							</tr>
						</table>
					</td>
<%
		}
		else
		{
%>
					<td colspan="2" align="center" class="eg_7" style="text-align:center;padding:4px;font-size:13px"><egui:intnl text="Please click on the domain group for selection"/>.</td>
<%
		}
%>
				<tr>
			</table>
			<div id="loadADGroups" style="border:0px solid blue;height:<%=resultContainerHeight%>;width:100%" >
<%
	//if (frmPage != null && frmPage.equalsIgnoreCase("main"))
	//{
		//if (ListGroups != null && ListGroups.size() > 0)
		//{
			int countTD = 0;
			if (source != null && !source.equalsIgnoreCase("EgReplicate"))
			{
%>
				<pagingroup:pagingdomaingroup pageNo = "<%= pageNo %>" rows = "<%= rows %>" object = "<%= ListGroups %>" source = "<%=source%>"/>
<%
			}
			else
			{
				int countTD2 = 0;
				if (e_groups != null && e_groups.size() > 0)
				{
%>
					<table align="center" border="0" cellpadding="0" cellspacing="0" width="95%">
					<tr>
						<td><b class="font_bold12">&nbsp;<egui:intnl text="ALREADY REGISTERED DOMAIN GROUPS"/></b></td>
					</tr>
					<tr>
						<td class="eg_blankspace" height="3">&nbsp;</td>
					</tr>
					<tr>
						<td width="100%" style="padding:4px;border-top-width:0px">
							<table align="center" border="0" width="100%" class="x-grid-table" cellpadding="4" cellspacing="0"><col width="50%"><col width="50%">
								<tr class="x-grid-row">
<%
					countTD2 = 0;
					for (int i = 0;i<e_groups.size();i++)
					{
						String grpName = (String)e_groups.get(i);
						countTD2 = countTD2 + 1;

						String tempGrpName_A = StringUtils.replace(grpName,"'","&#39;");
						tempGrpName_A = StringUtils.replace(tempGrpName_A,"\\","|backslash|");

						String tempGrpName_B = "";
						if (grpName.length() > 31)
						{
							tempGrpName_B = grpName.substring(0,30);
							tempGrpName_B = StringUtils.replace(tempGrpName_B,"<","&lt;");
							tempGrpName_B = StringUtils.replace(tempGrpName_B,">","&gt;");
							tempGrpName_B = tempGrpName_B + "...";
						}
						else
						{
							tempGrpName_B = StringUtils.replace(grpName,"<","&lt;");
							tempGrpName_B = StringUtils.replace(tempGrpName_B,">","&gt;");
						}

						if (countTD2 <= 2)
						{
%>
									<td class="x-grid-cell" valign="top" style="width:250px"><div class="x-grid-cell-inner"><%=tempGrpName_B%></div></td>
<%
						}
						else
						{
							countTD2 = 1;
%>
								</tr>
								<tr class="x-grid-row">
									<td class="x-grid-cell" valign="top" style="width:250px"><div class="x-grid-cell-inner"><%=tempGrpName_B%></div></td>
<%
						}
					}

					if (countTD2 == 1)
					{
%>
									<td class="x-grid-cell" valign="top" style="width:250px"><div class="x-grid-cell-inner">&nbsp;</div></td>
<%
					}
%>
								</tr>
							</table>
						</td>
					</tr>
					</table>
<%
				}
				else
				{
					if (!searchString.equals("") && searchString.length() > 0)
					{
%>
						<table align="center" border="0" cellpadding="0" cellspacing="0" width="95%">
						<tr>
							<td style="padding-top:6px" class="font_bold12"><b>&nbsp;<egui:intnl text="ALREADY REGISTERED DOMAIN GROUPS"/></b></td>
						</tr>
						<tr>
							<td class="eg_blankspace" height="3">&nbsp;</td>
						</tr>
						<tr>
							<td width="100%" class="page_tab_bg" style="padding:4px;border-top-width:0px">
								<table align="center" border="0" width="100%" class="tableborder_ad" cellpadding="6" cellspacing="0">
									<tr>
										<td class="tdborder_ad" align="center"><b><egui:intnl text="No groups found"/>.</b></td>
									<tr>
								</table>
							</td>
						</tr>
						</table>
<%
					}
				}
				ListGroups.removeAll(groupExits);
				if (ListGroups.size() > 0)
				{
%>
					<pagingroup:pagingdomaingroup pageNo = "<%= pageNo %>" rows = "<%= rows %>" object = "<%= ListGroups %>" source = "<%=source%>" checkedGroups = "<%=ckdGroups%>"/>
					<div id="groupDiv" style="display:none;width:420px;height:50px;left:200px;right:200px;top:80px;position:absolute;border:0px solid #ff0000;z-index:1000;">
						<table border="0" cellpadding="0" cellspacing="0" width="100%">
							<tr>
								<td colspan="3">
									<table border="0" cellpadding="0" cellspacing="0" width="100%">
										<tr>
											<td width="5" height="22" class="panel_top_left"><img src="/final/admin/eg_images/spacer.gif" width="5" height="22" border="0"></td>
											<td class="panel_top_bg whitefont" height="22px" width="100%" id="setTitle" ><egui:intnl text='admin.user.Domain Groups' /></td>
											<td align="left" class="panel_top_bg" style="padding-right:55px"></td>
											<td align="right" class="panel_top_bg" style="padding-top:2px">
											<img class="mouse" src="/final/monitor/eg_images/<%=admin_Skin%>/popup_close.png" border="0" title="Close" onclick="javascript:hideMsgDiv();"></td>
											<td width="9" height="22" class="panel_top_right"><img src="/final/admin/eg_images/spacer.gif" width="9" height="22" border="0"></td>
										</tr>
									</table>
								</td>
							</tr>
							<tr>
								<td class="panel_left_bg eg_blankspace" width="5px"><img src="/final/admin/eg_images/spacer.gif"></td>
								<td align="center" valign="top" style="padding:8px 4px 4px 4px;" class="panelbg" >
									<table border="0" cellpadding="0" cellspacing="0" width="100%">
										<tr>
											<td id="errMsg" style="height:100px;" align="center">
												<egui:intnl text="The selected group has already been registered in the eG system"/>.
											</td>
										</tr>
									</table>
								</td>
								<td class="panel_right_bg" width="9px"><img src="/final/admin/eg_images/spacer.gif" width="9"></td>
							</tr>
							<tr>
								<td class="panel_bottom_left"><img src="/final/admin/eg_images/spacer.gif" width="5" height="10"></td>
								<td class="panel_bottom_bg" height="10"><img src="/final/admin/eg_images/spacer.gif"></td>
								<td class="panel_bottom_right"><img src="/final/admin/eg_images/spacer.gif" width="9" height="10"></td>
							</tr>
						</table>
						</div>
<%
				}
				else
				{
					String tmpStr = "No groups available for selection.";
					if (!searchString.equals("") && searchString.length() > 0)
					{
						tmpStr = "No groups found.";
					}
%>
					<table align="center" border="0" cellpadding="0" cellspacing="0" width="95%">
					<tr>
						<td style="padding-top:6px" class="font_bold12"><b>&nbsp;<egui:intnl text="SELECT DOMAIN GROUPS FOR REGISTRATION"/></b></td>
					</tr>
					<tr>
						<td class="eg_blankspace" height="3">&nbsp;</td>
					</tr>
					<tr>
						<td width="100%" class="page_tab_bg" style="padding:4px;border-top-width:0px">
							<table align="center" border="0" width="100%" class="tableborder_ad" cellpadding="6" cellspacing="0">
								<tr>
									<td class="tdborder_ad font_normal12" align="center"><b><%=tmpStr%></b></td>
								<tr>
							</table>
						</td>
					</tr>
					</table>
<%
				}
			}
		//}
	//}
%>
			<br/></div>
			<div>
<%
		if (totalPages > 1)
		{
%>
			<script language = "javascript">
				var pageNoFirst = "<%=pageNo != null ? pageNo :defaultPageNo%>";

				var pageNo = parseInt(pageNoFirst);
				var j = parseInt(pageNoFirst);

				if (j > 1)
					j = j - 5;

				if (j < 1)
					j = 1;

				var upperLimit;

				var next = "next";
				var prev = "prev";
				var first = "first";
				var last = "last";
				upperLimit = parseInt("<%=totalPages%>");

				document.write("<table align=\"center\" border=\"0\">");
				document.write("<tr>");
				document.write("<td>&nbsp;</td>");
				document.write("</tr>");
				document.write("<tr>");
					

				if (pageNo > 1)
				{
					document.write("<td>");
					document.write("<a id=\"eg_monlink\" href='javascript:getPageNo(" + first + ")'><img src=\"/final/admin/eg_images/back-arrow.gif\" border=\"0\"><img src=\"/final/admin/eg_images/back-arrow.gif\" border=\"0\">&nbsp;<b><egui:intnl text='admin.common.First'/></b></a>");
					document.write("</td>");
				}
				else
				{
					document.write("<td>");
					document.write("<img src=\"/final/admin/eg_images/back-arrow.gif\" border=\"0\">");
					document.write("<img src=\"/final/admin/eg_images/back-arrow.gif\" border=\"0\">");
					document.write("&nbsp;");
					document.write("<egui:intnl text='admin.common.First'/>");
					document.write("</td>");
				}

				document.write("<td>&nbsp;");
				document.write("</td>");

				

				if (pageNo > 1)
				{
					document.write("<td>");
					document.write("&nbsp;<a id=\"eg_monlink\" href='javascript:getPageNo(" + prev + ")'><img src=\"/final/admin/eg_images/back-arrow.gif\" border=\"0\">&nbsp;<b><egui:intnl text='admin.common.Prev'/></b></a>");
					document.write("</td>");
				}
				else
				{
					document.write("<td>");
					document.write("<img src=\"/final/admin/eg_images/back-arrow.gif\" border=\"0\">");
					document.write("&nbsp;");
					document.write("<egui:intnl text='admin.common.Prev'/>");
					document.write("</td>");
				}

				document.write("<td>");
				for (var i = 0; i < 10; i++)
				{
					if (j <= upperLimit)
					{
						document.write("&nbsp;&nbsp;");

						if (pageNo != j)
						{
							document.write("<a id=\"eg_monlink\" href='javascript:getDirectPageNo(" + j + ")'>" + j + "</a>");
						}
						else
						{
							document.write("<span id=\"page_no\">"+j+"</span>");
							
						}
						document.write("&nbsp;&nbsp;");
					}

					j++;
				}
				document.write("</td>");

				if (pageNo < upperLimit)
				{
					document.write("<td>");
					document.write("<a id=\"eg_monlink\" href='javascript:getPageNo(" + next + ")'><b><egui:intnl text='admin.common.Next'/></b>&nbsp;<img src=\"/final/admin/eg_images/forward-arrow.gif\" border=\"0\"></a>");
					document.write("</td>");
				}
				else
				{
					document.write("<td>");
					document.write("<egui:intnl text='admin.common.Next'/>");
					document.write("&nbsp;");
					document.write("<img src=\"/final/admin/eg_images/forward-arrow.gif\" border=\"0\">");
					document.write("</td>");
				}

				document.write("<td>&nbsp;");
				document.write("</td>");


				if (pageNo < upperLimit)
				{
					document.write("<td>");
					document.write("&nbsp;<a id=\"eg_monlink\" href='javascript:getPageNo(" + last + ")'><b><egui:intnl text='admin.common.Last'/></b>&nbsp;<img src=\"/final/admin/eg_images/forward-arrow.gif\" border=\"0\"><img src=\"/final/admin/eg_images/forward-arrow.gif\" border=\"0\"></a>");
					document.write("</td>");
				}
				else
				{
					document.write("<td>");
					document.write("&nbsp;<egui:intnl text='admin.common.Last'/>");
					document.write("&nbsp;");
					document.write("<img src=\"/final/admin/eg_images/forward-arrow.gif\" border=\"0\">");
					document.write("<img src=\"/final/admin/eg_images/forward-arrow.gif\" border=\"0\">");
					document.write("</td>");
				}
				document.write("</tr>");
				document.write("</table>");
			</script>
<%
		}
%>
			</div>
		</td>
	</tr>
<%
	}
	else
	{
%>
			</table>
			<table height="350px" align="center" cellspacing="0" cellpadding="0" width="80%" border="0" >
				<tr>
<%
		ArrayList error = (ArrayList)session.getAttribute("errorList");
		if (error == null || error.size() == 0)
		{
			if (searchString.equals("") || searchString.length() == 0)
			{
%>
					<script>hideSearchMenu()</script>
					<td align="center">
						<img src="/final/admin/eg_images/exclamation-icon.gif"> <br/> <b><egui:intnl text="admin.user.No groups exist"/>.</b>
					</td>
<%
			}
			else
			{
%>
					<td align="center">
						<img src="/final/admin/eg_images/exclamation-icon.gif"> <br/> <b><egui:intnl text="admin.user.No groups found for your currenr search"/>,&nbsp;<i><%=searchString%></i></b>
					</td>
<%
			}
		}
		else
		{
			IniFile egErrorsIni = null;
			String code = (String)getErrorMessage(error);
			session.setAttribute("domainError",error);
			String errorDescription = "";
			String reasons = "";
			String solution = "";
			if(egErrorsIni == null)
			{
				egErrorsIni = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_errors.ini");
			}

			errorDescription = egErrorsIni.getValue("AD_ERRORS","ERR_"+code);
			reasons = egErrorsIni.getValue("LDAP_ERROR_DESCRIPTIONS","ERR_"+code);
			solution = egErrorsIni.getValue("LDAP_RESOLUTION","ERR_"+code);

			if (errorDescription == null || errorDescription.length() == 0)
			{
				errorDescription = "Could not find error description";
			}
%>
					<td>
						<table border="0" cellspacing="0" cellpadding="5" style="list-style-type:none">
							<tr>
								<td colspan="2" align="center"><b><egui:intnl text="admin.user.DOMAIN AUTHENTICATION ERROR"/></b>
								</td>
							</tr>
							<tr>
								<td align="left" width="20%" class="tdborder_ad">&nbsp;<b><egui:intnl text="admin.auth.ERROR"/></b></td>
								<td align="left" width="600px" class="tdborder_ad"><%=errorDescription%></td>
							</tr>
							<tr>
								<td align="left" width="20%" class="tdborder_ad">&nbsp;<b><egui:intnl text="admin.auth.DESCRIPTION"/></b></td>
								<td align="left" width="600px" class="tdborder_ad"><%=reasons%></td>
							</tr>
<%
					if (solution != null && !solution.equalsIgnoreCase(""))
					{
%>
							<tr>
								<td align="left" width="20%" class="tdborder_ad">&nbsp;<b><egui:intnl text="admin.auth.RESOLUTION"/></b></td>
								<td align="left" width="600px" class="tdborder_ad"><%=solution%></td>
							</tr>
<%
					}
%>
							<tr>
								<td height="3" colspan="2">&nbsp;</td>
							</tr>
							<tr>
								<td colspan="2" align="center"><a class="body_link" href="javascript:void(0);" onclick="javascript:openRootCauseWindow()"><b><egui:intnl text="admin.filter.Click here"/>&nbsp;<img border="0" src="/final/admin/eg_images/icon_click.gif"></b></a> to view the root cause of this error.</td>
							</tr>
						</table>
					</td>
<%
		}
%>
				</tr>
			</table>
		</td>
	</tr>
<%
	}
%>
</table>
</form>
<script>
	if ('<%=searchString%>' != "")
	{
		document.egGroup.searchBox.focus();
	}
</script>
</body>
</html>
<script>
	var parentWindowObj = window.parent;
	var pageHeader = "";
	var selectedGroup = "<%=selectedGroup%>";
	if (selectedGroup != null && selectedGroup.toLowerCase() == "all")
	{
		pageHeader = '<egui:intnl text="admin.test.List of all domain groups" />';
	}
	else
	{
		pageHeader = '<egui:intnl text="admin.test.List of domain groups in" />';
		pageHeader = pageHeader + " '"+selectedGroup+"'";
	}
	parentWindowObj.setWindowTitle(pageHeader);

	function getPageNo(key)
	{
		var pagaNoStr = "<%=pageNo != null ? pageNo :defaultPageNo%>";
		var pageNo = parseInt(pagaNoStr);
		var upperLimit;
		upperLimit = parseInt("<%=totalPages%>");

		if (key == "next")
		{
			if (pageNo >= upperLimit)
				pageNo = upperLimit;

			else
				pageNo = pageNo + 1;
		}
		else if (key == "prev")
		{
			if (pageNo <= 1)
				pageNo = 1;

			else
				pageNo = pageNo - 1;
		}
		else if (key == "first")
		{
			pageNo = 1;
		}
		else if (key == "last")
		{
			pageNo = upperLimit;
		}

		var c_groups = getCheckedGroups();
		document.egGroup.checkedGroups.value = c_groups;
		//new change
		document.egGroup.pageNo.value = pageNo;
		document.egGroup.method = "post";
		document.egGroup.action = "EgListDomainGroups.jsp";
		document.egGroup.submit();
	//End of new change
	}

	function getDirectPageNo(pageNo)
	{
		var c_groups = getCheckedGroups();
		document.egGroup.checkedGroups.value = c_groups;
		//new change
		document.egGroup.pageNo.value = pageNo;
		document.egGroup.method = "post";
		document.egGroup.action = "EgListDomainGroups.jsp";
		document.egGroup.submit();
	//End of new change
	}

	function getCheckedGroups()
	{
		myArray = window.parent.groupArray;
		var item = "";
		c = 0;
		if (myArray != null && myArray.length > 0)
		{
			for (i=0;i<myArray.length;i++)
			{
				if (myArray[i] != null && myArray[i] != "undefiend")
				{
					if (c == 0)
					{
						item = item + myArray[i];
					}
					else
					{
						item = item +"|#|"+myArray[i];
					}
					c++;
				}
			}
		}
		return item;
	}
</script>
<%!
	public String getErrorMessage(ArrayList stausList)
	{
		String errCode = "E999";
		if(stausList.contains("EXCEPTION"))
		{
			int idx = stausList.indexOf("EXCEPTION");
			Exception e =(Exception)stausList.get(idx+1);
			String errorStr = e.toString();
			if (errorStr.startsWith("javax.naming.AuthenticationException"))
			{
				String errMessage = e.getMessage();
				StringTokenizer strTokens = new StringTokenizer(errMessage,",");
				while(strTokens.hasMoreTokens())
				{
					String tok = strTokens.nextToken();
					if (tok.startsWith(" data "))
					{
						errCode = tok.substring(tok.indexOf(" ",1)+1);
					}
				}
			}
			else if (errorStr.startsWith("javax.naming.NoPermissionException"))
			{
				errCode = "50";
			}
			else if (errorStr.startsWith("javax.naming.CommunicationException"))
			{
				if (errorStr.indexOf("SSLHandshakeException") > -1 || errorStr.indexOf("ValidatorException") > -1 || errorStr.indexOf("SunCertPathBuilderException") > -1)
				{
					errCode = "E010";
				}
				else
				{
					errCode = "2";
				}
			}
			else if (errorStr.startsWith("javax.naming.ServiceUnavailableException"))
			{
				errCode = "51";
			}
			else if(errorStr.startsWith("java.net.UnknownHostException"))
			{
				errCode = "E001";
			}
			else if (errorStr.startsWith("javax.naming.NamingException"))
			{
				errCode = "E999";
			}
			else
			{
				errCode = "E999";
			}
		}
		else if (stausList.contains("KERBEROS"))
		{
			int idx = stausList.indexOf("KERBEROS");
			String  errorStr =(String )stausList.get(idx+1);
			if (errorStr.startsWith("javax.naming.AuthenticationException"))
			{
				StringTokenizer strTokens = new StringTokenizer(errorStr,",");
				while(strTokens.hasMoreTokens())
				{
					String tok = strTokens.nextToken();
					if (tok.startsWith(" data "))
					{
						errCode = tok.substring(tok.indexOf(" ",1)+1);
					}
				}
			}
			else if (errorStr.startsWith("javax.net.ssl.SSLHandshakeException"))
			{
				errCode = "E010";
			}
			else if (errorStr.startsWith("Receive timed out"))
			{
				errCode = "E011";
			}
			else if (errorStr.startsWith("Clients credentials have been revoked"))
			{
				errCode = "E012";
			}
			else if (errorStr.startsWith("Server not found in Kerberos database"))
			{
				errCode = "E013";
			}
			else if (errorStr.startsWith("KDC has no support for encryption type"))
			{
				errCode = "E014";
			}
			else if (errorStr.startsWith("PRE_EXCEPTION"))
			{
				int idxy = stausList.indexOf("PRE_EXCEPTION");
				Exception e =(Exception)stausList.get(idxy+1);
				errorStr = e.toString();
				if (errorStr.startsWith("javax.naming.AuthenticationException"))
				{
					StringTokenizer strTokens = new StringTokenizer(errorStr,",");
					while(strTokens.hasMoreTokens())
					{
						String tok = strTokens.nextToken();
						if (tok.startsWith(" data "))
						{
							errCode = tok.substring(tok.indexOf(" ",1)+1);
						}
					}
				}
				else if (errorStr.startsWith("javax.naming.NoPermissionException"))
				{
					errCode = "50";
				}
				else if (errorStr.startsWith("javax.naming.CommunicationException"))
				{
					if (errorStr.indexOf("SSLHandshakeException") > -1 || errorStr.indexOf("ValidatorException") > -1 || errorStr.indexOf("SunCertPathBuilderException") > -1)
					{
						errCode = "E010";
					}
					else
					{
						errCode = "2";
					}
				}
				else if (errorStr.startsWith("javax.naming.ServiceUnavailableException"))
				{
					errCode = "51";
				}
				else if(errorStr.startsWith("java.net.UnknownHostException"))
				{
					errCode = "E001";
				}
				else if (errorStr.startsWith("javax.naming.NamingException"))
				{
					errCode = "E999";
				}
				else
				{
					errCode = "E999";
				}
			}
			else if (errorStr.startsWith("Clock skew too great"))
			{
				errCode = "E004";
			}
			else if (errorStr.startsWith("Identifier"))
			{
				errCode = "E006";
			}
			else if (errorStr.startsWith("Client not found in Kerberos database"))
			{
				errCode = "E007";
			}
			else if (errorStr.startsWith("Pre-authentication"))
			{
				errCode = "E005";
			}
			else if (stausList.contains("USER_EXCEPTION"))
			{
				errCode = "525";
			}
			else if (errorStr.startsWith("Invalid User"))
			{
				errCode = "E008";
			}
			else if (errorStr.startsWith("javax.naming.NoPermissionException"))
			{
				errCode = "50";
			}
			else if (errorStr.startsWith("javax.naming.CommunicationException"))
			{
				if (errorStr.indexOf("SSLHandshakeException") > -1 || errorStr.indexOf("ValidatorException") > -1 || errorStr.indexOf("SunCertPathBuilderException") > -1)
				{
					errCode = "E010";
				}
				else
				{
					errCode = "2";
				}
			}
			else if (errorStr.startsWith("javax.naming.ServiceUnavailableException"))
			{
				errCode = "51";
			}
			else if(errorStr.startsWith("java.net.UnknownHostException"))
			{
				errCode = "E001";
			}
			else if (errorStr.startsWith("javax.naming.NamingException"))
			{
				errCode = "E999";
			}
			else
			{
				errCode = "E999";
			}
		}
		else if (stausList.contains("USER_EXCEPTION"))
		{
			errCode = "525";
		}
		else if (stausList.contains("Others"))
		{
			int idx = stausList.indexOf("Others");
			String  errorStr =(String )stausList.get(idx+1);
			
			if (errorStr.startsWith("Invalid User"))
			{
				errCode = "E008";
			}
		}
		else if (stausList.contains("SocketException"))
		{
			errCode = "E001";
		}
		return errCode;
	}

	public ArrayList getRegisteredGroups(ArrayList ad_groups,Vector e_groups)
	{
		ArrayList result = new ArrayList();
		for (int i = 0;i<ad_groups.size();i++)
		{
			String grp_name = (String)ad_groups.get(i);
			if (e_groups.contains(grp_name))
			{
				result.add(grp_name);
			}
		}
		return result;
	}
%>