<%
/**
*	File name	:	EgPrintTestConfigParameters.jsp
*	Purpose		:	Print page for agents test configuration parameters
**/
%>

<%@ include file="EgTrackerA.jsp" %>
<%@ page errorPage="EgProbs.jsp"%>
<%@ page import="com.egurkha.ini.IniUI"%>
<%@ page import = "com.egurkha.util.DateUtil" %>
<%@ page import = "com.eg.EgDbInfo"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "com.egurkha.EgTimeZoneConverter"%>
<%@ page import = "com.egurkha.admin.TestConfigParameters"%>

<%@ taglib prefix ="egui" uri= "../WEB-INF/eg-taglib.tld"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>

<%!
	public String removeNull(String component)
	{
		return (component.endsWith(":NULL"))?component.substring(0,component.indexOf(":NULL")):component;
	}

	public static ArrayList breakString(String givenString,int screenLen)
	{
		ArrayList aListResultant = new ArrayList();
		int strLen = givenString.length();
		int resLen = strLen/screenLen;
		int idx = 0;
		int k = 0;
		if (givenString.indexOf(" ")>-1)
		{
			for (int i=0;i<resLen;i++)
			{
				String res = givenString.substring(idx,idx+screenLen);
				int s = res.length();
				if (res.charAt(s-1)==' ')
				{
					res = res.trim();
					aListResultant.add(res);
					idx = idx+screenLen;
				}
				else
				{
					k = res.lastIndexOf(" ");
					if (k==0 || k == -1)
					{
						aListResultant.add(res.substring(0));
						idx = idx+screenLen;
					}
					else
					{
						aListResultant.add(res.substring(0,k));
						String temp = res.substring(k);
						int m = temp.length();
						idx = idx+screenLen;
						idx = idx-m;
					}
				}
				if (i == resLen-1)
				{
					int lastLen = strLen-idx;
					if (lastLen > screenLen)
					{
						resLen = resLen+1;
					}
				}
			}
			String ss = givenString.substring(idx).trim();
			aListResultant.add(ss);
		}
		else
		{
			for (int i=0;i<resLen ;i++)
			{
				String res = givenString.substring(idx,idx+screenLen);
				aListResultant.add(res);
				idx = idx+screenLen;
			}
			aListResultant.add(givenString.substring(idx));
		}
		return aListResultant;
	}
%>

<html>
<head>
<!-- <link rel="stylesheet" type="text/css" href="/final/styles/eGLightTheme.css" />
<link rel="stylesheet" type="text/css" href="/final/styles/eGLightThemeIcons.css" /> -->
<style>

@media print {body {-webkit-print-color-adjust: exact;}}


@font-face{font-family:'LucidaGrandeRegular';src:url('/../../fonts/6216/6216.woff') format('woff')}
@font-face{font-family:'LucidaGrandeBold';src:url('/../../fonts/6215/6215.woff') format('woff')}

body{font-family:'LucidaGrandeRegular';font-size:12px;line-height:1.5em;color:#2a292a;}
.header{font-family:'LucidaGrandeRegular';font-size:15px;}
.formLabel {font-family:'LucidaGrandeRegular';font-size:13px;}
.formValue {font-family:'LucidaGrandeBold';font-size:13px;}
b{font-family:'LucidaGrandeBold';font-size:12px;}

table tr td{font-family:'LucidaGrandeRegular';font-size:12px;padding:4px;}

.printTable{border: 1px solid #c3c3c3; border-collapse: collapse;}
.printTable tr th{border: 1px solid #c3c3c3;padding:4px;background-color:#e2e2e2;font-family:'LucidaGrandeBold';font-size:12px;}
.printTable tr td{border: 1px solid #c3c3c3;padding:4px;}

.printTableHeader{font-family:'LucidaGrandeBold';border: 1px solid #c3c3c3;text-align:center;background-color:#cdcdcd;padding:4px;}

</style>
</head>
<body style="padding:10px">

<%
	String userLanguage = _user.getLanguage();
	IniUI iniUI = IniUI.getInstance();
	if (userLanguage == null)
	{
		userLanguage = iniUI.getDefaultLanguage();
	}

	String compType = request.getParameter("componentType");
	String compName = request.getParameter("componentName");

	if (compType == null || compType.equals("-1"))
	{
		compType = "All";
	}

	if (compName == null || compName.equals("-1"))
	{
		compName = "All";
	}

	EgDbInfo dbInfo = new EgDbInfo("manager");
	String fontStyle = "";
	if (dbInfo.doubleByteEnabled || !userLanguage.equals("en_US"))
	{
		fontStyle = "multi_font";
	}

	//For PDF
	String uiFile = "eg_ui.ini";
	String iniFileDir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile egUI = new IniFile(iniFileDir + uiFile);
	String currentDateFormat = egUI.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	Date date = new Date(System.currentTimeMillis());
	String currentDateTime = DateUtil.formatDate(date,currentDateFormat+" HH:mm:ss");

	EgTimeZoneConverter timeZoneConverter = new EgTimeZoneConverter(currentDateTime,_user);
	currentDateTime = (String)timeZoneConverter.getDateTime();

	String subTitle = "";
	if (compType.equalsIgnoreCase("All") && compName.equalsIgnoreCase("All"))
	{
		subTitle = _mapping.getTextDescription("admin.test.All Component Types")+ " " + ":" + " "+_mapping.getTextDescription("admin.test.All Components");
	}
	else if (!compType.equalsIgnoreCase("All"))
	{
		if (compName.equalsIgnoreCase("All"))
		{
			subTitle = _mapping.getComponentTypeDescription(compType) + " " + ":" + " " + _mapping.getTextDescription("admin.test.All Components");
		}
		else
		{
			subTitle = _mapping.getComponentTypeDescription(compType) + " " + ":" + " " + removeNull(compName);
		}
	}

	String mainTitle = _mapping.getTextDescription("admin.test.Test Configuration Report for") + "&nbsp;" + subTitle;
	String genDate = _mapping.getTextDescription("admin.test.as on")+ "&nbsp;" + currentDateTime;

	String logo=iniUI.getMonitorHomeLogo();
	if(iniUI.isHKTThemeEnabled())
	{
		logo = iniUI.getHKTReporterLogo();
	}
%>
<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" valign="top">
	<tr>
		<td width="100%" align="center" height="100%" valign="top">

			<table cellpadding="0" cellspacing="0" border="0" width="100%" align="center">
				<tr>
					<td style="padding:5px 10px 10px 10px"><img src='<%=logo%>' border="0" /></td>
				</tr>
			</table>

			<table width="100%" border="0" cellspacing="0" cellpadding="0" align="center"  style="border-bottom:1px solid #999;">
				<tr>
					<td style="padding:2px">
						<div style="float:left" class="header"><%=mainTitle%></div>
						<div style="float:right" class="header"><%=genDate%></div>
					</td>
				</tr>
			</table>
		</td>
	</tr>
	<tr>
		<td height="30" class="eg_blankspace">&nbsp;<img src="/final/admin/eg_images/spacer.gif" border="0"></td>
	</tr>
</table>
<%
	TestConfigParameters tView = new TestConfigParameters();
	TreeMap tmap_TestDetailsForComp = new TreeMap();
	TreeMap tmap_CompTypeKey = new TreeMap();
	ArrayList aListResultantTests = new ArrayList();

	ArrayList aListTests = new ArrayList();
	ArrayList aListSelectedTests = new ArrayList();
	ArrayList aListTestsParams = new ArrayList();
	ArrayList aListTempTest = new ArrayList();

	ArrayList aListPrintCTsCNs = (ArrayList)request.getAttribute("aListPrintCTsCNs");

	if (aListPrintCTsCNs != null)
	{
		for (int k=0;k<aListPrintCTsCNs.size();k++)
		{
			String compoTypeName = (String)aListPrintCTsCNs.get(k);

			ArrayList compValue = StringUtils.egTokenizer(compoTypeName,"~|~");
			String componentType = (String)compValue.get(0);
			String componentName = (String)compValue.get(1);
			tmap_TestDetailsForComp = tView.getTestsParams(componentType,componentName);
			if (tmap_TestDetailsForComp != null && tmap_TestDetailsForComp.size()>0)
			{
				tmap_CompTypeKey = (TreeMap)tmap_TestDetailsForComp.get(componentType);
				aListResultantTests = (ArrayList)tmap_CompTypeKey.get(componentName);
				String testType = "";
				String display = "";

				for (int rs=0;rs<aListResultantTests.size();rs++)
				{
					if (rs == 0)
					{
						testType = "PerformanceTest";
					}
					else if (rs == 1)
					{
						testType = "ConfigurationTest";
					}
					aListTests = (ArrayList)aListResultantTests.get(rs);
					aListSelectedTests = (ArrayList)aListTests.get(0);
					if (aListSelectedTests.size()== 0)
					{
						display = "false";
					}
					else
					{
						display = "true";
					}
					String type = "";
					String test = "";
					if (aListSelectedTests.size()== 0)
					{
%>
		
			<table border="0" cellspacing="0" cellpadding="0" width="100%"  align="center" class="table_border">
				<tr>
					<td width="100%"  align="left" ><b> <%=removeNull(componentName)%> (<egui:intnl type="<%=componentType%>"/>)</b></td>
				</tr>
				<tr>
					<td height="10" class="eg_blankspace">&nbsp;<img src="/final/admin/eg_images/spacer.gif" border="0"></td>
				</tr>
				<tr>
					<td align="center" width="10%" class="eg_subhead <%=fontStyle%>" nowrap  height="60">
						<img src="/final/admin/eg_images/<%=admin_Skin%>/exclamation-icon.gif"><br><%=removeNull(componentName)%>&nbsp;<b><egui:intnl text="admin.test.is managed in an agentless manner"/></b>.&nbsp;<b><egui:intnl text="admin.test.No agentless performance tests are currently available."/></b>.
					</td>
				</tr>
			</table><br/>
<%
						continue;
					}
					if (aListSelectedTests.size() > 0)
					{
						String isConfig = (String)aListSelectedTests.get(0);
						if (isConfig.indexOf("_cf")>1)
						{
							testType = "ConfigurationTest";
						}
%>

			<br/>
			<table align='center' cellspacing='0' cellpadding='0' border='0'  width="100%" >
				<tr>
<%
						if (testType.equals("PerformanceTest"))
						{
							type = "Performance Tests";
%>
					<td align="left" class="formValue"><%=removeNull(componentName)%> (<egui:intnl type="<%=componentType%>"/>) - <%=type%></td>
<%
						}
						else
						{
							type = "Configuration Tests";
%>
					<td align="left" class="formValue"><%=removeNull(componentName)%> (<egui:intnl type="<%=componentType%>"/>) - <%=type%></td>
<%
						}
%>
				</tr>
			</table>
<%
					}
					aListTestsParams = (ArrayList)aListTests.get(1);
					for (int lt=0;lt<aListTestsParams.size();lt++)
					{
						test = (String)aListSelectedTests.get(lt);
%>

				<table align='center' cellspacing='0' cellpadding='0' border='0' class='printTable' width="100%" style="table-layout:fixed"><col width="40%"><col width="60%">
						<tr>
							<th style='text-align:left;' colspan="2"><egui:intnl test="<%=test%>"/></th>
						</tr>
<%
						aListTempTest = (ArrayList)aListTestsParams.get(lt);
						ArrayList aListData = new ArrayList();

						boolean cellFlag = false;

						for (int t=0;t<aListTempTest.size();t=t+2)
						{
							String key = (String)aListTempTest.get(t);
							String value = (String)aListTempTest.get(t+1);
							if (value.startsWith("\"") && value.endsWith("\""))
							{
								value = value.substring(1,value.length()-1);
							}
%>
							<tr>
								<td nowrap valign="top"><egui:intnl text='<%="admin.test."+key.toUpperCase()%>'/></td>
<%
							int i_limit = 85;
							if (value.length()>i_limit)
							{
%>
								<td valign="top">
<%
								ArrayList aListStrValues = breakString(value,i_limit);
								for (int r=0;r<aListStrValues.size();r++)
								{
									String str_value = (String)aListStrValues.get(r);
									out.print(str_value+"<br>");
								}
%>
								</td>
<%
							}
							else
							{
%>
								<td valign="top"><%=value%></td>
<%
							}
%>
								</tr>
<%
						}
%>
				</table>
<%
					}
				}
			}
			else
			{
%> 
			
				<table border="0" cellspacing="0" cellpadding="0"  align="center" class="table_border" width="100%" >
					<tr>
						<td>
							<table align="center"   cellspacing="0" cellpadding="0" border="0" height="22">
								<tr>
									<td align="left" id="eg_subheadbg" ><strong> <%=removeNull(componentName)%> (<egui:intnl type="<%=componentType%>"/>)</strong></td>
								</tr>
							</table>
						</td>
					</tr>
					<tr>
						<td height="10" class="eg_blankspace">&nbsp;<img src="/final/admin/eg_images/spacer.gif" border="0"></td>
					</tr>
					<tr>
						<td align="center" width="10%" class="eg_subhead" nowrap  height="60">
							<img src="/final/admin/eg_images/<%=admin_Skin%>/exclamation-icon.gif"><br>&nbsp;&nbsp;&nbsp;<egui:intnl text="admin.test.All the tests of this component are excluded"/>
						</td>
					</tr>
				</table>
				<table align="center" cellspacing="0" cellpadding="0" border="0" style="table-layout:fixed">
						<tr>
							<td height="8" class="eg_blankspace">&nbsp;<img src="/final/admin/eg_images/spacer.gif" border="0"></td>
						</tr>
				</table>
<%
			}
		}
	}
%>
</body>
</html>



