<%
/*********************************************************************************************************
*	Name				:	EgLogoutA.jsp
*	Purpose				:	This code logs out the egurkha admin from the system
*	Version				:	eG 3.0
*	Creation Date		:	27/06/2000
*	Last Modified Date	:	27/11/2002	-	Sandhya	-	To display Manager IP in the title bar
*							12/11/2003	-	Williams		-	Server Time works now!!!
*							21/11/2003		Williams		-	Added EgAdminOperations.jsp as the HomePage
*	Author				:	BalaMurugan. V / John Williams
********************************************************************************************************/
%>
<%@ include file="EgTrackerA.jsp" %>
<%@ page errorPage="EgProbs.jsp"%>
<%@ page import="com.egurkha.EgUserRole" %>
<%@ page import="com.egurkha.admin.AdminOperations" %>
<%@ page import="com.eg.EgRoleInfo" %>
<%@ page import="com.eg.EgInstallInfo"%>
<%@ page import="com.eg.EgManagersIniForManager"%>
<%@ page import="com.egurkha.admin.UpdateTestPeriod"%>
<%@ page import="com.egurkha.admin.EgTestSpecification" %>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	
	UserRegistry reg = UserRegistry.getInstance();
	Map sessGrpUser = reg.getLoggedInGroupUsers();

	User t_user = reg.getUser(sessionID);
	EgUserRole object = t_user.getUserRole();
	String userName=t_user.getLoginID();
	String sess_user = (String)sessGrpUser.get(sessionID);

	if (userName != null && userName.indexOf("/Grp/") != -1)
	{
		String domainDispName = userName.substring(0,userName.indexOf("/Grp/"));

		if (sess_user != null && !sess_user.startsWith(domainDispName.trim()))
		{
			userName = sess_user;
		}
	}

	boolean isLocal = true;
	if (userName.indexOf("/")>-1)
	{
		isLocal = false;
	}

	boolean isCMEnabled = EgInstallInfo.isConfigSupported;
	if (isCMEnabled)
	{
		isCMEnabled = object.hasAnyConfigRole(EgUserPermission.CONFIG);
	}

	String show = "normalTest";
	if(isCMEnabled)
	{
		show = "both";
	}

	long perm = EgUserPermission.AGENT_TEST_CONFIG;
	boolean permission  = object.hasAdminRole(perm);
	String userid=request.getParameter("userid");
	EgRoleInfo ri=EgRoleInfo.getInstance(session.getId(),(String)session.getAttribute("sess_userid"));//by JJ
//	EgRoleInfo ri = new EgRoleInfo(session.getId());
	
	String fromTab = request.getParameter("fromTab");
	if (fromTab == null || fromTab.length() == 0)
	{
		fromTab = "admin";
	}

	IniFile ini = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_services.ini");
	String tempStr = ini.getValue("MISC_ARGS","ShowUnConfigTestsOnSignout");
	boolean showUnconfigTests = true;
	if (tempStr != null && (tempStr.trim().equalsIgnoreCase("no") || tempStr.trim().equalsIgnoreCase("false")))
	{
		showUnconfigTests = false;
	}
	if (showUnconfigTests && permission && !EgInstallInfo.isSuperManager && fromTab.equalsIgnoreCase("admin"))
	{
		AdminOperations ao=new AdminOperations(ri.getAllServers());
		String[] str = ao.getUnconfiguredTests();
		List listComponents = ri.getAllServers();
		int unConfiguredTestsCount = 0;
		if (listComponents != null && listComponents.size() > 0)
		{
			EgTestSpecification egTestSpecification = new EgTestSpecification(ri.getAllServers());
			TreeMap tmapUnConfigTests = egTestSpecification.getUnconfiguredTest();
			//unConfiguredTestsCount = egTestSpecification.getTotalUnconfiguredTestsCount(); //Bug: It counts _cf tests for no-config users too.
			// To find any unconfigured tests exist for this user.
			if (tmapUnConfigTests != null)
			{
				Iterator tmapIt = tmapUnConfigTests.keySet().iterator();
				while(tmapIt.hasNext())
				{
					String compType = (String)tmapIt.next();
					TreeMap compMap = (TreeMap)tmapUnConfigTests.get(compType);
					Iterator compMapIt = compMap.keySet().iterator();
					while(compMapIt.hasNext())
					{
						String comp = (String)compMapIt.next();
						ArrayList testsList = (ArrayList)compMap.get(comp);
						ArrayList perfTests = (ArrayList)testsList.get(0);
						ArrayList confTests = new ArrayList();
						if (testsList.size() > 1 && isCMEnabled)
						{
							confTests =(ArrayList) testsList.get(1);
						}
						unConfiguredTestsCount += perfTests.size() + confTests.size();
						if (unConfiguredTestsCount > 0)
						{
							break;
						}
					}
					if (unConfiguredTestsCount > 0)
					{
							break;
					}
				}
			}
		}

		boolean hasAdminTab=true;
		if(EgInstallInfo.isClusterSupported)
		{
			EgManagersIniForManager mi = EgManagersIniForManager.getInstance();
			if(mi != null && !mi.isPrimaryManager())
			{
				hasAdminTab=false;
			}
		}

		String s_check = request.getParameter("proceed");
		//this is for old signout page
		if(false && (s_check == null || s_check == ""))
		{
%>
			<jsp:useBean id="TestConfig" scope="page" class="egurkha.TestsNotConfigured"/>
<%
			if(str[0] !=null && str[0].length() >0 || new UpdateTestPeriod().getAggregateTestsWithoutRecommendedTestPeriod().size()>0)
			{
				if(userid!=null && userid.equalsIgnoreCase("true"))
				{
					String pageFwd = "../admin/EgUnconfigTests.jsp?from=logout&target=main&show="+show;
%>
					<jsp:forward page='<%=pageFwd%>'/>
<%
				}
			}
		}

		boolean hasUnConfiguredTests = false;
		if (hasAdminTab)
		{
			if (unConfiguredTestsCount > 0)
			{
				hasUnConfiguredTests = true;
			}
			else
			{
				if (EgInstallInfo.isAggregationSupported())
				{
					boolean hasAggregateComponent = false;
					for (int i=0;i<listComponents.size();i++)
					{
						String strComponent = (String)listComponents.get(i);
						String strCompType = strComponent.substring(0,strComponent.indexOf(":"));
						if (strCompType.startsWith("Agg_"))
						{
							hasAggregateComponent = true;
							break;
						}
					}

					if (hasAggregateComponent)
					{
						UpdateTestPeriod tempUpdateTestPeriod = new UpdateTestPeriod();
						Vector vecAgg = tempUpdateTestPeriod.getAggregateTestsWithoutRecommendedTestPeriod();
						if (vecAgg.size() > 0)
						{
							hasUnConfiguredTests = true;
						}
					}
				}
			}
		}
		String reqFrom = (String)session.getAttribute("clsTrial");
		if (reqFrom != null && reqFrom.equalsIgnoreCase("yes"))
		{
			hasUnConfiguredTests = false;
		}
		
		if(hasUnConfiguredTests)
		{
			String fromPage = request.getParameter("fromPage");
			if (fromPage != null && fromPage.equalsIgnoreCase("proceedingSignout"))
			{
				if(userid!=null && userid.equalsIgnoreCase("true"))
				{
					String strForward = "../admin/EgUnconfiguredTestsSummary.jsp?fromPage=proceedingSignout";
%>
					<jsp:forward page='<%=strForward%>'/>
<%
				}
			}
		}
	}

	// This is used to check the Internet availability
	session.removeAttribute("isInternetAvailable");
%>
<script language="javascript">
	if ('<%=fromTab%>' != null && '<%=fromTab%>' == "DemoScenarios")
	{
		window.parent.location="../servlet/com.egurkha.Logout?userName=<%=userName%>&isLocal=<%=isLocal%>&fromTab=DemoScenarios";
	}
	else
	{
		window.parent.location="../servlet/com.egurkha.Logout?userName=<%=userName%>&isLocal=<%=isLocal%>";
	}
</script>



