<%
/*
 *   File		:	EgIncludeComponents.jsp
 *   Purpose	:	Provides a mechanism to include components for a test
 *   Author		:	S.Anand (2009)
 *   UI Design	:	Jaiwin & Krishnamurthi
*/
%>

<%@ include file="EgTrackerA.jsp" %>
<%@ page errorPage="EgProbs.jsp" %>
<%@ page import="java.util.*" %>
<%@ page import="com.eg.EgRoleInfo" %>
<%@ page import="com.eg.EgSpecsInfo" %>
<%@ page import="com.eg.IniFile" %>
<%@ page import="com.eg.EgURLEncoder"%>
<%@ page import="com.egurkha.util.EgStackForBackButton"%>

<%@ taglib prefix ="egui" uri="../WEB-INF/eg-taglib.tld"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>

<%!
	EgSpecsInfo egSpecs = new EgSpecsInfo("manager");

	private ArrayList getArrayList(String strValue,String delimiter)
	{
		ArrayList aL = new ArrayList();
		StringTokenizer stTempTokens = new StringTokenizer(strValue,delimiter);
		while (stTempTokens.hasMoreTokens())
		{
			String str = stTempTokens.nextToken().trim();
			aL.add(str);
		}
		return aL;
	}
%>

<%
	EgRoleInfo ri = EgRoleInfo.getInstance(session.getId(),(String)session.getAttribute("sess_userid"));

	String componentType = request.getParameter("componentType");
	String componentName = request.getParameter("componentName");
	String pageRefreshed = request.getParameter("pageRefreshed");
	boolean isPageRefreshed = false;
	if (pageRefreshed == null)
	{
		pageRefreshed = "false";
	}
	else
	{
		pageRefreshed = "true";
		isPageRefreshed = true;
	}

	String managed = null;
	String unmanaged = null;
	if (pageRefreshed != null && pageRefreshed.equals("true"))
	{
		componentName = request.getParameter("mainComponentName");

		managed = request.getParameter("strManage");
		unmanaged = request.getParameter("strunManage");
	}

	String testType = request.getParameter("testType");
	testType = testType != null?testType:"PerformanceTest";
	String testForInclusion = request.getParameter("TestsForInclusion");
	String[] strComponents = ri.getAllServersOfType(componentType);
	List listComponents = Arrays.asList(strComponents);

	String currentComponentPattern = componentType + ":" + componentName;

	String query = "";
	//Scenario : Only one component is managed.
	if (listComponents.size() == 1 && listComponents.contains(currentComponentPattern))
	{
		query = "EgIncludeComponentTests.jsp?componentType="+EgURLEncoder.encode(componentType,"UTF-8")+"&componentName="+EgURLEncoder.encode(componentName,"UTF-8")+"&TestsForInclusion="+EgURLEncoder.encode(testForInclusion,"UTF-8")+"&testType="+EgURLEncoder.encode(testType,"UTF-8");
%>
		<jsp:forward page="<%=query%>" />
<%
	}

	IniFile disableIni = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_disable.ini");

	boolean isPortRelevantForTest = egSpecs.isPortRelevantForTest(testForInclusion);
	String subject = "";
	if (isPortRelevantForTest)
	{
		subject = componentType;
	}
	else
	{
		subject = "Default_server";
	}

	ArrayList aListTempComponents = new ArrayList(listComponents);
	ArrayList aListTests = new ArrayList();
	StringTokenizer st = new StringTokenizer(testForInclusion,",");
	while (st.hasMoreTokens())
	{
		String temp = st.nextToken();
		aListTests.add(temp);
	}

	ArrayList aListIncludedComponents=null;
	TreeMap tmapExcludedComps = null;
	TreeMap tmapCompsToBeIncluded = null;

	if (isPageRefreshed)
	{
		if (managed != null && managed.length() > 0)
		{
			tmapCompsToBeIncluded = new TreeMap();
			StringTokenizer stComponents = new StringTokenizer(managed,",");
			while (stComponents.hasMoreTokens())
			{
				String eachComponent = stComponents.nextToken();
				int hashIdx = eachComponent.indexOf("#");
				String strComponent = eachComponent.substring(0,hashIdx);
				String strTest = eachComponent.substring(hashIdx+1);
				ArrayList aListTempComps = (ArrayList)tmapCompsToBeIncluded.get(strTest);
				if (aListTempComps == null)
				{
					aListTempComps = new ArrayList();
					aListTempComps.add(strComponent);

					tmapCompsToBeIncluded.put(strTest,aListTempComps);
				}
				else
				{
					aListTempComps.add(strComponent);
				}
			}
		}

		if (unmanaged != null && unmanaged.length() > 0)
		{
			tmapExcludedComps = new TreeMap();
			StringTokenizer stComponents = new StringTokenizer(unmanaged,",");
			while (stComponents.hasMoreTokens())
			{
				String eachComponent = stComponents.nextToken();
				int hashIdx = eachComponent.indexOf("#");
				String strComponent = eachComponent.substring(0,hashIdx);
				String strTest = eachComponent.substring(hashIdx+1);
				ArrayList aListTempComps = (ArrayList)tmapExcludedComps.get(strTest);
				if (aListTempComps == null)
				{
					aListTempComps = new ArrayList();
					aListTempComps.add(strComponent);

					tmapExcludedComps.put(strTest,aListTempComps);
				}
				else
				{
					aListTempComps.add(strComponent);
				}
			}
		}
	}
	else
	{
		//ensure whether there are more than one components to be excluded.if not donot show this page
		boolean hasMoreThanOneCompToIncl = false;
		int compCount=0;
		int prevCompIdx=-1;
		for (int i=0;i<aListTests.size();i++)
		{
			String strTest = (String)aListTests.get(i);
			ArrayList aListStrExcludedComponents = null;
			ArrayList aListStrMainComponent = null;

			boolean isPortRelevantForStrTest = egSpecs.isPortRelevantForTest(strTest);
			String strSubject = "";
			if (isPortRelevantForStrTest)
			{
				strSubject = componentType;
			}
			else
			{
				strSubject = "Default_server";
			}

			List listVariables = Arrays.asList(disableIni.getVariables(strSubject));
			aListIncludedComponents = new ArrayList();
			for (int j=0;j<aListTempComponents.size();j++)
			{
				String strTempPattern = (String)aListTempComponents.get(j);
				String tempComponent = strTempPattern.substring(strTempPattern.indexOf(":")+1);
				String searchVariable = "";

				if (isPortRelevantForStrTest)
				{
					searchVariable = componentType + ":" + tempComponent;
				}
				else
				{
					searchVariable = "Default_server" + ":" + tempComponent.substring(0,tempComponent.indexOf(":"));
				}

				String strValue = disableIni.getValue(strSubject,searchVariable);
				ArrayList aListResultantTest = getArrayList(strValue,",");
				if (aListResultantTest.contains(strTest))
				{
					if (!hasMoreThanOneCompToIncl)
					{
						if (prevCompIdx == -1)
						{
							compCount++;
						}
						else
						{
							if (j != prevCompIdx)
							{
								compCount++;
							}
						}
						prevCompIdx=j;

						if (compCount > 1)
						{
							hasMoreThanOneCompToIncl = true;
						}
					}

					if (tempComponent.equals(componentName))
					{
						if (aListStrMainComponent == null)
						{
							aListStrMainComponent = new ArrayList();
						}

						aListStrMainComponent.add(componentName);
					}
					else
					{
						if (aListStrExcludedComponents == null)
						{
							aListStrExcludedComponents = new ArrayList();
						}

						aListStrExcludedComponents.add(tempComponent);
					}
				}
			}

			if (aListStrExcludedComponents != null)
			{
				if (tmapExcludedComps == null)
				{
					tmapExcludedComps = new TreeMap();
				}

				tmapExcludedComps.put(strTest,aListStrExcludedComponents);
			}

			if (aListStrMainComponent != null)
			{
				if (tmapCompsToBeIncluded == null)
				{
					tmapCompsToBeIncluded = new TreeMap();
				}

				tmapCompsToBeIncluded.put(strTest,aListStrMainComponent);
			}
		}

		if (!hasMoreThanOneCompToIncl)
		{
			query = "EgIncludeComponentTests.jsp?componentType="+EgURLEncoder.encode(componentType,"UTF-8")+"&componentName="+EgURLEncoder.encode(componentName,"UTF-8")+"&TestsForInclusion="+EgURLEncoder.encode(testForInclusion,"UTF-8")+"&testType="+EgURLEncoder.encode(testType,"UTF-8");
%>
			<jsp:forward page="<%=query%>" />
<%
		}
	}

	/* For back - start */
	EgStackForBackButton stackBackPages = (EgStackForBackButton)session.getAttribute("backList");
	String testChoosenToConfigure = request.getParameter("testChoosenToConfigure");

	if (testChoosenToConfigure == null)
	{
		String queryStr = "testType="+testType+"&componentType="+componentType+"&componentName="+componentName+"&showPopup=false";
		boolean isQueryUpdated = stackBackPages.addMultipleVariablesInQueryString("/final/admin/EgConfigureComponentTests.jsp?cType_HelpPage="+componentType,queryStr);
		if (!isQueryUpdated)
		{
			stackBackPages.addMultipleVariablesInQueryString("/final/admin/EgConfigureComponentTests.jsp?componentType="+componentType+"&componentName="+EgURLEncoder.encode(componentName,"UTF-8")+"&testType="+testType,"showPopup=false");
		}
	}
	else
	{
		String queryStr = "testType="+testType+"&componentType="+componentType+"&componentName="+componentName+"&testName="+testChoosenToConfigure+"&showPopup=false";
		stackBackPages.addMultipleVariablesInQueryString("/final/admin/EgConfigureComponentTests.jsp?cType_HelpPage="+componentType+"&tName_HelpPage="+testChoosenToConfigure,queryStr);
	}
	/* For back - end */
%>

<html>
<head>
<egui:skin ui="adminindex"/>
<META HTTP-EQUIV="expires" CONTENT="0">
<META HTTP-EQUIV="expires" CONTENT="0">
<script language="JavaScript">

function unManagedComponentToManagedComponent()
{
	//journey from unmanagedcomponent to managedcomponent
	var thisForm = document.list;
	var managedComponentLength = thisForm.managed.options.length;
	var unmanagedComponentLength = thisForm.unmanaged.options.length;
	var managedComponentList = thisForm.managed;
	var unmanagedComponentList = thisForm.unmanaged;
	if (unmanagedComponentList.selectedIndex == -1)
	{
		alert('<egui:intnl text="admin.test.Please choose a component"/>');
		return false;
	}
	else
	{
		for (var i=0; i<unmanagedComponentLength; i++)
		{
			if (unmanagedComponentList.options[i].selected == true)
			{
				var testTxt = unmanagedComponentList.options[i].text;
				var testVal = unmanagedComponentList.options[i].value;
				managedComponentList.options[managedComponentLength++] = new Option(testTxt,testVal);
			}
		}

		for (var i = unmanagedComponentLength; i>0; i--)
		{
			if(unmanagedComponentList.options[i-1].selected == true)
			{
				unmanagedComponentList.options[i-1] = null;
			}
		}
	}

	var managedComponentLen = thisForm.managed.options.length;
	var managedComponentList = thisForm.managed;

	var temp = "";
	for (var i=0; i<managedComponentLen; i++)
	{
		var testVal = managedComponentList.options[i].value;
		temp = temp + testVal + ",";
	}
	temp = temp.substring(0,temp.length-1);
	thisForm.strManage.value = temp;

	var unmanagedComponentLen = thisForm.unmanaged.options.length;
	var unmanagedComponentList = thisForm.unmanaged;

	var temp1 = "";
	for (var i=0; i<unmanagedComponentLen; i++)
	{
		var testVal = unmanagedComponentList.options[i].value;
		temp1 = temp1 + testVal + ",";
	}
	temp1 = temp1.substring(0,temp1.length-1);
	thisForm.strunManage.value = temp1;

	thisForm.method = "post";
	thisForm.action = "EgIncludeComponents.jsp";
	thisForm.submit();
}

function managedComponentTounManagedComponent()
{
	//journey from managedcomponent to unmanagedcomponent
	var thisForm = document.list;
	var managedComponentLength = thisForm.managed.options.length;
	var unmanagedComponentLength = thisForm.unmanaged.options.length;
	var managedComponentList = thisForm.managed;
	var unmanagedComponentList = thisForm.unmanaged;
	if (managedComponentList.selectedIndex == -1)
	{
		alert('<egui:intnl text="admin.test.Please choose a component"/>');
		return false;
	}
	else
	{
		for (var i=0; i<managedComponentLength; i++)
		{
			if (managedComponentList.options[i].selected == true)
			{
				var testTxt = managedComponentList.options[i].text;
				var testVal = managedComponentList.options[i].value;
				unmanagedComponentList.options[unmanagedComponentLength++] = new Option(testTxt,testVal);
			}
		}

		for (var i = managedComponentLength; i>0; i--)
		{
			if(managedComponentList.options[i-1].selected == true)
			{
				managedComponentList.options[i-1] = null;
			}
		}
	}

	var managedComponentLen = thisForm.managed.options.length;
	var managedComponentList = thisForm.managed;

	var temp = "";
	for (var i=0; i<managedComponentLen; i++)
	{
		var testVal = managedComponentList.options[i].value;
		temp = temp + testVal + ",";
	}
	temp = temp.substring(0,temp.length-1);
	thisForm.strManage.value = temp;

	var unmanagedComponentLen = thisForm.unmanaged.options.length;
	var unmanagedComponentList = thisForm.unmanaged;

	var temp1 = "";
	for (var i=0; i<unmanagedComponentLen; i++)
	{
		var testVal = unmanagedComponentList.options[i].value;
		temp1 = temp1 + testVal + ",";
	}
	temp1 = temp1.substring(0,temp1.length-1);
	thisForm.strunManage.value = temp1;

	thisForm.method = "post";
	thisForm.action = "EgIncludeComponents.jsp";
	thisForm.submit();
}

function apply()
{
	var thisForm = document.list;
	var managedComponentLen = thisForm.managed.options.length;
	var managedComponentList = thisForm.managed;
	var allowToSubmit = true;

	if (managedComponentLen==0)
	{
		alert('<egui:intnl text="admin.test.Please choose a component"/>');
		return false;
	}

	var temp = "";
	for (var i=0; i<managedComponentLen; i++)
	{
		var testVal = managedComponentList.options[i].value;
		temp = temp + testVal + ",";
	}
	temp = temp.substring(0,temp.length-1);
	thisForm.componentName.value = temp;
	thisForm.applybutton.disabled = true;
	thisForm.method = "post";
	thisForm.action = "EgIncludeComponentTests.jsp";
	thisForm.submit();
}

function isNetscape()
{
	// get browser info.
	appName= navigator.appName;
	appLongVer = navigator.appVersion;
	appVer = appLongVer.substring(0,1);
	// check for Navigator ver 4+.
	if ((appName == "Netscape") && (appVer >= 4)) return true;
	return false;
}

function isIE()
{
	// get browser info.
	appName= navigator.appName;
	appLongVer = navigator.appVersion;
	appVer = appLongVer.substring(0,1);
	// check for IE ver 4+.
	if ((appName == "Microsoft Internet Explorer") && (appVer >= 4)) return true;
	return false;
}

function showAgentSummary()
{
	document.getElementById('AgentSummaryHeading_2').style.display = 'none';
	if (isNetscape())
	{
		document.getElementById('AgentSummaryHeading_1').style.display = 'table-row';
		document.getElementById('AgentSummary').style.display = 'table-row';
	}
	else if (isIE())
	{
		document.getElementById('AgentSummaryHeading_1').style.display = 'block';
		document.getElementById('AgentSummary').style.display = 'block';
	}
}

function hideAgentSummary()
{
	document.getElementById('AgentSummaryHeading_1').style.display = 'none';
	if (isNetscape())
	{
		document.getElementById('AgentSummaryHeading_2').style.display = 'table-row';
		document.getElementById('AgentSummary').style.display = 'table-row';
	}
	else if (isIE())
	{
		document.getElementById('AgentSummaryHeading_2').style.display = 'block';
		document.getElementById('AgentSummary').style.display = 'block';
	}
	document.getElementById('AgentSummary').style.display = 'none';
}
</script>
</head>
<body style="overflow:auto" id="space6">
<form name="list" method="post" action="EgConfigureComponentTestsp.jsp" style="margin:0px">
<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0">
	<jsp:include page="listSearch.jsp?title=AGENT - TESTS - SPECIFIC CONFIGURATION&subtitle=false&backButton=true"/>

	<tr>
		<td width="100%" id="eg_whitebg" align="center">
			<table align="center" width="85%" cellspacing="0" cellpadding="0" border="0" class="eg_subcontentbg">
				<tr>
					<td height="6" id="inner_top_left" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
					<td height="6" id="eg_subcontentbg" colspan="3"><img src="/final/admin/eg_images/spacer.gif" height="6"></td>
					<td height="6" id="inner_top_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
				</tr>

				<tr id="AgentSummaryHeading_1">
					<td width="7" align="left"class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
					<td align="center" id="eg_subcontentbg" nowrap colspan="3" width="100%">
						<table border="0" cellspacing="0" cellpadding="2" width="100%">
							<tr>
								<td width="100%"><b><egui:intnl text="admin.test.admin.test.TEST(S) TO BE INCLUDED"/></b></td>
								<td style="width:30px" align="center"><img id="img0" class="mouse" src="/final/admin/eg_images/arrowup.gif" border="0" onClick="javascript:hideAgentSummary();"></td>
							</tr>
						</table>
					</td>
					<td width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
				</tr>

				<tr id="AgentSummaryHeading_2" style="display:none">
					<td width="7" align="left"class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
					<td align="center" id="eg_subcontentbg" nowrap colspan="3" width="100%">
						<table border="0" cellspacing="0" cellpadding="2" width="100%">
							<tr>
								<td width="100%"><b><egui:intnl text="admin.test.TEST(S) TO BE INCLUDED"/></b></td>
								<td style="width:30px" align="center"><img id="img0" class="mouse" src="/final/admin/eg_images/arrowdn.gif" border="0" onClick="javascript:showAgentSummary();"></td>
							</tr>
						</table>
					</td>
					<td width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
				</tr>

				<tr id="AgentSummary">
					<td width="7" align="left"class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
					<td colspan="3" align="center" width="100%" >
						<div class="div_scroll" style="width:100%;height:60px; border:0px solid #ff0000;">
						<table align="center" border="0" width="100%"  cellpadding="4" cellspacing="0" class="tableborder_ad">
<%
	for (int i=0;i<aListTests.size();i=i+3)
	{
		boolean border = true;
		if (i+1 == aListTests.size()) border = false;
%>
							<tr>
<%
		for (int j=i;j<i+3;j++)
		{
			if (j < aListTests.size())
			{
				String strTest = (String)aListTests.get(j);
				String strDisplay = _mapping.getTestDescription(strTest);
%>
								<td width="33%" class="tdborder_ad" valign="top"><%=strDisplay%> </td>
<%
			}
			else
			{
%>
								<td width="33%" class="tdborder_ad" valign="top">&nbsp;</td>
<%
			}
		}
%>
							</tr>
<%
	}
%>
						</table>
						</div>
					</td>
					<td width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
				</tr>

				<tr>
					<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
					<td id="eg_subcontentbg"  valign="top" colspan="3"><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
					<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
				</tr>
			</table>
		</td>
	</tr>


	<tr><td class="eg_blankspace" height="20px">&nbsp;</td></tr>

	<tr>
		<td style="padding:0px">
			<table align="center" cellspacing="0" cellpadding="4" border="0" width="85%" class="linesquare2">
				<tr>
					<td class="linebg" colspan="3">
						<table border="0" cellspacing="0" cellpadding="0" width="100%">
							<tr>
								<td width="50%" align="left"><strong><%=_mapping.getComponentTypeDescription(componentType)%>&nbsp;<egui:intnl text="admin.test.components"/></strong></td>
								<td width="50%" align="right">&nbsp;</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr><td class="eg_blankspace" height="4px" colspan="3">&nbsp;</td></tr>
				<tr>
					<td width="45%" style="padding:0px">
						<table align="center" cellspacing="0" cellpadding="0" border="0">
							<tr>
								<td id="eg_subheadbg" align='center' valign='middle' class="head_padding4" style="border-left-width:1px"><strong><egui:intnl text="admin.server.Components to be Included"/></strong></td>
							</tr>
							<tr>
								<td align="center" valign="middle">
									<select name="managed" size="20" multiple width="320" style="width:320px;">
<%
	if (tmapCompsToBeIncluded != null)
	{
		for (int i=0;i<aListTests.size();i++)
		{
			String strTest = (String)aListTests.get(i);
			ArrayList aListResultant = (ArrayList)tmapCompsToBeIncluded.get(strTest);
			if (aListResultant !=  null && aListResultant.size() > 0)
			{
				Collections.sort(aListResultant,String.CASE_INSENSITIVE_ORDER);
				String strLabel = _mapping.getTestDescription(strTest);
%>
				<optgroup label="<%=strLabel%>">
<%
				for (int j=0;j<aListResultant.size();j++)
				{
					String strComp = (String)aListResultant.get(j);
					String strDispComp = null;
					if (strComp.indexOf(":NULL") > -1)
					{
						strDispComp = strComp.substring(0,strComp.indexOf(":"));
					}
					else
					{
						strDispComp = strComp;
					}
%>
					<option value="<%=strComp+"#"+strTest%>"><%=strDispComp%></option>
<%
				}
%>
				<optgroup label="&nbsp;&nbsp;&nbsp;">
<%
			}
		}
	}
%>
									</select>
								</td>
							</tr>
						</table>
					</td>
					<td width="10%" align="center" valign="middle"  style="padding:0px">
						<input type="button" value='&lsaquo;&lsaquo;' class="eg_lightbutton" onClick="javascript:unManagedComponentToManagedComponent();" name="man" style="width: 85px; letter-spacing: 0px; font-size:13px; height:20px"><br><br><br>
						<input type="button" value='&rsaquo;&rsaquo;' class="eg_lightbutton" onClick="javascript:managedComponentTounManagedComponent();" name="unman" style="width: 85px; letter-spacing: 0px; font-size:13px; height:20px">
					</td>
					<td width="45%" style="padding:0px">
						<table align="center" cellspacing="0" cellpadding="0" border="0">
							<tr>
								<td id="eg_subheadbg" align='center' valign='middle' class="head_padding4"><strong><egui:intnl text="admin.server.Excluded Components"/></strong></td>
							</tr>
							<tr>
								<td align="center" valign="middle">
									<select name="unmanaged" size="20" multiple width="320" style="width:320px;">
<%
	if (tmapExcludedComps != null)
	{
		for (int i=0;i<aListTests.size();i++)
		{
			String strTest = (String)aListTests.get(i);
			ArrayList aListResultant = (ArrayList)tmapExcludedComps.get(strTest);
			if (aListResultant != null && aListResultant.size() > 0)
			{
				Collections.sort(aListResultant,String.CASE_INSENSITIVE_ORDER);
				String strLabel = _mapping.getTestDescription(strTest);
%>
				<optgroup label="<%=strLabel%>">
<%
				for (int j=0;j<aListResultant.size();j++)
				{
					String strComp = (String)aListResultant.get(j);
					String strDispComp = null;
					if (strComp.indexOf(":NULL") > -1)
					{
						strDispComp = strComp.substring(0,strComp.indexOf(":"));
					}
					else
					{
						strDispComp = strComp;
					}
%>
					<option value="<%=strComp+"#"+strTest%>"><%=strDispComp%></option>
<%
				}
%>
				<optgroup label="&nbsp;&nbsp;&nbsp;">
<%
			}
		}
	}
%>
									</select>
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr><td class="eg_blankspace" height="4px" colspan="3">&nbsp;</td></tr>
			</table>
		</td>
	</tr>
	<tr><td class="eg_blankspace" height="6px">&nbsp;</td></tr>
	<tr>
		<td width="100%" align="center">
			<input type="button" name="applybutton" value='<egui:intnl text="admin.test.Apply"/>' onClick="javascript:apply();" class="eg_back">
			<input type="hidden" name="componentType" value="<%=componentType%>">
			<input type="hidden" name="componentName" value="">
			<input type="hidden" name="mainComponentName" value="<%=componentName%>">
			<input type="hidden" name="testType" value="<%=testType%>">
			<input type="hidden" name="TestsForInclusion" value="<%=testForInclusion%>">
			<input type="hidden" name="showPopup" value='<%=request.getParameter("showPopup")%>'>
			<input type="hidden" name="pageRefreshed" value="true">
			<input type="hidden" name="strManage" value="">
			<input type="hidden" name="strunManage" value="">
		</td>
	</tr>
</table>
</form>
</body>
</html>



