<%
/*******************************************************************************
*       Name            :	EgHostCheck.jsp
*       Purpose         :       To list the host names given for a particular
				ip address and check if the given hostname is
				present in the host names list.If present we
				alert the user about the hostname and
				ask for confirmation for using the same host
				name for the server or not.
*       Version         :       2.0
*       CreationDate    :       18/12/2001
*       LastModified    :       26/03/2003 //sandhya - NICKNAMES 
				19/12/2001 
*       Author          :       KrishnaKumar.C
*******************************************************************************/
%>

<%@ include file="EgTrackerA.jsp"%>
<%@ page errorPage="EgProbs.jsp"%>
<%@ page import="java.util.*"%>
<%@ page import="com.egurkha.ini.IniUI"%>
<%@ page import="com.eg.EgDiscInfo"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ taglib prefix ="egui" uri="../WEB-INF/eg-taglib.tld"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<!--skm -->
<%@ page import = "com.eg.EgAggregateInfo" %>
<%@ page import = "com.eg.UpdateAndTransmitUserInfo" %>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page import = "com.eg.EgTopoInfo" %>
<%@ page import = "com.eg.EgExternalInfo" %>
<%@ page import = "com.eg.IniHelper"%>
<%@ page import = "com.eg.EgConfigFilesSync"%>
<%@ page import="com.eg.EgConfigInfo"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>

<jsp:useBean id="discInfo" class="egurkha.EgUIUtils" scope="page"/>

<%
	Vector temp_v_host_name = null;
	Vector v_host_name = new Vector();
	Vector v_host_name_nocase = new Vector();
	//component case issue. dont allow components to have same name with different case
	EgDiscInfo egDiscInfo = new EgDiscInfo("manager");
	ArrayList al_all_hosts=egDiscInfo.getAllHostsWithPort();
	String s_host_ip = request.getParameter("hostip");
	String s_host_name = request.getParameter("hostname");
	String s_server_name = request.getParameter("server");
	String s_server_type = request.getParameter("stype");
	String s_sid=request.getParameter("sid");
	String oldhostname = request.getParameter("oldhostname");
	String port_for_asset = request.getParameter("hportno");
	String lowerCaseHostName=request.getParameter("lowerCaseHostName");
	String newHostName = request.getParameter("newHostName");
	String siteflag = request.getParameter("siteflag");
	String treeViewSrc = request.getParameter("treeViewSrc");
	String fromResultPage = request.getParameter("fromResultPage");
	String serverNameWithPort = s_host_name;
	if (s_server_name != null && s_server_name.equals("new"))
	{
		oldhostname = "";
	}
	String mserver = request.getParameter("modifyserver");
	boolean isModifyServer = false;
	if(mserver != null && mserver.equals("true"))
	{
		isModifyServer = true;
	}
	if (port_for_asset == null || port_for_asset == "null")
		serverNameWithPort = s_host_name+":NULL";
	else
		serverNameWithPort = s_host_name+":"+port_for_asset;

	String selectedServerGroup = request.getParameter("selectedServerGroup");
	if (selectedServerGroup == null)
	{
		selectedServerGroup = "";
	}
	/*....... For Auto Topology .... (Start)*/
	String frmTopology = request.getParameter("frmTopology");
	String topoSegName = request.getParameter("topoSegName");
	String initialPortNo = request.getParameter("portnumber");
	/*....... For Auto Topology .... (End)*/
	

	if (lowerCaseHostName!=null && lowerCaseHostName.equals("true"))
		s_host_name = newHostName;

	EgAggregateInfo aggregateInfo = new EgAggregateInfo("manager"); //skm
	EgExternalInfo externalInfo = new EgExternalInfo("manager");
	Vector aggTypes = aggregateInfo.getAggregateTypes();
	boolean exist=false;

	v_host_name = discInfo.getAllHostsForIp(s_host_ip,s_host_name);

	Vector ext = externalInfo.getAllExternalHostsForIP(s_host_ip,s_host_name);
	Vector rem = externalInfo.getAllRemoteHostsForIP(s_host_ip,s_host_name);

	if(v_host_name == null)
		v_host_name = new Vector();

	temp_v_host_name = new Vector(v_host_name);

	if(ext != null)
		temp_v_host_name = getUniqueHosts(temp_v_host_name,ext);

	if(rem != null)
		temp_v_host_name = getUniqueHosts(temp_v_host_name,rem);


	if (v_host_name!=null)
	{
		for (int i=0; i<v_host_name.size(); i++)
		{
			String thisName = ((String)v_host_name.get(i)).toLowerCase();
			v_host_name_nocase.add(thisName);
		}
	}

	int nameIndex = v_host_name_nocase.indexOf(s_host_name.toLowerCase());

	if(v_host_name.size() > 0)
	{
		for(int vi=0;vi<v_host_name.size();vi++)
		{
			String host_na=(String)v_host_name_nocase.get(vi);
			exist=s_host_name.toLowerCase().equalsIgnoreCase(host_na);
			if(exist)
				break;
		}
	}

	if(!exist)
	{
		for(int vi=0;vi<temp_v_host_name.size();vi=vi+2)
		{
			String host_na=(String)temp_v_host_name.get(vi);
			exist=s_host_name.equalsIgnoreCase(host_na);
			if(exist)
			{
				nameIndex = (nameIndex == -1?vi:nameIndex);
				break;
			}
		}
	}


	boolean nickManaged =false;
	Hashtable nickIPMap=egDiscInfo.getNickIpMap();

	ArrayList allNicks=egDiscInfo.getAllNicks();
	boolean newNickAdded = !allNicks.contains(s_host_name.toLowerCase());
	Enumeration keys = nickIPMap.keys();
	while (keys.hasMoreElements())
	{
		String thisKey = (String) keys.nextElement();
		if (thisKey.equalsIgnoreCase(s_host_name))
		{
			String thisIp = (String)nickIPMap.get(thisKey);
			if (!thisIp.equals(s_host_ip))
			{
				nickManaged = true;
			}
		}
	}
	//Vmware Vcenter eg_services.ini entries
	IniFile externalRead = new IniFile(EgConfigInfo.egMgrConfigDir + "eg_services.ini");
	ArrayList extIniEntries = new ArrayList();
	String Ssl = "True";
	String uName = "$unconfigured";
	String uPass = "$unconfigured";
	String isDiscovery = "Yes";
	String webPort = "443";
	if (!(nickManaged || (v_host_name_nocase.size() > 0 && !exist)))
	{
		if (s_server_type.equals("Virtual_center"))
		{
			extIniEntries.add(new IniHelper(IniHelper.SET,"VIRTUAL_CENTER", s_host_name, Ssl+"#"+uName+"#"+uPass+"#"+isDiscovery+"#"+webPort));
		}
	}
	else if (s_server_type.equals("Virtual_center") && (mserver != null))
	{
		ArrayList vCValList = new ArrayList();
		String vCVal = externalRead.getValue("VIRTUAL_CENTER",oldhostname);
		StringTokenizer stTok = new StringTokenizer(vCVal,"#");
		while (stTok.hasMoreTokens())
		{
			vCValList.add(stTok.nextToken());
		}
		if (vCValList.size() > 0 && !vCValList.contains("$unconfigured"))
		{
			String SslMod = (String)vCValList.get(0);
			String uNameMod = (String)vCValList.get(1);
			String uPassMod = (String)vCValList.get(2);
			String isDiscoveryMod = (String)vCValList.get(3);
			String webPortMod = (String)vCValList.get(4);

			extIniEntries.add(new IniHelper(IniHelper.DELETE,"VIRTUAL_CENTER", oldhostname, Ssl+"#"+uName+"#"+uPass+"#"+isDiscovery+"#"+webPort));
			extIniEntries.add(new IniHelper(IniHelper.SET,"VIRTUAL_CENTER", s_host_name, SslMod+"#"+uNameMod+"#"+uPassMod+"#"+isDiscoveryMod+"#"+webPortMod));
		}
		else
		{
			extIniEntries.add(new IniHelper(IniHelper.DELETE,"VIRTUAL_CENTER", oldhostname, Ssl+"#"+uName+"#"+uPass+"#"+isDiscovery+"#"+webPort));
			extIniEntries.add(new IniHelper(IniHelper.SET,"VIRTUAL_CENTER", s_host_name, Ssl+"#"+uName+"#"+uPass+"#"+isDiscovery+"#"+webPort));
		}
	}
	if (extIniEntries.size() > 0)
	{
		IniFile externalWrite = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_services.ini");
		for (int n=0; n<extIniEntries.size(); n++)
		{
			IniHelper iniHelper = (IniHelper)extIniEntries.get(n);
			String iniAction = iniHelper.getAction();
			String subject = iniHelper.getSubject();
			String key = iniHelper.getVariable();
			String value = iniHelper.getValue();
			if(iniAction != null)
			{
				if (iniAction.equals(IniHelper.SET))
				{
					externalWrite.setValue(subject,key,value);
				}
				else if (iniAction.equals(IniHelper.DELETE))
				{
					externalWrite.deleteValue(subject,key);
				}
			}
		}
		externalWrite.saveFile();
		EgConfigFilesSync.releaseInstance(externalWrite);
	}

	/* code for auditlog starts */
	AuditLogThread auditLogThread = new AuditLogThread();	
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",_user.getLoginID());
	auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
	auditLogThread.setValue("Session_id",session.getId());
	auditLogThread.setValue("Module","Add/Modify Servers");
	auditLogThread.setValue("Activity","Server Configuration");
	/* code for auditlog ends */

	if(s_server_name != null && s_host_name != null && (s_server_name.equals("new") || isModifyServer) && IniUI.isEgReservedKeyword(s_host_name))
	{
		Vector sess_vec = new Vector();
		sess_vec.removeAllElements();
		sess_vec.addElement(_mapping.getTextDescription("admin.server.Add/Modify Component"));
		if(!StringUtils.isNull(treeViewSrc))
		{
			sess_vec.addElement("EgDispServer.jsp?qctr=1&server="+ s_server_type+"&isAggregateLink="+s_server_type.startsWith("Agg_")+"&treeViewSrc="+treeViewSrc+"&selectedServerGroup="+selectedServerGroup);
		}
		else
		{
			sess_vec.addElement("EgDispServer.jsp?qctr=1&server="+ s_server_type+"&isAggregateLink="+s_server_type.startsWith("Agg_")+"&selectedServerGroup="+selectedServerGroup);

		}
		sess_vec.addElement(_mapping.getTextDescription("admin.server.Possible reason")+":");
		sess_vec.addElement("'"+s_host_name+"' "+_mapping.getTextDescription("admin.server.is an eG defined keyword choose another name")+".");
		if(frmTopology!=null && frmTopology.equals("yes"))
		{
			sess_vec.add("frmTopology");
		}
		session.setAttribute("vec_Errors",sess_vec);
%>
		<jsp:forward page="EgErrors.jsp" />
<%
		return;
	}

	if (!(nickManaged || (v_host_name_nocase.size() > 0 && !exist)))
	{
		if(s_server_name.equalsIgnoreCase("new"))
		{
			boolean isManagedServer = false;
			String arr_comps[]=egDiscInfo.getAllServersOfType(s_server_type);
			String s_port = request.getParameter("hportno");
			String s_key ="";
			if(s_port==null) s_port = "NULL";
			if(arr_comps != null)
			{
				if(s_sid!=null && s_sid.length()>0)
				{
					s_key = s_server_type+ ":" + s_host_name + ":" + s_port + ":" + s_sid;
				}
				else
				{
					s_key = s_server_type+ ":" + s_host_name + ":" + s_port;
				}
				for(int i=0;i<arr_comps.length;i++)
				{
					if(arr_comps[i].equalsIgnoreCase(s_key))
					{
						isManagedServer = true;
						break;
					}
				}
			}
			String tmpPort = "";
			if (s_port != null && !s_port.equalsIgnoreCase("null"))
			{
				tmpPort = ":"+s_port;
			}
			if(isManagedServer)
			{
				Vector sess_vec = new Vector();
				sess_vec.add(_mapping.getTextDescription("admin.server.Add/Modify Component"));
				if(!StringUtils.isNull(treeViewSrc))
				{
					sess_vec.add("EgDispServer.jsp?qctr=1&server="+ s_server_type+"&isAggregateLink="+s_server_type.startsWith("Agg_")+"&treeViewSrc="+treeViewSrc+"&selectedServerGroup="+selectedServerGroup);
				}
				else
				{
					sess_vec.add("EgDispServer.jsp?qctr=1&server="+ s_server_type+"&isAggregateLink="+s_server_type.startsWith("Agg_")+"&selectedServerGroup="+selectedServerGroup);

				}
				sess_vec.add(_mapping.getTextDescription("admin.server.Component already managed."));
				sess_vec.add(_mapping.getTextDescription("admin.server.The component")+" '"+s_host_name+tmpPort+"' ("+_mapping.getComponentTypeDescription(s_server_type)+") "+_mapping.getTextDescription("admin.server.you are trying to add is already managed")+".");
				if(frmTopology!=null && frmTopology.equals("yes"))
				{
					sess_vec.add("frmTopology");
				}
				session.setAttribute("vec_Errors",sess_vec);

				/* code for auditlog starts */
				auditLogThread.setCurrentValue("ColumnName","Component Already Managed");
				auditLogThread.setCurrentValue("Component type","$ctype$:"+s_server_type);
				auditLogThread.setCurrentValue("Component name",s_host_name);
				auditLogThread.setCurrentValue("Port number",s_port);
				auditLogThread.setValue("Description","Component was not added as it had been already managed");
				auditLogThread.sendItToDB();
				/* code for auditlog ends */
%>
				<jsp:forward page="EgErrors.jsp" /> 
<%
				return;
			}
		}

		boolean caseIssue = (nameIndex!=-1) && !temp_v_host_name.contains(s_host_name);
		UpdateAndTransmitUserInfo userinfo = new UpdateAndTransmitUserInfo();

		if ((lowerCaseHostName == null || !lowerCaseHostName.equals("true")) && caseIssue)
		{
			if (allNicks == null || !allNicks.contains(s_host_name.toLowerCase()))
			{
				removeOldEntries(newNickAdded, s_host_name, userinfo);
%>
				<jsp:forward page="Egnewserverp.jsp?action=allservers&<%=request.getQueryString()%>&treeViewSrc=<%=treeViewSrc%>"/>
<%
			}
		}
		else
		{
			removeOldEntries(newNickAdded, s_host_name, userinfo);
			String ur ="Egnewserverp.jsp?action=singleserver&hostname="+s_host_name+"&"+request.getQueryString()+"&treeViewSrc="+treeViewSrc+"&servertype="+s_server_type+"&servername="+serverNameWithPort+"&hostIp="+s_host_ip;
			if(frmTopology!=null && frmTopology.equals("yes"))
			{
				ur = ur + "&topoSegName="+topoSegName+"&initPort="+initialPortNo;
			}
%>
			<jsp:forward page="<%=ur%>" />
<%
		}
	}
	if(!nickManaged && s_server_type.startsWith("Agg_"))
	{
		UpdateAndTransmitUserInfo userinfo = new UpdateAndTransmitUserInfo();
		removeOldEntries(newNickAdded, s_host_name, userinfo);
		String url ="Egnewserverp.jsp?action=singleserver&hostname="+s_host_name+"&"+request.getQueryString()+"&treeViewSrc="+treeViewSrc;
%>
		<jsp:forward page="<%=url%>" />
<%
	}
%>
<html>
<head>
<title></title>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<script language="javascript">	
function valform(support)
{
	var servertype = '<%=s_server_type%>';
	var servername='<%=serverNameWithPort%>';
	var hostip = '<%=s_host_ip%>';
	thisForm = document.hostcheck;
	var radioval = "";
	var queryString = thisForm.qstring.value;
	for(i=0; i<thisForm.notify.length; i++)
	{
		if(thisForm.notify[i].checked)
			radioval = thisForm.notify[i].value;
	}
	if(radioval == "")
	{
		alert('<egui:intnl text="admin.server.Please choose an option"/>');
		return;
	}
	else
	{
		if (isNetscape()) targetObj = thisForm.update;
		if (isIE()) targetObj = thisForm.update;
		targetObj.disabled = true;
		window.document.hostcheck.action = "Egnewserverp.jsp?action="+radioval + "&" + queryString+"&siteflag="+support+"&servertype="+servertype+"&servername="+servername+"&hostIp="+hostip;
		window.document.hostcheck.submit();
	}
}

function caseCheck(newhostname)
{
	thisForm = document.hostcheck;
	window.document.hostcheck.action = "EgHostCheck.jsp?newHostName="+newhostname+"&lowerCaseHostName=true";
	window.document.hostcheck.submit();

}

function isNetscape() 
{
	// get browser info. 
	appName= navigator.appName;
	appLongVer = navigator.appVersion;
	appVer = appLongVer.substring(0, 1); 

	// check for Navigator ver 4+. 
	if ((appName == "Netscape") && (appVer >= 4)) return true;
		return false;
}

function isIE() 
{
	// get browser info. 
	appName= navigator.appName;
	appLongVer = navigator.appVersion;
	appVer = appLongVer.substring(0, 1); 

	// check for IE ver 4+. 
	if ((appName == "Microsoft Internet Explorer") && (appVer >= 4)) return true;
		return false;
}

function call()
{
	thisForm = document.hostcheck;
	var server_name = '<%=s_server_name%>';
	var server_type = '<%=s_server_type%>';
	var modifyserver = '<%=request.getParameter("modifyserver")%>';
	var allExternalTests = '<%=request.getParameter("allExternalTests")%>';
	var queryString = '<%=request.getQueryString()%>';
	if(server_type.indexOf("Agg_")==0)
	{
		window.parent.location.href="EgAggregateTree.jsp?qctr=1&server="+server_type+"&reqfrom=home";
	}
	else
	{
		window.document.hostcheck.action = "EgNewServer.jsp?server=" + server_name + "&serverType=" + server_type +"&"+queryString;
		window.document.hostcheck.submit();
	}
}

</script>
<egui:skin ui = "admin"/>
</head>
<body style="overflow:auto" id="space6" scroll="auto">
<form name="hostcheck" method="post" style="margin:0px">
<input type="hidden" name="qstring" value="<%=request.getQueryString()%>">
<input type="hidden" id="treeViewSrc" name="treeViewSrc" value="<%=treeViewSrc%>">
<input type="hidden" id="fromResultPage" name="fromResultPage" value="<%=fromResultPage%>">
<input type="hidden" name="server_name" value="<%=s_server_name%>">
<input type="hidden" name="server_type" value="<%=s_server_type%>">
<input type="hidden" name="initPort" value="<%=initialPortNo%>">

<table border="0" align="center" cellspacing="0" cellpadding="0" width="100%">
<%
	Enumeration en = request.getParameterNames();
	while(en.hasMoreElements())
	{
		String name = (String)en.nextElement();
		String [] val2 = request.getParameterValues(name);
		String val ="";
		if (val!=null && val2.length==1)
			val = request.getParameter(name);
		else
			val = com.egurkha.util.StringUtils.getUniqueArrayAsString(val2);
%>
	<input type="hidden" name="<%=name%>" value="<%=val%>">
<%
	}

	if(nickManaged || (v_host_name_nocase.size() > 0 && !exist))
	{
		String hostname = "";
		String dispHostName = "";
		boolean proceed = true;

		for(int i=1;i < temp_v_host_name.size();i=i+2)
		{
			if(((String)temp_v_host_name.get(i)).equals("false"))
			{
				proceed = false;
				hostname = (String)temp_v_host_name.get(i-1);
				break;
			}
		}

		if(hostname.length() > 0)
		{
			Hashtable nickIPMapTemp = egDiscInfo.getAllNicksIpMap();
			Hashtable lowerCaseNickIPMap = new Hashtable();
			Hashtable originalNickMap = new Hashtable();
			if(nickIPMapTemp != null)
			{
				dispHostName = (String)nickIPMapTemp.get(s_host_name);
				if (dispHostName == null)
				{
					Enumeration eunmMap  = nickIPMapTemp.keys();
					while(eunmMap.hasMoreElements())
					{
						String key = (String)eunmMap.nextElement();
						String value = (String)nickIPMapTemp.get(key);
						lowerCaseNickIPMap.put(key.toLowerCase(),value);
						originalNickMap.put(key.toLowerCase(),key);
					}
				}
				dispHostName = (String)lowerCaseNickIPMap.get(s_host_name.toLowerCase());
				if(dispHostName != null)
				{
					dispHostName = (String)originalNickMap.get(s_host_name.toLowerCase());
				}
				else
				{
					dispHostName = s_host_name;
				}
			}
		}

%>
	<input type="hidden" name="hostcheck" value="true">
<%
		String enable="";
		String port=request.getParameter("hportno");
		if( port!=null &&!port.equals(request.getParameter("sportno")))
		{
			enable="disabled";
		}
		if(!s_server_name.equalsIgnoreCase("new"))
		{
			enable="disabled";
		}
%>
	<jsp:include page="listSearch.jsp?title=UPDATE - COMPONENT DETAILS&leftString=&backButton=false&subtitle=false"/>
	<tr>
		<td width="100%" id="eg_whitebg" align="center" height="100%" valign="top">
<%
		if(proceed)
		{
%>
			<table align="center" cellspacing="0" cellpadding="0" width="80%" border="0">
				<tr>
					<td>
						<table align="center" width="100%" cellspacing="0" cellpadding="0" border="0" height="22">
							<tr>
								<td id="subhead_left" width="7"> <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"></td>
								<td class="eg_darktextbold" width="100%" align="center" id="eg_subheadbg" style="border-left-width:0px;border-right-width:0px"><strong><%=s_host_ip%>&nbsp;<egui:intnl text="admin.server.IP is already mapped to the following nick name(s)"/>: </strong></td>
								<td id="subhead_right" width="7"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7"></td>
							</tr>
						</table>
					</td>
				</tr>
			</table>
<%
		}
%>
			<table align="center" cellspacing="0" cellpadding="0" width="80%" border="0">
<%
		if(proceed)
		{
			for(int i=0;i < v_host_name.size();i=i+2)
			{
				String compName = (String)v_host_name.get(i);

%>
				<tr>
					<td height="6" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
					<td width="100%" id="eg_subcontentbg" height="20" class="eg_subcontent" colspan="3" style="border-left-width:1px;border-right-width:0px">&nbsp;&nbsp;&nbsp;<strong><%=v_host_name.get(i)%></strong>
					</td>
					<td height="6" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
				</tr>
<%
			}
%>
				<tr>
					<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
					<td id="eg_subcontentbg"  width="100%"  valign="top" colspan="3"><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
					<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
				</tr>
				<tr>
					<td id="eg_blankspace" height="6" colspan="3">&nbsp;</td>
				</tr>
<%
		}
%>
			</table>
			<table align="center" cellspacing="0" cellpadding="0" width="80%" border="0" id="eg_subcontentbg">
				<tr>
					<td height="6" id="inner_top_left" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
					<td height="6" id="eg_subcontentbg" width="100%" colspan="2"><img src="/final/admin/eg_images/spacer.gif" height="6"></td>
					<td height="6" id="inner_top_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
				</tr>
<%
		if(v_host_name_nocase.contains(s_host_name.toLowerCase()))
		{
			if(proceed)
			{
%>
				<tr>
					<td id="eg_subcontentbg"> &nbsp;</td>
					<td colspan="2" nowrap valign="top" id="eg_subcontentbg" class="eg_darktextbold"><egui:intnl text="admin.server.The host name"/> (<%=s_host_name%>) <egui:intnl text="admin.server.you have added is already present in this list"/>.</td>
					<td id="eg_subcontentbg"> &nbsp;</td>
				</tr>
				<tr>
					<td id="eg_subcontentbg"> &nbsp;</td>
					<td valign="top" id="eg_subcontentbg" class="eg_subcontent"><input type="radio" class="eg_input"value="singleserver" name="notify"></td>
					<td valign="top" id="eg_subcontentbg" class="eg_subcontent"><p class="smallpara"><egui:intnl text="admin.server.Do you wish to continue adding the same host name for this component?"/></p></td>
					<td id="eg_subcontentbg"> &nbsp;</td>
				</tr>
				<tr>
					<td id="eg_subcontentbg"> &nbsp;</td>
					<td valign="top" id="eg_subcontentbg" class="eg_subcontent"><input type="radio" value="allservers" name="notify" <%=enable%>></td>
					<td valign="top" id="eg_subcontentbg" class="eg_subcontent"><egui:intnl text="admin.server.Do you wish to continue adding the same host name for this component and apply for all components?"/></td>
					<td id="eg_subcontentbg"> &nbsp;</td>
				</tr>
				<tr>
					<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
					<td id="eg_subcontentbg"  width="100%" colspan="2" valign="top" ><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
					<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
				</tr>
<%
			}
			else
			{
%>
				<tr>
					<td id="eg_subcontentbg"> &nbsp;</td>
					<td colspan="2" valign="top" id="eg_subcontentbg" class="eg_subcontent">
					<egui:intnl text="admin.server.The host name"/>&nbsp;(<%=s_host_name%>)&nbsp;<egui:intnl text="admin.server.you have added is already associated with"/>&nbsp;<%=hostname%>.
					<egui:intnl text="admin.server.Click BACK and choose a different host name"/>
					</td>
					<td id="eg_subcontentbg"> &nbsp;</td>
				</tr>
				<tr>
					<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
					<td id="eg_subcontentbg"  width="100%" colspan="2" valign="top" ><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
					<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
				</tr>
<%
			}
		}
		else if(!v_host_name_nocase.contains(s_host_name.toLowerCase()))
		{
			if(proceed)
			{
				String radioValue = "singleserver"; 
				if(!s_server_name.equalsIgnoreCase("new"))
					radioValue ="allservers";

				ArrayList nicks = egDiscInfo.getAllComponentNicks(false);
				int count = 0;
				for (int i=0;i<nicks.size();i++)
				{
					String nick = (String)nicks.get(i);
					if (nick.equals(oldhostname))
						count++;
					if(count > 1)
						break;
				}

				if (count > 1)
					radioValue = "allservers";
				else
					radioValue = "singleserver";
%>
				<tr>
					<td id="eg_subcontentbg" class="space1"> &nbsp;</td>
					<td colspan="2" valign="top" id="eg_subcontentbg" class="eg_darktextbold"><egui:intnl text="admin.server.The host name"/> (<%=s_host_name%>) <egui:intnl text="admin.server.you have added is not present in the above list"/>.</td>
					<td id="eg_subcontentbg"> &nbsp;</td>
				</tr>
				<tr>
					<td id="eg_subcontentbg" class="space1"> &nbsp;</td>
					<td valign="top" id="eg_subcontentbg" class="eg_subcontent"><input type="radio" class="eg_input" value="<%=radioValue%>" name="notify" checked ></td>
					<td valign="top" id="eg_subcontentbg" class="eg_subcontent">
<%
				if(s_server_name.equalsIgnoreCase("new"))
				{
%>
				<egui:intnl text="admin.server.Do you wish to add the new host name for this component alone?"/>
<%
				}
				else
				{
%>
				<egui:intnl text="admin.server.Do you wish to rename all the components that have the old host name?"/>
				<input type="hidden" name="modify" value="yes">
<%
				}
%>
					</td>
					<td id="eg_subcontentbg"> &nbsp;</td>
				</tr>
				
				<tr>
					<td id="eg_subcontentbg" class="space1"> &nbsp;</td>
					<td valign="top" id="eg_subcontentbg" class="eg_subcontent"><input type="radio" class="eg_input"value="allservers" name="notify" <%=enable%>></td>
					<td valign="top" id="eg_subcontentbg" class="eg_subcontent"><egui:intnl text="admin.server.Do you wish to add the new host name for this component and apply for all components?"/></td>
					<td id="eg_subcontentbg"> &nbsp;</td>
				</tr>

				<tr>
					<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
					<td id="eg_subcontentbg"  width="100%" colspan="2" valign="top" ><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td> 
					<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
				</tr>
<%
			}
			else
			{
				/* code for auditlog starts */
				auditLogThread.setCurrentValue("ColumnName","Component Already Managed");
				auditLogThread.setCurrentValue("01~~Component type","$ctype$:"+s_server_type);
				auditLogThread.setCurrentValue("02~~Component name",s_host_name);
				if(s_host_ip != null && !s_host_ip.equals("0.0.0.0"))
				{
					auditLogThread.setCurrentValue("03~~IP in which component to be managed",s_host_ip);
				}
%>
				<tr>
					<td height="6" id="inner_top_left" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
					<td height="6" id="eg_subcontentbg" width="100%" colspan="2"><img src="/final/admin/eg_images/spacer.gif" height="6"></td>
					<td height="6" id="inner_top_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
				</tr>
<%
	if(hostname != null && hostname.equals("0.0.0.0"))
	{
		List aggCompTypes = egDiscInfo.getServerTypesForNick(dispHostName);
%>
				<tr>
					<td id="eg_subcontentbg"> &nbsp;</td>

					<td colspan="2" valign="top">
					<div align="center"><img src="/final/admin/eg_images/<%=admin_Skin%>/exclamation-icon.gif" align="center" hspace="10" vspace="10" border="0"><br><br>

					<egui:intnl text="admin.error.The host/nick name"/>&nbsp;(<strong><%=s_host_name%></strong>)&nbsp;<egui:intnl text="admin.error.you are trying to add is already associated with an aggregate component"/>&nbsp;<egui:intnl text="admin.error.in the following manner"/>.

					<br><br>
					<table border='0' cellspacing='0' cellpadding='3' width='75%'>
						<tr>
							<td width='50%' id='eg_subheadbg' style='text-align:center;border-right-width:1px'><strong><egui:intnl text="admin.common.Component type"/></strong></td>
							<td width='50%' id='eg_subheadbg' style='text-align:center'><strong><egui:intnl text="admin.common.Host"/>/<egui:intnl text="admin.common.Nick name"/></strong></td>
						</tr>
<%
		if(aggCompTypes != null && !aggCompTypes.isEmpty())
		{
			for(int i=0;i<aggCompTypes.size();i++)
			{
				String aggCompType = (String) aggCompTypes.get(i);
				auditLogThread.setCurrentValue("Component already managed","$ctype$:"+aggCompType+":"+dispHostName);
%>
						<tr>
							<td width='50%' id='cell_border1' align='left'><%=_mapping.getComponentTypeDescription(aggCompType)%></td>
							<td width='50%' id='cell_border1' align='left'><%=dispHostName%></td>
						</tr>
<%
			}
		}
%>
					</table>

					<br/><br/>
					<egui:intnl text="admin.server.Click <b>BACK</b> and choose a different host/nick name"/>.</div><br><br></td>
					<td id="eg_subcontentbg"> &nbsp;</td>
				</tr>
<%
				auditLogThread.setValue("Description","Component was not added as it had been already managed");
				auditLogThread.sendItToDB();
				/* code for auditlog ends */
	}
	else
	{
				auditLogThread.setCurrentValue("IP in which component already managed",hostname);
				auditLogThread.setValue("Description","Component was not added as it had been already managed");
				auditLogThread.sendItToDB();
				/* code for auditlog ends */
%>
				<tr>
					<td id="eg_subcontentbg"> &nbsp;</td>

					<td colspan="2" valign="top">
					<div align="center"><img src="/final/admin/eg_images/<%=admin_Skin%>/exclamation-icon.gif" align="center" hspace="10" vspace="10" border="0"><br><br>

					<egui:intnl text="admin.error.The host/nick name"/>&nbsp;(<strong><%=s_host_name%></strong>)&nbsp;<egui:intnl text="admin.error.you are trying to add is already associated with the IP"/>&nbsp;(<strong><%=hostname%></strong>)
					<egui:intnl text="admin.error.in the following manner"/>.

					<br><br>
					<table border='0' cellspacing='0' cellpadding='3' width='50%'>
						<tr>
							<td width='50%' id='eg_subheadbg' style='text-align:left''><strong>IP</strong></td>
							<td width='50%' id='eg_subheadbg' style='text-align:left'><strong>Host/Nick name</strong></td>
						</tr>
						<tr>
							<td width='50%' id='cell_border1' align='left'><%=hostname%></td>
							<td width='50%' id='cell_border1' align='left'><%=dispHostName%></td>
							</tr>
					</table>

					<br/><br/>
					<egui:intnl text="admin.server.Click <b>BACK</b> and choose a different host/nick name"/>.</div><br><br></td>
					<td id="eg_subcontentbg"> &nbsp;</td>
				</tr>
<%
	}
%>
				<tr>
					<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
					<td id="eg_subcontentbg"  width="100%" colspan="2" valign="top" ><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
					<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
				</tr>
<%
			}
		}
%>
			</table>
			<br>
			<table align="center" cellspacing="0" cellpadding="4" width="80%" border="0">
<%
		if(proceed)
		{
%>
				<tr>
					<td align="right"  class="eg_subcontent">
						<input type="button" name="update" style="width: 85px;height: 20px;" class="eg_back" value='<egui:intnl text="admin.common.Update"/>' onClick="javascript:valform('<%=siteflag%>')">
					</td>
					<td align="left">
						<input type="button" name="update" style="width: 85px;height: 20px;" class="eg_back" value='<egui:intnl text="admin.common.Back"/>' onClick="javascript:call()">
					</td>
				</tr>
<%
		}
		else
		{
%>
				<tr>
					<td align="center">
						<input type="button" name="update" style="width: 80px;height: 20px;" class="eg_back" value='<egui:intnl text="admin.common.Back"/>' onClick="javascript:call()">
					</td>
				</tr>
<%
		}
%>
			</table>
		</td>
	</tr>
	<input type="hidden" name="qstring" value="<%=request.getQueryString()%>">
	<input type="hidden" name="server_name" value="<%=s_server_name%>">
	<input type="hidden" name="server_type" value="<%=s_server_type%>">
	</form>
<%
	}
	else
	{
		boolean caseIssue = (nameIndex!=-1) && !temp_v_host_name.contains(s_host_name);
		if ((lowerCaseHostName==null || !lowerCaseHostName.equals("true")) && caseIssue)
		{
			if(allNicks != null && allNicks.contains(s_host_name.toLowerCase()))
			{
				newHostName = (String)temp_v_host_name.get(nameIndex);
%>
	<tr>
		<td height="470">
			<table align="center" cellspacing="0" cellpadding="0" width="80%" border="0">
				<tr>
					<td colspan="3" align="center" class="eg_subcontentbg"><img src="/final/admin/eg_images/<%=admin_Skin%>/exclamation-icon.gif" align="center" hspace="10" vspace="10" border="0"></td>
				</tr>
				<tr>
					<td height="6" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
					<td width="100%" id="eg_subcontentbg" height="80" class="eg_subcontent" style="border-left-width:1px;border-right-width:0px;" align="center">
						<egui:intnl text="admin.error.The host/nick name"/> (<strong><%=s_host_name%></strong>)&nbsp;<egui:intnl text="admin.error.you are trying to add is already associated with the IP"/>&nbsp;(<strong><%=s_host_ip%></strong>)
						<egui:intnl text="admin.error.in the following manner"/>.
						<br><br>
						<table border='0' cellspacing='0' cellpadding='3' width='50%'>
							<tr>
								<td width='50%' id='eg_subheadbg' style='text-align:left''><strong>IP</strong></td>
								<td width='50%' id='eg_subheadbg' style='text-align:left'><strong>Host/Nick name</strong></td>
							</tr>
							<tr>
								<td width='50%' id='cell_border1' align='left'><%=s_host_ip%></td>
								<td width='50%' id='cell_border1' align='left'><%=newHostName%></td>
								</tr>
						</table>
						<br><br>
						<egui:intnl text="admin.server.Do you wish to use the old host/nick name"/> (<strong><%=newHostName%>)</strong>&nbsp;<egui:intnl text="admin.server.for this IP address"/>?
						<br><br>
					</td>
					<td height="6" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
				</tr>
				<tr>
					<td height="6" width="7" colspan="3"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="15" border="0"></td>
				</tr>
				<tr>
					<td colspan="3" align="center">
						<input type=button value= '<egui:intnl text="admin.server.Cancel"/>' onclick = "javascript:call()" class="eg_back"> &nbsp;
						<input type=button value= '<egui:intnl text="admin.server.Continue"/>' onclick = "javascript:caseCheck('<%=newHostName%>')" class="eg_back">
					</td>
				</tr>
			</table>
		</td>
	</tr>
<%
			}
		}
	}
%>
</table>
</body>
</html>

<%!
	public void removeOldEntries(boolean newNickAdded, String s_host_name, UpdateAndTransmitUserInfo userinfo)
	{
		if (newNickAdded)
		{
			ArrayList queryList = new ArrayList();
			queryList.add("delete from measure_last where trgt_host='"+s_host_name+"'");
			queryList.add("delete from metatest where comp_name like '"+s_host_name+":%'");
			for (int j=0; j<queryList.size(); j++)
			{
				String thisQry = (String) queryList.get(j);
				userinfo.deleteFromDb(thisQry);
			}
		}
	}
	public Vector getUniqueHosts(Vector v_host_name,Vector hosts)
	{
		for(int i=0;i<hosts.size();i=i+2)
		{
			String temp1 = (String)hosts.get(i);
			String temp2 = (String)hosts.get(i+1);
			if(!v_host_name.contains(temp1))
			{
				v_host_name.add(temp1);
				v_host_name.add(temp2);
			}
		}
		return v_host_name;
	}
%>



