<!DOCTYPE html>

<%@ include file="EgTrackerA.jsp" %>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>

<html>
<head>
	<meta charset="utf-8">

	<script type="text/javascript" src="../extjs/ext-all.js"></script>

	<!-- Fancy Scroll-->
	<script src="/final/scripts/jquery-1.8.2.js"></script>
	<script src="/final/styles/jscrollpane/jquery.jscrollpane.js" ></script>
	<script src="/final/styles/jscrollpane/jquery.mousewheel.js" ></script>
	<script src="/final/styles/jscrollpane/mwheelIntent.js" ></script>
	<link rel="stylesheet" href="/final/styles/jscrollpane/jquery.jscrollpane.css"/>

	<script language="JavaScript1.2">
		var csrfToken = '<%=strCsrfToken%>';
		var pageTitle = '<egui:intnl text="admin.title.DELETE USERS"/>';
		var pageDescc = '<egui:intnl description="EgDeleteUser.jsp"/>';
		var deleteAll = "no";
		var processing = '<egui:intnl text="admin.common.Processing" />...';
		var search_string = '<egui:intnl text="admin.user.Please enter a Search String"/>.';
		var select_users = '<egui:intnl text="admin.user.Please select user(s)"/>';
		var no_search_users_found = '<egui:intnl text="admin.user.No user(s) found for your search"/>.';
		var no_independent_components = '<egui:intnl text="admin.user.There are no independent components associated with this user(s)"/>.';
		var confirmation1 = '<egui:intnl text="admin.user.Are you sure you want to delete selected user(s)"/>?';
		var confirmation2 = '<egui:intnl text="admin.user.Selected users components once deleted will never be discovered again"/>.\n<egui:intnl text="admin.server.Are you sure you want to delete"/>?';
		var confirmationLabel = '<egui:intnl text="admin.user.CONFIRMATION"/>';
		var no_users_conf = '<egui:intnl text="admin.user.No users have been configured"/>';

		var probsErrorMessage = '<egui:intnl text="admin.error.Problem encountered while loading the user interface"/>';
		var requestTimeOut = '<egui:intnl text="admin.error.Response timed out"/>';
		var errorTitle = '<egui:intnl text="admin.user.Error"/>';
		var deletedMessage = '<egui:intnl text="admin.common.User(s) deleted successfully"/>';
	</script>

	<!-- Application folder -->
	<script type="text/javascript" src="DeleteUsers/app/app.js"></script>
	<egui:skin ui="admin"/>

	<script language="javascript">
		Ext.onReady(function(){
			Ext.Ajax.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
			Ext.data.Connection.prototype.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
			Ext.data.ScriptTagProxy.prototype.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};

			Ext.Ajax.on('requestexception', function (conn, response, options) {
				var errorStr = response.responseText;
				if (errorStr != undefined && errorStr != 'undefined' && errorStr.indexOf("customerror") != -1)
				{
					if (errorStr.indexOf("user-session-invalid") != -1)
					{
						callWindow(1);
					}
					else if (errorStr.indexOf("user-deleted") != -1)
					{
						callWindow(2);
					}
					else if (errorStr.indexOf("user-timedout") != -1)
					{
						callWindow(3);
					}
				}
				else
				{
					if (response.status == 302 || (response.timedout != undefined && response.timedout == true))
					{
						Ext.Msg.show({
							title : errorTitle,
							msg : requestTimeOut+'.',
							buttons : Ext.Msg.OK,
							icon : 'iconError'
						});
					}
					else
					{
						console.log(response.responseText);
						Ext.Msg.show({
							title : errorTitle,
							msg : probsErrorMessage+'.',
							buttons : Ext.Msg.OK,
							icon : 'iconError'
						});
					}
				}
			});
		});
	</script>


</head>

<body>
<div id="loadmask" class="x-mask-msg x-layer x-mask-msg-default" style="z-index: 19001;left:45%;top:35%;">
	<div class="x-mask-loading" style="position:relative">
		Loading...
	</div>
</div>
</body>
</html>

<%
	if(request.getQueryString()!=null)
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/EgDeleteUser.jsp?"+request.getQueryString());
	}
	else
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/EgDeleteUser.jsp");
	}
%>



