<%
/*******************************************************************************
*		Name				:EgDbSettingsJSON.jsp
*		Purpose				:To configure database settings.
*		Version				:6.0
*		Created Date		:28/06/2013
*		Modified Date		:28/06/2013
*		Author				:Abdul Khader M
*******************************************************************************/
%>
<%@ include file="../../../admin/EgTrackerAJSON.jsp" %>
<%@ page import="com.egurkha.util.*" %>
<%@ page import="com.eg.MappingNameSorter" %>
<%@ page import="com.egurkha.ini.IniUI" %>
<%@ page import="com.eg.EgMemInfo" %>
<%@ page import="java.util.*" %>
<%@ page import="com.eg.EgServicesInfo" %>
<%@ page import="net.sf.json.*" %>
<%@ page import="egurkha.TransactionBean" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	response.setContentType("application/json");
	JSONObject rootJson = new JSONObject();
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>
<%!
	String licenseCheck = new String("license");
%>

<%
	IniUI iniUI = IniUI.getInstance();
	String userLanguage = iniUI.getDefaultLanguage();
	if (_user != null)
	{
		userLanguage = _user.getLanguage();
	}

	boolean ddEnabled = false;
	synchronized(licenseCheck)
	{
		ddEnabled = EgMemInfo.ddEnabled;
	}

	//to check if auditlog enabled
	EgServicesInfo egserInfo = new EgServicesInfo("manager");
	boolean isAuditLogEnabled = egserInfo.isAuditlogEnabled();
	rootJson.put("isAuditLogEnabled",isAuditLogEnabled);
	boolean isBillingEnabled = egserInfo.isBillingDataEnabled();
	rootJson.put("isBillingEnabled",isBillingEnabled);
	TransactionBean dbconfig = new TransactionBean();
%>

<%!
	String subject = "MANAGER_SETTINGS";
	String strVal1 = "";
	String strVal2 = "";
	String strVal3 = "";
	String strVal4 = "";
	String strVal5 = "";
	String strVal6 = "";
	String strVal7 = "";
	String strVal8 = "";
	String strVal9 = "";
	String strVal10 = "";
	String strVal11 = "";
	String strVal12 = "";
	String strVal13 = "";

	String[] slots = new String[48];
	
	private String[] getTimeSlots()
	{
		for (int a=0; a<slots.length/2; a++)
		{
			if (a < 10)
			{
				slots[2*a] = "0"+String.valueOf(a)+":00";
				slots[2*a+1] = "0"+String.valueOf(a)+":30";
			}
			else
			{
				slots[2*a] = String.valueOf(a)+":00";
				slots[2*a+1] = String.valueOf(a)+":30";
			}
		}

		return slots;
	}
%>
<%
	dbconfig.createFile("eg_db.ini");
	strVal1 = dbconfig.getStrValue(subject,"MeasurementCleanPeriod");
	rootJson.put("MeasurementCleanPeriod",strVal1);
	strVal2 = dbconfig.getStrValue(subject,"HourlyCleanPeriod");
	rootJson.put("HourlyCleanPeriod",strVal2);
	strVal3 = dbconfig.getStrValue(subject,"DailyCleanPeriod");
	rootJson.put("DailyCleanPeriod",strVal3);
	strVal4 = dbconfig.getStrValue(subject,"MonthlyCleanPeriod");
	rootJson.put("MonthlyCleanPeriod",strVal4);
	strVal5 = dbconfig.getStrValue(subject,"EventHistoryCleanPeriod");
	rootJson.put("EventHistoryCleanPeriod",strVal5);
	strVal6 = dbconfig.getStrValue("DB_PROPERTIES","sql.initconns");
	rootJson.put("sql.initconns",strVal6);
	strVal7 = dbconfig.getStrValue("DB_PROPERTIES","sql.maxconns");
	rootJson.put("sql.maxconns",strVal7);
	rootJson.put("ddEnabled",ddEnabled);
	if (ddEnabled)
	{
		strVal8 = dbconfig.getStrValue(subject,"DetailedDiagnosisCleanPeriod");
		rootJson.put("DetailedDiagnosisCleanPeriod",strVal8);
	}
	rootJson.put("isAuditLogEnabled",isAuditLogEnabled);
	if (isAuditLogEnabled)
	{
		strVal10= dbconfig.getStrValue(subject,"AuditLogCleanPeriod");
		rootJson.put("AuditLogCleanPeriod",strVal10);
	}
	strVal9 = dbconfig.getStrValue(subject,"TrendStartTime");
	rootJson.put("TrendStartTime",strVal9);
	strVal11= dbconfig.getStrValue(subject,"CtxUserBillingCleanPeriod");
	rootJson.put("CtxUserBillingCleanPeriod",strVal11);
	strVal12= dbconfig.getStrValue(subject,"CtxUserMonthlyBillingCleanPeriod");
	rootJson.put("CtxUserMonthlyBillingCleanPeriod",strVal12);
	strVal13= dbconfig.getStrValue(subject,"FixHistoryCleanPeriod");
	rootJson.put("FixHistoryCleanPeriod",strVal13);

	//Config Mgmt changes
	boolean isConfigEnabled = EgInstallInfo.isConfigSupported;

	//ensure whether the user is configuration management enabled
	if (_user != null && isConfigEnabled)
	{
		EgUserRole userRole = _user.getUserRole();
		isConfigEnabled = userRole.hasAnyConfigRole(EgUserPermission.CONFIG);
	}

	String configMeasure = "";
	String configChangeMaster = "";
	rootJson.put("isConfigEnabled",isConfigEnabled);
	if (isConfigEnabled)
	{
		configMeasure = dbconfig.getStrValue(subject,"ConfigMeasurementCleanPeriod");
		rootJson.put("ConfigMeasurementCleanPeriod",configMeasure);
		configChangeMaster = dbconfig.getStrValue(subject,"ConfigChangeMasterCleanPeriod");
		rootJson.put("ConfigChangeMasterCleanPeriod",configChangeMaster);
	}

	String trendStartTime = null;
	if (StringUtils.isNull(strVal9))
	{
		trendStartTime = "00:30";
	}
	else
	{
		long minutes = 30;
		try
		{
			minutes = Long.parseLong(strVal9.trim());
		}
		catch(NumberFormatException nfe)
		{
		}

		int hours = (int)minutes/60;
		minutes = minutes - (hours * 60);
		if (hours < 10)
		{
			trendStartTime = "0" + String.valueOf(hours);
		}
		else
		{
			trendStartTime = String.valueOf(hours);
		}

		if (minutes < 10)
		{
			trendStartTime += ":0" + String.valueOf(minutes);
		}
		else
		{
			trendStartTime += ":" + String.valueOf(minutes);
		}
	}
	rootJson.put("timeSlots",this.getTimeSlots());

	rootJson.put("trendStartTime",trendStartTime);
	rootJson.put("Update","Egdbsettingsp.jsp?");
	rootJson.put("Advanced Settings","EgDDDPurge.jsp");
%>
<%
	if (request.getQueryString() != null)
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/EgDbSettings.jsp?"+request.getQueryString());
	}
	else
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/EgDbSettings.jsp");
	}
	out.println(rootJson.toString());
%>



