<%
/*******************************************************************************
*		Name				:EgConsolidatedReportsJSON.jsp
*		Purpose				:Configures the details required for default reports
*		Version				:6.0
*		Created Date		:28/06/2013
*		Modified Date		:28/06/2013
*		Author				:Abdul Khader M
*******************************************************************************/
%>
<%@ include file="../../../admin/EgTrackerAJSON.jsp" %>
<%@ page import = "egurkha.reporter.*" %>
<%@ page import = "com.eg.EgSpecsInfo" %>
<%@ page import = "com.eg.EgReportInfo" %>
<%@ page import = "com.eg.EgDiscInfo" %>
<%@ page import = "com.eg.EgThresholdInfo" %>
<%@ page import = "com.eg.EgConfigInfo" %>
<%@ page import = "com.eg.EgDbAdapterTypeUI"%>
<%@ page import = "egurkha.EgDbAdapterUI" %>
<%@ page import = "com.eg.IniFile" %>
<%@ page import = "java.util.*" %>
<%@ page import = "com.eg.EgTopoInfo" %>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import = "net.sf.json.*" %>
<%@ page import = "egurkha.ConfigSiteBean" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%!
	StringBuffer servMeasure=null;
%>
<%
	response.setContentType("application/json");
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	JSONObject rootJson = new JSONObject();
	JSONObject hiddenJson = new JSONObject();

	JSONArray catTypeArrayJson = new JSONArray();
	JSONArray timeArrayJson = new JSONArray();
	JSONArray toTimeArrayJson = new JSONArray();
	JSONArray minArrayJson = new JSONArray();
	JSONArray timeLineArrayJson = new JSONArray();
	JSONArray daysOfWeekArrayJson = new JSONArray();

	JSONObject selectedCatTypeJson = new JSONObject();
	JSONObject selectedFromTimeJson = new JSONObject();
	JSONObject selectedToTimeJson = new JSONObject();
	JSONObject selectedFromMinJson = new JSONObject();
	JSONObject selectedToMinJson = new JSONObject();
	JSONObject selectedTimeLineJson = new JSONObject();
	JSONArray selectedDaysOfWeekArrayJson = new JSONArray();

	ConfigSiteBean SiteBean = new ConfigSiteBean();

	User user=registry.getUser(session.getId());
	com.egurkha.ini.IniUI ui = (com.egurkha.ini.IniUI)com.egurkha.ini.IniUI.getInstance();
	String thisLanguage = ui.getDefaultLanguage();
	if (user!=null)
	{
		String userLang = user.getLanguage();
		if (userLang!=null && !userLang.equalsIgnoreCase("NULL"))
		{
			thisLanguage=userLang;
		}
	}
	
	EgMappingInfo mappingInfo = new EgMappingInfo(thisLanguage);
	if(SiteBean.rcat())
	{
		EgThresholdInfo et = new EgThresholdInfo("manager");
		EgReportInfo rep = new EgReportInfo("manager");
		EgConfigInfo econ= new EgConfigInfo("manager");
		EgDiscInfo ed = new EgDiscInfo("manager");
		EgSpecsInfo espec = new EgSpecsInfo("manager");
		ErUserData erdata = new ErUserData("supermonitor",false);
		ErInfo erinfo = new ErInfo();
		ErUtils erUtils = new ErUtils();
		String fname = econ.getReportConfigFile();
		Vector v_cattype=new Vector();
		v_cattype.addElement(mappingInfo.getTextDescription("admin.reports.Zone"));
		v_cattype.addElement(mappingInfo.getTextDescription("admin.reports.Server"));
		v_cattype.addElement(mappingInfo.getTextDescription("admin.reports.Thin client session"));
		v_cattype.addElement(mappingInfo.getTextDescription("admin.reports.Thin client application"));
		v_cattype.addElement(mappingInfo.getTextDescription("admin.reports.Thin client user"));

		for (int i=0; i<v_cattype.size(); i++)
		{
			JSONObject catTypeObj = new JSONObject();
			String aCatType = (String) v_cattype.get(i);
			catTypeObj.put("displayField",aCatType);
			catTypeObj.put("valueField",aCatType);
			catTypeArrayJson.add(catTypeObj);
		}

		IniFile irep = new IniFile(fname);
		String tests[];
		String dmeasures[];
		//String infos[];
		String testName="";
		String cattype = "";
		String cattypeT = "";
		String secType ="";
		String graphType = "";
		String comType = "";
		String comName="";
		String siteType="";
		String serverTests[];
		
		//ArrayList a_infos = new ArrayList();
		Vector v;
		
		String testinfo = "";
		String testselect="";
		String serverselect="";
		
		boolean serverlist=false;
		//boolean sitelist = false;
		//boolean netsyslist= false;
		int tind = 0;
		String serverType="";
		Vector v_time=new Vector();
		Vector v_min=new Vector();
		Vector v_days=new Vector();

		for (int i=0;i<24;i++)
		{
			JSONObject timeObj = new JSONObject();
			if (i<10)
			{
				v_time.add("0"+i);
				timeObj.put("displayField","0"+i);
				timeObj.put("valueField","0"+i);
				timeArrayJson.add(timeObj);
			}
			else
			{
				v_time.add(String.valueOf(i));
				timeObj.put("displayField",String.valueOf(i));
				timeObj.put("valueField",String.valueOf(i));
				timeArrayJson.add(timeObj);
			}
		}

		for (int i=0;i<25;i++)
		{
			JSONObject timeObj = new JSONObject();
			if (i<10)
			{
				v_time.add("0"+i);
				timeObj.put("displayField","0"+i);
				timeObj.put("valueField","0"+i);
				toTimeArrayJson.add(timeObj);
			}
			else
			{
				v_time.add(String.valueOf(i));
				timeObj.put("displayField",String.valueOf(i));
				timeObj.put("valueField",String.valueOf(i));
				toTimeArrayJson.add(timeObj);
			}
		}

		for (int i=0;i<60;i=i+5)
		{
			JSONObject minObj = new JSONObject();
			if (i<10)
			{
				v_min.add("0"+i);
				minObj.put("displayField","0"+i);
				minObj.put("valueField","0"+i);
				minArrayJson.add(minObj);
			}
			else
			{
				v_min.add(String.valueOf(i));
				minObj.put("displayField",String.valueOf(i));
				minObj.put("valueField",String.valueOf(i));
				minArrayJson.add(minObj);
			}
		}

		v_days.add("Sunday");
		v_days.add("Monday");
		v_days.add("Tuesday");
		v_days.add("Wednesday");
		v_days.add("Thursday");
		v_days.add("Friday");
		v_days.add("Saturday");

		if(request.getParameter("catType")!=null)
		{
			cattype=request.getParameter("catType");
		}
		selectedCatTypeJson.put("catType",cattype);

		if(request.getParameter("graphType")!=null)
			graphType=request.getParameter("graphType");
		
		if(request.getParameter("secType")!=null)
			secType =request.getParameter("secType");
		if(request.getParameter("tests")!=null)
			testName = request.getParameter("tests");
		
		if(request.getParameter("serverType")!=null)
			serverType = request.getParameter("serverType");
		else
			serverType="Default";

		if(request.getParameter("comType")!=null)
			comType = request.getParameter("comType");

		if(request.getParameter("comName")!=null)
			comName = request.getParameter("comName");

		String secTypeI="";
		String cattypeVar = "";
		String graphTypeI="";
		String deleted=request.getParameter("Deleted");

		if (deleted==null)
			deleted="false";

		if(request.getParameter("graphTypeI")!=null)
			graphTypeI = request.getParameter("graphTypeI");
		if(cattype != null)
		{
			if((cattype.toUpperCase()).startsWith("ZONE"))
			{
				if(serverType!=null && serverType !="")
					cattypeVar = serverType+":"+testName;//.substring(0,comName.indexOf(":"));
			}
			else if((cattype.toUpperCase()).startsWith("SERVER"))
			{
				if(graphType !=null && graphType !="")
					cattypeVar = cattype+":"+graphType+":"+siteType;
			}
		}
		
		if(secType != null && secType !="" && !secType.equalsIgnoreCase("citrix session"))
			secTypeI=secType.toUpperCase()+"_REPORT";
		else
			secTypeI=secType.toUpperCase()+" REPORT";
		
		String timeline=request.getParameter("timeline");
		if (timeline==null)
			timeline=rep.getTimeFrame("MISC","MaxTimeline");

		String fromTime = rep.getTimeFrame(secTypeI,"FROM");
		String toTime = rep.getTimeFrame(secTypeI,"TO");

		if (cattype.equalsIgnoreCase("Services"))
		{
			fromTime=rep.getTimeFrame("ZONE_REPORT","FROM");
			toTime=rep.getTimeFrame("ZONE_REPORT","TO");
		   // out.println("fromTime"+fromTime);
		   // out.println("toTime"+toTime);
		}

		String Hourfrom=request.getParameter("timefrom");
		String Minfrom=request.getParameter("minfrom");
		String Hourto=request.getParameter("timeto");
		String Minto=request.getParameter("minto");
		StringTokenizer st1 = new StringTokenizer(fromTime,":");
		if (Hourfrom==null)
		{
			if(st1.hasMoreTokens())
			{
				Hourfrom = st1.nextToken();
				Minfrom = st1.nextToken();
			}
		}
		if (Hourto==null)
		{
			st1=new StringTokenizer(toTime,":");
			if(st1.hasMoreTokens())
			{
				Hourto = st1.nextToken();
				Minto = st1.nextToken();
			}
		}

		selectedFromTimeJson.put("Hourfrom",Hourfrom);
		selectedFromMinJson.put("Minfrom",Minfrom);
		selectedToTimeJson.put("Hourto",Hourto);
		selectedToMinJson.put("Minto",Minto);

		Vector v_exc=new Vector();
		String Days = rep.getExcludeWeekend(secTypeI);
		//out.println("cattype---->"+cattype);
		if (cattype.equalsIgnoreCase("Services"))
			Days=rep.getExcludeWeekend("ZONE_REPORT");

		st1 = new StringTokenizer(Days,",");
		while (st1.hasMoreTokens())
		{
			//JSONObject selWeekendDays = new JSONObject();
			String aToken = (String) (st1.nextToken()).trim();
			v_exc.add(aToken);
			//selWeekendDays.put("displayField",aToken);
			//selWeekendDays.put("valueField",aToken);
			//selectedDaysOfWeekArrayJson.add(selWeekendDays);
		}
		Vector v_func=new Vector();
		String functions = "";
		if (cattype.equalsIgnoreCase("Zone") || cattype.equalsIgnoreCase("Services"))
			functions=irep.getValue("ZONE_REPORT","Function");

		st1 = new StringTokenizer(functions,",");
		while (st1.hasMoreTokens())
		{
			v_func.add((st1.nextToken()).trim());
		}
		
		String[] selectedfunc=request.getParameterValues("calfunc");
		if (selectedfunc==null )
		{
			if (v_func!=null && v_func.size()>0)
			{
				selectedfunc=new String[1];
				selectedfunc[0]=(String)v_func.get(0);
			}
		}

		String ServerMeasures=request.getParameter("serverMeasure");
		String Measure=request.getParameter("measure");
		String DisplayName=request.getParameter("display");
		if (Measure==null || Measure.equals("----Select the Measure---") && cattype.equalsIgnoreCase("Server"))
		{
			if(ServerMeasures!=null)
			servMeasure=new StringBuffer(ServerMeasures);
		}

		if (testName!=null && Measure!=null&&DisplayName!=null && !testName.equals("---Select the test ---")&& !Measure.equals("----Select the Measure---"))
		{
			if (ServerMeasures==null || ServerMeasures.equals("") || servMeasure==null || servMeasure.length()==0)
			{
				servMeasure=new StringBuffer();
				servMeasure.append(testName).append("=").append(Measure);
				if (DisplayName!=null && !DisplayName.equals(""))
				servMeasure.append("#").append(DisplayName);
			}else
			{
				//if (ServerMeasures.indexOf(testName)>-1)
				servMeasure.append(",").append(Measure);
				if (DisplayName!=null && !DisplayName.equals(""))
					servMeasure.append("#").append(DisplayName);
			}

		}
		ArrayList subjects=new ArrayList();
		ArrayList sub=new ArrayList();
		//out.println(cattype);
		String[] measurelist=request.getParameterValues("associatem");

		if (deleted==null || (deleted!=null && deleted.equalsIgnoreCase("false")))
		{
			subjects=(ArrayList)rep.getVariables(secTypeI);
			sub=subjects;
		}
		if (cattype.equals("Services") && sub.size() ==0 )
		{
			subjects=(ArrayList)rep.getVariables("ZONE_REPORT");
			sub=subjects;
		}
		//out.println(testName);
		if (sub.size()>0)
		{
			subjects=new ArrayList();
			for (int i=0;i<sub.size();i++)
			{
				String vars=(String)sub.get(i);
				if (cattype.equalsIgnoreCase("Zone"))
				{
					//if (!testName.equals("") && vars.indexOf(serverType+":"+testName)>-1)
					//{
						String vals=irep.getValue(secTypeI,(String)sub.get(i));
					
						if (vals!=null && !vals.equals(""))
							subjects.add(sub.get(i)+"="+vals);
					//}else
					//{
						//measurelist=null;
					//}
				}else if (cattype.equalsIgnoreCase("Server"))
				{
					
					//if (!testName.equals("") && vars.indexOf(testName)>-1)
					//{
						String vals=irep.getValue(secTypeI,(String)sub.get(i));
					
						if (vals!=null && !vals.equals(""))
							subjects.add(sub.get(i)+"="+vals);
					//}else
					//{
						//measurelist=null;
					//}

				}else if (cattype.equalsIgnoreCase("Services"))
				{
					//out.println("coming here");
					
						
							String vals=irep.getValue(secTypeI,(String)sub.get(i));
						
							if (vals!=null && !vals.equals(""))
								subjects.add(sub.get(i)+"="+vals);
						
					
							 vals="";
							 vals=irep.getValue("ZONE_REPORT",(String)sub.get(i));
						
							if (vals!=null && !vals.equals(""))
								subjects.add(sub.get(i)+"="+vals);
				}
			}
		}

		if (measurelist!=null)
		{
			subjects=new ArrayList();
			for (int i=0;i<measurelist.length;i++)
				subjects.add(measurelist[i]);
		}
		
		irep = null;
		
		if(cattype != null)
		{
			if(cattype.startsWith("Application"))
				serverlist = true;
			
		}

		
		if (cattype.equalsIgnoreCase("Zone") || cattype.equalsIgnoreCase("Server") || cattype.equalsIgnoreCase("Services"))
		{
			rootJson.put("cattype",cattype);
		}

		String zoneselect ="";
		String serselect ="";
		
		if(cattype != null)
		{
			if(cattype.startsWith("Zone"))
			{
				zoneselect = "checked";
				serverlist = true;
			}
			if(cattype.startsWith("Server"))
			{
				serselect = "checked";
				serverlist = true;
			}
			if(cattype.startsWith("Services"))
			{
				serselect = "checked";
				serverlist = true;
			}
		}

		if (cattype!=null && !cattype.equals(""))
		{
			String ex_timeline = "1 week";
			int d1=0,d2=0;
			String s="";
			for (int i=1;i<6;i++)
			{
				JSONObject timeLineObj = new JSONObject();
				if(i<5)
				{
					d1=i*7*24;
					timeLineObj.put("valueField",d1);
					if (i==1)
					{
						s=i+" "+mappingInfo.getTextDescription("admin.reports.week");
						timeLineObj.put("displayField",s);
						timeLineArrayJson.add(timeLineObj);
					}
					else
					{
						s=i+" "+mappingInfo.getTextDescription("admin.reports.weeks");
						timeLineObj.put("displayField",s);
						timeLineArrayJson.add(timeLineObj);
					}
					if (timeline.equals(String.valueOf(d1)))
					{
						ex_timeline = i+" weeks";
						if (i == 1)
						{
							ex_timeline = i+" week";
						}
						selectedTimeLineJson.put("timeline",d1);
					}else
					{
						//selectedTimeLineJson.put("timeline","Unlimited");
					}
				}
				else
				{
					if(i>4)
					{
						d1=1;
						s=d1+" "+mappingInfo.getTextDescription("admin.reports.month");
						d2=d1*30*24;
						timeLineObj.put("valueField",d2);
						timeLineObj.put("displayField",s);
						timeLineArrayJson.add(timeLineObj);
					}
					int timelineValue = 0;
					try 
					{
						timelineValue = Integer.parseInt(timeline);
					}catch(Exception e)
					{
						timelineValue = 0;
					}
					if (timelineValue >=d2)
					{
						ex_timeline = d1+" month";
						selectedTimeLineJson.put("timeline",720);
					}
					else
					{
						//selectedTimeLineJson.put("timeline","Unlimited");
					}
				}
			}
			
			//JSONObject unlimitedTimeLineObj = new JSONObject();
			//unlimitedTimeLineObj.put("valueField","-1");
			//unlimitedTimeLineObj.put("displayField","Unlimited");
			//timeLineArrayJson.add(unlimitedTimeLineObj);
			//Integer aValue = new Integer(-1);
			//String timeLineStr = aValue.toString();
			//if (timeline == timeLineStr || timeline.equalsIgnoreCase(timeLineStr))
			//{
				//selectedTimeLineJson.put("timeline","Unlimited");
			//}

			String existingWeekendDays = "";
			for (int j=0;j<v_days.size();j++)
			{
				JSONObject dayObj = new JSONObject();
				String day=(String)v_days.get(j);
				String adminReportText="admin.reports.";
				String textForDBLSupport = adminReportText+day;
				String textDescription = mappingInfo.getTextDescription(textForDBLSupport);
				dayObj.put("valueField",day);
				dayObj.put("displayField",textDescription);
				daysOfWeekArrayJson.add(dayObj);
				if (v_exc.contains(day.trim()))
				{
					JSONObject selWeekendDays = new JSONObject();
					selWeekendDays.put("displayField",day.trim());
					selWeekendDays.put("valueField",day.trim());
					selectedDaysOfWeekArrayJson.add(selWeekendDays);
					existingWeekendDays += day.trim() + ",";
				}
				else
				{
				}
			}

			if(existingWeekendDays.endsWith(","))
			{
				existingWeekendDays = existingWeekendDays.substring(0,existingWeekendDays.lastIndexOf(","));
			}
		}
		String selectedMeasures="";

	}
	else
	{
		Vector errors = new Vector();
		errors.addElement(_mapping.getTextDescription("admin.error.Admin Home"));
		errors.addElement("EgAdminOperations.jsp");
		errors.addElement(_mapping.getTextDescription("admin.error.Possible Reason"));
		errors.addElement(_mapping.getTextDescription("admin.error.Your license does not allow you to use this feature")+".");
		errors.addElement(_mapping.getTextDescription("admin.error.Please contact") + " <a href='mailTo:license@eginnovations.com' target='_parent' class='dash_link'><b>license@eginnovations.com</b></a> " + _mapping.getTextDescription("admin.error.for more details")+".");
		session.putValue("vec_Errors", errors);
		//response.sendRedirect("EgErrors.jsp");
	}
	if(request.getQueryString()!=null)
		session.setAttribute("adminLastAccessedURL","/final/admin/EgConsolidatedReports.jsp?"+request.getQueryString());
	else
		session.setAttribute("adminLastAccessedURL","/final/admin/EgConsolidatedReports.jsp?catType=Zone&secType=ZONE");

	rootJson.put("catTypeArrayJson",catTypeArrayJson);
	rootJson.put("timeArrayJson",timeArrayJson);
	rootJson.put("toTimeArrayJson",toTimeArrayJson);
	rootJson.put("minArrayJson",minArrayJson);
	rootJson.put("daysOfWeekArrayJson",daysOfWeekArrayJson);
	rootJson.put("timeLineArrayJson",timeLineArrayJson);

	rootJson.put("selectedCatTypeJson",selectedCatTypeJson);
	rootJson.put("selectedFromTimeJson",selectedFromTimeJson);
	rootJson.put("selectedToTimeJson",selectedToTimeJson);
	rootJson.put("selectedFromMinJson",selectedFromMinJson);
	rootJson.put("selectedToMinJson",selectedToMinJson);
	rootJson.put("selectedTimeLineJson",selectedTimeLineJson);
	rootJson.put("selectedDaysOfWeekArrayJson",selectedDaysOfWeekArrayJson);

	out.println(rootJson);
%>



