<!DOCTYPE html>

<%@ include file="EgTrackerA.jsp" %>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	if (request.getQueryString() != null)
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/EgConsolidatedReports.jsp?"+request.getQueryString());
	}
	else
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/EgConsolidatedReports.jsp?catType=Zone&secType=ZONE");
	}

	String catType = "";
	String secType = "";
	String services = "";
	if(request.getQueryString()!=null)
	{
		catType = (String) request.getParameter("catType");
		secType = (String) request.getParameter("secType");
		services = (String) request.getParameter("category");
	}
%>

<html>
<head>
	<meta charset="utf-8">
	<title>CONSOLIDATED REPORTS</title>

	<!--Skin color--------->
	<egui:skin ui = "admin"/>

	<!---Components, icons, skin and Core ext script--->
	<script type="text/javascript" src="../extjs/ext-all.js"></script>

	<!-- Fancy Scroll-->
	<script src="/final/scripts/jquery-1.8.2.js"></script>
	<script src="/final/styles/jscrollpane/jquery.jscrollpane.js" ></script>
	<script src="/final/styles/jscrollpane/jquery.mousewheel.js" ></script>
	<script src="/final/styles/jscrollpane/mwheelIntent.js" ></script>
	<link rel="stylesheet" href="/final/styles/jscrollpane/jquery.jscrollpane.css"/>

	<!-- Application folder -->
	<script language="JavaScript">
		var csrfToken = '<%=strCsrfToken%>';
		var measuresToUpdate = new Array();
		var deletedMeasuresToUpdate = new Array();
		var assoMeasuresMap = new Ext.util.HashMap();
		var measuresToUpdateMap = new Ext.util.HashMap();
		var measureToAdd = '';
		var k = 0;
		var toDeleteIterator = 0;
		var publicJson = '';
		var catTypeFromSession = '<%=catType%>';
		var secTypeFromSession = '<%=secType%>';
		var servicesFromSession = '<%=services%>';

		if (servicesFromSession == 'null' || servicesFromSession == null)
		{
			servicesFromSession = 'notConfig';
		}

		var consolidatedReportsTitle = '<egui:intnl text="admin.reports.Consolidated Reports" />';
		var consolidatedReportsDesc = '<egui:intnl text="admin.reports.This page enables the administrator to configure default values for consolidated / thin client reports" />.';
		var consolidReportType = '<egui:intnl text="admin.reports.Report type" />';
		var consolidTimePeriod = '<egui:intnl text="admin.reports.Time period" />';
		var consolidTimeline = '<egui:intnl text="admin.reports.Timeline (Default) Only for thin client reports" />';
		var consolidWeekendDays = '<egui:intnl text="admin.reports.Weekend days" />';
		var consolidUpdateText = '<egui:intnl text="admin.reports.Update" />';

		var configureMetricsBtn = '<egui:intnl text="admin.reports.Configure metrics for specific component type" />';

		var consolidatedMeasureTitle = '<egui:intnl text="admin.reports.Consolidated Measures" />';
		var consolidatedMeasureDesc = '<egui:intnl text="admin.reports.This page enables the administrator to configure metrics for consolidated reports" />.';
		var measuresReportType = '<egui:intnl text="admin.reports.Report type" />';

		var measuresCompType = '<egui:intnl text="admin.reports.Component type" />';
		var measuresTest = '<egui:intnl text="admin.reports.Test" />';
		var measuresMeasure = '<egui:intnl text="admin.reports.Measure" />';
		var measuresDisplayName = '<egui:intnl text="admin.reports.Display name" />';

		var measuresFuncText = '<egui:intnl text="admin.reports.Functions" />';
		var measuresAddText = '<egui:intnl text="admin.reports.Add" />';
		var measuresDeleteText = '<egui:intnl text="admin.reports.Delete" />';
		var measuresUpdateText = '<egui:intnl text="admin.reports.Update" />';
		var measuresBackText = '<egui:intnl text="admin.reports.Back" />';

		var alertForDeleteConfirmation = '<egui:intnl text="admin.reports.Do you want to delete the selected measure" />?';
		var alertforAlreadyAdded = '<egui:intnl text="admin.reports.Your current selection has already been added" />';
		var alertForNoTest = '<egui:intnl text="admin.reports.Please choose a test" />';
		var alertForNoMeasure = '<egui:intnl text="admin.reports.Please choose a measure" />';

		var associatedMeasuresMulti = '<egui:intnl text="admin.reports.Associated measures" />';

		var consolidatedReportSuccess = '<egui:intnl text="admin.reports.Configuration has been updated successfully" />.';
		var consolidatedReportFailure = '<egui:intnl text="admin.reports.Configuration has not been updated successfully" />.';

		var probsErrorMessage = '<egui:intnl text="admin.error.Problem encountered while loading the user interface"/>.';
		var noSelectionMsg = '<egui:intnl text="admin.reports.Please choose any associated measures"/>.';
		var noSelectionFuncMsg = '<egui:intnl text="admin.reports.Please choose a function to be performed"/>.';
		var requestTimeOut = '<egui:intnl text="admin.error.Response timed out"/>.';
		var errorTitle = '<egui:intnl text="admin.user.Error"/>';
	</script>

	<script type="text/javascript" src="EgConsolidatedReports/app/app.js"></script>

	<script language="javascript">
		Ext.onReady(function(){
			Ext.Ajax.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
			Ext.data.Connection.prototype.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
			Ext.data.ScriptTagProxy.prototype.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};

			Ext.Ajax.on('requestexception', function (conn, response, options) {
				var errorStr = response.responseText;
				if (errorStr != undefined && errorStr != 'undefined' && errorStr.indexOf("customerror") != -1)
				{
					if (errorStr.indexOf("user-session-invalid") != -1)
					{
						callWindow(1);
					}
					else if (errorStr.indexOf("user-deleted") != -1)
					{
						callWindow(2);
					}
					else if (errorStr.indexOf("user-timedout") != -1)
					{
						callWindow(3);
					}
				}
				else
				{
					if (response.status == 302 || (response.timedout != undefined && response.timedout == true))
					{
						Ext.Msg.show({
							title : errorTitle,
							msg : requestTimeOut,
							buttons : Ext.Msg.OK,
							icon : 'iconError'
						});
					}
					else
					{
						console.log(response.responseText);
						Ext.Msg.show({
							title : errorTitle,
							msg : probsErrorMessage,
							buttons : Ext.Msg.OK,
							icon : 'iconError'
						});
					}
				}
			});
		});
	</script>
</head>
<body>

</body>
</html>



