<%
/*
 *   File		:	EgConfigureDefaultTestParams.jsp
 *   Purpose	:	Default page for test configuration
 *   Author		:	S.Anand (2009)
 *   UI Design	:	Jaiwin & Krishnamurthi
*/
%>

<%@ include file="EgTrackerA.jsp" %>
<%@ page errorPage="EgProbs.jsp"%>
<%@ page import="com.eg.IniFile" %>
<%@ page import="com.eg.EgSpecsInfo" %>
<%@ page import="com.eg.EgInstallInfo" %>
<%@ page import="com.eg.EgUtils" %>
<%@ page import="com.eg.EgURLEncoder" %>
<%@ page import="com.eg.EgURLDecoder" %>
<%@ page import="java.util.*" %>
<%@ page import="com.eg.EgUtils" %>
<%@ page import="com.egurkha.util.*" %>
<%@ page import="com.eg.EgCrypt" %>
<%@ page import="com.eg.EgRoleInfo" %>
<%@ page import="com.eg.EgName" %>
<%@ page import="com.eg.MappingNameSorter" %>
<%@ page import="com.egurkha.ini.IniUI" %>
<%@ page import = "com.egurkha.util.EgStackForBackButton"%>
<%@ page import = "com.eg.EgConfigFilesSync"%>
<%@ page import="com.eg.EgConfigInfo"%>
<%@ page import="com.eg.EgUsersInfo"%>

<%@ taglib prefix ="egui" uri="../WEB-INF/eg-taglib.tld"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%!
	EgSpecsInfo egSpecs = new EgSpecsInfo("manager");

	//param to continue globally
	String[] paramToContinue = {"host","port","mCount","rptName","agentless","Hyperv","isLdoms","isPassive","server_type_name"};

	//param to be continued for snmpV1 and snmpV2
	String[] snmpV1V2ParamToContinue = {"username","authpass","authtype","encryptflag","encrypttype","encryptpassword"};

	//param to be continued in snmpV3 when encrypt param is false
	String[] snmpV3ParamToContinue = {"encrypttype","encryptpassword"};

	//param to continue when mode is true.(applicable to java application component type)
	String[] modeTrueToContinue = {"Jmx_Remote_Port","Jndi_Name","user","password"};

	//param to continue when mode is false.(applicable to java application component type)
	String[] modeFalseToContinue = {"snmpversion","snmpcommunity","snmpPort","authtype","authpass","username","encryptflag","encryptpassword","encrypttype"};

	String[] targetDiskIORateLabel = {"Equals","Less Than","Less Than or Equal To","Greater Than","Greater Than or Equal To"};

	String[] targetDiskIORateValue = {"EQ","LT","LE","GT","GE"};

	//param to set in read-only mode when the test is set to have muti-user enabled
	String[] multiUserReadOnlyParam = {"user","admin_user","domain","password","admin_password"};
	String[] multiNameReadOnlyParam = {"name","pattern","threshold_value"};
	ArrayList aListPages = new ArrayList();

	public boolean isParameter(String encryptParam)
	{
		String decryptParam = EgCrypt.decrypt(encryptParam);
		if (decryptParam.equals(encryptParam)) // not password
		{
			return (true);
		}
		return false;
	}
	private ArrayList getParameterList(String str,boolean needLowerCaseKey)
	{
		String delimiter = " -";
		ArrayList aListResultant = new ArrayList();
		String prevKey = "";

		str = str.substring(str.indexOf("-"));
		int spaceHyphenIdx = str.indexOf(delimiter);
		while (spaceHyphenIdx != -1)
		{
			String cutString = str.substring(0,spaceHyphenIdx);

			//This check will be carried out when the cutString contains only the key
			//for e.g.:-
			//str : -admin_password -103:98:88:90:79:76:81:-110:52 -ssl false
			//cutString : -admin_password
			if (cutString.trim().indexOf(" ") == -1)
			{
				String strPart1 = str.substring(cutString.length()+1);
				String strPart2 = strPart1.substring(0,strPart1.indexOf(delimiter));
				cutString = cutString+" "+strPart2;
				spaceHyphenIdx = cutString.length();
			}

			if (cutString.indexOf("\"") != -1)
			{
				String strAfterDoubleQuotes = str.substring(spaceHyphenIdx);
				String remainingPiece = strAfterDoubleQuotes.substring(0,strAfterDoubleQuotes.indexOf("\"")+1);
				cutString = cutString + remainingPiece;

				String key = cutString.substring(0,cutString.indexOf(" "));
				String value = cutString.substring(cutString.indexOf(" ")+1);
				if (needLowerCaseKey)
				{
					aListResultant.add(key.trim().toLowerCase());
				}
				else
				{
					aListResultant.add(key.trim());
				}
				aListResultant.add(value.trim());

				String remainingString = strAfterDoubleQuotes.substring(strAfterDoubleQuotes.indexOf("\"")+1);
				str = remainingString.trim();
				if (str.length() == 0)
				{
					spaceHyphenIdx = -1;
				}
				else
				{
					spaceHyphenIdx = str.indexOf(delimiter);
				}
			}
			else
			{
				if (cutString.startsWith("- "))
				{
					int idx = aListResultant.indexOf(prevKey);
					String strValue = (String)aListResultant.get(idx+1);
					strValue = strValue + " " + cutString;
					aListResultant.remove(idx+1);
					aListResultant.add(strValue);

					str = str.substring(cutString.length()+1);
				}
				else
				{
					String key = cutString.substring(0,cutString.indexOf(" "));
					String value = cutString.substring(cutString.indexOf(" ")+1);
					if (needLowerCaseKey)
					{
						aListResultant.add(key.trim().toLowerCase());
						prevKey = key.trim().toLowerCase();
					}
					else
					{
						aListResultant.add(key.trim());
						prevKey = key.trim();
					}
					aListResultant.add(value.trim());

					str = str.substring(spaceHyphenIdx+1);
				}
				spaceHyphenIdx = str.indexOf(delimiter);
			}
		}

		if (str.length() > 0)
		{
			if (str.startsWith("- "))
			{
				int idx = aListResultant.indexOf(prevKey);
				String strValue = (String)aListResultant.get(idx+1);
				strValue = strValue + " " + str;
				aListResultant.remove(idx+1);
				aListResultant.add(strValue);
			}
			else
			{
				String lastKey = str.substring(0,str.indexOf(" "));
				String lastValue = str.substring(str.indexOf(" ")+1);
				if (needLowerCaseKey)
				{
					aListResultant.add(lastKey.trim().toLowerCase());
				}
				else
				{
					aListResultant.add(lastKey.trim());
				}
				aListResultant.add(lastValue.trim());
			}
		}

		return aListResultant;
	}
%>

<%
	IniUI iniUI = IniUI.getInstance();
	String userLanguage = iniUI.getDefaultLanguage();
	if (_user != null)
	{
		userLanguage = _user.getLanguage();
	}
	MappingNameSorter sorter = new MappingNameSorter(userLanguage);
	EgUsersInfo usersInfo = new EgUsersInfo();

	//tells information about the corresponding authenticated user
	EgRoleInfo ri = EgRoleInfo.getInstance(session.getId(),(String)session.getAttribute("sess_userid"));
	List listComponentTypes = Arrays.asList(ri.getServerTypes());
	listComponentTypes = sorter.getSortedCompTypeList(listComponentTypes);
	String selectedCompType = "";

	Arrays.sort(paramToContinue, String.CASE_INSENSITIVE_ORDER);
	Arrays.sort(snmpV1V2ParamToContinue, String.CASE_INSENSITIVE_ORDER);
	Arrays.sort(snmpV3ParamToContinue, String.CASE_INSENSITIVE_ORDER);
	Arrays.sort(modeTrueToContinue, String.CASE_INSENSITIVE_ORDER);
	Arrays.sort(modeFalseToContinue, String.CASE_INSENSITIVE_ORDER);
	Arrays.sort(multiUserReadOnlyParam, String.CASE_INSENSITIVE_ORDER);
	Arrays.sort(multiNameReadOnlyParam, String.CASE_INSENSITIVE_ORDER);

	ArrayList aListParamNamesValues = new ArrayList();
	ArrayList aListDisplay = new ArrayList();

	String componentType = request.getParameter("componentType");
	componentType = (componentType != null)?componentType:"";

	String previousComponentType = request.getParameter("previousComponentType");
	previousComponentType = (previousComponentType != null)?previousComponentType:"";

	String testType = testType = request.getParameter("testType");
	testType = (testType == null)?"PerformanceTest":testType;

	String perviousTestType = request.getParameter("previousTestType");
	perviousTestType = (perviousTestType == null)?"PerformanceTest":perviousTestType;

	String pfSelected = "";
	String cfSelected = "";
	if (testType.equalsIgnoreCase("PerformanceTest"))
	{
		pfSelected = "selected";
	}
	else
	{
		cfSelected = "selected";
	}

	String testName = "";
	if (previousComponentType.equals(componentType) && testType.equals(perviousTestType))
	{
		testName = request.getParameter("testName");
		testName = (testName != null)?testName:"";
		testName = testName.trim();
	}

	String previousTestName = request.getParameter("previousTestName");
	previousTestName = (previousTestName != null)?previousTestName:"";

	String allowedParams = "";
	String strTcKeywords = "";
	String[] tcKeywords = new String[0];
	ArrayList aListTcKeywordsLowerCase = new ArrayList();

	ArrayList aListParamsWithDoubleQuotes = null;
	String strDoubleQuotesParams = "";

	String strDelimiter = "";
	String strDelimiterMask = "";
	String[] arrDelimiterMasks = new String[0];

	ArrayList aResultant = new ArrayList();
	ArrayList aListResultantTempInLowerCase = new ArrayList();
	ArrayList aListResultantInLowerCase = new ArrayList();

	ArrayList aListEnabledTestForCompType = new ArrayList();

	//for testperiod
	TreeMap periodMap = new TreeMap();
	String testPeriod = "";

	boolean isCorrectiveScriptEnabled = false;
	boolean isCorrectParamExist = false;

	//For SNMP - Start
	boolean isSnmp=false;
	boolean isSnmpV1V2 = false;
	String[] versions = {"v1","v2","v3"};
	String[] authTypes = {"MD5","SHA"};
	String[] encryptTypes = {"DES","AES"};
	String snmpVer = "";
	String encryptValue = "";
	String encryptFlag = "";
	boolean isOldSnmp = false;

	boolean isModeParamExist =false;

	//policy filter start
	boolean isPolicyParamExists = false;
	ArrayList aPolicyFilter = new ArrayList();
	String tPolicyFilter = "";
	//policy filter end

	//show_alias_and_interface_name - starts
	boolean hasShowAliasParam = false;
	String useAliasValue = "";
	//show_alias_and_interface_name - ends

	boolean isWsdlUrlExist=false;
	boolean isUrlParamExist = false;
	ArrayList aUrlCredentialVal = new ArrayList();
	boolean isCredentialParamExist = false;
	boolean isPrivateKeyParamExist = false;
	ArrayList aListContentValues = new ArrayList();
	ArrayList aListEncodingValues = new ArrayList();
	ArrayList aListFilePathValues = new ArrayList();

	ArrayList aListDynamicSelectOptionNameAndValue = new ArrayList();
	ArrayList aListDynamicRadioOptionNameAndValue = new ArrayList();

	//contains multiple user enabled test - starts
	List listMultipleUserSupportTest = null;
	//for tests which is mutiple user enabled
	boolean multiUserMode = false;
	boolean multiNamePatternMode = false;
	//contains multiple user enabled test - starts

	//virtual center
	String[] virtualCenters = null;
	//RHEV
	String[] rhevs = null;
	//HMC
	String[] hmcs = null;
	boolean isHMC = false;
	String resIsManagedByValue = "";

	//url parameter(Http or HttpPost Test)
	String previousUrl = null;

	//showAllOnly - starts
	boolean hasShowAllOnlyParam = false;
	String showAllEventsValue = "";
	//showAllOnly - ends

	//Report_only_total - starts
	boolean hasReportOnlyTotalParam = false;
	String reportTotalValue = "";
	//Report_only_total - ends

	String strSpecificPattern = "false";
	//contains enabled test for a component type
	ArrayList aListTempEnabledTests = null;
	if (!componentType.equals("") && !componentType.equals("-1"))
	{
		if (testType.equals("PerformanceTest"))
		{
			aListEnabledTestForCompType = egSpecs.getEnabledTests(componentType,false);
		}
		else
		{
			aListEnabledTestForCompType = egSpecs.getEnabledTests(componentType,true);
		}
		aListTempEnabledTests = new ArrayList(aListEnabledTestForCompType);
		aListEnabledTestForCompType = sorter.getSortedTestList(aListEnabledTestForCompType);
	}

	boolean viewAccessOnly = false;
	boolean userBasedLicense = usersInfo.isUserBasedLicense();

	if (!componentType.equals("") && !componentType.equals("-1") && 
		!testName.equals("") && !testName.equals("-1") && 
		!testType.equals(""))
	{
		IniFile egTestParamIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_testparam.ini");
		ArrayList aListPasswordParameters = null;
		boolean hasPasswordParameters = false;
		String[] passwordTests = egTestParamIni.getVariables("PASSWORD");
		List listPasswordTests = Arrays.asList(passwordTests);
		for (int i=0;i<aListTempEnabledTests.size();i++)
		{
			String strTest = (String)aListTempEnabledTests.get(i);
			if (listPasswordTests.contains(strTest))
			{
				String strPasswordParams = egTestParamIni.getValue("PASSWORD",strTest);
				StringTokenizer stPasswordParams = new StringTokenizer(strPasswordParams,",");
				while (stPasswordParams.hasMoreTokens())
				{
					String tempParam = stPasswordParams.nextToken();
					tempParam = "-" + tempParam;
					if (aListPasswordParameters == null)
					{
						aListPasswordParameters = new ArrayList();
						hasPasswordParameters = true;
					}

					if (aListPasswordParameters.contains(tempParam)) continue;

					aListPasswordParameters.add(tempParam);
				}
			}
		}
		session.setAttribute("aListPasswordParameters",aListPasswordParameters);

		String[] defaultControl = egTestParamIni.getVariables("PARAM-CONTROL");
		ArrayList aListDefaultPasswordParameters = null;
		if (defaultControl != null && defaultControl.length > 0)
		{
			for (int i=0;i<defaultControl.length;i++)
			{
				String tempParamName = defaultControl[i];
				String tempParamValue = egTestParamIni.getValue("PARAM-CONTROL",tempParamName);
				if (tempParamValue.equalsIgnoreCase("password"))
				{
					if (aListDefaultPasswordParameters == null)
					{
						aListDefaultPasswordParameters = new ArrayList();
					}

					aListDefaultPasswordParameters.add("-"+tempParamName.toLowerCase());
				}
			}
		}
		session.setAttribute("aListDefaultPasswordParameters",aListDefaultPasswordParameters);

		//String[] paramsWithDoubleQuotes = egTestParamIni.getVariables("ENCLOSE_WITH_DOUBLEQUOTES");
		String[] paramsWithDoubleQuotes = null;
		if (paramsWithDoubleQuotes != null && paramsWithDoubleQuotes.length > 0)
		{
			for (int i=0;i<paramsWithDoubleQuotes.length;i++)
			{
				String tempParamName = paramsWithDoubleQuotes[i];
				if (aListParamsWithDoubleQuotes == null)
				{
					aListParamsWithDoubleQuotes = new ArrayList();
				}
				aListParamsWithDoubleQuotes.add(tempParamName.toLowerCase());
			}

			strDoubleQuotesParams = aListParamsWithDoubleQuotes.toString();
			strDoubleQuotesParams = strDoubleQuotesParams.substring(1,strDoubleQuotesParams.length()-1);
			strDoubleQuotesParams = StringUtils.replace(strDoubleQuotesParams,", ",",");
		}

		String port = "";

		if (componentType.equals("Oracle_server"))
		{
			port = "$portNo:$sid";
		}
		else
		{
			port = "$portNo";
		}

		String patternA = testName + ":" + componentType + ":" + "$hostName" + ":" + port;
		String patternB = testName + ":" + componentType + ":" + "$hostName";
		String patternC = testName + "::" + "$hostName" + ":" + port;
		String patternD = testName + "::" + "$hostName";

		List listSpecficationVariables = Arrays.asList(egSpecs.getTestSpecVar());
		String resultantPattern = "";
		if (listSpecficationVariables.contains(patternA))
		{
			resultantPattern = patternA;
			strSpecificPattern = "true";
		}
		else if (listSpecficationVariables.contains(patternB))
		{
			resultantPattern = patternB;
			strSpecificPattern = "true";
		}
		else if (listSpecficationVariables.contains(patternC))
		{
			resultantPattern = patternC;
		}
		else if (listSpecficationVariables.contains(patternD))
		{
			resultantPattern = patternD;
		}

		session.setAttribute("strSpecificPattern",strSpecificPattern);
		String defaultTestParams = egSpecs.getArgsForTest(resultantPattern);
		if (defaultTestParams == null || defaultTestParams.equals(""))
		{
			Vector sess_vec = new Vector();
			sess_vec.addElement(_mapping.getTextDescription("admin.test.Configure Agents!"));
			sess_vec.addElement("EgConfigureDefaultTestParams.jsp?qctr=1&componentType=" + componentType);
			sess_vec.addElement(_mapping.getTextDescription("admin.test.TEST NOT AVAILABLE FOR CONFIGURATION"));
			sess_vec.addElement("<b>"+_mapping.getTestDescription(testName)+"</b> "+_mapping.getTextDescription("admin.test.for")+" <b>"+_mapping.getComponentTypeDescription(componentType)+"</b> "+_mapping.getTextDescription("admin.test.is currently not available for configuration")+". ");
			sess_vec.addElement("<br>"+_mapping.getTextDescription("admin.test.Please contact System administrator")+".");
			session.setAttribute("vec_Errors",sess_vec);
%>
			<jsp:forward page="EgErrors.jsp"/>
<%
		}

		StringTokenizer stParamTokens = new StringTokenizer(defaultTestParams,",");
		stParamTokens.nextToken();
		stParamTokens.nextToken();
		String testParams = stParamTokens.nextToken();
		testPeriod = stParamTokens.nextToken().trim();

		allowedParams = egTestParamIni.getValue("SPECIAL_CHARACTERS","Parameters");

		tcKeywords=egTestParamIni.getVariables("TEST_CONFIGURATION_PARAM_VALUE_KEYWORDS");
		List listTcKeywords = Arrays.asList(tcKeywords);
		strTcKeywords = listTcKeywords.toString();
		strTcKeywords = strTcKeywords.substring(1,strTcKeywords.length()-1);
		strTcKeywords = StringUtils.replace(strTcKeywords,", ",",");
		for (int i=0;i<listTcKeywords.size();i++)
		{
			String strKeyword = (String)listTcKeywords.get(i);
			strKeyword = strKeyword.trim();
			strKeyword = strKeyword.toLowerCase();
			aListTcKeywordsLowerCase.add(strKeyword);
		}

		HashMap hmapTestParamDetails = new HashMap();

		//radio
		String testRadioValue = egTestParamIni.getValue("RADIO",testName);
		StringTokenizer radioTokens = new StringTokenizer(testRadioValue,",");
		while (radioTokens.hasMoreTokens())
		{
			String eachRadioToken = radioTokens.nextToken();
			if (eachRadioToken.indexOf("(") > -1 && eachRadioToken.indexOf(")") > -1)
			{
				String tempStrs = eachRadioToken.substring(eachRadioToken.indexOf("(")+1,eachRadioToken.indexOf(")"));
				eachRadioToken = eachRadioToken.substring(0,eachRadioToken.indexOf("("));
				if (!aListDynamicRadioOptionNameAndValue.contains(eachRadioToken))
				{
					aListDynamicRadioOptionNameAndValue.add(eachRadioToken);//param name
					aListDynamicRadioOptionNameAndValue.add(tempStrs);//param value
				}
			}
			hmapTestParamDetails.put(eachRadioToken.toLowerCase(),"radio");
		}

		//select
		String testSelectValue = egTestParamIni.getValue("SELECT",testName);
		StringTokenizer selectTokens = new StringTokenizer(testSelectValue,",");
		while (selectTokens.hasMoreTokens())
		{
			String eachSelectToken = selectTokens.nextToken();
			if (eachSelectToken.indexOf("(") > -1 && eachSelectToken.indexOf(")") > -1)
			{
				String tempStrs = eachSelectToken.substring(eachSelectToken.indexOf("(")+1,eachSelectToken.lastIndexOf(")"));
				eachSelectToken = eachSelectToken.substring(0,eachSelectToken.indexOf("("));
				if (!aListDynamicSelectOptionNameAndValue.contains(eachSelectToken))
				{
					aListDynamicSelectOptionNameAndValue.add(eachSelectToken);//param name
					aListDynamicSelectOptionNameAndValue.add(tempStrs);//param value
				}
			}
			hmapTestParamDetails.put(eachSelectToken.toLowerCase(),"select");
		}

		//password
		String testPwdValue = egTestParamIni.getValue("PASSWORD",testName);
		StringTokenizer pwdTokens = new StringTokenizer(testPwdValue,",");
		while (pwdTokens.hasMoreTokens())
		{
			String eachPwdToken = pwdTokens.nextToken();
			hmapTestParamDetails.put(eachPwdToken.toLowerCase(),"password");
		}

		//textarea
		String testTextAreaValue = egTestParamIni.getValue("TEXTAREA",testName);
		StringTokenizer txtAreaTokens = new StringTokenizer(testTextAreaValue,",");
		while (txtAreaTokens.hasMoreTokens())
		{
			String eachTxtAreaCount = txtAreaTokens.nextToken();
			hmapTestParamDetails.put(eachTxtAreaCount.toLowerCase(),"textarea");
		}

		List listDefaultControls = new ArrayList();
		if (defaultControl != null && defaultControl.length > 0)
		{
			for (int i=0;i<defaultControl.length;i++)
			{
				String tempParamName = defaultControl[i].toLowerCase();
				listDefaultControls.add(tempParamName);
			}
		}

		ArrayList aListTemp = getParameterList(testParams.trim(),false);
		for (int i=0;i<aListTemp.size();i=i+2)
		{
			String strParamName = (String)aListTemp.get(i);
			String strSearch = strParamName.substring(1);
			strSearch = strSearch.toLowerCase();
			String strParamValue = (String)aListTemp.get(i+1);
			String controlName = null;

			boolean isParamExist = hmapTestParamDetails.containsKey(strSearch);
			if (isParamExist)
			{
				controlName = hmapTestParamDetails.get(strSearch).toString();
			}
			else if (listDefaultControls.contains(strSearch))
			{
				String tempName = strParamName.substring(1);
				controlName = egTestParamIni.getValue("PARAM-CONTROL",tempName.toLowerCase());
				if (controlName.indexOf("(") > -1 && controlName.indexOf(")") > -1)
				{
					String tempStrs = controlName.substring(controlName.indexOf("(")+1,controlName.length()-1);
					controlName = controlName.substring(0,controlName.indexOf("("));
					if (controlName.equals("select") && 
						!aListDynamicSelectOptionNameAndValue.contains(tempName))
					{
						aListDynamicSelectOptionNameAndValue.add(tempName);
						aListDynamicSelectOptionNameAndValue.add(tempStrs);
					}
					if (controlName.equals("radio") && 
						!aListDynamicRadioOptionNameAndValue.contains(tempName))
					{
						aListDynamicRadioOptionNameAndValue.add(tempName);
						aListDynamicRadioOptionNameAndValue.add(tempStrs);
					}
				}
			}
			else
			{
				controlName = "text";
			}

			aResultant.add(strParamName);
			aResultant.add(strParamValue);
			aResultant.add(controlName);
		}

		for (int i=0;i<aResultant.size();i++)
		{
			aListResultantTempInLowerCase.add(aResultant.get(i).toString().toLowerCase());
		}

		if (aListResultantTempInLowerCase.contains("-usealias") && 
			aListResultantTempInLowerCase.contains("-show_alias_and_interface_name"))
		{
			hasShowAliasParam = true;
			int useAliasIdx = aListResultantTempInLowerCase.indexOf("-usealias");
			String useAliasCase = (String)aResultant.get(useAliasIdx);
			useAliasCase = useAliasCase.substring(1);
			useAliasValue = request.getParameter(useAliasCase);
			if (useAliasValue == null || useAliasValue.length() == 0)
			{
				useAliasValue = (String)aResultant.get(useAliasIdx+1);
			}
		}

		isSnmp = aListResultantTempInLowerCase.contains("-snmpport");

		//java application
		isModeParamExist = (isSnmp && 
							aListResultantTempInLowerCase.contains("-mode") && 
							aListResultantTempInLowerCase.contains("-jmx_remote_port"));

		if (isSnmp)
		{
			int portIdx = aListResultantTempInLowerCase.indexOf("-port");
			String portCase = null;
			if (portIdx != -1)
			{
				portCase = (String)aResultant.get(portIdx);
			}

			int timeOutIdx = aListResultantTempInLowerCase.indexOf("-timeout");
			String timeOutCase = null;
			if (timeOutIdx != -1)
			{
				timeOutCase = (String)aResultant.get(timeOutIdx);
			}

			int modeIdx = aListResultantTempInLowerCase.indexOf("-mode");
			String modeCase = null;
			if (modeIdx != -1)
			{
				modeCase = (String)aResultant.get(modeIdx);
			}

			int snmpComIdx=aListResultantTempInLowerCase.indexOf("-snmpcommunity");

			//for older version of snmp not having snmpversion
			String selectToAdd = "";
			if (!aListResultantTempInLowerCase.contains("-snmpversion"))
			{
				aResultant.add(snmpComIdx+3,"-snmpversion");
				aResultant.add(snmpComIdx+4,"v1");
				aResultant.add(snmpComIdx+5,"select");

				aListResultantTempInLowerCase.add(snmpComIdx+3,"-snmpversion");
				aListResultantTempInLowerCase.add(snmpComIdx+4,"v1");
				aListResultantTempInLowerCase.add(snmpComIdx+5,"select");

				selectToAdd = selectToAdd + ",snmpversion";
				isOldSnmp = true;


				String[] tmpVersions = {"v1","v2"};
				versions = tmpVersions;
			}

			if (aListResultantTempInLowerCase.contains("-snmpversion") && !aListResultantTempInLowerCase.contains("-authtype") && !aListResultantTempInLowerCase.contains("-encrypttype"))
			{
				isOldSnmp = true;

				String[] tmpVersions = {"v1","v2"};
				versions = tmpVersions;
			}

			if (selectToAdd.length() > 0)
			{
				IniFile egTestParamIniSync = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_testparam.ini");
				egTestParamIniSync.setValue("SELECT",testName,selectToAdd.substring(1));
				egTestParamIniSync.saveFile();
				EgConfigFilesSync.releaseInstance(egTestParamIniSync);
			}

			int snmpVerIdx = aListResultantTempInLowerCase.indexOf("-snmpversion");

			if (testName.equals(previousTestName))
			{
				String originalSnmpParam = ((String)aResultant.get(snmpVerIdx)).substring(1);
				snmpVer = request.getParameter(originalSnmpParam);
				snmpVer = (snmpVer!=null)?snmpVer:"";
			}

			//displaying snmp community afer snmp version -starts
			String moveSnmpCommParam = (String)aResultant.remove(snmpComIdx);
			String moveSnmpCommValue = (String)aResultant.remove(snmpComIdx);
			String moveSnmpCommDisplayControl = (String)aResultant.remove(snmpComIdx);

			aResultant.add(snmpVerIdx,moveSnmpCommDisplayControl);
			aResultant.add(snmpVerIdx,moveSnmpCommValue);
			aResultant.add(snmpVerIdx,moveSnmpCommParam);
			//displaying snmp community afer snmp version -ends

			isSnmpV1V2 = (aListResultantTempInLowerCase.contains("v1") || aListResultantTempInLowerCase.contains("v2"))?true:false;

			if (snmpVer!="")
			{
				isSnmpV1V2 = (snmpVer.equalsIgnoreCase("v1") || snmpVer.equalsIgnoreCase("v2"))?true:false;
			}

			if(!isSnmpV1V2)
			{
				int encryptFlagIdx = aListResultantTempInLowerCase.indexOf("-encryptflag");
				if (encryptFlagIdx > -1)
				{
					if (testName.equals(previousTestName))
					{
						encryptFlag = request.getParameter(((String)aResultant.get(encryptFlagIdx)).substring(1));
						encryptFlag = (encryptFlag!=null)?encryptFlag:"";
					}
				}

				encryptValue = (String)aResultant.get(aListResultantTempInLowerCase.indexOf("-encryptflag")+1);
			}

			if (isModeParamExist)
			{
				if (timeOutIdx == -1)
				{
					//put mode after port
					//-host,-port,-mode
					int tempModeIdx = aResultant.indexOf(modeCase);
					String moveModeParam = (String)aResultant.remove(tempModeIdx);
					String moveModeValue = (String)aResultant.remove(tempModeIdx);
					String moveModeDisplayControl = (String)aResultant.remove(tempModeIdx);

					int tempPortIdx = aResultant.indexOf(portCase);
					aResultant.add(tempPortIdx+3,moveModeParam);
					aResultant.add(tempPortIdx+4,moveModeValue);
					aResultant.add(tempPortIdx+5,moveModeDisplayControl);
				}
				else
				{
					int tempTimeOutCaseIdx = aResultant.indexOf(timeOutCase);
					String moveTimeOutParam = (String)aResultant.remove(tempTimeOutCaseIdx);
					String moveTimeOutValue = (String)aResultant.remove(tempTimeOutCaseIdx);
					String moveTimeOutDisplayControl = (String)aResultant.remove(tempTimeOutCaseIdx);

					//-host,-port,-timeout,-mode
					//put timeout after port
					int tempPortIdx = aResultant.indexOf(portCase);
					aResultant.add(tempPortIdx+3,moveTimeOutParam);
					aResultant.add(tempPortIdx+4,moveTimeOutValue);
					aResultant.add(tempPortIdx+5,moveTimeOutDisplayControl);

					int tempModeCaseIdx = aResultant.indexOf(modeCase);
					String moveModeParam = (String)aResultant.remove(tempModeCaseIdx);
					String moveModeValue = (String)aResultant.remove(tempModeCaseIdx);
					String moveModeDisplayControl = (String)aResultant.remove(tempModeCaseIdx);

					//put mode after timeout
					int tempTimeOutCaseIdx1 = aResultant.indexOf(timeOutCase);
					aResultant.add(tempTimeOutCaseIdx1+3,moveModeParam);
					aResultant.add(tempTimeOutCaseIdx1+4,moveModeValue);
					aResultant.add(tempTimeOutCaseIdx1+5,moveModeDisplayControl);
				}
			}
		}

		if (aListResultantTempInLowerCase.contains("-showallevents") && 
			aListResultantTempInLowerCase.contains("-showallonly"))
		{
			hasShowAllOnlyParam = true;
			int showAllEventsIdx = aListResultantTempInLowerCase.indexOf("-showallevents");
			String showAllEventsCase = (String)aResultant.get(showAllEventsIdx);
			showAllEventsCase = showAllEventsCase.substring(1);
			showAllEventsValue = request.getParameter(showAllEventsCase);
			if (showAllEventsValue == null || showAllEventsValue.length() == 0)
			{
				showAllEventsValue = (String)aResultant.get(showAllEventsIdx+1);
			}
		}

		if (aListResultantTempInLowerCase.contains("-report_total") && 
			aListResultantTempInLowerCase.contains("-report_only_total"))
		{
			hasReportOnlyTotalParam = true;
			int reportTotalIdx = aListResultantTempInLowerCase.indexOf("-report_total");
			String reportTotalCase = (String)aResultant.get(reportTotalIdx);
			reportTotalCase = reportTotalCase.substring(1);
			reportTotalValue = request.getParameter(reportTotalCase);
			if (reportTotalValue == null || reportTotalValue.length() == 0)
			{
				reportTotalValue = (String)aResultant.get(reportTotalIdx+1);
			}
		}

		IniFile testsIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_tests.ini");

		//contains multiple user enabled test
		listMultipleUserSupportTest = Arrays.asList(testsIni.getVariables("MULTIPLE_USERS"));

		//policy filter work starts here
		isPolicyParamExists = aListResultantTempInLowerCase.contains("-policyfilter") && aListResultantTempInLowerCase.contains("-filter");

		String tLogType = "";
		int tLogTypeIdx = aListResultantTempInLowerCase.indexOf("-logtype");
		if (tLogTypeIdx > -1)
		{
			if (testName.equals(previousTestName))
			{
				tLogType = request.getParameter(((String)aResultant.get(tLogTypeIdx)).substring(1));
				tLogType = (tLogType != null && tLogType.length() > 0)?tLogType:"";
			}
		}

		int tPolicyFilterIdx = aListResultantTempInLowerCase.indexOf("-policyfilter");
		if (tPolicyFilterIdx > -1)
		{
			if (testName.equals(previousTestName))
			{
				tPolicyFilter = request.getParameter(((String)aResultant.get(tPolicyFilterIdx)).substring(1));
				tPolicyFilter = (tPolicyFilter != null && tPolicyFilter.length() > 0)?tPolicyFilter:"";
			}
		}

		if (isPolicyParamExists)
		{
			int policyFilterIdx = aListResultantTempInLowerCase.indexOf("-policyfilter");
			String policyFilterValue = (String)aResultant.get(policyFilterIdx+1);

			if ((policyFilterValue.equalsIgnoreCase("true") && (tPolicyFilter.length()==0 || tPolicyFilter.equalsIgnoreCase("true"))) || tPolicyFilter.equalsIgnoreCase("true"))
			{
				String testParam[] = testsIni.getVariables("EVENTLOG_POLICIES");
				for(int i = 0;i<testParam.length;i++)
				{
					if(!(testParam[i].startsWith(testName+":")))
						continue;
					String str = testParam[i].substring(testParam[i].lastIndexOf(":")+1,testParam[i].length());
					aPolicyFilter.add(str);
				}
			}

			if(tPolicyFilter.equalsIgnoreCase("false"))
			{
				ArrayList aListPolicy = new ArrayList();
				int filterIdx = aListResultantTempInLowerCase.indexOf("-filter");
				String filterValue = (String)aResultant.get(filterIdx+1);
				if(filterValue.indexOf(":") > -1)
				{
					if(filterValue.indexOf(";") > -1)
					{
						StringTokenizer policyTokens = new StringTokenizer(filterValue,";");
						while(policyTokens.hasMoreTokens())
						{
							String tempPolicy = policyTokens.nextToken();
							tempPolicy = tempPolicy.substring(0,tempPolicy.indexOf(":"));
							aListPolicy.add(tempPolicy);
						}
					}
					else
					{
						aListPolicy.add(filterValue.substring(0,filterValue.indexOf(":")));
					}
				}
				else
				{
					if(filterValue.indexOf(";")>-1)
					{
						//more than one policy name i.e -filter IISEvents;CitrixEvents;XchgEvents
						StringTokenizer policyTokens = new StringTokenizer(filterValue,";");
						while(policyTokens.hasMoreTokens())
						{
							aListPolicy.add(policyTokens.nextToken());
						}
					}
					else
					{
						//one policy name i.e -filter IISEvents
						aListPolicy.add(filterValue);
					}
				}

				for(int c=0;c<aListPolicy.size();c++)
				{
					String pattern = testName+":"+tLogType+":"+aListPolicy.get(c);
					String strVal = testsIni.getValue("EVENTLOG_POLICIES",pattern);
					strVal = (aListPolicy.get(c)).toString()+":"+strVal;
					aPolicyFilter.add(strVal);
				}
			}

			if (aPolicyFilter.size() > 0)
			{
				if (aPolicyFilter.contains("all"))
				{
					aPolicyFilter.remove("all");
					Collections.sort(aPolicyFilter,String.CASE_INSENSITIVE_ORDER);
					aPolicyFilter.add(0,"all");
				}
				else
				{
					Collections.sort(aPolicyFilter,String.CASE_INSENSITIVE_ORDER);
				}
			}
		}
		//policy filter work ends here

		//credential work starts here(http test)
		String moreUrl = "";
		if (testName.equals(previousTestName))
		{
			moreUrl = request.getParameter("moreurl");
			moreUrl = (moreUrl!=null)?moreUrl:"";
		}
		isCredentialParamExist = aListResultantTempInLowerCase.contains("-credentials");
		isUrlParamExist = aListResultantTempInLowerCase.contains("-url");
		isWsdlUrlExist = aListResultantTempInLowerCase.contains("-wsdl_url");
		isPrivateKeyParamExist = aListResultantTempInLowerCase.contains("-privatekey");
		ArrayList aTempUrl = new ArrayList();
		if (isCredentialParamExist)
		{
			int urlIdx=0;
			if(isUrlParamExist)
				urlIdx = aListResultantTempInLowerCase.indexOf("-url");
			else if(isWsdlUrlExist)
				urlIdx = aListResultantTempInLowerCase.indexOf("-wsdl_url");
			String urls = aResultant.get(urlIdx+1).toString();
			previousUrl = urls;
			StringTokenizer urlTokens = new StringTokenizer(urls,"|");
			int urlCount = urlTokens.countTokens();
			int credentialIdx = aListResultantTempInLowerCase.indexOf("-credentials");
			String credentialValues = aResultant.get(credentialIdx+1).toString();
			StringTokenizer credentialValuesTokens = new StringTokenizer(credentialValues,"|");
			int credentialTokens = credentialValuesTokens.countTokens();

			int contentIdx = aListResultantTempInLowerCase.indexOf("-content");
			String contentValues = aResultant.get(contentIdx+1).toString();
			StringTokenizer contentValuesTokens = new StringTokenizer(contentValues,"|");
			int contentTokens = contentValuesTokens.countTokens();

			int encodingIdx = aListResultantTempInLowerCase.indexOf("-encoding");
			String encodingValues = aResultant.get(encodingIdx+1).toString();
			StringTokenizer encodingValuesTokens = new StringTokenizer(encodingValues,"|");
			int encodingTokens = encodingValuesTokens.countTokens();
			
			String filePathValues ="";
			StringTokenizer filePathValuesTokens =null;
			int filePathTokens =0;
			if(isPrivateKeyParamExist)
			{
				int filePathIdx = aListResultantTempInLowerCase.indexOf("-privatekey");
				filePathValues = aResultant.get(filePathIdx+1).toString();
				filePathValuesTokens = new StringTokenizer(filePathValues,"|");
				filePathTokens = filePathValuesTokens.countTokens();
			}

			while(urlTokens.hasMoreTokens())
			{
				String s = urlTokens.nextToken();
				if (s.indexOf(":") > -1)
				{
					//URL Format->$name:$url
					aUrlCredentialVal.add(s.substring(0,s.indexOf(":")));
					String s1 = credentialValuesTokens.nextElement().toString();
					aUrlCredentialVal.add(s1.substring(0,s1.indexOf(":")));
					//decrypting the password
					String s2 = s1.substring(s1.indexOf(":")+1);
					s2 = EgCrypt.decrypt(s2);
					aUrlCredentialVal.add(s2);

					String s3 = contentValuesTokens.nextElement().toString();
					aListContentValues.add(s3);
					String s4 = encodingValuesTokens.nextElement().toString();
					aListEncodingValues.add(s4);
					
					if(isPrivateKeyParamExist)
					{
						String s5 = filePathValuesTokens.nextElement().toString();
						if(s5 != null && s5.startsWith("none"))
						{
							if(s5.indexOf(":")>-1)
							{
								aListFilePathValues.add(s5.substring(0,s5.indexOf(":")));
								//decrypting the password
								String s6 = s5.substring(s5.indexOf(":")+1);
								aListFilePathValues.add(EgCrypt.decrypt(s6));
							}
						}
						else
						{
							if(s5.indexOf(":")>-1)
							{
								String start = s5.substring(0,s5.indexOf(":"));
								String remaining = s5.substring(s5.indexOf(":")+1);
								String end = remaining.substring(0, remaining.indexOf(":"));
								String passStr = remaining.substring(remaining.indexOf(":")+1);
								aListFilePathValues.add(start+":"+end);
								//decrypting the password
								aListFilePathValues.add(EgCrypt.decrypt(passStr));
							}
						}
					}
				}
				else
				{
					//URL Format->$unconfigured
					aUrlCredentialVal.add("$unconfigured");
					aUrlCredentialVal.add("none");
					aUrlCredentialVal.add("none");

					aListContentValues.add("none:none");
					aListEncodingValues.add("none");
					
					if(isPrivateKeyParamExist)
					{
						aListFilePathValues.add("none");
						aListFilePathValues.add("none");
					}
				}
			}

			if (moreUrl.equals("true"))
			{
				String reqUrlVal = "";
				if(isUrlParamExist)
					reqUrlVal = request.getParameter("url");
				else if(isWsdlUrlExist)
					reqUrlVal = request.getParameter("WSDL_URL");
				StringTokenizer reqUrlTokens = new StringTokenizer(reqUrlVal,",");
				while (reqUrlTokens.hasMoreTokens())
				{
					String s3 = reqUrlTokens.nextToken();
					String s4 = s3.substring(0,s3.indexOf(":"));
					aTempUrl.add(s4);
					boolean urlExist = aUrlCredentialVal.contains(s4);
					if(urlExist)
					{
						int urlIndex = aUrlCredentialVal.indexOf(s4);
						String urlUsername = (String)aUrlCredentialVal.get(urlIndex+1);
						String urlUserpass = (String)aUrlCredentialVal.get(urlIndex+2);
						aTempUrl.add(urlUsername);
						aTempUrl.add(urlUserpass);
					}
					else
					{
						aTempUrl.add("none");
						aTempUrl.add("none");
					}
				}
				aUrlCredentialVal = aTempUrl;
			}
		}
		//credential work ends here

		isCorrectParamExist = (aListResultantTempInLowerCase.contains("-correct") && aListResultantTempInLowerCase.contains("-alarmtype") && aListResultantTempInLowerCase.contains("-userparams") && aListResultantTempInLowerCase.contains("-correctivescript"));

		String reqCorrectValue = "";
		if (testName.equals(previousTestName))
		{
			reqCorrectValue = request.getParameter("correct");
			reqCorrectValue = (reqCorrectValue!=null)?reqCorrectValue:"";
		}

		if (isCorrectParamExist)
		{
			int correctiveIdx = aListResultantTempInLowerCase.indexOf("-correct");
			String correctVal = (String)aResultant.get(correctiveIdx+1);
			if((correctVal.equals("true") && reqCorrectValue.length()==0) || reqCorrectValue.equals("true"))
			{
				isCorrectiveScriptEnabled = true;
			}
		}

		//To do the following
		//1.Configure value for virtual centers 
		//2.Change webport value,when its value is default - starts
		if (aListResultantTempInLowerCase.contains("-webport") && 
			aListResultantTempInLowerCase.contains("-ssl"))
		{
			if (aListResultantTempInLowerCase.contains("-virtual_center"))
			{
				//To configure value for virtual centers - starts
				int tempVirtual_centerIdx = aListResultantTempInLowerCase.indexOf("-virtual_center");
				String tempVirtual_centerValue = ((String)aResultant.get(tempVirtual_centerIdx+1)).trim();

				com.eg.IniFile servicesIniFile = new com.eg.IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_services.ini");
				virtualCenters = servicesIniFile.getVariables("VIRTUAL_CENTER");
				String selectedVirtualCenter = "";
				if (testName.equals(previousTestName))
				{
					selectedVirtualCenter = request.getParameter("virtual_center");
					selectedVirtualCenter = (selectedVirtualCenter != null)?selectedVirtualCenter:"";
				}
				if (!selectedVirtualCenter.equals(""))
				{
					String sslValue = "";
					String esx_UserValue = "";
					String esx_PassWord = "";
					String webPort = "";
					String selectedVirtualCenterValue = "";
					if (selectedVirtualCenter.equalsIgnoreCase("none"))
					{
						if (tempVirtual_centerValue.equalsIgnoreCase("none"))
						{
							int tempIdx = aListResultantTempInLowerCase.indexOf("-esx_user");
							esx_UserValue = ((String)aResultant.get(tempIdx+1)).trim();

							tempIdx = aListResultantTempInLowerCase.indexOf("-esx_password");
							esx_PassWord = ((String)aResultant.get(tempIdx+1)).trim();

							tempIdx = aListResultantTempInLowerCase.indexOf("-ssl");
							sslValue = ((String)aResultant.get(tempIdx+1)).trim();

							tempIdx = aListResultantTempInLowerCase.indexOf("-webport");
							webPort = ((String)aResultant.get(tempIdx+1)).trim();

							if (webPort.equalsIgnoreCase("default"))
							{
								if (sslValue.equalsIgnoreCase("true") || 
								sslValue.equalsIgnoreCase("yes"))
								{
									webPort = "443";
								}
								else
								{
									webPort = "80";
								}
							}
						}
						else
						{
							esx_UserValue = "$unconfigured";
							esx_PassWord = "$unconfigured";
							sslValue = "true";
							webPort = "443";
						}
					}
					else
					{
						selectedVirtualCenterValue = servicesIniFile.getValue("VIRTUAL_CENTER",selectedVirtualCenter);
						selectedVirtualCenterValue = (selectedVirtualCenterValue != null)?selectedVirtualCenterValue:"";
						if (!selectedVirtualCenterValue.equals(""))
						{
							StringTokenizer stVirtualCenterTokens = null;
							stVirtualCenterTokens = new StringTokenizer(selectedVirtualCenterValue,"#");
							sslValue = stVirtualCenterTokens.nextToken();
							esx_UserValue = stVirtualCenterTokens.nextToken();
							esx_PassWord = stVirtualCenterTokens.nextToken();
							stVirtualCenterTokens.nextToken();
							webPort = stVirtualCenterTokens.nextToken();
						}
					}

					int virtual_centerIdx = aListResultantTempInLowerCase.indexOf("-virtual_center");
					aResultant.remove(virtual_centerIdx+1);
					aResultant.add(virtual_centerIdx+1,selectedVirtualCenter);

					int sslIdx = aListResultantTempInLowerCase.indexOf("-ssl");
					aResultant.remove(sslIdx+1);
					aResultant.add(sslIdx+1,sslValue.toLowerCase());

					int esx_userIdx = aListResultantTempInLowerCase.indexOf("-esx_user");
					aResultant.remove(esx_userIdx+1);
					aResultant.add(esx_userIdx+1,esx_UserValue);

					int esx_PassWordIdx = aListResultantTempInLowerCase.indexOf("-esx_password");
					aResultant.remove(esx_PassWordIdx+1);
					aResultant.add(esx_PassWordIdx+1,esx_PassWord);

					int webPortIdx = aListResultantTempInLowerCase.indexOf("-webport");
					aResultant.remove(webPortIdx+1);
					aResultant.add(webPortIdx+1,webPort);
				}
				else
				{
					if (tempVirtual_centerValue.equalsIgnoreCase("none"))
					{
						int tempIdx = aListResultantTempInLowerCase.indexOf("-webport");
						String webPort = ((String)aResultant.get(tempIdx+1)).trim();
						if (webPort.equalsIgnoreCase("default"))
						{
							tempIdx = aListResultantTempInLowerCase.indexOf("-ssl");
							String sslValue = ((String)aResultant.get(tempIdx+1)).trim();
							if (sslValue.equalsIgnoreCase("true") || 
								sslValue.equalsIgnoreCase("yes"))
							{
								webPort = "443";
							}
							else
							{
								webPort = "80";
							}

							int webPortIdx = aListResultantTempInLowerCase.indexOf("-webport");
							aResultant.remove(webPortIdx+1);
							aResultant.add(webPortIdx+1,webPort);
						}
					}
				}
				//To configure value for virtual centers - ends
			}
			else
			{
				int webPortIdx = aListResultantTempInLowerCase.indexOf("-webport");
				String webPort = ((String)aResultant.get(webPortIdx+1)).trim();
				if (webPort.equalsIgnoreCase("default"))
				{
					int sslIdx = aListResultantTempInLowerCase.indexOf("-ssl");
					String tempSslValue = (String)aResultant.get(sslIdx+1);
					if (tempSslValue.equalsIgnoreCase("true") || 
						tempSslValue.equalsIgnoreCase("yes"))
					{
						webPort = "443";
					}
					else
					{
						webPort = "80";
					}
					aResultant.remove(webPortIdx+1);
					aResultant.add(webPortIdx+1,webPort);
				}
			}
		}
		//ends

		////////RHEV- Code Starts
		if (aListResultantTempInLowerCase.contains("-rhel_mgr_host"))
		{
			com.eg.IniFile servicesIniFile = new com.eg.IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_services.ini");
			rhevs = servicesIniFile.getVariables("RHEV");
			if (testName.equals(previousTestName))
			{
				String rhevManager = request.getParameter("Rhel_mgr_host");
				if (rhevManager == null)
				{
						rhevManager = "none";
				}
		
				String strRhevUser = "";
				String strRhevPassword = "";
				String strRhevPort = "";
				String strRhevDomain = "";
				if (rhevManager.equalsIgnoreCase("none"))
				{
					strRhevUser = "$unconfigured";
					strRhevPassword = "$unconfigured";
					strRhevPort = "8443";
					strRhevDomain = "internal";
				}
				else
				{
					String strTemp = servicesIniFile.getValue("RHEV",rhevManager);
					strTemp = strTemp.substring(strTemp.indexOf("#")+1);

					strRhevUser = strTemp.substring(0,strTemp.indexOf("#"));
					strTemp = strTemp.substring(strTemp.indexOf("#")+1);

					strRhevPassword = strTemp.substring(0,strTemp.indexOf("#"));
					strRhevPassword = EgCrypt.decrypt(strRhevPassword);
					strTemp = strTemp.substring(strTemp.indexOf("#")+1);
					strTemp = strTemp.substring(strTemp.indexOf("#")+1);
					strRhevPort = strTemp.substring(0,strTemp.indexOf("#"));
					strTemp = strTemp.substring(strTemp.indexOf("#")+1);
					strRhevDomain = strTemp;

				}
				int userIdx = aListResultantTempInLowerCase.indexOf("-rhel_mgr_user");
				aResultant.remove(userIdx+1);
				aResultant.add(userIdx+1,strRhevUser);

				int pwdIndex = aListResultantTempInLowerCase.indexOf("-rhel_mgr_password");
				aResultant.remove(pwdIndex+1);
				aResultant.add(pwdIndex+1,strRhevPassword);

				int portIndex = aListResultantTempInLowerCase.indexOf("-rhel_mgr_port");
				aResultant.remove(portIndex+1);
				aResultant.add(portIndex+1,strRhevPort);

				int domainIndex = aListResultantTempInLowerCase.indexOf("-rhel_mgr_domain");
				aResultant.remove(domainIndex+1);
				aResultant.add(domainIndex+1,strRhevDomain);
			}
		}
		////////RHEV - Code Ends

		//To do the following
		//1.Configure value for HMCs
		if (aListResultantTempInLowerCase.contains("-is_managed_by") && 
			aListResultantTempInLowerCase.contains("-management_server"))
		{
			com.eg.IniFile servicesIniFile = new com.eg.IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_services.ini");
			hmcs = servicesIniFile.getVariables("HMC");
			isHMC = true;

			if (testName.equals(previousTestName))
			{
				String strIsManagedByChanged = request.getParameter("isManagedByChanged");
				if (strIsManagedByChanged == null)
				{
					String hmcMgmtServer = request.getParameter("management_server");
					if (hmcMgmtServer == null)
					{
						hmcMgmtServer = "none";
					}

					String strMgmtUser = "";
					String strMgmtPassword = "";
					if (hmcMgmtServer.equalsIgnoreCase("none"))
					{
						strMgmtUser = "$unconfigured";
						strMgmtPassword = "$unconfigured";
					}
					else
					{
						String strTemp = servicesIniFile.getValue("HMC",hmcMgmtServer);
						strTemp = strTemp.substring(strTemp.indexOf("#")+1);

						strMgmtUser = strTemp.substring(0,strTemp.indexOf("#"));
						strTemp = strTemp.substring(strTemp.indexOf("#")+1);

						strMgmtPassword = strTemp.substring(0,strTemp.indexOf("#"));
						strMgmtPassword = EgCrypt.decrypt(strMgmtPassword);
					}

					int managementUserIdx = aListResultantTempInLowerCase.indexOf("-management_user");
					aResultant.remove(managementUserIdx+1);
					aResultant.add(managementUserIdx+1,strMgmtUser);

					int managementPasswordIdx = aListResultantTempInLowerCase.indexOf("-management_password");
					aResultant.remove(managementPasswordIdx+1);
					aResultant.add(managementPasswordIdx+1,strMgmtPassword);
				}
				else
				{
					String tempManagedBy = request.getParameter("is_managed_by");
					if (tempManagedBy != null && tempManagedBy.equalsIgnoreCase("hmc"))
					{
						request.setAttribute("management_server","none");
						request.setAttribute("management_user","none");
						request.setAttribute("management_password","none");
					}
					else if (tempManagedBy != null && tempManagedBy.equalsIgnoreCase("ivm"))
					{
						request.setAttribute("management_server","$unconfigured");
						request.setAttribute("management_user","$unconfigured");
						request.setAttribute("management_password","$unconfigured");
					}
				}

				resIsManagedByValue = request.getParameter("is_managed_by");
			}
			else
			{
				int isManagedByIdx = aListResultantTempInLowerCase.indexOf("-is_managed_by");
				resIsManagedByValue = (String)aResultant.get(isManagedByIdx+1);
			}
		}

		IniFile uiIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_ui.ini");
		String[] testFormatPeriod = uiIni.getVariables("TEST_FREQUENCY");
		if (!EgUtils.isNull((Object)testFormatPeriod))
		{
			for (int i=0;i<testFormatPeriod.length;i++)
			{
				String prdStr = uiIni.getValue("TEST_FREQUENCY", testFormatPeriod[i]);
				long lngVal = Long.parseLong(prdStr);
				periodMap.put(new Long(lngVal), testFormatPeriod[i]);
			}
		}

		for (int i=0;i<aResultant.size();i++)
		{
			aListResultantInLowerCase.add(aResultant.get(i).toString().toLowerCase());
		}

		ArrayList aListDesktopInfrastructures = usersInfo.getAllUserBasedCompTypes();
		if (userBasedLicense && aListDesktopInfrastructures != null && aListDesktopInfrastructures.contains(componentType))
		{
			viewAccessOnly = true;
		}
	}
%>

<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<egui:skin ui = "adminindex"/>
<script>
function showCompTypeTestList()
{
	var thisForm = document.topology;
	var componentType = "";
	if (thisForm.componentType != null && thisForm.componentType != undefined)
	{
		componentType = thisForm.componentType.value;
	}
	thisForm.testName.value = "";
	thisForm.method = "post";
	thisForm.action = "EgConfigureDefaultTestParams.jsp?cType_HelpPage="+componentType;
	thisForm.submit();
}

function changeValue()
{
	var thisForm = document.topology;
	var componentType = "";
	if (thisForm.componentType != null && thisForm.componentType != undefined)
	{
		componentType = thisForm.componentType.value;
	}
	var testName = "";
	if (thisForm.testName != null && 
		thisForm.testName != undefined && 
		thisForm.testName.value != "-1")
	{
		testName = thisForm.testName.value;
	}
	thisForm.method = "post";
	thisForm.action = "EgConfigureDefaultTestParams.jsp?cType_HelpPage="+componentType+"&tName_HelpPage="+testName;
	thisForm.submit();
}

function changeIsManagedValue()
{
	var thisForm = document.topology;
	var componentType = "";
	if (thisForm.componentType != null && thisForm.componentType != undefined)
	{
		componentType = thisForm.componentType.value;
	}
	var testName = "";
	if (thisForm.testName != null && 
		thisForm.testName != undefined && 
		thisForm.testName.value != "-1")
	{
		testName = thisForm.testName.value;
	}
	thisForm.method = "post";
	thisForm.action = "EgConfigureDefaultTestParams.jsp?cType_HelpPage="+componentType+"&tName_HelpPage="+testName+"&isManagedByChanged=true";
	thisForm.submit();
}

function createCredentials(urlFieldName,urlFieldValue)
{
	var thisForm = document.topology;
	var urls = document.getElementById(urlFieldName).value;
	var urlList = new Array();
	var duplicateValue = "false";
	if(urls.indexOf(",") > -1)
	{
		urlList = urls.split(",");
	}
	else
	{
		urlList[0] = urls;
	}

	var toMatch = /^(http|ftp|https)\:(\\\\|\/\/)([A-Za-z0-9]+(\.)*[A-Za-z0-9]*)+/;
	var urlValidated="false";
	for(var i=0;i<urlList.length;i++)
	{
		var eachUrl = urlList[i];
		var ColonIdx = eachUrl.indexOf(":");
		if (ColonIdx <= 0)
		{
			alert(_checkurl);
			thisForm.url.focus();
			urlValidated = "true";
			duplicateValue = "true";
			return;
		}
		eachUrl = eachUrl.substring(0,eachUrl.indexOf(":"));
		var urlValue = urlList[i].substring(ColonIdx+1);
		var urlCpy = urlValue;
		var stIdx = urlValue.indexOf("[");
		var edIdx = urlValue.indexOf("]");
		if(stIdx>0 && edIdx>0 && stIdx<edIdx)
		{
			var urlSt = urlValue.substring(0,stIdx);
			var urlmd = urlValue.substring(stIdx+1,edIdx);
			var urled = urlValue.substring(edIdx+1);
			urlValue = urlSt+urlmd+urled;
			//alert("rama" + " '" + urlValue + "' " );
		}
		if (urlValidated == "false")
		{
			var validUrl = "false";
			if (toMatch.test(urlValue))
			{
				validUrl = "true";
			}

			if (validUrl == "false")
			{
				duplicateValue = "true";
				urlValidated = "true"
				alert(_urlNameValue + " '" + eachUrl + "' " + _isInvalid);
				var datawin = window.open("Data.jsp?fieldName="+encodeURIComponent(urlFieldName),"DataWindow","width=625,height=300,left=0,top=132,scrollbars=0,scrollbars=no,resizable=no");
				datawin.focus();
			}
		}

		if (urlValidated == "false")
		{
			for(var j=i+1;j<urlList.length;j++)
			{
				var nextUrl =  urlList[j];
				nextUrl = nextUrl.substring(0,nextUrl.indexOf(":"));
				if(eachUrl.toUpperCase() == nextUrl.toUpperCase())
				{
					alert('<egui:intnl text="admin.test.Please enter different name"/>');
					duplicateValue = "true";
					if(urls!=null)
					{
						while(urls.indexOf("#") > -1)
						{
							urls = urls.replace("#","~egHash~");
						}
					}
					var datawin = window.open("Data.jsp?value="+encodeURIComponent(urls)+"&name="+encodeURIComponent(urlFieldName),"DataWindow","width=625,height=300,left=0,top=132,scrollbars=0,scrollbars=no,resizable=no");
					datawin.focus();
				}
			}
		}
	}

	if(duplicateValue == "false")
	{
		if(urls != urlFieldValue)
		{
			var componentType = "";
			if (thisForm.componentType != null && thisForm.componentType != undefined)
			{
				componentType = thisForm.componentType.value;
			}
			var testName = "";
			if (thisForm.testName != null && thisForm.testName != undefined)
			{
				testName = thisForm.testName.value;
			}
			thisForm.moreurl.value = "true";
			thisForm.urls.value = urls;
			thisForm.method = "post";
			thisForm.action = "EgConfigureDefaultTestParams.jsp?cType_HelpPage="+componentType+"&tName_HelpPage="+testName;
			thisForm.submit();
		}
	}
}

function changeExecutiontime(optionSelected)
{
	var thisForm = document.topology;
	var componentType = "";
	if (thisForm.componentType != null && thisForm.componentType != undefined)
	{
		componentType = thisForm.componentType.value;
	}
	var testName = "";
	if (thisForm.testName != null && thisForm.testName != undefined)
	{
		testName = thisForm.testName.value;
	}
	var testPeriod = "86400";
	if (optionSelected == 'hourly') testPeriod = "3600";
	thisForm.testPeriod.value = testPeriod;
	thisForm.method = "post";
	thisForm.action = "EgConfigureDefaultTestParams.jsp?cType_HelpPage="+componentType+"&tName_HelpPage="+testName;
	thisForm.submit();
}

function configureOSPattern(serverName,testName,stringVar)
{
	window.open("EgRuntimePattern.jsp?servername="+encodeURIComponent(serverName)+"&testname="+encodeURIComponent(testName)+"&testParam="+encodeURIComponent(stringVar),"DataWindow","width=550,height=300,left=0,top=132,scrollbars=0,scrollbars=yes");
}

var plusButtonClicked="false";
function config_popup(theURL,winName,features)
{
	var thisForm = document.topology;
	var componentType = "";
	if (thisForm.componentType != null && thisForm.componentType != undefined)
	{
		componentType = thisForm.componentType.value;
	}
	var testName = "";
	if (thisForm.testName != null && thisForm.testName != undefined)
	{
		testName = thisForm.testName.value;
	}
	theURL = theURL + "&fromPage_HelpPage=EgConfigureDefaultTestParams.jsp&cType_HelpPage="+componentType+"&tName_HelpPage="+testName;

	plusButtonClicked = "true";
	if(!window.vmgWindow)
	{
		vmgWindow=open(theURL,winName,features);
	}
	else
	{
		if(!vmgWindow.closed)
		{
			vmgWindow.close();
			vmgWindow = open(theURL,winName,features);
			vmgWindow.focus();
		}
		else
		{
			vmgWindow=open(theURL,winName,features);
		}
	}
}

var newDomainValue = "";
//for MultiUserSupportTest
var newAdminUserValue = "";
//for CtxAuthTest,TermAuthTest,WinAuthTest
var newUserValue = "";
function getUserValue(paramName)
{
	var thisForm = document.topology;
	if (paramName.toLowerCase() == "domain")
	{
		newDomainValue = thisForm.domain.value;
	}
	else if (paramName.toLowerCase() == "admin_user")
	{
		newAdminUserValue = thisForm.admin_user.value;
	}
	else if (paramName.toLowerCase() == "user")
	{
		newUserValue = thisForm.user.value;
	}
}

var changedDomainValue = "";
var changedAdminUserValue = "";
var changedUserValue = "";
function getUserChangedValue(paramName)
{
	var thisForm = document.topology;
	if (paramName.toLowerCase() == "domain")
	{
		changedDomainValue = thisForm.domain.value;
	}
	else if (paramName.toLowerCase() == "admin_user")
	{
		changedAdminUserValue = thisForm.admin_user.value;
	}
	else if (paramName.toLowerCase() == "user")
	{
		changedUserValue = thisForm.user.value;
	}
}

var newNameValue = "";
var newPatternValue = "";
var newThresholdValue = "";
function getNamePatternValue(paramName)
{
	var thisForm = document.topology;
	if (paramName.toLowerCase() == "name")
	{
		newNameValue = thisForm.name.value;
	}
	else if (paramName.toLowerCase() == "pattern")
	{
		newPatternValue = thisForm.pattern.value;
	}
	else if (paramName.toLowerCase() == "threshold_value")
	{
		newThresholdValue = thisForm.threshold_value.value;
	}
}

var changedNameValue = "";
var changedPatternValue = "";
var changedThresholdValue = "";
function getNamePatternChangedValue(paramName)
{
	var thisForm = document.topology;
	if (paramName.toLowerCase() == "name")
	{
		changedNameValue = thisForm.name.value;
	}
	else if (paramName.toLowerCase() == "pattern")
	{
		changedPatternValue = thisForm.pattern.value;
	}
	else if (paramName.toLowerCase() == "threshold_value")
	{
		changedThresholdValue = thisForm.threshold_value.value;
	}
}

function checkMultipleNamePattern(paramName,paramValue)
{
	var thisForm = document.topology;
	var multiName = "false";

	if (paramName.toLowerCase() == "name")
	{
		var nameValue = thisForm.name.value;
		if (nameValue.indexOf(",") > -1)
		{
			multiName = "true";
		}
	}
	else if (paramName.toLowerCase() == "pattern")
	{
		var patternValue = thisForm.pattern.value;
		if (patternValue.indexOf(",") > -1)
		{
			multiName = "true";
		}
	}
	else if (paramName.toLowerCase() == "threshold_value")
	{
		var thresholdValue = thisForm.threshold_value.value;
		if (thresholdValue.indexOf(",") > -1)
		{
			multiName = "true";
		}
	}

	if (multiName == "true")
	{
		var orginalPatternValue = "";
		var orginalNameValue = "";
		var orginalThresholdValue = "";
		if (plusButtonClicked == "true")
		{
			if (paramName.toLowerCase() == "pattern")
			{
				var patternValue = thisForm.pattern.value;
				if (patternValue != newPatternValue && patternValue.indexOf(",") > -1)
				{
					orginalPatternValue = newPatternValue;
				}
			}
			else if (paramName.toLowerCase() == "name")
			{
				var nameValue = thisForm.name.value;
				if (nameValue != newNameValue && nameValue.indexOf(",") > -1)
				{
					orginalNameValue = newNameValue;
				}
			}
			else if (paramName.toLowerCase() == "threshold_value")
			{
				var thresholdValue = thisForm.threshold_value.value;
				if (thresholdValue != newThresholdValue && thresholdValue.indexOf(",") > -1)
				{
					orginalThresholdValue = newThresholdValue;
				}
			}
		}
		else
		{
			if (paramName.toLowerCase() == "pattern")
			{
				var patternValue = thisForm.pattern.value;
				if (patternValue != paramValue && patternValue.indexOf(",") > -1)
				{
					orginalPatternValue = paramValue;
				}
			}
			else if (paramName.toLowerCase() == "threshold_value")
			{
				var thresholdValue = thisForm.threshold_value.value;
				if (thresholdValue != paramValue && thresholdValue.indexOf(",") > -1)
				{
					orginalthresholdValue = paramValue;
				}
			}
			else if (paramName.toLowerCase() == "name")
			{
				var nameValue = thisForm.name.value;
				if (nameValue != paramValue && nameValue.indexOf(",") > -1)
				{
					orginalNameValue = nameValue;
				}
			}
		}

		if (paramName.toLowerCase() == "name")
		{
			var nameValue = thisForm.name.value;
			if (nameValue != newNameValue && nameValue.indexOf(",") > -1)
			{
				if (thisForm.testname != null && thisForm.testname.value != undefined)
				{
					if (thisForm.testname.value == "SlowTransTest")
					{
						alert("<egui:intnl text='admin.test.Please use the encircled'/> '+' <egui:intnl text='admin.test.button adjacent to the NAME text box or the \'Click here\' link above the test parameters to configure names, patterns and threshold values'/>.");
					}
				}
				else
				{
					alert("<egui:intnl text='admin.test.Please use the encircled'/> '+' <egui:intnl text='admin.test.button adjacent to the NAME text box or the \'Click here\' link above the test parameters to configure names, patterns and threshold values'/>.");
				}
				thisForm.name.value = changedNameValue.substring(0,changedNameValue.indexOf(","));
				tempField = thisForm.name;
				setTimeout("tempField.focus()",0);
				return false;
			}
		}
		else if (paramName.toLowerCase() == "pattern")
		{
			var patternValue = thisForm.pattern.value;
			if (patternValue != newPatternValue && patternValue.indexOf(",") > -1)
			{
				if (thisForm.testname != null && thisForm.testname.value != undefined)
				{
					if (thisForm.testname.value == "SlowTransTest")
					{
						alert("<egui:intnl text='admin.test.Please use the encircled'/> '+' <egui:intnl text='admin.test.button adjacent to the NAME text box or the \'Click here\' link above the test parameters to configure names, patterns and threshold values'/>.");
					}
				}
				else
				{
					alert("<egui:intnl text='admin.test.Please use the encircled'/> '+' <egui:intnl text='admin.test.button adjacent to the NAME text box or the \'Click here\' link above the test parameters to configure names, patterns and threshold values'/>.");
				}
				thisForm.pattern.value = changedPatternValue.substring(0,changedPatternValue.indexOf(","));
				tempField = thisForm.pattern;
				setTimeout("tempField.focus()",0);
				return false;
			}
		}
		else if (paramName.toLowerCase() == "threshold_value")
		{
			var thresholdValue = thisForm.threshold_value.value;
			if (thresholdValue != newThresholdValue && thresholdValue.indexOf(",") > -1)
			{
				if (thisForm.testname != null && thisForm.testname.value != undefined)
				{
					if (thisForm.testname.value == "SlowTransTest")
					{
						alert("<egui:intnl text='admin.test.Please use the encircled'/> '+' <egui:intnl text='admin.test.button adjacent to the NAME text box or the \'Click here\' link above the test parameters to configure names, patterns and threshold values'/>.");
					}
				}
				else
				{
					alert("<egui:intnl text='admin.test.Please use the encircled'/> '+' <egui:intnl text='admin.test.button adjacent to the NAME text box or the \'Click here\' link above the test parameters to configure names, patterns and threshold values'/>.");
				}
				thisForm.threshold_value.value = changedThresholdValue.substring(0,changedThresholdValue.indexOf(","));
				tempField = thisForm.threshold_value;
				setTimeout("tempField.focus()",0);
				return false;
			}
		}
	}
}

function checkMultipleUser(paramName,paramValue)
{
	var thisForm = document.topology;
	var multiUser = "false";
	if (paramName.toLowerCase() == "domain")
	{
		var domainValue = thisForm.domain.value;
		if (domainValue.indexOf(",") > -1)
		{
			multiUser = "true";
		}
	}
	else if (paramName.toLowerCase() == "admin_user")
	{
		var adminUserValue = thisForm.admin_user.value;
		if (adminUserValue.indexOf(",") > -1)
		{
			multiUser = "true";
		}
	}
	else if (paramName.toLowerCase() == "user")
	{
		var userValue = thisForm.user.value;
		if (userValue.indexOf(",") > -1)
		{
			multiUser = "true";
		}
	}

	if (multiUser == "true")
	{
		var orginalDomainValue = "";
		var orginalUserValue = "";
		if (plusButtonClicked == "true")
		{
			if (paramName.toLowerCase() == "domain")
			{
				var domainValue = thisForm.domain.value;
				if (domainValue != newDomainValue && domainValue.indexOf(",") > -1)
				{
					orginalDomainValue = newDomainValue;
				}
			}
			else if (paramName.toLowerCase() == "admin_user")
			{
				var adminUserValue = thisForm.admin_user.value;
				if (adminUserValue != newAdminUserValue && adminUserValue.indexOf(",") > -1)
				{
					orginalUserValue = newAdminUserValue;
				}
			}
			else if (paramName.toLowerCase() == "user")
			{
				var userValue = thisForm.user.value;
				if (userValue != newUserValue && userValue.indexOf(",") > -1)
				{
					orginalUserValue = newUserValue;
				}
			}
		}
		else
		{
			if (paramName.toLowerCase() == "domain")
			{
				var domainValue = thisForm.domain.value;
				if (domainValue != paramValue && domainValue.indexOf(",") > -1)
				{
					orginalDomainValue = paramValue;
				}
			}
			else if (paramName.toLowerCase() == "admin_user")
			{
				var adminUserValue = thisForm.admin_user.value;
				if (adminUserValue != paramValue && adminUserValue.indexOf(",") > -1)
				{
					orginalUserValue = paramValue;
				}
			}
			else if (paramName.toLowerCase() == "user")
			{
				var userValue = thisForm.user.value;
				if (userValue != paramValue && userValue.indexOf(",") > -1)
				{
					orginalUserValue = paramValue;
				}
			}
		}

		if (paramName.toLowerCase() == "domain")
		{
			var domainValue = thisForm.domain.value;
			if (domainValue != newDomainValue && domainValue.indexOf(",") > -1)
			{
				if (thisForm.testname != null && thisForm.testname.value != undefined)
				{
					if (thisForm.testname.value == "CtxAuthTest" || 
						thisForm.testname.value == "WinAuthTest" || 
						thisForm.testname.value == "TermAuthTest")
					{
						alert("<egui:intnl text='admin.test.Please use the encircled'/> '+' <egui:intnl text='admin.test.button adjacent to the USER text box or the \'Click here\' link above the test parameters to configure multiple domains and users'/>.");
					}
					else
					{
						alert("<egui:intnl text='admin.test.Please use the encircled'/> '+' <egui:intnl text='admin.test.button adjacent to the ADMIN USER text box or the \'Click here\' link above the test parameters to configure multiple domains and admin users'/>.");
					}
				}
				else
				{
					alert("<egui:intnl text='admin.test.Please use the encircled'/> '+' <egui:intnl text='admin.test.button adjacent to the USER text box or the \'Click here\' link above the test parameters to configure multiple domains and users'/>.");
				}
				thisForm.domain.value = changedDomainValue.substring(0,changedDomainValue.indexOf(","));
				tempField = thisForm.domain;
				setTimeout("tempField.focus()",0);
				return false;
			}
		}
		else if (paramName.toLowerCase() == "admin_user")
		{
			var adminUserValue = thisForm.admin_user.value;
			if (adminUserValue != newAdminUserValue && adminUserValue.indexOf(",") > -1)
			{
				alert("<egui:intnl text='admin.test.Please use the encircled'/> '+' <egui:intnl text='admin.test.button adjacent to the ADMIN USER text box or the \'Click here\' link above the test parameters to configure multiple domains and admin users'/>.");
				thisForm.admin_user.value = changedAdminUserValue.substring(0,changedAdminUserValue.indexOf(","));
				tempField = thisForm.admin_user;
				setTimeout("tempField.focus()",0);
				return false;
			}
		}
		else if (paramName.toLowerCase() == "user")
		{
			var userValue = thisForm.user.value;
			if (userValue != newUserValue && userValue.indexOf(",") > -1)
			{
				alert("<egui:intnl text='admin.test.Please use the encircled'/> '+' <egui:intnl text='admin.test.button adjacent to the USER text box or the \'Click here\' link above the test parameters to configure multiple domains and users'/>.");
				thisForm.user.value = changedUserValue.substring(0,changedUserValue.indexOf(","));
				tempField = thisForm.user;
				setTimeout("tempField.focus()",0);
				return false;
			}
		}
	}
}

function checkHashTildeHash()
{
	var thisForm = document.topology;
	var multiUser = "false";

	if (thisForm.admin_user != null && thisForm.admin_user.value != undefined)
	{
		var adminUserValue = thisForm.admin_user.value;
		if (adminUserValue.indexOf(",") > -1)
		{
			multiUser = "true";
		}

		if (multiUser == "false")
		{
			var admin_passwordValue = thisForm.admin_password.value;

			if (!checkspecialnomess(admin_passwordValue,"|"))
			{
				alert("<egui:intnl text='admin.test.Password data should not contain pipe' />");
				tempField = thisForm.admin_password;
				setTimeout("tempField.focus()",1);
				return false;
			}

			for(var k=0;k < admin_passwordValue.length;k++)
			{
				if(admin_passwordValue.charAt(k) == '#' && 
					admin_passwordValue.charAt(k + 1) == '~' && 
					admin_passwordValue.charAt(k + 2) == '#')
				{
					alert(_checkHashTildeHash);
					tempField = thisForm.admin_password;
					setTimeout("tempField.focus()",1);
					return false;
				}
			}
		}
	}
	else if (thisForm.user != null && thisForm.user.value != undefined)
	{
		var userValue = thisForm.user.value;
		if (userValue.indexOf(",") > -1)
		{
			multiUser = "true";
		}

		if (multiUser == "false")
		{
			var passwordValue = thisForm.password.value;

			if (!checkspecialnomess(passwordValue,",|"))
			{
				alert("<egui:intnl text='admin.test.Password data should not contain pipe and comma' />");
				tempField = thisForm.password;
				setTimeout("tempField.focus()",1);
				return false;
			}

			for(var k=0;k < passwordValue.length;k++)
			{
				if (passwordValue.charAt(k) == '#' && 
					passwordValue.charAt(k + 1) == '~' && 
					passwordValue.charAt(k + 2) == '#')
				{
					alert(_checkHashTildeHash);
					tempField = thisForm.password;
					setTimeout("tempField.focus()",1);
					return false;
				}
			}
		}
	}
}

function changeVirtualCenterValue(optionSelected)
{
	var thisForm = document.topology;
	var componentType = "";
	if (thisForm.componentType != null && thisForm.componentType != undefined)
	{
		componentType = thisForm.componentType.value;
	}
	var testName = "";
	if (thisForm.testName != null && thisForm.testName != undefined)
	{
		testName = thisForm.testName.value;
	}

	if (optionSelected == 'Other')
	{
		openVCDetails(this.event,"EgVcConfig.jsp?fromPage_HelpPage=EgConfigureDefaultTestParams.jsp&cType_HelpPage="+componentType+"&tName_HelpPage="+testName);
	}
	else
	{
		thisForm.virtual_center.value = optionSelected;
		thisForm.method = "post";
		thisForm.action = "EgConfigureDefaultTestParams.jsp?cType_HelpPage="+componentType+"&tName_HelpPage="+testName;
		thisForm.submit();
	}
}

function changeRHEVMgrValue(optionSelected)
{
	var thisForm = document.topology;
	var componentType = "";
	if (thisForm.componentType != null && thisForm.componentType != undefined)
	{
		componentType = thisForm.componentType.value;
	}
	var testName = "";
	if (thisForm.testName != null && thisForm.testName != undefined)
	{
		testName = thisForm.testName.value;
	}

	if (optionSelected == 'Other')
	{
		openVCDetails(this.event,"EgRhevConfig.jsp?fromPage_HelpPage=EgConfigureDefaultTestParams.jsp&cType_HelpPage="+componentType+"&tName_HelpPage="+testName);
	}
	else
	{
		thisForm.Rhel_mgr_host.value = optionSelected;
		thisForm.method = "post";
		thisForm.action = "EgConfigureDefaultTestParams.jsp?cType_HelpPage="+componentType+"&tName_HelpPage="+testName;
		thisForm.submit();
	}
}

function InsideViewChange(value)
{
	var thisForm = document.topology;

	if (value == "tcp" || value == "wmi")
	{
		if (thisForm.domain != null && 
			thisForm.domain != undefined && 
			thisForm.domain.value == "$unconfigured")
		{
			thisForm.domain.value = "none";
		}

		if (thisForm.admin_user != null && 
			thisForm.admin_user != undefined && 
			thisForm.admin_user.value == "$unconfigured")
		{
			thisForm.admin_user.value = "none";
		}

		if (thisForm.admin_password != null && 
			thisForm.admin_password != undefined && 
			thisForm.admin_password.value == "$unconfigured")
		{
			thisForm.admin_password.value = "none";
		}

		if (thisForm.admin_passwordconfirmpassword != null && 
			thisForm.admin_passwordconfirmpassword != undefined && 
			thisForm.admin_passwordconfirmpassword.value == "$unconfigured")
		{
			thisForm.admin_passwordconfirmpassword.value = "none";
		}
	}
	else
	{
		if (thisForm.domain != null && 
			thisForm.domain != undefined && 
			thisForm.domain.value == "none")
		{
			thisForm.domain.value = "$unconfigured";
		}

		if (thisForm.admin_user != null && 
			thisForm.admin_user != undefined && 
			thisForm.admin_user.value == "none")
		{
			thisForm.admin_user.value = "$unconfigured";
		}

		if (thisForm.admin_password != null && 
			thisForm.admin_password != undefined && 
			thisForm.admin_password.value == "none")
		{
			thisForm.admin_password.value = "$unconfigured";
		}

		if (thisForm.admin_passwordconfirmpassword != null && 
			thisForm.admin_passwordconfirmpassword != undefined && 
			thisForm.admin_passwordconfirmpassword.value == "none")
		{
			thisForm.admin_passwordconfirmpassword.value = "$unconfigured";
		}
	}
}

function changeHMCValue(optionSelected)
{
	var thisForm = document.topology;
	var componentType = "";
	if (thisForm.componentType != null && thisForm.componentType != undefined)
	{
		componentType = thisForm.componentType.value;
	}
	var testName = "";
	if (thisForm.testName != null && thisForm.testName != undefined)
	{
		testName = thisForm.testName.value;
	}

	if (optionSelected == 'Other')
	{
		openVCDetails(this.event,"EgHMCConfig.jsp?fromPage_HelpPage=EgConfigureDefaultTestParams.jsp&cType_HelpPage="+componentType+"&tName_HelpPage="+testName);
	}
	else
	{
		thisForm.management_server.value = optionSelected;
		thisForm.method = "post";
		thisForm.action = "EgConfigureDefaultTestParams.jsp?cType_HelpPage="+componentType+"&tName_HelpPage="+testName;
		thisForm.submit();
	}
}

function checkURLAndCredentials(paramValue)
{
	var thisForm = document.topology;
	var v_url='';
	if(thisForm.url!=null && thisForm.url!=undefined)
	{
		v_url = thisForm.url.value;
	}
	else if(thisForm.WSDL_URL!=null && thisForm.WSDL_URL!=undefined)
	{
		v_url = thisForm.WSDL_URL.value;
	}
	var v_cred = thisForm.credentials.value;
	var arrURL = v_url.split(",");
	var arrCred = v_cred.split(",");
	if (arrURL.length != arrCred.length && plusButtonClicked == "false")
	{
		alert("<egui:intnl text='admin.test.Please use the encircled'/> '+' <egui:intnl text='admin.test.button adjacent to the URL text box or the \'Click here\' link above the test parameters to configure URL and credentials'/>.");
		if(thisForm.url!=null && thisForm.url!=undefined)
		{
			thisForm.url.value = paramValue;
			tempField = thisForm.url;
		}
		else if(thisForm.WSDL_URL!=null && thisForm.WSDL_URL!=undefined)
		{
			thisForm.WSDL_URL.value = paramValue;
			tempField = thisForm.WSDL_URL;
		}
		setTimeout("tempField.focus()",0);
		return false;
	}
}
</script>
<script language="JavaScript" src="eg_scripts/validate.js"></script>
<script language="JavaScript" src="eg_scripts/testvalidate.js"></script>
<script language="javascript" src="/final/admin/eg_scripts/eg_configcomponent.js"></script>
<script language="javascript" src="/final/admin/eg_scripts/common.js"></script>
<script language="javascript" src="/final/admin/eg_scripts/ajaxutils.js"></script>
<script language="JavaScript1.2" src="../scripts/<%=script_src%>"></script>
</head>
<body style="overflow:auto;" id="space6" scroll="auto">
<form name="topology" method="post">
<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0">
	<jsp:include page="listSearch.jsp?title=AGENTS - TESTS - DEFAULT CONFIGURATION&subtitle=false" />
<%
	/* For back - start */
	EgStackForBackButton stackBackPages = (EgStackForBackButton)session.getAttribute("backList");
	String queryStr = "testType="+testType+"&componentType="+componentType+"&previousComponentType="+previousComponentType+"&testName="+testName+"&previousTestName="+testName;
	stackBackPages.updateQueryStrForURL("/final/admin/EgConfigureDefaultTestParams.jsp",queryStr);
	/* For back - end */

	//tell whether _cf test enabled or not
	boolean isConfigSupported = EgInstallInfo.isConfigSupported;

	//ensure whether the user is configuration management enabled
	if (_user != null && isConfigSupported)
	{
		EgUserRole userRole = _user.getUserRole();
		isConfigSupported = userRole.hasAnyConfigRole(EgUserPermission.CONFIG);
	}

	if (isConfigSupported)
	{
%>
	<tr>
		<td>
			<table border="0" width="90%" align="center">
				<tr>
					<td nowrap height="24" align="right">
<%
		if (componentType!=null && !componentType.equals("") && !componentType.equals("-1"))
		{
%>
						<a href="EgEnableAndDisableTests.jsp?componentType=<%=componentType%>&testType=<%=testType%>&showBackButton=true" class="eg_monlink">
						<b><egui:intnl text="admin.common.Click here"/></b>&nbsp;<img src="/final/admin/eg_images/icon_click.gif" border="0"></a>
<%
			if (testType.equalsIgnoreCase("PerformanceTest"))
			{
%>
						<egui:intnl text="admin.test.to enable and disable performance tests for"/>&nbsp;<%=_mapping.getComponentTypeDescription(componentType)%>
<%
			}
			else
			{
%>
						<egui:intnl text="admin.test.to enable and disable configuration tests for"/>&nbsp;<%=_mapping.getComponentTypeDescription(componentType)%>
<%
			}
		}
		else
		{
%>
						<a href="EgEnableAndDisableTests.jsp?showBackButton=true" class="eg_monlink">
						<b><egui:intnl text="admin.common.Click here"/></b>&nbsp;<img src="/final/admin/eg_images/icon_click.gif" border="0">
						</a>
<%
			if (testType.equalsIgnoreCase("PerformanceTest"))
			{
%>
						<egui:intnl text="admin.test.to enable and disable performance tests"/>
<%
			}
			else
			{
%>
						<egui:intnl text="admin.test.to enable and disable configuration tests"/>
<%
			}
		}
%>
					</td>
				</tr>
			</table>
		</td>
	</tr>

	<tr>
		<td width="100%" id="eg_whitebg" align="center" valign="middle">
			<table align="center" width="90%" cellspacing="0" cellpadding="0" border="0" class="eg_subcontentbg">
				<tr>
					<td height="6" id="inner_top_left" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
					<td height="6" id="eg_subcontentbg" colspan="3"><img src="/final/admin/eg_images/spacer.gif" height="6"></td>
					<td height="6" id="inner_top_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
				</tr>
				<tr>
					<td width="7" align="left"class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
					<td align="center" id="eg_subcontentbg" nowrap colspan="3">
						<table border="0" cellspacing="0" cellpadding="0" width="100%">
							<tr>
								<td width="15%" align="right"><egui:intnl text="admin.server.Component type"/>&nbsp;:&nbsp;</td>
								<td id="eg_subcontentbg" align="left" class="paddingright" width="35%">&nbsp;&nbsp;<select name="componentType" id="componentType" style="width:230px" onchange="javascript:showCompTypeTestList()">
<%
		if (listComponentTypes.size() > 0)
		{
%>
			<option value="-1"><egui:intnl text="admin.common.Choose a component type"/></option>
<%
		}
		else
		{
%>
			<option value="-1"><egui:intnl text="admin.common.Not Applicable"/></option>
<%
		}

		//EgName class is used to hold name and its localised name.
		for (int j=0; j<listComponentTypes.size(); j++)
		{
			EgName nameObj = (EgName)listComponentTypes.get(j);
			String actualname = nameObj.getActualName();
			String localname = nameObj.getLocalName();
			if (actualname.equals(componentType))
			{
				selectedCompType = localname;
%>
				<option value="<%=actualname%>" selected><%=localname%></option>
<%
			}
			else
			{
%>
				<option value="<%=actualname%>"><%=localname%></option>
<%
			}
		}
%>
								</select>
								</td>
								<td width="20%" align="right"><egui:intnl text="admin.server.Test type"/>&nbsp;:&nbsp;</td>
								<td id="eg_subcontentbg" align="left" class="paddingright" width="30%">&nbsp;&nbsp;<select name="testType" style="width:230px" onchange="javascript:showCompTypeTestList()">
								<option value="PerformanceTest" <%=pfSelected%>><egui:intnl text="admin.server.Performance"/></option>
								<option value="ConfigurationTest" <%=cfSelected%>><egui:intnl text="admin.server.Configuration"/></option>
								</select></td>
							</tr>
						</table>
					</td>
					<td width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
				</tr>
				<tr>
					<td>&nbsp;</td>
				</tr>
				<tr>
					<td width="7" align="left" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
					<td align="center" id="eg_subcontentbg" nowrap colspan="3">
						<table border="0" cellspacing="0" cellpadding="0" width="100%">
							<tr>
								<td width="15%" align="right">&nbsp;</td>
								<td id="eg_subcontentbg" align="left" class="paddingright" width="35%">&nbsp;</td>
								<td width="20%" align="right"><egui:intnl text="admin.server.Test name"/>&nbsp;:&nbsp;</td>
								<td id="eg_subcontentbg" align="left" class="paddingright" width="30%">&nbsp;&nbsp;<select name="testName" style="width:230px" onchange="javascript:changeValue()">
<%
		if (aListEnabledTestForCompType.size() > 0)
		{
%>
			<option value="-1"><egui:intnl text="admin.common.Choose a test name"/></option>
<%
		}
		else
		{
%>
			<option value="-1"><egui:intnl text="admin.common.Not Applicable"/></option>
<%
		}

		for (int i=0; i<aListEnabledTestForCompType.size(); i++)
		{
			EgName nameObj = (EgName)aListEnabledTestForCompType.get(i);
			String strTestName = nameObj.getActualName();
			String strTestDisplayValue = nameObj.getLocalName();
			if (testName != null && strTestName.equals(testName))
			{
%>
				<option value="<%=strTestName%>" selected><%=strTestDisplayValue%></option>
<%
			}
			else
			{
%>
				<option value="<%=strTestName%>"><%=strTestDisplayValue%></option>
<%
			}
		}
%>
								</select></td>
							</tr>
						</table>
					</td>
					<td width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
				</tr>
				<tr>
					<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
					<td id="eg_subcontentbg" valign="top" colspan="3"><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
					<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
				</tr>
			</table>
		</td>
	</tr>
<%
	}
	else
	{
%>
	<tr>
		<td width="100%" id="eg_whitebg" align="center" valign="middle">
			<table align="center" width="90%" cellspacing="0" cellpadding="0" border="0" class="eg_subcontentbg">
				<tr>
					<td height="6" id="inner_top_left" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
					<td height="6" id="eg_subcontentbg" colspan="3"><img src="/final/admin/eg_images/spacer.gif" height="6"></td>
					<td height="6" id="inner_top_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
				</tr>
				<tr>
					<td width="7" align="left"class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
					<td align="center" id="eg_subcontentbg" nowrap colspan="3">
						<table border="0" cellspacing="0" cellpadding="0" width="100%">
							<tr>
								<td width="15%" align="right"><egui:intnl text="admin.server.Component type"/> : </td>
								<td id="eg_subcontentbg" align="left" class="paddingright" width="35%">&nbsp;&nbsp;<select name="componentType" id="componentType" style="width:230px" onchange="javascript:changeValue()">
<%
		if (listComponentTypes.size() > 0)
		{
%>
			<option value="-1"><egui:intnl text="admin.common.Choose one"/></option>
<%
		}
		else
		{
%>
			<option value="-1"><egui:intnl text="admin.common.Not Applicable"/></option>
<%
		}

		//EgName class is used to hold name and its localised name.
		for (int j=0; j<listComponentTypes.size(); j++)
		{
			EgName nameObj = (EgName)listComponentTypes.get(j);
			String actualname = nameObj.getActualName();
			String localname = nameObj.getLocalName();
			if (actualname.equals(componentType))
			{
				selectedCompType = localname;
%>
				<option value="<%=actualname%>" selected><%=localname%></option>
<%
			}
			else
			{
%>
				<option value="<%=actualname%>"><%=localname%></option>
<%
			}
		}
%>
								</select>
								</td>
								<td width="20%" align="right"><egui:intnl text="admin.server.Test name"/> : </td>
								<td id="eg_subcontentbg" align="left" class="paddingright" width="30%">&nbsp;&nbsp;<select name="testName" style="width:230px" onchange="javascript:changeValue()">
<%
		if (aListEnabledTestForCompType.size() > 0)
		{
%>
			<option value="-1"><egui:intnl text="admin.common.Choose one"/></option>
<%
		}
		else
		{
%>
			<option value="-1"><egui:intnl text="admin.common.Not Applicable"/></option>
<%
		}

		for (int i=0; i<aListEnabledTestForCompType.size(); i++)
		{
			EgName nameObj = (EgName)aListEnabledTestForCompType.get(i);
			String strTestName = nameObj.getActualName();
			String strTestDisplayValue = nameObj.getLocalName();
			if (testName != null && strTestName.equals(testName))
			{
%>
				<option value="<%=strTestName%>" selected><%=strTestDisplayValue%></option>
<%
			}
			else
			{
%>
				<option value="<%=strTestName%>"><%=strTestDisplayValue%></option>
<%
			}
		}
%>
								</select></td>
							</tr>
						</table>
					</td>
					<td width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
				</tr>
				<tr>
					<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
					<td id="eg_subcontentbg" valign="top" colspan="3"><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
					<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
				</tr>
			</table>
		</td>
	</tr>
<%
	}
%>
	<tr>
		<td>&nbsp;</td>
	</tr>
<%
	if (!componentType.equals("") && !componentType.equals("-1") && 
		!testName.equals("") && !testName.equals("-1") && 
		!testType.equals(""))
	{
		boolean isPortRelevantForTest = egSpecs.isPortRelevantForTest(testName);

		if (listMultipleUserSupportTest != null && 
			listMultipleUserSupportTest.contains(testName))
		{
			multiUserMode = true;
%>
	<tr>
		<td>&nbsp;</td>
	</tr>

	<tr>
		<td width="100%" id="eg_whitebg" align="center" valign="middle">
			<table align="center" width="90%" cellspacing="0" cellpadding="0" border="0" >
				<tr>
					<td nowrap height="24" align="left" valign="top" ><egui:intnl text="admin.test.To configure users for this test" />&nbsp; <a href = "javascript:void(0)" onClick="config_popup('./VmgUsers.jsp?server=<%=componentType%>&test=<%=testName%>&port=<%=isPortRelevantForTest%>&compname=','','scrollbars=yes,width=900,height=380,top=150,left=50')" class="eg_monlink"><b><egui:intnl text="admin.common.Click here"/></b>&nbsp;<img src="/final/admin/eg_images/icon_click.gif" border="0"></a></td>
				</tr>
			</table>
		</td>
	</tr>
<%
		}
		else if (testName.equalsIgnoreCase("SlowTransTest"))
		{
			multiNamePatternMode = true;
%>
	<tr>
		<td>&nbsp;</td>
	</tr>

	<tr>
		<td width="100%" id="eg_whitebg" align="center" valign="middle">
			<table align="center" width="90%" cellspacing="0" cellpadding="0" border="0" >
				<tr>
					<td nowrap height="24" align="left"><egui:intnl text="admin.test.To configure url patterns for this test" />&nbsp;<a href = "javascript:void(0)" onClick="config_popup('./EgConfigureNamePattern.jsp?server=<%=componentType%>&test=<%=testName%>&port=<%=isPortRelevantForTest%>&compname=','','scrollbars=yes,width=900,height=380,top=150,left=50')" class="eg_monlink"><b><egui:intnl text="admin.common.Click here"/></b>&nbsp;<img src="/final/admin/eg_images/icon_click.gif" border="0"></a></td>
				</tr>
			</table>
		</td>
	</tr>
<%
		}
		else if (testName.equalsIgnoreCase("CtxAuthTest") || 
				testName.equalsIgnoreCase("WinAuthTest") || 
				testName.equalsIgnoreCase("TermAuthTest"))
		{
			multiUserMode = true;
%>
	<tr>
		<td>&nbsp;</td>
	</tr>

	<tr>
		<td width="100%" id="eg_whitebg" align="center" valign="middle">
			<table align="center" width="90%" cellspacing="0" cellpadding="0" border="0" >
				<tr>
					<td nowrap height="24" align="left"><egui:intnl text="admin.test.To configure users for this test" />&nbsp;<a href = "javascript:void(0)" onClick="config_popup('./EgConfigureMultipleUsers.jsp?server=<%=componentType%>&test=<%=testName%>&port=<%=isPortRelevantForTest%>&compname=','','scrollbars=yes,width=900,height=380,top=150,left=50')" class="eg_monlink"><b><egui:intnl text="admin.common.Click here"/></b>&nbsp;<img src="/final/admin/eg_images/icon_click.gif" border="0"></a></td>
				</tr>
			</table>
		</td>
	</tr>
<%
		}
		else if (isPolicyParamExists)
		{
			int logTypeIdx = aListResultantInLowerCase.indexOf("-logtype");
			String logTypeVal = (String)aResultant.get(logTypeIdx+1);
			int policyFilterIdx = aListResultantInLowerCase.indexOf("-policyfilter");
			String policyFilterVal = (String)aResultant.get(policyFilterIdx+1);

			if ((policyFilterVal.equalsIgnoreCase("true") && tPolicyFilter.length() == 0) || 
				tPolicyFilter.equalsIgnoreCase("true"))
			{
%>
	<tr>
		<td>&nbsp;</td>
	</tr>

	<tr>
		<td width="100%" id="eg_whitebg" align="center" valign="middle">
			<table align="center" width="90%" cellspacing="0" cellpadding="0" border="0" >
				<tr>
					<td nowrap height="24" align="left"><egui:intnl text="admin.test.To add/modify Policy"/>&nbsp;<a href="ViewPolicy.jsp?server=<%=componentType%>&test=<%=testName%>&port=<%=isPortRelevantForTest%>&showAll=no&logtype=<%=logTypeVal%>&requestFrom=EgConfigureDefaultTestParams.jsp&testType=<%=testType%>" class="eg_monlink"><b><egui:intnl text="admin.common.Click here"/></b>&nbsp;<img src="/final/admin/eg_images/icon_click.gif" border="0"></a></td>
				</tr>
			</table>
		</td>
	</tr>
<%
			}
		}
		else if (isUrlParamExist && isCredentialParamExist)
		{
%>
	<tr>
		<td>&nbsp;</td>
	</tr>

	<tr>
		<td width="100%" id="eg_whitebg" align="center" valign="middle">
			<table align="center" width="90%" cellspacing="0" cellpadding="0" border="0" >
				<tr>
					<td nowrap height="24" align="left"><egui:intnl text="admin.test.To view/configure URL and credentials for this test"/>&nbsp;<a href = "javascript:void(0)" onClick="config_popup('./EgConfigureUrlAndCredentials.jsp?server=<%=componentType%>&test=<%=testName%>&port=<%=isPortRelevantForTest%>&isPrivateKeyParamExist=<%=isPrivateKeyParamExist%>','','scrollbars=yes,width=900,height=500,top=150,left=50')" class="eg_monlink"><b><egui:intnl text="admin.common.Click here"/></b>&nbsp;<img src="/final/admin/eg_images/icon_click.gif" border="0"> </a></td>
				</tr>
			</table>
		</td>
	</tr>
<%
		}
%>
	<tr>
		<td align="center" valign="top">
			<table align="center" cellspacing="0" cellpadding="0" width="90%" border="0" height="100%" class="eg_subcontentbg"><col width="7px"><col width="350"><col width="25"><col width="60%"><col width="7px">
				<tr>
					<td align="center" colspan="5">
						<table align="center" width="100%" cellspacing="0" cellpadding="0" border="0" height="22">
							<tr>
								<td id="subhead_left" width="7"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7"></td>
								<td class="eg_darktextbold" width="100%" align="center" id="eg_subheadbg" style="border-left-width:0px;border-right-width:0px"><egui:intnl text="admin.test.Parameters to be configured for"/>&nbsp;<egui:intnl test="<%=testName%>"/>
<%
		if (isPortRelevantForTest)
		{
%>
			&nbsp;<egui:intnl text="admin.test.of"/>&nbsp;<egui:intnl type="<%=componentType%>"/>
<%
		}
%>
								</td>
								<td id="subhead_right" width="7"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7"></td>
							</tr>
						</table>
					</td>
				</tr>

				<tr>
					<th id="formtop_border">&nbsp;</th>
					<td id="formtop_border"><egui:intnl text="admin.test.TEST PERIOD"/></td>
					<td id="formtop_border">:</td>
					<td id="formtop_border">
						<select name="testPeriod" class="list">
<%
		//testPeriod
		String testPeriodVal = "";
		if (testName.equals(previousTestName))
		{
			testPeriodVal = request.getParameter("testPeriod");
			testPeriodVal = (testPeriodVal != null)?testPeriodVal:"";
		}

		Iterator itr = periodMap.keySet().iterator();
		boolean b = true;
		for (int i=0; i<periodMap.size(); i++)
		{
			Long lngperiod = (Long)itr.next();
			String periodVal = lngperiod.toString();
			String periodStr = (String)periodMap.get(lngperiod);
			if (periodVal.equals(testPeriodVal))
			{
				out.println("<option value = '" + periodVal + "' selected>" + periodStr + "</option>");
				b = false;
			}
			else if (periodVal.equals(testPeriod) && b)
			{
				out.println("<option value = '" + periodVal + "' selected>" + periodStr + "</option>");
			}
			else
			{
				out.println("<option value = '" + periodVal + "'>" + periodStr + "</option>");
			}
		}
%>
						</select>
					</td>
					<td id="formtop_border">&nbsp;</td>
				</tr>
<%
		String tempSnmpVersion = "";
		boolean hasMultipleUsers = false;
		boolean hasMultipleNames = false;
		boolean isCompTypeOracleClusterService = componentType.equals("Oracle_cluster_service");
		String testInfoDelimiter = egSpecs.getTestInfoDelimiter(testName);
		if (testInfoDelimiter.trim().length() == 0)
		{
			testInfoDelimiter = "#";
		}
		strDelimiter = testInfoDelimiter;
		IniFile testsIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_tests.ini");
		arrDelimiterMasks = testsIni.getVariables("TEST_INFO_DELIMITER_MASK");
		List delimiterMasksList = new ArrayList();
		if (arrDelimiterMasks != null &&  arrDelimiterMasks.length > 0)
		{
			delimiterMasksList = new ArrayList(Arrays.asList(arrDelimiterMasks));
		}
		if (strDelimiterMask.trim().length() == 0)
		{
			strDelimiterMask = "0egHash1";
		}
		for (int i=0;i<aResultant.size();i=i+3)
		{
			String paramName = (String)aResultant.get(i);
			aListParamNamesValues.add(paramName);
			paramName = paramName.substring(1).trim();
			if(delimiterMasksList.contains(testName+":"+paramName+":"+testInfoDelimiter))
			{
				strDelimiterMask = testsIni.getValue("TEST_INFO_DELIMITER_MASK",testName+":"+paramName+":"+testInfoDelimiter);
			}
			String paramValue = (String)aResultant.get(i+1);
			String displayControl = (String)aResultant.get(i+2);
			displayControl = displayControl.trim();
			//if (aListParamsWithDoubleQuotes != null && 
			//	!aListParamsWithDoubleQuotes.contains(paramName.toLowerCase()) && !displayControl.equalsIgnoreCase("password"))
			if (!displayControl.equalsIgnoreCase("password"))
			{
				paramValue = paramValue.trim();

				if (paramValue.startsWith("\"") && paramValue.endsWith("\""))
				{
					paramValue = paramValue.substring(1,paramValue.length()-1);
				}
			}
			aListParamNamesValues.add(paramValue);

			if(componentType.equals("Client_desktop") && (testName.equals("ClientServiceTest") || testName.equals("ClientTcpTest")))
			{
				if(paramName.equalsIgnoreCase("adapter_device_selection") || paramName.equalsIgnoreCase("device_name") || paramName.equalsIgnoreCase("device_id"))
				{
					continue;
				}
			}

			int elementIdx = Arrays.binarySearch(paramToContinue,paramName,String.CASE_INSENSITIVE_ORDER);
			if (elementIdx > -1) continue;

			//parameter value comes only for component type called "web" for the parameter "site"
			if (paramValue.equalsIgnoreCase("noteditable")) continue;

			//hide the parameter info
			if (!isCompTypeOracleClusterService && paramName.equalsIgnoreCase("info"))
			{
				continue;
			}

			if (isCorrectParamExist && !isCorrectiveScriptEnabled)
			{
				if (paramName.equalsIgnoreCase("alarmtype") || 
					paramName.equalsIgnoreCase("userparams") || 
					paramName.equalsIgnoreCase("correctivescript"))
				{
					continue;
				}
			}

			if (isSnmp)
			{
				//hiding some parameters to the ui for snmpV1 and snmpV2 only.
				int snmpParamIdx = Arrays.binarySearch(snmpV1V2ParamToContinue,paramName,String.CASE_INSENSITIVE_ORDER);
				if (snmpVer.length() == 0)
				{
					if (isSnmpV1V2)
					{
						if (snmpParamIdx > -1) continue;
					}
				}
				else if(snmpVer.equals("v1") || snmpVer.equals("v2"))
				{
					if (snmpParamIdx > -1) continue;
				}

				//for snmpV3
				if (paramName.equalsIgnoreCase("snmpversion"))
				{
					tempSnmpVersion = paramValue;
				}

				if (paramName.equalsIgnoreCase("snmpcommunity"))
				{
					if (snmpVer.length() == 0)
					{
						if (tempSnmpVersion.equalsIgnoreCase("v3")) continue;
					}
					else
					{
						if (snmpVer.equalsIgnoreCase("v3")) continue;
					}
				}

				//in snmpV3 hiding encrypt type and encrypt password when its value is false.
				int snmpV3ParamIdx = Arrays.binarySearch(snmpV3ParamToContinue,paramName,String.CASE_INSENSITIVE_ORDER);
				if (!isSnmpV1V2)
				{
					if (encryptFlag.length() == 0)
					{
						if (encryptValue.equalsIgnoreCase("false"))
						{
							if (snmpV3ParamIdx > -1) continue;
						}
					}
					else if(encryptFlag.equalsIgnoreCase("false"))
					{
						if (snmpV3ParamIdx > -1) continue;
					}
				}

				if (isModeParamExist)
				{
					int modeIdx = aListResultantInLowerCase.indexOf("-mode");
					String modeValue = ((String)aResultant.get(modeIdx+1)).trim();

					if (testName.equals(previousTestName))
					{
						String requestModeValue = request.getParameter(((String)aResultant.get(modeIdx)).substring(1));
						requestModeValue = (requestModeValue==null)?"":requestModeValue;
						if (!requestModeValue.equals("")) modeValue = requestModeValue;
					}

					if (modeValue.equalsIgnoreCase("true"))
					{
						int modeTrueParamIdx = Arrays.binarySearch(modeTrueToContinue,paramName,String.CASE_INSENSITIVE_ORDER);
						if (modeTrueParamIdx > -1) continue;
					}
					else
					{
						int modeFalseParamIdx = Arrays.binarySearch(modeFalseToContinue,paramName,String.CASE_INSENSITIVE_ORDER);
						if (modeFalseParamIdx > -1) continue;
					}

					int profilerIdx = aListResultantInLowerCase.indexOf("-profiler");
					if (profilerIdx > -1)
					{
						String profilerValue = ((String)aResultant.get(profilerIdx+1)).trim();
						if (testName.equals(previousTestName))
						{
							String requestProfilerValue = request.getParameter(((String)aResultant.get(profilerIdx)).substring(1));
							requestProfilerValue = (requestProfilerValue==null)?"":requestProfilerValue;
							if (!requestProfilerValue.equals("")) profilerValue = requestProfilerValue;
						}

						if (paramName.equalsIgnoreCase("profiler_home") && 
							profilerValue.equalsIgnoreCase("false"))
						{
							continue;
						}
					}

					int heapAnalysisIdx = aListResultantInLowerCase.indexOf("-heap_analysis");
					if (heapAnalysisIdx > -1)
					{
						String heapAnalysisValue = ((String)aResultant.get(heapAnalysisIdx+1)).trim();

						String requestHeapAnalysisValue = "";
						if (testName.equals(previousTestName))
						{
							requestHeapAnalysisValue = request.getParameter(((String)aResultant.get(heapAnalysisIdx)).substring(1));
							requestHeapAnalysisValue = (requestHeapAnalysisValue == null)?"":requestHeapAnalysisValue;
						}

						if (!requestHeapAnalysisValue.equals("")) 
						{
							heapAnalysisValue = requestHeapAnalysisValue;
						}

						if ((paramName.equalsIgnoreCase("java_home") ||  
							 paramName.equalsIgnoreCase("include_packages") || 
							 paramName.equalsIgnoreCase("exclude_packages")) && 
							heapAnalysisValue.equalsIgnoreCase("false"))
						{
							continue;
						}
					}
				}
			}

			int readOnlyParamIdx = Arrays.binarySearch(multiUserReadOnlyParam,paramName,String.CASE_INSENSITIVE_ORDER);
			if(readOnlyParamIdx <= -1)
			{
				readOnlyParamIdx = Arrays.binarySearch(multiNameReadOnlyParam,paramName,String.CASE_INSENSITIVE_ORDER);
			}

			if (readOnlyParamIdx > -1)
			{
				if (paramName.equalsIgnoreCase("domain") || 
					paramName.equalsIgnoreCase("user") || 
					paramName.equalsIgnoreCase("admin_user"))
				{
					if (paramValue.indexOf("|") > -1)
					{
						hasMultipleUsers = true;
					}
				}
				else if (paramName.equalsIgnoreCase("name") || 
					paramName.equalsIgnoreCase("pattern") || 
					paramName.equalsIgnoreCase("threshold_value"))
					{
						if (paramValue.indexOf("|") > -1)
						{
							hasMultipleNames = true;
						}
					}
			}

			if (hasShowAliasParam)
			{
				if (paramName.equalsIgnoreCase("show_alias_and_interface_name") && useAliasValue.equalsIgnoreCase("false"))
				{
					continue;
				}
			}

			if (hasShowAllOnlyParam)
			{
				if (paramName.equalsIgnoreCase("showAllOnly") && showAllEventsValue.equalsIgnoreCase("false"))
				{
					continue;
				}
			}

			if (hasReportOnlyTotalParam)
			{
				if (paramName.equalsIgnoreCase("Report_only_total") && reportTotalValue.equalsIgnoreCase("false"))
				{
					continue;
				}
			}

			if (paramName.equalsIgnoreCase("credentials"))
			{
				StringBuffer strBuffer = new StringBuffer();
				for (int k=0;k<aUrlCredentialVal.size();k=k+3)
				{
					if (k >= 3)
					{
						strBuffer.append(",");
					}
					strBuffer.append(aUrlCredentialVal.get(k+1));
					strBuffer.append(":");
					strBuffer.append(aUrlCredentialVal.get(k+2));
				}
%>
				<input type="hidden" name="<%=paramName%>" id="<%=paramName%>" value='<%=strBuffer.toString()%>'>
<%
				continue;
			}

			if (paramName.equalsIgnoreCase("content"))
			{
				StringBuffer strBuffer = new StringBuffer();
				for (int k=0;k<aListContentValues.size();k++)
				{
					if (k >= 1)
					{
						strBuffer.append(",");
					}
					strBuffer.append(aListContentValues.get(k));
				}
%>
				<input type="hidden" name="<%=paramName%>" id="<%=paramName%>" value='<%=strBuffer.toString()%>'>
<%
				continue;
			}

			if (paramName.equalsIgnoreCase("encoding"))
			{
				StringBuffer strBuffer = new StringBuffer();
				for (int k=0;k<aListEncodingValues.size();k++)
				{
					if (k >= 1)
					{
						strBuffer.append(",");
					}
					strBuffer.append(aListEncodingValues.get(k));
				}
%>
				<input type="hidden" name="<%=paramName%>" id="<%=paramName%>" value='<%=strBuffer.toString()%>'>
<%
				continue;
			}

			if (paramName.equalsIgnoreCase("privateKey"))
			{
				StringBuffer strBuffer = new StringBuffer();				
				for (int k=0;k<aListFilePathValues.size();k=k+2)
				{
					if (k >= 2)
					{
						strBuffer.append(",");
					}					
					strBuffer.append(aListFilePathValues.get(k));
					strBuffer.append("#~~#");
					strBuffer.append(aListFilePathValues.get(k+1));
				}
				
%>
							<input type="hidden" name="<%=paramName%>" id="<%=paramName%>" value='<%=strBuffer.toString()%>'>
<%
				continue;
			}

			if (testName.equalsIgnoreCase("WindowshareTest") && 
				(paramName.equalsIgnoreCase("domainname") || 
				paramName.equalsIgnoreCase("shareusername") || 
				paramName.equalsIgnoreCase("password")))
			{
				if (displayControl.equalsIgnoreCase("password"))
				{
					if (paramValue.indexOf("|") > -1)
					{
						String tempStr = "";
						StringTokenizer st1 = new StringTokenizer(paramValue,"|");
						while(st1.hasMoreTokens())
						{
							tempStr += EgCrypt.decrypt(st1.nextToken()) + "#~#";
						}
						paramValue = tempStr.substring(0, tempStr.length()-3);
					}
					else
					{
						paramValue = EgCrypt.decrypt(paramValue);
					}
				}
				else
				{
					if (paramValue.indexOf("|") > -1)
					{
						paramValue = StringUtils.replace(paramValue,"|",",");
					}
				}
%>
				<input type="hidden" name="<%=paramName%>" id="<%=paramName%>" value='<%=paramValue%>'>
<%
				continue;
			}

			String readOnly = "";
%>
				<tr>
					<td id="formtop_border" style="valign:middle">
<%
			boolean showStar = false;
			String tempNewValue = null;
			if (paramValue.startsWith("$") && aListTcKeywordsLowerCase.contains(paramValue.toLowerCase()))
			{
				showStar = true;
				if (testName.equals(previousTestName))
				{
					tempNewValue = request.getParameter(paramName);
					if (tempNewValue != null)
					{
						tempNewValue = tempNewValue.toLowerCase();
						if (!aListTcKeywordsLowerCase.contains(tempNewValue))
						{
							showStar = false;
						}
					}
				}

				if (showStar)
				{
%>
					<font color='black'>&nbsp;&nbsp;*&nbsp;</font>
<%
				}
				else
				{
%>
					&nbsp;&nbsp;
<%
				}
			}
			else
			{
%>
				&nbsp;&nbsp;
<%
			}
%>
					</td>
					<td id="formtop_border"><egui:intnl text='<%="admin.test."+paramName.toUpperCase()%>'/></td>
					<td id="formtop_border">:</td>
<%
			if (displayControl.equalsIgnoreCase("radio"))
			{
				String enabled = "";
				String disabled = "";

				//Dependent Parameter - Having relationship with other parameters
				//For e.g., correct which has relations with alarmtype,userparams,correctivescript
				//Independent Parameter - Does not have relationship with other parameters
				//For e.g., isPassive
				//ProcessTest=wide(Yes:true#No:false) - Independent param
				//parameter value definition = (Yes:true#No:false)
				//Independent parameter having values true (or) false,yes (or) no,y (or) n doesnt 
				//need to define parameter value definition.
				//so ProcessTest=wide(Yes:true#No:false) can also be called as ProcessTest=wide
				//This will be handled in else block

				boolean isIndependentParam = aListDynamicRadioOptionNameAndValue.contains(paramName);
				if (isIndependentParam)
				{
					//block fires when the user put corresponding value to the isolated
					//radio parameter.
					int paramIdx = aListDynamicRadioOptionNameAndValue.indexOf(paramName);
					String tempParamValue = (String)aListDynamicRadioOptionNameAndValue.get(paramIdx+1);
					StringTokenizer st = new StringTokenizer(tempParamValue,"#");
					String tempParam = st.nextToken();
					String tempName1 = tempParam.substring(0,tempParam.indexOf(":"));
					String tempValue1 = tempParam.substring(tempParam.indexOf(":")+1,tempParam.length());
					String tempParam1 = st.nextToken();
					String tempName2 = tempParam1.substring(0,tempParam1.indexOf(":"));
					String tempValue2 = tempParam1.substring(tempParam1.indexOf(":")+1,tempParam1.length());

					String selectedParamValue = "";
					if (testName.equals(previousTestName))
					{
						selectedParamValue = request.getParameter(paramName);
						selectedParamValue = (selectedParamValue!=null)?selectedParamValue:"";
					}

					if (paramValue.equalsIgnoreCase("yes"))
					{
						paramValue = "true";
					}
					else if (paramValue.equalsIgnoreCase("no"))
					{
						paramValue = "false";
					}

					if (selectedParamValue.equalsIgnoreCase("") && 
						tempValue1.equalsIgnoreCase(paramValue))
					{
						enabled = "checked";
						disabled = "";
					}
					else if (selectedParamValue.equalsIgnoreCase("") && 
						tempValue2.equalsIgnoreCase(paramValue))
					{
						enabled = "";
						disabled = "checked";
					}
					else if (selectedParamValue.equalsIgnoreCase(tempValue1))
					{
						enabled = "checked";
						disabled = "";
					}
					else if (selectedParamValue.equalsIgnoreCase(tempValue2))
					{
						enabled = "";
						disabled = "checked";
					}
					aListDisplay.add(paramName+"#"+tempValue1);
					aListDisplay.add(tempName1);

					aListDisplay.add(paramName+"#"+tempValue2);
					aListDisplay.add(tempName2);

					if (paramName.equalsIgnoreCase("Aggregate_user_sessions") && 
						viewAccessOnly && disabled.equalsIgnoreCase("checked"))
					{
%>
					<td id="formtop_border">
						<table border="0" cellpadding="0" cellspacing="0">
							<tr>
								<td valign="middle"><input type="radio" class="eg_input" name="<%=paramName%>" id="<%=paramName%>" value="<%=tempValue1%>" <%=enabled%> disabled></td>
								<td valign="middle"><%=tempName1%></td>
								<td valign="middle">&nbsp;&nbsp;&nbsp;</td>
								<td valign="middle"><input type="radio" class="eg_input" name="<%=paramName%>" id="<%=paramName%>" value="<%=tempValue2%>" <%=disabled%> disabled></td>
								<td valign="middle"><%=tempName2%></td>
							</tr>
						</table>
					</td>
<%
					}
					else
					{
%>
					<td id="formtop_border">
						<table border="0" cellpadding="0" cellspacing="0">
							<tr>
								<td valign="middle"><input type="radio" class="eg_input" name="<%=paramName%>" id="<%=paramName%>" value="<%=tempValue1%>" <%=enabled%>></td>
								<td valign="middle"><%=tempName1%></td>
								<td valign="middle">&nbsp;&nbsp;&nbsp;</td>
								<td valign="middle"><input type="radio" class="eg_input" name="<%=paramName%>" id="<%=paramName%>" value="<%=tempValue2%>" <%=disabled%>></td>
								<td valign="middle"><%=tempName2%></td>
							</tr>
						</table>
					</td>
<%
					}
%>
					<td id="formtop_border">&nbsp;</td>
				</tr>
<%
				}
				else
				{
					if (paramName.equalsIgnoreCase("encryptflag") && isSnmp)
					{
						String encryptFlagVal = "";
						if (testName.equals(previousTestName))
						{
							encryptFlagVal = request.getParameter(paramName);
							encryptFlagVal = (encryptFlagVal!=null)?encryptFlagVal:"";
						}

						if (paramValue.equalsIgnoreCase("true") && encryptFlagVal.length()==0)
						{
							enabled = "checked";
							disabled = "";
						}
						else if (paramValue.equalsIgnoreCase("false") && encryptFlagVal.length()==0)
						{
							enabled = "";
							disabled = "checked";
						}
						else if (encryptFlagVal.equalsIgnoreCase("true"))
						{
							enabled = "checked";
							disabled = "";
						}
						else if (encryptFlagVal.equalsIgnoreCase("false"))
						{
							enabled = "";
							disabled = "checked";
						}
%>
					<td id="formtop_border">
						<table border="0" cellpadding="0" cellspacing="0">
							<tr>
								<td valign="middle"><input type="radio" class="eg_input" name="<%=paramName%>" id="<%=paramName%>" value="true" <%=enabled%> onclick='javascript:changeValue()'></td>
								<td valign="middle"><egui:intnl text="admin.common.Yes"/></td>
								<td valign="middle">&nbsp;&nbsp;&nbsp;</td>
								<td valign="middle"><input type="radio" class="eg_input" name="<%=paramName%>" id="<%=paramName%>" value="false" <%=disabled%> onclick='javascript:changeValue()'></td>
								<td valign="middle"><egui:intnl text="admin.common.No"/></td>
							</tr>
						</table>
					</td>
					<td id="formtop_border">&nbsp;</td>
				</tr>
<%
					}
					else if (paramName.equalsIgnoreCase("policyfilter") && isPolicyParamExists)
					{
						String policyFilterValue = "";
						if (testName.equals(previousTestName))
						{
							policyFilterValue = request.getParameter(paramName);
							policyFilterValue = (policyFilterValue != null && policyFilterValue.length() > 0)?policyFilterValue:"";
						}

						if(paramValue.equalsIgnoreCase("true") && policyFilterValue.length()==0)
						{
							enabled = "checked";
							disabled = "";
						}
						if (paramValue.equalsIgnoreCase("false") && policyFilterValue.length()==0)
						{
							enabled = "";
							disabled = "checked";
						}
						else if(policyFilterValue.equalsIgnoreCase("true"))
						{
							enabled = "checked";
							disabled = "";
						}
						else if(policyFilterValue.equalsIgnoreCase("false"))
						{
							enabled = "";
							disabled = "checked";
						}
%>
					<td id="formtop_border">
						<table border="0" cellpadding="0" cellspacing="0">
							<tr>
								<td valign="middle"><input type="radio" class="eg_input" name="<%=paramName%>" id="<%=paramName%>" value="true" <%=enabled%> onclick='javascript:changeValue()'></td>
								<td valign="middle"><egui:intnl text="admin.common.Yes"/></td>
								<td valign="middle">&nbsp;&nbsp;&nbsp;</td>
								<td valign="middle"><input type="radio" class="eg_input" name="<%=paramName%>" id="<%=paramName%>" value="false" <%=disabled%> onclick='javascript:changeValue()'></td>
								<td valign="middle"><egui:intnl text="admin.common.No"/></td>
							</tr>
						</table>
					</td>
					<td id="formtop_border">&nbsp;</td>
				</tr>
<%
					}
					else if (paramName.equalsIgnoreCase("correct") && isCorrectParamExist)
					{
						String correctVal = "";
						if (testName.equals(previousTestName))
						{
							correctVal = request.getParameter(paramName);
							correctVal = (correctVal != null && correctVal.length() > 0)?correctVal:"";
						}

						if(paramValue.equalsIgnoreCase("false") && correctVal.length()==0)
						{
							enabled = "";
							disabled = "checked";
						}
						else if(paramValue.equalsIgnoreCase("true") && correctVal.length()==0)
						{
							enabled = "checked";
							disabled = "";
						}
						else if(correctVal.equalsIgnoreCase("true"))
						{
							enabled = "checked";
							disabled = "";
						}
						else if(correctVal.equalsIgnoreCase("false"))
						{
							enabled = "";
							disabled = "checked";
						}
%>
					<td id="formtop_border">
						<table border="0" cellpadding="0" cellspacing="0">
							<tr>
								<td valign="middle"><input type="radio" class="eg_input" name="<%=paramName%>" id="<%=paramName%>" value="true" <%=enabled%> onclick='javascript:changeValue()'></td>
								<td valign="middle"><egui:intnl text="admin.common.Yes"/></td>
								<td valign="middle">&nbsp;&nbsp;&nbsp;</td>
								<td valign="middle"><input type="radio" class="eg_input" name="<%=paramName%>" id="<%=paramName%>" value="false" <%=disabled%> onclick='javascript:changeValue()'></td>
								<td valign="middle"><egui:intnl text="admin.common.No"/></td>
							</tr>
						</table>
					</td>
					<td id="formtop_border">&nbsp;</td>
				</tr>
<%
					}
					else if(paramName.equalsIgnoreCase("mode") && isModeParamExist)
					{
						String snmpSelected = "";
						String jmxSelected = "";
						String modeTempVal = new String(paramValue);

						String requestModeValue = "";
						if (testName.equals(previousTestName))
						{
							requestModeValue = request.getParameter(paramName);
							requestModeValue = (requestModeValue==null)?"":requestModeValue;
						}

						if (!requestModeValue.equals(""))
						{
							modeTempVal = requestModeValue;
						}

						if (modeTempVal.equalsIgnoreCase("true"))
						{
							snmpSelected = "checked";
						}
						else
						{
							jmxSelected = "checked";
						}
%>
					<td id="formtop_border">
						<table border="0" cellpadding="0" cellspacing="0">
							<tr>
								<td valign="middle"><input type="radio" class="eg_input" name="<%=paramName%>" id="<%=paramName%>" value="true" <%=snmpSelected%> onclick='javascript:changeValue()'></td>
								<td valign="middle"><egui:intnl text="admin.common.SNMP"/></td>
								<td valign="middle">&nbsp;&nbsp;&nbsp;</td>
								<td valign="middle"><input type="radio" class="eg_input" name="<%=paramName%>" id="<%=paramName%>" value="false" <%=jmxSelected%> onclick='javascript:changeValue()'></td>
								<td valign="middle"><egui:intnl text="admin.common.JMX"/></td>
							</tr>
						</table>
					</td>
					<td id="formtop_border">&nbsp;</td>
				</tr>
<%
						aListDisplay.add(paramName+"#"+"true");
						aListDisplay.add("SNMP");

						aListDisplay.add(paramName+"#"+"false");
						aListDisplay.add("JMX");
					}
					else if(paramName.equalsIgnoreCase("profiler") && isModeParamExist)
					{
						String profilerOn = "";
						String profilerOff = "";
						String profilerValue = new String(paramValue);

						String requestProfilerValue = "";
						if (testName.equals(previousTestName))
						{
							requestProfilerValue = request.getParameter(paramName);
							requestProfilerValue = (requestProfilerValue==null)?"":requestProfilerValue;
						}

						if (!requestProfilerValue.equals(""))
						{
							profilerValue = requestProfilerValue;
						}

						if (profilerValue.equalsIgnoreCase("true"))
						{
							profilerOn = "checked";
						}
						else
						{
							profilerOff = "checked";
						}
%>
					<td id="formtop_border">
						<table border="0" cellpadding="0" cellspacing="0">
							<tr>
								<td valign="middle"><input type="radio" class="eg_input" name="<%=paramName%>" id="<%=paramName%>" value="true" <%=profilerOn%> onclick='javascript:changeValue()'></td>
								<td valign="middle"><egui:intnl text="admin.common.On"/></td>
								<td valign="middle">&nbsp;&nbsp;&nbsp;</td>
								<td valign="middle"><input type="radio" class="eg_input" name="<%=paramName%>" id="<%=paramName%>" value="false" <%=profilerOff%> onclick='javascript:changeValue()'></td>
								<td valign="middle"><egui:intnl text="admin.common.Off"/></td>
							</tr>
						</table>
					</td>
					<td id="formtop_border">&nbsp;</td>
				</tr>
<%
						aListDisplay.add(paramName+"#"+"true");
						aListDisplay.add("On");

						aListDisplay.add(paramName+"#"+"false");
						aListDisplay.add("Off");
					}
					else if(paramName.equalsIgnoreCase("heap_analysis") && isModeParamExist)
					{
						String heapAnalysisYes = "";
						String heapAnalysisNo = "";
						String heapAnalysisValue = new String(paramValue);

						String requestHeapAnalysisValue = "";
						if (testName.equals(previousTestName))
						{
							requestHeapAnalysisValue = request.getParameter(paramName);
							requestHeapAnalysisValue = (requestHeapAnalysisValue==null)?"":requestHeapAnalysisValue;
						}

						if (!requestHeapAnalysisValue.equals(""))
						{
							heapAnalysisValue = requestHeapAnalysisValue;
						}

						if (heapAnalysisValue.equalsIgnoreCase("true"))
						{
							heapAnalysisYes = "checked";
						}
						else
						{
							heapAnalysisNo = "checked";
						}
%>
					<td id="formtop_border">
						<table border="0" cellpadding="0" cellspacing="0">
							<tr>
								<td valign="middle"><input type="radio" class="eg_input" name="<%=paramName%>" id="<%=paramName%>" value="true" <%=heapAnalysisYes%> onclick='javascript:changeValue()'></td>
								<td valign="middle"><egui:intnl text="admin.common.Yes"/></td>
								<td valign="middle">&nbsp;&nbsp;&nbsp;</td>
								<td valign="middle"><input type="radio" class="eg_input" name="<%=paramName%>" id="<%=paramName%>" value="false" <%=heapAnalysisNo%> onclick='javascript:changeValue()'></td>
								<td valign="middle"><egui:intnl text="admin.common.No"/></td>
							</tr>
						</table>
					</td>
					<td id="formtop_border">&nbsp;</td>
				</tr>
<%
						aListDisplay.add(paramName+"#"+"true");
						aListDisplay.add("Yes");

						aListDisplay.add(paramName+"#"+"false");
						aListDisplay.add("No");
					}
					else if(paramName.equalsIgnoreCase("useAlias") && hasShowAliasParam)
					{
						String usealiasYes = "";
						String usealiasNo = "";
						String usealiasValue = new String(paramValue);

						String requestusealiasValue = "";
						if (testName.equals(previousTestName))
						{
							requestusealiasValue = request.getParameter(paramName);
							requestusealiasValue = (requestusealiasValue==null)?"":requestusealiasValue;
						}

						if (!requestusealiasValue.equals(""))
						{
							usealiasValue = requestusealiasValue;
						}

						if (usealiasValue.equalsIgnoreCase("true") || usealiasValue.equalsIgnoreCase("yes"))
						{
							usealiasYes = "checked";
						}
						else
						{
							usealiasNo = "checked";
						}
%>
								<td id="formtop_border">
									<table border="0" cellpadding="0" cellspacing="0">
										<tr>
											<td valign="middle"><input type="radio" class="eg_input" name="<%=paramName%>" id="<%=paramName%>" value="true" <%=usealiasYes%> onclick='javascript:changeValue()'></td>
											<td valign="middle"><egui:intnl text="admin.common.Yes"/></td>
											<td valign="middle">&nbsp;&nbsp;&nbsp;</td>
											<td valign="middle"><input type="radio" class="eg_input" name="<%=paramName%>" id="<%=paramName%>" value="false" <%=usealiasNo%> onclick='javascript:changeValue()'></td>
											<td valign="middle"><egui:intnl text="admin.common.No"/></td>
										</tr>
									</table>
								</td>
								<td id="formtop_border">&nbsp;</td>
							</tr>
<%
						aListDisplay.add(paramName+"#"+"true");
						aListDisplay.add("Yes");

						aListDisplay.add(paramName+"#"+"false");
						aListDisplay.add("No");
					}
					else if (paramName.equalsIgnoreCase("showAllEvents") && hasShowAllOnlyParam)
					{
						String showalleventsYes = "";
						String showalleventsNo = "";
						String showalleventsValue = new String(paramValue);

						String requestshowalleventsValue = "";
						if (testName.equals(previousTestName))
						{
							requestshowalleventsValue = request.getParameter(paramName);
							requestshowalleventsValue = (requestshowalleventsValue==null)?"":requestshowalleventsValue;
						}

						if (!requestshowalleventsValue.equals(""))
						{
							showalleventsValue = requestshowalleventsValue;
						}
						if (showalleventsValue.equalsIgnoreCase("true") || showalleventsValue.equalsIgnoreCase("yes"))
						{
							showalleventsYes = "checked";
						}
						else
						{
							showalleventsNo = "checked";
						}
%>
								<td id="formtop_border" colspan="2">
									<table border="0" cellspacing="0" cellpadding="0">
										<tr>
											<td>
												<table border="0" cellpadding="0" cellspacing="0">
													<tr>
														<td valign="middle"><input type="radio" class="eg_input" name="<%=paramName%>" id="<%=paramName%>" value="true" <%=showalleventsYes%> onclick='javascript:changeValue()'></td>
														<td valign="middle"><egui:intnl text="admin.common.Yes"/></td>
														<td valign="middle">&nbsp;&nbsp;&nbsp;</td>
														<td valign="middle"><input type="radio" class="eg_input" name="<%=paramName%>" id="<%=paramName%>" value="false" <%=showalleventsNo%> onclick='javascript:changeValue()'></td>
														<td valign="middle"><egui:intnl text="admin.common.No"/></td>
													</tr>
												</table>
											</td>
											<td>&nbsp;</td>
										</tr>
									</table>
								</td>
							</tr>
<%
						aListDisplay.add(paramName+"#"+"true");
						aListDisplay.add("Yes");

						aListDisplay.add(paramName+"#"+"false");
						aListDisplay.add("No");
					}
					else if (paramName.equalsIgnoreCase("Report_total") && hasReportOnlyTotalParam)
					{
						String reporttotalYes = "";
						String reporttotalNo = "";
						String reporttotalValue = new String(paramValue);

						String requestreporttotalValue = "";
						if (testName.equals(previousTestName))
						{
							requestreporttotalValue = request.getParameter(paramName);
							requestreporttotalValue = (requestreporttotalValue==null)?"":requestreporttotalValue;
						}

						if (!requestreporttotalValue.equals(""))
						{
							reporttotalValue = requestreporttotalValue;
						}
						if (reporttotalValue.equalsIgnoreCase("true") || reporttotalValue.equalsIgnoreCase("yes"))
						{
							reporttotalYes = "checked";
						}
						else
						{
							reporttotalNo = "checked";
						}
%>
								<td id="formtop_border" colspan="2">
									<table border="0" cellspacing="0" cellpadding="0">
										<tr>
											<td>
												<table border="0" cellpadding="0" cellspacing="0">
													<tr>
														<td valign="middle"><input type="radio" class="eg_input" name="<%=paramName%>" id="<%=paramName%>" value="true" <%=reporttotalYes%> onclick='javascript:changeValue()'></td>
														<td valign="middle"><egui:intnl text="admin.common.Yes"/></td>
														<td valign="middle">&nbsp;&nbsp;&nbsp;</td>
														<td valign="middle"><input type="radio" class="eg_input" name="<%=paramName%>" id="<%=paramName%>" value="false" <%=reporttotalNo%> onclick='javascript:changeValue()'></td>
														<td valign="middle"><egui:intnl text="admin.common.No"/></td>
													</tr>
												</table>
											</td>
											<td>&nbsp;</td>
										</tr>
									</table>
								</td>
							</tr>
<%
						aListDisplay.add(paramName+"#"+"true");
						aListDisplay.add("Yes");

						aListDisplay.add(paramName+"#"+"false");
						aListDisplay.add("No");
					}
					else
					{
						//handling independent parameter for radio - starts
						//handled yes,no,true,false,y and n only
						//block fires when the user forgets to put corresponding value
						//to the isolated radio parameter.Parameter are handled to their
						//default values.
						String value1 = "";
						String value2 = "";

						if (paramValue.equalsIgnoreCase("yes") || paramValue.equalsIgnoreCase("no"))
						{
							value1 = "yes";
							value2 = "no";
						}
						else if (paramValue.equalsIgnoreCase("true") || paramValue.equalsIgnoreCase("false"))
						{
							value1 = "true";
							value2 = "false";
						}
						else
						{
							value1 = "y";
							value2 = "n";
						}

						String selectedParamValue = "";
						if (testName.equals(previousTestName))
						{
							selectedParamValue = request.getParameter(paramName);
							selectedParamValue = (selectedParamValue!=null)?selectedParamValue:"";
						}

						if (selectedParamValue.equals(""))
						{
							if (paramValue.equalsIgnoreCase("n") || 
								paramValue.equalsIgnoreCase("no") || 
								paramValue.equalsIgnoreCase("false"))
							{
								enabled = "";
								disabled = "checked";
							}
							else
							{
								enabled = "checked";
								disabled = "";
							}
						}
						else
						{
							if (selectedParamValue.equalsIgnoreCase("n") || 
								selectedParamValue.equalsIgnoreCase("no") || 
								selectedParamValue.equalsIgnoreCase("false"))
							{
								enabled = "";
								disabled = "checked";
							}
							else
							{
								enabled = "checked";
								disabled = "";
							}
						}

						if (paramName.equalsIgnoreCase("Report_By_User") && 
							viewAccessOnly && enabled.equalsIgnoreCase("checked"))
						{
%>
					<td id="formtop_border">
						<table border="0" cellpadding="0" cellspacing="0">
							<tr>
								<td valign="middle"><input type="radio" class="eg_input" name="<%=paramName%>" id="<%=paramName%>" value="<%=value1%>" <%=enabled%> disabled></td>
								<td valign="middle"><egui:intnl text="admin.common.Yes"/></td>
								<td valign="middle">&nbsp;&nbsp;&nbsp;</td>
								<td valign="middle"><input type="radio" class="eg_input" name="<%=paramName%>" id="<%=paramName%>" value="<%=value2%>" <%=disabled%> disabled></td>
								<td valign="middle"><egui:intnl text="admin.common.No"/></td>
							</tr>
						</table>
					</td>
<%
						}
						else if (paramName.equalsIgnoreCase("ReportByClientName") && 
							viewAccessOnly && disabled.equalsIgnoreCase("checked"))
						{
%>
					<td id="formtop_border">
						<table border="0" cellpadding="0" cellspacing="0">
							<tr>
								<td valign="middle"><input type="radio" class="eg_input" name="<%=paramName%>" id="<%=paramName%>" value="<%=value1%>" <%=enabled%> disabled></td>
								<td valign="middle"><egui:intnl text="admin.common.Yes"/></td>
								<td valign="middle">&nbsp;&nbsp;&nbsp;</td>
								<td valign="middle"><input type="radio" class="eg_input" name="<%=paramName%>" id="<%=paramName%>" value="<%=value2%>" <%=disabled%> disabled></td>
								<td valign="middle"><egui:intnl text="admin.common.No"/></td>
							</tr>
						</table>
					</td>
<%
						}
						else
						{
%>
					<td id="formtop_border">
						<table border="0" cellpadding="0" cellspacing="0">
							<tr>
								<td valign="middle"><input type="radio" class="eg_input" name="<%=paramName%>" id="<%=paramName%>" value="<%=value1%>" <%=enabled%>></td>
								<td valign="middle"><egui:intnl text="admin.common.Yes"/></td>
								<td valign="middle">&nbsp;&nbsp;&nbsp;</td>
								<td valign="middle"><input type="radio" class="eg_input" name="<%=paramName%>" id="<%=paramName%>" value="<%=value2%>" <%=disabled%>></td>
								<td valign="middle"><egui:intnl text="admin.common.No"/></td>
							</tr>
						</table>
					</td>
<%
						}
%>
					<td id="formtop_border">&nbsp;</td>
				</tr>
<%
					//handling independent parameter for radio - ends
					}
				}
			}
			else if (displayControl.equalsIgnoreCase("select"))
			{
				//Dependent Parameter - Having relationship with other parameters
				//For e.g., snmpVersion which has relations with snmpCommunity,AuthType,AuthPass,EncryptType,EncryptPass
				//Independent Parameter - Does not have relationship with other parameters
				//For e.g., alarmtype
				boolean isIndependentParam = aListDynamicSelectOptionNameAndValue.contains(paramName);
				if (isIndependentParam)
				{
%>
					<td height="30" id="formtop_border">
						<select name="<%=paramName%>" id="<%=paramName%>">
<%
					int strParamIdx = aListDynamicSelectOptionNameAndValue.indexOf(paramName);
					String strParamValue = (String)aListDynamicSelectOptionNameAndValue.get(strParamIdx+1);
					String selectedParamValue = "";
					if (testName.equals(previousTestName))
					{
						selectedParamValue = request.getParameter(paramName);
						selectedParamValue = (selectedParamValue != null)?selectedParamValue:"";
					}
					StringTokenizer st = new StringTokenizer(strParamValue,"#");
					while (st.hasMoreTokens())
					{
						String s = st.nextToken();
						String strText = s.substring(0,s.indexOf(":"));
						String strValue = s.substring(s.indexOf(":")+1,s.length());
						aListDisplay.add(paramName+"#"+strValue);
						aListDisplay.add(strText);
						if (paramValue.equals(strValue))
						{
%>
							<option value=<%=strValue%> selected><%=strText%></option>
<%
						}
						else if (selectedParamValue.equals(strValue))
						{
%>
							<option value=<%=strValue%> selected><%=strText%></option>
<%
						}
						else
						{
%>
							<option value=<%=strValue%>><%=strText%></option>
<%
						}
					}
%>
						</select>
					</td>
					<td id="formtop_border">&nbsp;</td>
				</tr>
<%
				}
				else
				{
					if (paramName.equalsIgnoreCase("snmpversion") && isSnmp)
					{
						if (testName.equals(previousTestName))
						{
							String strVal = request.getParameter(paramName);
							paramValue = (strVal==null)?paramValue:strVal;
						}
						String select = "";
%>
					<td height="30" id="formtop_border">
						<select name="<%=paramName%>" class="list" onChange='javaScript:changeValue()' id="<%=paramName%>" >
<%
						for(int k=0;k<versions.length;k++)
						{
							if(versions[k].equalsIgnoreCase(paramValue))
							{
								select = "selected";
							}
							else
							{
								select = "";
							}
%>
							<option value="<%=versions[k]%>"<%=select%>><%=versions[k]%></option>
<%
						}
%>
						</select>
					</td>
					<td id="formtop_border">&nbsp;</td>
				</tr>
<%
					}
					else if (paramName.equalsIgnoreCase("authtype") && isSnmp)
					{
						if (testName.equals(previousTestName))
						{
							String authTypeVal = request.getParameter(paramName);
							paramValue = (authTypeVal==null)?paramValue:authTypeVal;
						}
						String select = "";
%>
					<td height="30" id="formtop_border">
						<select name="<%=paramName%>" class="list" id="<%=paramName%>" >
<%
						for(int k=0;k<authTypes.length;k++)
						{
							if(paramValue.equals(authTypes[k]))
							{
								select = "selected";
							}
							else
							{
								select = "";
							}
%>
							<option value="<%=authTypes[k]%>"<%=select%>><%=authTypes[k]%></option>
<%
						}
%>
						</select>
					</td>
					<td id="formtop_border">&nbsp;</td>
				</tr>
<%
					}
					else if (paramName.equalsIgnoreCase("encrypttype") && isSnmp)
					{
						if (testName.equals(previousTestName))
						{
							String encryptTypeVal = request.getParameter(paramName);
							paramValue = (encryptTypeVal==null)?paramValue:encryptTypeVal;
						}
						String select = "";
%>
					<td height="30" id="formtop_border">
						<select name="<%=paramName%>" class="list" id="<%=paramName%>">
<%
						for(int k=0;k<encryptTypes.length;k++)
						{
							if(paramValue.equals(encryptTypes[k]))
							{
								select = "selected";
							}
							else
							{
								select = "";
							}
%>
							<option value="<%=encryptTypes[k]%>"<%=select%>><%=encryptTypes[k]%></option>
<%
						}
%>
						</select>
					</td>
					<td id="formtop_border">&nbsp;</td>
				</tr>
<%
					}
					else if(paramName.equalsIgnoreCase("filter") && isPolicyParamExists)
					{
						String policyFilterValue = "";
						int policyFilterIdx = aListResultantTempInLowerCase.indexOf("-policyfilter");

						if (testName.equals(previousTestName))
						{
							policyFilterValue = request.getParameter(((String)aResultant.get(policyFilterIdx)).substring(1));
							policyFilterValue = (policyFilterValue != null && policyFilterValue.length() > 0)?policyFilterValue:"";
						}

						if (policyFilterValue.equalsIgnoreCase("true"))
						{
							ArrayList aListPolicy = new ArrayList();
							String select = "";
							String filterName = paramValue;
							if(filterName.indexOf(":") > -1)
							{
								if(filterName.indexOf(";") > -1)
								{
									StringTokenizer policyTokens = new StringTokenizer(filterName,";");
									while(policyTokens.hasMoreTokens())
									{
										String tempPolicy = policyTokens.nextToken();
										tempPolicy = tempPolicy.substring(0,tempPolicy.indexOf(":"));
										aListPolicy.add(tempPolicy);
									}
								}
								else
								{
									aListPolicy.add(filterName.substring(0,filterName.indexOf(":")));
								}
							}
							else if (filterName.indexOf(";") > -1)
							{
								StringTokenizer policyTokens = new StringTokenizer(filterName,";");
								while(policyTokens.hasMoreTokens())
								{
									String tempPolicy = policyTokens.nextToken();
									aListPolicy.add(tempPolicy);
								}
							}
							else
							{
								aListPolicy.add(filterName);
							}
%>
					<td height="30" id="formtop_border">
						<select name="<%=paramName%>" class="list" multiple size="5" width="350" style="width:350px;" id="<%=paramName%>">
<%
							for(int k=0;k<aPolicyFilter.size();k++)
							{
								if(aListPolicy.contains(aPolicyFilter.get(k)))
								{
									select = "selected";
								}
								else
								{
									select = "";
								}
%>
								<option value="<%=(String)aPolicyFilter.get(k)%>" <%=select%>><%=(String)aPolicyFilter.get(k)%></option>
<%
							}
%>
						</select>
					</td>
					<td id="formtop_border">&nbsp;</td>
				</tr>
<%
						}
						else if(policyFilterValue.length()==0 && paramValue.indexOf(":") > -1)
						{
							//called while loading the page when policy filter value is "no"
							paramValue = StringUtils.replace(paramValue,"|",",");
%>
					<td height="30" id="formtop_border" valign="top" class="eg_subcontent">
						<table cellspacing="0" cellpadding="0" border="0">
							<tr>
								<td valign="top"><textarea name="<%=paramName%>" id="<%=paramName%>" rows="5" cols="28"><%=paramValue%></textarea></td>
								<td nowrap>&nbsp;<input type="button" name ="viewurl" class="eg_lightbutton" value='<egui:intnl text="admin.common.View"/>' onClick="javascript:openSmallWindow('<%=paramName%>')" style="width:60px;"></td>
							</tr>
						</table>
					</td>
					<td id="formtop_border">&nbsp;</td>
				</tr>
<%
						}
						else if(policyFilterValue.length()==0 && paramValue.indexOf(":") == -1)
						{
							ArrayList aTemp = new ArrayList();
							if (paramValue.indexOf(";") > -1)
							{
								StringTokenizer st = new StringTokenizer(paramValue,";");
								while (st.hasMoreTokens())
								{
									aTemp.add(st.nextToken().trim());
								}
							}
							else
							{
								aTemp.add(paramValue);
							}
								String select = "";
%>
					<td height="30" id="formtop_border">
						<select name="<%=paramName%>" id="<%=paramName%>" class="list" multiple size="5" width="350" style="width:350px;">
<%
							for(int k=0;k<aPolicyFilter.size();k++)
							{
								if(aTemp.contains((String)aPolicyFilter.get(k)))
								{
									select = "selected";
								}
								else
								{
									select = "";
								}
%>
								<option value="<%=(String)aPolicyFilter.get(k)%>" <%=select%>><%=(String)aPolicyFilter.get(k)%></option>
<%
							}
%>
						</select>
					</td>
					<td id="formtop_border">&nbsp;</td>
				</tr>
<%
						}
						else if (policyFilterValue.equalsIgnoreCase("false"))//special case
						{
							String tempPolicyFilterValue = "";
							for(int z=0;z<aPolicyFilter.size();z++)
							{
								if (z>0)
								{
									tempPolicyFilterValue = tempPolicyFilterValue + ";";
								}
								tempPolicyFilterValue = tempPolicyFilterValue + (aPolicyFilter.get(z)).toString();
							}
%>
					<td height="30" id="formtop_border" valign="top" class="eg_subcontent">
						<table cellspacing="0" cellpadding="0" border="0">
							<tr>
								<td valign="top"><textarea name="<%=paramName%>" id="<%=paramName%>" rows="5" cols="28"><%=tempPolicyFilterValue%></textarea></td>
								<td nowrap>&nbsp;<input type="button" name ="viewurl" class="eg_lightbutton" value='<egui:intnl text="admin.common.View"/>' onClick="javascript:openSmallWindow('<%=paramName%>')" style="width:60px;"></td>
							</tr>
						</table>
					</td>
					<td id="formtop_border">&nbsp;</td>
				</tr>
<%
						}
					}
					/////////RHEV - Starts
					else if (paramName.equalsIgnoreCase("Rhel_mgr_host"))
					{
						String selectedRhevMgr = paramValue;
						if (testName.equals(previousTestName))
						{
							selectedRhevMgr = request.getParameter(paramName);
						}
						selectedRhevMgr = (selectedRhevMgr!=null)?selectedRhevMgr:paramValue;
						if (selectedRhevMgr.equalsIgnoreCase("$unconfigured"))
						{
							selectedRhevMgr = "none";
						}
%>
									<td height="30" id="formtop_border">
										<select name="<%=paramName%>" size="1" style="width:175px;"
										onchange="javascript:changeRHEVMgrValue(this.value);" id="<%=paramName%>">
											<option value='None'><egui:intnl text="admin.test.Choose an RHEV Manager"/></option>
<%
						if (rhevs != null && rhevs.length > 0)
						{
							for (int k=0;k<rhevs.length;k++)
							{
								String selected = "";
								String eachRhev=rhevs[k];
								if (selectedRhevMgr.equalsIgnoreCase(eachRhev))
								{
									selected = "selected";
								}
%>
											<option value="<%=eachRhev%>" <%=selected%>><%=eachRhev%></option>
<%
							}
						}
						else
						{
							if (!selectedRhevMgr.equalsIgnoreCase("none"))
							{
%>
											<option value="<%=selectedRhevMgr%>" selected><%=selectedRhevMgr%></option>
<%
							}
						}
%>
%>
											<option value='Other'><egui:intnl text="admin.test.Other"/></option>
										</select>
									</td>
									<td id="formtop_border">&nbsp;</td>
								</tr>
<%
					}
					/////////RHEV - Ends
					else if (paramName.equalsIgnoreCase("virtual_center"))
					{
						String selectedVirtualCenter = paramValue;
						if (testName.equals(previousTestName))
						{
							selectedVirtualCenter = request.getParameter(paramName);
						}
						selectedVirtualCenter = (selectedVirtualCenter!=null)?selectedVirtualCenter:paramValue;
%>
									<td height="30" id="formtop_border">
										<select name="<%=paramName%>" size="1" style="width:150px;"
										onchange="javascript:changeVirtualCenterValue(this.value);" id="<%=paramName%>">
											<option value='None'><egui:intnl text="admin.test.None"/></option>
<%
						if (virtualCenters != null && virtualCenters.length > 0)
						{
							for (int k=0;k<virtualCenters.length;k++)
							{
								String selected = "";
								String eachVirtualCenter=virtualCenters[k];
								if (selectedVirtualCenter.equalsIgnoreCase(eachVirtualCenter))
								{
									selected = "selected";
								}
%>
											<option value="<%=eachVirtualCenter%>" <%=selected%>><%=eachVirtualCenter%></option>
<%
							}
						}
						else
						{
							if (!selectedVirtualCenter.equalsIgnoreCase("none"))
							{
%>
											<option value="<%=selectedVirtualCenter%>" selected><%=selectedVirtualCenter%></option>
<%
							}
						}
%>
%>
											<option value='Other'><egui:intnl text="admin.test.Other"/></option>
										</select>
									</td>
									<td id="formtop_border">&nbsp;</td>
								</tr>
<%
					}
					else if (paramName.equalsIgnoreCase("management_server"))
					{
						String selectedHMC = paramValue;
						if (testName.equals(previousTestName))
						{
							selectedHMC = request.getParameter(paramName);
						}
						selectedHMC = (selectedHMC!=null)?selectedHMC:paramValue;

						boolean showTextBox = false;
						String strIsManagedByChanged = request.getParameter("isManagedByChanged");
						if (strIsManagedByChanged == null)
						{
							if (resIsManagedByValue.equalsIgnoreCase("ivm"))
							{
								showTextBox = true;
							}
						}
						else if (strIsManagedByChanged != null && strIsManagedByChanged.equalsIgnoreCase("true"))
						{
							String tempManagedBy = request.getParameter("is_managed_by");
							String tempMgmtServerVal = (String)request.getAttribute("management_server");
							if (tempMgmtServerVal != null)
							{
								paramValue = tempMgmtServerVal;
							}

							if (tempManagedBy != null && tempManagedBy.equalsIgnoreCase("ivm"))
							{
								showTextBox = true;
							}
						}

						if (showTextBox)
						{
%>
								<td height="30" id="formtop_border">
									<input type="text" name="<%=paramName%>" id="<%=paramName%>" value="<%=paramValue%>">
								</td>
<%
						}
						else
						{
							String noneSelected = "";
							String otherSelected = "";
							if (selectedHMC.equalsIgnoreCase("none"))
							{
								noneSelected = "selected";
							}
							else if (selectedHMC.equalsIgnoreCase("other"))
							{
								otherSelected = "selected";
							}
%>
								<td height="30" id="formtop_border">
									<select name="<%=paramName%>" size="1" style="width:150px;"
									onchange="javascript:changeHMCValue(this.value);" id="<%=paramName%>">
										<option value='None' <%=noneSelected%>><egui:intnl text="admin.test.None"/></option>
<%
							if (hmcs != null && hmcs.length > 0)
							{
								for (int k=0;k<hmcs.length;k++)
								{
									String selected = "";
									String eachHMC=hmcs[k];
									if (selectedHMC.equalsIgnoreCase(eachHMC))
									{
										selected = "selected";
									}
%>
											<option value="<%=eachHMC%>" <%=selected%>><%=eachHMC%></option>
<%
								}
							}
							else
							{
								if (!selectedHMC.equalsIgnoreCase("none"))
								{
%>
											<option value="<%=selectedHMC%>" selected><%=selectedHMC%></option>
<%
								}
							}
%>
										<option value='Other' <%=otherSelected%>><egui:intnl text="admin.test.Other"/></option>
									</select>
								</td>
<%
						}
%>
								<td id="formtop_border">&nbsp;</td>
							</tr>
<%
					}
					else if (paramName.equalsIgnoreCase("executiontime"))
					{
						String selectedOption = "";
						if (testName.equals(previousTestName))
						{
							selectedOption = request.getParameter(paramName);
							selectedOption = (selectedOption != null && selectedOption.length() > 0)?selectedOption:"";
						}
						String hourlySelected = "";
						String dailySelected = "";
						if (selectedOption.equals("") && paramValue.equalsIgnoreCase("hourly"))
						{
							hourlySelected = "selected";
						}
						else if(!selectedOption.equals("") && selectedOption.equalsIgnoreCase("hourly"))
						{
							hourlySelected = "selected";
						}
						else
						{
							dailySelected = "selected";
						}

						ArrayList hours = new ArrayList();
						for (int m=0;m<24;m++)
						{
							if (m < 10)
							{
								hours.add("0"+String.valueOf(m));
							}
							else
							{
								hours.add(String.valueOf(m));
							}
						}

						ArrayList minutes = new ArrayList();
						for (int m=0;m<60;m++)
						{
							if (m < 10)
							{
								minutes.add("0"+String.valueOf(m));
							}
							else
							{
								minutes.add(String.valueOf(m));
							}
						}
%>
					<td height="30" id="formtop_border">
						<select name="<%=paramName%>" size="1" style="width:70px;" onchange="javascript:changeExecutiontime(this.value);" id="<%=paramName%>">
							<option value="hourly" <%=hourlySelected%>><egui:intnl text="admin.test.Hourly"/></option>
							<option value="daily" <%=dailySelected%>><egui:intnl text="admin.test.Daily"/></option>
						</select>
<%
						if (dailySelected.equals("selected"))
						{
							if (!(paramValue.indexOf(":")>-1)) paramValue="00:00";
							String selectedHr = paramValue.substring(0,paramValue.indexOf(":"));
							String selectedMin = paramValue.substring(paramValue.indexOf(":")+1,paramValue.length());
%>
						&nbsp;&nbsp;Hrs&nbsp;:&nbsp;
						<select name="hours" size="1"  width="100" style="width:40px;" id="<%=paramName%>">
<%
							for (int m=0;m<hours.size();m++)
							{
								String hrs = ((String)hours.get(m)).trim();
								if (selectedHr.equals(hrs))
								{
%>
									<option value=<%=hrs%> selected><%=hrs%></option>
<%
								}
								else
								{
%>
									<option value=<%=hrs%>><%=hrs%></option>
<%
								}
							}
%>
						</select>
						&nbsp;&nbsp;Mins&nbsp;:&nbsp;
						<select name="minutes" size="1"  width="100" style="width:40px;" id="<%=paramName%>">
<%
							for (int m=0;m<minutes.size();m++)
							{
								String mins = ((String)minutes.get(m)).trim();
								if (selectedMin.equals(mins))
								{
%>
							<option value=<%=mins%> selected><%=mins%></option>
<%
								}
								else
								{
%>
							<option value=<%=mins%>><%=mins%></option>
<%
								}
							}
%>
						</select>
<%
						}
%>
					</td>
					<td id="formtop_border">&nbsp;</td>
				</tr>
<%
					}
					else if (paramName.equalsIgnoreCase("Inside_view_using"))
					{
						String exeSelected = "";
						String tcpSelected = "";
						if (paramValue.equalsIgnoreCase("exe"))
						{
							exeSelected = "selected";
						}
						else if(paramValue.equalsIgnoreCase("tcp") || paramValue.equalsIgnoreCase("wmi"))
						{
							tcpSelected = "selected";
						}
%>
					<td height="30" id="formtop_border">
						<select name="<%=paramName%>" id="<%=paramName%>" onchange="javascript:InsideViewChange(this.value);">
							<option value="exe" <%=exeSelected%>><egui:intnl text="admin.test.Netbios (Windows)"/></option>
							<option value="tcp" <%=tcpSelected%>><egui:intnl text="admin.test.TCP/WMI (Windows)"/></option>
						</select>
					</td>
					<td id="formtop_border">&nbsp;</td>
				</tr>
<%
					}
					else if (paramName.equalsIgnoreCase("is_managed_by"))
					{
						String hmcSelected = "";
						String ivmSelected = "";
						if (testName.equals(previousTestName))
						{
							String strManagedBy = request.getParameter(paramName);
							if (strManagedBy != null)
							{
								paramValue = strManagedBy;
							}
						}

						if (paramValue.equalsIgnoreCase("hmc"))
						{
							hmcSelected = "selected";
						}
						else if(paramValue.equalsIgnoreCase("ivm"))
						{
							ivmSelected = "selected";
						}
%>
								<td height="30" id="formtop_border">
									<select name="<%=paramName%>" id="<%=paramName%>" onchange="javascript:changeIsManagedValue();">
										<option value="hmc" <%=hmcSelected%>><egui:intnl text="admin.test.HMC"/></option>
										<option value="ivm" <%=ivmSelected%>><egui:intnl text="admin.test.IVM"/></option>
									</select>
								</td>
								<td id="formtop_border">&nbsp;</td>
							</tr>
<%
					}
					else
					{
%>
					<td height="30" id="formtop_border">
						<select name="<%=paramName%>" id="<%=paramName%>">
							<option value=<%=paramValue%> selected><%=paramValue%></option>
						</select>
					</td>
					<td id="formtop_border">&nbsp;</td>
				</tr>
<%
					}
				}
			}
			else if (displayControl.equalsIgnoreCase("password"))
			{
				if (isSnmp)
				{
					String tempValue = paramValue;
					String strVal = null;
					if (testName.equals(previousTestName))
					{
						strVal = request.getParameter(paramName);
					}
					paramValue = (strVal==null)?tempValue:strVal;
				}
				else if (paramName.equalsIgnoreCase("management_password"))
				{
					String strIsManagedByChanged = request.getParameter("isManagedByChanged");
					if (strIsManagedByChanged != null && strIsManagedByChanged.equals("true"))
					{
						String tempPassValue = (String)request.getAttribute("management_password");
						if (tempPassValue != null)
						{
							paramValue = tempPassValue;
						}
					}
				}

				if(paramValue.indexOf("|") > -1)
				{
					String tempStrs = "";
					StringTokenizer st1 = new StringTokenizer(paramValue,"|");
					while(st1.hasMoreTokens())
					{
						tempStrs += EgCrypt.decrypt(st1.nextToken()) + "#~#";
					}
					paramValue = tempStrs.substring(0, tempStrs.length()-3);
				}
				else
				{
					paramValue = EgCrypt.decrypt(paramValue);
				}

				if (paramValue.indexOf("\"") > -1)
				{
					paramValue = StringUtils.replace(paramValue,"\"","&#34;");
				}

				if (readOnlyParamIdx > -1 && multiUserMode && hasMultipleUsers)
				{
					readOnly = "readOnly";
				}
				if (readOnlyParamIdx > -1 && multiNamePatternMode && hasMultipleNames)
				{
					readOnly = "readOnly";
				}

				if (multiUserMode)
				{
%>
					<td id="formtop_border"><input type="password" id="<%=paramName%>" name="<%=paramName%>" value="<%=paramValue%>"<%=readOnly%> onblur="javascript:checkHashTildeHash()"></td>
					<td id="formtop_border">&nbsp;</td>
				</tr>
<%
				}
				else
				{
%>
					<td id="formtop_border"><input type="password" id="<%=paramName%>" name="<%=paramName%>" value="<%=paramValue%>"></td>
					<td id="formtop_border">&nbsp;</td>
				</tr>
<%
				}

				if (!readOnly.equals("readOnly"))
				{
%>
				<tr>
					<td id="formtop_border">
<%
					if (showStar)
					{
%>
						<font color='black'>&nbsp;&nbsp;*&nbsp;</font>
<%
					}
					else
					{
%>
						&nbsp;&nbsp;
<%
					}
%>
					</td>
					<td id="formtop_border">CONFIRM PASSWORD</td>
					<td id="formtop_border">:</td>
					<td id="formtop_border"><input type="password" id="<%=paramName+"confirmpassword"%>" name="<%=paramName+"confirmpassword"%>" value="<%=paramValue%>"></td>
					<td id="formtop_border">&nbsp;</td>
				</tr>
<%
				}
			}
			else if (displayControl.equalsIgnoreCase("textarea"))
			{
				String temp = paramValue;
				String strVal = null;
				if (testName.equals(previousTestName))
				{
					strVal = request.getParameter(paramName);
				}
				paramValue = (strVal==null)?temp:strVal;

				if (testInfoDelimiter.length() > 0 && paramValue.indexOf(testInfoDelimiter) > -1)
				{
					paramValue = StringUtils.replace(paramValue, testInfoDelimiter, EgConstants.COMMA);
				}
				else if (paramValue.indexOf(EgConstants.PIPE) > -1)
				{
					paramValue = StringUtils.replace(paramValue, EgConstants.PIPE, EgConstants.COMMA);
				}
				if (strDelimiterMask.length() > 0 && paramValue.indexOf(strDelimiterMask) != -1)
				{
					paramValue = StringUtils.replace(paramValue,strDelimiterMask,testInfoDelimiter);
				}
%>
					<td height="30" id="formtop_border" class="eg_subcontent"><textarea name="<%=paramName%>" id="<%=paramName%>" rows="10" cols="55"><%=paramValue%></textarea>
<%
				if ((paramName.equalsIgnoreCase("process") || paramName.equalsIgnoreCase("serviceName")) && paramValue.equalsIgnoreCase("(EG_RUNTIME)"))
				{
%>
					&nbsp;<input type="button" name="os_pattern" value='<egui:intnl text="admin.common.Configure"/>' class="eg_lightbutton" onclick="javascript:configureOSPattern('<%=componentType%>','<%=testName%>','<%=paramName%>');" style="width:70px">
<%
				}
%>
					</td>
					<td id="formtop_border">&nbsp;</td>
				</tr>
<%
			}
			else
			{
				if (isSnmp || isPolicyParamExists || isUrlParamExist || isWsdlUrlExist || paramName.equalsIgnoreCase("real_ServerName"))
				{
					String tempValue = paramValue;
					String strVal = null;
					if (testName.equals(previousTestName))
					{
						strVal = request.getParameter(paramName);
					}
					paramValue = (strVal==null)?tempValue:strVal;
				}

				if(paramName.equalsIgnoreCase("url"))
				{
					if (isCredentialParamExist)
					{
						previousUrl = (previousUrl == null)?"":previousUrl;
						if (previousUrl.equals(paramValue))
						{
							paramValue = EgURLDecoder.decode(paramValue.trim(),"UTF-8");
						}

						if(paramValue.indexOf("|") > -1)
						{
							paramValue = StringUtils.replace(paramValue,"|",",");
						}

						if (paramValue.indexOf("~egHash~") > -1)
						{
							paramValue = StringUtils.replace(paramValue,"~egHash~","#");
						}
%>
					<td id="formtop_border">
						<table cellpadding="0" cellspacing="0" border="0">
							<tr>
								<td><input type="text" name="<%=paramName%>" id="<%=paramName%>" value="<%=paramValue%>" onblur="javascript:checkURLAndCredentials('<%=paramValue%>');"></td>
								<td valign="middle" align="center">
									&nbsp;&nbsp;<img src="/final/admin/eg_images/plus.gif" title="Click here to view/configure URL and credentials" class="leftmouse" onClick="config_popup('./EgConfigureUrlAndCredentials.jsp?server=<%=componentType%>&test=<%=testName%>&port=<%=isPortRelevantForTest%>&isPrivateKeyParamExist=<%=isPrivateKeyParamExist%>','','scrollbars=yes,width=900,height=500,top=150,left=50')">
								</td>
							</tr>
						</table>
					</td>
					<td id="formtop_border">&nbsp;</td>
<%
					}
					else
					{
						paramValue = EgURLDecoder.decode(paramValue.trim(),"UTF-8");
%>
					<td id="formtop_border"><input type="text" name="<%=paramName%>" id="<%=paramName%>" value="<%=paramValue%>">&nbsp;&nbsp;<input type="button" name ="viewurl" class="eg_lightbutton" value='<egui:intnl text="admin.common.View"/>' onClick="javascript:openSmallWindow('<%= paramName %>')" ></td>
					<td id="formtop_border">&nbsp;</td>
<%
					}
%>
				</tr>
<%
				}
				else if(paramName.equalsIgnoreCase("WSDL_URL"))
				{
					if (isCredentialParamExist)
					{
						previousUrl = (previousUrl == null)?"":previousUrl;
						if (previousUrl.equals(paramValue))
						{
							paramValue = EgURLDecoder.decode(paramValue.trim(),"UTF-8");
						}

						if(paramValue.indexOf("|") > -1)
						{
							paramValue = StringUtils.replace(paramValue,"|",",");
						}

						if (paramValue.indexOf("~egHash~") > -1)
						{
							paramValue = StringUtils.replace(paramValue,"~egHash~","#");
						}
%>
					<td id="formtop_border">
						<table cellpadding="0" cellspacing="0" border="0">
							<tr>
								<td><input type="text" name="<%=paramName%>" id="<%=paramName%>" value="<%=paramValue%>" onblur="javascript:checkURLAndCredentials('<%=paramValue%>');"></td>
								<td valign="middle" align="center">
									&nbsp;&nbsp;<img src="/final/admin/eg_images/plus.gif" title="Click here to view/configure URL and credentials" class="leftmouse" onClick="config_popup('./EgConfigureWsdlUrlAndCredentials.jsp?server=<%=componentType%>&test=<%=testName%>&port=<%=isPortRelevantForTest%>','','scrollbars=yes,width=900,height=500,top=150,left=50')">
								</td>
							</tr>
						</table>
					</td>
					<td id="formtop_border">&nbsp;</td>
<%
					}
					else
					{
						paramValue = EgURLDecoder.decode(paramValue.trim(),"UTF-8");
%>
					<td id="formtop_border"><input type="text" name="<%=paramName%>" id="<%=paramName%>" value="<%=paramValue%>">&nbsp;&nbsp;<input type="button" name ="viewurl" class="eg_lightbutton" value='<egui:intnl text="admin.common.View"/>' onClick="javascript:openSmallWindow('<%= paramName %>')" ></td>
					<td id="formtop_border">&nbsp;</td>
<%
					}
%>
				</tr>
<%
				}
				else if (paramName.equalsIgnoreCase("management_user"))
				{
					String strIsManagedByChanged = request.getParameter("isManagedByChanged");
					if (strIsManagedByChanged == null)
					{
%>
								<td id="formtop_border"><input type="text" name="<%=paramName%>" id="<%=paramName%>" value="<%=paramValue%>"></td>
								<td id="formtop_border">
								&nbsp;</td>
							</tr>
<%
					}
					else
					{
						String tempUser = (String)request.getAttribute("management_user");
						if (tempUser != null)
						{
							paramValue = tempUser;
						}
%>
								<td id="formtop_border"><input type="text" name="<%=paramName%>" id="<%=paramName%>" value="<%=paramValue%>"></td>
								<td id="formtop_border">
								&nbsp;</td>
							</tr>
<%
					}
				}
				else if(paramName.equalsIgnoreCase("Target_DiskIO_Rate"))
				{
					String tempTargetDiskIORate = "";
					String tempTargetDiskIORateValue = "";

					if (paramValue.equalsIgnoreCase("$unconfigured"))
					{
						tempTargetDiskIORateValue = paramValue;
					}
					else
					{
						tempTargetDiskIORate = paramValue.substring(0,paramValue.indexOf("_"));
						tempTargetDiskIORateValue = paramValue.substring(paramValue.indexOf("_")+1,paramValue.length());
						paramValue = tempTargetDiskIORateValue;
					}
%>
								<td id="formtop_border">
								<select name="TargetDiskIORate_select" id ="TargetDiskIORate_select" style="width:180px" >&nbsp;
<%
					for (int k=0;k<targetDiskIORateLabel.length;k++)
					{
						String strTargetDiskIORateLabel = targetDiskIORateLabel[k];
						String strTargetDiskIORateValue = targetDiskIORateValue[k];
						if (strTargetDiskIORateValue.equalsIgnoreCase(tempTargetDiskIORate))
						{
%>
							<option value="<%=strTargetDiskIORateValue%>" selected><%=strTargetDiskIORateLabel%></option>
<%
						}
						else
						{
%>
							<option value="<%=strTargetDiskIORateValue%>"><%=strTargetDiskIORateLabel%></option>
<%
						}
					}
%>
								</select>
								<input type="text" name="<%=paramName%>" id="<%=paramName%>" value="<%=paramValue%>"></td>
								<td id="formtop_border">
								&nbsp;</td>
							</tr>
<%
				}
				else if (testName.equalsIgnoreCase("WindowshareTest") && 
					paramName.equalsIgnoreCase("sharename"))
				{
					if (paramValue.indexOf("|") > -1)
					{
						paramValue = StringUtils.replace(paramValue,"|",",");
					}
%>
								<td id="formtop_border"><a href = "javascript:void(0)" onClick="config_popup('./EgConfigureWinSharedFolders.jsp?server=<%=componentType%>&test=<%=testName%>&port=<%=isPortRelevantForTest%>','','scrollbars=yes,width=900,height=500,top=150,left=50')" class="eg_monlink"><egui:intnl text="admin.test.To view/configure shared folders for monitoring"/>,&nbsp;<b><egui:intnl text="admin.common.click here"/></b>&nbsp;<img src="/final/admin/eg_images/icon_click.gif" border="0"></a></td>
								<td id="formtop_border">&nbsp;</td>
							</tr>
							<input type="hidden" name="<%=paramName%>" id="<%=paramName%>" value='<%=paramValue%>'>
<%
				}
				else
				{
					String destinationPage = "";
					String plusButton = "";
					String onBlurStr  = "";
					String onFocusStr = "";
					String onChangeStr = "";
					if (multiUserMode && readOnlyParamIdx>-1)
					{
						if (hasMultipleUsers)
						{
							readOnly = "readOnly";
						}
						if (paramName.equalsIgnoreCase("user"))
						{
							destinationPage = "EgConfigureMultipleUsers.jsp";
						}
						else
						{
							destinationPage = "VmgUsers.jsp";
						}
						if (paramName.equalsIgnoreCase("admin_user") || paramName.equalsIgnoreCase("user"))
						{
							plusButton = "<img src=\"/final/admin/eg_images/plus.gif\" title=\"Click here to configure user(s)\" class=\"leftmouse\" onClick=\"config_popup(\'./"+destinationPage+"?server="+componentType+"&test="+testName+"&port="+isPortRelevantForTest+"&compname=\',\'\',\'scrollbars=yes,width=900,height=380,top=150,left=50\')\">";

						}
						onBlurStr =  "javascript:checkMultipleUser('"+paramName+"','"+paramValue+"')";
						onFocusStr = "javascript:getUserValue('"+paramName+"')"; 
						onChangeStr = "javascript:getUserChangedValue('"+paramName+"')";
					}
					if (multiNamePatternMode && readOnlyParamIdx>-1)
					{
						if (hasMultipleNames)
						{
							readOnly = "readOnly";
						}
						if (paramName.equalsIgnoreCase("name"))
						{
							destinationPage = "EgConfigureNamePattern.jsp";
							plusButton = "<img src=\"/final/admin/eg_images/plus.gif\" title=\"Click here to configure url pattern(s)\" class=\"leftmouse\" onClick=\"config_popup(\'./"+destinationPage+"?server="+componentType+"&test="+testName+"&port="+isPortRelevantForTest+"&compname=\',\'\',\'scrollbars=yes,width=900,height=380,top=150,left=50\')\">";
						}
						
						onBlurStr =  "javascript:checkMultipleNamePattern('"+paramName+"','"+paramValue+"')";
						onFocusStr = "javascript:getNamePatternValue('"+paramName+"')"; 
						onChangeStr = "javascript:getNamePatternChangedValue('"+paramName+"')";
					}

					if(paramValue.indexOf("|") > -1)
					{
						paramValue = StringUtils.replace(paramValue,"|",",");
					}
					if (paramValue.indexOf("~#~") > -1)
					{
						paramValue = StringUtils.replace(paramValue,"~#~",";");
					}

					if (multiUserMode || multiNamePatternMode)
					{
						if (readOnlyParamIdx > -1)
						{
%>
					<td id="formtop_border">
						<table cellpadding="0" cellspacing="0" border="0">
							<tr>
								<td><input type="text" name="<%=paramName%>" id="<%=paramName%>" value="<%=paramValue%>"<%=readOnly%> onblur="<%=onBlurStr%>" onfocus="<%=onFocusStr%>" onchange="<%=onChangeStr%>"></td>
								<td valign="middle">&nbsp;<%=plusButton%>
								</td>
							</tr>
						</table>
					</td>
<%
						}
						else
						{
%>
					<td id="formtop_border"><input type="text" name="<%=paramName%>" id="<%=paramName%>" value="<%=paramValue%>">
<%
							if (paramValue.length() > 20 && readOnly.equals(""))
							{
%>
					&nbsp;<input type="button" class="eg_lightbutton" value='<egui:intnl text="admin.common.View"/>' onClick="javascript:openSmallWindow('<%=paramName%>')">
<%
							}
						}
%>
					</td>
					<td id="formtop_border">&nbsp;</td>
				</tr>
<%
					}
					else
					{
%>
					<td id="formtop_border"><input type="text" name="<%=paramName%>" id="<%=paramName%>" value="<%=paramValue%>">
<%
						if (paramValue.length() > 20)
						{
%>
					&nbsp;<input type="button" class="eg_lightbutton" value='<egui:intnl text="admin.common.View"/>' onClick="javascript:openSmallWindow('<%=paramName%>')">
<%
						}
%>
					</td>
					<td id="formtop_border">&nbsp;</td>
				</tr>
<%
					}
				}
			}
		}

		session.setAttribute("aListParamNamesValues",aListParamNamesValues);
		session.setAttribute("aListDisplay",aListDisplay);
		session.setAttribute("aListParamsWithDoubleQuotes",aListParamsWithDoubleQuotes);
		session.setAttribute("isOldSnmp",new Boolean(isOldSnmp));
%>
				<tr>
					<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
					<td id="eg_subcontentbg" colspan="3" valign="top"><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
					<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
				</tr>
				<tr>
					<td colspan="5" id="eg_blankspace" height="10" class="eg_whitebg">&nbsp;</td>
				</tr>
				<tr>
					<td colspan="5" align="center" id="eg_whitebg">
						<input type="button" value='<egui:intnl text="admin.common.Update"/>' name="update" onclick="javascript:populate('<%=testName%>','defaultConfiguration','<%=multiUserMode%>')" class="eg_back">
					</td>
					<input type="hidden" name="allowedParams" value="<%=allowedParams%>">
					<input type="hidden" name="strTcKeywords" value="<%=strTcKeywords%>">
					<input type="hidden" name="strDoubleQuotesParams" value="<%=strDoubleQuotesParams%>">
				</tr>
			</table>
		</td>
	</tr>
<%
	}
%>
</table>
<input type="hidden" name="moreurl" value="">
<input type="hidden" name="urls" value="">
<input type="hidden" name="previousTestType" value="<%=testType%>">
<input type="hidden" name="previousComponentType" value="<%=componentType%>">
<input type="hidden" name="previousTestName" value="<%=testName%>">
<input type="hidden" name="isCredentialParamExist" value="<%=isCredentialParamExist%>">
<input type="hidden" name="delimiter" value="<%=strDelimiter%>">
<input type="hidden" name="delimiterMask" value="<%=strDelimiterMask%>">
</form>
<%
	session.setAttribute("adminLastAccessedURL","/final/admin/EgConfigureDefaultTestParams.jsp?componentType="+EgURLEncoder.encode(componentType,"UTF-8")+"&previousComponentType="+EgURLEncoder.encode(previousComponentType,"UTF-8")+"&testType="+testType+"&previousTestType="+testType+"&testName="+EgURLEncoder.encode(testName,"UTF-8"));

	//used for help page support.when data.jsp is clicked
	aListPages.add("/final/admin/EgConfigureDefaultTestParams.jsp?componentType="+EgURLEncoder.encode(componentType,"UTF-8")+"&previousComponentType="+EgURLEncoder.encode(previousComponentType,"UTF-8")+"&testType="+testType+"&previousTestType="+testType+"&testName="+EgURLEncoder.encode(testName,"UTF-8"));
	if (aListPages.size() > 2)
	{
		aListPages.remove(0);
	}
	session.setAttribute("aListPages",aListPages);
%>
</body>
</html>



