<%
/**
 *  File         : 	EgConfigThresh.jsp
 *  Purpose      : 	To configure thresholds  
 *  Version      : 	0.0
 *  Creation Date: 	21/11/2000
 *  Last Modified:
 *			04/03/2006	Thirumal Azhagan.T	UI changes for MIX policy.
 *			27/06/2005  Thirumal Azhagan.T
 *			23/07/2004	Arun	Allows factors of SQC to be set for relative thresholds
 *			21/07/2004	Arun	Optimise use of EgThresholdInfo, allows SQC to have factors
			15/07/2004	Arun	Multiple thresholds were not allowed to have decimal values
			12/01/2004	Arun	Removes :NULL from server names, Fixed missing "(default)"
			29/12/2003 //Saravanan - Priority display names taken from ui.ini
			11/12/2003 //Saravanan - Medium priority Added for Single thresholds
			28/10/2003 //Saravanan - Multiple threshold changes
			18/06/2001 //Sandhya - To check for space in absolute values	
			11/06/2001 // kk to check validity of numbers.
			08/12/2000  //Sandhya.K
 *  Author       :	Lavanya.T.K 
 *	Design Changes	:	Jaiwin.
 */
%>

<%@ include file="EgTrackerA.jsp" %>
<%@ page errorPage="EgProbs.jsp"%>
<%@ page import="com.eg.EgSpecsInfo" %>
<%@ page import="com.eg.EgThresholdInfo" %>
<%@ page import="com.eg.EgTesterInfo" %>
<%@ page import="com.eg.EgURLEncoder" %>
<%@ page import="com.egurkha.ini.*" %>
<%@ page import="com.egurkha.util.*" %>
<%@ page import="java.sql.*" %>
<%@ page import="java.util.*" %>
<%@ page import="com.eg.EgServerGroupBean" %>
<%@ page import="com.eg.EgServicesInfo"%>
<%@ page import="com.eg.EgExternalInfo"%>
<%@ page import="com.eg.IniFile"%>
<%@ page import="com.eg.EgRoleInfo" %>
<%@ page import = "com.egurkha.util.EgStackForBackButton"%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	request.setCharacterEncoding("UTF-8");
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>

<%
	EgRoleInfo ri=EgRoleInfo.getInstance(session.getId(),(String)session.getAttribute("sess_userid"));//by JJ
	boolean allPermission=ri.hasAllComponentAccess();//by James Thomas
%>

<jsp:useBean id="topo" scope="page" class="egurkha.ConfigTopology"/>
<jsp:useBean id="prgBean" scope="page" class="egurkha.EgTestParamBean"/>

<%!
	EgSpecsInfo egSpecs = new EgSpecsInfo("manager");
	EgThresholdInfo egThresh = new EgThresholdInfo("manager");
	EgExternalInfo extInfo = new EgExternalInfo("manager");
	EgTesterInfo testerInfo=new EgTesterInfo("manager");
	Hashtable hash = extInfo.getInternalAgentMap();

	// Variable declarations
	String testName = "";
	String q_ctr = "";
	String serverName = "";
	String temp = "";
	String strTok = "";
	String strToken = "";
	String strExServer = "";
	String strIniVal = null;
	String variable = "";
	String str_comp_name = "";
	String measure = "";
	String policy = "";
	String min = "";
	String max = "";
	//String minimum = "";
	//String maximum = "";

	//thirumal3/4/2006
	String absA = "";
	String absB = "";
	String relA = "";
	String relB = "";
	String absoluteA = "";
	String absoluteB = "";
	String relativeA = "";
	String relativeB = "";

	//String priority = "";
	String alarmString = "";
	String junk = "";
	String alarmpolicy = "";
	String prior = "";
	String pol = "";
	String wholeStr = "";
	String alarm_type="";
	String alarm="";
	String str_comp_type = "";

	StringTokenizer st = null;
	StringTokenizer st1 = null;
	StringTokenizer st2 = null;

	int count=0;
	int stCount=0;

	Vector vecHost = new Vector();
	Vector v_abs = new Vector();
	Vector v_temp = new Vector();
	//Vector vecTestNoPort = new Vector();

	String ComponentsList[];
	String AllComp[];
	String userThreshVal[];
	String userThresh[];
	String[] threshPol = new String[] {"absolute", "relative", "none"};

	IniUI ui = (IniUI)com.egurkha.ini.IniUI.getInstance();
	String[] priorArr = new String[]{ui.getStateDisplayLabel("LOW"),ui.getStateDisplayLabel("INTERMEDIATE"),ui.getStateDisplayLabel("HIGH")};
%>

<%
	// code for dbOptimization - Thirumal
	EgServicesInfo egserInfo = new EgServicesInfo("manager");
	boolean uniqueHostSystemData = egserInfo.isUniqueHostSystemData();
	com.eg.IniFile servicesIniFile = new com.eg.IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_services.ini");
	String updateSpecificThreshToDb = servicesIniFile.getValue("MISC_ARGS","updateSpecificThreshToDb");
	EgServerGroupBean descGrp = new EgServerGroupBean(); //TA
	vecHost = new Vector(); // Srinivas
	String val = "";

	String threshInfo = request.getParameter("threshinfo");
	if (threshInfo != null)
	{
		if (threshInfo.indexOf("0eGHash1") > -1)
		{
			threshInfo=com.egurkha.util.StringUtils.replace(threshInfo,"0eGHash1","#");
		}
	}
	
	String serverType = request.getParameter("server");	//Thirumal
	String click1=request.getParameter("click1");
	session.setAttribute("TestName",request.getParameter("t_name"));
	String test=request.getParameter("t_name");
	session.setAttribute("ServerType",serverType);
	String value=request.getParameter("value");
	// user Threshold - Thirumal 11/11/2005
	String configInfo = (String) request.getParameter("configInfo");
	String conf = (String) request.getParameter("conf");
	if (conf != null)
		session.setAttribute("conf",conf);
	// user threshold ends here
	List defaultPolicies=new ArrayList();
	defaultPolicies.add("immediate");
	defaultPolicies.add("shortterm");
	defaultPolicies.add("standard");
	defaultPolicies.add("longterm");

	Enumeration e = request.getParameterNames();
	if(e.hasMoreElements())
	{
		testName = request.getParameter("t_name");
		q_ctr = request.getParameter("qctr");
		serverName = serverType;
	}

	if(q_ctr.equals("1"))
	{
		str_comp_type=request.getParameter("comptype");
		str_comp_name=request.getParameter("compname");
	}
	
	topo.createFile("eg_discover.ini");
	Vector v_components = new Vector();
	Vector v_mappedAgent = new Vector();
	Vector hostSysTests = new Vector();
	String t[] = egSpecs.getTestsForServer ("Host_system");
	if (t != null)
	{
		for (int i=0; i<t.length; i++)
		hostSysTests.add(t[i]);
	}
	
	EgRoleInfo roleInfo=EgRoleInfo.getInstance(session.getId(),(String)session.getAttribute("sess_userid"));//by JJ
	AllComp=roleInfo.getAllServersOfType(serverName);
	for(int i=0;i<AllComp.length;i++)
		v_components.add(AllComp[i]);

	if (uniqueHostSystemData  && hostSysTests.contains(testName))
	{
		for(int x=0;x<v_components.size();x++)
		{
			String Host = (String) v_components.get(x);
			StringTokenizer stok = new StringTokenizer(Host,":");
			int countTok = stok.countTokens();
			if (countTok < 2)
				continue;
			if(Host.startsWith("Format:"))
				continue;
			stok.nextToken();
			String Compnt = stok.nextToken().trim();
			if (hash.containsKey(Compnt))
			{
				v_components.removeElementAt(x);
				x--;
			}
		}
		String [] a_size  = new String[v_components.size()];
		ComponentsList = (String[]) v_components.toArray(a_size);
	}
	else
	{
		//ComponentsList=topo.getVariables(serverName);
		ComponentsList=roleInfo.getAllServersOfType(serverName);
	}

	String Comp = request.getParameter("compname");
	// added by Thirumal for user threshold
	boolean all = false;
	if (Comp != null && !Comp.equals(""))
	{
		int ind = Comp.indexOf("(default)");
		if(ind > 0)
		{
			Comp = Comp.substring(0,ind);
		}

		boolean b = egSpecs.isPortRelevantForTest(testName);
		Vector s_serverGroup = descGrp.getServerGroup(Comp,testName,b);

		StringBuffer s_buffer = new StringBuffer(128);
		s_buffer.append(testName);
		s_buffer.append(":");
		s_buffer.append(Comp);

		String userThresh = egThresh.getUserThresholdValue(s_buffer.toString());
		Vector vec = egThresh.getInfosForThresholds(testName,Comp);

		// Changed to handle info relevant tests - Thirumal Azhagan 11/18/2005
		if ((vec != null && vec.size() > 0 && s_serverGroup != null && s_serverGroup.size() > 0 && userThresh != null && userThresh.length() > 0) || (s_serverGroup != null && s_serverGroup.size() > 0 && userThresh != null && userThresh.length() > 0 && !egSpecs.isInfoRelevantForTest(testName)))
		{
			all = true;
		}
		// ends here

		Vector sess_vec = new Vector();
		String policy = "";
		if(s_serverGroup != null && s_serverGroup.size() > 0 && conf == null && (!all))
		{
			boolean checkk = descGrp.isServerAssociatedToTest(Comp,testName);
			if(checkk)
			{
				String thisGroup = (String) s_serverGroup.get(0);
				policy = descGrp.getPolicyForTest(thisGroup,testName);
				//if (policy == null || policy.equals(""))
				//{
				//	TreeSet ts = descGrp.getManagedInfos(thisGroup,testName);
				//	if (ts != null && ts.size() > 0)
				//	{
				//		Iterator itr = ts.iterator();
				//		while (itr.hasNext())
				//		{
				//			policy += "  "+(String) itr.next()+",";
				//		}
				//	}
				//}
				if (policy != null && policy.length() > 0)
				{
					EgStackForBackButton stackBackPages = (EgStackForBackButton)session.getAttribute("backList");
					String queryStr = "t_name="+test+"&qctr=0&thresh=1&server="+serverType;
					stackBackPages.updateQueryStrForURL("/final/admin/EgConfigThresh.jsp",queryStr);
					if (policy.indexOf(",") > -1)
					{
						policy = policy.substring(0,policy.lastIndexOf(","));
					}

					sess_vec.add(" click here ");
					sess_vec.add("Hi");
					sess_vec.add("Configure threshold rule");
					sess_vec.add(Comp+" is part of server group(s) '"+s_serverGroup +"' and is associated to policy '"+policy+"'.");
					session.putValue("vec_Results",sess_vec);
%>
					<jsp:forward page="EgConfigResults.jsp" />
<%
				}
			}
		}
	}
%>

<html>
<head>
<title>Configure Thresholds For Tests</title>
<egui:skin ui="admin"/>
<script language="JavaScript" src="eg_scripts/validate.js"></script>
<script language="JavaScript1.2" src="../scripts/<%=script_src%>"></script>
<script language="JavaScript">

function check(fieldvalue)
{
	var dot_count = 0;
	var slash_count = 0;

	s_val = fieldvalue;
	for(var i=0;i < s_val.length;i++)
	{
		if(s_val.charAt(i) == '.')
		{
			dot_count = dot_count + 1;
		}
		else if (s_val.charAt(i) == '/')
		{
			slash_count++;
		}
		else
		{
			continue;
		}
	}

	if(dot_count > 1 && slash_count != 2)
	{
		alert('<egui:intnl text="admin.threshold.Invalid number"/>.');
		return false;
	}

	if(s_val.charAt(s_val.length - 1) == '.')
	{
		alert('<egui:intnl text="admin.threshold.Invalid number"/>.');
		return false;
	}
	
	return true;
}

//validation for space
function checkspace(fieldvalue)
{
	s_val = fieldvalue;
	for(count = 0; count < s_val.length; count++)
	{
		if(s_val.charAt(count) == ' ')
		{
			alert('<egui:intnl text="admin.threshold.Space not allowed"/>.');
			return false;
		}
	}
	return true;
}

function populate1()
{
	var comp1 = document.threshconfig.compname.value;
	var server = document.threshconfig.server.value;
	var comp;
	if(comp1.indexOf("(default)") > 0)
		comp = server+":"+comp1.substring(0,comp1.indexOf("(default)"));
	else
		comp = server+":"+comp1;
	var test = document.threshconfig.t_name.value;
	if(comp.indexOf(":") == comp.lastIndexOf(":"))
		comp = comp + ":NULL";
	var str = "EgUpdateInfo.jsp?server="+encodeURI(server)+"&comp="+ encodeURI(comp)+"&test="+test+"&qctr=5&tt=1&from=threshinfo";
	
	if (isNetscape()) targetObj = document.threshconfig.ref;
	if (isIE()) targetObj = document.threshconfig.ref;
	targetObj.disabled = true;
	
	window.location.href= str;
}

function isNetscape() 
{
	// get browser info. 
	appName= navigator.appName;
	appLongVer = navigator.appVersion;
	appVer = appLongVer.substring(0, 1); 

	// check for Navigator ver 4+. 
	if ((appName == "Netscape") && (appVer >= 4)) return true;
	return false;
}

function isIE() 
{
	// get browser info. 
	appName= navigator.appName;
	appLongVer = navigator.appVersion;
	appVer = appLongVer.substring(0, 1); 

	// check for IE ver 4+. 
	if ((appName == "Microsoft Internet Explorer") && (appVer >= 4)) return true;
	return false;
}

function populateNEW(count)
{
	var res = true;
	var num = document.threshconfig.measNo.value;

	for(var i=0; i < num; i++)
	{
		var absA = "absA"+i;
		var absB = "absB"+i;
		var relA = "relA"+i;
		var relB = "relB"+i;

		var absoluteA = document.threshconfig[absA].value;
		var absoluteB = document.threshconfig[absB].value;
		var relativeA = document.threshconfig[relA].value;
		var relativeB = document.threshconfig[relB].value;

		// Negative value check
		var description = document.getElementById("ANV"+i).value;
		var arr = description.split(":");
		var measurement = arr[0];
		var isNegativeValuesAllowed = arr[1];

		// Absolute minimum - start
		if(!checkWithRegExp(absoluteA,0))
		{
			alert('<egui:intnl text="admin.threshold.Invalid threshold entry"/>'+".\n"+'<egui:intnl text="admin.threshold.Possible reasons could be"/>'+" : \n"+
			"1) "+'<egui:intnl text="admin.threshold.Threshold values are not set for one/more measures"/>'+".\n"+
			"2) "+"<egui:intnl text='admin.threshold.Threshold specifications are not in the \'Critical/Major/Minor\' format'/>"+".\n"+
			"3) "+'<egui:intnl text="admin.threshold.One/more threshold entries contain special characters"/>'+".");
			document.threshconfig[absA].focus();
			res=false;
			break;
		}

		// Negative value check
		if(isNegativeValuesAllowed == "false")
		{
			if(absoluteA.toLowerCase() != "none" && checkNegativeVal(absoluteA))
			{
				alert("<egui:intnl text='admin.threshold.Absolute minimum'/> <egui:intnl text='admin.threshold.for'/>"+" \'"+measurement+"\' "+"<egui:intnl text='admin.threshold.should not contain negative values'/>.");
				document.threshconfig[absA].focus();
				res=false;
				break;
			}
		}

		//check ascending order
		if(absoluteA.toLowerCase() != "none" && !checkAscendingOrder(absoluteA,0))
		{
			alert('<egui:intnl text="admin.threshold.Absolute Minimum threshold values representing Critical/Major/Minor should be in ascending order"/>');
			document.threshconfig[absA].focus();
			res=false;
			break;
		}
		// end

		//Relative minimum - start
		if(!checkWithRegExp(relativeA,1))
		{
			alert('<egui:intnl text="admin.threshold.Invalid threshold entry"/>'+".\n"+'<egui:intnl text="admin.threshold.Possible reasons could be"/>'+" : \n"+
			"1) "+'<egui:intnl text="admin.threshold.Threshold values are not set for one/more measures"/>'+".\n"+
			"2) "+"<egui:intnl text='admin.threshold.Threshold specifications are not in the \'Critical/Major/Minor\' format'/>"+".\n"+
			"3) "+'<egui:intnl text="admin.threshold.One/more threshold entries contain special characters"/>'+".\n"+
			"4) "+"<egui:intnl text='admin.threshold.Relative threshold specifications are not in \'n1*sqc/n2*sqc/n3*sqc\' format where n1<n2<n3'/>"+".");
			document.threshconfig[relA].focus();
			res=false;
			break;
		}

		// Negative value check
		if(isNegativeValuesAllowed == "false")
		{
			if(relativeA.toLowerCase() != "none" && checkNegativeVal(relativeA))
			{
				alert("<egui:intnl text='admin.threshold.Relative minimum'/> <egui:intnl text='admin.threshold.for'/>"+" \'"+measurement+"\' "+"<egui:intnl text='admin.threshold.should not contain negative values'/>.");
				document.threshconfig[relA].focus();
				res=false;
				break;
			}
		}

		//check ascending order
		if(relativeA.toLowerCase() != "none" && !checkAscendingOrder(relativeA,1))
		{
			alert('<egui:intnl text="admin.threshold.Relative Minimum threshold values representing Critical/Major/Minor should be in ascending order"/>');
			document.threshconfig[relA].focus();
			res=false;
			break;
		}
		//end

		//Absolute maximum -start
		if(!checkWithRegExp(absoluteB,0))
		{
			alert('<egui:intnl text="admin.threshold.Invalid threshold entry"/>'+".\n"+'<egui:intnl text="admin.threshold.Possible reasons could be"/>'+" : \n"+
			"1) "+'<egui:intnl text="admin.threshold.Threshold values are not set for one/more measures"/>'+".\n"+
			"2) "+"<egui:intnl text='admin.threshold.Threshold specifications are not in the \'Critical/Major/Minor\' format'/>"+".\n"+
			"3) "+'<egui:intnl text="admin.threshold.One/more threshold entries contain special characters"/>'+".");
			document.threshconfig[absB].focus();
			res=false;
			break;
		}

		// Negative value check
		if(isNegativeValuesAllowed == "false")
		{
			if(absoluteB.toLowerCase() != "none" && checkNegativeVal(absoluteB))
			{
				alert("<egui:intnl text='admin.threshold.Absolute maximum'/> <egui:intnl text='admin.threshold.for'/>"+" \'"+measurement+"\' "+"<egui:intnl text='admin.threshold.should not contain negative values'/>.");
				document.threshconfig[absB].focus();
				res=false;
				break;
			}
		}

		//check descending order
		if(absoluteB.toLowerCase() != "none" && !checkDescendingOrder(absoluteB,0))
		{
			alert('<egui:intnl text="admin.threshold.Absolute Maximum threshold values representing Critical/Major/Minor should be in descending order"/>');
			document.threshconfig[absB].focus();
			res=false;
			break;
		}
		//end

		//Relative maximum - start
		if(!checkWithRegExp(relativeB,1))
		{
			alert('<egui:intnl text="admin.threshold.Invalid threshold entry"/>'+".\n"+'<egui:intnl text="admin.threshold.Possible reasons could be"/>'+" : \n"+
			"1) "+'<egui:intnl text="admin.threshold.Threshold values are not set for one/more measures"/>'+".\n"+
			"2) "+"<egui:intnl text='admin.threshold.Threshold specifications are not in the \'Critical/Major/Minor\' format'/>"+".\n"+
			"3) "+'<egui:intnl text="admin.threshold.One/more threshold entries contain special characters"/>'+".\n"+
			"4) "+"<egui:intnl text='admin.threshold.Relative threshold specifications are not in \'n1*sqc/n2*sqc/n3*sqc\' format where n1>n2>n3'/>"+".");
			document.threshconfig[relB].focus();
			res=false;
			break;
		}

		// Negative value check
		if(isNegativeValuesAllowed == "false")
		{
			if(relativeB.toLowerCase() != "none" && checkNegativeVal(relativeB))
			{
				alert("<egui:intnl text='admin.threshold.Relative maximum'/> <egui:intnl text='admin.threshold.for'/>"+" \'"+measurement+"\' "+"<egui:intnl text='admin.threshold.should not contain negative values'/>.");
				document.threshconfig[relB].focus();
				res=false;
				break;
			}
		}

		//check descending order
		if(relativeB.toLowerCase() != "none" && !checkDescendingOrder(relativeB,1))
		{
			alert('<egui:intnl text="admin.threshold.Relative Maximum threshold values representing Critical/Major/Minor should be in descending order"/>');
			document.threshconfig[relB].focus();
			res=false;
			break;
		}
		//end
	}

	if(res)
	{
		if (isNetscape()) targetObj = document.threshconfig.up;
		if (isIE()) targetObj = document.threshconfig.up;
		targetObj.disabled = true;
		var updateSpecificThreshToDb = '<%=updateSpecificThreshToDb%>';
		if (updateSpecificThreshToDb == 'true')
		{
			alert("<egui:intnl text='admin.threshold.This operation might take some time, please wait'/>....");
		}
		document.threshconfig.submit();
	}
}

function checkWithRegExp(val,c)
{
	var regExp;
	if(c==0)
	{
		regExp = /^(none)$|^(\-|\-?(([0-9]+\.|\.)?[0-9]+))\/(\-|\-?(([0-9]+\.|\.)?[0-9]+))\/(\-|\-?(([0-9]+\.|\.)?[0-9]+))$/i;
	}
	else
	{
		regExp = /^(none)$|^(\-|\-?(([0-9]+\.|\.)?[0-9]+\*)?sqc)\/(\-|\-?(([0-9]+\.|\.)?[0-9]+\*)?sqc)\/(\-|\-?(([0-9]+\.|\.)?[0-9]+\*)?sqc)$/i;
	}
	var ret = regExp.test(val);
	return ret;
}

function checkNegativeVal(val,c)
{
	var arr = val.split("/");
	var Cri,Maj,Min;
	Cri = arr[0];
	Maj = arr[1];
	Min = arr[2];

	if (Cri == "-")
	{
		Cri = "0";
	}

	if (Maj == "-")
	{
		Maj = "0";
	}

	if (Min == "-")
	{
		Min = "0";
	}

	var regExp = /^\-([0-9]+\.|\.)?[0-9]+/;
	var ret = regExp.test(Cri);
	if(!ret)
	{
		ret = regExp.test(Maj);
	}
	if(!ret)
	{
		ret = regExp.test(Min);
	}
	return ret;
}

function checkAscendingOrder(val,c)
{
	var arr = val.split("/");
	var Cri,Maj,Min;
	Cri = arr[0];
	Maj = arr[1];
	Min = arr[2];
	if (c==1)
	{
		Cri = Cri.replace(/(\*sqc)/gi,"");
		Cri = Cri.replace(/sqc/g,"1");
		Maj = Maj.replace(/(\*sqc)/gi,"");
		Maj = Maj.replace(/sqc/g,"1");
		Min = Min.replace(/(\*sqc)/gi,"");
		Min = Min.replace(/sqc/g,"1");
	}

	var ret = true;
	if (Cri != "-" && Maj != "-")
	{
		if (parseFloat(Cri) >= parseFloat(Maj))
		{
			ret = false;
		}
	}
	if (Maj != "-" && Min != "-")
	{
		if (parseFloat(Maj) >= parseFloat(Min))
		{
			ret = false;
		}
	}
	if (Cri != "-" && Min != "-")
	{
		if (parseFloat(Cri) >= parseFloat(Min))
		{
			ret = false;
		}
	}
	return ret;
}

function checkDescendingOrder(val,c)
{
	var arr = val.split("/");
	var Cri,Maj,Min;
	Cri = arr[0];
	Maj = arr[1];
	Min = arr[2];
	if (c==1)
	{
		Cri = Cri.replace(/(\*sqc)/gi,"");
		Cri = Cri.replace(/sqc/g,"1");
		Maj = Maj.replace(/(\*sqc)/gi,"");
		Maj = Maj.replace(/sqc/g,"1");
		Min = Min.replace(/(\*sqc)/gi,"");
		Min = Min.replace(/sqc/g,"1");
	}

	var ret = true;
	if (Cri != "-" && Maj != "-")
	{
		if (parseFloat(Cri) <= parseFloat(Maj))
		{
			ret = false;
		}
	}
	if (Maj != "-" && Min != "-")
	{
		if (parseFloat(Maj) <= parseFloat(Min))
		{
			ret = false;
		}
	}
	if (Cri != "-" && Min != "-")
	{
		if (parseFloat(Cri) <= parseFloat(Min))
		{
			ret = false;
		}
	}
	return ret;
}


function populate(count)
{
	var threshSeries = '<%=ui.getStateDisplayLabel("HIGH")%>' + "/" + '<%=ui.getStateDisplayLabel("INTERMEDIATE")%>' + "/" + '<%=ui.getStateDisplayLabel("LOW")%>';
	var minArr = "";
	var maxArr = "";

	var relAArr = "";
	var relBArr = "";
	var absAArr = "";
	var absBArr = "";

	var num = document.threshconfig.measNo.value;
	var temp="false";
	for(var i=0; i < num; i++)
	{
		var absA = "absA"+i;
		var absB = "absB"+i;
		var relA = "relA"+i;
		var relB = "relB"+i;
		//var nam1 ="min"+i;
		//var nam2 ="max"+i;
		var nam3 ="pol"+i;
		var absoluteA = document.threshconfig[absA].value;
		var absoluteB = document.threshconfig[absB].value;
		var relativeA = document.threshconfig[relA].value;
		var relativeB = document.threshconfig[relB].value;
		if(!check(absoluteA))
		{
			temp="true";
			document.threshconfig[absA].focus();
			break;
		}
		if(!check(absoluteB))
		{
			temp="true";
			document.threshconfig[absB].focus();
			break;
		}
		if(!check(relativeA))
		{
			temp="true";
			document.threshconfig[relA].focus();
			break;
		}
		if(!check(relativeB))
		{
			temp="true";
			document.threshconfig[relB].focus();
			break;
		}
		var splChar = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ`~!@#$%^&*()_+=[]{}|\\:;\"\'<>,\?"; 
		var threshType = document.threshconfig.threshType.value;
		//if (relativeB != 'none' && threshType != null && threshType == 'Multiple' && maxArr.length != 3)
		//{
		//	alert("Multiple thresholds should be given in "+ threshSeries +" format");
		//	document.threshconfig[relB].focus();
		//	temp = "true";
		//	break;
		//}
		//if (absoluteB != 'none' && threshType != null && threshType == 'Multiple' && maxArr.length != 3)
		//{
		//	alert("Multiple thresholds should be given in "+ threshSeries +" format");
		//	document.threshconfig[absB].focus();
		//	temp = "true";
		//	break;
		//}
		//if (absoluteA != 'none' && threshType != null && threshType == 'Multiple' && maxArr.length != 3)
		//{
		//	alert("Multiple thresholds should be given in "+ threshSeries +" format");
		//	document.threshconfig[absA].focus();
		//	temp = "true";
		//	break;
		//}
		//if (relativeA != 'none' && threshType != null && threshType == 'Multiple' && minArr.length != 3)
		//{
		//	alert("Multiple thresholds should be given in "+ threshSeries +" format");
		//	document.threshconfig[relA].focus();
		//	temp = "true";
		//	break;
		//}
		var description = document.getElementById("ANV"+i).value;
		var desc = description.split(":");
		var measurement = desc[0];
		var isNegativeValuesAllowed = desc[1];

		if (relativeA.length != 0 && !(relativeA == 'sqc' || relativeA == 'none'))
		{
			relAArr = relativeA.split("/");
			if(relAArr.length == 3)
			{
				if(trim(relAArr[0]) == '' || trim(relAArr[1]) == '' || trim(relAArr[2]) == '')
				{
					alert('<egui:intnl text="admin.threshold.Empty values are not allowed"/>');
					document.threshconfig[relA].focus();
					temp = "true";
					break;
				}
				else
				{
					if (isNegativeValuesAllowed == 'false')
					{
						if(!(isValidSqcFactor(relAArr[0],false) && isValidSqcFactor(relAArr[1],false) && isValidSqcFactor(relAArr[2],false)))
						{
							alert("<egui:intnl text='admin.threshold.Relative minimum'/> <egui:intnl text='admin.threshold.for'/>"+" \'"+measurement+"\' "+"<egui:intnl text='admin.threshold.can have only \'sqc\',\'-\',\'none\' and \'sqc with a positive value\''/>.");
							document.threshconfig[relA].focus();
							temp = "true";
							break;
						}
					}
					else
					{
						if(!(isValidSqcFactor(relAArr[0],true) && isValidSqcFactor(relAArr[1],true) && isValidSqcFactor(relAArr[2],true)))
						{
							alert("<egui:intnl text='admin.threshold.Relative minimum'/> <egui:intnl text='admin.threshold.for'/>"+" \'"+measurement+"\' "+"<egui:intnl text='admin.threshold.can have only \'sqc\',\'-\' and \'none\' values'/>.");
							document.threshconfig[relA].focus();
							temp = "true";
							break;
						}
					}
					
				}
				if(!isRelativeAscending(relAArr[0],relAArr[1],relAArr[2]))
				{
					alert("<egui:intnl text='admin.threshold.Min Relative threshold policy should be in ascendiing order'/>");
					document.threshconfig[relA].focus();
					temp = "true";
					break;
				}
			}
			else
			{
				alert("<egui:intnl text='admin.threshold.Please provide the threshold values in Critical/Major/Minor format'/>");
				document.threshconfig[relA].focus();
				temp = "true";
				break;
			}
		}

		if (relativeB.length != 0 && !(relativeB == 'sqc' || relativeB == 'none'))
		{
			relBArr = relativeB.split("/");
			if(relBArr.length == 3)
			{
				if(trim(relBArr[0]) == '' || trim(relBArr[1]) == '' || trim(relBArr[2]) == '')
				{
					alert("<egui:intnl text='admin.threshold.Empty values are not allowed'/>");
					document.threshconfig[relB].focus();
					temp = "true";
					break;
				}
				else
				{
					if (isNegativeValuesAllowed == 'false')
					{
						if(!(isValidSqcFactor(relBArr[0],false) && isValidSqcFactor(relBArr[1],false) && isValidSqcFactor(relBArr[2],false)))
						{
							alert("<egui:intnl text='admin.threshold.Relative maximum'/> <egui:intnl text='admin.threshold.for'/>"+" \'"+measurement+"\' "+"<egui:intnl text='admin.threshold.can have only \'sqc\',\'-\',\'none\' and \'sqc with a positive value\''/>.");
							document.threshconfig[relB].focus();
							temp = "true";
							break;
						}
					}
					else
					{
						if(!(isValidSqcFactor(relBArr[0],true) && isValidSqcFactor(relBArr[1],true) && isValidSqcFactor(relBArr[2],true)))
						{
							alert("<egui:intnl text='admin.threshold.Relative maximum'/> <egui:intnl text='admin.threshold.for'/>"+" \'"+measurement+"\' "+"<egui:intnl text='admin.threshold.can have only \'sqc\',\'-\' and \'none\' values'/>.");
							document.threshconfig[relB].focus();
							temp = "true";
							break;
						}
					}
					
				}
				if(!isRelativeDescending(relBArr[0],relBArr[1],relBArr[2]))
				{
					alert("<egui:intnl text='admin.threshold.Max Relative threshold policy should be in descending order'/>");
					document.threshconfig[relB].focus();
					temp = "true";
					break;
				}
			}
			else
			{
				alert("<egui:intnl text='admin.threshold.Please provide the threshold values in Critical/Major/Minor format'/>");
				document.threshconfig[relB].focus();
				temp = "true";
				break;
			}
		}

		if (absoluteA.length != 0 && !(absoluteA == 'none'))
		{
			var str_temp="true";
			for(var x=0; x<splChar.length; x++)
			{
				check_char = absoluteA.indexOf(splChar.charAt(x));
				if(check_char >= 0)
				{
					str_temp="false";
				}
			}

			if(str_temp == "true")
			{
				absAArr = absoluteA.split("/");
				if(absAArr.length != 3)// && absAArr.length != 1)
				{
					alert("<egui:intnl text='admin.threshold.Please provide the threshold values in Critical/Major/Minor format'/>");
					document.threshconfig[absA].focus();
					temp = "true";
					break;
				}

				if(absAArr.length == 3)
				{
					if(trim(absAArr[0]) == '' || trim(absAArr[1]) == '' || trim(absAArr[2]) == '')
					{
						alert("<egui:intnl text='admin.threshold.Empty values are not allowed'/>");
						document.threshconfig[absA].focus();
						temp = "true";
						break;
					}
				}

				if ((absAArr[0] != '-' && trim(absAArr[0]) != '') &&
					(absAArr[1] != '-' && trim(absAArr[1]) != ''))
				{
					if(eval(absAArr[0]) >= eval(absAArr[1]))
					{
						//alert("Threshold values representing High/Medium/Low should be in ascending order");
						//alert("Minimum threshold values representing "+threshSeries+" should be in ascending order");
						alert("<egui:intnl text='admin.threshold.Minimum threshold values representing Critical/Major/Minor should be in ascending order'/>");
						document.threshconfig[absA].focus();
						temp = "true";
						break;
					}
				}
				
				if ((absAArr[1] != '-' && trim(absAArr[1]) != '') &&
					(absAArr[2] != '-' && trim(absAArr[2]) != ''))
				{
					if(eval(absAArr[1]) >= eval(absAArr[2]))
					{
						//alert("Threshold values representing High/Medium/Low should be in ascending order");
						//alert("Minimum threshold values representing "+threshSeries+" should be in ascending order");
						alert("<egui:intnl text='admin.threshold.Minimum threshold values representing Critical/Major/Minor should be in ascending order'/>");
						document.threshconfig[absA].focus();
						temp = "true";
						break;
					}
				}

				if((absAArr[0] != '-' && trim(absAArr[0]) != '') &&
					(absAArr[2] != '-' && trim(absAArr[2]) != ''))
				{
					if(eval(absAArr[0]) >= eval(absAArr[2]))
					{
						//alert("Threshold values representing High/Medium/Low should be in ascending order");
						//alert("Minimum threshold values representing "+threshSeries+" should be in ascending order");
						alert("<egui:intnl text='admin.threshold.Minimum threshold values representing Critical/Major/Minor should be in ascending order'/>");
						document.threshconfig[absA].focus();
						temp = "true";
						break;
					}
				}
				
				if (isNegativeValuesAllowed == 'false')
				{
					if (isNegative(absAArr[0],absAArr[1],absAArr[2]))
					{
						alert("<egui:intnl text='admin.threshold.Absolute minimum'/> <egui:intnl text='admin.threshold.for'/>"+" \'"+measurement+"\' "+"<egui:intnl text='admin.threshold.should not contain negative values'/>.");
						document.threshconfig[absA].focus();
						temp = "true";
						break;
					}
				}

				if(str_temp == "false")
				{
					temp = "true";
					break;
				}
			}
			if(str_temp == "false")
			{
				alert("<egui:intnl text='admin.threshold.Alphabets,special characters and \'sqc\' values are not allowed for Absolute threshold policy!'/>");
				//document.threshconfig[nam1].value="";
				document.threshconfig[absA].focus();
				temp="true";
				break;
			}
		}

		if (absoluteB.length != 0 && !(absoluteB == 'none'))
		{
			var str_tem="true";
			for(var k=0; k<splChar.length; k++)
			{
				check_cha = absoluteB.indexOf(splChar.charAt(k));
				if(check_cha >= 0)
				{
					str_tem="false";
				}
			}
			if(str_tem == "true")
			{
				absBArr = absoluteB.split("/");
				if(absBArr.length != 3) //&& absBArr.length != 1)
				{
					alert("<egui:intnl text='admin.threshold.Please provide the threshold values in Critical/Major/Minor format'/>");
					document.threshconfig[absB].focus();
					temp = "true";
					break;
				}
				if(absBArr.length == 3)
				{
					if(absBArr[0] == '' || absBArr[1] == '' || absBArr[2] == '')
					{
						alert("<egui:intnl text='admin.threshold.Empty values are not allowed'/>");
						document.threshconfig[absB].focus();
						temp = "true";
						break;
					}
				}
				
				if(isNegativeValuesAllowed == 'false')
				{
					if(isNegative(absBArr[0],absBArr[1],absBArr[2]))
					{
						alert("<egui:intnl text='admin.threshold.Absolute maximum'/> <egui:intnl text='admin.threshold.for'/>"+" \'"+measurement+"\' "+"<egui:intnl text='admin.threshold.should not contain negative values'/>!");
						document.threshconfig[absB].focus();
						temp = "true";
						break;
					}
				}

				if ((absBArr[0] != '-' && trim(absBArr[0]) != '') &&
					(absBArr[1] != '-' && trim(absBArr[1]) != ''))
				{
					if(eval(absBArr[1]) >= eval(absBArr[0]))
					{
						//alert("Threshold values representing High/Medium/Low should be in descending order");
						//alert("Maximum threshold values representing "+threshSeries+" should be in descending order");
						alert("<egui:intnl text='admin.threshold.Maximum threshold values representing Critical/Major/Minor should be in descending order'/>");
						document.threshconfig[absB].focus();
						temp = "true";
						break;
					}
				}
				
				if ((absBArr[1] != '-' && trim(absBArr[1]) != '') && (absBArr[2] != '-' && trim(absBArr[2]) != ''))
				{
					if(eval(absBArr[2]) >= eval(absBArr[1]))
					{
						//alert("Threshold values representing High/Medium/Low should be in descending order");
						//alert("Maximum threshold values representing "+threshSeries+" should be in descending order");
						alert("<egui:intnl text='admin.threshold.Maximum threshold values representing Critical/Major/Minor should be in descending order'/>");
						document.threshconfig[absB].focus();
						temp = "true";
						break;
					}
				}
				
				if ((absBArr[0] != '-' && trim(absBArr[0]) != '') && (absBArr[2] != '-' && trim(absBArr[2]) != ''))
				{
					if(eval(absBArr[2]) >= eval(absBArr[0]))
					{
						//alert("Threshold values representing High/Medium/Low should be in descending order");
						alert("<egui:intnl text='admin.threshold.Maximum threshold values representing Critical/Major/Minor should be in descending order'/>");
						document.threshconfig[absB].focus();
						temp = "true";
						break;
					}
				}

				if(str_tem == "false")
				{
					temp = "true";
					break;
				}
			}

			if(str_tem == "false")
			{
				alert("<egui:intnl text='admin.threshold.Alphabets,special characters and \'sqc\' values are not allowed for Absolute threshold policy!'/>");
				//document.threshconfig[nam2].value="";
				document.threshconfig[absB].focus();
				temp="true";
				break;
			}
		}

		if(absoluteA != 'none' && absoluteB != 'none')
		{
			absAArr = absoluteA.split("/");
			absBArr = absoluteB.split("/");
			if(absAArr.length == 3 && absBArr.length == 3)
			{
				//if(eval(absAArr[0]) < eval(absBArr[0]))
				//{
				//	document.threshconfig[absA].focus();
				//	temp="true";
				//	alert("Maximum wwwvalue should be greater than the minimum value.");
				//	break;
				//}
			}
		}
		if((absoluteA == 'sqc' || absoluteB == 'sqc'))
		{
			if(absoluteA == 'sqc')// || minimum == 'none')
			{
				alert("<egui:intnl text='admin.threshold.Absolute threshold policy cannot have \'sqc\' values'/>");
				document.threshconfig[absA].focus();
				temp="true";
				break;
			}
			if(absoluteB == 'sqc')// || minimum == 'none')
			{
				alert("<egui:intnl text='admin.threshold.Absolute threshold policy cannot have \'sqc\' values'/>");
				document.threshconfig[absB].focus();
				temp="true";
				break;
			}
		}
		else if(absoluteA != 'none' || absoluteA != 'sqc')
		{
			if(!checkspace(absoluteA))
			{
				document.threshconfig[nam2].focus();
				temp = "true";
				break;
			}
		}
		else if(absoluteB != 'none' || absoluteB != 'sqc')
		{
			if(!checkspace(absoluteB))
			{
				document.threshconfig[absB].focus();
				temp = "true";
				break;
			}
		}
	}
	if(temp == 'false')
	{
		if (isNetscape()) targetObj = document.threshconfig.up;
		if (isIE()) targetObj = document.threshconfig.up;
		targetObj.disabled = true;
		alert("<egui:intnl text='admin.threshold.This operation might take some time,please wait'/>....");
		document.threshconfig.submit();
	}
}


function trim(s)
{
	if(s != null)
	{
		while (s.substring(0,1) == ' ')
		{
			s = s.substring(1,s.length);
		}

		while (s.substring(s.length-1,s.length) == ' ')
		{
			s = s.substring(0,s.length-1);
		}
	}

	return s;
}

function listselect()
{
	var comp_name;

	var comptypes = document.threshconfig.comptype.value;
	var comp_name = document.threshconfig.ComponentsList.options[document.threshconfig.ComponentsList.selectedIndex].value;

	if (comp_name != "-1")
	{
<%
		String str1 = request.getParameter("thresh");
		if(str1 != null)
		{
%>
			window.location.href = "EgConfigThresh.jsp?comptype=" +encodeURI(comptypes) + "&compname="+ encodeURI(comp_name) + "&qctr=1&rctr=0&t_name=" + "<%= request.getParameter("t_name") %>" + "&server=" + "<%=EgURLEncoder.encode(serverType,"UTF-8")%>&thresh=1&abc=<%= request.getParameter("abc") %>";
<%
		}
		else
		{
%>
			window.location.href = "EgConfigThresh.jsp?comptype=" +encodeURI(comptypes) + "&compname="+encodeURI(comp_name)+ "&qctr=1&rctr=0&t_name=" + "<%= request.getParameter("t_name") %>" + "&server=" + "<%=EgURLEncoder.encode(serverType,"UTF-8")%>&abc=<%= request.getParameter("abc") %>";
<%
		}
%>
	}
}

function deletethresh()
{
	var comp_name;

	var comptypes = document.threshconfig.comptype.value;
	//comp_name = document.threshconfig.ComponentsList.options[document.threshconfig.ComponentsList.selectedIndex].value;

	//var a = confirm("Are you sure you want to delete specific thresholds for <%=request.getParameter("t_name")%> ?");
	var a = confirm('<egui:intnl text="admin.threshold.Are you sure you want to delete specific thresholds for"/> <egui:intnl test='<%=request.getParameter("t_name")%>'/> ?');
	if(a)
	{
		if (isNetscape()) targetObj = document.threshconfig.del;
		if (isIE()) targetObj = document.threshconfig.del;
		targetObj.disabled = true;
		document.threshconfig.delet.value = "true";
		document.threshconfig.submit();
	}
}

function isValidSqcFactor(value,isNegative)
{
	var tokens = value.split("*");
	if (tokens.length == 2)
	{
		if (!isNegative)
		{
			if ((isNumber("+", tokens[0]) && tokens[1] == 'sqc'))
			{
				return true;
			}
		}
		else
		{
			if ((isNumber("+", tokens[0]) && tokens[1] == 'sqc')||(isNumber("-", tokens[0]) && tokens[1] == 'sqc'))
			{
				return true;
			}
		}
	}
	else if (tokens.length == 1 && (tokens[0] == 'sqc' || tokens[0] == "-"))
	{
		return true;
	}

	return false;
}

function isRelativeDescending(val1,val2,val3)
{
	var token1 = val1.split("*");
	var token2 = val2.split("*");
	var token3 = val3.split("*");

	if(token1[0] == 'sqc') token1[0] = '1';
	if(token2[0] == 'sqc') token2[0] = '1';
	if(token3[0] == 'sqc') token3[0] = '1';

	//if(token1[0] == '1')
	//{
	//	if(token2[0] != '-' || token3[0] != '-')
	//	{
	//		return false;
	//	}
	//}
	//if(token2[0] == '1' && token3[0] != '-')
	//{
	//	return false;
	//}

	if(token2[0] != '-' && token3[0] != '-')
	{
		if((eval(token2[0]) < eval(token3[0])) ||  (eval(token2[0]) == eval(token3[0])))
		{
			return false;
		}
	}
	if(token1[0] != '-' && token2[0] != '-')
	{
		if( (eval(token1[0]) < eval(token2[0])) || (eval(token1[0]) == eval(token2[0])))
		{
			return false;
		}
	}
	if(token1[0] != '-' && token3[0] != '-')
	{
		if( (eval(token1[0]) < eval(token3[0])) || (eval(token1[0]) == eval(token3[0])) )
		{
			return false;
		}
	}
	return true;
}

function isNegative(val1,val2,val3)
{
	if ((val1 >= 0 || val1 == '-1' || val1 == '-') &&
		(val2 >= 0 || val2 == '-1' || val2 == '-') &&
		(val3 >= 0 || val3 == '-1' || val3 == '-'))
	{
		return false;
	}
	else
	{
		return true;
	}
}
function isRelativeAscending(val1,val2,val3)
{
	var token1 = val1.split("*");
	var token2 = val2.split("*");
	var token3 = val3.split("*");

	if(token1[0] == 'sqc') token1[0] = '1';
	if(token2[0] == 'sqc') token2[0] = '1';
	if(token3[0] == 'sqc') token3[0] = '1';

	//if(token1[0] == '9')
	//{
	//	if(token2[0] != '-' || token3[0] != '-')
	//	{
	//		return false;
	//	}
	//}
	//if(token2[0] == '9' && token3[0] != '-')
	//{
	//	return false;
	//}

	if(token2[0] != '-' && token3[0] != '-')
	{
		if( (eval(token2[0]) > eval(token3[0])) || (eval(token2[0]) == eval(token3[0])) )
		{
			return false;
		}
	}
	if(token1[0] != '-' && token2[0] != '-')
	{
		if( (eval(token1[0]) > eval(token2[0])) || (eval(token1[0]) == eval(token2[0])) )
		{
			return false;
		}
	}
	if(token1[0] != '-' && token3[0] != '-')
	{
		if( (eval(token1[0]) > eval(token3[0])) || (eval(token1[0]) == eval(token3[0])) )
		{
			return false;
		}
	}
	return true;
}

function call(component)
{
	var comp;
	//if(component.indexOf("default") > -1)
	//	comp = component.substring(0,component.indexOf("default")-1);
	//if((component.indexOf(":") < 0))
		//	comp = component + ":NULL";
	var server = '<%=serverType%>';
	//comp = server + ":"+ comp;
	comp = '<%=request.getParameter("comp")%>';
	var str = "";

<%
	String threshinfo = threshInfo;//request.getParameter("threshinfo");
	if(threshinfo == null || threshinfo.equals(""))
	{
%>
		str = "EgTestList.jsp?server="+server+"&qctr=1";
<%
	}
	else
	{
%>
		str = "EgUpdateInfo.jsp?server="+server+"&comp="+comp+"&test="+'<%= request.getParameter("t_name")%>'+"&qctr=5&tt=1&from=threshinfo";
<%
	}
%>
	window.location.href =str;
}

function callGroup()
{
	window.location.href="EgEntryForServerGroup.jsp?servertype=<%=EgURLEncoder.encode(serverType,"UTF-8")%>&test=<%=test%>&serv=<%=EgURLEncoder.encode(serverType,"UTF-8")%>&reqFrom=egConThresh";
}
</script>
</head>

<!-- <body leftmargin="0" topmargin="20" marginwidth="0" marginheight="20" bgcolor="#FFFFFF"> -->
<body style="overflow:auto" id="space6">
<form name="threshconfig" method="post" action="Egconfigthreshp.jsp" style="margin:0px">
<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0">
<%
	session.setAttribute("egPageDesc","EgConfigThresh.jsp");
%>
	<jsp:include page="listSearch.jsp?title=AGENT - SPECIFIC THRESHOLDS&leftString=&backButton=true&subtitle=false&searchBox=false"/>
	<tr>
		<td width="100%" id="eg_whitebg" align="center" height="100%" valign="top">
			<table align="center" width="85%" cellspacing="0" cellpadding="0" border="0">
<%
	if(q_ctr.equals("0"))
	{
		if(allPermission)// by James Thomas
		{
%>
				<tr>
					<td height="22" nowrap class="eg_subcontent" colspan="4" align="right">&nbsp;&nbsp;&nbsp;<egui:intnl text="admin.threshold.To configure thresholds for multiple servers"/>  <a class="eg_monlink" href="javascript:callGroup()"><b><egui:intnl text="admin.common.Click here"/></b>&nbsp;<img src="/final/admin/eg_images/icon_click.gif" border="0"></a></td>
				</tr>
<%
		}// by James Thomas
%>
				<tr>
					<td height="6" id="inner_top_left" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
					<td height="6" id="eg_subcontentbg" colspan="3"><img src="/final/admin/eg_images/spacer.gif" height="6"></td>
					<td height="6" id="inner_top_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
				</tr>
				<tr>
					<td height='25' align='center' id="eg_subcontentbg" class="eg_subcontent" nowrap>&nbsp;</td>
					<td id="eg_subcontentbg" valign="middle" align="center" colspan="2" width="50%">
						<egui:intnl text="admin.threshold.Component type"/> : <b><egui:intnl type="<%=serverType%>"/></b>&nbsp;&nbsp;</td>
<%
	}
	else
	{
%>
				<tr>
					<td height="6" id="inner_top_left" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
					<td height="6" id="eg_subcontentbg" colspan="3"><img src="/final/admin/eg_images/spacer.gif" height="6"></td>
					<td height="6" id="inner_top_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
				</tr>
				<tr>
					<td height='25' align='center' id="eg_subcontentbg" class="eg_subcontent" nowrap>&nbsp;</td>
					<td id="eg_subcontentbg" valign="middle" align="center" colspan="2" width="50%">
						<egui:intnl text="admin.threshold.Component type"/> : <b><egui:intnl type="<%=serverType%>"/></b>&nbsp;&nbsp;</td>
<%
	}
%>
					<td id="eg_subcontentbg" class="eg_subcontent" valign="middle" align="left">
<%
	/* code for ComponentsList */
	if(egSpecs.isPortRelevantForTest(testName))
	{
		// Add managed components from 
		// eg_ (thresholds.ini & infogroup.ini).	Thirumal

		Vector v_vect = new Vector();
		TreeSet vcc1 = descGrp.getTestColnComponentsForServerType();
		v_vect.addAll(vcc1);
		String[] sss = egThresh.getUserThresholds();
		if(sss != null && sss.length > 0)
		{
			for(int z=0;z<sss.length;z++)
			{
				if(!v_vect.contains(sss[z]))
				{
					v_vect.add(sss[z]);
				}
			}
		}
		//ComponentsList=topo.getVariables(serverName);
		ComponentsList=roleInfo.getAllServersOfType(serverName);
		for(int j=0; j<ComponentsList.length; j++)
		{
			//ComponentsList=topo.getVariables(serverName);
			ComponentsList=roleInfo.getAllServersOfType(serverName);
			if(ComponentsList[j].startsWith("Format:") || ComponentsList[j].startsWith("#"))
			{
				continue;
			}
			else
			{
				temp=ComponentsList[j].substring(ComponentsList[j].indexOf(":")+1,ComponentsList[j].length());
			}
			prgBean.createFile("eg_disable.ini");
			String excludedTestForComp = prgBean.getStrValue(serverName,serverName+":"+temp);
			//out.println("excludedTestForComp=="+excludedTestForComp);
			if (excludedTestForComp != null && !excludedTestForComp.equals(""))
			{
				//if (excludedTestForComp.indexOf(test)!=-1)
				StringTokenizer st =new StringTokenizer(excludedTestForComp,",");
				boolean match = false;
				while (st.hasMoreTokens())
				{
					String tname=st.nextToken();
					if (tname.equals(test))
					{
						match = true;
						break;
					}
				}
				if (match)
					continue;
			}
			String excludedTestForHost = prgBean.getStrValue("Default_server","Default_server"+":"+temp);
			//out.println("excludedTestForComp=="+excludedTestForHost);
			if (excludedTestForHost != null && !excludedTestForHost.equals(""))
			{
				boolean match = false;
				StringTokenizer st =new StringTokenizer(excludedTestForHost,",");
				while (st.hasMoreTokens())
				{
					String tname=st.nextToken();
					if (tname.equals(test))
					{
						match = true;
						break;
					}
				}
				if (match) 
					continue;
			}
			String temp1 = "";
			userThreshVal = (String[]) v_vect.toArray(new String[v_vect.size()]); //
			//userThreshVal = egThresh.getUserThresholds();

			//String testName=request.getParameter("t_name");
			StringTokenizer string = new StringTokenizer(temp,":");
			if(string.countTokens()>2)
			{
				//temp=string.nextToken()+":"+string.nextToken();
				temp1=temp+"(default)";
				String junk = string.nextToken();
			}
			if(vecHost.contains(temp.trim())==false && !vecHost.contains(temp1.trim()))
			{
				boolean tempFlag=true;
				for(int f=0;f<userThreshVal.length;f++)
				{
					if(userThreshVal[f].equals(testName+":"+temp))
					{
						vecHost.addElement(temp.trim());
						tempFlag=false;
					}
				}
				if(tempFlag)
				{
					temp1=temp+"(default)";
					vecHost.addElement(temp1.trim());
				}
			}
		}

		String thresh_comp = request.getParameter("comp");
		if(thresh_comp != null)
		{
			thresh_comp = thresh_comp.substring(thresh_comp.indexOf(":")+1);
		}

		if(threshinfo == null)
		{
%>
						<select name="ComponentsList" onchange="JavaScript:listselect()" class="list">
<%
			if (vecHost.size()>0)
			{
%>			
							<option value="-1"><egui:intnl text="admin.threshold.Choose one"/></option> 
<%
			}			
			else
			{
%>
							<option value="-1"><egui:intnl text="admin.common.Not Applicable"/></option>
<%
			}
			TreeSet ts = new TreeSet(vecHost);
			vecHost.removeAllElements();
			vecHost.addAll(ts);
			Collections.sort(vecHost,String.CASE_INSENSITIVE_ORDER);
			for(int j=0; j<vecHost.size(); j++)
			{
				String serverName = (String)vecHost.elementAt(j);
				int index = serverName.lastIndexOf("(default)");
				if (index > -1)
				{
					serverName = serverName.substring(0, index);
					serverName = Server.getServerNameWithoutPort(serverName, false);
					serverName = serverName + "(default)";
				}
				else
				{
					serverName = Server.getServerNameWithoutPort(serverName, false);
				}
%>
							<option value=<%=(String)vecHost.elementAt(j)%>
<%
				if(q_ctr.equals("1") && (vecHost.elementAt(j).equals(thresh_comp) || vecHost.elementAt(j).equals(thresh_comp + "(default)") ||
				(vecHost.elementAt(j).equals(str_comp_name) || vecHost.elementAt(j).equals(str_comp_name + "(default)"))))
				{
					out.println(" selected ");
				}
%>
							><%=serverName%></option>
<%
			}
%>
						</select>
<%
		}
		vecHost.removeAllElements();
	}
	else
	{
		// Add managed components from 
		// eg_ (thresholds.ini & infogroup.ini).

		Vector v_vect = new Vector();
		TreeSet vcc1 = descGrp.getTestColnComponentsForServerType();
		Iterator itr = vcc1.iterator();
		while(itr.hasNext())
		{
			String comp = (String) itr.next();
			StringTokenizer stok = new StringTokenizer(comp,":");
			if(stok.countTokens() > 3)
			{
				StringBuffer sbuff = new StringBuffer();
				sbuff.append(stok.nextToken());
				sbuff.append(":");
				sbuff.append(stok.nextToken());
				sbuff.append(":NULL");
				comp = sbuff.toString();
			}
			v_vect.add(comp);
		}
		String[] sss = egThresh.getUserThresholds();
		if(sss != null && sss.length > 0)
		{
			for(int z=0;z<sss.length;z++)
			{
				if(!v_vect.contains(sss[z]))
				{
					v_vect.add(sss[z]);
				}
			}
		}

		/* code to retrieve distinct host name from tests which have no port numbers  */
		//ComponentsList=topo.getVariables(serverName);
		ComponentsList=roleInfo.getAllServersOfType(serverName);
		for(int j=0; j<ComponentsList.length; j++)
		{
			if(ComponentsList[j].startsWith("Format:") || ComponentsList[j].startsWith("#"))
			{
				continue;
			}
			String strComp = ComponentsList[j].substring(ComponentsList[j].indexOf(":")+1);
			strComp = removeNull(strComp);
			prgBean.createFile("eg_disable.ini");
			String excludedTestForComp = prgBean.getStrValue(serverName,serverName+":"+strComp);
			//out.println("excludedTestForComp=="+excludedTestForComp);
			
			if (excludedTestForComp != null && !excludedTestForComp.equals(""))
			{
				//if (excludedTestForComp.indexOf(test)!=-1)
				StringTokenizer st =new StringTokenizer(excludedTestForComp,",");
				boolean match = false;
				while (st.hasMoreTokens())
				{
					String tname=st.nextToken();
					if (tname.equals(test))
					{
						match=true;
						break;
					}
				}
				if (match) 
					continue;
			}
			String excludedTestForHost = prgBean.getStrValue("Default_server","Default_server"+":"+strComp);
			//out.println("excludedTestForHost=="+excludedTestForHost);
			if (excludedTestForHost != null && !excludedTestForHost.equals(""))
			{
				StringTokenizer st =new StringTokenizer(excludedTestForHost,",");
				boolean match = false;
				//if (excludedTestForHost.indexOf(test)!= -1)
				while (st.hasMoreTokens())
				{
					String tname=st.nextToken();
					if (tname.equals(test))
					{
						match=true;
						break;
					}
				}
				if (match) 
					continue;
			}
			st2 = new StringTokenizer(ComponentsList[j],":");
			stCount = st2.countTokens();

			// Srinivas
			if (stCount < 2)
				continue;
			st2.nextToken();
			strToken = st2.nextToken();
			//if(m==1 && (vecHost.contains(strToken)==false && vecHost.contains(strToken+"(default)")==false))
			if((vecHost.contains(strToken)==false && vecHost.contains(strToken+"(default)")==false))
			{
				userThresh = (String[]) v_vect.toArray(new String[v_vect.size()]); //
				//userThresh = egThresh.getUserThresholds();
				//vecHost.addElement(strToken);
				boolean Flag=true;
				for(int v=0;v<userThresh.length;v++)
				{
					if(userThresh[v].equals(testName+":"+strToken+":NULL") || userThresh[v].equals(testName+":"+strToken))
					{
						vecHost.addElement(strToken);
						Flag=false;
					}
				}
				if(Flag)
				{
					strToken=strToken+"(default)";
					vecHost.addElement(strToken);
				}
			}
		}
		if(threshinfo == null)
		{
%>
						<select name="ComponentsList" onchange="JavaScript:listselect()" class="list">
	
<%
			if(vecHost.size()>0)
			{
%>
							<option value="-1"><egui:intnl text="admin.threshold.Choose one"/></option> 
<%
			}
			else
			{
%>
							<option value="-1"><egui:intnl text="admin.common.Not Applicable"/></option>
<%
			}
			TreeSet ts = new TreeSet(vecHost);
			vecHost.removeAllElements();
			vecHost.addAll(ts);
			Collections.sort(vecHost,String.CASE_INSENSITIVE_ORDER);
			for(int j=0; j<vecHost.size(); j++)
			{
%>
							<option value=<%=(String)vecHost.elementAt(j)%>
<%
				if(q_ctr.equals("1")  && (vecHost.elementAt(j).equals(str_comp_name) || vecHost.elementAt(j).equals(str_comp_name+"(default)")))
				{
					out.println(" selected ");
				}
%>
							><%=(String)vecHost.elementAt(j)%></option>
<%
			}
%>
						</select>
<%
		}
		vecHost.removeAllElements();
		strExServer = "";
	}
%>
					</td>
					<td id="eg_subcontentbg">&nbsp;</td>
				</tr>
				<tr>
					<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
					<td id="eg_subcontentbg"  valign="top" colspan="3"><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
					<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
				</tr>
			</table>
<%
	boolean isHostTest = egSpecs.isTestRelevantForServer("Host_system",testName,true);
	if (isHostTest)
	{
%>
			*&nbsp;<egui:intnl text="admin.threshold.Changes made to specific thresholds will be applied to all components with the same nick name"/>
			<br>
<%
	}
%>
			<br>
<%
	if (Comp != null && !Comp.equals("") && !Comp.equals("null"))
	{
%>
			<table align="center" border="0" cellpadding="0" cellspacing="0" height="22" width="85%">
				<tr>
					<td id="subhead_left" width="7"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7"></td>
					<td id="eg_subheadbg" style="border-left-width: 0px; border-right-width: 0px;" align="center" width="100%">
<%
		if (Comp.indexOf("(default)") > -1)
		{
			Comp = Comp.substring(0,Comp.indexOf("("));
		}
		session.setAttribute("compname",Comp);

		//if(egSpecs.isPortRelevantForTest(testName))
		//{
			if(threshinfo == null || threshinfo.equals(""))
			{
				if(!q_ctr.equals("0"))
				{
%>
					<egui:intnl text="admin.threshold.Configuration of"/> <b><egui:intnl test='<%=request.getParameter("t_name")%>'/></b>
<%
					if(Comp !=null)
					{
						out.println(_mapping.getTextDescription("admin.threshold.for")+" ");
						out.println(Server.getServerNameWithoutPort(Comp, false));
					}
				}
			}
			else
			{
%>
				<egui:intnl text="admin.threshold.Configuration of"/> <b><%=threshinfo%> </b> <egui:intnl text="admin.threshold.for"/> <b><%=request.getParameter("t_name")%></b> <egui:intnl text="admin.threshold.for"/> <%=removeNull(Comp)%>
<%
			}
		//}
		//else
		//{
		//	if(threshinfo == null || threshinfo.equals(""))
		//	{
		//		if(!q_ctr.equals("0"))
		//		{
%>
					<!-- <egui:intnl text="admin.threshold.Configuration of"/> <b><egui:intnl test='<%//=request.getParameter("t_name")%>'/></b> -->
<%
		//		}
		//	}
		//	else
		//	{
%>
				<!-- <egui:intnl text="admin.threshold.Configuration of"/> <b><%//=threshinfo%> </b> <egui:intnl text="admin.threshold.for"/> <b><%//=request.getParameter("t_name")%> </b> <egui:intnl text="admin.threshold.for"/> <%//=removeNull(Comp)%> -->
<%
		//	}
		//}
%>
					</td>
					<td id="subhead_right" width="7"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7"></td>
				</tr>
			</table>
<%
	}

	boolean isSpecThreshAvail = false;
	if(q_ctr.equals("1") && !str_comp_name.equals("undefined"))
	{
		if(str_comp_name.indexOf(":")<0)
		{
			if(threshinfo == null || threshinfo.equals(""))
				variable = testName + ":" + str_comp_name;
			else
				variable = testName + ":" + str_comp_name+":NULL";
		}
		else
		{
			variable = testName + ":" + str_comp_name;
		}

		val = egThresh.getUserThresholdValue(variable);
		String str_comp = request.getParameter("compname");
		if(str_comp.indexOf("default") > 0)
			str_comp = str_comp.substring(0,str_comp.indexOf("default")-1);
		if(str_comp.indexOf(":") < 0)
		{
			if(threshinfo != null && !threshinfo.equals(""))
				str_comp = str_comp + ":NULL";
		}

		String str_var = testName+":"+str_comp;
		String usr_var = str_var;

		if(threshinfo != null)
			str_var = str_var +"#"+threshinfo;

		int count1 = 0;
		int count2 = 0;

		val = egThresh.getDescThresholdValue(str_var);
		if(!val.equals(""))
			count2 = 1;

		boolean b_portRelev = egSpecs.isPortRelevantForTest(testName);
		Vector serverGroup = new Vector();
		String policyName = "";
		if(val.equals(""))
		{
			StringTokenizer st = new StringTokenizer(usr_var, ":");
			if(st.countTokens() >3) // For oracle comes with sid
			{
				if(usr_var.indexOf("#") > -1)
				{
					val = egThresh.getUserThresholdValue(usr_var.substring(0, usr_var.lastIndexOf("#")));
					//serverGroup = descGrp.getServerGroup(str_comp,testName,b_portRelev);	// Thiru
					//policyName = descGrp.getPolicyForTest(serverGroup,testName);
					//val = descGrp.getPolicyValue(policyName);
					if(val.length() == 0)
					{
						serverGroup = descGrp.getServerGroup(str_comp,testName,b_portRelev);	// Thiru
						if (serverGroup != null && serverGroup.size() > 0)
						{
							String thisGroup = (String) serverGroup.get(0);
							policyName = descGrp.getPolicyForTest(thisGroup,testName);
							val = descGrp.getPolicyValue(policyName);
						}
						//val = egThresh.getUserThresholdValue(usr_var.substring(0, usr_var.lastIndexOf("#")));
					}
					if(val.length() == 0)
					{
						String threshinf = threshInfo;//request.getParameter("threshinfo");
						serverGroup = descGrp.getServerGroup(str_comp,testName,b_portRelev,threshinf);
						if (threshinf != null && threshinf.length() > 0)
						{
							if (serverGroup != null && serverGroup.size() > 0)
							{
								String thisGroup = (String) serverGroup.get(0);
								policyName = descGrp.getPolicyForTest(thisGroup,testName,threshinf);
							}
						}
						val = descGrp.getPolicyValue(policyName);
					}
				}
				else
				{
					val = egThresh.getUserThresholdValue(usr_var);
					//serverGroup = descGrp.getServerGroup(str_comp,testName,b_portRelev);	//thiru
					//policyName = descGrp.getPolicyForTest(serverGroup,testName);
					//val = descGrp.getPolicyValue(policyName);
					if(val.length() == 0)
					{
						serverGroup = descGrp.getServerGroup(str_comp,testName,b_portRelev);	//thiru
						if (serverGroup != null && serverGroup.size() > 0)
						{
							String thisGroup = (String) serverGroup.get(0);
							policyName = descGrp.getPolicyForTest(thisGroup,testName);
							val = descGrp.getPolicyValue(policyName);
						}
						//val = egThresh.getUserThresholdValue(usr_var);
					}
					if(val.length() == 0)
					{
						String threshinf = threshInfo;//request.getParameter("threshinfo");
						serverGroup = descGrp.getServerGroup(str_comp,testName,b_portRelev,threshinf);
						if (threshinf != null && threshinf.length() > 0)
						{
							if (serverGroup != null && serverGroup.size() > 0)
							{
								String thisGroup = (String) serverGroup.get(0);
								policyName = descGrp.getPolicyForTest(thisGroup,testName,threshinf);
							}
						}
						val = descGrp.getPolicyValue(policyName);
					}
				}
			}
			else if((!b_portRelev) && (usr_var.lastIndexOf(":") != usr_var.indexOf(":")))//For Non-oracle
			{
				val = egThresh.getUserThresholdValue(usr_var.substring(0, usr_var.lastIndexOf(":")));
				//serverGroup = descGrp.getServerGroup(str_comp,testName,b_portRelev);
				//policyName = descGrp.getPolicyForTest(serverGroup,testName);
				//val = descGrp.getPolicyValue(policyName);
				if(val.length() == 0)
				{
					serverGroup = descGrp.getServerGroup(str_comp,testName,b_portRelev);
					if (serverGroup != null && serverGroup.size() > 0)
					{
						String thisGroup = (String) serverGroup.get(0);
						policyName = descGrp.getPolicyForTest(thisGroup,testName);
						val = descGrp.getPolicyValue(policyName);
					}
					//val = egThresh.getUserThresholdValue(usr_var.substring(0, usr_var.lastIndexOf(":")));
				}
				if(val.length() == 0)
				{
					String threshinf = threshInfo;//request.getParameter("threshinfo");
					serverGroup = descGrp.getServerGroup(str_comp,testName,b_portRelev,threshinf);
					if (serverGroup != null && serverGroup.size() > 0)
					{
						String thisGroup = (String) serverGroup.get(0);
						if (threshinf != null && threshinf.length() > 0)
							policyName = descGrp.getPolicyForTest(thisGroup,testName,threshinf);
						val = descGrp.getPolicyValue(policyName);
					}
				}
			}
			else
			{
				val = egThresh.getUserThresholdValue(usr_var);
				//serverGroup = descGrp.getServerGroup(str_comp,testName,b_portRelev);
				//policyName = descGrp.getPolicyForTest(serverGroup,testName);
				//val = descGrp.getPolicyValue(policyName);
				if(val.length() == 0)
				{
					serverGroup = descGrp.getServerGroup(str_comp,testName,b_portRelev);
					if (serverGroup != null && serverGroup.size() > 0)
					{
						String thisGroup = (String) serverGroup.get(0);
						policyName = descGrp.getPolicyForTest(thisGroup,testName);
						val = descGrp.getPolicyValue(policyName);
					}
					//val = egThresh.getUserThresholdValue(usr_var);
				}
				if(val.length() == 0)
				{
					String threshinf = threshInfo;//request.getParameter("threshinfo");
					serverGroup = descGrp.getServerGroup(str_comp,testName,b_portRelev,threshinf);
					if (serverGroup != null && serverGroup.size() > 0)
					{
						String thisGroup = (String) serverGroup.get(0);
						if (threshinf != null && threshinf.length() > 0)
							policyName = descGrp.getPolicyForTest(thisGroup,testName,threshinf);
						val = descGrp.getPolicyValue(policyName);
					}
				}
			}

			if(!val.equals(""))
				count1 = 1;
		}
		if(val.equals(""))
		{
			strIniVal = egThresh.getDefaultThresholdValue(testName);
			isSpecThreshAvail = false; 
		}
		else
		{
			strIniVal = val;
			isSpecThreshAvail = true; 
		}
		st = new StringTokenizer(strIniVal,",");
		boolean multiThresh = false;
		String[] alarmPolicies= egThresh.getAllAlarmPolicies();
		st = new StringTokenizer(strIniVal,",");
		ArrayList allAuditLogList = new ArrayList();
		if(true)
		{
%>
			<table align="center" width="85%" cellspacing="0" cellpadding="3" border="0" id="cell_border1">
				<col width="29%"><col width="29%"><col width="29%"><col width="13%">
				<tr>
					<td id="table_head" class="eg_subcontent" align="center"><b><egui:intnl text="admin.threshold.Measurements"/></b></td>
					<td id="table_head" class="lineleft" align="center" ><b><egui:intnl 
					text="admin.threshold.Minimum"/></b></td>
					<td id="table_head" class="lineleft" align="center" ><b><egui:intnl text="admin.threshold.Maximum"/></b></td>
					<td id="table_head" class="lineleft" align="center" ><b><egui:intnl text="admin.threshold.Alarm Policy"/></b></td>
				</tr>
				<tr>
					<td id="eg_cellbgmedium" class="eg_subcontent" align="left" >&nbsp;</td>
					<td id="eg_cellbgmedium" class="eg_subcontent" align="left"  >
						<table cellspacing="0" cellpadding="1" border="0" width="100%" >
							<tr>
								<td align="center" width="42%" class="eg_subcontent"><egui:intnl text="admin.threshold.Absolute"/></td>
								<td width="68%" align="center" class="eg_subcontent"><egui:intnl text="admin.threshold.Relative"/></td>
							</tr>
						</table>
					</td>
					<td id="eg_cellbgmedium" class="eg_subcontent"  align="left" >
						<table cellspacing="0" cellpadding="0" border="0" width="100%">
							<tr>
								<td align="center" width="42%" class="eg_subcontent"><egui:intnl text="admin.threshold.Absolute"/></td>
								<td width="68%" align="center" class="eg_subcontent"><egui:intnl text="admin.threshold.Relative"/></td>
							</tr>
						</table>
					</td>
					<td id="eg_cellbgmedium" class="eg_subcontent" align="left">&nbsp;</td>
				</tr>
<%
			v_abs = new Vector();
			v_abs.addElement(serverName);
			v_abs.addElement(testName);
			count=0;
			v_temp = new Vector();
			boolean cellFlag=false;
			while(st.hasMoreTokens())
			{
				strTok=st.nextToken();
				st1 = new StringTokenizer(strTok,":");
				while(st1.hasMoreTokens())
				{
					prior = "";
					measure = st1.nextToken();
					policy = st1.nextToken();
					if(policy.equalsIgnoreCase("none"))
					{
						policy = "mix";
					}
					//~~~~~~3/4/2006 Thirumal Azhagan ~~~~~~
					if (policy.equalsIgnoreCase("relative"))
					{
						min = st1.nextToken();
						relA = min;
						if (min.equals("-1"))
						{
							relA = "none";
							min = relA;
						}
						max = st1.nextToken();
						relB = max;
						if (max.equals("-1"))
						{
							relB = "none";
							max = relB;
						}
						alarmpolicy = st1.nextToken();
						st1.nextToken();
						wholeStr=measure+":"+policy+":"+ relA+":"+relB;
						v_temp.addElement(wholeStr);
						absA = "none";
						absB = "none";
					}
					else if (policy.equalsIgnoreCase("absolute"))
					{
						min = st1.nextToken();
						absA = min;
						if (min.equals("-1"))
						{
							absA = "none";
							min = absA;
						}
						max = st1.nextToken();
						absB = max;
						if (max.equals("-1"))
						{
							absB = "none";
							max = absB;
						}
						alarmpolicy = st1.nextToken();
						st1.nextToken();
						wholeStr=measure+":"+policy+":"+ absA+":"+absB;
						v_temp.addElement(wholeStr);
						relA = "none";
						relB = "none";
					}
					else if (policy.equalsIgnoreCase("mix"))
					{
						min = st1.nextToken();
						max = st1.nextToken();
						Vector _vec = getAbsAndRel(min);
						absA = (String) _vec.get(0);
						relA = (String) _vec.get(1);
						Vector _vec1 = getAbsAndRel(max);
						absB = (String) _vec1.get(0);
						relB = (String) _vec1.get(1);
						alarmpolicy = st1.nextToken();
						st1.nextToken();
						StringBuffer sb1 = new StringBuffer();
						StringBuffer sb2 = new StringBuffer();
						sb1.append(absA);
						sb1.append("&");
						sb1.append(relA);
						String m1 = sb1.toString();
						sb2.append(absB);
						sb2.append("&");
						sb2.append(relB);
						String m2 = sb2.toString();
						if (absA.equals("none") && relA.equals("none"))
							m1 = "none";
						if (absB.equals("none") && relB.equals("none"))
							m2 = "none";
						wholeStr = measure+":"+policy+":"+ m1+":"+m2;
						v_temp.addElement(wholeStr);
					}
					else//none
					{
						min = st1.nextToken();
						max = st1.nextToken();
						absA = min;
						absB = max;
						if (min.equals("-1"))
						{
							absA = "none";
							min = absA;
						}
						if (max.equals("-1"))
						{
							absB = "none";
							max = absA;
						}
						alarmpolicy = st1.nextToken();
						st1.nextToken();
						wholeStr=measure+":"+policy+":"+ absA+":"+absB;
						v_temp.addElement(wholeStr);
						relA = "none";
						relB = "none";
					}
					//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
					pol="pol"+count;
%>
				<tr>
					<td id="<%=cellFlag?"cell_border3":"cell_border4"%>" class="eg_subcontent" wrap><egui:intnl measure='<%=testName+":"+measure%>'/></td>
					<input type=hidden name=<%=pol%> value=<%=policy%>>
<%
					boolean isNegativeValuesAllowed = testerInfo.isNegativeValuesAllowed(testName,measure);
					String readOnly = "";
					if(isNegativeValuesAllowed)
					{
						readOnly = "readOnly";
					}
					String measureNameForUI = _mapping.getMeasureDescription(testName,measure);
%>
					<input type = "hidden" id = "<%="ANV"+count%>" name ="<%="ANV"+count%>" value = '<%=measureNameForUI+":"+isNegativeValuesAllowed%>'>
<%
					ArrayList auditLogList = new ArrayList();
					auditLogList.add((testName+":"+measure));
					auditLogList.add(absA);
					auditLogList.add(relA);
					auditLogList.add(absB);
					auditLogList.add(relB);
					if(alarmpolicy != null && (alarmpolicy.trim().equalsIgnoreCase("none")))
					{
						auditLogList.add("immediate");
					}
					else
						auditLogList.add(alarmpolicy);
					allAuditLogList.add(auditLogList);
					absoluteA = "absA"+count;
					absoluteB = "absB"+count;
					relativeA = "relA"+count;
					relativeB = "relB"+count;
					alarmString="alarm"+count;
%>
					<td id="<%=cellFlag?"cell_border3":"cell_border4"%>" class="eg_subcontent" align="center">
						<table cellspacing="0" cellpadding="0" border="0" >
							<tr>
								<td><input type=text name=<%=absoluteA%> value=<%=absA%> size="8" style="width:85px"></td>
								<td width="20">&nbsp;</td>
								<td id="eg_subcontentbg" class="eg_subcontent" align="center" ><input type=text name=<%=relativeA%> value=<%=relA%> size="8" class="list" style="width:110px" <%=readOnly%>></td>
							</tr>
						</table>
					</td>
					<td id="<%=cellFlag?"cell_border3":"cell_border4"%>" class="eg_subcontent" align="center" >
						<table cellspacing="0" cellpadding="0" border="0" >
							<tr>
								<td><input type=text name=<%=absoluteB%> value=<%=absB%> size="8" style="width:85px"></td>
								<td width="20">&nbsp;</td>
								<td id="eg_subcontentbg" class="eg_subcontent" align="center" ><input type=text name=<%=relativeB%> value=<%=relB%> size="8" class="list" style="width:110px" <%=readOnly%>></td>
							</tr>
						</table>
					</td>
					<td id="<%=cellFlag?"cell_border3":"cell_border4"%>" class="eg_subcontent"  align="center" >
						<select name="<%=alarmString%>" class="list" style="width:85px"><%//=HtmlUtils.setSelectOptions(alarmPolicies, alarmpolicy)%>
<%
					for (int x=0;x<alarmPolicies.length;x++)
					{
						if (defaultPolicies.contains(alarmPolicies[x]))
						{
%>
											<option value="<%=alarmPolicies[x]%>" <%=(alarmPolicies[x].equals(alarmpolicy))?"selected":""%> ><%=alarmPolicies[x]%></option>		
<%
						}
						else
						{
%>
											<option value="<%=alarmPolicies[x]%>" <%=(alarmPolicies[x].equals(alarmpolicy))?"selected":""%> ><%=alarmPolicies[x]%></option>		
<%
						}
					}
%>
						</select>
					</td>
<%
					v_abs.addElement(measure);
					v_abs.addElement(policy);
					v_abs.addElement(min);
					v_abs.addElement(max);
					v_abs.addElement(alarmpolicy);
					v_abs.addElement(prior);
					session.setAttribute("v_absolute",v_abs);
				}
				count=count+1;
%>
				</tr>
<%
				cellFlag=!cellFlag;
			}
%>
				<input type="hidden" name="threshType" value="Multiple">
			</table>
<%
			session.setAttribute("v_compare",v_temp);
		}//END OF IF FOR SINGLE THRESHOLDS 
		session.setAttribute("previousValues",allAuditLogList);
%>
			<br>
			<table border="0">
				<tr>
					<td colspan="13" height="15" align="center" nowrap>
						<input type="button" name="up" value='<egui:intnl text="admin.common.Update"/>' onClick="javascript:populateNEW('1')"  class="eg_back" style="width:70px;"> &nbsp; &nbsp;
<%
		String info = threshInfo;//request.getParameter("threshinfo");
		if((count1 == 1) && (info == null))
		{
%>
						<input type="button" name="del" value='<egui:intnl text="admin.common.Delete"/>' onClick="javascript:deletethresh()" class="eg_back" style="width:70px;">&nbsp; &nbsp;
<%
		}

		String str = request.getParameter("abc");
		if((str == null) || (str.equals("null")))
		{
%>
						<input type="button" name="ref" value='<egui:intnl text="admin.threshold.Refine"/>' onClick="javascript:populate1()" class="eg_back" style="width:70px;">
<%
		}
%>
					</td>
				</tr>
			</table>
			<input type=hidden name="measNo" value=<%=count%>>
<%
	}

	if (str_comp_type != null 
		&& !str_comp_type.equals("") 
		&& !str_comp_type.equals("null"))
	{
		session.setAttribute("hostname",Comp);
	}
	else
	{
		session.setAttribute("hostname",str_comp_name);
	}
%>
			<input type=hidden name=comptype value=<%=serverType%>>
			<input type=hidden name="delet" value="">
			<input type=hidden name="t_name" value="<%=request.getParameter("t_name")%>">
			<input type=hidden name="server" value="<%=serverType%>">
			<input type=hidden name="compname" value="<%=request.getParameter("compname")%>">
			<input type=hidden name="abc" value="<%=request.getParameter("abc")%>">
			<input type=hidden name="threshinfo" value="<%=threshInfo%>">
			<input type="hidden" name="value" value="<%=strIniVal%>">
			<input type="hidden" name="value1" value="<%=value%>">
			<input type="hidden" name="click1" value="<%=click1%>">
			<input type=hidden name="thresh_comp" value="<%=request.getParameter("comp")%>">
			<!-- Inner most table ends here -->
		</td>
	</tr>
</table>
</form>
</body>
</html>

<%!
	public String removeNull(String compName)
	{
		if (compName != null && compName.length()>0)
		{
			return (compName.endsWith(":NULL"))?compName.substring(0,compName.indexOf(":NULL")):compName;
		}
		else
		{
			return "";
		}
	}

	// T.Thirumal Azhagan    3/7/2006
	public Vector getAbsAndRel(String format) // for mix format in threshold ,introduced by BOSS(MIX)
	{
		Vector vect = new Vector();	// [absolute,relative]
		StringTokenizer stok1 = new StringTokenizer(format,"/");
		if (!format.equals("-1") && stok1.countTokens() == 3)
		{
			String h;
			String m;
			String l;
			String H = stok1.nextToken();
			String M = stok1.nextToken();
			String L = stok1.nextToken();
			if (!(H.equals("-")))
			{
				if (H.indexOf("&") > -1)
				{
					StringTokenizer st = new StringTokenizer(H,"&");
					H = st.nextToken();
					h = st.nextToken();
				}
				else
				{
					if (H.indexOf("sqc") > -1)
					{
						h = H;
						H = "-";
					}
					else
					{
						h = "-";
					}
				}
			}
			else
			{
				h = "-";
			}
			if (!(M.equals("-")))
			{
				if (M.indexOf("&") > -1)
				{
					StringTokenizer st = new StringTokenizer(M,"&");
					M = st.nextToken();
					m = st.nextToken();
				}
				else
				{
					if (M.indexOf("sqc") > -1)
					{
						m = M;
						M = "-";
					}
					else
					{
						m = "-";
					}
				}
			}
			else
			{
				m = "-";
			}
			if (!(L.equals("-")))
			{
				if (L.indexOf("&") > -1)
				{
					StringTokenizer st = new StringTokenizer(L,"&");
					L = st.nextToken();
					l = st.nextToken();
				}
				else
				{
					if (L.indexOf("sqc") > -1)
					{
						l = L;
						L = "-";
					}
					else
					{
						l = "-";
					}
				}
			}
			else
			{
				l = "-";
			}
			StringBuffer sb2 = new StringBuffer();
			StringBuffer sb1 = new StringBuffer();
			String s1 = null;
			if (H.equals("-") && M.equals("-") && L.equals("-"))
			{
				s1 = "none";
			}
			else
			{
				sb1.append(H);
				sb1.append("/");
				sb1.append(M);
				sb1.append("/");
				sb1.append(L);
				s1 = sb1.toString();
			}
			String s2 = null;
			if (h.equals("-") && m.equals("-") && l.equals("-"))
			{
				vect.add(s1);
				vect.add("none");
			}
			else
			{
				sb2.append(h);
				sb2.append("/");
				sb2.append(m);
				sb2.append("/");
				sb2.append(l);
				s2 = sb2.toString();
				vect.add(s1);
				vect.add(s2);
			}
		}
		else
		{
			vect.add("none");
			vect.add("none");
		}
		return vect;
	}
%>

<%
	if(request.getQueryString()!=null)
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/EgConfigThresh.jsp?"+request.getQueryString());
	}
	else
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/EgConfigThresh.jsp");
	}
%>



