<!DOCTYPE html>

<%@ include file = "EgTrackerA.jsp" %>
<%@ taglib prefix ="egui" uri="../WEB-INF/eg-taglib.tld"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>

<html>
<head>
	<title>Backup/Revert Configuration</title>
	<meta charset="utf-8">

	<egui:skin ui="admin"/>

	<script type="text/javascript" src="../extjs/ext-all.js"></script>

	<!-- Fancy Scroll-->
	<script src="/final/scripts/jquery-1.8.2.js"></script>
	<script src="/final/styles/jscrollpane/jquery.jscrollpane.js" ></script>
	<script src="/final/styles/jscrollpane/jquery.mousewheel.js" ></script>
	<script src="/final/styles/jscrollpane/mwheelIntent.js" ></script>
	<link rel="stylesheet" href="/final/styles/jscrollpane/jquery.jscrollpane.css"/>

	<script type="text/javascript" src="ICBackup/app/app.js"></script>

	<script language="javascript">
	Ext.onReady(function(){
		Ext.Ajax.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
		Ext.data.Connection.prototype.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
		Ext.data.ScriptTagProxy.prototype.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};

		Ext.Ajax.on('requestexception', function (conn, response, options) {
			var errorStr = response.responseText;
			if (errorStr != undefined && errorStr != 'undefined' && errorStr.indexOf("customerror") != -1)
			{
				if (errorStr.indexOf("user-session-invalid") != -1)
				{
					callWindow(1);
				}
				else if (errorStr.indexOf("user-deleted") != -1)
				{
					callWindow(2);
				}
				else if (errorStr.indexOf("user-timedout") != -1)
				{
					callWindow(3);
				}
			}
			else
			{
				if (response.status == 302 || (response.timedout != undefined && response.timedout == true))
				{
					Ext.Msg.show({
						title : errorTitle,
						msg : requestTimeOut,
						buttons : Ext.Msg.OK,
						icon : Ext.MessageBox.ERROR
					});
				}
				else
				{
					console.log(response.responseText);
					Ext.Msg.show({
						title : errorTitle,
						msg : probsErrorMessage,
						buttons : Ext.Msg.OK,
						icon : Ext.MessageBox.ERROR
					});
				}
			}
		});
	});
	</script>

	<script language="JavaScript1.2">
	var csrfToken = '<%=strCsrfToken%>';
	var pageDesc = '<egui:intnl description="EgBackupConfig.jsp"/>.';
	var pageTitle = '<egui:intnl text="admin.title.Backup/Revert"/>';
	var publicJSON = '';

	var confirmMsg1 = '<egui:intnl text="admin.ic.This would update your backup with the current set of configuration"/>. <egui:intnl text="admin.ic.Do you want to proceed?"/>';
	var confirmMsg2 = '<egui:intnl text="admin.ic.This would replace the current configuration with those that were taken in the last backup process"/>. <egui:intnl text="admin.ic.Do you want to proceed?"/>';
	var captionBackup = '<egui:intnl text="admin.ic.the current configuration"/>';
	var captionRevert = '<egui:intnl text="admin.ic.to the previously backed up configuration"/>';
	var backup = '<egui:intnl text="admin.ic.Backup"/>';
	var revert = '<egui:intnl text="admin.ic.Revert"/>';
	var updating = '<egui:intnl text="admin.common.Updating"/>...';

	var probsErrorMessage = '<egui:intnl text="admin.error.Problem encountered while loading the user interface"/>.';
	var requestTimeOut = '<egui:intnl text="admin.error.Response timed out"/>.';
	var errorTitle = '<egui:intnl text="admin.user.Error"/>';
	</script>
</head>
<body>
</body>
</html>

<%
	if (request.getQueryString()!=null)
		session.setAttribute("adminLastAccessedURL","/final/admin/EgBackupConfig.jsp?"+request.getQueryString());
	else
		session.setAttribute("adminLastAccessedURL","/final/admin/EgBackupConfig.jsp");
%>



