<!DOCTYPE html>

<%
/***********************************************************************************************************
 *   File		:	EgAssignAgents.jsp
 *   Purpose	:	To assign agent to redundant managers
************************************************************************************************************/
%>

<%@ include file = "EgTrackerA.jsp" %>
<%@ page import = "java.util.*"%>
<%@ page import = "com.eg.EgDiscInfo"%>
<%@ page import = "com.eg.EgManagersIniForManager"%>
<%@ page import = "com.eg.EgInstallInfo"%>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import = "com.egurkha.*"%>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page import = "com.eg.EgServicesInfo"%>
<%@ page language = "java" contentType = "text/html; charset=UTF-8" pageEncoding = "UTF-8"%>
<%@ taglib prefix = "egui" uri = "../WEB-INF/eg-taglib.tld"%>

<html>
<head>
	<meta charset="utf-8">
	<egui:skin ui="admin"/>

	<script type="text/javascript" src="../extjs/ext-all.js"></script>

	<!-- Fancy Scroll-->
	<script src="/final/scripts/jquery-1.8.2.js"></script>
	<script src="/final/styles/jscrollpane/jquery.jscrollpane.js" ></script>
	<script src="/final/styles/jscrollpane/jquery.mousewheel.js" ></script>
	<script src="/final/styles/jscrollpane/mwheelIntent.js" ></script>
	<link rel="stylesheet" href="/final/styles/jscrollpane/jquery.jscrollpane.css"/>

	<script type="text/javascript" src="AssignToManager/app/app.js"></script>

	<script language="JavaScript1.2">
		var csrfToken = '<%=strCsrfToken%>';
		var pageTitle = '<egui:intnl text="admin.title.ASSIGN - AGENTS"/>';
		var pageDescc = '<egui:intnl description="EgAssignAgents.jsp"/>';

		var probsErrorMessage = '<egui:intnl text="admin.error.Problem encountered while loading the user interface"/>';
		var requestTimeOut = '<egui:intnl text="admin.error.Response timed out"/>';
		var errorTitle = '<egui:intnl text="admin.user.Error"/>';

		Ext.onReady(function(){
			Ext.Ajax.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
			Ext.data.Connection.prototype.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
			Ext.data.ScriptTagProxy.prototype.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};

			Ext.Ajax.on('requestexception', function (conn, response, options) {
				var errorStr = response.responseText;
				if (errorStr != undefined && errorStr != 'undefined' && errorStr.indexOf("customerror") != -1)
				{
					if (errorStr.indexOf("user-session-invalid") != -1)
					{
						callWindow(1);
					}
					else if (errorStr.indexOf("user-deleted") != -1)
					{
						callWindow(2);
					}
					else if (errorStr.indexOf("user-timedout") != -1)
					{
						callWindow(3);
					}
				}
				else
				{
					if (response.status == 302 || (response.timedout != undefined && response.timedout == true))
					{
						Ext.Msg.show({
							title : errorTitle,
							msg : requestTimeOut,
							buttons : Ext.Msg.OK,
							icon : 'iconError'
						});
					}
					else
					{
						console.log(response.responseText);
						Ext.Msg.show({
							title : errorTitle,
							msg : probsErrorMessage,
							buttons : Ext.Msg.OK,
							icon : 'iconError'
						});
					}
				}
			});
		});
	</script>
</head>

<%
	AuditLogThread auditLogThread = new AuditLogThread();
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",_user.getLoginID());
	auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
	auditLogThread.setValue("Session_id",session.getId());
	auditLogThread.setValue("Module","Agents");
	auditLogThread.setValue("Activity","Redundant Manager");

	int clusterType = EgInstallInfo.iclusterType;
	User user=registry.getUser(session.getId());
	com.egurkha.ini.IniUI ui = (com.egurkha.ini.IniUI)com.egurkha.ini.IniUI.getInstance();
	String thisLanguage = ui.getDefaultLanguage();
	if (user!=null)
	{
		String userLang = user.getLanguage();
		if (userLang!=null && !userLang.equalsIgnoreCase("NULL"))
		{
			thisLanguage=userLang;
		}
	}

	EgServicesInfo servicesInfo = new EgServicesInfo("manager");
	String mailSender = servicesInfo.getMonitorMailAdds();

	EgMappingInfo mappingInfo = new EgMappingInfo(thisLanguage);
	if((!EgInstallInfo.isClusterSupported) ||(EgInstallInfo.isClusterSupported && clusterType != 1))
	{
		Vector sess_vec = new Vector();
		sess_vec.addElement(mappingInfo.getTextDescription("admin.error.Agent status page"));
		sess_vec.addElement("EgServerList.jsp");
		sess_vec.addElement(mappingInfo.getTextDescription("admin.error.Assign agents"));
		sess_vec.addElement(mappingInfo.getTextDescription("admin.error.This feature is not supported by your license")+"."); 
		if (mailSender == null || mailSender.length() == 0)
		{
			sess_vec.addElement(mappingInfo.getTextDescription("admin.error.Please contact your eG administrator") + " " + mappingInfo.getTextDescription("admin.error.for more details")+".");
		}
		else
		{
			sess_vec.addElement(mappingInfo.getTextDescription("admin.error.Please contact") + " <a href='mailTo:"+mailSender+"' target='_parent' class='dash_link'><b>"+mailSender+"</b></a> " + mappingInfo.getTextDescription("admin.error.for more details")+".");
		}
		session.putValue("vec_Errors",sess_vec);
		/* code for auditlog starts */
		auditLogThread.setValue("Description","Redundant manager feature is not supported by your license");
		auditLogThread.sendItToDB();
		/* code for auditlog ends */
		session.setAttribute("adminLastAccessedURL","/final/admin/EgAssignAgents.jsp");
%>
		<jsp:forward page="EgErrors.jsp" />
<%
	}
%>

<body>
<div id="loadmask" class="x-mask-msg x-layer x-mask-msg-default" style="z-index: 19001;left:45%;top:35%;">
	<div class="x-mask-loading" style="position:relative">
		Loading...
	</div>
</div>
</body>

</html>



