<%/*******************************************************************************
 *	File name			:	EgAssetConfigUpload.jsp
 *	Purpose				:	to upload and display the asset information.
 *	Creation Date		:	15-10-2012 (dd-MM-yyyy)
 ******************************************************************************/
%>
<%@ include file="EgTrackerA.jsp"%>
<%@ page import = "java.io.*"%>
<%@ page import = "java.util.*" %>
<%@ page import = "java.text.SimpleDateFormat" %>
<%@ page import = "com.eg.EgInstallInfo"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "com.egurkha.util.multipart.*"%>
<%@ page import = "com.egurkha.admin.EgAssetInfoReader"%>
<%@ page import = "com.egurkha.admin.EgAssetManagementDAO"%>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import = "com.eg.EgDateInfo"%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>
<html>
<head>
<egui:skin ui = "admin"/>
<script language="javascript">
function closewindow()
{
	window.history.back();
}
</script>
</head>
<body>
<%
	FileWriter fwriter = null;
	EgAssetInfoReader assetReader = new EgAssetInfoReader();
	SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
	EgDateInfo dateInfo = new EgDateInfo();

	ArrayList getDefHeaderList = null, getCusHeaderList = null, getDefOuterValList = null, getCusOuterValList = null, getTargetHostList = new ArrayList();
	boolean defaultValuesAvailable = false, repeatedColumns = false;
	int hostInserted = 0;
	EgAssetManagementDAO assetDAO = new EgAssetManagementDAO();
	EgMappingInfo mappingInfo = new EgMappingInfo(trackerLanguage);
	Hashtable ht_parampart=new Hashtable();
	Hashtable ht_filepart=new Hashtable();
	ArrayList trgtHostLists = new ArrayList();
	String getDt = "";
	String installDir = EgInstallInfo.getInstallDir();
	installDir = StringUtils.replace(installDir, '\\', '/');
	String fileName = "", assetFilePath = installDir+"/asset/";
	try
	{
		fwriter = new FileWriter(installDir+"/manager/logs/assetInfo.log");
		/*****************To get File and write into /egurkha_installsDir/asset/ directory******************/
		MultipartParser mp = new MultipartParser(request, 10*1024*1024); // 10MB
		Part part;
		String folder="";
		
		while ( ( part = mp.readNextPart() ) != null )
		{
			String name = part.getName();
			if ( part.isParam() )
			{
				ParamPart paramPart = (ParamPart) part;
				ht_parampart.put( name, paramPart.getStringValue() );
			}
			else if ( part.isFile() )
			{
				FilePart filePart = (FilePart) part;
				ht_parampart.put("#"+name, name);
				ByteArrayOutputStream baos = new ByteArrayOutputStream();
				filePart.writeTo( baos );
				byte[] fileContent = baos.toByteArray();
				baos.flush();
				baos.close();
				if ( fileContent.length > 0 )
				{
					ht_parampart.put(name+"_name", filePart.getFileName());
					ht_filepart.put(name, fileContent);
				}
			}
		}
		Iterator itr = ht_filepart.keySet().iterator();
		byte[] thisFileContent=null;
		boolean checkCustomFolder = false;
		File f = new File(installDir+"/asset/");
		if ( !f.isDirectory() )
		{
			f.mkdir();
		}
		while(itr.hasNext())
		{
			String key = (String) itr.next();
			fileName = (String) ht_parampart.get(key+"_name");
			thisFileContent = ( byte[] )ht_filepart.get( key );
			File thisFile = new File(installDir+"/asset/"+fileName);
			getDt = assetReader.getLogDate();
			fwriter.write(getDt+" INFO Asset Info - "+fileName+" uploading...\n");
			fwriter.flush();
			FileOutputStream fos = new FileOutputStream(thisFile);
			fos.write(thisFileContent);
			fos.flush();
			fos.close();
			fwriter.write(getDt+" INFO Asset Info - "+fileName+" uploaded successfully.\n");
			fwriter.flush();

		}
		/*****************To get File and write into /egurkha_installsDir/asset/ directory******************/

		assetFilePath += fileName;
		Hashtable assetTbl = new Hashtable();
		if ( !StringUtils.isNull( assetFilePath ) )
		{
			getDt = assetReader.getLogDate();
			fwriter.write(getDt+" INFO reading Asset Information from "+fileName+"\n");
			fwriter.flush();
			if ( assetFilePath.endsWith("csv") )
			{
				assetReader.readFromCSV(assetFilePath);
			}
			else if ( assetFilePath.endsWith("xls") )
			{
				assetReader.readFromXLS(assetFilePath);
			}
			assetTbl = assetReader.getAssetTable();
			if ( assetTbl != null && !assetTbl.isEmpty() )
			{
				fwriter.write(getDt+" INFO read Asset Information from "+fileName+"\n");
				fwriter.flush();
			}
			else
			{
				fwriter.write(getDt+" ERROR "+fileName+" file may be invalid format or Empty. \n");
				fwriter.flush();
			}
		}
		if ( assetTbl != null && !assetTbl.isEmpty() && assetTbl.containsKey("def_header") )
		{
			getDefHeaderList  = (ArrayList) assetTbl.get("def_header");
		}
		if ( assetTbl != null && !assetTbl.isEmpty() && assetTbl.containsKey("cus_header") )
		{
			getCusHeaderList  = (ArrayList) assetTbl.get("cus_header");
		}

		if ( getDefHeaderList == null || getDefHeaderList.isEmpty() || getDefHeaderList.size() < 20 )
		{
			getDt = assetReader.getLogDate();
			fwriter.write(getDt+" ERROR Please should give default values \n");
			fwriter.flush();
%>
<br/><br/>
<table align="center" width="90%" cellspacing="0" cellpadding="0" border="0" class="eg_subcontentbg">
	<tr>
		<td height="6" id="inner_top_left" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
		<td height="6" id="eg_subcontentbg" colspan="3"><img src="/final/admin/eg_images/spacer.gif" height="6"></td>
		<td height="6" id="inner_top_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
	</tr>
	<tr>
		<td width="7" align="left"class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
		<td align="center" id="eg_subcontentbg" nowrap colspan="3">
			<table border="0" cellspacing="0" cellpadding="0" width="100%" height="100%">
				<tr>
					<td align="center"><b><egui:intnl text="admin.Asset.Please should give default values" /></b>&nbsp;</td>
				</tr>
			</table>
		</td>
		<td width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
	</tr>
	<tr>
		<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
		<td id="eg_subcontentbg" valign="top" colspan="3"><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
		<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
	</tr>
</table>
<%
		}
		else if ( getDefHeaderList == null || getDefHeaderList.isEmpty() || getDefHeaderList.size() >= 20 )
		{
			defaultValuesAvailable = true;
		}

		if ( getDefHeaderList != null && !getDefHeaderList.isEmpty() && getCusHeaderList != null && !getCusHeaderList.isEmpty() )
		{
			for ( int i = 0; i < getDefHeaderList.size(); i++ )
			{
				String getDefVal = (String) getDefHeaderList.get(i);
				for ( int j = 0; j < getCusHeaderList.size() ; j++ )
				{
					String getCusVal = (String) getCusHeaderList.get(j);
					if ( getDefVal.equalsIgnoreCase(getCusVal) && ( !StringUtils.isNull(getDefVal) && !StringUtils.isNull(getCusVal) ) )
					{
						repeatedColumns = true;
						getDt = assetReader.getLogDate();
						fwriter.write(getDt+" ERROR "+getDefVal+" appears two times in sheet, Please check the header name \n");
						fwriter.flush();
%>

<br/><br/>
<table align="center" width="90%" cellspacing="0" cellpadding="0" border="0" class="eg_subcontentbg">
	<tr>
		<td height="6" id="inner_top_left" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
		<td height="6" id="eg_subcontentbg" colspan="3"><img src="/final/admin/eg_images/spacer.gif" height="6"></td>
		<td height="6" id="inner_top_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
	</tr>
	<tr>
		<td width="7" align="left"class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
		<td align="center" id="eg_subcontentbg" nowrap colspan="3">
			<table border="0" cellspacing="0" cellpadding="0" width="100%" height="100%">
				<tr>
					<td align="center"><b>'<%=getDefVal%>'&nbsp;<egui:intnl text="admin.Asset.Appears two times in sheet, Please check the header name" /></b></td>
				</tr>
			</table>
		</td>
		<td width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
	</tr>
	<tr>
		<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
		<td id="eg_subcontentbg" valign="top" colspan="3"><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
		<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
	</tr>
</table>

<%
						break;
					}
				}
			}
		}
		
		if ( assetTbl != null && !assetTbl.isEmpty() && assetTbl.containsKey("def_values") )
		{
			getDefOuterValList = (ArrayList) assetTbl.get("def_values");
		}
		if ( assetTbl != null && !assetTbl.isEmpty() && assetTbl.containsKey("cus_values") )
		{
			getCusOuterValList = (ArrayList) assetTbl.get("cus_values");
		}

		if ( getDefOuterValList != null && !getDefOuterValList.isEmpty() )
		{
			Iterator defOuterItr = getDefOuterValList.iterator();
			int getListIndex = 0;
			getDt = assetReader.getLogDate();
			fwriter.write(getDt+" INFO Checking Host Name \n");
			fwriter.flush();
			while ( defOuterItr.hasNext() )
			{
				ArrayList getDefValList = (ArrayList) defOuterItr.next();
				String genCmpTypeWithNamePort = "";
				if ( getDefValList != null && !getDefValList.isEmpty() )
				{
					String getCmpTypeWithName = "", compType = "", reverseCompType = "";
					getCmpTypeWithName = (String) getDefValList.get(0);
					getCmpTypeWithName = StringUtils.replace(getCmpTypeWithName, '\"', ' ');
	                           	getCmpTypeWithName = getCmpTypeWithName.trim();
					if ( getCmpTypeWithName.indexOf(":") > 0)
					{
						compType = getCmpTypeWithName.substring(0, getCmpTypeWithName.indexOf(":") );
						reverseCompType = mappingInfo.getReverseComponentTypeDescription(compType);
					}
					if ( !StringUtils.isNull( reverseCompType ) )
					{
						int getColCount = 0;
						StringTokenizer strTkn = new StringTokenizer(getCmpTypeWithName, ":");
						getColCount = strTkn.countTokens();
						if ( ( reverseCompType.equals("Oracle_server") && getColCount != 4 ) || ( !reverseCompType.equals("Oracle_server") && getColCount != 2 ) )
						{
							defOuterItr.remove();
							if ( getCusOuterValList != null && !getCusOuterValList.isEmpty() )
							{
								getCusOuterValList.set(getListIndex, "");

							}
							getDt = assetReader.getLogDate();
							fwriter.write(getDt+" ERROR '"+getCmpTypeWithName+"' is not a valid Host Name and not imported, Please check the Servertype, Nick name and Port or with Instance name...\n");
							fwriter.flush();
							trgtHostLists.add(getCmpTypeWithName+"|false");
						}
						else
						{
							
							String tmpCmpNameWithPort = getCmpTypeWithName.substring( getCmpTypeWithName.indexOf(":") + 1 );
							genCmpTypeWithNamePort = reverseCompType+":"+tmpCmpNameWithPort;
							getDefValList.set(0, genCmpTypeWithNamePort);
							getTargetHostList.add(genCmpTypeWithNamePort);
							trgtHostLists.add(getCmpTypeWithName+"|true");
							hostInserted++;
							Date dt = dateInfo.egetRealDate();
							String getDate = sdf.format(dt);
							fwriter.write(getDate+" INFO '"+getCmpTypeWithName+"' is valid Host Name and importing...\n");
							fwriter.flush();
						}
					}
				}
				getListIndex++;
			}
			if ( getCusOuterValList != null && !getCusOuterValList.isEmpty() )
			{
				getCusOuterValList.removeAll(Collections.singleton(""));
				assetTbl.put("cus_values", getCusOuterValList);
			}
		}
		

		Hashtable getDefaultResultTable = assetDAO.insertDefaultAssetInfo(getTargetHostList, assetTbl);
		Hashtable getCustomResultTable = assetDAO.insertCustomAssetInfo(getTargetHostList, assetTbl);
%>
<%
		if ( defaultValuesAvailable && !repeatedColumns )
		{
%>
<br/><br/>
<table align="center" width="90%" cellspacing="0" cellpadding="0" border="0" class="eg_subcontentbg">
	<tr>
		<td height="6" id="inner_top_left" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
		<td height="6" id="eg_subcontentbg" colspan="3"><img src="/final/admin/eg_images/spacer.gif" height="6"></td>
		<td height="6" id="inner_top_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
	</tr>
	<tr>
		<td width="7" align="left"class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
		<td align="center" id="eg_subcontentbg" nowrap colspan="3">
			<table border="0" cellspacing="0" cellpadding="0" width="100%" height="100%">
				<tr>
					<td width="100%" align="center">
<%
			if ( getDefaultResultTable != null && !getDefaultResultTable.containsKey("error") && getCustomResultTable != null && !getCustomResultTable.containsKey("error") && ( trgtHostLists.size() == hostInserted ) )
			{
%>

						<b><egui:intnl text="admin.Asset.Asset Information Imported Successfully"/>.</b>
<%
			}
			else
			{
%>
						<b><egui:intnl text="admin.Asset.Some problems occured while importing asset information, Please check assetinfo log"/>.</b>
<%
			}
%>
					</td>
				</tr>
			</table>
		</td>
		<td width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
	</tr>
	<tr>
		<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
		<td id="eg_subcontentbg" valign="top" colspan="3"><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
		<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
	</tr>
</table>
<%
		}
%>

				
<br/>
<table align="center" width="90%" cellspacing="0" cellpadding="0" border="0" >
	<tr>
		<td width="100%" align="center">
		<input type="button" class="eg_back" value='<egui:intnl text="admin.Asset.Close"/>' onclick="javascript:history.go(-2);"/>
		</td>
	</tr>
</table>

<%
		fwriter.close();
	}
	catch ( Exception e )
	{
		System.err.println("[Exception] @ EgAssetConfigImport.jsp "+e);
		e.printStackTrace();
	}
%>

</body>
</html>