<%
/*******************************************************************************
 *	File name		:	EgAdminTopology.jsp
 *	Purpose			:	Configure Topology Graph
 *	Version			:	4.0
 *	Creation Date	:	10-08-2000
 *	Last Modified	:	
 *		28/06/2004	Arun			Added hidden field for saving segments in Egadmintopologyp.jsp
 *		21/05/2004	Vijaykumar		Merge applet, frame and table borders
 *		30/12/2003	Arun			Removes :NULL from server names
 *		17-11-2003	John Williams	eG 3.0 Layout Change
 *	Authtor			:	KrishnaKumar.C
 ******************************************************************************/
%>
<%@ include file="EgTrackerA.jsp" %>
<%@page import="com.eg.EgAggregateInfo"%>
<%@ page errorPage="EgProbs.jsp" %>
<%@ page import="com.egurkha.*"%>
<%@ page import = "com.eg.EgGroupInfo" %>
<%@ page import="java.util.*" %>
<%@ page import="com.eg.EgDiscInfo" %>
<%@ page import="com.eg.EgTopoInfo" %>
<%@ page import="com.eg.EgURLEncoder" %>
<%@ page import = "com.eg.EgName"%>
<%@ page import = "com.eg.EgInstallInfo"%>
<%@ page import = "com.eg.EgConfigInfo"%>
<%@ page import = "com.eg.MappingNameSorter"%>
<%@ page import="java.io.*" %>
<%@ page import="com.egurkha.util.StringUtils" %>
<%@ page import="com.egurkha.ini.IniUI"%>
<%@ taglib prefix = "egui" uri="../WEB-INF/eg-taglib.tld"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	String q_ctr = request.getParameter("qctr");
	if (q_ctr==null)
		q_ctr="0";
		String prevassocomp="";

	String newsegment = request.getParameter("newsegment");
	String zoomLevel = request.getParameter("zoom");
	if(zoomLevel == null)
		zoomLevel = "100";
	int limit = 15;
	String strCompSearch = request.getParameter("strCompSearch");
	String strOtherCompSearch = request.getParameter("strOtherCompSearch");
	String searchType = request.getParameter("searchType");
	boolean isSearchData = false;
	boolean isCompSearchResult = (strCompSearch != null && !strCompSearch.equalsIgnoreCase("") && !strCompSearch.equals("Search") && !strCompSearch.equals("undefined"));
	boolean isOtherCompSearchResult =(strOtherCompSearch != null && !strOtherCompSearch.equalsIgnoreCase("") && !strOtherCompSearch.equals("Search") && !strOtherCompSearch.equals("undefined"));

	ArrayList compSearchList = new ArrayList();
	ArrayList otherCompSearchList = new ArrayList();
	if (isCompSearchResult)
	{
		StringTokenizer strTokens = new StringTokenizer(strCompSearch);
		while (strTokens.hasMoreTokens())
		{
			String thisToken = strTokens.nextToken().trim();
			if (thisToken.equals("")) continue;
			compSearchList.add(thisToken);
		}
	}
	if (isOtherCompSearchResult)
	{
		StringTokenizer strTokens = new StringTokenizer(strOtherCompSearch);
		while (strTokens.hasMoreTokens())
		{
			String thisToken = strTokens.nextToken().trim();
			if (thisToken.equals("")) continue;
			otherCompSearchList.add(thisToken);
		}
	}

	IniFile egUI = new IniFile(EgConfigInfo.egMgrConfigDir + "eg_ui.ini");
	String strLimit = egUI.getValue("MISC_ARGS","SEARCHBOX_ENABLE_LIMIT");
	if(strLimit != null)
	{
		limit = Integer.parseInt(strLimit);
	}

%>

<%
	String showIndOnlyParam = request.getParameter("showIndOnlyParam");
	boolean showIndOnly = showIndOnlyParam==null || showIndOnlyParam.equals("true");
	String segment = "";
	segment = request.getParameter("segment").trim();

	EgGroupInfo groupinfo = new EgGroupInfo();
	EgTopoInfo topoinfo = groupinfo.getTopoInfoObject();//new EgTopoInfo("manager");
	boolean isCompAvailableInOtherSegments = false;
	if(segment != null && segment.length() > 0)
	{
		Vector segComps = topoinfo.getComponentsForSegment(segment);
		String [] segNames = topoinfo.getSegmentNames();
		if(segComps != null && segComps.size() > 0 && segNames != null && segNames.length > 0)
		{
			for (int i=0;i<segNames.length;i++)
			{
				String segName = segNames[i];
				if(segName.equals(segment))
					continue;

				Vector tempComps = topoinfo.getComponentsForSegment(segName);
				if(tempComps == null || tempComps.size() <= 0)
					continue;

				for (int j=0;j<tempComps.size();j++)
				{
					String segCompName = (String) tempComps.get(j);
					if(segComps.contains(segCompName))
					{
						isCompAvailableInOtherSegments = true;
						break;
					}
				}
				if(isCompAvailableInOtherSegments)
					break;
			}
		}
	}

	if(isCompAvailableInOtherSegments)
	{
		showIndOnly = false;
	}

	String ComponentType = request.getParameter("comptype");
	String ComponentList = request.getParameter("compname");
%>

<jsp:useBean id="EgConfigTopo" scope="page" class="egurkha.ConfigTopology"/>
<jsp:useBean id="zoneinfo" scope="page" class="egurkha.ZoneInfoBean"/>
<jsp:useBean id="topobean" scope="page" class="egurkha.ConfigTopoBean"/>
<jsp:useBean id="admintopo" scope="page" class="com.egurkha.admin.AdminTopologyBean"/>

<html>
<head>
<title>Admin Topology - eG Manager &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; </title>
<!-- <link rel="stylesheet" href="eg_styles/eg_adminstyle.css" /> -->
<egui:skin ui="admin"/>
<meta name="Author" content="John Williams">
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<script language="JavaScript1.2" src="/final/jquery/jquery.js"></script>
<script language="javascript">
<!--

var indOnly = <%=showIndOnly%>;
function isNetscape() 
{
	// get browser info. 
	appName= navigator.appName;
	appLongVer = navigator.appVersion;
	appVer = appLongVer.substring(0, 1); 

	// check for Navigator ver 4+. 
	if ((appName == "Netscape") && (appVer >= 4)) return true;
	return false;
}

function isIE() 
{
	// get browser info. 
	appName= navigator.appName;
	appLongVer = navigator.appVersion;
	appVer = appLongVer.substring(0, 1); 

	// check for IE ver 4+. 
	if ((appName == "Microsoft Internet Explorer") && (appVer >= 4)) return true;
	return false;
}

function populate()
{
	var fmng=new Array();
	var mnglen = document.topology.ComponentsUnder.options.length;
	var fmglst = document.topology.ComponentsUnder;
	var funmg = new Array();
	var unmg = document.topology.ComponentsUnderEgurkha.options.length;
	var unmglst = document.topology.ComponentsUnderEgurkha;
<%
	if(request.getParameter("compname") != null)
	{
%>
		var flag = true;
<%
	}
	else
	{
%>
		var flag = false;
<%
	}
%>
	for (var y = 0 ; y < mnglen ; y++ )
	{
		if(fmglst.options[y].value==null)
		{
			continue;
		}
		else
		{
			fmng[y]=fmglst.options[y].value;
		}
	}
	for (var y = 0 ; y < unmg ; y++ )
	{
		if(unmglst.options[y].value==null)
		{
			continue;
		}
		else
		{
			funmg[y]=unmglst.options[y].value;
		}
	}
	document.topology.fmanage.value=fmng;
	document.topology.fumanage.value=funmg;
	document.topology.showIndOnlyParam.value=indOnly;
	if(flag == true)
	{
		/*
		if (isNetscape()) targetObj = document.topology.up;
		if (isIE()) targetObj = document.topology.up;
		targetObj.disabled = true;
		*/
		document.topology.con.disabled=true;
		document.topology.connect.disabled=true;
		document.topology.affect.disabled=true;
		document.topology.submit();
	}
}

function addtomanage(str_dirct)
{
	var selectedFlg = false;
	//getting list size
	var j = document.topology.ComponentsUnder.options.length;
	//gettin list vars
	var list = document.topology.ComponentsUnderEgurkha;
	var mlist = document.topology.ComponentsUnder;
	for (var i = 0; i < list.options.length; i++)
	{
		//browsing through to find selected items
		if(list.options[i].selected == true)
		{
			selectedFlg = true;
			var txt=list.options[i].text;
			var val=list.options[i].value;
			var flag = 0;
			if(val == "-1")
			{
				alert("<egui:intnl text='admin.topology.Please choose a valid component'/>");
				return;
			}
			//to check if it already exists
			for ( k = 0; k < mlist.options.length ; k++)
			{
				if (val == mlist.options[k].value )
				{
					flag = 1;
				}
			}
			//addin the new name
			if(flag == 0)
			{
				var key = val.substring(0,val.lastIndexOf(':'));
				if (key.indexOf(":NULL") > -1)
				{
					key = key.substring(0, key.indexOf(":NULL"));
				}

				key = key + ':' + str_dirct + ':' + val.substring(val.lastIndexOf(':')+1);
				val=val.substring(0,val.lastIndexOf(':')) + ':' + str_dirct + ':' + val.substring(val.lastIndexOf(':')+1,val.length);
				mlist.options[j++] = new Option (key, val);
			}
		}
	}
	if(!selectedFlg)
	{
		alert("<egui:intnl text='admin.topology.Please choose a component'/>");
		return;
	}
	for(var k = list.options.length; k > 0 ; k--)
	{
		if(list.options[k-1].selected == true )
		{
			list.options[k-1] = null;
		}
	}
	populate();
}

function addtounmanage(segment,alertadmin)
{
	var proceed = false;
	var selectedComp = false;
	if(alertadmin == "true")
	{
		var a= confirm('<egui:intnl text="admin.topology.Removing component(s) from the following segment will remove the association of the segment from service(s)"/>,'+segment);
		if(a)
		{
			proceed = true;
		}
	}
	else
	{
		proceed = true;
	}

	if(proceed)
	{
		//getting list size
		var j = document.topology.ComponentsUnderEgurkha.options.length;
		//gettin list vars
		var list = document.topology.ComponentsUnder;
		if(list.options.length == 0)
		{
			alert("<egui:intnl text='admin.topology.There is no component to remove'/>");
			return;
		}
		var mlist = document.topology.ComponentsUnderEgurkha;
		var assocomp="";
		var tobeDeleted = "";
		for (var i = 0 ; i < list.options.length ; i++ )
		{
			//browsing through to find selected items
			assocomp=assocomp+","+list.options[i].value;
			if(list.options[i].selected == true)
			{
				
				var txt=list.options[i].text;
				var val=list.options[i].value;
				selectedComp = true;
				var tempVal = val;
				var compname = tempVal.substring(0,tempVal.lastIndexOf(":"));
				var comptype = tempVal.substring(tempVal.lastIndexOf(":")+1);
				tempVal = comptype+":"+compname;
				
				if(tobeDeleted == "")
					tobeDeleted = tempVal;
				else
					tobeDeleted=tobeDeleted+","+tempVal;

				var temparray = txt.split(":");
				var flag = 0;
				//alert(txt + val);
				//to check if it already exists
				for ( k = 0; k < mlist.options.length ; k++)
				{
					if ( val == mlist.options[k].value )
					{
						flag = 1;
					}
				}
				//addin the new name
				if(flag == 0)
				{
					var key = val.substring(0,val.lastIndexOf(':'));
					if (key.indexOf(":NULL") > -1)
					{
						key = key.substring(0, key.indexOf(":NULL"));
					}

					key = key + ':' + val.substring(val.lastIndexOf(':')+1);
					temp=val.substring(val.lastIndexOf(':') + 1,val.length);
					val_arr=val.split(':');
					var temp1='';
					for(var x=0;x < val_arr.length - 2;x++)
					{
						temp1=temp1 + val_arr[x] + ":";
					}
					temp1=temp1 + temp;
					mlist.options[j++] = new Option (key,temp1) ;
				}
			}
		}
		if(!selectedComp)
		{
			alert("<egui:intnl text='admin.topology.Please choose a component to remove'/>");
			return;
		}
		document.topology.prevassocomp.value=assocomp;
		document.topology.tobeDeletedHdn.value=tobeDeleted;
		for(var i = document.topology.ComponentsUnder.options.length; i > 0 ; i--)
		{
			if(document.topology.ComponentsUnder.options[i-1].selected == true )
			{
				document.topology.ComponentsUnder.options[i-1] = null;
			}
		}
		document.topology.updateZone.value="true";
		populate();
	}
}

function listselect(x)
{
	var comp_type = document.topology.ComponentsType.options[document.topology.ComponentsType.selectedIndex].value
	var segment = document.topology.segment.value;
	var zonename = document.topology.zone.value;

	var zoomlevel = document.getElementById('zoomValue').value;

	if(x == '1')
	{
		window.location.href = "EgAdminTopology.jsp?comptype=" +encodeURI(comp_type)+ "&qctr=1&segment=" + encodeURI(segment)+"&zone="+encodeURI(zonename)+"&showIndOnlyParam="+indOnly+"&newsegment=<%=newsegment%>"+"&zoom="+zoomlevel;
	}
	else
	{
		var list = document.topology.ComponentsList;
		var strCompSearchVal;
		var strOtherCompSearchVal;
		var searchType = document.topology.searchType.value;
		if(searchType == "compSearch" || searchType == "otherCompSearch")
		{
			var strCompSearch = document.getElementById("strCompSearch");
			var strOtherCompSearch = document.getElementById("strOtherCompSearch");

			if(strCompSearch != null)
			{
				strCompSearchVal = strCompSearch.value;
				if(strCompSearchVal == null || strCompSearchVal == "undefined" || strCompSearchVal == "Search")
				{
					strCompSearchVal = "";
				}
			}
			if(strOtherCompSearch != null)
			{
				strOtherCompSearchVal = strOtherCompSearch.value;
				if(strOtherCompSearchVal == null || strOtherCompSearchVal == "undefined" || strOtherCompSearchVal == "Search")
				{	
					strOtherCompSearchVal = "";
				}
			}
		}

		var comp_name = "";
		for (var i = 0 ; i < list.options.length ; i++ )
		{
			//browsing through to find selected items
			if(list.options[i].selected == true)
			{
				comp_name = list.options[i].value;
			}
		}
		if(comp_type !=  "-1")
		{
			if(list.selectedIndex < 0)
			{
				alert("<egui:intnl text='admin.topology.Please choose a component'/>");
				return;
			}
			if(comp_name == "-1")
			{
				alert("<egui:intnl text='admin.topology.Please choose a valid component'/>");
				return;
			}
			if (comp_name != " ")
			{
				window.location.href = "EgAdminTopology.jsp?comptype=" + encodeURI(comp_type) + "&compname=" + encodeURI(comp_name)+ "&qctr=1&segment=" + encodeURI(segment)+"&zone="+encodeURI(zonename)+"&showIndOnlyParam="+indOnly+"&newsegment=<%=newsegment%>"+"&zoom="+zoomlevel+"&searchType="+searchType+"&strCompSearch="+strCompSearchVal+"&strOtherCompSearch="+strOtherCompSearchVal;
			}
		}
	}//end of if(x=='1')
}

function godeletetopology(segment,zone_associated,site_associated)
{
	var comptype = document.topology.comptype.value;
	var compname = document.topology.compname.value;
	var zonename = document.topology.zone.value;
	if(site_associated == "false" && zone_associated == "false")
	{
		var a = confirm('<egui:intnl text="admin.topology.Are you sure you want to delete segment"/>,'+" '" + segment + "' ?");
		if(a)
		{
			//if (isNetscape()) targetObj = document.deleteImg;
			//if (isIE()) targetObj = deleteImg.style;
			//targetObj.visibility = "hidden";
			window.location.href = "Egdelsegmentp.jsp?qctr="+<%=q_ctr%>+"&segment=" +encodeURI(segment)+ "&destiny=segments&comptype=" +encodeURI(comptype)+ "&compname=" +encodeURI(compname)+"&zone="+encodeURI(zonename)+"&zoneAssociated="+encodeURI(zone_associated)+"&reqfrom=navlink";
		}
	}
	else
	{
		//if (isNetscape()) targetObj = document.deleteImg;
		//if (isIE()) targetObj = deleteImg.style;
		//targetObj.visibility = "hidden";
		window.location.href = "Egdelsegmentp.jsp?qctr="+<%=q_ctr%>+"&segment=" +encodeURI(segment)+ "&destiny=topology&comptype=" +encodeURI(comptype)+ "&compname=" +encodeURI(compname)+"&zone="+encodeURI(zonename)+"&zoneAssociated="+encodeURI(zone_associated)+"&reqfrom=navlink";
	}
}

var topowin;
function showtopology()
{
	var segment = document.topology.segment.value;
	var zonename = document.topology.zone.value;
	topowin = window.open('EgTopologyA.jsp?segment=' + segment+"&zone="+zonename,'topology','toolbar=yno,location=no,status=no,menubar=no,scrollbars=1,resizable,width=792,height=410,left=0,top=136,screenx=0,screeny=0');
	topowin.focus();
}

function cleanup()
{
	if(topowin != null)
	{
		topowin.close();
	}
}

function call()
{
	window.location.href = "./EgDispSegments.jsp";
}

//search function
function Search(searchType)
{
	var thisForm = document.topology;
	var comType = thisForm.ComponentsType.value;
	var compname = document.topology.compname.value;
	var segment = document.topology.segment.value;
	var zonename = document.topology.zone.value;
	var strOtherCompSearchVal = "";
	var strCompSearchVal = "";

	if (comType == "-1" )
	{
		alert('<egui:intnl text="admin.topology.Please select the component type"/>');
		return false;
	}

	if(searchType == "compSearch")
	{
		var strCompSearch = document.getElementById("strCompSearch").value;
		var strOtherCompSearch = document.getElementById("strOtherCompSearch");
		if(strOtherCompSearch != null)
		{
			strOtherCompSearchVal = strOtherCompSearch.value;
			if(strOtherCompSearchVal == null || strOtherCompSearchVal == "undefined" || strOtherCompSearchVal == "Search")
			{
				strOtherCompSearchVal = "";
			}
		}
		if (strCompSearch == null || strCompSearch == " " || strCompSearch == "null" || strCompSearch == 'Search')
		{
			thisForm.action="./EgAdminTopology.jsp?comptype="+encodeURI(comType)+"&qctr=1&segment="+encodeURI(segment)+"&zone="+encodeURI(zonename)+"&showIndOnlyParam="+indOnly+"&newsegment=true&zoom=100&searchType="+searchType+"&strCompSearch="+strCompSearch+"&strOtherCompSearch="+strOtherCompSearchVal;
		}
		else
		{
			thisForm.action="./EgAdminTopology.jsp?comptype="+encodeURI(comType)+"&qctr=1&segment="+encodeURI(segment)+"&zone="+encodeURI(zonename)+"&showIndOnlyParam="+indOnly+"&newsegment=true&zoom=100&strCompSearch="+encodeURI(strCompSearch)+"&searchType="+searchType+"&strOtherCompSearch="+strOtherCompSearchVal;;
		}
	}
	else
	{
		var strOtherCompSearch = document.getElementById("strOtherCompSearch").value;
		var strCompSearch = document.getElementById("strCompSearch");
		if(strCompSearch != null)
		{
			strCompSearchVal = strCompSearch.value;
			if(strCompSearchVal == null || strCompSearchVal == "undefined" || strCompSearchVal == "Search")
			{
				strCompSearchVal = "";
			}
		}

		if (comType == "-1" )
		{
			alert('<egui:intnl text="admin.topology.Please select the component type"/>');
			return false;
		}

		if (strOtherCompSearch == null || strOtherCompSearch == " " || strOtherCompSearch == "null" || strOtherCompSearch == 'Search')
		{
			thisForm.action="./EgAdminTopology.jsp?comptype="+encodeURI(comType)+"&qctr=1&segment="+encodeURI(segment)+"&zone="+encodeURI(zonename)+"&showIndOnlyParam="+indOnly+"&newsegment=true&zoom=100&searchType="+searchType+"&strCompSearch="+strCompSearchVal+"&strOtherCompSearch="+strOtherCompSearch;
		}
		else
		{
			thisForm.action = "./EgAdminTopology.jsp?comptype="+encodeURI(comType)+"&compname="+encodeURI(compname)+"&qctr=1&segment="+encodeURI(segment)+"&zone="+encodeURI(zonename)+"&showIndOnlyParam="+indOnly+"&newsegment=true&zoom=100&strOtherCompSearch="+encodeURI(strOtherCompSearch)+"&searchType="+searchType+"&strCompSearch="+strCompSearchVal;
		}
	}
	thisForm.submit();
}

//document.onkeydown = KeyCheck;
//function KeyCheck(e)
//{
//	if(!e)
//		var e = window.event;
//	if (e.keyCode) 
//		code = e.keyCode;
//	else if (e.which)
//		code = e.which;
//	if(code!=13)
//	{
//		return true;
//	}
//	else
//	{
//		return false;
//	}
//}

// For big screen resizable width adjustment - Jaiwin
documentView ={
		getObject: function()
		{
			if(typeof( window.innerWidth) == 'number')
			{//Firefox
				this.height = window.innerHeight;
				this.width = window.innerWidth-10;
				this.fireFox = true;
			}
			else if( document.documentElement && ( document.documentElement.clientWidth
				|| document.documentElement.clientHeight ))
			{//IE 6 + in 'standards compliant mode'
				this.height = document.documentElement.clientHeight;
				this.width = document.documentElement.clientWidth;
				this.ie = true;
			}
			else if(document.body && document.body.clientHeight)
			{ //IE 4 compatible
				this.height = document.body.clientHeight;
				this.width = document.body.clientWidth;
				this.ie = true;
			}
			this.screenHeight=window.screen.availHeight;
			this.screenWidth=window.screen.availWidth;
			return this;
		},
		getScreenHeight: function()
		{
			return this.getObject().screenHeight;
		},
		getScreenWidth: function()
		{
			return this.getObject().screenWidth;
		},
		getHeight: function()
		{
			return this.getObject().height;
		},
		getWidth: function()
		{
			return this.getObject().width;
		},
		isIE: function()
		{
			return this.getObject().ie;
		},
		isFireFox: function()
		{
			return this.getObject().fireFox;
		}
	};
var old_width=0;
function bigScreenPage()
{
	if(old_width==0)
	{
		old_width=1000;
	}
	var selectWidth1Obj = document.getElementById('selectWidth1');
	var selectWidth2Obj = document.getElementById('selectWidth2');
	var selectWidth3Obj = document.getElementById('selectWidth3');
	var selectWidth4Obj = document.getElementById('selectWidth4');
	var iframeWidthObj = document.getElementById('iframeWidth');
	if(selectWidth1Obj!=null && selectWidth1Obj!=undefined)
	{
		var selectWidth = selectWidth1Obj.style.width;
		if(selectWidth!=null && selectWidth!=undefined)
		{
			var newSelectWidth=parseInt((parseInt(selectWidth)/old_width) * documentView.getWidth());
			selectWidth1Obj.style.width=(newSelectWidth)+"px";
		}
	}
	if(selectWidth2Obj!=null && selectWidth2Obj!=undefined)
	{
		var selectWidth = selectWidth2Obj.style.width;
		if(selectWidth!=null && selectWidth!=undefined)
		{
			var newSelectWidth=parseInt((parseInt(selectWidth)/old_width) * documentView.getWidth());
			selectWidth2Obj.style.width=(newSelectWidth)+"px";
		}
	}
	if(selectWidth3Obj!=null && selectWidth3Obj!=undefined)
	{
		var selectWidth = selectWidth3Obj.style.width;
		if(selectWidth!=null && selectWidth!=undefined)
		{
			var newSelectWidth=parseInt((parseInt(selectWidth)/old_width) * documentView.getWidth());
			selectWidth3Obj.style.width=(newSelectWidth)+"px";
		}
	}
	if(selectWidth4Obj!=null && selectWidth4Obj!=undefined)
	{
		var selectWidth = selectWidth4Obj.style.width;
		if(selectWidth!=null && selectWidth!=undefined)
		{
			var newSelectWidth=parseInt((parseInt(selectWidth)/old_width) * documentView.getWidth());
			selectWidth4Obj.style.width=(newSelectWidth)+"px";
		}
	}
	if(iframeWidthObj!=null && iframeWidthObj!=undefined)
	{
		var selectWidth = iframeWidthObj.style.width;
		if(selectWidth!=null && selectWidth!=undefined)
		{
			var newSelectWidth=parseInt((parseInt(selectWidth)/old_width) * documentView.getWidth());
			iframeWidthObj.style.width=(newSelectWidth)+"px";
		}
	}

	old_width=documentView.getWidth();
}
window.onresize = bigScreenPage;


var $j = jQuery.noConflict();

function tableHeaderResize(){

	var pageWidth = $j(window).width();
	$j(".headWidth").width(pageWidth*(240/1000));
}

$j(document).ready(function(){
	tableHeaderResize();
});

$j(window).resize(function() {
	tableHeaderResize();
});

//-->
</script>
</head>
<body style="overflow:auto" id="space6"  onUnload="cleanup();" onLoad=" bigScreenPage();">

<%
	String sessionsID = session.getId();
	
	String selected="";
	String zonename	=	"";
	String str_comp_type="";
	String str_comp_name="";
	boolean zone		=	false;
	Enumeration e		=	request.getParameterNames();
	Hashtable params = new Hashtable();
	ArrayList a_ComponentsType	=	new ArrayList();
	
	
	if(e.hasMoreElements())
	{
		q_ctr			=	request.getParameter("qctr");
		segment		=	request.getParameter("segment").trim();
		zonename	=	request.getParameter("zone");
		if(q_ctr.equals("1"))
		{
			str_comp_type		=	request.getParameter("comptype");
			str_comp_name	=	request.getParameter("compname");
		}
	}

	boolean includeOtherSegComp=false;
	if(showIndOnly)
		includeOtherSegComp = false;
	else
		includeOtherSegComp = true;

	if (sessionsID!=null)
	{
%>
		<jsp:setProperty name="admintopo" property="sessionID" value="<%=sessionsID%>"/>
<%
	}

	if (segment!=null)
	{
%>
		<jsp:setProperty name="admintopo" property="includeOtherSegComp" value="<%=includeOtherSegComp%>"/>
<%
	}

	if (segment!=null)
	{
%>
		<jsp:setProperty name="admintopo" property="segmentName" value='<%=request.getParameter("segment")%>'/>
<%
	}

	if (zonename == null)
	{
		zonename = groupinfo.getZoneNameForComponent("Segment:"+segment+":NULL");
	}
	zonename = (zonename==null)?"-1": zonename;

	if (zonename != null)
	{
%>
		<jsp:setProperty name="admintopo" property="zoneName" value="<%=zonename%>"/>
<%
	}

	if (str_comp_type!=null && request.getParameter("comptype")!=null)
	{
%>
		<jsp:setProperty name="admintopo" property="selectedType" value='<%=request.getParameter("comptype")%>'/>

<%
	}
	if (str_comp_name!=null && request.getParameter("compname")!=null && !str_comp_name.equals("null"))
	{
%>
		<jsp:setProperty name="admintopo" property="selectedComp" value='<%=request.getParameter("compname")%>'/>
<%
	}

	params.put("qctr", q_ctr);
	params.put("segment", segment);
	params.put("zone", zonename);
	params.put("showIndOnly", new Boolean (showIndOnlyParam!=null && showIndOnlyParam.equalsIgnoreCase("true")));
	if (str_comp_type!=null)
		params.put("comptype", str_comp_type);
	if (str_comp_name!=null)
		params.put("compname", str_comp_name);
	topobean.setParameters(params);

	admintopo.execute();

	/*does this segment belong to a zone or not*/
	zone = topobean.isZoneAssociated();
	String [] segs = topoinfo.getSegmentNames();
	ArrayList depCmps = new ArrayList();
	ArrayList segCmps = new ArrayList();
	String [] thisSegVars= topoinfo.getVariables(segment);
	if (thisSegVars!=null)
	{
		segCmps.addAll(Arrays.asList(thisSegVars));
	}

	boolean isDepCompStarted = false;
	if (segs!=null)
	for (int i=0; i<segs.length; i++)
	{
		String thisSeg = segs[i];
		if (thisSeg.equals(segment))
			continue;
		String [] thisVars = topoinfo.getVariables(thisSeg);
		if (thisVars!=null)
		{
			for (int j=0; j<thisVars.length; j++)
			{
				String thisComp = thisVars[j];
				if (!segCmps.contains(thisComp))
					depCmps.addAll(Arrays.asList(thisVars));
			}
		}

	}
	String rr = str_comp_type+":"+str_comp_name;
	if (showIndOnly && !segCmps.contains(rr)  && depCmps.contains(rr))
		isDepCompStarted = true;
%>
<form name="topology" method="post" action="Egadmintopologyp.jsp" style="margin:0px;padding:0px;">
<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" id="eg_whitebg">


<input type="hidden" name="update" value="true">
<input type="hidden" name="newsegment" value="<%=newsegment%>">
<input type="hidden" name="searchType" value="<%=searchType%>">
<%
	session.setAttribute("egPageDesc","EgAdminTopology.jsp");
%>
	<jsp:include page="listSearch.jsp?title=COMPONENTS TOPOLOGY&backButton=true&subtitle=true&searchBox=false"/>

	<tr>
		<td width="100%" id="eg_whitebg" align="center" height="100%" valign="top">
			<table align="center" cellspacing="0" cellpadding="0" width="95%" border="0">
				<tr>
					<td height="6" id="inner_top_left" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
					<td height="6" id="eg_subcontentbg" width="100%" colspan="4"><img src="/final/admin/eg_images/spacer.gif" height="6" ></td>
					<td height="6" id="inner_top_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
				</tr>
				<tr>
					<td class="eg_subcontentbg">&nbsp;</td>
					<td valign="top" nowrap colspan="4" class="eg_subcontentbg" id="space1">
						<table align="center" cellspacing="0" cellpadding="0" border="0" width="100%">
							<tr>
								<td  id="space1">
									<table align="center" cellspacing="0" cellpadding="0" border="0" id="cell_border1" width="100%">
										<tr>
											<th id="eg_subheadbg_lower" class="head_padding4" style="border-top-width:0px"><egui:intnl text="admin.topology.Type of components"/></th>
										</tr>
										<tr>
											<td id="eg_whitebg" align="center" nowrap height="28" class="space">
											<select id="selectWidth1" name="ComponentsType" onchange="JavaScript:listselect('1')" width="240" style="width:240px;">
											<option value = "-1"><egui:intnl text="admin.common.Choose one"/></option>
<%
	EgAggregateInfo egagg=new EgAggregateInfo("manager");
	EgDiscInfo discInfo=new EgDiscInfo("manager");
	Vector aggComp=new Vector();
	aggComp=egagg.getAggregateTypes();
	EgComponentList cList = (EgComponentList)admintopo.getStartCompList();
	Set typeSet = cList.getAllTypes();
	Iterator typeI = typeSet.iterator();
	ArrayList serverList =  new ArrayList();
	ArrayList tmpServerList =  new ArrayList();

	/*boolean isGroupsExist = false;
	Iterator tmpItr = cList.iterator();
	if (newsegment != null )
	{
		while (tmpItr.hasNext())
		{
			Object obj = tmpItr.next();
			if (obj instanceof EgGroup)
			{
				EgGroup thisGr = (EgGroup)obj;
				if (groupinfo.isGroupExistsUnderAnyZone(thisGr.getDisplayName()))
				{
					continue;
				}
				isGroupsExist = true;
			}
		}
	}*/

	while (typeI.hasNext())
	{
		String thisType = (String) typeI.next();
		//if(aggComp!=null && aggComp.contains(thisType))
			//continue;
		if(thisType.equals("Site_servers")||thisType.equals("Zone") || thisType.equals("Segment") || thisType.equals("Service") || thisType.equals(""))
		{
			continue;
		}

		/*if (newsegment!=null && !newsegment.equalsIgnoreCase("null") && thisType.equals("Group") && (!groupinfo.isAnyIndependentGroupsExist() || !isGroupsExist ))
		{
			continue;
		}*/
		
		serverList.add(thisType);
	}
	tmpServerList.addAll(serverList);
	String userLanguage = _user.getLanguage();
	IniUI  iniUI = IniUI.getInstance();
	if (userLanguage == null)
		userLanguage = iniUI.getDefaultLanguage();


	ArrayList aListEntity = new ArrayList(); //Krishnamurthi for sorting
	Iterator cListI = cList.iterator();
	while (cListI.hasNext())
	{
		Object thisO = cListI.next();
		String optionVal = null;
		String dispVal = null;
		String type = null;
		String optionValu = null;
		if (thisO instanceof EgComponent)
		{
			EgComponent thisComp = (EgComponent)thisO;
			if (!thisComp.getType().equals(admintopo.getSelectedType()))
				continue;
			optionVal=thisComp.getName();
			//type = thisComp.getType();
			//optionValu = optionVal+":" + type;
			dispVal=thisComp.getDisplayName();
			aListEntity.add(optionVal);
		}
		else if (thisO instanceof EgGroup)
		{
			EgGroup thisComp = (EgGroup)thisO;
			String thisTypeTmp = thisComp.getType();
			String selectedTypeTmp = admintopo.getSelectedType();
			
			if (!thisTypeTmp.equals(selectedTypeTmp))
				continue;
			optionVal=thisComp.getName();
			//type = thisComp.getType();
			//optionValu = optionVal+":" + type;
			dispVal=thisComp.getDisplayName();
			ArrayList zoneList = groupinfo.getZoneNameForGroup(dispVal);
			
			if(zone)
			{
				if(zoneList == null || !zoneList.contains(zonename))
				{
					continue;
				}
			}
			else
			{
				if(zoneList != null && zoneList.size() > 0)
				{
					continue;
				}
			}

			/*if(newsegment != null && !newsegment.equalsIgnoreCase("null") && groupinfo.isGroupExistsUnderAnyZone(dispVal))
			{
				continue;
			}*/
			if (newsegment != null && newsegment.equalsIgnoreCase("null"))
			{
				ArrayList zoneGr = groupinfo.getZoneNameForGroup(dispVal);
				String zoneGrStr = "";
				if(zoneGr != null && zoneGr.size() > 0)
					zoneGrStr = (String)zoneGr.get(0);
				String zoneSeg = groupinfo.getZoneNameForSegment(segment);
				if(zoneSeg == null || zoneSeg.equals("null"))
					zoneSeg = "";
				if(!zoneGrStr.equals(zoneSeg))
				{
					continue;
				}
			}
			aListEntity.add(optionVal);
		}
		else if (thisO instanceof EgService)
		{
			EgService thisComp = (EgService)thisO;
			if (!thisComp.getType().equals(admintopo.getSelectedType()))
				continue;
			optionVal=thisComp.getName();
			//type = thisComp.getType();
			//optionValu = optionVal+":" + type;
			dispVal=thisComp.getDisplayName();
			aListEntity.add(optionVal);
		}
		else if (thisO instanceof EgSegment)
		{
			EgSegment thisComp = (EgSegment)thisO;
			if (!thisComp.getType().equals(admintopo.getSelectedType()))
				continue;
			optionVal=thisComp.getName();
			//type = thisComp.getType();
			//optionValu = optionVal+":" + type;
			dispVal=thisComp.getDisplayName();
			aListEntity.add(optionVal);
		}
		//String cSelected = "";
		
		//if (dispVal!=null && dispVal.equals(admintopo.getSelectedComp()))
		//{
		//	cSelected = "Selected";
		//}
	}

	boolean isJS = false;
	String jsOption = 	iniUI.getValue("TOPOLOGY_OPTIONS","Javascript");
	if(jsOption!=null && jsOption.length() > 0)
	{
		if(jsOption.equalsIgnoreCase("yes") || jsOption.equalsIgnoreCase("true"))
			isJS = true;
		else if(jsOption.equalsIgnoreCase("auto"))
		{
			String max_limit = iniUI.getValue("TOPOLOGY_OPTIONS","Max_limit");
			int max = 100; // Default value
			try{
				max = Integer.parseInt(max_limit);
			}
			catch(Exception exp){
				max = 100;
			}
			String[] totalVariables =  topoinfo.getVariables(segment);
			int totalComps = 0;
			if(totalVariables!=null)
				totalComps = totalVariables.length;
			if(totalComps > max)
				isJS = false;
			else
				isJS = true;
		}
	}

	boolean isSearchBoxNeed = (aListEntity != null && aListEntity.size() >= limit);
	MappingNameSorter sorter = new MappingNameSorter(userLanguage);
	serverList = sorter.getSortedCompTypeList(serverList);
	for(int j=0;j<serverList.size();j++)
	{
		EgName nameObj = (EgName)serverList.get(j);
		String tmpVal = nameObj.getActualName();	
		String tmpDis = nameObj.getLocalName();	
		String tSelected = "";
		if (tmpVal.equals(admintopo.getSelectedType()))
		{
			tSelected = "Selected";
		}
%>
		<option value="<%=tmpVal%>" <%=tSelected%>><%=tmpDis%></option>
<%
	}
%>
								</select>
								</td>
							</tr>
						</table>
					</td>
					<td id="space1" >
						<table align="left" cellspacing="0" cellpadding="0" width="100%" border="0" id="cell_border1">
							<tr>
								<td colspan="3" id="eg_subheadbg_lower" align="left" class="head_padding4" style="border-top-width:0px;text-align:left"><egui:intnl text="admin.topology.Component chosen for"/>&nbsp;<b><jsp:getProperty name="admintopo" property="segmentName"/></b>&nbsp;<egui:intnl text="admin.topology.configuration"/>
								</td>
								
							</tr>
							<tr>
								<td width="57%" id="eg_whitebg" class="eg_subcontent" align="left" nowrap height="28" > &nbsp; 
<%
	String display = admintopo.getSelectedComp();
	if(display == null || display.trim().equalsIgnoreCase("null"))
	{
		out.println("<egui:intnl text='admin.topology.Please choose a component'/>");
	}
	else
	{
%>
		<%=display%>
<%
	}
%>
								</td>
<%
	String site_associated = (topobean.isSiteAssociated()) ? "true":"false";
	TreeSet existing = topobean.getExistingServers();
%>
								<td  align="left"  id="eg_whitebg" class="eg_subcontent"><input id="eg_input" type="checkbox" name="showIndCheck" <%=showIndOnly?"":"checked"%> onClick="javascript:toggleInd();">
								</td>
								<td  id="eg_whitebg" class="eg_subcontent"><egui:intnl text="admin.topology.Use components from other segments"/>&nbsp;
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td  valign="top" id="space1">
						<table align="center" cellspacing="0" cellpadding="0" border="0">
							<tr>
<%
	String dispCompType = admintopo.getSelectedType();
	if(dispCompType ==null || dispCompType.equalsIgnoreCase("null") || !tmpServerList.contains(dispCompType))
	{
%>
								<td class="eg_subheadbg" id="cellborder1" style="padding:4px" height="23" align="left" nowrap><strong>
								<egui:intnl text="admin.topology.Components"/></strong></td>
<%
	}
	else if(dispCompType !=null && dispCompType.equals("Group"))
	{
%>
								<td class="eg_subheadbg" id="cellborder1" style="padding:4px" height="23" align="left" nowrap><strong><egui:intnl text="admin.topology.Group"/></strong></td>
<%
	}
	else if(dispCompType != null)
	{
		String servTypeCaption = _mapping.getComponentTypeDescription(dispCompType);
		if(servTypeCaption != null && !servTypeCaption.equals("-1"))
		{
			servTypeCaption+=" Components";
		}
		else
		{
			servTypeCaption = "Components";
		}
%>
								<td class="eg_subheadbg" id="cellborder1" style="padding:4px" height="23" align="left" nowrap title="<%=servTypeCaption%>"><div class="headWidth" style="border: 0px solid #000000;white-space: nowrap;width:200px;overflow:hidden;text-overflow:ellipsis;"><strong><egui:display name="<%=servTypeCaption%>" /></strong></div></td>
<%
	}
%>
								<!-- <th class="eg_subheadbg" id="cellborder1" style="padding:4px" height="23" align="left" nowrap><egui:intnl text="admin.topology.COMPONENTS"/> </th> -->
							</tr>
<%
	if(isSearchBoxNeed)
	{
%>
							<tr>
								<td align="center" id="cell_border1">
									<table align="center" cellspacing="0" cellpadding="0"  border="0" width="100%" >
										<tr>
											<td align="center"  id="space1">
												<table cellspacing="0" cellpadding="0" border="0">
													<tr>
														<td >
															<div class="searchImg" style="border:0px solid red;">
																<div class="rightside" style="display:inline;border:0px solid blue;" onkeypress="if(event.keyCode==13) javascript:Search('compSearch');">
																	<input class="textBoxImg" type="text" onfocus="if(this.value=='Search') this.value='';" onblur="if(this.value=='') this.value='Search';" value='<%=(strCompSearch!=null && !strCompSearch.equals("undefined")  && !strCompSearch.equalsIgnoreCase(""))?strCompSearch:"Search"%>' name="strCompSearch" id="strCompSearch"/>
																</div>
																<div class="searchIcon" style="display:inline;border:0px solid red;float:left">
																	<a id="eg_strInput" href="javascript:void(0)" name="Go" onclick="javascript:Search('compSearch')"><img src="/final/images/gray/search-icon.png" style="text-decoration:none" border="0"  class="png"/></a>
																</div>
															</div>
														</td>
													</tr>
												</table>
											</td>
										</tr>
									</table>
								</td>
							</tr>
<%
	}
%>
							<tr>
								<td align="center" nowrap width="100%" valign="top" height="135" >
									<select id="selectWidth2" id="ComponentsList" name="ComponentsList" size="9" style="width:250px;">
<%

// alert operation for no search component types
	ArrayList tempaListEntity =(ArrayList) aListEntity.clone();
	ArrayList tempminusList = new ArrayList();
	if(aListEntity !=null && aListEntity.size() > 0)
	{
		if(compSearchList != null && compSearchList.size() > 0 )
		{
			for(int jj=0;jj<aListEntity.size();jj++)
			{
				String searchCompName = (String) aListEntity.get(jj);

				if (isCompSearchResult && !isItemExists(compSearchList,searchCompName))
				{
					tempminusList.add(searchCompName);
					continue;
				}
			}
			tempaListEntity.removeAll(tempminusList);
		}
		if((tempaListEntity == null || tempaListEntity.size() == 0))
		{
			isSearchData = false;
		}
		else
		{
			isSearchData = true;
		}

	}

	//Krishnamurthi - Sorting - Start
	Collections.sort(aListEntity,String.CASE_INSENSITIVE_ORDER);
	if(aListEntity != null && aListEntity.size() > 0)
	{
		if(isSearchData)
		{
			for (int n=0;n<aListEntity.size();n++)
			{
				String entity = (String)aListEntity.get(n);
				String displayEntity = entity;
				if (displayEntity.endsWith(":NULL"))
				{
					displayEntity = displayEntity.substring(0,displayEntity.indexOf(":"));
				}
				String cSelected = "";
				if (displayEntity != null && displayEntity.equals(admintopo.getSelectedComp()))
				{
					cSelected = "selected";
				}
					if (compSearchList !=null && compSearchList.size() > 0 )
					{
						if(isItemExists(compSearchList,displayEntity))
						{
%>
												<option value="<%=entity%>" <%=cSelected%>><%=displayEntity%></option>
<%		
						}
					}
					else
					{
%>
												<option value="<%=entity%>" <%=cSelected%>><%=displayEntity%></option>
<%
					}
			}
		}
		else
		{
%>
						<option value="-1"><egui:intnl text="admin.topology.No component(s) found "/>!</option>

<%
		}
	}
	//Krishnamurthi - Sorting - End
%>
									</select>									
								</td>
							</tr>
							<tr>
								<td align="center" valign="bottom">
									<input type="button" value='<egui:intnl text="admin.topology.Start"/>' onClick="javascript:listselect('0');" name="start" class="eg_back" onClick="javascript:populate();" style="width: 50px;">
								</td>
							</tr>
						</table>
					</td>
					<td valign="top" align="center" class="eg_subcontentbg" nowrap>
						<table align="center" width="100%" cellspacing="0" cellpadding="4" border="0">
							<tr>
								<td align="center" valign="top" nowrap>
<%
	//new change
	EgComponentList associatedList = (EgComponentList)admintopo.getAssCompList();
	List compList = admintopo.getAllCompList();
	boolean isOtherCompSearchBoxNeed = ((compList !=null && compList.size() >= limit) && (ComponentList != null && !ComponentList.equals("null")));
	Vector ass_servers_tmp = new Vector();
	Iterator itrTmp = associatedList.iterator();
	while(itrTmp.hasNext())
	{
		EgObject thisO = (EgObject)itrTmp.next();
		String assType = thisO.getType();
		String assComp = thisO.getName();
		String ass = assType+":"+assComp+" /"+thisO.getState();
		ass_servers_tmp.add(ass);
	}
	//end
%>
									<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" id="cell_border1" height="100%">
										<tr>
											<td align="center" id="eg_subheadbg">
												<table align="center" cellspacing="0" cellpadding="0"  border="0" width="100%" >
													<tr>
														<td align="left" class="space4" nowrap>&nbsp;<strong><egui:intnl text="admin.topology.OTHER COMPONENTS"/></strong></td>
<%
	if(isOtherCompSearchBoxNeed)
	{
%>
														<td align="right">
															<table cellspacing="0" cellpadding="0" border="0">
																<tr>
																	<td>
																		<div class="searchImg" style="border:0px solid red;">
																		<div class="rightside" style="display:inline;border:0px solid blue;" onkeypress="if(event.keyCode==13) javascript:Search('otherCompSearch');">
																			<input class="textBoxImg" type="text" onfocus="if(this.value=='Search') this.value='';" onblur="if(this.value=='') this.value='Search';" value='<%=(strOtherCompSearch!=null && !strOtherCompSearch.equals("undefined") && !strOtherCompSearch.equalsIgnoreCase(""))?strOtherCompSearch:"Search"%>' name="strOtherCompSearch" id="strOtherCompSearch"/>
																		</div>
																		<div class="searchIcon" style="display:inline;border:0px solid red;float:left">
																			<a id="eg_strInput" href="javascript:void(0)" name="Go" onclick="javascript:Search('otherCompSearch')"><img src="/final/images/gray/search-icon.png" style="text-decoration:none" border="0"  class="png"/></a>
																		</div>
																		</div>
																	</td>
																</tr>
															</table>
														</td>
<%
	}
%>
													</tr>
												</table>
											</td>
										</tr>
										<!-- <tr>
											<th id="eg_subheadbg" class="head_padding4" style="border-top-width:0px"><egui:intnl text="admin.topology.ALL COMPONENTS"/></th>
										</tr> -->
										<tr>
											<td id="eg_subcontentbg" align="center" valign="top" nowrap height="100%" style="padding:0px">
												<select id="selectWidth3" name="ComponentsUnderEgurkha" size="12" multiple style="width:310px;">
<%
	aListEntity = new ArrayList(); //Krishnamurthi for sorting
	Iterator allServersI = compList.iterator();
	if (ComponentType!=null && ComponentList!=null && !ComponentList.equals("null"))
	{
		if (!isDepCompStarted)
		{
			while(allServersI.hasNext())
			{
				//EgComponent myComp = (EgComponent)allServersI.next();
				Object thisO = allServersI.next();
				String optionVal = null;
				String dispVal = null;
				String type = null;
				String optionValu = null;
				if (thisO instanceof EgComponent)
				{
					EgComponent thisComp = (EgComponent)thisO;
					optionVal=thisComp.getName();
					//String aaa = thisComp.getPort();
					type = thisComp.getType();
					optionValu = optionVal +":"+ type;
					dispVal=thisComp.getDisplayName()+ ":" + _mapping.getComponentTypeDescription(type);
					aListEntity.add(optionValu);
				}
				else if (thisO instanceof EgGroup)
				{
					EgGroup thisComp = (EgGroup)thisO;
					optionVal=thisComp.getName();
					type = thisComp.getType();
					optionValu = optionVal +":"+ type;
					dispVal=thisComp.getDisplayName()+ ":" + _mapping.getComponentTypeDescription(type);
					String checkGrpName = type+":"+optionVal+" /"+thisComp.getState();
					
					if(ass_servers_tmp.contains(checkGrpName))
						continue;

					aListEntity.add(optionValu);
					String tmpGroupName ="";
					if (dispVal.endsWith(":Group"))
					{
						tmpGroupName = dispVal.substring(0,dispVal.indexOf(":Group"));
					}
					else
					{
						tmpGroupName = dispVal;
					}

					//commented by ahamed
					/*boolean isGroupExist = false;
					isGroupExist = groupinfo.isGroupExistsUnderAnyZone(tmpGroupName);
					String tmpZoneName = groupinfo.getZoneNameForSegment(segment);
					ArrayList tmpZoneName2 = groupinfo.getZoneNameForGroup(tmpGroupName);
					if (tmpZoneName2.contains(tmpZoneName))
					{
						isGroupExist =false;
					}*/
				
					/*if(newsegment != null && !newsegment.equalsIgnoreCase("null") && isGroupExist)
					{
						continue;
					}*/
				}
				else if (thisO instanceof EgService)
				{
					EgService thisComp = (EgService)thisO;
					optionVal=thisComp.getName();
					type = thisComp.getType();
					optionValu = optionVal +":"+ type;
					dispVal=optionVal+ ":" + _mapping.getComponentTypeDescription(type);

					aListEntity.add(optionValu);
				}
				else if (thisO instanceof EgSegment)
				{
					EgSegment thisComp = (EgSegment)thisO;
					optionVal=thisComp.getName();
					type = thisComp.getType();
					optionValu = optionVal +":"+ type;
					dispVal=thisComp.getDisplayName()+ ":" + _mapping.getComponentTypeDescription(type);

					aListEntity.add(optionValu);
				}
%>
				<!-- <option value="<%//=optionValu%>"><%//=dispVal%></option> -->
<%
			}
		}
	//Krishnamurthi - Sorting - Start
		Collections.sort(aListEntity,String.CASE_INSENSITIVE_ORDER);
		TreeMap tm1 = new TreeMap();
		Hashtable ht = new Hashtable();
		Hashtable tmpHash = new Hashtable();
		ht = discInfo.getAllCompForTopology(aListEntity);

		if(isOtherCompSearchResult && ht.size() > 0 && isOtherCompSearchBoxNeed)
		{
			Iterator hashKeyList = ht.keySet().iterator();
			ArrayList htKeyArrLst = new ArrayList();
			ArrayList minusList = new ArrayList();
			while(hashKeyList.hasNext())
			{
				String hashKeyData = (String)hashKeyList.next();
				htKeyArrLst.add(hashKeyData);
			}
			for(int jj=0;jj<htKeyArrLst.size();jj++)
			{
				String tmpKey = (String) htKeyArrLst.get(jj);
				String strKey = "";
				ArrayList searchValList = (ArrayList) ht.get(tmpKey);
				for(int ii=0;ii<searchValList.size();ii++)
				{
					String tmpSearchData = (String) searchValList.get(ii);
					String tmpSearchVal = "";
					if(tmpSearchData.endsWith(":NULL"))
					{
						tmpSearchVal = tmpSearchData.substring(0,tmpSearchData.indexOf(":NULL"));
					}
					else
					{
						tmpSearchVal = tmpSearchData;
					}
					if (isOtherCompSearchResult && !isItemExists(otherCompSearchList,tmpSearchVal))
					{
						minusList.add(tmpSearchData);
						continue;
					}
				}
				if (isOtherCompSearchResult && isItemExists(otherCompSearchList,_mapping.getComponentTypeDescription(tmpKey)))
				{
					strKey = tmpKey;
				}
				if(strKey !=null && strKey.length() > 0)
				{
					tmpHash.put(tmpKey,searchValList);
					continue;
				}
				searchValList.removeAll(minusList);
				if(searchValList == null || searchValList.size() == 0)
				{
					continue;
				}
				else
				{
					tmpHash.put(tmpKey,searchValList);
				}
			}
			ht = new Hashtable(tmpHash);
		}

		if(ht !=null && ht.size() > 0)
		{
			Iterator tmKeyList = ht.keySet().iterator();
			ArrayList keyList = new ArrayList();
			while(tmKeyList.hasNext())
			{
				String keyData = (String)tmKeyList.next();
				keyList.add(keyData);
			}
			Collections.sort(keyList,String.CASE_INSENSITIVE_ORDER);
			keyList = sorter.getSortedCompTypeList(keyList);
			for(int kl=0;kl<keyList.size();kl++)
			{
				EgName nameObj = (EgName)keyList.get(kl);
				String tmpVal = nameObj.getActualName();	
				String tmpDis = nameObj.getLocalName();	
				//String keyServer = (String) keyList.get(kl);
%>
				<optgroup label="<%=tmpDis%>">

<%
				ArrayList servValue = (ArrayList) ht.get(tmpVal);
				Collections.sort(servValue,String.CASE_INSENSITIVE_ORDER);
				for(int val=0;val<servValue.size();val++)
				{
					String valData = (String) servValue.get(val);
					String valueEntity = valData + ":" + tmpVal;
					if (valData.endsWith(":NULL"))
					{
						valData = valData.substring(0,valData.indexOf(":"));
					}
%>

													<option value="<%=valueEntity%>"><%=valData%></option>
<%
	//Krishnamurthi - Sorting - End
				}
			}
		}
		else if(isOtherCompSearchResult &&  searchType.equals("otherCompSearch"))
		{
%>
													<option value="-1"><egui:intnl text="admin.topology.No component(s) found "/>!</option>

<%		}
	}
	else if(isOtherCompSearchResult &&  searchType.equals("otherCompSearch"))
	{
%>
													<option value="-1"><egui:intnl text="admin.topology.No component(s) found "/>!</option>

<%
	}
%> 
												</select>
											</td>
										</tr>
									</table>
								</td>
								<td align="center" valign="center" width="100%" id="space1">
									<table align="center" cellspacing="2" cellpadding="0" width="100%" border="0" >
										<tr>
											<td align="center" nowrap height="38"><input type="button" name="affect" value='<egui:intnl text="admin.topology.Uses"/> &rsaquo;&rsaquo;' class="eg_lightbutton" onClick="javascript:addtomanage('L');" style="width: 80px; letter-spacing: 0px;"></td>
										</tr>
										<tr>
											<td align="center" nowrap height="38"><input type="button" name="connect" value='<egui:intnl text="admin.topology.Connects"/> &rsaquo;&rsaquo;' class="eg_lightbutton" onClick="javascript:addtomanage('N');" style="width: 80px; letter-spacing: 0px;"></td>
										</tr>
										<tr>
											<td align="center" nowrap height="38"><input type="button" name="con" value='&lsaquo;&lsaquo; <egui:intnl text="admin.topology.Remove"/>' class="eg_lightbutton" onClick="javascript:addtounmanage('<%=segment%>','false');" style="width: 80px; letter-spacing: 0px;"></td>
										</tr>
									</table>
								</td>
								<td align="center" valign="top" nowrap>
									<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" id="cell_border1">
										<tr>
											<th class="eg_subheadbg" id="cellborder1" style="padding:4px" height="23" align="left" nowrap><egui:intnl text="admin.topology.ASSOCIATED COMPONENTS"/></th>
										</tr>
										<tr>
											<td id="eg_subcontentbg" align="center" valign="top" nowrap height="100%">
												<select id="selectWidth4" name="ComponentsUnder" size="12" multiple  style="width:255px;">
<%
	EgComponentList assList = (EgComponentList)admintopo.getAssCompList();
	Vector v_ass_servers = new Vector();
	Hashtable htAssoComp = new Hashtable();
	Iterator assServersI2 = assList.iterator();

	if (!isDepCompStarted)
	while(assServersI2.hasNext())
	{
		EgObject thisO = (EgObject)assServersI2.next();
		String assType = thisO.getType();
		String type = null;
		String optionValu = null;
		String optionVal=thisO.getName();

		String rel = thisO.getTopologyRelation();
		type = thisO.getType();
		optionValu = optionVal +":"+ rel + ":"+ type;
		String dispVal=thisO.getDisplayName();
		/*
		if (thisO instanceof EgComponent)
		{
			EgComponent thisComp = (EgComponent)thisO;
			optionVal=thisComp.getName();
			dispVal=thisComp.getDisplayName();
		}else if (thisO instanceof EgGroup)
		{
			EgGroup thisComp = (EgGroup)thisO;
			optionVal=thisComp.getName();
			dispVal=thisComp.getDisplayName();
		}
		*/
		v_ass_servers.add(optionValu);
		String tmpServerName = optionValu;
		if (tmpServerName.indexOf(":NULL:")>0) 
		{
			int nullIndex = tmpServerName.indexOf(":NULL:");
			tmpServerName = tmpServerName.substring(0,nullIndex)+tmpServerName.substring(nullIndex+5);	
		}	
		String tmpServer = tmpServerName;
		String tmpType = tmpServer.substring(tmpServer.lastIndexOf(":")+1);
		String tmpName = tmpServer.substring(0,tmpServer.lastIndexOf(":")+1);
%>
				<!-- <option value="<%//=optionValu%>"><%//=tmpName+_mapping.getComponentTypeDescription(tmpType)%></option> -->
<%
	}
	session.setAttribute("ass_servers",v_ass_servers);
	//Krishnamurthi - Sorting - Start
	//Collections.sort(v_ass_servers,String.CASE_INSENSITIVE_ORDER);
	if(v_ass_servers != null && v_ass_servers.size() > 0)
	{
		htAssoComp = discInfo.getAllAssoCompForTopology(v_ass_servers);
		if(htAssoComp !=null && htAssoComp.size() > 0)
		{
			Iterator htAssoKeyList = htAssoComp.keySet().iterator();
			ArrayList assoKeyList = new ArrayList();
			while(htAssoKeyList.hasNext())
			{
				String assoKeyData = (String)htAssoKeyList.next();
				assoKeyList.add(assoKeyData);
			}
			Collections.sort(assoKeyList,String.CASE_INSENSITIVE_ORDER);
			assoKeyList = sorter.getSortedCompTypeList(assoKeyList);
			for (int m=0;m<assoKeyList.size();m++)
			{
				EgName nameObj = (EgName)assoKeyList.get(m);
				String tmpVal = nameObj.getActualName();	
				String tmpDis = nameObj.getLocalName();	
%>
				<optgroup label="<%=tmpDis%>">
<%
				ArrayList assoServValue = (ArrayList) htAssoComp.get(tmpVal);
				Collections.sort(assoServValue,String.CASE_INSENSITIVE_ORDER);
				for(int aval=0;aval<assoServValue.size();aval++)
				{
					String assoValData = (String) assoServValue.get(aval);
					String valueEntity = assoValData + ":" + tmpVal;
					String valData = assoValData.substring(0,assoValData.lastIndexOf(":"));
					String relation = assoValData.substring(assoValData.lastIndexOf(":")+1);
					String dispAssoCompData = "";
					if (valData.endsWith(":NULL"))
					{
						valData = valData.substring(0,valData.indexOf(":"));
						dispAssoCompData = valData+":"+relation;
					}
					else
					{
						dispAssoCompData = assoValData;
					}
%>
						<option value="<%=valueEntity%>"><%=dispAssoCompData%></option>

<%
				}
			}
		}
	}
	//Krishnamurthi - Sorting - End
%>
												</select>
											</td>
										</tr>
									</table>
								</td>
							</tr>
						</table>
					</td>
				</tr>
			</table>
		</td>
		<td class="eg_subcontentbg">&nbsp;</td>
	</tr>
	<tr>
		<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
		<td id="eg_subcontentbg"  width="100%"  valign="top" colspan="4"><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
		<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
	</tr>
	<tr>
		<td  height="10px" colspan="6">&nbsp;</td>
	</tr>
	
			<input type="hidden" name=fmanage value="">
			<input type="hidden" name=fumanage value="">
			<input type="hidden" name=updateZone value="false">
			<input type="hidden" name="zone" value="<%=zonename%>">
			<input type="hidden" name=comptype value="<%=str_comp_type%>">
			<input type="hidden" name=compname value="<%=str_comp_name%>">
			<input type="hidden" name=segment value="<%=segment%>">
			<input type="hidden" name="update" value="true">
			<input type="hidden" name="showIndOnlyParam" value="true">
			<input type="hidden" name="prevassocomp" value="">
			<input type="hidden" name="tobeDeletedHdn" value="">
			<input type="hidden" id= "zoomValue" name="zoomValue" value="<%=zoomLevel%>">
				
	<tr>
<%
	if (!topobean.isEmptySegment())
	{
		// new change on 17 Oct 2007 (to find zone associate)
		ArrayList zoneElements = groupinfo.getAllElementsUnderZone(zonename);
		boolean zone_associated = false;

		if(zoneElements != null && zoneElements.contains("Segment:"+segment+":NULL"))
		{
			zone_associated = true;
		}
%>
		<td align="center" valign="top" height="100%" colspan="6">
			<table align="center" cellspacing="0" cellpadding="2" width="95%"  border="0" id="table_outer_border" style="padding:0px">
				<tr>
					<th id="eg_subheadbg" style="border-top-width:0px">
						<table align="center" width="100%" cellspacing="0" cellpadding="0" border="0">
							<tr>
								<th align="left" nowrap class="head_padding4"><egui:intnl text="admin.topology.SEGMENT PREVIEW"/></th>
								<td align="right" nowrap><input type="button" value='<egui:intnl text="admin.topology.Delete Segment"/>' class="eg_back" style="width: 120px;" onClick="javascript:godeletetopology('<%=segment%>','<%=zone_associated%>','<%=site_associated%>');">&nbsp;</td>
							</tr>
						</table>
					</th>
				</tr>
<%
		if(isJS)
		{
%>
				<tr>
					<td valign="top" style="padding:0px">
					<div id="loading_image" style="position:absolute;top:610px;left:480px;visibility:visible;display:block;"><table height="100%"><tr><td height="100%" valign="middle"> <img src='/final/admin/eg_images/indicator_medium.gif'></td></tr></table> </div>

					<iframe id="iframeWidth" style="width:916px" height="520" id="topoFrame" name="topoFrame" src="EgTopologyB.jsp?segment=<%=EgURLEncoder.encode(segment,"UTF-8")%>&zoom=<%=EgURLEncoder.encode(zoomLevel,"UTF-8")%>&physical_topology=1&site=egurkha.physical.topology" border="0" scrolling="no" marginwidth="0px" marginheight="0px" frameborder="0" color="blue" style="border-width:0px; border-style:solid; border-color:yellow;"></iframe>
					</td>
				</tr>
				
<%
		}
		else
		{
%>
				<tr>
					<td align="center" valign="top" nowrap height="520" bgcolor="#FFFFFF" style="background-color: #FFFFFF;">
						<iframe align="center" id="iframeWidth" style="width:916px" height="520" src="EgTopologyA.jsp?segment=<%=EgURLEncoder.encode(segment,"UTF-8")%>"  border="0" scrolling="no" class="eg_scroll" frameborder="0"></iframe>
					</td>
				</tr>
<%
		}
		if (zone)
		{
%>
				<tr>
					<th id="eg_subheadbg" align="left" class="head_padding4" style=
					"border-top-width:0px"> <egui:intnl text="admin.topology.Association"/> </th>
<%
	//}
%>
				</tr>

<%
									//if (zone)
									//{
			String disassString = topobean.segmentDisassociationString();
%>
				<tr>
					<td id="eg_subcontentbg" class="eg_subcontent" align="left"> 
						<table width="100%" border="0" cellspacing="4" cellspacing="0">
							<tr>
<%
			ArrayList sites = topoinfo.getSitesForSegment(segment);
			//EgConfigSites.jsp?site=sdfsdfsd&segment=ttt&service=true&modify=true&zone=sdfsdf
			Iterator sitesIter = sites.iterator();
			if (sitesIter.hasNext())
			{
%>
								<td width="120"><egui:intnl text="admin.topology.Service(s) mapping"/></td>
								<td width="10">:</td>
								<jsp:useBean id="siteBean" class="egurkha.ConfigSiteBean" scope="page" />
								<td>
<%

				int cc=0;
				while (sitesIter.hasNext())
				{
					if (cc != 0)
						out.print(", ");
					cc ++;
					String thisSite = (String)sitesIter.next();
					thisSite = thisSite.trim();
					String thisZone = groupinfo.getZoneNameForService(thisSite);
					String service = "false";
					if(siteBean.isAService(thisSite))
						service = "true"; 
					thisZone = thisZone==null ? "-1":thisZone;
%>
									<a class="eg_monlink" href="EgConfigSites.jsp?site=<%=EgURLEncoder.encode(thisSite,"UTF-8")%>&segment=<%=EgURLEncoder.encode(segment,"UTF-8")%>&service=<%=EgURLEncoder.encode(service,"UTF-8")%>&modify=true&zone=<%=EgURLEncoder.encode(thisZone,"UTF-8")%>" style="text-decoration=none;"> <b><%=thisSite%></b> </a>
<% 
				}
			}
%>
								</td>
							</tr>
							<tr>
								<td width="120" id="eg_subcontentbg" class="eg_subcontent" align="left" nowrap><egui:intnl text="admin.topology.Zone mapping"/> </td>
								<td width="10">:</td>
								<td align="left"><a class="eg_monlink" href="EgConfigZone.jsp?qctr=0&mode=modify&zone=<%=EgURLEncoder.encode(zonename,"UTF-8")%>"><b><%=zonename%></b></a>
<%
			if (disassString!=null)
			{
%>
									(<a class="eg_monlink" href="Egconfigzonep.jsp?qctr=0&mode=modify&zone=<%=EgURLEncoder.encode(zonename,"UTF-8")%>&returnto=segment_<%=EgURLEncoder.encode(segment,"UTF-8")%>&<%=request.getQueryString()%>&chosenHosts=<%=EgURLEncoder.encode(disassString,"UTF-8")%>&comp_type=Segment"><b><egui:intnl text="admin.topology.Disassociate"/></b>) 
											
<%
			}
%>
								</td>
							</tr>
						</table>
					</td>
				</tr>
<%
		}
%>

			</table>
		</td>
<%
	}
	else
	{
%>
		<td colspan="6" width="100%" height="228" >
			<table border="0" width="100%" cellpadding="0" cellspacing="0">
				<tr>
					<td align="center" valign="center"><img src = "/final/admin/eg_images/<%=admin_Skin%>/exclamation-icon.gif">&nbsp;
					</td>
				</tr>
				<tr>
					<td align="center" valign="center"  id="eg_errorsmall"><egui:intnl text="admin.topology.Segment has not been configured"/>!</td>
				</tr>
			</table>
		</td>
			
<%
	}
%>
	</tr>
	<tr>
		<td>&nbsp;</td>
	</tr>
</table>
</form>
<%
	String queryString = request.getQueryString();
	String Qstring="";
	if(queryString!=null)
	{
		StringTokenizer strtok = new StringTokenizer(queryString,"&");
		while(strtok.hasMoreTokens())
		{
			String param = strtok.nextToken();
			int ind = param.indexOf("=");
			if (ind < 0)
				continue;
			String reqparam =param.substring(0,ind);
			String value = param.substring(ind+1);
			if(reqparam!=null)
			{
				if(reqparam.equals("zone"))
				{
					value=com.eg.EgURLEncoder.encode(request.getParameter(reqparam), "UTF-8");
				}
				if(reqparam.equals("segment"))
				{
					value=com.eg.EgURLEncoder.encode(request.getParameter(reqparam), "UTF-8");
				}
				if(reqparam.equals("compname") ||reqparam.equals("comptype"))
				{
					value=com.eg.EgURLEncoder.encode(request.getParameter(reqparam), "UTF-8");
				}
			}
			Qstring=Qstring+reqparam+"="+value+"&";
		}
	}
	if(Qstring!=null)
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/EgAdminTopology.jsp?"+Qstring);
	}
	else 
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/EgAdminTopology.jsp");
	}

%>
</body>
<script language="javascript">

function toggleInd()
{
	//window.location.href="EgAdminTopology.jsp?showIndOnlyParam="+!indOnly+"&<%=request.getQueryString()%>";
<%
	StringBuffer sb = new StringBuffer();
	sb.append("EgAdminTopology.jsp?qctr=");
	sb.append(q_ctr);
	sb.append("&segment=");
	sb.append(EgURLEncoder.encode(segment,"UTF-8"));
	if(newsegment!=null)
		sb.append("&newsegment="+EgURLEncoder.encode(newsegment,"UTF-8"));

	//sb.append("&reqFrom=thisPage");
	if (zonename!=null && !(zonename.equals("-1")))
	{
		sb.append("&zone=");
		sb.append(EgURLEncoder.encode(zonename,"UTF-8"));
	}
	if (!q_ctr.equals("0"))
	{
		sb.append("&comptype=");
		sb.append(EgURLEncoder.encode(str_comp_type,"UTF-8"));
		if (str_comp_name!=null)
		{
		sb.append("&compname=");
		sb.append(EgURLEncoder.encode(str_comp_name,"UTF-8"));
		}
	}
%>
	var zoomlevel = document.getElementById('zoomValue').value;
	window.location.href="<%=sb.toString()%>&showIndOnlyParam="+!indOnly+"&zoom="+zoomlevel;
}
</script>
</html>
<%!
	private boolean isItemExists(List searchList, String server)
	{
		Iterator i = searchList.iterator();
		while(i.hasNext())
		{
			String nextStr = (String) i.next();
			if (server.indexOf(nextStr)!= -1 || (server.toUpperCase().indexOf(nextStr.toUpperCase())) != -1)
			{
				return true;
			}
		}
		return false;
	}
%>
