<%@ include file="../../../admin/EgTrackerAJSON.jsp" %>
<%@ page import="com.eg.EgInstallInfo"%>
<%@ page import="com.eg.IniFile"%>
<%@ page import="com.eg.EgMappingInfo"%>
<%@ page import="com.egurkha.ini.IniUI"%>
<%@ page import="com.eg.EgTesterInfo"%>
<%@ page import="com.eg.EgTablesInfo"%>
<%@ page import="com.eg.EgSpecsInfo"%>
<%@ page import="com.egurkha.util.StringUtils" %>
<%@ page import="net.sf.json.*"%>

<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>

<%!
	public int getLeniencyFactor(String relValue)
	{
		int leniency = 0;
		if (relValue != null)
		{
			if (relValue.equals("-"))
			{
				leniency = 0;
			}
			else if (relValue.equals("sqc"))
			{
				leniency = 100;
			}
			else
			{
				int idx = relValue.indexOf("*");
				String s1 = relValue.substring(0,idx);
				double d_value = Double.valueOf(s1.trim()).doubleValue();
				d_value = d_value * 100;
				leniency = (new Double(d_value)).intValue();
			}
		}
		return leniency;
	}
%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json");

	JSONObject rootJson = new JSONObject();
	JSONObject screenLabels = new JSONObject();
	JSONObject hiddenObj = new JSONObject();
	screenLabels.put("title","CONFIGURE THRESHOLDS");
	IniUI iniUI = IniUI.getInstance();
	//user language
	String userLanguage = iniUI.getDefaultLanguage();
	if (_user != null)
	{
		userLanguage = _user.getLanguage();
	}

	EgMappingInfo mappingInfo = new EgMappingInfo(userLanguage);
	EgTesterInfo testerInfo = new EgTesterInfo("manager");
	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
	EgTablesInfo tablesInfo = new EgTablesInfo("manager");

	String strFromMon = request.getParameter("fromMon");
	String strTestName = request.getParameter("testName");
	String strDescName = request.getParameter("descName");
	String from = "defaultThreshPage";
	String comeFrom = "admin";
	if(!StringUtils.isNull(strFromMon))
	{
		if(StringUtils.isNull(strTestName))
		{
			strTestName = request.getParameter("strTestName");
		}

		if(StringUtils.isNull(strDescName))
		{
			strDescName = request.getParameter("strDescName");
		}
		from = "monitorThreshPage";
		comeFrom = "";
	}

	String measure = request.getParameter("measure");
	String absMinCritical = request.getParameter("absMinCritical");
	String absMinMajor = request.getParameter("absMinMajor");
	String absMinMinor = request.getParameter("absMinMinor");
	String relMinCritical = request.getParameter("relMinCritical");
	String relMinMajor = request.getParameter("relMinMajor");
	String relMinMinor = request.getParameter("relMinMinor");
	String absMaxCritical = request.getParameter("absMaxCritical");
	String absMaxMajor = request.getParameter("absMaxMajor");
	String absMaxMinor = request.getParameter("absMaxMinor");
	String relMaxCritical = request.getParameter("relMaxCritical");
	String relMaxMajor = request.getParameter("relMaxMajor");
	String relMaxMinor = request.getParameter("relMaxMinor");
	String alarmPolicy = request.getParameter("alarmPolicy");


	String criticalMsg = mappingInfo.getThresholdPriorityDescription(strTestName+":"+measure+":Critical");

	if (!StringUtils.isNull(criticalMsg))
	{
		JSONObject toolTipMsg = new JSONObject();
		rootJson.put("isToolTip",true);
		toolTipMsg.put("toolTipCritical",criticalMsg);
		criticalMsg = mappingInfo.getThresholdPriorityDescription(strTestName+":"+measure+":Major");

		toolTipMsg.put("toolTipMajor",criticalMsg);
		rootJson.put("toolTipMsg",toolTipMsg);
	}
	else
	{
		rootJson.put("isToolTip",false);
	}

	String ua = request.getHeader("User-Agent");
	boolean isFirefox = (ua != null && ua.indexOf("Firefox/") != -1);
	boolean isChrome = (ua != null && ua.indexOf("Chrome") != -1);
	boolean isNegativeValuesAllowed = testerInfo.isNegativeValuesAllowed(strTestName,measure);
	rootJson.put("isNegativeValuesAllowed",isNegativeValuesAllowed);

	if (absMinCritical == null)
	{
		absMinCritical = "-";
	}
	if (absMinMajor == null)
	{
		absMinMajor = "-";
	}
	if (absMinMinor == null)
	{
		absMinMinor = "-";
	}

	String minStaticSelected = "";
	String minStaticBlock = "none";
	if ((absMinCritical != null && !absMinCritical.equals("-")) || 
		(absMinMajor != null && !absMinMajor.equals("-")) || 
		(absMinMinor != null && !absMinMinor.equals("-")))
	{
		minStaticSelected = "selected";
		if (isFirefox || isChrome)
		{
			minStaticBlock = "table-row";
		}
		else
		{
			minStaticBlock = "block";
		}
	}

	String minAutomaticSelected = "";
	String minAutomaticBlock = "none";
	String minAutoToleranceBlock = "";
	String minAutoCriticalSliderBlock = "";
	String minAutoMajorSliderBlock = "";
	String minAutoMinorSliderBlock = "";

	if ((relMinCritical != null && !relMinCritical.equals("-")) || 
		(relMinMajor != null && !relMinMajor.equals("-")) || 
		(relMinMinor != null && !relMinMinor.equals("-")))
	{
		minAutomaticSelected = "selected";
		if (isFirefox || isChrome)
		{
			minAutomaticBlock = "table-row";
		}
		else
		{
			minAutomaticBlock = "block";
		}

		if (relMinCritical != null && !relMinCritical.equals("-"))
		{
			if (isFirefox || isChrome)
			{
				minAutoToleranceBlock = "table-row";
				minAutoCriticalSliderBlock = "table-row";
			}
			else
			{
				minAutoToleranceBlock = "block";
				minAutoCriticalSliderBlock = "block";
			}
		}

		if (relMinMajor != null && !relMinMajor.equals("-"))
		{
			if (isFirefox || isChrome)
			{
				minAutoToleranceBlock = "table-row";
				minAutoMajorSliderBlock = "table-row";
			}
			else
			{
				minAutoToleranceBlock = "block";
				minAutoMajorSliderBlock = "block";
			}
		}

		if (relMinMinor != null && !relMinMinor.equals("-"))
		{
			if (isFirefox || isChrome)
			{
				minAutoToleranceBlock = "table-row";
				minAutoMinorSliderBlock = "table-row";
			}
			else
			{
				minAutoToleranceBlock = "block";
				minAutoMinorSliderBlock = "block";
			}
		}
	}

	if (absMaxCritical == null)
	{
		absMaxCritical = "-";
	}
	if (absMaxMajor == null)
	{
		absMaxMajor = "-";
	}
	if (absMaxMinor == null)
	{
		absMaxMinor = "-";
	}

	String maxStaticSelected = "";
	String maxStaticBlock = "none";
	String strMeasureBlock = "none";
	if ((absMaxCritical != null && !absMaxCritical.equals("-")) || 
		(absMaxMajor != null && !absMaxMajor.equals("-")) || 
		(absMaxMinor != null && !absMaxMinor.equals("-")))
	{
		maxStaticSelected = "selected";
		if (isFirefox || isChrome)
		{
			maxStaticBlock = "table-row";
		}
		else
		{
			maxStaticBlock = "block";
		}
	}
	

	String maxAutomaticSelected = "";
	String maxAutomaticBlock = "none";
	String maxAutoToleranceBlock = "";
	String maxAutoCriticalSliderBlock = "";
	String maxAutoMajorSliderBlock = "";
	String maxAutoMinorSliderBlock = "";
	if ((relMaxCritical != null && !relMaxCritical.equals("-")) || 
		(relMaxMajor != null && !relMaxMajor.equals("-")) || 
		(relMaxMinor != null && !relMaxMinor.equals("-")))
	{
		maxAutomaticSelected = "selected";
		if (isFirefox || isChrome)
		{
			maxAutomaticBlock = "table-row";
		}
		else
		{
			maxAutomaticBlock = "block";
		}

		if (relMaxCritical != null && !relMaxCritical.equals("-"))
		{
			if (isFirefox || isChrome)
			{
				maxAutoToleranceBlock = "table-row";
				maxAutoCriticalSliderBlock = "table-row";
			}
			else
			{
				maxAutoToleranceBlock = "block";
				maxAutoCriticalSliderBlock = "block";
			}
		}

		if (relMaxMajor != null && !relMaxMajor.equals("-"))
		{
			if (isFirefox || isChrome)
			{
				maxAutoToleranceBlock = "table-row";
				maxAutoMajorSliderBlock = "table-row";
			}
			else
			{
				maxAutoToleranceBlock = "block";
				maxAutoMajorSliderBlock = "block";
			}
		}

		if (relMaxMinor != null && !relMaxMinor.equals("-"))
		{
			if (isFirefox || isChrome)
			{
				maxAutoToleranceBlock = "table-row";
				maxAutoMinorSliderBlock = "table-row";
			}
			else
			{
				maxAutoToleranceBlock = "block";
				maxAutoMinorSliderBlock = "block";
			}
		}
	}

	int relMinCriticalLeniency = getLeniencyFactor(relMinCritical);
	int relMinMajorLeniency = getLeniencyFactor(relMinMajor);
	int relMinMinorLeniency = getLeniencyFactor(relMinMinor);
	int relMaxCriticalLeniency = getLeniencyFactor(relMaxCritical);
	int relMaxMajorLeniency = getLeniencyFactor(relMaxMajor);
	int relMaxMinorLeniency = getLeniencyFactor(relMaxMinor);

	IniFile thresholdsIni = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_thresholds.ini");
	String alarmVariables[] = thresholdsIni.getVariables("ALARM_POLICY");

	ArrayList aListGlobalThresholds = testerInfo.getGlobalThresholds();
	boolean isGlobalThresholds = false;
	if (aListGlobalThresholds != null && aListGlobalThresholds.contains(strTestName))
	{
		isGlobalThresholds = true;
	}
	rootJson.put("isGlobalThresholds",isGlobalThresholds);
	rootJson.put("selectedTest",strTestName);
	rootJson.put("selectedDescriptor",strDescName);
	rootJson.put("pattName",strDescName);
	rootJson.put("selectedMeasure",measure);

	if((absMinCritical.equals("-") && absMinMajor.equals("-") && absMinMinor.equals("-")) && (relMinCritical.equals("-") && relMinMajor.equals("-") && relMinMinor.equals("-")) && (absMaxCritical.equals("-") && absMaxMajor.equals("-") && absMaxMinor.equals("-")) && (relMaxCritical.equals("-") && relMaxMajor.equals("-") && relMaxMinor.equals("-")))
	{
		if (isFirefox || isChrome)
		{
			strMeasureBlock = "table-row";
		}
		else
		{
			strMeasureBlock = "block";
		}
	}

	if (strMeasureBlock.equals("table-row") || strMeasureBlock.equals("block"))
	{
		rootJson.put("allMeasureCheck","true");
	}
	boolean isHostTest = specsInfo.isTestRelevantForServer("Host_system",strTestName,true);
	if (isHostTest)
	{
		screenLabels.put("hTest_msg",_mapping.getTextDescription("admin.threshold.Changes made to default threshold will be applied to all component types to which this test is mapped"));
	}

	String unit = tablesInfo.getUnitForMeasure(strTestName,measure);
		screenLabels.put("test_description","<b>Thresholds for the '"+mappingInfo.getMeasureDescription(strTestName,measure)+" <i>("+unit+")</i>' measure of the '"+strDescName+"' descriptor");
		screenLabels.put("minThresh_tip",_mapping.getTextDescription("admin.threshold.Specify minimum threshold values (Critical, Major, and Minor) in ascending order"));

	JSONArray minThreshStaticArr = new JSONArray();
	JSONObject minThreshStaticObj = new JSONObject();
	minThreshStaticObj.put("displayField","None");
	minThreshStaticObj.put("valueField","none");
	minThreshStaticArr.add(minThreshStaticObj);
	minThreshStaticObj.put("displayField","Specific values");
	minThreshStaticObj.put("valueField","specify");
	minThreshStaticArr.add(minThreshStaticObj);
	rootJson.put("minThreshStaticArr",minThreshStaticArr);

	JSONObject minThreshObj = new JSONObject();
	minThreshObj.put("minStaticOption",minStaticSelected);
	minThreshObj.put("minStaticBlock",minStaticBlock);
	minThreshObj.put("absMinCritical",absMinCritical);
	minThreshObj.put("absMinMajor",absMinMajor);
	minThreshObj.put("absMinMinor",absMinMinor);

	if(!StringUtils.isNull(minStaticSelected))
	{
		rootJson.put("selectedMinStatic","specify");
	}
	else
	{
		rootJson.put("selectedMinStatic","none");
	}
	rootJson.put("minStaticBlock",minStaticBlock);
	String absMinThreshField = absMinCritical+"$"+absMinMajor+"$"+absMinMinor;
	rootJson.put("absMinThreshField",absMinThreshField);

	if (!isGlobalThresholds)
	{
		if(!isNegativeValuesAllowed)
		{
			minThreshObj.put("minAutomaticOption",minAutomaticSelected);
			minThreshObj.put("minAutomaticBlock",minAutomaticBlock);
			minThreshObj.put("minAutoToleranceBlock",minAutoToleranceBlock);
			minThreshObj.put("relMinCritical",relMinCriticalLeniency);
			minThreshObj.put("relMinMajor",relMinMajorLeniency);
			minThreshObj.put("relMinMinor",relMinMinorLeniency);


			JSONArray autoMinThreshArr = new JSONArray(); 
			JSONObject autoMinThreshObj = new JSONObject();
			autoMinThreshObj.put("displayField","None");
			autoMinThreshObj.put("valueField","None");
			autoMinThreshArr.add(autoMinThreshObj);
			autoMinThreshObj.put("displayField","Specific values");
			autoMinThreshObj.put("valueField","specify");
			autoMinThreshArr.add(autoMinThreshObj);
			rootJson.put("autoMinThreshArr",autoMinThreshArr);
			if(!StringUtils.isNull(minAutomaticSelected))
			{
				rootJson.put("minAutomaticSelected","specify");
			}
			else
			{
				rootJson.put("minAutomaticSelected","none");
			}
			rootJson.put("minAutomaticBlock",minAutomaticBlock);
			rootJson.put("autoMinThreshField",minAutoCriticalSliderBlock+"$"+minAutoMajorSliderBlock+"$"+minAutoMinorSliderBlock);


		}
	}

	screenLabels.put("maxThresh_tip",_mapping.getTextDescription("admin.threshold.Specify maximum threshold values (Critical, Major, and Minor) in descending order"));
	JSONObject maxThreshObj = new JSONObject();
	maxThreshObj.put("maxStaticOption",maxStaticSelected);
	maxThreshObj.put("maxStaticBlock",maxStaticBlock);
	maxThreshObj.put("absMaxCritical",absMaxCritical);
	maxThreshObj.put("absMaxMajor",absMaxMajor);
	maxThreshObj.put("absMaxMinor",absMaxMinor);


	//rootJson.put("maxThreshStaticArr",maxThreshStaticArr);
	if(!StringUtils.isNull(maxStaticSelected))
	{
		rootJson.put("selectedMaxStatic","specify");
	}
	else
	{
		rootJson.put("selectedMaxStatic","none");
	}
	rootJson.put("maxStaticBlock",maxStaticBlock);
	String absMaxThreshField = absMaxCritical+"$"+absMaxMajor+"$"+absMaxMinor;
	rootJson.put("absMaxThreshField",absMaxThreshField);

	if (!isGlobalThresholds )
	{
		if(!isNegativeValuesAllowed)
		{

	maxThreshObj.put("maxAutomaticOption",maxAutomaticSelected);
	maxThreshObj.put("maxAutomaticBlock",maxAutomaticBlock);
	maxThreshObj.put("maxAutoToleranceBlock",maxAutoToleranceBlock);
	maxThreshObj.put("relMaxCritical",relMaxCriticalLeniency);
	maxThreshObj.put("relMaxMajor",relMaxMajorLeniency);
	maxThreshObj.put("relMaxMinor",relMaxMinorLeniency);


			if(!StringUtils.isNull(maxAutomaticSelected))
			{
				rootJson.put("maxAutomaticSelected","specify");
			}
			else
			{
				rootJson.put("maxAutomaticSelected","none");
			}
			rootJson.put("maxAutomaticBlock",maxAutomaticBlock);
			rootJson.put("autoMaxThreshField",maxAutoCriticalSliderBlock+"$"+maxAutoMajorSliderBlock+"$"+maxAutoMinorSliderBlock);

		}
	}
	rootJson.put("minThreshObj",minThreshObj);
	rootJson.put("maxThreshObj",maxThreshObj);
	JSONObject alarmPolicyDescriptionObj = new JSONObject();
	JSONArray alarmPolicyArr = new JSONArray();

	for (int i=0;i<alarmVariables.length;i++)
	{
		JSONObject alarmPolicyObj = new JSONObject();
		JSONObject alarmObj = new JSONObject();

		String strAlarmPolicy = alarmVariables[i];
		String selected = "";
		alarmPolicyObj.put("displayField",strAlarmPolicy);
		alarmPolicyObj.put("valueField",strAlarmPolicy);
		alarmObj.put("displayField",strAlarmPolicy);
		alarmObj.put("valueField",strAlarmPolicy);
		String strDescription = thresholdsIni.getValue("ALARM_POLICY",strAlarmPolicy);
		int i_idx = strDescription.indexOf(",");
		String windowSize = strDescription.substring(0,i_idx);
		String numCrossings = strDescription.substring(i_idx+1);
		if (windowSize.equals("1") && numCrossings.equals("1"))
		{
			alarmPolicyDescriptionObj.put(strAlarmPolicy,numCrossings + " threshold violation out of " + windowSize + " measurement");
		}
		else
		{
			alarmPolicyDescriptionObj.put(strAlarmPolicy,numCrossings + " threshold violations out of " + windowSize + " consecutive measurements");
		}

		if (strAlarmPolicy.equals(alarmPolicy))
		{
			rootJson.put("selectedAlarmType",alarmPolicy);
			selected = "selected";
			if (windowSize.equals("1") && numCrossings.equals("1"))
			{
				rootJson.put("selectedAlarmDescription",numCrossings + " threshold violation out of " + windowSize + " measurement");
			}
			else
			{
				rootJson.put("selectedAlarmDescription",numCrossings + " threshold violations out of " + windowSize + " consecutive measurements");
			}
		}
		alarmPolicyArr.add(alarmObj);
	}

	rootJson.put("alarmPolicyDescriptionObj",alarmPolicyDescriptionObj);
	rootJson.put("alarmPolicyArr",alarmPolicyArr);

	String count = request.getParameter("measCount");
	int countVal = 0;
	if(!StringUtils.isNull(count))
	{
		countVal = Integer.valueOf(count).intValue();
	}
	if(countVal > 1)
	{
		rootJson.put("admin.common.Apply to other measures",_mapping.getTextDescription("admin.common.Apply to other measures"));
		rootJson.put("applyOtherMeasure_check_box","true");
		rootJson.put("countVal",countVal);
	}

	hiddenObj.put("testName",strTestName);
	hiddenObj.put("descName",strDescName);
	hiddenObj.put("measure",measure);
	hiddenObj.put("from",from);
	hiddenObj.put("comeFrom",comeFrom);
	rootJson.put("screenLabels",screenLabels);
	rootJson.put("hiddenObj",hiddenObj);
	out.println(rootJson.toString());

%>