<%@ include file="../../../../admin/EgTrackerAJSON.jsp" %>
<%@ page import = "net.sf.json.*"%>
<%@ page import="com.eg.*"%>
<%@ page import="com.egurkha.util.StringUtils"%>
<%@ page import="com.egurkha.admin.AuditLogThread"%>
<%@ page import="egurkha.TestBean"%>
<%@ page import="java.io.File"%>
<%@ page import="java.util.*"%>

<%
	response.setContentType("text/html;charset=UTF-8");

	AuditLogThread auditLogThread = new AuditLogThread();
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",_user.getLoginID());
	auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
	auditLogThread.setValue("Session_id",session.getId());
	auditLogThread.setValue("Module","Performance Rating Test");
	auditLogThread.setValue("Activity","Configure Test");

	ArrayList associatedCompTypes = new ArrayList();
	ArrayList disassociatedCompTypes = new ArrayList();

	JSONObject rootJson = new JSONObject();
	rootJson.put("success","true");

	String p_measures = "";
	Hashtable compTestDetails = (Hashtable)session.getAttribute("compTestDetails");
	String masterInfosTest2 = (String)compTestDetails.get("masterInfosTest");
	String descriptorBasedTest2 = (String)compTestDetails.get("descriptorBasedTest");
	if(descriptorBasedTest2.equalsIgnoreCase("true"))
	{
		if(compTestDetails.containsKey("TEST_MEASURES"))
		{
			Hashtable measure_name_mapping = null;
			if(compTestDetails.containsKey("MEASURE_NAME_MAPPING"))
			{
				measure_name_mapping = (Hashtable)compTestDetails.get("MEASURE_NAME_MAPPING");
			}
			LinkedHashMap tmht = new LinkedHashMap();
			LinkedHashMap test_measures = (LinkedHashMap)compTestDetails.get("TEST_MEASURES");
			Iterator itr = test_measures.keySet().iterator();
			while(itr.hasNext())
			{
				String compTest_Measure = (String)itr.next();
				String associatedTestMeasures = (String)test_measures.get(compTest_Measure);
				String arr_exist[] = StringUtils.getTokens(associatedTestMeasures,"|");
				boolean found = false;
				if(arr_exist != null)
				{
					for(int i=0;i<arr_exist.length;i++)
					{
						String tma[] = StringUtils.getTokens(arr_exist[i],",");
						for(int j=0;j<tma.length;j++)
						{
							String tmd = tma[j];
							if(tmd.startsWith((masterInfosTest2+":")))
							{
								found=true;
								break;
							}
						}
					}
				}
				if(!found)
				{
					String dispName = (String)measure_name_mapping.get(compTest_Measure);
					if(p_measures.length()==0)
						p_measures=dispName;
					else
						p_measures+=","+dispName;
				}
			}
			if(p_measures.length()>0)
			{
				String message = _mapping.getTextDescription("admin.common.This performance rating test measure")+" \""+p_measures+"\" "+_mapping.getTextDescription("admin.common.should include measures of")+" "+_mapping.getTestDescription(masterInfosTest2) + " test";
				rootJson.put("operationResultMessage",message);
				rootJson.put("isFailure",true);
			}
		}
	}
	if(compTestDetails.containsKey("TEST_MEASURES"))
	{
		boolean thresholdsNotFound = false;
		LinkedHashMap test_measures = (LinkedHashMap)compTestDetails.get("TEST_MEASURES");
		Iterator itr = test_measures.keySet().iterator();
		while(itr.hasNext())
		{
			String compTest_Measure = (String)itr.next();
			String associatedTestMeasures = (String)test_measures.get(compTest_Measure);
			String arr_exist[] = StringUtils.getTokens(associatedTestMeasures,"|");
			if(arr_exist != null)
			{
				for(int i=0;i<arr_exist.length;i++)
				{
					String tma[] = StringUtils.getTokens(arr_exist[i],",");
					for(int j=0;j<tma.length;j++)
					{
						String tmd = tma[j];
						int tilda = tmd.indexOf("~");
						if(tilda>0)
						{
							String thresholds = tmd.substring(tmd.lastIndexOf("~")+1).trim();
							if(thresholds.equals("-1:-1"))
							{
								String tm = tmd.substring(0,tmd.indexOf("~"));
								String t = tm.substring(0,tm.indexOf(":"));
								String m = tm.substring(tm.indexOf(":")+1);
								p_measures="-";//don't remove this line
								String displayname = "";
								if(compTestDetails.containsKey("MEASURE_NAME_MAPPING"))
								{
									Hashtable measure_name_mapping = (Hashtable)compTestDetails.get("MEASURE_NAME_MAPPING");
									if(measure_name_mapping != null && measure_name_mapping.containsKey(compTest_Measure))
									{
										displayname = (String)measure_name_mapping.get(compTest_Measure);
									}
								}
								String message="Both minimum and maximum target values cannot be none for "+_mapping.getMeasureDescription(t,m) +" measure of "+_mapping.getTestDescription(t) + " test in the performance rating measure " + displayname;
								rootJson.put("operationResultMessage",message);
								rootJson.put("isFailure",true);
								thresholdsNotFound=true;
								break;
							}
						}
					}
					if(thresholdsNotFound)
						break;
				}
			}
			if(thresholdsNotFound)
				break;
		}
	}
	ArrayList status = new ArrayList();
	if(p_measures.length()==0 && compTestDetails != null && compTestDetails.containsKey("compTest"))
	{
		rootJson.put("isFailure",false);
		boolean createOrRecreateTest = setAuditlog(compTestDetails, request, session, auditLogThread, _mapping,status,associatedCompTypes,disassociatedCompTypes);
		String compTest = (String)compTestDetails.get("compTest");
		EgDbaseInfo dbaseInfo = new EgDbaseInfo("manager");
		boolean pre_defined_test = (compTest.indexOf("_")==compTest.lastIndexOf("_"));

		if(!pre_defined_test && createOrRecreateTest && dbaseInfo.isTableExistInDB(compTest))
		{
			String sep = System.getProperty("file.separator");
			String dbServType = new EgDbInfo("manager").checkDBType();
			if(dbServType != null && dbServType.equals("EgMsSqlAdapter"))
			{
				String queryDir = EgInstallInfo.getInstallDir()+sep+"bin"+sep+"database"+sep+"mssql"+sep+"Composite_Test_Query";
				File dir = new File(queryDir);
				if(dir.isDirectory())
				{
					File queryFile = new File(queryDir+sep+compTest+".txt");
					if(queryFile.exists())
					{
						queryFile.delete();
					}
				}
			}
			else
			{
				String queryDir = EgInstallInfo.getInstallDir()+sep+"bin"+sep+"database"+sep+"Composite_Test_Query";
				File dir = new File(queryDir);
				if(dir.isDirectory())
				{
					File queryFile = new File(queryDir+sep+compTest+".txt");
					if(queryFile.exists())
					{
						queryFile.delete();
					}
				}
			}

			dbaseInfo.removeDynamicTable(compTest);

			EgThresholdInfo threshConfig = new EgThresholdInfo("manager");
			String existingCompMeasures[] = threshConfig.getMeasurementsForTest(compTest);
			if(existingCompMeasures != null)
			{
				IniFile dbFilePtrWr = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir()+"/manager/config/eg_db.ini");
				for(int i=0;i<existingCompMeasures.length;i++)
				{
					String compMeasure = existingCompMeasures[i];
					dbFilePtrWr.deleteValue("MEASUREMENT_DB_MAPPING", compTest +":"+ compMeasure);
					dbFilePtrWr.deleteValue("MEASUREMENT_DB_MAPPING", compTest +":"+ compMeasure + ":state");
				}
				dbFilePtrWr.saveFile();
				EgConfigFilesSync.releaseInstance(dbFilePtrWr);
			}
		}
		String compType = (String)compTestDetails.get("compType");
		String layerName = request.getParameter("layer");
		LinkedHashMap toSecondaryManagers = new LinkedHashMap();
		IniFile compInfoSync = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir()+"/manager/config/eg_composite.ini");
		UpdateAndTransmitICInfo updateICInfo = new  UpdateAndTransmitICInfo();
		if(!pre_defined_test && createOrRecreateTest)
		{
			deleteTestFromUserThresholds(compTest);
			updateICInfo.removeAggTestEntries(compTest);

			String newCompType = null;
			String newly_associated_comp_types = request.getParameter("newly_associated_comp_types");
			if(newly_associated_comp_types != null && (newly_associated_comp_types=newly_associated_comp_types.trim()).length()>0 && !newly_associated_comp_types.equalsIgnoreCase("null"))
			{
				boolean found = false;
				String arr[] = StringUtils.getTokens(newly_associated_comp_types,",");
				for(int i=0;i<arr.length;i++)
				{
					if(arr[i].equals(compType))
					{
						found=true;
						break;
					}
				}
				if(!found)
				{
					newCompType = arr[0];
				}
			}
			//Vector existingCompMeasures = compInfo.getMeasurementsForTest(compTest);
			Vector existingCompMeasures = null;
			Vector var = compInfoSync.getVariables(EgCompositeInfo.TEST_MEASURES,true);
			if(var != null && !var.isEmpty())
			{
				existingCompMeasures = new Vector();
				String key = compTest+":";
				for(int i=0;i<var.size();i++)
				{
					String v = (String)var.get(i);
					if(v.startsWith(key))
					{
						v = v.substring(v.indexOf(":")+1);
						existingCompMeasures.add(v);
					}
				}
			}
			if(existingCompMeasures != null)
			{
				String measuresInfo = compInfoSync.getValue(EgCompositeInfo.MEASURES,compTest);
				for(int i=0;i<existingCompMeasures.size();i++)
				{
					compInfoSync.deleteValue(EgCompositeInfo.TEST_MEASURES,compTest+":"+(String)existingCompMeasures.get(i));
				}
				for(int i=0;i<existingCompMeasures.size();i++)
				{
					String measure = (String)existingCompMeasures.get(i);
					if(measuresInfo != null && measuresInfo.indexOf(":")>-1)
					{
						String newString = "";
						String mkey = measure + ":";
						StringTokenizer st = new StringTokenizer(measuresInfo,"#");
						while(st.hasMoreTokens())
						{
							String t = st.nextToken();
							if(t.startsWith(mkey))
							{
								continue;
							}
							newString += "#" + t;
						}
						if(newString.length()>0)
						{
							measuresInfo = newString.substring(1);
						}
					}
				}
				if(measuresInfo.length()>0)
				{
					compInfoSync.setValue(EgCompositeInfo.MEASURES,compTest,measuresInfo);
				}
				else
				{
					compInfoSync.deleteValue(EgCompositeInfo.MEASURES,compTest);
				}
			}
			compInfoSync.setValue("USER_DEFINED_COMPOSITE_TESTS",compTest,"true");

			LinkedHashMap udct = new LinkedHashMap();
			udct.put(compTest,"true");
			toSecondaryManagers.put("USER_DEFINED_COMPOSITE_TESTS",udct);

			if(newCompType != null)
			{
				compInfoSync.setValue("TEST_COMP_TYPE_LAYER_MAPPING",compTest,(newCompType+"#"+layerName));
				LinkedHashMap tclm = new LinkedHashMap();
				tclm.put(compTest,(newCompType+"#"+layerName));
				toSecondaryManagers.put("TEST_COMP_TYPE_LAYER_MAPPING",tclm);
			}
			else
			{
				compInfoSync.setValue("TEST_COMP_TYPE_LAYER_MAPPING",compTest,(compType+"#"+layerName));
				LinkedHashMap tclm = new LinkedHashMap();
				tclm.put(compTest,(compType+"#"+layerName));
				toSecondaryManagers.put("TEST_COMP_TYPE_LAYER_MAPPING",tclm);
			}
		}

		String weightageStr = request.getParameter("weightageStr");
		compInfoSync.setValue("WEIGHTAGE",compTest,weightageStr);

		LinkedHashMap weightht = new LinkedHashMap();
		weightht.put(compTest,weightageStr);
		toSecondaryManagers.put("WEIGHTAGE",weightht);

		int mCount = 0;
		String descriptorBasedTest = (String)compTestDetails.get("descriptorBasedTest");
		if(!pre_defined_test && createOrRecreateTest)
		{
			Vector measures = (Vector)compTestDetails.get("MEASURE_NAMES");
			mCount = (measures != null && !measures.isEmpty())?measures.size():0;
			if(mCount>0)
			{
				//compInfoSync.addMeasureForTest(compTest,measures);//check this
				compInfoSync.deleteValue(EgCompositeInfo.MEASURES,compTest);
				int idx[] = new int[measures.size()];
				for(int i=0;i<measures.size();i++)
				{
					String str = (String)measures.get(i);
					String j = str.substring(str.lastIndexOf("_")+1);
					idx[i] = Integer.parseInt(j);
				}
				Arrays.sort(idx);
				String updatedMeasureStr = "";
				for(int i=0;i<idx.length;i++)
				{
					int index = idx[i];
					updatedMeasureStr = updatedMeasureStr+"#m_"+index+":dbs:%::"+index;
				}
				compInfoSync.setValue(EgCompositeInfo.MEASURES,compTest,updatedMeasureStr.substring(1));
			}
		}
		List associatedTests = new ArrayList();
		if(compTestDetails.containsKey("TEST_MEASURES"))
		{
			LinkedHashMap tmht = new LinkedHashMap();
			LinkedHashMap test_measures = (LinkedHashMap)compTestDetails.get("TEST_MEASURES");
			Iterator itr = test_measures.keySet().iterator();
			while(itr.hasNext())
			{
				String compTest_Measure = (String)itr.next();
				String associatedTestMeasures = (String)test_measures.get(compTest_Measure);
				compInfoSync.setValue("TEST_MEASURES",compTest_Measure,associatedTestMeasures);

				tmht.put(compTest_Measure,associatedTestMeasures);

				String arr_exist[] = StringUtils.getTokens(associatedTestMeasures,"|");
				if(arr_exist != null)
				{
					for(int i=0;i<arr_exist.length;i++)
					{
						String tma[] = StringUtils.getTokens(arr_exist[i],",");
						for(int j=0;j<tma.length;j++)
						{
							String tmd = tma[j];
							int tilda = tmd.indexOf("~");
							if(tilda>0)
							{
								String tm = tmd.substring(0,tmd.indexOf("~"));
								String t = tm.substring(0,tm.indexOf(":"));
								if(!associatedTests.contains(t))
								{
									associatedTests.add(t);
								}
							}
						}
					}
				}
			}
			toSecondaryManagers.put("TEST_MEASURES",tmht);
		}
		if(compTestDetails.containsKey("INCLUDE_DESCRIPTORS"))
		{
			LinkedHashMap inht = new LinkedHashMap();
			Hashtable measure_test_desc = (Hashtable)compTestDetails.get("INCLUDE_DESCRIPTORS");
			Iterator itr1 = measure_test_desc.keySet().iterator();
			while(itr1.hasNext())
			{
				String infos = "";
				String ctm = (String)itr1.next();
				Hashtable ht = (Hashtable)measure_test_desc.get(ctm);
				Iterator itr2 = ht.keySet().iterator();
				while(itr2.hasNext())
				{
					String it = (String)itr2.next();
					ArrayList al = (ArrayList)ht.get(it);
					for(int i=al.size()-1;i>=0;i--)
					{
						String d = (String)al.get(i);
						if(d.trim().length()==0 || d.trim().equalsIgnoreCase("all"))
						{
							al.remove(i);
						}
					}
					if(al.isEmpty())
					{
						continue;
					}
					infos += it+":";
					for(int i=0;i<al.size();i++)
					{
						infos += (String)al.get(i)+",";
					}
					infos = infos.substring(0,infos.length()-1) +"|";
				}
				if(infos.length()>0)
				{
					infos = infos.substring(0,infos.length()-1);
					compInfoSync.setValue("INCLUDE_DESCRIPTORS",ctm,infos);
					inht.put(ctm,infos);
				}
				else
				{
					compInfoSync.deleteValue("INCLUDE_DESCRIPTORS",ctm);
					inht.put(ctm,"");
				}
			}
			toSecondaryManagers.put("INCLUDE_DESCRIPTORS",inht);
		}
		if(compTestDetails.containsKey("EXCLUDE_DESCRIPTORS"))
		{
			LinkedHashMap exht = new LinkedHashMap();
			Hashtable measure_test_desc = (Hashtable)compTestDetails.get("EXCLUDE_DESCRIPTORS");
			Iterator itr1 = measure_test_desc.keySet().iterator();
			while(itr1.hasNext())
			{
				String infos = "";
				String ctm = (String)itr1.next();
				Hashtable ht = (Hashtable)measure_test_desc.get(ctm);
				Iterator itr2 = ht.keySet().iterator();
				while(itr2.hasNext())
				{
					String it = (String)itr2.next();
					ArrayList al = (ArrayList)ht.get(it);
					for(int i=al.size()-1;i>=0;i--)
					{
						String d = (String)al.get(i);
						if(d.trim().length()==0 || d.trim().equalsIgnoreCase("none"))
						{
							al.remove(i);
						}
					}
					if(al.isEmpty())
					{
						continue;
					}
					infos += it+":";
					for(int i=0;i<al.size();i++)
					{
						infos += (String)al.get(i)+",";
					}
					infos = infos.substring(0,infos.length()-1) +"|";
				}
				if(infos.length()>0)
				{
					infos = infos.substring(0,infos.length()-1);
					compInfoSync.setValue("EXCLUDE_DESCRIPTORS",ctm,infos);
					exht.put(ctm,infos);
				}
				else
				{
					compInfoSync.deleteValue("EXCLUDE_DESCRIPTORS",ctm);
					exht.put(ctm,"");
				}
			}
			toSecondaryManagers.put("EXCLUDE_DESCRIPTORS",exht);
		}

		if(!pre_defined_test)
		{
			String masterInfosTest = (String)compTestDetails.get("masterInfosTest");
			if(masterInfosTest == null || (masterInfosTest=masterInfosTest.trim()).length()==0 || masterInfosTest.equals("-") || masterInfosTest.equals("-1") || masterInfosTest.equalsIgnoreCase("null"))
			{
				masterInfosTest = "-1";
			}
			if(descriptorBasedTest.equalsIgnoreCase("true") && !masterInfosTest.equals("-1"))
			{
				compInfoSync.setValue("MASTER_INFOS_TEST",compTest,masterInfosTest);
			}
			else
			{
				compInfoSync.setValue("MASTER_INFOS_TEST",compTest,"-1");
			}
			compInfoSync.setValue("TEST_INFO_STATUS",compTest,descriptorBasedTest);
		}
		compInfoSync.saveFile();
		EgConfigFilesSync.releaseInstance(compInfoSync);

		String configDir = EgInstallInfo.getInstallDir()+"/manager/config/";
		String testDescription = (String)compTestDetails.get("testDescription");
		String purpose_of_test = (String)compTestDetails.get("purpose_of_test");

		StringTokenizer st = new StringTokenizer(purpose_of_test,"\n");
		String store_purpose_of_test = "";
		while(st.hasMoreTokens())
		{
			store_purpose_of_test += "~egline~" + st.nextToken();
		}
		if(store_purpose_of_test.length()>8)
		{
			store_purpose_of_test = store_purpose_of_test.substring(8);
		}
		IniFile compLangIni = EgConfigFilesSync.getInstance(configDir+"eg_composite_lang_en_US.ini", true);
		compLangIni.setValue("TEST_NAME_MAPPING",compTest,testDescription);
		compLangIni.setValue("TEXT_NAME_MAPPING","admin.composite."+compTest,testDescription);
		compLangIni.setValue("PURPOSE_OF_TEST",compTest,store_purpose_of_test);

		ArrayList mnm = new ArrayList();
		ArrayList ads = new ArrayList();
		String allMeasureNameMapKeys[] = compLangIni.getVariables("MEASURE_NAME_MAPPING");
		String allAlarmDispNameMapKeys[] = compLangIni.getVariables("ALARM_DISPLAY_STRING");
		String vkey = compTest+":";
		if(allMeasureNameMapKeys != null) {
			for(int i=0;i<allMeasureNameMapKeys.length;i++) {
				String key = allMeasureNameMapKeys[i];
				if(key.startsWith(vkey)) {
					mnm.add(key);
				}
			}
		}
		if(allAlarmDispNameMapKeys != null) {
			for(int i=0;i<allAlarmDispNameMapKeys.length;i++) {
				String key = allAlarmDispNameMapKeys[i];
				if(key.startsWith(vkey)) {
					ads.add(key);
				}
			}
		}
		if(compTestDetails.containsKey("MEASURE_NAME_MAPPING"))
		{
			Hashtable measure_name_mapping = (Hashtable)compTestDetails.get("MEASURE_NAME_MAPPING");
			Iterator itr = measure_name_mapping.keySet().iterator();
			while(itr.hasNext())
			{
				String key = (String)itr.next();
				String label = (String)measure_name_mapping.get(key);
				if(label != null && label.trim().length()>0)
				{
					mnm.remove(key);
					compLangIni.setValue("MEASURE_NAME_MAPPING",key,label.trim());
				}
			}
		}
		if(compTestDetails.containsKey("ALARM_DISPLAY_STRING"))
		{
			Hashtable measure_name_mapping = (Hashtable)compTestDetails.get("ALARM_DISPLAY_STRING");
			Iterator itr = measure_name_mapping.keySet().iterator();
			while(itr.hasNext())
			{
				String key = (String)itr.next();
				String label = (String)measure_name_mapping.get(key);
				if(label != null && label.trim().length()>0)
				{
					ads.remove(key);
					compLangIni.setValue("ALARM_DISPLAY_STRING",key,label.trim());
				}
			}
		}
		if(!mnm.isEmpty() || !ads.isEmpty()) {
			mnm.addAll(ads);
			for(int i=0;i<mnm.size();i++) {
				String key = (String)mnm.get(i);
				compLangIni.deleteValue("MEASURE_NAME_MAPPING",key);
				compLangIni.deleteValue("ALARM_DISPLAY_STRING",key);
			}
		}
		compLangIni.saveFile();
		EgConfigFilesSync.releaseInstance(compLangIni);
		
		if(!pre_defined_test && createOrRecreateTest)
		{
			EgTablesInfo tablesInfo = new EgTablesInfo("manager");
			boolean portBasedTest=tablesInfo.isPortRelevantForLayer(layerName);
			boolean addSidToSpec = false;
			if(compType.equals("Oracle_server") && portBasedTest)
			{
				addSidToSpec = true;
			}
			TestBean testBean = new TestBean(true);
			testBean.addCompositeTest(addSidToSpec,compTest,portBasedTest,mCount,descriptorBasedTest);
			testBean.setThresholdsForAggTest(compTest);

			Hashtable testMappingHt = new Hashtable();
			Hashtable defaultTestMappingHt = new Hashtable();
			Hashtable testSpecificationHt = new Hashtable();
			IniFile specsIni = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_specs.ini");

			if(!portBasedTest)
			{
				String testMappingTests = specsIni.getValue("TEST_MAPPING","Host_system");
				if(testMappingTests == null || (testMappingTests=testMappingTests.trim()).length()==0)
				{
					testMappingHt.put("Host_system",compTest);
				}
				else
				{
					String testMappingTestsStr = ","+testMappingTests+",";
					if(testMappingTestsStr.indexOf(","+compTest+",")<0)
					{
						testMappingHt.put("Host_system",(testMappingTests + "," + compTest));
					}
				}
			}
			else
			{
				String newStr = "";
				String tmp = null;
				String testMappingTests = specsIni.getValue("TEST_MAPPING","Host_system");
				String array[] = StringUtils.getTokens(testMappingTests,",");
				for(int i=0;i<array.length;i++)
				{
					tmp = array[i].trim();
					if(tmp.equals(compTest))
						continue;
					newStr+=","+tmp;
				}
				testMappingHt.put("Host_system",newStr.substring(1));
			}
			EgServicesInfo servicesInfo = new EgServicesInfo("manager");
			boolean enabledByDefault = true;
			String iniValue = servicesInfo.getValue("MISC_ARGS","EnableCompositeTest");
			if(iniValue != null && (iniValue.equalsIgnoreCase("no") || iniValue.equalsIgnoreCase("false")))
			{
				enabledByDefault=false;
			}
			if(enabledByDefault)
			{
				String testMappingTests = specsIni.getValue("TEST_MAPPING",compType);
				if(testMappingTests == null || (testMappingTests=testMappingTests.trim()).length()==0)
				{
					testMappingHt.put(compType,compTest);
				}
				else
				{
					String testMappingTestsStr = ","+testMappingTests+",";
					if(testMappingTestsStr.indexOf(","+compTest+",")<0)
					{
						testMappingHt.put(compType,(testMappingTests + "," + compTest));
					}
				}
				for(int i=0;i<associatedCompTypes.size();i++)
				{
					String a_compType = (String)associatedCompTypes.get(i);
					testMappingTests = specsIni.getValue("TEST_MAPPING",a_compType);
					if(testMappingTests == null || (testMappingTests=testMappingTests.trim()).length()==0)
					{
						testMappingHt.put(a_compType,compTest);
					}
					else
					{
						String testMappingTestsStr = ","+testMappingTests+",";
						if(testMappingTestsStr.indexOf(","+compTest+",")<0)
						{
							testMappingHt.put(a_compType,(testMappingTests + "," + compTest));
						}
					}
				}
			}
			for(int i=0;i<disassociatedCompTypes.size();i++)
			{
				String a_compType = (String)disassociatedCompTypes.get(i);
				String testMappingTests = specsIni.getValue("TEST_MAPPING",a_compType);
				if(testMappingTests != null && (testMappingTests=testMappingTests.trim()).length()>0)
				{
					int idx = -1;
					if(testMappingTests.equals(compTest))
					{
						testMappingHt.put(a_compType,"");
					}
					else if(testMappingTests.endsWith(","+compTest))
					{
						testMappingHt.put(a_compType,testMappingTests.substring(0,testMappingTests.lastIndexOf(",")));
					}
					else if(testMappingTests.startsWith(compTest+","))
					{
						testMappingHt.put(a_compType,testMappingTests.substring(testMappingTests.lastIndexOf(",")+1));
					}
					else if((idx=testMappingTests.indexOf(","+compTest+","))>=0)
					{
						String tmp = testMappingTests.substring(idx+1);
						tmp = tmp.substring(tmp.indexOf(",")+1);
						testMappingTests = testMappingTests.substring(0,idx+1)+tmp;
						testMappingHt.put(a_compType,testMappingTests);
					}
				}
			}
			if(!portBasedTest)
			{
				String defaultTestMappingTests = specsIni.getValue("DEFAULT_TEST_MAPPING","Host_system");
				if(defaultTestMappingTests == null || (defaultTestMappingTests=defaultTestMappingTests.trim()).length()==0)
				{
					defaultTestMappingHt.put("Host_system",compTest);
				}
				else
				{
					String defaultTestMappingStr = ","+defaultTestMappingTests+",";
					if(defaultTestMappingStr.indexOf(","+compTest+",")<0)
					{
						defaultTestMappingHt.put("Host_system",(defaultTestMappingTests + "," + compTest));
					}
				}
			}
			else
			{
				String newStr = "";
				String tmp = null;
				String defaultTestMappingTests = specsIni.getValue("DEFAULT_TEST_MAPPING","Host_system");
				String array[] = StringUtils.getTokens(defaultTestMappingTests,",");
				for(int i=0;i<array.length;i++)
				{
					tmp = array[i].trim();
					if(tmp.equals(compTest))
						continue;
					newStr+=","+tmp;
				}
				defaultTestMappingHt.put("Host_system",newStr.substring(1));
			}

			String defaultTestMappingTests = specsIni.getValue("DEFAULT_TEST_MAPPING",compType);
			if(defaultTestMappingTests == null || (defaultTestMappingTests=defaultTestMappingTests.trim()).length()==0)
			{
				defaultTestMappingHt.put(compType,compTest);
			}
			else
			{
				String defaultTestMappingStr = ","+defaultTestMappingTests+",";
				if(defaultTestMappingStr.indexOf(","+compTest+",")<0)
				{
					defaultTestMappingHt.put(compType,(defaultTestMappingTests + "," + compTest));
				}
			}
			for(int i=0;i<associatedCompTypes.size();i++)
			{
				String a_compType = (String)associatedCompTypes.get(i);
				defaultTestMappingTests = specsIni.getValue("DEFAULT_TEST_MAPPING",a_compType);
				if(defaultTestMappingTests == null || (defaultTestMappingTests=defaultTestMappingTests.trim()).length()==0)
				{
					defaultTestMappingHt.put(a_compType,compTest);
				}
				else
				{
					String defaultTestMappingStr = ","+defaultTestMappingTests+",";
					if(defaultTestMappingStr.indexOf(","+compTest+",")<0)
					{
						defaultTestMappingHt.put(a_compType,(defaultTestMappingTests + "," + compTest));
					}
				}
			}
			for(int i=0;i<disassociatedCompTypes.size();i++)
			{
				String a_compType = (String)disassociatedCompTypes.get(i);
				defaultTestMappingTests = specsIni.getValue("DEFAULT_TEST_MAPPING",a_compType);
				if(defaultTestMappingTests != null && (defaultTestMappingTests=defaultTestMappingTests.trim()).length()>0)
				{
					int idx = -1;
					if(defaultTestMappingTests.equals(compTest))
					{
						defaultTestMappingHt.put(a_compType,"");
					}
					else if(defaultTestMappingTests.endsWith(","+compTest))
					{
						defaultTestMappingHt.put(a_compType,defaultTestMappingTests.substring(0,defaultTestMappingTests.lastIndexOf(",")));
					}
					else if(defaultTestMappingTests.startsWith(compTest+","))
					{
						defaultTestMappingHt.put(a_compType,defaultTestMappingTests.substring(defaultTestMappingTests.lastIndexOf(",")+1));
					}
					else if((idx=defaultTestMappingTests.indexOf(","+compTest+","))>=0)
					{
						String tmp = defaultTestMappingTests.substring(idx+1);
						tmp = tmp.substring(tmp.indexOf(",")+1);
						defaultTestMappingTests = defaultTestMappingTests.substring(0,idx+1)+tmp;
						defaultTestMappingHt.put(a_compType,defaultTestMappingTests);
					}
				}
			}

			Vector tsvar = specsIni.getVariables("TEST_SPECIFICATION",true);
			Vector tsval = specsIni.getAllValues("TEST_SPECIFICATION");

			int measurePeriod = 300;
			if(tsvar != null && tsval != null)
			{
				for(int i=0;i<associatedTests.size();i++)
				{
					String key = (String)associatedTests.get(i)+":";
					for(int j=0;j<tsvar.size();j++)
					{
						String tvar = (String)tsvar.get(j);
						if(tvar.startsWith(key))
						{
							String tval = (String)tsval.get(j);
							tval = tval.substring(tval.lastIndexOf(",")+1).trim();
							try
							{
								int mp = Integer.parseInt(tval);
								if(mp<measurePeriod)
								{
									measurePeriod = mp;//setting the smallest test period of all associated main tests.
								}
							}
							catch(Exception e)
							{
							}
							break;
						}
					}
				}
			}
			String hostNameStr = "$hostName";
			Vector aggCompTypes = new com.eg.EgAggregateInfo("manager").getAggregateTypes();
			if(aggCompTypes != null && aggCompTypes.contains(compType))
			{
				EgTesterInfo testerInfo = new EgTesterInfo("manager");
				if(testerInfo.externalAgentRunsAllAggTests())
				{
					hostNameStr = "$EG_SERVER";
				}
			}
			else
			{
				String[] externalServerTypes = new EgSpecsInfo("manager").getAllExternalServerTypes();
				if(externalServerTypes != null && externalServerTypes.length>0 && Arrays.asList(externalServerTypes).contains(compType))
				{
					hostNameStr = "$EG_SERVER";
				}
			}
			String testSpecification=null;
			String testSpecificationValue = null;
			if(portBasedTest)
			{
//				if(addSidToSpec)
//				{
//					testSpecification=compTest+"::$hostName:$portNo:$sid";
//					testSpecificationValue = "$hostName,-auto, -host $hostIp -port $portNo -infobased "+descriptorBasedTest+" -agentless y -info $sid -rptName $hostName -mCount "+mCount+", "+measurePeriod;
//				}
//				else
//				{
//					testSpecification=compTest+"::$hostName:$portNo";
//					testSpecificationValue = "$hostName,-auto, -host $hostIp -port $portNo -infobased "+descriptorBasedTest+" -agentless y -rptName $hostName -mCount "+mCount+", "+measurePeriod;
//				}
				if(addSidToSpec)
				{
					testSpecification=compTest+"::$hostName:$portNo:$sid";
					testSpecificationValue = hostNameStr+",-auto, -host $hostIp -port $portNo -min_max_values none -agentless n -info $sid -rptName $hostName -mCount "+mCount+", "+measurePeriod;
				}
				else
				{
					testSpecification=compTest+"::$hostName:$portNo";
					testSpecificationValue = hostNameStr+",-auto, -host $hostIp -port $portNo -min_max_values none -agentless n -rptName $hostName -mCount "+mCount+", "+measurePeriod;
				}
			}
			else
			{
				testSpecification=compTest+"::$hostName";
				//testSpecificationValue = "$hostName,-auto, -host $hostIp -infobased "+descriptorBasedTest+" -agentless y -rptName $hostName -mCount "+mCount+", "+measurePeriod;
				testSpecificationValue = hostNameStr+",-auto, -host $hostIp -min_max_values none -agentless n -rptName $hostName -mCount "+mCount+", "+measurePeriod;
			}
			testSpecificationHt.put(testSpecification,testSpecificationValue);

			Vector specVec = new Vector();
			specVec.add(testMappingHt);
			specVec.add(defaultTestMappingHt);
			specVec.add(testSpecificationHt);
			updateICInfo.updateSpecsForServer(specVec);

			IniFile tmpini = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_composite.ini");
			String mvalue = tmpini.getValue("MEASURES",compTest);
			LinkedHashMap mht = new LinkedHashMap();
			mht.put(compTest,mvalue);
			toSecondaryManagers.put("MEASURES",mht);
		}
		else if((!pre_defined_test) && (!associatedCompTypes.isEmpty() || !disassociatedCompTypes.isEmpty()))
		{
			Hashtable testMappingHt = new Hashtable();
			Hashtable defaultTestMappingHt = new Hashtable();
			Hashtable testSpecificationHt = new Hashtable();
			IniFile specsIni = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_specs.ini");

			EgServicesInfo servicesInfo = new EgServicesInfo("manager");
			boolean enabledByDefault = true;
			String iniValue = servicesInfo.getValue("MISC_ARGS","EnableCompositeTest");
			if(iniValue != null && (iniValue.equalsIgnoreCase("no") || iniValue.equalsIgnoreCase("false")))
			{
				enabledByDefault=false;
			}
			if(enabledByDefault)
			{
				for(int i=0;i<associatedCompTypes.size();i++)
				{
					String a_compType = (String)associatedCompTypes.get(i);
					String testMappingTests = specsIni.getValue("TEST_MAPPING",a_compType);
					if(testMappingTests == null || (testMappingTests=testMappingTests.trim()).length()==0)
					{
						testMappingHt.put(a_compType,compTest);
					}
					else
					{
						String testMappingTestsStr = ","+testMappingTests+",";
						if(testMappingTestsStr.indexOf(","+compTest+",")<0)
						{
							testMappingHt.put(a_compType,(testMappingTests + "," + compTest));
						}
					}
				}
			}
			for(int i=0;i<disassociatedCompTypes.size();i++)
			{
				String a_compType = (String)disassociatedCompTypes.get(i);
				String testMappingTests = specsIni.getValue("TEST_MAPPING",a_compType);
				if(testMappingTests != null && (testMappingTests=testMappingTests.trim()).length()>0)
				{
					int idx = -1;
					if(testMappingTests.equals(compTest))
					{
						testMappingHt.put(a_compType,"");
					}
					else if(testMappingTests.endsWith(","+compTest))
					{
						testMappingHt.put(a_compType,testMappingTests.substring(0,testMappingTests.lastIndexOf(",")));
					}
					else if(testMappingTests.startsWith(compTest+","))
					{
						testMappingHt.put(a_compType,testMappingTests.substring(testMappingTests.lastIndexOf(",")+1));
					}
					else if((idx=testMappingTests.indexOf(","+compTest+","))>=0)
					{
						String tmp = testMappingTests.substring(idx+1);
						tmp = tmp.substring(tmp.indexOf(",")+1);
						testMappingTests = testMappingTests.substring(0,idx+1)+tmp;
						testMappingHt.put(a_compType,testMappingTests);
					}
				}
			}
			for(int i=0;i<associatedCompTypes.size();i++)
			{
				String a_compType = (String)associatedCompTypes.get(i);
				String defaultTestMappingTests = specsIni.getValue("DEFAULT_TEST_MAPPING",a_compType);
				if(defaultTestMappingTests == null || (defaultTestMappingTests=defaultTestMappingTests.trim()).length()==0)
				{
					defaultTestMappingHt.put(a_compType,compTest);
				}
				else
				{
					String defaultTestMappingStr = ","+defaultTestMappingTests+",";
					if(defaultTestMappingStr.indexOf(","+compTest+",")<0)
					{
						defaultTestMappingHt.put(a_compType,(defaultTestMappingTests + "," + compTest));
					}
				}
			}
			for(int i=0;i<disassociatedCompTypes.size();i++)
			{
				String a_compType = (String)disassociatedCompTypes.get(i);
				String defaultTestMappingTests = specsIni.getValue("DEFAULT_TEST_MAPPING",a_compType);
				if(defaultTestMappingTests != null && (defaultTestMappingTests=defaultTestMappingTests.trim()).length()>0)
				{
					int idx = -1;
					if(defaultTestMappingTests.equals(compTest))
					{
						defaultTestMappingHt.put(a_compType,"");
					}
					else if(defaultTestMappingTests.endsWith(","+compTest))
					{
						defaultTestMappingHt.put(a_compType,defaultTestMappingTests.substring(0,defaultTestMappingTests.lastIndexOf(",")));
					}
					else if(defaultTestMappingTests.startsWith(compTest+","))
					{
						defaultTestMappingHt.put(a_compType,defaultTestMappingTests.substring(defaultTestMappingTests.lastIndexOf(",")+1));
					}
					else if((idx=defaultTestMappingTests.indexOf(","+compTest+","))>=0)
					{
						String tmp = defaultTestMappingTests.substring(idx+1);
						tmp = tmp.substring(tmp.indexOf(",")+1);
						defaultTestMappingTests = defaultTestMappingTests.substring(0,idx+1)+tmp;
						defaultTestMappingHt.put(a_compType,defaultTestMappingTests);
					}
				}
			}
			Vector specVec = new Vector();
			specVec.add(testMappingHt);
			specVec.add(defaultTestMappingHt);
			specVec.add(testSpecificationHt);
			updateICInfo.updateSpecsForServer(specVec);
		}
		Vector secondaryManagersVec = new Vector();
		secondaryManagersVec.add(toSecondaryManagers);
		updateICInfo.updateCompositeIni(secondaryManagersVec);

		if(!pre_defined_test)
		{
			IniFile testsIni = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir()+"/manager/config/eg_tests.ini");
			testsIni.setValue("TREND_TESTS",compTest,"No");
			testsIni.setValue("GLOBAL_THRESHOLDS",compTest,"yes");
			testsIni.setValue("AGGREGATE_TEST","updated_time",""+System.currentTimeMillis());
			testsIni.saveFile();
			EgConfigFilesSync.releaseInstance(testsIni);
		}
		if(!pre_defined_test && createOrRecreateTest)
		{
			if(((String)status.get(0)).equalsIgnoreCase("AddTest"))
			{
				auditLogThread.setValue("Description","Performance rating test $test$:"+compTest+" has been generated successfully");
				rootJson.put("operationResultMessage",_mapping.getTextDescription("admin.common.Performance rating test has been generated successfully"));
			}
			else
			{
				auditLogThread.setValue("Description","Performance rating test  $test$:"+compTest+" has been regenerated successfully");
				rootJson.put("operationResultMessage",_mapping.getTextDescription("admin.common.Performance rating test has been regenerated successfully"));
			}
		}
		else
		{
			auditLogThread.setValue("Description","Performance rating test  $test$:"+compTest+" has been updated successfully");
			rootJson.put("operationResultMessage",_mapping.getTextDescription("admin.common.Performance rating test has been updated successfully"));
		}
		auditLogThread.sendItToDB();
	}
	out.println(rootJson.toString());
%>
<%!
	// below method is only for auditlog
	boolean setAuditlog(Hashtable compTestDetails, HttpServletRequest request, HttpSession session, AuditLogThread auditLogThread, EgMappingInfo _mapping, ArrayList status, ArrayList associatedCompTypes, ArrayList disassociatedCompTypes)
	{
		boolean isOldTest = false;
		boolean measuresAddedOrModified = false;
		if(compTestDetails != null && !compTestDetails.isEmpty())
		{
			if(compTestDetails.containsKey("modifyTest"))
			{
				String modifyTestStr = (String)compTestDetails.get("modifyTest");
				isOldTest = (modifyTestStr != null && modifyTestStr.trim().equalsIgnoreCase("true"));
			}
		}
		if(!isOldTest) // this is new Performance rating test
		{
			status.add("AddTest");
			measuresAddedOrModified = true;
			String compTest = (String)compTestDetails.get("compTest");
			String compType_c = (String)compTestDetails.get("compType");
			String layerName = request.getParameter("layer");
			String weightageStr = request.getParameter("weightageStr");
			String descriptorBasedTest = (String)compTestDetails.get("descriptorBasedTest");
			String weightageName = request.getParameter("weightageName");
			String weightage[] = StringUtils.getTokens(request.getParameter("weightageStr"),"#");
			String keyWeightage[] = StringUtils.getTokens(weightage[0],":");
			String supportWeightage[] = StringUtils.getTokens(weightage[1],":");
			if(weightageStr.equalsIgnoreCase("Key:1:none:none:0#Sup:1:none:none:0")) {
				weightageStr = "SystemDefined";
			}
			else {
				weightageStr = "CustomDefined";
			}
			if(compTestDetails.containsKey("testDescription")) {
				String desc_c = (String)compTestDetails.get("testDescription");
				if(desc_c != null && desc_c.trim().length()>0) {
					auditLogThread.setCurrentValue("01~~Test display name",desc_c);
				}
			}
			if(compTestDetails.containsKey("purpose_of_test")) {
				String pot = (String)compTestDetails.get("purpose_of_test");
				if(pot != null && pot.trim().length()>0) {
					auditLogThread.setCurrentValue("02~~Test description",pot);
				}
			}
			auditLogThread.setCurrentValue("03~~Component type to which this test is applicable","$ctype$:"+compType_c);
			auditLogThread.setCurrentValue("04~~Descriptor based",descriptorBasedTest.equalsIgnoreCase("true")?"Yes":"No");
			auditLogThread.setCurrentValue("05~~Layer to which this test is associated","$layer$:"+layerName);
			auditLogThread.setCurrentValue("06~~Weightage for measures",weightageName.equals("SystemDefined")?"System Defined":"Custom Defined");

			auditLogThread.setCurrentValue("07~~Weightage for key Measure Normal",keyWeightage[1]);

			if(keyWeightage[2].equalsIgnoreCase("none"))
				auditLogThread.setCurrentValue("08~~Weightage for key Measure Minor","None");
			else
				auditLogThread.setCurrentValue("08~~Weightage for key Measure Minor",keyWeightage[2]);

			if(keyWeightage[3].equalsIgnoreCase("none"))
				auditLogThread.setCurrentValue("09~~Weightage for key Measure Major","None");
			else
				auditLogThread.setCurrentValue("09~~Weightage for key Measure Major",keyWeightage[3]);

			auditLogThread.setCurrentValue("10~~Weightage for key Measure Critical",keyWeightage[4]);
			auditLogThread.setCurrentValue("11~~Weightage for non-key Measure Normal",supportWeightage[1]);

			if(supportWeightage[2].equalsIgnoreCase("none"))
				auditLogThread.setCurrentValue("12~~Weightage for non-key Measure Minor","None");
			else
				auditLogThread.setCurrentValue("12~~Weightage for non-key Measure Minor",supportWeightage[2]);

			if(supportWeightage[3].equalsIgnoreCase("none"))
				auditLogThread.setCurrentValue("13~~Weightage for non-key Measure Major","None");
			else
				auditLogThread.setCurrentValue("13~~Weightage for non-key Measure Major",supportWeightage[3]);

			auditLogThread.setCurrentValue("14~~Weightage for non-key Measure Critical",supportWeightage[4]);

			Vector compMeasures_current = (Vector)compTestDetails.get("MEASURE_NAMES");
			Collections.sort(compMeasures_current,String.CASE_INSENSITIVE_ORDER);
			for(int i=0;i<compMeasures_current.size();i++)
			{
				String comp_measure = (String)compMeasures_current.get(i);
				auditLogThread.setCurrentValue("15~~Measure names","$measure$:"+compTest+":"+comp_measure);
			}

			LinkedHashMap testMeasures_current = (LinkedHashMap)compTestDetails.get("TEST_MEASURES");
			ArrayList measureList = new ArrayList();
			measureList.addAll(testMeasures_current.keySet());
			Collections.sort(measureList,String.CASE_INSENSITIVE_ORDER);
			Iterator itr = measureList.iterator();
			while(itr.hasNext())
			{
				String compMeasure = (String)itr.next();
				String value = (String)testMeasures_current.get(compMeasure);
				StringTokenizer st = new StringTokenizer(value,"|");
				while(st.hasMoreTokens())
				{
					StringTokenizer st1 = new StringTokenizer(st.nextToken(),",");
					while(st1.hasMoreTokens())
					{
						String t = st1.nextToken();
						t = t.substring(0,t.indexOf("~"));
						auditLogThread.setCurrentValue("16~~Associated Measures of $measure$:"+compMeasure,"$measure$:"+t);
					}
				}
			}
			if(descriptorBasedTest.equalsIgnoreCase("true"))
			{
				String masterInfosTest = (String)compTestDetails.get("masterInfosTest");
				auditLogThread.setCurrentValue("17~~Show descriptors of the test","$test$:"+masterInfosTest);
			}
			if(compTestDetails.containsKey("INCLUDE_DESCRIPTORS"))
			{
				String include_desc_label = "Include descriptors for ";
				Hashtable compTestMeasureInfo = (Hashtable)compTestDetails.get("INCLUDE_DESCRIPTORS");
				Iterator itr1 = compTestMeasureInfo.keySet().iterator();
				while(itr1.hasNext())
				{
					String ctm = (String)itr1.next();
					String label = include_desc_label + " $measure$:"+ctm;
					Hashtable ht = (Hashtable)compTestMeasureInfo.get(ctm);
					Iterator itr2 = ht.keySet().iterator();
					while(itr2.hasNext())
					{
						String infos = "";
						String it = (String)itr2.next();
						String currentValue = "$test$:"+it;
						ArrayList al = (ArrayList)ht.get(it);
						for(int i=al.size()-1;i>=0;i--)
						{
							String d = (String)al.get(i);
							if(d.trim().length()==0 || d.trim().equalsIgnoreCase("all"))
							{
								al.remove(i);
							}
						}
						if(al.isEmpty())
						{
							continue;
						}
						for(int i=0;i<al.size();i++)
						{
							infos += (String)al.get(i)+",";
						}
						infos = infos.substring(0,infos.length()-1);
						auditLogThread.setCurrentValue(label,currentValue+"("+infos+")");
					}
				}
			}
			if(compTestDetails.containsKey("EXCLUDE_DESCRIPTORS"))
			{
				String exclude_desc_label = "Exclude descriptors for ";
				Hashtable compTestMeasureInfo = (Hashtable)compTestDetails.get("EXCLUDE_DESCRIPTORS");
				Iterator itr1 = compTestMeasureInfo.keySet().iterator();
				while(itr1.hasNext())
				{
					String ctm = (String)itr1.next();
					String label = exclude_desc_label + " $measure$:"+ctm;
					Hashtable ht = (Hashtable)compTestMeasureInfo.get(ctm);
					Iterator itr2 = ht.keySet().iterator();
					while(itr2.hasNext())
					{
						String infos = "";
						String it = (String)itr2.next();
						String currentValue = "$test$:"+it;
						ArrayList al = (ArrayList)ht.get(it);
						for(int i=al.size()-1;i>=0;i--)
						{
							String d = (String)al.get(i);
							if(d.trim().length()==0 || d.trim().equalsIgnoreCase("none"))
							{
								al.remove(i);
							}
						}
						if(al.isEmpty())
						{
							continue;
						}
						for(int i=0;i<al.size();i++)
						{
							infos += (String)al.get(i)+",";
						}
						infos = infos.substring(0,infos.length()-1);
						auditLogThread.setCurrentValue(label,currentValue+"("+infos+")");
					}
				}
			}
			String newly_associated_comp_types = request.getParameter("newly_associated_comp_types");
			if(newly_associated_comp_types != null && newly_associated_comp_types.length()>0)
			{
				String narray[] = StringUtils.getTokens(newly_associated_comp_types,",");
				for(int i=0;i<narray.length;i++)
				{
					String str = narray[i].trim();
					if(str.equals("-1")) continue;
					auditLogThread.setCurrentValue("Associated component types","$ctype$:"+str);
					associatedCompTypes.add(str);
				}
			}
		}
		else
		{
			status.add("ModifyTest");
			Hashtable compTestDetailsPrevious = null;
			Object obj = session.getAttribute("compTestDetailsForAuditLog");
			if(obj != null)
			{
				compTestDetailsPrevious = (Hashtable)obj;
				ArrayList previousKeyList = new ArrayList(compTestDetailsPrevious.keySet());
				Collections.sort(previousKeyList,String.CASE_INSENSITIVE_ORDER);
				Iterator previous_itr = previousKeyList.iterator();
				while(previous_itr.hasNext())
				{
					String s = (String)previous_itr.next();
				}
			}
			if(compTestDetailsPrevious != null && !compTestDetailsPrevious.isEmpty())
			{
				String descriptorBasedTest_previous = null;
				if(compTestDetailsPrevious.containsKey("descriptorBasedTest"))
					descriptorBasedTest_previous = (String)compTestDetailsPrevious.get("descriptorBasedTest");
				descriptorBasedTest_previous = descriptorBasedTest_previous.equalsIgnoreCase("true")?"Yes":"No";
				String descriptorBasedTest_current = (String)compTestDetails.get("descriptorBasedTest");
				descriptorBasedTest_current=descriptorBasedTest_current.equalsIgnoreCase("true")?"Yes":"No";
				if(!descriptorBasedTest_previous.equals(descriptorBasedTest_current))
				{
					measuresAddedOrModified = true;
				}
				auditLogThread.setCurrentValue("03~~Descriptor based",descriptorBasedTest_current);
				auditLogThread.setPreviousValue("03~~Descriptor based",descriptorBasedTest_previous);

				String layer_previous = null;
				if(compTestDetailsPrevious.containsKey("layer"))
					layer_previous = (String)compTestDetailsPrevious.get("layer");
				String layer_current = request.getParameter("layer");
				auditLogThread.setCurrentValue("04~~Layer to which this test is associated","$layer$:"+layer_current);
				auditLogThread.setPreviousValue("04~~Layer to which this test is associated","$layer$:"+layer_previous);
				if(!layer_previous.equals(layer_current))
				{
					measuresAddedOrModified = true;
				}

				String weightageName_previous = null;
				if(compTestDetailsPrevious.containsKey("weightageType"))
					weightageName_previous = (String)compTestDetailsPrevious.get("weightageType");
				String weightageName_current = request.getParameter("weightageName");

				weightageName_current = weightageName_current.equalsIgnoreCase("SystemDefined")?"System Defined":"Custom Defined";
				weightageName_previous = weightageName_previous.equalsIgnoreCase("SystemDefined")?"System Defined":"Custom Defined";
				auditLogThread.setCurrentValue("05~~Weightage for measures",weightageName_current);
				auditLogThread.setPreviousValue("05~~Weightage for measures",weightageName_previous);

				String weightage[] = StringUtils.getTokens(request.getParameter("weightageStr"),"#");
				String keyWeightage[] = StringUtils.getTokens(weightage[0],":");
				String supportWeightage[] = StringUtils.getTokens(weightage[1],":");

				String keyNormal_previous = null;
				String KeyMinor_previous = null;
				String KeyMajor_previous = null;
				String KeyCritical_previous = null;
				String supportNormal_previous = null;
				String supportMinor_previous = null;
				String supportMajor_previous = null;
				String supportCritical_previous = null;
				if(compTestDetailsPrevious.containsKey("weightage"))
				{
					Hashtable weightage_p = (Hashtable)compTestDetailsPrevious.get("weightage");
					keyNormal_previous = (String)weightage_p.get("keyNormal");
					KeyMinor_previous = (String)weightage_p.get("keyMinor");
					if(KeyMinor_previous != null && KeyMinor_previous.equalsIgnoreCase("none"))
						KeyMinor_previous = "None";
					KeyMajor_previous = (String)weightage_p.get("keyMajor");
					if(KeyMajor_previous != null && KeyMajor_previous.equalsIgnoreCase("none"))
						KeyMajor_previous = "None";
					KeyCritical_previous = (String)weightage_p.get("keyCritical");
					supportNormal_previous = (String)weightage_p.get("supportNormal");
					supportMinor_previous = (String)weightage_p.get("supportMinor");
					if(supportMinor_previous != null && supportMinor_previous.equalsIgnoreCase("none"))
						supportMinor_previous = "None";
					supportMajor_previous = (String)weightage_p.get("supportMajor");
					if(supportMajor_previous != null && supportMajor_previous.equalsIgnoreCase("none"))
						supportMajor_previous = "None";
					supportCritical_previous = (String)weightage_p.get("supportCritical");
				}

				auditLogThread.setPreviousValue("07~~Weightage for key Measure Normal",keyNormal_previous);
				auditLogThread.setCurrentValue("07~~Weightage for key Measure Normal",keyWeightage[1]);

				auditLogThread.setPreviousValue("08~~Weightage for key Measure Minor",KeyMinor_previous);
				if(keyWeightage[2].equalsIgnoreCase("none"))
					auditLogThread.setCurrentValue("08~~Weightage for key Measure Minor","None");
				else
					auditLogThread.setCurrentValue("08~~Weightage for key Measure Minor",keyWeightage[2]);

				auditLogThread.setPreviousValue("09~~Weightage for key Measure Major",KeyMajor_previous);
				if(keyWeightage[3].equalsIgnoreCase("none"))
					auditLogThread.setCurrentValue("09~~Weightage for key Measure Major","None");
				else
					auditLogThread.setCurrentValue("09~~Weightage for key Measure Major",keyWeightage[3]);

				auditLogThread.setPreviousValue("10~~Weightage for key Measure Critical",KeyCritical_previous);
				auditLogThread.setCurrentValue("10~~Weightage for key Measure Critical",keyWeightage[4]);

				auditLogThread.setPreviousValue("11~~Weightage for non-key Measure Normal",supportNormal_previous);
				auditLogThread.setCurrentValue("11~~Weightage for non-key Measure Normal",supportWeightage[1]);

				auditLogThread.setPreviousValue("12~~Weightage for non-key Measure Minor",supportMinor_previous);
				if(supportWeightage[2].equalsIgnoreCase("none"))
					auditLogThread.setCurrentValue("12~~Weightage for non-key Measure Minor","None");
				else
					auditLogThread.setCurrentValue("12~~Weightage for non-key Measure Minor",supportWeightage[2]);

				auditLogThread.setPreviousValue("13~~Weightage for non-key Measure Major",supportMajor_previous);
				if(supportWeightage[3].equalsIgnoreCase("none"))
					auditLogThread.setCurrentValue("13~~Weightage for non-key Measure Major","None");
				else
					auditLogThread.setCurrentValue("13~~Weightage for non-key Measure Major",supportWeightage[3]);

				auditLogThread.setPreviousValue("14~~Weightage for non-key Measure Critical",supportCritical_previous);
				auditLogThread.setCurrentValue("14~~Weightage for non-key Measure Critical",supportWeightage[4]);

				String compTest = (String)compTestDetails.get("compTest");
				Vector compMeasures_current = (Vector)compTestDetails.get("MEASURE_NAMES");
				Vector compMeasures_previous = (Vector)compTestDetailsPrevious.get("MEASURE_NAMES");
				Collections.sort(compMeasures_current,String.CASE_INSENSITIVE_ORDER);
				Collections.sort(compMeasures_previous,String.CASE_INSENSITIVE_ORDER);

				if(compMeasures_current.size() != compMeasures_previous.size())
				{
					//composite measure is either added or deleted
					measuresAddedOrModified = true;
				}
				else if(!compMeasures_current.containsAll(compMeasures_previous))
				{
					//composite measure is deleted
					measuresAddedOrModified = true;
				}
				for(int i=0;i<compMeasures_previous.size();i++)
				{
					String comp_measure = (String)compMeasures_previous.get(i);
					auditLogThread.setPreviousValue("15~~Measure names","$measure$:"+compTest+":"+comp_measure);
				}
				for(int i=0;i<compMeasures_current.size();i++)
				{
					String comp_measure = (String)compMeasures_current.get(i);
					auditLogThread.setCurrentValue("15~~Measure names","$measure$:"+compTest+":"+comp_measure);
				}

				LinkedHashMap testMeasures_previous = (LinkedHashMap)compTestDetailsPrevious.get("TEST_MEASURES");
				LinkedHashMap testMeasures_current = (LinkedHashMap)compTestDetails.get("TEST_MEASURES");
				ArrayList measureList = new ArrayList();
				measureList.addAll(testMeasures_current.keySet());
				Collections.sort(measureList,String.CASE_INSENSITIVE_ORDER);
				Iterator itr = measureList.iterator();
				while(itr.hasNext())
				{
					String compMeasure = (String)itr.next();
					String value = (String)testMeasures_current.get(compMeasure);
					StringTokenizer st = new StringTokenizer(value,"|");
					while(st.hasMoreTokens())
					{
						StringTokenizer st1 = new StringTokenizer(st.nextToken(),",");
						while(st1.hasMoreTokens())
						{
							String t = st1.nextToken();
							t = t.substring(0,t.indexOf("~"));
							auditLogThread.setCurrentValue("16~~Associated Measures of $measure$:"+compMeasure,"$measure$:"+t);
						}
					}
					if(testMeasures_previous != null && testMeasures_previous.containsKey(compMeasure))
					{
						String value_p = (String)testMeasures_previous.get(compMeasure);
						StringTokenizer st_p = new StringTokenizer(value_p,"|");
						while(st_p.hasMoreTokens())
						{
							StringTokenizer st_pr = new StringTokenizer(st_p.nextToken(),",");
							while(st_pr.hasMoreTokens())
							{
								String t = st_pr.nextToken();
								t = t.substring(0,t.indexOf("~"));
								auditLogThread.setPreviousValue("16~~Associated Measures of $measure$:"+compMeasure,"$measure$:"+t);
							}
						}
					}
				}
				String masterInfosTestPrevious = (String)compTestDetailsPrevious.get("masterInfosTest");
				if(masterInfosTestPrevious == null || (masterInfosTestPrevious=masterInfosTestPrevious.trim()).length()==0 || masterInfosTestPrevious.equals("-") || masterInfosTestPrevious.equals("-1") || masterInfosTestPrevious.equalsIgnoreCase("null"))
				{
					masterInfosTestPrevious = "-";
				}
				else
				{
					masterInfosTestPrevious="$test$:"+masterInfosTestPrevious;
				}

				String masterInfosTest = (String)compTestDetails.get("masterInfosTest");
				if(masterInfosTest == null || (masterInfosTest=masterInfosTest.trim()).length()==0 || masterInfosTest.equals("-") || masterInfosTest.equals("-1") || masterInfosTest.equalsIgnoreCase("null"))
				{
					masterInfosTest = "-";
				}
				else
				{
					masterInfosTest="$test$:"+masterInfosTest;
				}
				auditLogThread.setPreviousValue("17~~Show descriptors of the test",masterInfosTest);
				auditLogThread.setCurrentValue("17~~Show descriptors of the test",masterInfosTest);
				String include_desc_label = "Include descriptors for ";
				if(compTestDetailsPrevious.containsKey("INCLUDE_DESCRIPTORS"))
				{
					Hashtable compTestMeasureInfo = (Hashtable)compTestDetailsPrevious.get("INCLUDE_DESCRIPTORS");
					Iterator itr1 = compTestMeasureInfo.keySet().iterator();
					while(itr1.hasNext())
					{
						String ctm = (String)itr1.next();
						String label = include_desc_label + " $measure$:"+ctm;
						Hashtable ht = (Hashtable)compTestMeasureInfo.get(ctm);
						Iterator itr2 = ht.keySet().iterator();
						while(itr2.hasNext())
						{
							String infos = "";
							String it = (String)itr2.next();
							String currentValue = "$test$:"+it;
							ArrayList al = (ArrayList)ht.get(it);
							for(int i=al.size()-1;i>=0;i--)
							{
								String d = (String)al.get(i);
								if(d.trim().length()==0 || d.trim().equalsIgnoreCase("all"))
								{
									al.remove(i);
								}
							}
							if(al.isEmpty())
							{
								continue;
							}
							for(int i=0;i<al.size();i++)
							{
								infos += (String)al.get(i)+",";
							}
							infos = infos.substring(0,infos.length()-1);
							auditLogThread.setPreviousValue(label,currentValue+"("+infos+")");
						}
					}
				}
				if(compTestDetails.containsKey("INCLUDE_DESCRIPTORS"))
				{
					Hashtable compTestMeasureInfo = (Hashtable)compTestDetails.get("INCLUDE_DESCRIPTORS");
					Iterator itr1 = compTestMeasureInfo.keySet().iterator();
					while(itr1.hasNext())
					{
						String ctm = (String)itr1.next();
						String label = include_desc_label + " $measure$:"+ctm;
						Hashtable ht = (Hashtable)compTestMeasureInfo.get(ctm);
						Iterator itr2 = ht.keySet().iterator();
						while(itr2.hasNext())
						{
							String infos = "";
							String it = (String)itr2.next();
							String currentValue = "$test$:"+it;
							ArrayList al = (ArrayList)ht.get(it);
							for(int i=al.size()-1;i>=0;i--)
							{
								String d = (String)al.get(i);
								if(d.trim().length()==0 || d.trim().equalsIgnoreCase("all"))
								{
									al.remove(i);
								}
							}
							if(al.isEmpty())
							{
								continue;
							}
							for(int i=0;i<al.size();i++)
							{
								infos += (String)al.get(i)+",";
							}
							infos = infos.substring(0,infos.length()-1);
							auditLogThread.setCurrentValue(label,currentValue+"("+infos+")");
						}
					}
				}

				String exclude_desc_label = "Exclude descriptors for ";
				if(compTestDetailsPrevious.containsKey("EXCLUDE_DESCRIPTORS"))
				{
					Hashtable compTestMeasureInfo = (Hashtable)compTestDetailsPrevious.get("EXCLUDE_DESCRIPTORS");
					Iterator itr1 = compTestMeasureInfo.keySet().iterator();
					while(itr1.hasNext())
					{
						String ctm = (String)itr1.next();
						String label = exclude_desc_label + " $measure$:"+ctm;
						Hashtable ht = (Hashtable)compTestMeasureInfo.get(ctm);
						Iterator itr2 = ht.keySet().iterator();
						while(itr2.hasNext())
						{
							String infos = "";
							String it = (String)itr2.next();
							String currentValue = "$test$:"+it;
							ArrayList al = (ArrayList)ht.get(it);
							for(int i=al.size()-1;i>=0;i--)
							{
								String d = (String)al.get(i);
								if(d.trim().length()==0 || d.trim().equalsIgnoreCase("none"))
								{
									al.remove(i);
								}
							}
							if(al.isEmpty())
							{
								continue;
							}
							for(int i=0;i<al.size();i++)
							{
								infos += (String)al.get(i)+",";
							}
							infos = infos.substring(0,infos.length()-1);
							auditLogThread.setPreviousValue(label,currentValue+"("+infos+")");
						}
					}
				}
				if(compTestDetails.containsKey("EXCLUDE_DESCRIPTORS"))
				{
					Hashtable compTestMeasureInfo = (Hashtable)compTestDetails.get("EXCLUDE_DESCRIPTORS");
					Iterator itr1 = compTestMeasureInfo.keySet().iterator();
					while(itr1.hasNext())
					{
						String ctm = (String)itr1.next();
						String label = exclude_desc_label + " $measure$:"+ctm;
						Hashtable ht = (Hashtable)compTestMeasureInfo.get(ctm);
						Iterator itr2 = ht.keySet().iterator();
						while(itr2.hasNext())
						{
							String infos = "";
							String it = (String)itr2.next();
							String currentValue = "$test$:"+it;
							ArrayList al = (ArrayList)ht.get(it);
							for(int i=al.size()-1;i>=0;i--)
							{
								String d = (String)al.get(i);
								if(d.trim().length()==0 || d.trim().equalsIgnoreCase("none"))
								{
									al.remove(i);
								}
							}
							if(al.isEmpty())
							{
								continue;
							}
							for(int i=0;i<al.size();i++)
							{
								infos += (String)al.get(i)+",";
							}
							infos = infos.substring(0,infos.length()-1);
							auditLogThread.setCurrentValue(label,currentValue+"("+infos+")");
						}
					}
				}

				ArrayList currList = new ArrayList();
				String newly_associated_comp_types = request.getParameter("newly_associated_comp_types");

				if(newly_associated_comp_types != null && newly_associated_comp_types.length()>0)
				{
					String narray[] = StringUtils.getTokens(newly_associated_comp_types,",");
					for(int i=0;i<narray.length;i++)
					{
						String str = narray[i].trim();
						if(str.equals("-1")) continue;
						currList.add(str);
					}
				}
				ArrayList prevList = new ArrayList();
				if(compTestDetailsPrevious.containsKey("ass_comp_types"))
				{
					prevList = (ArrayList)compTestDetailsPrevious.get("ass_comp_types");
				}
				for(int i=currList.size()-1;i>=0;i--)
				{
					String x = (String)currList.get(i);
					if(prevList.indexOf(x)>-1)
					{
						prevList.remove(x);
						currList.remove(x);
					}
				}
				prevList.remove("-1");
				for (int i=0; i<currList.size(); i++)
				{
					String str = (String)currList.get(i);
					auditLogThread.setCurrentValue("Associated Component Types","$ctype$:"+str);
					associatedCompTypes.add(str);
				}
				for (int i=0; i<prevList.size(); i++)
				{
					String str = (String)prevList.get(i);
					auditLogThread.setCurrentValue("Disassociated Component Types","$ctype$:"+str);
					disassociatedCompTypes.add(str);
				}
			}
		}
		return measuresAddedOrModified;
	}
	void deleteTestFromUserThresholds(String test)
	{
		IniFile threshFilePtr = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir()+"/manager/config/eg_thresholds.ini");
		String[] variables=threshFilePtr.getVariables("USER_THRESHOLDS");
		boolean flag = false;
		if (variables!=null)
		{
			for (int i=0;i<variables.length ;i++ )
			{
				if (variables[i].startsWith(test+":"))
				{
					flag = true;
					threshFilePtr.deleteValue("USER_THRESHOLDS", variables[i]);
				}
			}
		}
		if (flag)
		{
			threshFilePtr.saveFile();
		}
		EgConfigFilesSync.releaseInstance(threshFilePtr);
	}
%>