<%@ include file="../../../admin/EgTrackerAJSON.jsp"%>
<%@ page import="com.eg.IniFile"%>
<%@ page import="com.eg.EgInstallInfo"%>
<%@ page import="net.sf.json.JSONObject"%>
<%@ page import="net.sf.json.JSONArray "%>
<%@ page import="com.egurkha.util.StringUtils"%>

<%

	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json;charset=UTF-8");

	JSONObject rootJson = new JSONObject();
	JSONObject hiddens = new JSONObject();
	rootJson.put("success","true");

	String descriptorBasedTest = "true";
	String selectedLayer = "-1";
	String selectedWeightageType = null;
	String keyNormal = null;
	String keyMinor = null;
	String keyMajor = null;
	String keyCritical = null;
	String supportNormal = null;
	String supportMinor = null;
	String supportMajor = null;
	String supportCritical = null;

	Hashtable compTestDetails = (Hashtable)session.getAttribute("compTestDetails");
	if(compTestDetails.containsKey("modifyTest"))
	{
		rootJson.put("isModifyTest",new Boolean(true));
	}
	else
	{
		rootJson.put("isModifyTest",new Boolean(false));
	}
	String compType = (String)compTestDetails.get("compType");
	String compTest = (String)compTestDetails.get("compTest");
	String thisCompType = (String)compTestDetails.get("compType");
	if(compTestDetails.containsKey("layer"))
	{
		selectedLayer = (String)compTestDetails.get("layer");
	}
	if(compTestDetails.containsKey("descriptorBasedTest"))
	{
		descriptorBasedTest = (String)compTestDetails.get("descriptorBasedTest");
	}

	String tdesc = _mapping.getTestDescription(compTest);
	if(tdesc.equals(compTest) && compTestDetails.containsKey("testDescription"))
	{
		tdesc = (String)compTestDetails.get("testDescription");
	}
	rootJson.put("test_desc_generate_tab",tdesc);
	rootJson.put("type_desc_generate_tab",_mapping.getComponentTypeDescription(compType));
	String descriptor_generate_tab = (descriptorBasedTest.equals("true") || descriptorBasedTest.equals("yes"))?"Yes":"No";
	rootJson.put("descriptor_generate_tab",descriptor_generate_tab);
	boolean isPredefinedRxTest = (compTest.indexOf("_")==compTest.lastIndexOf("_"));
	rootJson.put("is_predefined_test",isPredefinedRxTest);

	if(compTestDetails.containsKey("weightageType"))
	{
		selectedWeightageType = (String)compTestDetails.get("weightageType");
	}
	if(selectedWeightageType != null && selectedWeightageType.equals("CustomDefined") && compTestDetails.containsKey("weightage"))
	{
		Hashtable weightage = (Hashtable)compTestDetails.get("weightage");
		keyNormal = (String)weightage.get("keyNormal");
		keyMinor = (String)weightage.get("keyMinor");
		keyMajor = (String)weightage.get("keyMajor");
		keyCritical = (String)weightage.get("keyCritical");
		supportNormal = (String)weightage.get("supportNormal");
		supportMinor = (String)weightage.get("supportMinor");
		supportMajor = (String)weightage.get("supportMajor");
		supportCritical = (String)weightage.get("supportCritical");
	}
	else
	{
		selectedWeightageType = "SystemDefined";
		keyNormal = "1";
		keyMinor = "None";
		keyMajor = "None";
		keyCritical = "0";
		supportNormal = "1";
		supportMinor = "None";
		supportMajor = "None";
		supportCritical = "0";

		IniFile compIni = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_composite.ini");
		String default_weightage = compIni.getValue("DEFAULT_WEIGHTAGE","DEFAULT");
		if(default_weightage != null && !default_weightage.trim().equalsIgnoreCase("Key:1:none:none:0#Sup:1:none:none:0"))
		{
			StringTokenizer st = new StringTokenizer(default_weightage.trim(),"#");
			if(st.countTokens()==2)
			{
				StringTokenizer st1 = new StringTokenizer(st.nextToken(),":");
				StringTokenizer st2 = new StringTokenizer(st.nextToken(),":");
				if(st1.countTokens()==5 && st2.countTokens()==5)
				{
					st1.nextToken();
					keyNormal = st1.nextToken();
					keyMinor = st1.nextToken();
					keyMajor = st1.nextToken();
					keyCritical = st1.nextToken();

					st2.nextToken();
					supportNormal = st2.nextToken();
					supportMinor = st2.nextToken();
					supportMajor = st2.nextToken();
					supportCritical = st2.nextToken();
				}
			}
		}
	}
	MappingNameSorter sorter = new MappingNameSorter(trackerLanguage);
	EgTablesInfo tablesInfo = new EgTablesInfo("manager");
	ArrayList layerList = tablesInfo.getLayersForComponent(compType);
	Collections.reverse(layerList);

	JSONArray layers = new JSONArray();
	JSONObject obj = new JSONObject();
	if(!isPredefinedRxTest)
	{
		obj.put("displayField",_mapping.getTextDescription("admin.ic.Select a layer"));
		obj.put("valueField","-1");
		layers.add(obj);
	}
	if(layerList != null)
	{
		for(int i=0;i<layerList.size();i++)
		{
			String name = (String)layerList.get(i);
			if(isPredefinedRxTest && !name.equals(selectedLayer))
			{
				continue;
			}
			String displayname = _mapping.getLayerDescription(name);
			obj.put("displayField",displayname);
			obj.put("valueField",name);
			layers.add(obj);
		}
	}
	rootJson.put("layers",layers);

	ArrayList associatedTests = new ArrayList();
	if(compTestDetails != null && compTestDetails.containsKey("TEST_MEASURES"))
	{
		LinkedHashMap TEST_MEASURES_ht = (LinkedHashMap)compTestDetails.get("TEST_MEASURES");
		Iterator itrtm = TEST_MEASURES_ht.keySet().iterator();
		while(itrtm.hasNext())
		{
			String atmp = (String)TEST_MEASURES_ht.get(itrtm.next());
			String array[] = StringUtils.getTokens(atmp,"|");
			for(int i=0;i<array.length;i++)
			{
				String atm = array[i];
				String t = atm.substring(0,atm.indexOf(":"));
				if(!associatedTests.contains(t))
				{
					associatedTests.add(t);
				}
			}
		}
	}

	ArrayList filterCompTypes = new ArrayList();
	boolean associatedComponentsFound = false;
	boolean availableComponentsFound = false;
	JSONArray associatedComponentsJsonArray = new JSONArray();
	JSONArray availableComponentsJsonArray = new JSONArray();
	ArrayList alreadyAsociatedCompTypes = new ArrayList();
	if(compTestDetails.containsKey("ass_comp_types"))
	{
		ArrayList associatedCompTypesPre = (ArrayList)compTestDetails.get("ass_comp_types");
		if(associatedCompTypesPre != null && !associatedCompTypesPre.isEmpty())
		{
			alreadyAsociatedCompTypes.addAll(associatedCompTypesPre);
		}
	}
	if(!alreadyAsociatedCompTypes.contains(compType))
	{
		alreadyAsociatedCompTypes.add(compType);
	}
	for(int i=0;i<alreadyAsociatedCompTypes.size();i++)
	{
		String tmp = (String)alreadyAsociatedCompTypes.get(i);
		JSONObject compTypeObj = new JSONObject();
		compTypeObj.put("displayField",_mapping.getComponentTypeDescription(tmp));
		compTypeObj.put("valueField",tmp);
		associatedComponentsJsonArray.add(compTypeObj);
		associatedComponentsFound=true;
		filterCompTypes.add(tmp);
	}
	int compTypeCount=0;
	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
	EgDiscInfo discInfo = new EgDiscInfo("manager");
	String componentTypes[] = discInfo.getComponentTypes();
	if(componentTypes != null && componentTypes.length>0 && !isPredefinedRxTest)
	{
		ArrayList tempList = new ArrayList();
		tempList.addAll(Arrays.asList(componentTypes));
		ArrayList serverList = sorter.getSortedCompTypeList(tempList);
		for(int i=0;i<componentTypes.length;i++)
		{
			EgName egNameObj = (EgName)serverList.get(i);
			String componentType = egNameObj.getActualName();
			String defaultTests[] = specsInfo.getDefaultTestsForServer(componentType);
			if(defaultTests == null || defaultTests.length==0)
				continue;
			ArrayList allTests=new ArrayList();
			allTests.addAll(Arrays.asList(defaultTests));
			if(!allTests.containsAll(associatedTests))
				continue;
			ArrayList allLayers = tablesInfo.getLayersForComponent(componentType);
			if(allLayers == null || !allLayers.contains(selectedLayer))
				continue;

			if(!filterCompTypes.contains(componentType))
			{
				JSONObject compTypeObj = new JSONObject();
				compTypeObj.put("displayField",egNameObj.getLocalName());
				compTypeObj.put("valueField",componentType);
				availableComponentsJsonArray.add(compTypeObj);
				availableComponentsFound=true;
				compTypeCount++;
			}
		}
	}
	rootJson.put("availableComponents",availableComponentsJsonArray);
	rootJson.put("associatedComponents",associatedComponentsJsonArray);
	rootJson.put("associatedComponentsFound",associatedComponentsFound);
	rootJson.put("availableComponentsFound",availableComponentsFound);

	rootJson.put("multipleCompTypesAreAssociated",(alreadyAsociatedCompTypes.size()>1)?true:false);
	rootJson.put("defaultCompType",compType);

	JSONArray weightageTypes = new JSONArray();
	JSONObject wobj = new JSONObject();
	wobj.put("displayField",_mapping.getTextDescription("admin.ic.System Defined"));
	wobj.put("valueField","SystemDefined");
	weightageTypes.add(wobj);
	wobj.put("displayField",_mapping.getTextDescription("admin.ic.Custom Defined"));
	wobj.put("valueField","CustomDefined");
	weightageTypes.add(wobj);
	rootJson.put("weightageTypes",weightageTypes);

	rootJson.put("selectedLayer",selectedLayer);
	rootJson.put("descriptorBasedTest",descriptorBasedTest);
	rootJson.put("selectedWeightageType",selectedWeightageType);
	rootJson.put("keyNormal",keyNormal);
	rootJson.put("keyMinor",keyMinor);
	rootJson.put("keyMajor",keyMajor);
	rootJson.put("keyCritical",keyCritical);
	rootJson.put("supportNormal",supportNormal);
	rootJson.put("supportMinor",supportMinor);
	rootJson.put("supportMajor",supportMajor);
	rootJson.put("supportCritical",supportCritical);


	// below code is to check if this operation is for modify or update test
	boolean showModifyTestAlert = false;
	boolean isModifyOperationNow = false;
	if(compTestDetails.containsKey("modifyTest"))
	{
		isModifyOperationNow = true;
		String modifyTestStr = (String)compTestDetails.get("modifyTest");
		boolean isOldTest = (modifyTestStr != null && modifyTestStr.trim().equalsIgnoreCase("true"));
		if(isOldTest)
		{
			Hashtable compTestDetailsPrevious = null;
			Object obj_old = session.getAttribute("compTestDetailsForAuditLog");
			if(obj_old != null)
			{
				compTestDetailsPrevious = (Hashtable)obj_old;
			}
			if(compTestDetailsPrevious != null && !compTestDetailsPrevious.isEmpty())
			{
				String descriptorBasedTest_previous = null;
				if(compTestDetailsPrevious.containsKey("descriptorBasedTest"))
					descriptorBasedTest_previous = (String)compTestDetailsPrevious.get("descriptorBasedTest");
				descriptorBasedTest_previous = descriptorBasedTest_previous.equalsIgnoreCase("true")?"Yes":"No";
				String descriptorBasedTest_current = (String)compTestDetails.get("descriptorBasedTest");
				descriptorBasedTest_current=descriptorBasedTest_current.equalsIgnoreCase("true")?"Yes":"No";
				if(!descriptorBasedTest_previous.equals(descriptorBasedTest_current))
				{
					showModifyTestAlert=true;
				}

				Vector compMeasures_current = (Vector)compTestDetails.get("MEASURE_NAMES");
				Vector compMeasures_previous = (Vector)compTestDetailsPrevious.get("MEASURE_NAMES");
				Collections.sort(compMeasures_current,String.CASE_INSENSITIVE_ORDER);
				Collections.sort(compMeasures_previous,String.CASE_INSENSITIVE_ORDER);

				if(compMeasures_current.size() != compMeasures_previous.size())
				{
					showModifyTestAlert = true;
				}
				else if(!compMeasures_current.containsAll(compMeasures_previous))
				{
					showModifyTestAlert = true;
				}
				for(int i=0;i<compMeasures_previous.size();i++)
				{
					String comp_measure = (String)compMeasures_previous.get(i);
				}
				for(int i=0;i<compMeasures_current.size();i++)
				{
					String comp_measure = (String)compMeasures_current.get(i);
				}

				LinkedHashMap testMeasures_previous = (LinkedHashMap)compTestDetailsPrevious.get("TEST_MEASURES");
				LinkedHashMap testMeasures_current = (LinkedHashMap)compTestDetails.get("TEST_MEASURES");
				ArrayList measureList = new ArrayList();
				measureList.addAll(testMeasures_current.keySet());
				Collections.sort(measureList,String.CASE_INSENSITIVE_ORDER);
				Iterator itr = measureList.iterator();
				while(itr.hasNext())
				{
					ArrayList testMeasuresOfCompMeasure_cur = new ArrayList();
					String compMeasure = (String)itr.next();
					String value = (String)testMeasures_current.get(compMeasure);
					StringTokenizer st = new StringTokenizer(value,"|");
					while(st.hasMoreTokens())
					{
						StringTokenizer st1 = new StringTokenizer(st.nextToken(),",");
						while(st1.hasMoreTokens())
						{
							String t = st1.nextToken();
							t = t.substring(0,t.indexOf("~"));
							testMeasuresOfCompMeasure_cur.add(t);
						}
					}
					if(testMeasures_previous != null && testMeasures_previous.containsKey(compMeasure))
					{
						ArrayList testMeasuresOfCompMeasure_pre = new ArrayList();
						String value_p = (String)testMeasures_previous.get(compMeasure);
						StringTokenizer st_p = new StringTokenizer(value_p,"|");
						while(st_p.hasMoreTokens())
						{
							StringTokenizer st_pr = new StringTokenizer(st_p.nextToken(),",");
							while(st_pr.hasMoreTokens())
							{
								String t = st_pr.nextToken();
								t = t.substring(0,t.indexOf("~"));
								testMeasuresOfCompMeasure_pre.add(t);
							}
						}
						if(testMeasuresOfCompMeasure_cur.size() != testMeasuresOfCompMeasure_pre.size())
						{
							showModifyTestAlert=true;
							break;
						}
						else if(!testMeasuresOfCompMeasure_cur.containsAll(testMeasuresOfCompMeasure_pre))
						{
							showModifyTestAlert=true;
							break;
						}
					}
					else
					{
						showModifyTestAlert=true;
						break;
					}
				}
				Hashtable inc_ht_pre = new Hashtable();
				if(compTestDetailsPrevious.containsKey("INCLUDE_DESCRIPTORS"))
				{
					Hashtable compTestMeasureInfo = (Hashtable)compTestDetailsPrevious.get("INCLUDE_DESCRIPTORS");
					Iterator itr1 = compTestMeasureInfo.keySet().iterator();
					while(itr1.hasNext())
					{
						String ctm = (String)itr1.next();
						Hashtable ht = (Hashtable)compTestMeasureInfo.get(ctm);
						Iterator itr2 = ht.keySet().iterator();
						while(itr2.hasNext())
						{
							String it = (String)itr2.next();
							ArrayList al = (ArrayList)ht.get(it);
							for(int i=al.size()-1;i>=0;i--)
							{
								String d = (String)al.get(i);
								if(d.trim().length()==0 || d.trim().equalsIgnoreCase("all"))
								{
									al.remove(i);
								}
							}
							if(!al.isEmpty())
							{
								if(inc_ht_pre.containsKey(ctm))
								{
									Hashtable ht_inner = (Hashtable)inc_ht_pre.get(ctm);
									ht_inner.put(it,al);
								}
								else
								{
									Hashtable ht_inner = new Hashtable();
									ht_inner.put(it,al);
									inc_ht_pre.put(ctm,ht_inner);
								}
							}
						}
					}
				}
				Hashtable inc_ht_cur = new Hashtable();
				if(compTestDetails.containsKey("INCLUDE_DESCRIPTORS"))
				{
					Hashtable compTestMeasureInfo = (Hashtable)compTestDetails.get("INCLUDE_DESCRIPTORS");
					Iterator itr1 = compTestMeasureInfo.keySet().iterator();
					while(itr1.hasNext())
					{
						String ctm = (String)itr1.next();
						Hashtable ht = (Hashtable)compTestMeasureInfo.get(ctm);
						Iterator itr2 = ht.keySet().iterator();
						while(itr2.hasNext())
						{
							String it = (String)itr2.next();
							ArrayList al = (ArrayList)ht.get(it);
							for(int i=al.size()-1;i>=0;i--)
							{
								String d = (String)al.get(i);
								if(d.trim().length()==0 || d.trim().equalsIgnoreCase("all"))
								{
									al.remove(i);
								}
							}
							if(!al.isEmpty())
							{
								if(inc_ht_cur.containsKey(ctm))
								{
									Hashtable ht_inner = (Hashtable)inc_ht_cur.get(ctm);
									ht_inner.put(it,al);
								}
								else
								{
									Hashtable ht_inner = new Hashtable();
									ht_inner.put(it,al);
									inc_ht_cur.put(ctm,ht_inner);
								}
							}
						}
					}
				}
				Hashtable exc_ht_pre = new Hashtable();
				if(compTestDetailsPrevious.containsKey("EXCLUDE_DESCRIPTORS"))
				{
					Hashtable compTestMeasureInfo = (Hashtable)compTestDetailsPrevious.get("EXCLUDE_DESCRIPTORS");
					Iterator itr1 = compTestMeasureInfo.keySet().iterator();
					while(itr1.hasNext())
					{
						String ctm = (String)itr1.next();
						Hashtable ht = (Hashtable)compTestMeasureInfo.get(ctm);
						Iterator itr2 = ht.keySet().iterator();
						while(itr2.hasNext())
						{
							String it = (String)itr2.next();
							ArrayList al = (ArrayList)ht.get(it);
							for(int i=al.size()-1;i>=0;i--)
							{
								String d = (String)al.get(i);
								if(d.trim().length()==0 || d.trim().equalsIgnoreCase("none"))
								{
									al.remove(i);
								}
							}
							if(!al.isEmpty())
							{
								if(exc_ht_pre.containsKey(ctm))
								{
									Hashtable ht_inner = (Hashtable)exc_ht_pre.get(ctm);
									ht_inner.put(it,al);
								}
								else
								{
									Hashtable ht_inner = new Hashtable();
									ht_inner.put(it,al);
									exc_ht_pre.put(ctm,ht_inner);
								}
							}
						}
					}
				}
				Hashtable exc_ht_cur = new Hashtable();
				if(compTestDetails.containsKey("EXCLUDE_DESCRIPTORS"))
				{
					Hashtable compTestMeasureInfo = (Hashtable)compTestDetails.get("EXCLUDE_DESCRIPTORS");
					Iterator itr1 = compTestMeasureInfo.keySet().iterator();
					while(itr1.hasNext())
					{
						String ctm = (String)itr1.next();
						Hashtable ht = (Hashtable)compTestMeasureInfo.get(ctm);
						Iterator itr2 = ht.keySet().iterator();
						while(itr2.hasNext())
						{
							String it = (String)itr2.next();
							ArrayList al = (ArrayList)ht.get(it);
							for(int i=al.size()-1;i>=0;i--)
							{
								String d = (String)al.get(i);
								if(d.trim().length()==0 || d.trim().equalsIgnoreCase("none"))
								{
									al.remove(i);
								}
							}
							if(!al.isEmpty())
							{
								if(exc_ht_cur.containsKey(ctm))
								{
									Hashtable ht_inner = (Hashtable)exc_ht_cur.get(ctm);
									ht_inner.put(it,al);
								}
								else
								{
									Hashtable ht_inner = new Hashtable();
									ht_inner.put(it,al);
									exc_ht_cur.put(ctm,ht_inner);
								}
							}
						}
					}
				}
				
				//look out for include descriptor changes
				if(inc_ht_cur.size() != inc_ht_pre.size())
				{
					showModifyTestAlert = true;
				}
				else if(!inc_ht_cur.keySet().containsAll(inc_ht_pre.keySet()))
				{
					showModifyTestAlert = true;
				}
				else
				{
					Iterator compMeasureItr = inc_ht_cur.keySet().iterator();
					while(compMeasureItr.hasNext())
					{
						String compM = (String)compMeasureItr.next();
						Hashtable htc = (Hashtable)inc_ht_cur.get(compM);
						Hashtable htp = (Hashtable)inc_ht_pre.get(compM);
						if(htc.size() != htp.size())
						{
							showModifyTestAlert = true;
							break;
						}
						else if(!htc.keySet().containsAll(htp.keySet()))
						{
							showModifyTestAlert = true;
							break;
						}
						else
						{
							Iterator htcItr = htc.keySet().iterator();
							while(htcItr.hasNext())
							{
								String test = (String)htcItr.next();
								ArrayList alc = (ArrayList)htc.get(test);
								ArrayList alp = (ArrayList)htp.get(test);
								if(alc.size() != alp.size())
								{
									showModifyTestAlert = true;
									break;
								}
								else if(!alc.containsAll(alp))
								{
									showModifyTestAlert = true;
									break;
								}
							}
						}
					}
				}

				//look out for exclude descriptor changes
				if(exc_ht_cur.size() != exc_ht_pre.size())
				{
					showModifyTestAlert = true;
				}
				else if(!exc_ht_cur.keySet().containsAll(exc_ht_pre.keySet()))
				{
					showModifyTestAlert = true;
				}
				else
				{
					Iterator compMeasureItr = exc_ht_cur.keySet().iterator();
					while(compMeasureItr.hasNext())
					{
						String compM = (String)compMeasureItr.next();
						Hashtable htc = (Hashtable)exc_ht_cur.get(compM);
						Hashtable htp = (Hashtable)exc_ht_pre.get(compM);
						if(htc.size() != htp.size())
						{
							showModifyTestAlert = true;
							break;
						}
						else if(!htc.keySet().containsAll(htp.keySet()))
						{
							showModifyTestAlert = true;
							break;
						}
						else
						{
							Iterator htcItr = htc.keySet().iterator();
							while(htcItr.hasNext())
							{
								String test = (String)htcItr.next();
								ArrayList alc = (ArrayList)htc.get(test);
								ArrayList alp = (ArrayList)htp.get(test);
								if(alc.size() != alp.size())
								{
									showModifyTestAlert = true;
									break;
								}
								else if(!alc.containsAll(alp))
								{
									showModifyTestAlert = true;
									break;
								}
							}
						}
					}
				}
			}
		}
	}
	rootJson.put("showshowModifyTestAlert",showModifyTestAlert);
	rootJson.put("isModifyOperationNow",isModifyOperationNow);
	out.println(rootJson);
%>

