<%@ include file="../../../admin/EgTrackerAJSON.jsp"%>
<%@ page import="com.eg.EgURLDecoder"%>
<%@ page import="com.egurkha.util.StringUtils"%>
<%@ page import="com.eg.EgCompositeInfo"%>
<%@ page import="com.egurkha.admin.AuditLogThread"%>
<%@ page import="net.sf.json.JSONObject"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json;charset=UTF-8");

	JSONObject rootJson = new JSONObject();
	rootJson.put("success","true");

	String add = request.getParameter("add");

	if(add.equals("test"))
	{
		String configDir = EgInstallInfo.getInstallDir()+"/manager/config/";
		EgCompositeInfo compInfo = new EgCompositeInfo("manager");

		String operation = request.getParameter("operation");
		boolean addCompTest = operation != null && operation.equalsIgnoreCase("addTest");
		String compTest = request.getParameter("test");
		String display_name = request.getParameter("display_name");
		if(display_name != null && (display_name=display_name.trim()).length()>0 && !display_name.equalsIgnoreCase("null"))
		{
			display_name = EgURLDecoder.decode(display_name,"UTF-8");
		}
		String purpose_of_test = request.getParameter("purpose_of_test");
		if(purpose_of_test != null && (purpose_of_test=purpose_of_test.trim()).length()>0 && !purpose_of_test.equalsIgnoreCase("null"))
		{
			purpose_of_test = EgURLDecoder.decode(purpose_of_test,"UTF-8");
		}
		String compType = request.getParameter("compType");
		String descriptorBasedNew = request.getParameter("descriptor_based");
		String selected_master_test = request.getParameter("selected_master_test");
		if(selected_master_test == null || (selected_master_test=selected_master_test.trim()).length()==0 || selected_master_test.equals("-") || selected_master_test.equals("-1") || selected_master_test.equalsIgnoreCase("null"))
		{
			selected_master_test = "-1";
		}
		boolean isNewCompTest=false;
		boolean couldNotBeCreated = false;
		Vector userDefinedTests = compInfo.getUserDefinedTests();
		if(addCompTest)
		{
			int highestIndex = 0;
			if(userDefinedTests != null && !userDefinedTests.isEmpty())
			{
				for(int i=0;i<userDefinedTests.size();i++)
				{
					String t = (String)userDefinedTests.get(i);
					try
					{
						int _idx = t.indexOf("_");
						int l_idx = t.lastIndexOf("_");
						if(_idx>0 && _idx != l_idx)
						{
							int idx = Integer.parseInt(t.substring(_idx+1,l_idx));
							if(highestIndex<idx)
							{
								highestIndex=idx;
							}
						}
					}
					catch(Exception e)
					{
						couldNotBeCreated = true;
						e.printStackTrace();
					}
				}
			}
			int newTestIndex = highestIndex + 1;
			isNewCompTest=true;
			compTest = "CompTest_"+(newTestIndex)+"_rx";
			rootJson.put("newCompTestName",compTest);
		}
		if(isNewCompTest && couldNotBeCreated)
		{
			rootJson.put("AlertType","COULD_NOT_CREATE_TEST");
			rootJson.put("AlertTitle",_mapping.getTextDescription("admin.error.Could not create test"));
			String msg = _mapping.getTextDescription("admin.error.Existing performance rating tests have not been built properly")+". <br>";
			msg += _mapping.getTextDescription("admin.error.Please look at the ini entries")+".";
			rootJson.put("AlertMsg",msg);
		}
		userDefinedTests = compInfo.getUserDefinedTests();
		if(addCompTest && userDefinedTests != null && userDefinedTests.contains(compTest))
		{
			rootJson.put("AlertType","Error");
			rootJson.put("AlertTitle",_mapping.getTextDescription("admin.error.Add a Test"));
			String msg = _mapping.getTextDescription("admin.error.You are trying to add a test which already exists")+". <br>";
			msg += _mapping.getTextDescription("admin.error.Please enter a unique test name")+".";
			rootJson.put("AlertMsg",msg);
		}
		else
		{
			if(display_name != null)
				display_name = display_name.trim();
			String s_testname = null;
			boolean dispNameExists = false;
			IniFile langFile = new IniFile(configDir+"eg_lang_en_US.ini");
			Vector testname = langFile.getVariables("TEST_NAME_MAPPING",true);
			Vector testnamemapping = langFile.getAllValues("TEST_NAME_MAPPING");
			if(testname != null && testnamemapping != null)
			{
				for(int i=0;i<testname.size();i++)
				{
					String s_testnamemapping = (String)testnamemapping.get(i);
					if(s_testnamemapping.equalsIgnoreCase(display_name))
					{
						s_testname = (String)testname.get(i);
						dispNameExists = true;
						break;
					}
				}
			}
			if(!dispNameExists)
			{
				String aggLangFileName = EgInstallInfo.getInstallDir()+"/manager/config/eg_aggregate_lang_en_US.ini";
				IniFile aggLangIni = new IniFile(aggLangFileName);
				Vector aggtestname = aggLangIni.getVariables("TEST_NAME_MAPPING",true);
				Vector aggtestnamemapping = aggLangIni.getAllValues("TEST_NAME_MAPPING");
				if(aggtestname != null && aggtestnamemapping != null)
				{
					for(int i=0;i<aggtestname.size();i++)
					{
						String s_aggtestnamemapping = (String)aggtestnamemapping.get(i);
						if(s_aggtestnamemapping.equalsIgnoreCase(display_name))
						{
							s_testname = (String)aggtestname.get(i);
							dispNameExists = true;
							break;
						}
					}
				}
			}
			boolean compDisplayFailed=false;
			if(!dispNameExists)
			{
				String compLangFileName = EgInstallInfo.getInstallDir()+"/manager/config/eg_composite_lang_en_US.ini";
				IniFile compLangIni = new IniFile(compLangFileName);
				Vector comptestname = compLangIni.getVariables("TEST_NAME_MAPPING",true);
				Vector comptestnamemapping = compLangIni.getAllValues("TEST_NAME_MAPPING");
				if(comptestname != null && comptestnamemapping != null)
				{
					if(addCompTest)
					{
						for(int i=0;i<comptestname.size();i++)
						{
							String s_comptestnamemapping = (String)comptestnamemapping.get(i);
							if(s_comptestnamemapping.equalsIgnoreCase(display_name))
							{
								s_testname = (String)comptestname.get(i);
								dispNameExists = true;
								compDisplayFailed=true;
								break;
							}
						}
					}
					else
					{
						for(int i=0;i<comptestname.size();i++)
						{
							String s_comptestnamemapping = (String)comptestnamemapping.get(i);
							if(s_comptestnamemapping.equalsIgnoreCase(display_name))
							{
								s_testname = (String)comptestname.get(i);
								if(!s_testname.equalsIgnoreCase(compTest))
								{
									dispNameExists = true;
									compDisplayFailed=true;
									break;
								}
							}
						}
					}
				}
			}

			if(dispNameExists)
			{
				rootJson.put("AlertType","Error");
				if(addCompTest)
				{
					String msg=null;
					rootJson.put("AlertTitle",_mapping.getTextDescription("admin.error.Add Test"));
					if(compDisplayFailed)
					{
						msg = _mapping.getTextDescription("admin.error.You are trying to add a test name which is already assigned to another performance rating test")+".<br>";
					}
					else
					{
						msg = _mapping.getTextDescription("admin.error.You are trying to add a test name which is already assigned to test")+" " + _mapping.getTestDescription(s_testname)+". <br>";
					}
					msg += _mapping.getTextDescription("admin.error.Please enter a unique test name")+".";
					rootJson.put("AlertMsg",msg);
				}
				else
				{
					rootJson.put("AlertTitle",_mapping.getTextDescription("admin.error.Modify Test"));
					String msg = _mapping.getTextDescription("admin.error.You are trying to modify a test name which is already assigned to test")+" " + _mapping.getTestDescription(s_testname)+". <br>";
					msg += _mapping.getTextDescription("admin.error.Please enter a unique test name")+".";
					rootJson.put("AlertMsg",msg);
				}
			}
			else
			{
				if(addCompTest)
				{
					Hashtable compTestDetails = new Hashtable();
					compTestDetails.put("operation", operation);
					compTestDetails.put("compTest", compTest);
					compTestDetails.put("testDescription", display_name);
					compTestDetails.put("compType", compType);
					compTestDetails.put("purpose_of_test", purpose_of_test);
					compTestDetails.put("descriptorBasedTest", descriptorBasedNew);
					compTestDetails.put("masterInfosTest", selected_master_test);
					session.removeAttribute("compTestDetails");
					session.removeAttribute("compTestDetailsForAuditLog");
					session.setAttribute("compTestDetails",compTestDetails);
					session.setAttribute("compTestDetailsForAuditLog",compTestDetails.clone());
				}
				else
				{
					AuditLogThread auditLogThread = new AuditLogThread();
					auditLogThread.setValue("Category","Admin");
					auditLogThread.setValue("User_id",_user.getLoginID());
					auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
					auditLogThread.setValue("Session_id",session.getId());
					auditLogThread.setValue("Module","Performance Rating Test");
					auditLogThread.setValue("Activity","Configure Test");

					Hashtable compTestDetails = (Hashtable)session.getAttribute("compTestDetails");
					compTestDetails.put("testDescription", display_name);
					compTestDetails.put("purpose_of_test", purpose_of_test);
					compTestDetails.put("descriptorBasedTest", descriptorBasedNew);
					compTestDetails.put("masterInfosTest", selected_master_test);
					if(compType != null && compType.trim().length()>0)
					{
						compTestDetails.put("compType", compType);
					}
					session.setAttribute("compTestDetails",compTestDetails);
					IniFile complang = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir()+"/manager/config/eg_composite_lang_en_US.ini");
					String display_name_pre = complang.getValue("TEST_NAME_MAPPING",compTest);
					String purpose_of_test_pre = complang.getValue("PURPOSE_OF_TEST",compTest);
					complang.setValue("TEST_NAME_MAPPING",compTest,display_name);
					complang.setValue("TEXT_NAME_MAPPING","admin.composite."+compTest,display_name);
					StringTokenizer st = new StringTokenizer(purpose_of_test,"\n");
					String finalStr = "";
					while(st.hasMoreTokens())
					{
						finalStr += "~egline~" + st.nextToken();
					}
					if(finalStr.length()>8)
					{
						finalStr = finalStr.substring(8);
					}
					complang.setValue("PURPOSE_OF_TEST",compTest,finalStr);

					complang.saveFile();
					EgConfigFilesSync.releaseInstance(complang);

					auditLogThread.setPreviousValue("01~~Test name",display_name_pre);
					auditLogThread.setCurrentValue("01~~Test name", display_name);

					auditLogThread.setPreviousValue("02~~Test description", StringUtils.replace(purpose_of_test_pre,"~egline~"," "));
					auditLogThread.setCurrentValue("02~~Test description", purpose_of_test);

					auditLogThread.setValue("Description","Test description has been modified successfully for $test$:"+compTest);
					auditLogThread.sendItToDB();
				}
				rootJson.put("testDescription",display_name);
				rootJson.put("purpose_of_test",purpose_of_test);
				rootJson.put("descriptorBasedTest",descriptorBasedNew);
				rootJson.put("selectedMasterInfosTest",selected_master_test);

				rootJson.put("AlertType","Result");
				if(addCompTest)
				{
					rootJson.put("isNewTestEntry",true);
					rootJson.put("AlertTitle",_mapping.getTextDescription("admin.title.ADD TEST"));
					String forwardURL = "EgAddUDTestJson.jsp?added=done&test=" + compTest;
					rootJson.put("forwardPage",true);
					rootJson.put("forwardURL",forwardURL);
					rootJson.put("AlertMsg",_mapping.getTextDescription("admin.ic.Test has been added successfully")+".");
				}
				else
				{
					rootJson.put("isNewTestEntry",false);
					rootJson.put("AlertTitle",_mapping.getTextDescription("admin.title.UPDATE TEST"));
					rootJson.put("AlertMsg",_mapping.getTextDescription("admin.ic.Test has been updated successfully")+".");
				}
			}
		}
	}
	out.println(rootJson);
%>






