<%@ include file="../../../admin/EgTrackerAJSON.jsp"%>
<%@ page import="com.egurkha.util.StringUtils"%>
<%@ page import="com.eg.EgCompositeInfo"%>
<%@ page import="net.sf.json.JSONObject"%>
<%@ page import="net.sf.json.JSONArray "%>
<%@ page import="com.eg.MappingNameSorter"%>
<%@ page import="com.eg.EgName"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json;charset=UTF-8");

	session.removeAttribute("compTestDetails");
	session.removeAttribute("compTestDetailsForAuditLog");

	JSONObject rootJSON = new JSONObject();
	rootJSON.put("success","true");
	
	String egTitleSearchStr = request.getParameter("searchStr");
	boolean isSearchResult =(egTitleSearchStr!=null && !egTitleSearchStr.trim().equals(""));
	ArrayList searchList = new ArrayList();
	if (isSearchResult)
	{
		StringTokenizer st = new StringTokenizer(egTitleSearchStr);
		while (st.hasMoreTokens())
		{
			String thisToken = st.nextToken().trim();
			if (thisToken.equals(""))
				continue;
			searchList.add(thisToken);
		}
	}
	EgCompositeInfo compInfo = new EgCompositeInfo("manager");

	String keyNormal = "1";
	String keyMinor = "None";
	String keyMajor = "None";
	String keyCritical = "0";
	String supportNormal = "1";
	String supportMinor = "None";
	String supportMajor = "None";
	String supportCritical = "0";
	try
	{
		String default_weightage = compInfo.getValue("DEFAULT_WEIGHTAGE","DEFAULT");
		if(default_weightage != null && !default_weightage.trim().equalsIgnoreCase("1:none:none:0"))
		{
			StringTokenizer st = new StringTokenizer(default_weightage.trim(),":");
			if(st.countTokens()==4)
			{
				keyNormal = st.nextToken();
				keyMinor = st.nextToken();
				keyMajor = st.nextToken();
				keyCritical = st.nextToken();
			}
		}
		supportNormal = keyNormal;
		supportMinor = keyMinor;
		supportMajor = keyMajor;
		supportCritical = keyCritical;
	}
	catch(Exception e)
	{
		e.printStackTrace();
	}
	finally
	{
		rootJSON.put("keyNormal",keyNormal);
		rootJSON.put("keyMinor",keyMinor);
		rootJSON.put("keyMajor",keyMajor);
		rootJSON.put("keyCritical",keyCritical);

		rootJSON.put("supportNormal",supportNormal);
		rootJSON.put("supportMinor",supportMinor);
		rootJSON.put("supportMajor",supportMajor);
		rootJSON.put("supportCritical",supportCritical);
	}

	Vector allCompTests = compInfo.getUserDefinedTests();
	ArrayList tests = new ArrayList();
	String userCompTypes[] = com.eg.EgRoleInfo.getInstance(session.getId(),_user.getLoginID()).getServerTypes();
	if(userCompTypes != null)
	{
		EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
		for(int i=0;i<allCompTests.size();i++)
		{
			String compTest=(String)allCompTests.get(i);
			for(int j=0;j<userCompTypes.length;j++)
			{
				String compType=(String)userCompTypes[j];
				if(specsInfo.isTestRelevantForServer(compType, compTest,true))
				{
					if(!tests.contains(compTest))
					{
						tests.add(compTest);
					}
				}
			}
		}
	}

	if(tests == null || tests.size() == 0)
	{
		rootJSON.put("noUDTestsFound",true);
	}
	else
	{
		IniFile compLangIni = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_composite_lang_en_US.ini");
		rootJSON.put("noUDTestsFound",false);
		boolean searchItemFound = false;
		JSONArray testList = new JSONArray();
		JSONObject obj = new JSONObject();

		MappingNameSorter sorter = new MappingNameSorter(trackerLanguage);
		tests = sorter.getSortedTestList(tests);
		for(int i=0; i<tests.size(); i++)
		{
			EgName egName=(EgName)tests.get(i);
			String test=egName.getActualName();
			String dispTestName=egName.getLocalName();

			String componentType = compInfo.getComponentTypeForTest(test);
			String dispCompType = _mapping.getComponentTypeDescription(componentType);
			String descriptorBasedTest = compInfo.isDescriptorBasedTest(test)?"Yes":"No";
			String layerName = compInfo.getLayerForTest(test);
			String dispLayerName = _mapping.getLayerDescription(layerName);

			String purpose_of_test = compLangIni.getValue("PURPOSE_OF_TEST",test);
			if(StringUtils.isNull(purpose_of_test))
			{
				purpose_of_test = test;
			}
			String newLineAdded = StringUtils.replace(purpose_of_test,"~egline~","\n");

			if (isSearchResult && !doesExist(searchList,dispTestName,dispCompType,dispLayerName,newLineAdded,descriptorBasedTest))
			{
				continue;
			}
			searchItemFound=true;
			obj.put("test",test);
			obj.put("displayName",dispTestName);
			obj.put("purpose_of_test",newLineAdded);
			obj.put("desc_based_test",descriptorBasedTest);
			obj.put("compType",componentType);
			obj.put("dispCompType",dispCompType);
			obj.put("layerName",dispLayerName);
			testList.add(obj);
		}
		rootJSON.put("testsList",testList);
		if (!searchItemFound && egTitleSearchStr!=null && !egTitleSearchStr.equals(""))
		{
			rootJSON.put("noSrchItemFound",true);
		}
	}
	out.println(rootJSON);
%>
			
<%!
	private boolean doesExist(List searchList, String testDesc, String comptypeDesc, String layerDesc, String newLineAdded,String descriptorBasedTest)
	{
		Iterator i = searchList.iterator();
		while(i.hasNext())
		{
			String nextStr = (String) i.next();
			if(testDesc.indexOf(nextStr)!=-1 || (testDesc.toUpperCase().indexOf(nextStr.toUpperCase()))!=-1 || comptypeDesc.indexOf(nextStr)!=-1 || (comptypeDesc.toUpperCase().indexOf(nextStr.toUpperCase()))!=-1 || layerDesc.indexOf(nextStr)!=-1 || (layerDesc.toUpperCase().indexOf(nextStr.toUpperCase()))!=-1 || newLineAdded.indexOf(nextStr)!=-1 || (newLineAdded.toUpperCase().indexOf(nextStr.toUpperCase()))!=-1 || descriptorBasedTest.indexOf(nextStr)!=-1 || (descriptorBasedTest.toUpperCase().indexOf(nextStr.toUpperCase()))!=-1)
			{
				return true;
			}
		}
		return false;
	}
%>
<%	
	session.setAttribute("adminLastAccessedURL","/final/admin/compositeTest.jsp?"+request.getQueryString());
%>




