<%
/*
 *	Name			:	EgchangeippJson.jsp
 *	Purpose			:	Process page for the EgChangeIP.jsp.
 *	CreationDate	:	06/06/08
 */
%>
<%@ include file="../../../admin/EgTrackerAJSON.jsp"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%@ page import = "com.eg.AgentConfig"%>
<%@ page import = "com.eg.EgSpecsInfo"%>
<%@ page import = "com.eg.EgServicesInfo" %>
<%@ page import = "com.eg.UpdateIP"%>
<%@ page import = "com.eg.UnmanagedAgentsInfo" %>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>

<%@ page import = "java.util.List"%>
<%@ page import = "java.util.ArrayList"%>
<%@ page import = "java.util.StringTokenizer"%>
<%@ page import = "java.util.Collections"%>

<%@ page import="net.sf.json.JSONObject"%>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json;charset=UTF-8");
%>

<%
	JSONObject rootJSON = new JSONObject();
	rootJSON.put("success","true");

	String hostIP = request.getParameter("hostip");
	String hostName = request.getParameter("hostname");
	String port = request.getParameter("port");
	String newHostIP = request.getParameter("newhostip");
	String serverType = request.getParameter("servertype");
	String hostList = request.getParameter("hostlist");
	hostIP = (hostIP != null)?hostIP:"";
	hostName = (hostName != null)?hostName:"";
	newHostIP = (newHostIP != null)?newHostIP:"";
	serverType = (serverType != null)?serverType:"";
	hostList = (hostList != null)?hostList:"";
	AgentConfig agentConfig = AgentConfig.getAgentConfig();

	EgServicesInfo servicesInfo = new EgServicesInfo("manager");
	boolean isAllowHostName = servicesInfo.isAllowHostNames();
	rootJSON.put("serverType",serverType);

	/********Audit Log*******/
	AuditLogThread auditLogThread = new AuditLogThread();
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",_user.getLoginID());
	auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
	auditLogThread.setValue("Session_id",session.getId());
	auditLogThread.setValue("Module","Add/Modify Servers");
	auditLogThread.setValue("Activity","Modify Component");
	if(isAllowHostName)
	{
		auditLogThread.setCurrentValue("01~~Old host IP/Name", hostIP);
		auditLogThread.setCurrentValue("02~~New host IP/Name", newHostIP);
		auditLogThread.setValue("Description","Host IP/Name has been modified");
	}
	else
	{
		auditLogThread.setCurrentValue("01~~Old host IP", hostIP);
		auditLogThread.setCurrentValue("02~~New host IP", newHostIP);
		auditLogThread.setValue("Description","Host IP has been modified");
	}
	
	boolean statusFlag = true;
	String hostNames = hostName;
	String modexternalHosts = "";
	String modremoteHosts = "";
	if (hostList.length() > 0)
	{
		hostNames += ":"+hostList;
	}
	UpdateIP updateIP = new UpdateIP();
	
	// eg_discover.ini and eg_agents.ini are to be modified for IP changes
	statusFlag = updateIP.changeHostIP(hostNames,hostIP,newHostIP);
	
	hostNames = updateIP.getModifiedComponents(hostName,serverType);
	modexternalHosts = updateIP.getModifiedExternalHosts();
	modremoteHosts = updateIP.getModifiedRemoteHosts();
	Vector sess_vec = new Vector();
	String url = "";
	List resultList = new ArrayList();
	StringTokenizer stt = new StringTokenizer(hostNames,":");
	while(stt.hasMoreTokens())
	{
		String tmpHost = stt.nextToken();
		int idx = tmpHost.indexOf("|");
		if (idx > 0)
		{
			String modCompTypes = tmpHost.substring(idx+1);
			if(modCompTypes.indexOf(",") > 0)
			{
				StringTokenizer strToken = new StringTokenizer(modCompTypes,",");
				while(strToken.hasMoreTokens())
				{
					resultList.add(tmpHost.substring(0,idx)+" ("+_mapping.getComponentTypeDescription(strToken.nextToken())+")");
				}
			}
			else
			{
				resultList.add(tmpHost.substring(0,idx)+" ("+_mapping.getComponentTypeDescription(modCompTypes)+")");
			}
		}
		else
		{
			resultList.add(tmpHost+" ("+_mapping.getComponentTypeDescription(serverType)+")");
		}
	}
	Collections.sort(resultList);
	/*****Audit Log*********/
	if (resultList.size()>0)
	{		
		for(int i=0;i<resultList.size();i++)
		{
			auditLogThread.setCurrentValue("03~~Modified host(s)", (String)resultList.get(i));
		}
	
	}
	/*********************/

	String sessResult = resultList.toString();
	sessResult = sessResult.substring(1,sessResult.length() -1);

	boolean allExternalTests = true;
	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
	String[] testsForServer = specsInfo.getTestsForServer(serverType);
	if (testsForServer != null)
	{
		for (int a=0; a<testsForServer.length; a++)
		{
			if (!specsInfo.isTestExternal(testsForServer[a]))
			{
				allExternalTests = false;
				break;
			}
		}
	}

	if (statusFlag)
	{
		//Vmware Vcenter eg_services.ini entries
		IniFile externalWrite = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_services.ini");
		ArrayList extIniEntries = new ArrayList();
		String Ssl = "True";
		String uName = "$unconfigured";
		String uPass = "$unconfigured";
		String isDiscovery = "No";
		String webPort = "443";
		String domainVal = "internal";
		String pSeriesHostName = "$unconfigured";

		if (!com.egurkha.util.StringUtils.isNull(serverType) && serverType.equals("Virtual_center"))
		{
			ArrayList vCValList = new ArrayList();
			String vCVal = externalWrite.getValue("VIRTUAL_CENTER",hostIP);
			StringTokenizer stTok = new StringTokenizer(vCVal,"#");
			while (stTok.hasMoreTokens())
			{
				vCValList.add(stTok.nextToken());
			}
			if (vCValList.size() > 0 && !vCValList.contains("$unconfigured"))
			{
				String SslMod = (String)vCValList.get(0);
				String uNameMod = (String)vCValList.get(1);
				String uPassMod = (String)vCValList.get(2);
				String isDiscoveryMod = (String)vCValList.get(3);
				String webPortMod = (String)vCValList.get(4);
				String domainMod = (String)vCValList.get(4);

				extIniEntries.add(new IniHelper(IniHelper.DELETE,"VIRTUAL_CENTER", hostIP, Ssl+"#"+uName+"#"+uPass+"#"+isDiscovery+"#"+webPort));
				extIniEntries.add(new IniHelper(IniHelper.SET,"VIRTUAL_CENTER", newHostIP, SslMod+"#"+uNameMod+"#"+uPassMod+"#"+isDiscoveryMod+"#"+webPortMod));
			}
			else
			{
				extIniEntries.add(new IniHelper(IniHelper.DELETE,"VIRTUAL_CENTER", hostIP, Ssl+"#"+uName+"#"+uPass+"#"+isDiscovery+"#"+webPort));
				extIniEntries.add(new IniHelper(IniHelper.SET,"VIRTUAL_CENTER", newHostIP, Ssl+"#"+uName+"#"+uPass+"#"+isDiscovery+"#"+webPort));
			}
		}
		else if (!com.egurkha.util.StringUtils.isNull(serverType) && serverType.equals("Redhat_linux_mgr"))
		{
			ArrayList rhevValList = new ArrayList();
			String rhevVal = externalWrite.getValue("RHEV",hostIP);
			StringTokenizer rhevTok = new StringTokenizer(rhevVal,"#");
			while (rhevTok.hasMoreTokens())
			{
				rhevValList.add(rhevTok.nextToken());
			}
			if (rhevValList.size() > 0 && !rhevValList.contains("$unconfigured"))
			{
				String SslMod = (String)rhevValList.get(0);
				String uNameMod = (String)rhevValList.get(1);
				String uPassMod = (String)rhevValList.get(2);
				String isDiscoveryMod = (String)rhevValList.get(3);
				String webPortMod = (String)rhevValList.get(4);
				String domainMod = (String)rhevValList.get(5);

				extIniEntries.add(new IniHelper(IniHelper.DELETE,"RHEV", hostIP, Ssl+"#"+uName+"#"+uPass+"#"+isDiscovery+"#"+webPort+"#"+domainVal));
				extIniEntries.add(new IniHelper(IniHelper.SET,"RHEV", newHostIP, SslMod+"#"+uNameMod+"#"+uPassMod+"#"+isDiscoveryMod+"#"+webPortMod+"#"+domainMod));
			}
			else
			{
				extIniEntries.add(new IniHelper(IniHelper.DELETE,"RHEV", hostIP, Ssl+"#"+uName+"#"+uPass+"#"+isDiscovery+"#"+webPort+"#"+domainVal));
				extIniEntries.add(new IniHelper(IniHelper.SET,"RHEV", newHostIP, Ssl+"#"+uName+"#"+uPass+"#"+isDiscovery+"#"+webPort+"#"+domainVal));
			}
		}
		else if (!com.egurkha.util.StringUtils.isNull(serverType) && serverType.equals("hmc_server"))
		{
			ArrayList pSeriesValList = new ArrayList();
			String rhevVal = externalWrite.getValue("HMC",hostIP);
			StringTokenizer pserTok = new StringTokenizer(rhevVal,"#");
			while (pserTok.hasMoreTokens())
			{
				pSeriesValList.add(pserTok.nextToken());
			}
			if (pSeriesValList.size() > 0 && !pSeriesValList.contains("$unconfigured"))
			{
				String SslMod = (String)pSeriesValList.get(0);
				String uNameMod = (String)pSeriesValList.get(1);
				String uPassMod = (String)pSeriesValList.get(2);
				String isDiscoveryMod = (String)pSeriesValList.get(3);
				String hostNameMod = (String)pSeriesValList.get(4);

				extIniEntries.add(new IniHelper(IniHelper.DELETE,"HMC", hostIP, Ssl+"#"+uName+"#"+uPass+"#"+isDiscovery+"#"+pSeriesHostName));
				extIniEntries.add(new IniHelper(IniHelper.SET,"HMC", newHostIP, SslMod+"#"+uNameMod+"#"+uPassMod+"#"+isDiscoveryMod+"#"+hostNameMod));
			}
			else
			{
				extIniEntries.add(new IniHelper(IniHelper.DELETE,"HMC", hostIP, Ssl+"#"+uName+"#"+uPass+"#"+isDiscovery+"#"+pSeriesHostName));
				extIniEntries.add(new IniHelper(IniHelper.SET,"HMC", newHostIP, Ssl+"#"+uName+"#"+uPass+"#"+isDiscovery+"#"+pSeriesHostName));
			}
		}
		if (extIniEntries.size() > 0)
		{
			for (int n=0; n<extIniEntries.size(); n++)
			{
				IniHelper iniHelper = (IniHelper)extIniEntries.get(n);
				String iniAction = iniHelper.getAction();
				String subject = iniHelper.getSubject();
				String key = iniHelper.getVariable();
				String value = iniHelper.getValue();
				if(iniAction != null)
				{
					if (iniAction.equals(IniHelper.SET))
					{
						externalWrite.setValue(subject,key,value);
					}
					else if (iniAction.equals(IniHelper.DELETE))
					{
						externalWrite.deleteValue(subject,key);
					}
				}
			}
			externalWrite.saveFile();
			//EgConfigFilesSync.releaseInstance(externalWrite);
		}
		EgConfigFilesSync.releaseInstance(externalWrite);

		agentConfig.removeAgentElement(hostName);
		
		rootJSON.put("AlertType","result");
		rootJSON.put("AlertTitle",_mapping.getTextDescription("admin.server.Modify components"));
		String msg = _mapping.getTextDescription("admin.server.The following component(s) is/are updated with the new host IP")+" "+newHostIP+"<br><b>"+sessResult+"</b>";
		
		if(modexternalHosts!=null && modexternalHosts.length() > 0)
		{
			msg += "<br><br>";
			msg += _mapping.getTextDescription("admin.server.The following external host(s) is/are updated with the new host IP")+" "+newHostIP+"<br><b>"+modexternalHosts+"</b>";
			auditLogThread.setCurrentValue("04~~Modified External agent(s)", modexternalHosts);
		}
		if(modremoteHosts!=null && modremoteHosts.length() > 0)
		{
			msg += "<br><br>";
			msg += _mapping.getTextDescription("admin.server.The following remote host(s) is/are updated with the new host IP")+" "+newHostIP+"<br><b>"+modremoteHosts+"</b>";
			auditLogThread.setCurrentValue("05~~Modified Remote agent(s)", modremoteHosts);
		}
		rootJSON.put("AlertMsg",msg);
		auditLogThread.sendItToDB();
		UnmanagedAgentsInfo uai = new UnmanagedAgentsInfo();
		uai.updateAgentDetail(newHostIP);
	}
	else
	{
		rootJSON.put("AlertType","error");
		rootJSON.put("AlertTitle",_mapping.getTextDescription("admin.server.Modify components"));
		rootJSON.put("AlertMsg",_mapping.getTextDescription("admin.server.Not properly updated with the new host IP")+", "+newHostIP);
	}
	out.println(rootJSON);
%>



