<%
	/*
	 *		Name		:	EgDispServerJson.jsp
	 *		Purpose		:	To view components under a type.
	 *		Navigation	:	Infrastructure > Add / Modify Components
	 */
%>

<%@ include file="../../../admin/EgTrackerAJSON.jsp"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%@ page import="com.eg.EgDiscInfo"%>
<%@ page import="com.eg.EgSpecsInfo"%>
<%@ page import="com.eg.EgServicesInfo"%>
<%@ page import="com.eg.EgName"%>
<%@ page import="com.eg.MappingNameSorter"%>
<%@ page import="com.egurkha.util.StringUtils"%>
<%@ page import="com.egurkha.ini.IniUI"%>
<%@ page import="egurkha.ServerBean"%>
<%@ page import="java.util.Vector"%>
<%@ page import="java.util.ArrayList"%>

<%@ page import="net.sf.json.JSONObject"%>
<%@ page import="net.sf.json.JSONArray"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json;charset=UTF-8");

	JSONObject rootJSON = new JSONObject();
	rootJSON.put("success","true");
	egurkha.TestsNotConfigured tnCon = new egurkha.TestsNotConfigured();
	Vector orasWithoutSIDs = tnCon.serversWithoutSID();

	if (orasWithoutSIDs != null && orasWithoutSIDs.size() >0)
	{
		int orasCount = orasWithoutSIDs.size();
		if(orasCount % 4 == 1)
		{
			orasWithoutSIDs.add("");
			orasWithoutSIDs.add("");
			orasWithoutSIDs.add("");
		}
		else if (orasCount % 4 == 2)
		{
			orasWithoutSIDs.add("");
			orasWithoutSIDs.add("");
		}
		else if(orasCount % 4 == 3)
		{
			orasWithoutSIDs.add("");
		}
		
		JSONArray oraGridArr =  new JSONArray();
		for (int a=0; a<orasWithoutSIDs.size(); a=a+4)
		{
			String oraComp = orasWithoutSIDs.get(a).toString();
			JSONObject gridVal = new JSONObject();
			gridVal.put("column_1",orasWithoutSIDs.get(a).toString());
			gridVal.put("column_2",orasWithoutSIDs.get(a+1).toString());
			gridVal.put("column_3",orasWithoutSIDs.get(a+2).toString());
			gridVal.put("column_4",orasWithoutSIDs.get(a+3).toString());
			oraGridArr.add(gridVal);
		}
		rootJSON.put("oraGridData",oraGridArr);
		rootJSON.put("showOraclAlert",true);	
	}

	EgDiscInfo egDisc = new EgDiscInfo("manager");
	ArrayList managedCompTypes = egDisc.getManagedComponentTypes();
	boolean isAnyManagedCompExist = false;
	if (managedCompTypes != null && managedCompTypes.size() > 0)
	{
		isAnyManagedCompExist = true;
	}
	rootJSON.put("showManagedCompTypesOption",isAnyManagedCompExist);
	String activeCompTypes = request.getParameter("activeCompTypes");
	boolean activeCompCheck=false;
	if(activeCompTypes !=null && activeCompTypes.equalsIgnoreCase("true"))
	{
		activeCompCheck=true;
	}
	rootJSON.put("showManagedCompTypes",activeCompCheck);

	//Category
	String selectedServerGroup = request.getParameter("selectedServerGroup");
	if (selectedServerGroup == null || selectedServerGroup.trim().equals("") || selectedServerGroup.trim().equalsIgnoreCase("null"))
		selectedServerGroup = "-1";
	rootJSON.put("selectedServerGroup","-1");
	ArrayList serverGrps = getAllServerGroups();
	JSONArray categoryArr = new JSONArray();
	JSONObject tempObj = new JSONObject();
	tempObj.put("valueField","-1");
	tempObj.put("displayField",_mapping.getTextDescription("admin.server.All"));
	categoryArr.add(tempObj);

	for(int i=0; i<serverGrps.size(); i++)
	{
		String serverGrp = (String)serverGrps.get(i);
		if (serverGrp.equals(selectedServerGroup))
		{
			rootJSON.put("selectedServerGroup",serverGrp);
		}
		JSONObject obj = new JSONObject();
		obj.put("valueField",serverGrp);
		obj.put("displayField",_mapping.getTextDescription("admin.category."+serverGrp));
		categoryArr.add(obj);
	}
	rootJSON.put("category",categoryArr);

	//Component type
	ArrayList serverList  = new ArrayList();
	String[] servertypes = egDisc.getComponentTypes();
	for(int i=0; i<servertypes.length; i++)
	{
		if (!servertypes[i].equals("Site_servers"))
		{
			serverList.add(servertypes[i]);
		}
	}
	IniUI iniUI = IniUI.getInstance();
	String userLanguage = _user.getLanguage();
	if (userLanguage == null)
		userLanguage = iniUI.getDefaultLanguage();
	MappingNameSorter sorter = new MappingNameSorter(userLanguage);

	//Code starts to show managed comp types only
	List tempList=new ArrayList();
	List tempCategoryList = new ArrayList();
	if(activeCompTypes!=null && activeCompTypes.equalsIgnoreCase("true"))
	{
		rootJSON.put("selectedServerGroup","-1");
		boolean isOthersExist = false;
		for(int j=0;j<serverList.size();j++)
		{
			String compType = (String)serverList.get(j);
			if(compType.startsWith("Agg_"))
			{
				continue;
			}
			String[] tempCompNames = egDisc.getAllServersOfType(compType);
			if(tempCompNames !=null && tempCompNames.length > 0)
			{
				tempList.add(compType);
				String tmpCategory = getCategoryForCompononetType(compType);
				if (tmpCategory.equals(""))
				{
					isOthersExist = true;
					continue;
				}
				if (!tempCategoryList.contains(tmpCategory))
				{
					tempCategoryList.add(tmpCategory);
				}
			}
		}
		serverList = new ArrayList(tempList);
		categoryArr = new JSONArray();
		tempObj = new JSONObject();
		tempObj.put("valueField","-1");
		tempObj.put("displayField",_mapping.getTextDescription("admin.server.All"));
		categoryArr.add(tempObj);
		Collections.sort(tempCategoryList,String.CASE_INSENSITIVE_ORDER);
		if (isOthersExist)
		{
			tempCategoryList.add("OTHERS");
		}
		for(int i=0; i<tempCategoryList.size(); i++)
		{
			String serverGrp = (String)tempCategoryList.get(i);
			if (serverGrp.equals(selectedServerGroup))
			{
				rootJSON.put("selectedServerGroup",serverGrp);
			}
			JSONObject obj = new JSONObject();
			obj.put("valueField",serverGrp);
			obj.put("displayField",getCapitalizedCategory(serverGrp));
			categoryArr.add(obj);
		}
		rootJSON.put("category",categoryArr);
		if (!tempCategoryList.contains(selectedServerGroup))
		{
			selectedServerGroup = "-1";
		}
	}
	serverList = sorter.getSortedCompTypeList(serverList);

	if (selectedServerGroup != null && !selectedServerGroup.equals("null") && !selectedServerGroup.equals("-1") && selectedServerGroup.length() > 0)
	{
		if (selectedServerGroup.equalsIgnoreCase("Others"))
		{
			ArrayList serversGrpList = getOtherServers();
			if(activeCompTypes!=null && activeCompTypes.equalsIgnoreCase("true"))
			{
				ArrayList tempList1 = new ArrayList();
				for(int j=0;j<serversGrpList.size();j++)
				{
					String compType = (String)serversGrpList.get(j);
					String[] tempCompNames = egDisc.getAllServersOfType(compType);
					if(tempCompNames !=null && tempCompNames.length > 0)
					{
						tempList1.add(compType);
					}
				}
				serversGrpList = new ArrayList(tempList1);
			}
			serverList = sorter.getSortedCompTypeList(serversGrpList);
		}
		else if (selectedServerGroup.equalsIgnoreCase("CUSTOM COMPONENTS"))
		{
			ArrayList serversGrpList = getAllUserDefinedServers();
			if(activeCompTypes!=null && activeCompTypes.equalsIgnoreCase("true"))
			{
				ArrayList tempList1 = new ArrayList();
				for(int j=0;j<serversGrpList.size();j++)
				{
					String compType = (String)serversGrpList.get(j);
					String[] tempCompNames = egDisc.getAllServersOfType(compType);
					if(tempCompNames !=null && tempCompNames.length > 0)
					{
						tempList1.add(compType);
					}
				}
				serversGrpList = new ArrayList(tempList1);
			}
			serverList = sorter.getSortedCompTypeList(serversGrpList);
		}
		else
		{
			ArrayList serversGrpList = getCategorizedComponents(selectedServerGroup);
			if(activeCompTypes!=null && activeCompTypes.equalsIgnoreCase("true"))
			{
				ArrayList tempList1 = new ArrayList();
				for(int j=0;j<serversGrpList.size();j++)
				{
					String compType = (String)serversGrpList.get(j);
					String[] tempCompNames = egDisc.getAllServersOfType(compType);
					if(tempCompNames !=null && tempCompNames.length > 0)
					{
						tempList1.add(compType);
					}
				}
				serversGrpList = new ArrayList(tempList1);
			}
			serverList = sorter.getSortedCompTypeList(serversGrpList);
		}
	}
	if (selectedServerGroup != null && selectedServerGroup.equalsIgnoreCase("Others"))
	{
		serverList = removeAggServers(serverList);
	}
	String strServer = request.getParameter("server");
	if (strServer==null || strServer.equalsIgnoreCase("null"))
		strServer="";
	JSONArray compTypesArray = new JSONArray();
	JSONObject tmpObj = new JSONObject();
	tmpObj.put("valueField","-1");
	tmpObj.put("displayField",_mapping.getTextDescription("admin.server.Choose a component type"));
	compTypesArray.add(tmpObj);
	String selectedCompType = "-1";
	for(int i=0; i<serverList.size(); i++)
	{
		EgName nameObj = (EgName)serverList.get(i);
		//searchItemFound=true;
		String tmpVal = nameObj.getActualName();
		String tmpDis = nameObj.getLocalName();
		if(tmpVal.startsWith("Agg_"))
		{
			continue;
		}
		if (tmpVal.equals(strServer)) 
			selectedCompType = strServer;
		JSONObject obj = new JSONObject();
		obj.put("valueField",tmpVal);
		obj.put("displayField",tmpDis);
		compTypesArray.add(obj);
	}
	rootJSON.put("componentTypes",compTypesArray);
	rootJSON.put("selectedCompType",selectedCompType);

	//Components listing
	String egTitleSearchStr=request.getParameter("searchStr");
	boolean isSearchResult =(egTitleSearchStr!=null);
	if (egTitleSearchStr==null)
		egTitleSearchStr="";
	ArrayList searchList = new ArrayList();
	if (isSearchResult)
	{
		StringTokenizer st = new StringTokenizer(egTitleSearchStr);
		while (st.hasMoreTokens())
		{
			String thisToken = st.nextToken().trim();
			if (thisToken.equals(""))
				continue;
			searchList.add(thisToken);
		}
	}
	String temp = "";
	String [] serversArray = egDisc.getAllServersOfType(strServer);
	ArrayList servers = serversArray==null?new ArrayList():new ArrayList(Arrays.asList(serversArray));
	boolean serversFound = false;
	List minusList = new ArrayList();
	for(int j=0; j<servers.size(); j++)
	{
		String thisSrv = (String) servers.get(j);
		if(thisSrv.startsWith("Format:") || thisSrv.startsWith("#"))
		{
			minusList.add(thisSrv);
			continue;
		}
		temp=thisSrv.substring(thisSrv.indexOf(":")+1);
		if(strServer.equals("Oracle_server") && (temp.indexOf(":") != temp.lastIndexOf(":")))
		{
			temp = temp.substring(0,temp.lastIndexOf(":"));
		}

		String ipWithoutPort = Server.getServerNameWithoutPort(temp, false);
		if (isSearchResult && !doesExist(searchList,ipWithoutPort))
		{
				minusList.add(thisSrv);
				continue;
		}
		serversFound=true;
	}
	servers.removeAll(minusList);
	Collections.sort(servers,String.CASE_INSENSITIVE_ORDER);
	Vector vecStore = new Vector();
	JSONArray objArray = new JSONArray();
	com.eg.EgExternalInfo extInfo = new com.eg.EgExternalInfo("manager");
	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
	String[] extTypes = specsInfo.getAllExternalServerTypes();
	List extCompTypes = new ArrayList();
	if (extTypes != null)
	{
		extCompTypes = new ArrayList(Arrays.asList(extTypes));
	}
	if (!strServer.equals("null") && servers.size() > 0)
	{
		for(int j=0; j<servers.size(); j++)
		{
			String thisSrv = (String) servers.get(j);
			String serverType = (thisSrv.substring(0,thisSrv.indexOf(":"))).trim();
			temp=thisSrv.substring(thisSrv.indexOf(":")+1);
			String ip = egDisc.getComponentIP(strServer,temp);
			String nickAlone = temp.substring(0,temp.indexOf(":"));
			if(strServer.equals("Oracle_server") && (temp.indexOf(":") != temp.lastIndexOf(":")))
			{
				temp = temp.substring(0,temp.lastIndexOf(":"));
			}
			if(!vecStore.contains(temp))
			{
				vecStore.addElement(temp);
				String ipWithoutPort = Server.getServerNameWithoutPort(temp, false);

				if (isSearchResult && !doesExist(searchList,ipWithoutPort))
					continue;
				serversFound=true;
				String agentType = "Agent-based";
				if(serverType.equals("Real_user_monitor"))
				{
					agentType = "Agentless";
					//ip = "Not Applicable";
				}
				if(extInfo.isRemoteBased(nickAlone))
				{
					agentType = "Agentless";
				}
				else if (extCompTypes.contains(strServer))
				{
					agentType = "External Agent";
				}
				
				JSONObject obj = new JSONObject();
				//obj.put("Compname",temp);
				String compToShow = ipWithoutPort;
				if (serverType.equals("Oracle_server"))
				{
					List li = egDisc.getAllSIDs(ipWithoutPort);
					if (li != null && li.size() > 0)
					{
						compToShow += ":";
						for (int l=0; l < li.size(); l++)
						{
							if(l!=0)
							{
								compToShow += ",";
							}
							compToShow += li.get(l).toString();
						}
					}
				}
				obj.put("Compname",compToShow);
				if(serverType.equals("Real_user_monitor"))
				{
					IniFile iniTests = new IniFile(EgInstallInfo.getInstallDir() +"/manager/config/eg_tests.ini");
					String collector = iniTests.getValue("Real_user_monitor_URL_Mapping",ipWithoutPort);
					/*if(collector != null && collector.length() > 0)
					{
						String associatedUrl = iniTests.getValue("Eg_RUM_Collector",collector);
						if(associatedUrl != null && associatedUrl.length()>0)
							obj.put("HostIP",associatedUrl);
						else
							obj.put("HostIP","-");
					}
					else
					{
						obj.put("HostIP","-");
					}*/
					if(collector != null && collector.length() > 0)
					{
						obj.put("HostIP",collector);
					}
					else
					{
						obj.put("HostIP","-");
					}
					obj.put("IsRUM","true");
				}
				else
				{
					obj.put("HostIP",ip);
				}
				obj.put("Monitoring",agentType);
				objArray.add(obj);
			}
		}
		rootJSON.put("serversFound",serversFound);
		rootJSON.put("components",objArray);
	}
	EgServicesInfo servicesInfo = new EgServicesInfo("manager");
	boolean allowIPModification = servicesInfo.isAllowIPModification();
	rootJSON.put("allowIPModification",allowIPModification);

	out.println(rootJSON);
%>

<%
	session.setAttribute("adminLastAccessedURL","/final/admin/EgDispServer.jsp?category="+selectedServerGroup+"&comptype="+selectedCompType+"&activeCompTypes="+activeCompTypes);
%>

<%!
	public ArrayList tempServers = new ArrayList();
	public ServerBean serverBean = new ServerBean();

	private boolean doesExist(List searchList, String server)
	{
		Iterator i = searchList.iterator();
		while(i.hasNext())
		{
			String nextStr = (String) i.next();
			if (server.indexOf(nextStr)!=-1||(server.toUpperCase().indexOf(nextStr.toUpperCase()))!=-1)
			{
				return true;
			}
		}
		return false;
	}

	private ArrayList removeAggServers(ArrayList serverList)
	{
		ArrayList tmpList = new ArrayList();
		for(int i=0; i<serverList.size(); i++)
		{
			EgName nameObj1 = (EgName)serverList.get(i);
			String tmpVal = nameObj1.getActualName();
			String tmpDis = nameObj1.getLocalName();
			if(tmpVal.startsWith("Agg_"))
			{
				continue;
			}
			tmpList.add(serverList.get(i));
		}

		return tmpList;
	}

	public ArrayList getAllServerGroups()
	{
		ArrayList grp = new ArrayList();
		try
		{
			IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() +"/manager/config/eg_infrastructure.ini");
			String[] Subjects = iniFile.getSubjects();
			for (int i = 0;i<Subjects.length;i++ )
			{
				grp.add(Subjects[i]);
			}
			ArrayList icTypes = getAllUserDefinedServers();
			if (com.eg.EgMemInfo.icEnabled && icTypes != null && icTypes.size()>0)
			{
				grp.add("CUSTOM COMPONENTS");
			}
			Collections.sort(grp,String.CASE_INSENSITIVE_ORDER);
			ArrayList otherServers = getOtherServers();
			if (otherServers.size() > 0)
			{
				grp.add("OTHERS");
			}
			grp.remove("AGGREGATES");
			return grp;
		}
		catch (Exception e)
		{
			e.printStackTrace();
			return new ArrayList();
		}
	}
	public String getCapitalizedCategory(String categoryName)
	{
		StringBuffer buff = new StringBuffer();
		int j = 0;
		if (categoryName != null)
		{
			//for (int i = 0;i<grps.size();i++ )
			//{
				//String val = (String)grps.get(i);
				if (categoryName.indexOf("_") != -1)
				{
					categoryName = StringUtils.replace(categoryName,"_"," ");
				}
				StringTokenizer tokens = new StringTokenizer(categoryName," ");
				while(tokens.hasMoreTokens())
				{
					String token = tokens.nextToken();
					token = token.trim();
					token = token.toLowerCase();
					String sub = token.substring(1);
					String initial = (token.substring(0,1)).toUpperCase();
					initial = initial + sub;
					if (j == 0)
					{
						buff.append(initial);
					}
					else
					{
						buff.append(" ");
						buff.append(initial);
					}
					j++;
				}
			//}
		}
		return buff.toString();
	}

	public ArrayList getOtherServers()
	{
		getAllInfraServers();
		ArrayList serverList = new ArrayList();
		EgDiscInfo egDisc = new EgDiscInfo("manager");
		String[] otherServers = egDisc.getComponentTypes();
		if (otherServers == null || otherServers.length == 0)
		{
			return new ArrayList();
		}
		for(int i=0; i<otherServers.length; i++)
		{
			if (!otherServers[i].equals("Site_servers") && !otherServers[i].toLowerCase().endsWith("_ex"))
			{
				if (!tempServers.contains(otherServers[i]))
				{
					serverList.add(otherServers[i]);
				}
			}
		}
		return serverList;
	}

	public void getAllInfraServers()
	{
		ArrayList comGroups = new ArrayList();
		try
		{
			IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() +"/manager/config/eg_infrastructure.ini");
			String[] Subjects= iniFile.getSubjects();
			for (int i = 0;i<Subjects.length;i++ )
			{
				if (Subjects[i] != null && Subjects[i].equalsIgnoreCase("AGGREGATES"))
				{
					continue;
				}

				String [] variables = iniFile.getVariables(Subjects[i]);
				for (int j = 0;j<variables.length;j++)
				{
					tempServers.add(variables[j]);
				}
			}
		}
		catch (Exception e)
		{
		}
	}

	public ArrayList getAllUserDefinedServers()
	{
		Map serverList = new HashMap();
		Hashtable allSrvMap = serverBean.getAllServerMap();
		ArrayList udServers = (ArrayList)allSrvMap.get("UDSERVERS");	//userdefined servers
		if(udServers != null && udServers.size()>0)
		{
			for(int i=udServers.size()-1;i>=0;i--)
			{
				String ud_server = (String)udServers.get(i);
				if(udServers.get(i).toString().startsWith("Agg_"))
				{
					udServers.remove(i);
				}
			}
		}
		return udServers;
	}
	public ArrayList getCategorizedComponents(String compGroup)
	{
		ArrayList comGroups = new ArrayList();
		try
		{
			IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() +"/manager/config/eg_infrastructure.ini");
			String[] Subjects= iniFile.getSubjects();

			String [] variables = iniFile.getVariables(compGroup);
			for (int j = 0;j<variables.length;j++)
			{
				comGroups.add(variables[j]);
			}
		}
		catch (Exception e)
		{
			return new ArrayList();
		}
		if (!EgInstallInfo.isnamedUserLicense && !EgInstallInfo.isconcurrentUserLicense) //server based license, then remove Cloud_VMs type
		{
			comGroups.removeAll(EgInstallInfo.getUserCertSpecificTypes());
		}
		return comGroups;
	}
	public String getCategoryForCompononetType(String compType)
	{
		IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() +"/manager/config/eg_infrastructure.ini");
		String[] subs = iniFile.getSubjects();
		String res ="";
		if(subs!=null)
		{
			for (int s=0; s<subs.length; s++)
			{
				String sub = subs[s];
				String[] vars = iniFile.getVariables(sub);
				if (vars!=null)
				{
					List compTypes = Arrays.asList(vars);
					if (compTypes.contains(compType))
					{
						res = sub;
					}
				}
			}
		}
		return res;
	}
%>