<%
/*****************************************************************************
*  File         : EgDispSegments.jsp
*  Purpose      : To display all the segments in a topology and provide options
		  to modify and delete a segment
*  Version      : 4.0
*  Creation Date: 08/11/2001
*  Last Modified: 01/07/2003 //Saravanan - Sorted the vector which displays the segments.
		  19/03/2002 //sandhya 
		  18/02/2002 //sandhya  
		  25/01/2002 //sandhya - to pass destiny as a parameter to Egdelsegmentp.jsp 	 
		  22/11/2001
*  Author       : BalaMurugan.V
*	Design Changes	:	Jaiwin
******************************************************************************/
%>

<%@ include file="../../../admin/EgTrackerAJSON.jsp" %>
<%@ page import="com.eg.IniFile" %>
<%@ page import="com.eg.EgInstallInfo" %>
<%@ page import="com.eg.EgGroupInfo" %>
<%@ page import="com.eg.EgTopoInfo" %>
<%@ page import="com.eg.EgURLEncoder" %>
<%@ page import = "net.sf.json.*"%>
<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<%
	JSONObject rootJson = new JSONObject();
	JSONObject screenLabels = new JSONObject();
	JSONObject segmentObj = new JSONObject();
	JSONArray segmentArr = new JSONArray();

	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	EgGroupInfo groupinfo = new EgGroupInfo();
	EgTopoInfo topoinfo = groupinfo.getTopoInfoObject();
	String msg=(String)session.getAttribute("msg");
%>
<%!
	String str_iniFileName;//name of inifile
	String subject = "TOPOLOGY_SEGMENTS";//name of subject
 	String strVar[];
	String strVarArr[];
 	Vector v_seg;
 	String value;
 	//IniFile ini_top = null;
 	int count = 0;
%>
<%
	str_iniFileName="eg_topology.ini";
	
	v_seg = new Vector();
        //removal of physical topology
		//ini_top = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/" + str_iniFileName);
        //strVarArr = ini_top.getVariables(subject);
	strVarArr = topoinfo.getVariables(subject);
	if(strVarArr == null)
		return;
	for(int i=0; i<strVarArr.length; i++)
	{
		v_seg.addElement(strVarArr[i]);
	}
	session.setAttribute("existing_names",strVarArr);
	count = v_seg.size();
  	if(v_seg != null && v_seg.size() > 0)
  		Collections.sort(v_seg);
        //removal of physical topology
		//strVar = ini_top.getVariables("WEB_SITE_SEGMENTS");
		strVar = topoinfo.getVariables("WEB_SITE_SEGMENTS");
	String site_associated = "";
	String egTitleSearchStr = request.getParameter("egTitleSearchStr");
	boolean isSearchResult =egTitleSearchStr!=null&&!egTitleSearchStr.equals("");
	ArrayList searchList = new ArrayList();
	if (egTitleSearchStr == null)
		egTitleSearchStr ="";
	if (isSearchResult)
	{
		StringTokenizer st = new StringTokenizer(egTitleSearchStr);
		while (st.hasMoreTokens())
		{
			String thisToken = st.nextToken().trim();
			if (thisToken.equals(""))
				continue;
			searchList.add(thisToken);
		}
	}
	String reqFrom = request.getParameter("reqfrom");
	reqFrom = (reqFrom == null?"":reqFrom);


	session.setAttribute("egBackComplete","/final/admin/EgComponentSegments.jsp");
	session.setAttribute("egTitlehref", "/final/admin/EgAddSegment.jsp");
	
	String addSegmentUrl ="SegmentsTopo/data/EgAdminTopologyJson.jsp?mode=add"+"&zone=-1"+"&segment=aa";
	rootJson.put("AddSegmentUrl",addSegmentUrl);
	if(reqFrom.equalsIgnoreCase("navlink"))
	{
	}
	else
	{
	}
	if(v_seg==null || v_seg.size()==0 )
	{
		if(msg!=null)
		{
		}
		if(v_seg!=null && v_seg.size()==0)
		{
			rootJson.put("NoExtFound","true");
			screenLabels.put("NoSegments",_mapping.getTextDescription("admin.group.There are no Segments available currently"));
		}
	}else 
	{
		rootJson.put("NoExtFound","false");
		/* to display segments */
		int ctr = 0;
		String tdclass="form_border";
		String lastvalue="";
		if(count > 0)
		{
			IniFile ini = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_group.ini");
			ArrayList zoneCmpList = new ArrayList();
			String [] vars = ini.getVariables("ZONE_DETAILS");
			if (vars!=null)
				zoneCmpList.addAll(Arrays.asList(vars));
			String [] zones = ini.getVariables("LIST_OF_ZONES");
			Hashtable h = topoinfo.getSegmentServiceAssociation();
			String thiselement ="";
			Vector searchVec=new Vector();
			boolean searchItemFound = false;
			for(int i=0;i<v_seg.size();i++)
			{
				thiselement = ((String)v_seg.elementAt(i)).trim();
				if (isSearchResult && !doesExist(searchList,thiselement))
					continue;
				else
					searchVec.add(thiselement);
				searchItemFound=true;
			}
			int x=searchVec.size();
			if(x!=0)
			{
				lastvalue=(String)searchVec.get(x-1);
			}
			if(searchVec.size()!=0)
			{
			}
			List minusHosts = new ArrayList();
			for(int i=0;i<v_seg.size();i++)
			{
				boolean isLastElement = (i+1)<v_seg.size();
				thiselement = ((String)v_seg.elementAt(i)).trim();
				if (isSearchResult && !doesExist(searchList,thiselement))
				{
					minusHosts.add(thiselement);
					continue;
				}
				searchItemFound=true;
			}
			v_seg.removeAll(minusHosts);
			for(int i=0;i<v_seg.size();i++)
			{
				boolean isLastElement = (i+1)<v_seg.size();
				thiselement = ((String)v_seg.elementAt(i)).trim();
				//String thiszone = groupinfo.getZoneNameForSegment((String)thiselement);
				String thiszone = groupinfo.getZoneNameForComponent("Segment:"+thiselement+":NULL");
				if (thiszone==null)
					thiszone="-1";
				if(lastvalue.equalsIgnoreCase(thiselement))
				{
					tdclass="form_spacing";
				}
				/*String relSegment = groupinfo.getSegmentNameForGroup(thisGroup);
				Iterator serviceIter = groupinfo.getServiceNamesForGroup(thisGroup);
				boolean serRelated = serviceIter.hasNext();
				boolean segRelated = (relSegment!=null && !relSegment.equals(""));
				boolean isDisabled = serRelated || segRelated;*/
				ArrayList serviceList = topoinfo.getSitesForSegment(thiselement);

				String iniFilePath= EgInstallInfo.getInstallDir() +														"/manager/config/eg_ui.ini";
				IniFile iniFile = new IniFile(iniFilePath);
				String modifyMode = iniFile.getValue("TOPOLOGY_OPTIONS","ModifyMode");
				
				String topoURL = "";
				if(modifyMode!=null)
				{
					if(modifyMode.equalsIgnoreCase("manual"))
					{
						topoURL = "EgAdminTopology.jsp?qctr=0&segment="+EgURLEncoder.encode(thiselement,"UTF-8");
					}
					else if(modifyMode.equalsIgnoreCase("auto"))
					{
						topoURL = "EgTopologyMainPage.jsp?segment="+EgURLEncoder.encode(thiselement,"UTF-8")+"&fromPage=modifySegment"+"&zone="+EgURLEncoder.encode(thiszone,"UTF-8");
					}
				}
				topoURL="SegmentsTopo/data/EgAdminTopologyJson.jsp?mode=modify"+"&zone="+thiszone+"&segment="+thiselement; //+'&showIndOnlyParam=true'+'&newsegment='+newsegment;
				
				segmentObj.put("Zonename",thiszone);
				// changes on 24 Oct 2007 (checking segment under zone)
				ArrayList zoneElements = groupinfo.getAllElementsUnderZone(thiszone);
				boolean zone_associated = false;

				if(zoneElements != null  && zoneElements.contains("Segment:"+thiselement+":NULL"))
				{
					zone_associated = true;
				}
				// End
				segmentObj.put("Segmentname",thiselement);
				segmentObj.put("ModifyUrl",topoURL);
				// Get display image for this segment
				String imageValue = topoinfo.getValue("SEGMENT_DISPLAY_IMAGE",thiselement);
				segmentObj.put("ImageName",imageValue);
				
				String tmpStr = "<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" width=\"100%\" align=\"center\">";
				if(serviceList.size()>0 || zone_associated)
				{
					//tmpStr=tmpStr+"<tr height='6'></tr><tr><td width='100%' align='left' nowrap style='font-size:8pt;font-weight:normal;'><i>This segment is associated with the following</i></td></tr><tr height='5'></tr>";
				}
				else
				{
					tmpStr=tmpStr+"<tr><td width='100%' align='left' nowrap style='font-size:8pt;font-weight:normal;'><i>-</i></td></tr>";
					//tmpStr=tmpStr+" - ";
				}
				if (serviceList.size()>0 || zone_associated)
				{
					segmentObj.put("isDisabled","true");
					String displayStr = "admin.segment.This segment cannot be deleted since, this segment is associated with the following services";
					if(zone_associated)
						displayStr = "admin.segment.This segment cannot be deleted since, this segment is associated with the following zone";
				
					displayStr = "admin.segment.You may have to disassociate this segment from all of the related services";	
					if(zone_associated)
						displayStr = "admin.segment.You may have to disassociate this segment from the related zone";
				
					if(zone_associated)
					{
						tmpStr = tmpStr + "<tr><td width='55' style='font-size:8pt;font-weight:normal;'><i>Zone</i>";
						tmpStr = tmpStr+"</td><td width='5' class='eg_subcontent'>:</td><td>";
						tmpStr = tmpStr + "<a class='eg_monlink' href=\"/final/admin/EgComponentZones.jsp?zone="+EgURLEncoder.encode(thiszone,"UTF-8")+"&mode=modify&returnToMain=true&mainUrl=EgComponentSegments.jsp\" id='mouse' style='font-weight:normal;text-decoration:none;vertical-align:middle'>&nbsp;"+thiszone+"</a></td></tr><tr height='3'></tr>";
					}
					else
					{
						tmpStr = tmpStr + "<tr><td width='55' style='font-size:8pt;font-weight:normal;'><i>";
						if(serviceList.size()>1)
							tmpStr = tmpStr + "Services";
						else
							tmpStr = tmpStr + "Service";
						tmpStr = tmpStr+"</i></td><td width='5' class='eg_subcontent'>:</td><td>";
						tmpStr = tmpStr+"<table cellpadding='0'><tr>";
						int cc=0;
						Iterator serviceIter = serviceList.iterator();
						while (serviceIter.hasNext())
						{
							String thisService=(String)serviceIter.next();
							String sitezone = groupinfo.getZoneNameForService(thisService);
							sitezone = (sitezone==null)?"-1":sitezone;
							if(thisService!=null && !thisService.equals(""))
							{
								if(cc!=0)
								{
									tmpStr = tmpStr +"<td class='eg_subcontent'>,</td>";
								}
								tmpStr = tmpStr +"<td><a class='eg_monlink' href=\"/final/admin/EgComponentServices.jsp?site="+EgURLEncoder.encode(thisService,"UTF-8")+"&zone="+sitezone+"&modify=true&returnToMain=true&mainUrl=EgComponentSegments.jsp\" id='mouse' style='font-weight:normal;text-decoration:none;vertical-align:middle'>&nbsp;"+thisService+"</a></td>";
								cc++;
							}
						}
						tmpStr = tmpStr + "</tr></table>";
						tmpStr = tmpStr + "</td></tr><tr height='3'></tr>";
					}
				}
				else
				{
					segmentObj.put("isDisabled","false");
				}
				tmpStr = tmpStr + "</tr></table>";
				segmentObj.put("associations",tmpStr);
				segmentArr.add(segmentObj);

				if(strVar.length > 0)
				{
					for(int j=0; j<strVar.length; j++)
					{
						//removal of physical topology
						//String strVal = ini_top.getValue("WEB_SITE_SEGMENTS",strVar[j]);
						String strVal = topoinfo.getValue("WEB_SITE_SEGMENTS",strVar[j]);
						Vector v_segments = new Vector();
						if(strVal.indexOf(",") > -1)
						{
							StringTokenizer st = new StringTokenizer(strVal,",");
							while(st.hasMoreTokens())
							{
								String s_tmp = st.nextToken();
								if(!v_segments.contains(s_tmp))
								{
									v_segments.add(s_tmp);
								}
							}
						}
						else
						{
							if(!v_segments.contains(strVal))
							{
								v_segments.add(strVal);
							}
						}
						for(int k=0; k<v_segments.size(); k++) 
						{
										if(((String)v_segments.get(k)).equals((String)v_seg.get(i)))
										{
								site_associated = "true";
								break;
							}
							else
							{
								site_associated = "false";
							}
						}
						if(site_associated.equals("true"))
						{
							break;
						}
					}
				}
				else
				{
					site_associated = "false";
				}
				if (isLastElement)
				{
				}
				ctr++;
			}//End of for	
			if (!searchItemFound&&egTitleSearchStr!=null&&!egTitleSearchStr.equals(""))
			{
				screenLabels.put("searchResult",_mapping.getTextDescription("admin.segment.No segment(s) found for your search"));
				screenLabels.put("searchKey",egTitleSearchStr);
			}
		}
	}
						//else // No segments found... strange or probably the first time
						//{

						//}
					
					/* end of code */
	v_seg.removeAllElements();
	session.removeAttribute("msg");
%>

<%!
	private boolean doesExist(List schList, String segment)
	{
		Iterator i = schList.iterator();
		while(i.hasNext())
		{
			String nextStr = (String) i.next();
			if (segment.indexOf(nextStr)!=-1||(segment.toUpperCase().indexOf(nextStr.toUpperCase()))!=-1)
				return true;
		}
		return false;
	}
%>
<%
if(request.getQueryString()!=null)
session.setAttribute("adminLastAccessedURL","/final/admin/EgComponentSegments.jsp?"+request.getQueryString());
else session.setAttribute("adminLastAccessedURL","/final/admin/EgComponentSegments.jsp");
	
	screenLabels.put("deleteforSelectedMessage",_mapping.getTextDescription("admin.segment.Are you sure you want to delete the selected segment(s)?"));
	screenLabels.put("no segment selected",_mapping.getTextDescription("admin.segment.No Segment(s) have been selected"));
	screenLabels.put("deleteiconMsg1",_mapping.getTextDescription("admin.group.Are you sure you want to delete "));
	screenLabels.put("deleteiconMsg2",_mapping.getTextDescription("admin.group.segment?"));

	// Rename labels
	screenLabels.put("sameName",_mapping.getTextDescription("admin.segment.Segment names are identical")+". "+_mapping.getTextDescription("admin.segment.Please use different name for the segment"));
	screenLabels.put("admin.common.space not allowed",_mapping.getTextDescription("admin.common.Space is not allowed"));
	screenLabels.put("admin.common.special characters not allowed",_mapping.getTextDescription("admin.common.Special characters are not allowed"));
	screenLabels.put("admin.common.field value cannot be blank",_mapping.getTextDescription("admin.common.Field value cannot be blank."));
	screenLabels.put("admin.common.DBL not allowed",_mapping.getTextDescription("admin.common.Segment name is not allowed in DBL(Chinese,Korean,Japanese),since manager is SingleByte."));

	rootJson.put("screenLabels",screenLabels);
	rootJson.put("gridValues",segmentArr);
	//rootJson.put("strsite",strsite);	
	out.println(rootJson.toString());
%>
