<%
/*************************************************************************************************/
/*                 Name          : EgAutoPreviewPage.jsp                                         */
/*                 Purpose       : This page is used for Auto Topology preview					 */
/*                 Version       : 5.7                                                           */
/*                 Created On    : 27-02-2013                                                    */
/*************************************************************************************************/
%>
<%@ include file= "../../../admin/EgTrackerAJSON.jsp"%>
<%@ page import = "java.util.*"%>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.eg.EgGroupInfo"%>
<%@ page import = "com.eg.MappingNameSorter"%>
<%@ page import = "com.eg.EgName"%>
<%@ page import="com.eg.EgInstallInfo" %>
<%@ page import = "com.egurkha.EgConstants" %>
<%@ page import = "com.egurkha.monitor.alarms.AlarmPriorities" %>
<%@ page import = "com.egurkha.util.StringUtils" %>
<%@ page import = "com.egurkha.ini.IniUI" %>
<%@ page import = "com.egurkha.EgNewTopology" %>
<%@ page import = "com.eg.eGComponentCategory" %>
<%@ page import = "com.eg.TopoRhsComp" %>
<%@ page import = "com.eg.EgConfigFilesSync" %>
<%@ page session = "true" %>
<%@ taglib prefix = "egui" uri="../../../WEB-INF/eg-taglib.tld" %> 
<%@ page language = "java" contentType = "text/html; charset=UTF-8" pageEncoding = "UTF-8" %>
<jsp:useBean id="zoneinfo" scope="page" class="egurkha.ZoneInfoBean"/>
<%
try
{
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	String ua = request.getHeader( "User-Agent" );
	boolean isFirefox = ( ua != null && ua.indexOf( "Firefox/" ) != -1 );
	boolean isMSIE6 = ( ua != null && ua.indexOf( "MSIE 6.0" ) != -1 );
	
	String topologySkin=_user.getAdminSkin();
	String bgColor = "";
	String compNameColor="";
	String fontFamily="LucidaGrandeRegular";
	String fontFamilyBold="LucidaGrandeBold";
	String mouseOverLineColor = "";
	String mouseOverTextColor="";
	IniFile egUi = new IniFile(EgInstallInfo.getInstallDir()+ "/manager/config/eg_ui.ini");
	IniFile udTests=new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_udtests.ini");
	if(topologySkin!=null && topologySkin.equalsIgnoreCase("Dark"))
	{
		bgColor=egUi.getValue("TOPOLOGY_DARK_BACKGROUND","BgColor");
		compNameColor=egUi.getValue("TOPOLOGY_DARK_BACKGROUND","ComponentNameColor");
		mouseOverLineColor = "";
		mouseOverTextColor=egUi.getValue("TOPOLOGY_DARK_BACKGROUND","MouseOverTextColor");
	}
	else
	{
		bgColor=egUi.getValue("TOPOLOGY_LIGHT_BACKGROUND","BgColor");
		compNameColor=egUi.getValue("TOPOLOGY_LIGHT_BACKGROUND","ComponentNameColor");
		mouseOverLineColor = "";
		mouseOverTextColor=egUi.getValue("TOPOLOGY_LIGHT_BACKGROUND","MouseOverTextColor");
	}

	EgGroupInfo groupInfo = new EgGroupInfo();
	ArrayList thisZoneComponents = new ArrayList();	// Contains all components from the given zone.
	ArrayList allZoneComponents = new ArrayList();	// Contains all components from all Zones Except the selected Zone
	String zone = request.getParameter("zone");
	String segmentName = request.getParameter("segment");
	String zoomLevel = request.getParameter("zoom");
	String site = request.getParameter("site");
	String phyTopology = request.getParameter("physical_topology");
	boolean preview = true;

	String hlc_type = request.getParameter("hlcomptype");	// High_Lighted_CompType
	String hlc = request.getParameter("hlcomp");			// High_Lighted_Comp
	if(hlc_type == null) 
		hlc_type = "";
	if(hlc == null)
		hlc = "";

	String color = "A0A0A0";
	String dark = "150517";
	if(zoomLevel == null) zoomLevel = "100";
	if(phyTopology == null) phyTopology = "1";
	if(site == null) site = "egurkha.physical.topology";
	boolean isEntry = false;
	String conPath = request.getContextPath();
	//String contextPath = request.getContextPath()+"/admin/eg_images/";
	String contextPath1 = request.getContextPath()+"/images/component_icons/";
	String contextPath = request.getContextPath()+"/images/"+topologySkin+"/component_icons/";
	String ICImagePath=request.getContextPath()+"/images/"+topologySkin+"/ic_images/";
	String finalTopoStr = new String();

	// Collect Zone componets, if zone is not Default
	boolean isZone = false;
	if(zone!=null && !zone.equals("-1")){
		thisZoneComponents = groupInfo.getAllComponentsUnderZone(zone);
		isZone = true;
	}

	Hashtable tmpHt = groupInfo.getAllComponentsUnderZone();
	if(tmpHt!=null && tmpHt.size() > 0)
	{
		if(isZone && tmpHt.containsKey(zone)){
			tmpHt.remove(zone);
		}
		ArrayList valList = new ArrayList(tmpHt.values());
		for(int k=0;k<valList.size();k++)
		{
			ArrayList tmpList = (ArrayList) valList.get(k);
			allZoneComponents.addAll(tmpList);
		}
	}

/* New Coding Starts here */
	String comptype = request.getParameter("comptype");
	if(comptype==null) comptype="";
	String compname = request.getParameter("compname");
	if(compname==null) compname="";

	Hashtable compList = getStartCompsFromTopoAuto(allZoneComponents);
	Hashtable segmentCompTable = getSegmentComps(segmentName);

	//Remove segment components from compList...(Begin)
	if(segmentCompTable!=null && segmentCompTable.size() > 0)
	{
		Set myKeys = segmentCompTable.keySet();
		Iterator myItr = myKeys.iterator();
		while(myItr.hasNext())
		{
			String myKey  = (String) myItr.next();
			ArrayList totalList = (ArrayList) compList.get(myKey);
			if(totalList!=null && totalList.size() > 0)
			{
				ArrayList myList = (ArrayList) segmentCompTable.get(myKey);
				if(myList!=null && myList.size() > 0)
				{
					boolean remove = false;
					for(int k=0;k<myList.size();k++)
					{
						String thisString = (String) myList.get(k);
						int index = totalList.indexOf(thisString);
						if(index >= 0)
						{
							totalList.remove(index);
							remove = true;
						}
					}
					if(remove)
					{
						if(totalList.size() > 0)
							compList.put(myKey, totalList);
						else
							compList.remove(myKey);
					}
				}
			}
		}
	}
	//Remove segment components from compList...(End)

	ArrayList serverTypes = new ArrayList();
	ArrayList compNames = new ArrayList(); 
	if(compList!=null && compList.size() > 0)
	{
		Set compTypeSet = compList.keySet();
		if(compTypeSet!=null && compTypeSet.size() > 0)
		{
			serverTypes = new ArrayList(compTypeSet);
			Collections.sort(serverTypes);
		}
		if(comptype!=null && comptype.length() > 0)
		{
			compNames = (ArrayList) compList.get(comptype);
			if(compNames!=null)
				Collections.sort(compNames);
		}
	}
/* New Coding Ends here */
%>
<html>
<head>
<title>Auto Topology Preview</title>
<egui:skin ui="admin"/>
<head>
<script src="/final/scripts/map.js" type="text/javascript" charset="utf-8"></script>
<script src="/final/scripts/raphael.js" type="text/javascript" charset="utf-8"></script>
<script src="/final/scripts/g.raphael.js" type="text/javascript" charset="utf-8"></script>
<script src="/final/scripts/raphael.zoom.js" type="text/javascript" charset="utf-8"></script>

<script type="text/javascript">

document.oncontextmenu = new Function("return false");

// Set height and width based on window screen size
documentView ={
		getObject: function(){
			if(typeof( window.innerWidth) == 'number'){//Firefox
				this.height = window.innerHeight;
				this.width = window.innerWidth;
				this.fireFox = true;
			}
			else if( document.documentElement && ( document.documentElement.clientWidth
				|| document.documentElement.clientHeight )){//IE 6 + in 'standards compliant mode'
				this.height = document.documentElement.clientHeight;
				this.width = document.documentElement.clientWidth;
				this.ie = true;
			}
			else if(document.body && document.body.clientHeight){ //IE 4 compatible
				this.height = document.body.clientHeight;
				this.width = document.body.clientWidth;
				this.ie = true;
			}
			return this;
		},
		getHeight: function(){
			return this.getObject().height;
		},
		getWidth: function(){
			return this.getObject().width;
		},
		isIE: function(){
				return this.getObject().ie;
		},
		isFireFox: function(){
				return this.getObject().fireFox;
		}
};

function pageHeightWidth()
{
	var containerDiv = document.getElementById("container");

	if (containerDiv!=null){
		containerDiv.style.height = documentView.getHeight()-10;
		containerDiv.style.width = documentView.getWidth()- 10;
	}
}

window.onresize=pageHeightWidth;

function setZoomLevel(val)
{
	//This is a Dummy function, used to avoid java script error. Original Function is defined inside Body
}

</script>
</head>
<%
	// To Remover Previous session entries
	session.removeAttribute("THISSEGMENT");
	finalTopoStr = getTopologyString(segmentName , site , phyTopology);
	String sessionString = (String) session.getAttribute("THISSEGMENT");
	if(sessionString!=null && sessionString.length() > 0){
		session.setAttribute("THISSEGMENT",finalTopoStr);
	}
	else{
		session.setAttribute("THISSEGMENT",finalTopoStr);
	}
	ArrayList postionArrList = null;
	int divHeight = 100;
	int divWidth  = 100;
	//Get row & column spacing from eg_ui.ini .... (Begin)
	IniUI iniUI = IniUI.getInstance();
	String rs =	iniUI.getValue("TOPOLOGY_OPTIONS","Row_space");
	String cs = iniUI.getValue("TOPOLOGY_OPTIONS","Column_space");
	int rowspace = 50;
	int colspace = 50;
	try{
		if(rs!=null) rowspace = Integer.parseInt(rs);
		if(cs!=null) colspace = Integer.parseInt(cs);
	}
	catch(Exception e){
		rowspace = 50;
		colspace = 50;
	}
	//Get row & column spacing from eg_ui.ini .... (End)
	if(finalTopoStr!=null && finalTopoStr.trim().length() > 1)
	{
		EgNewTopology egNewTopo= new EgNewTopology(finalTopoStr,rowspace,colspace);
		postionArrList = egNewTopo.getOutputValues();
		divHeight = egNewTopo.getHeight();
		divWidth  = egNewTopo.getWidth();
		isEntry = true;
	}
	StringBuffer outPutBuffer = new StringBuffer();
	if(postionArrList!=null){
		outPutBuffer.append(postionArrList.toString().substring(1,postionArrList.toString().indexOf("]")));
	}
	//getting data from eg_lang_US.ini file
	//ArrayList tokeList = new ArrayList();
	//for(int i=0;i<postionArrList.size();i++)
	//{
		//String key =(String)postionArrList.get(i);
		
		//StringTokenizer tokenizer = new StringTokenizer(key,",");
		//String tokenVal=tokenizer.nextToken();
		//tokeList.add(tokenVal);
	//}
	//ArrayList keyList= new ArrayList();
	//for(int i=0;i<tokeList.size();i++)
	//{
		//String t_key=(String)tokeList.get(i);
		//String key = t_key.substring(0,t_key.indexOf("="));
		//keyList.add(key);
		
	//}
	//StringBuffer pnameBuffer = new StringBuffer();
	//ArrayList valueList = new ArrayList();
	//boolean isName = true;
	//String delim="";
	//String val="";
	//for(int i=1;i<keyList.size();i++)
	//{
		//delim="=";
		//String key1=(String)keyList.get(i);
		//String keyValue=key1.substring(0,key1.indexOf(":"));
		//String keyinValue="";
		//if(keyValue.indexOf("Agg_")==0)
		//{
			//keyinValue=keyValue.substring(4);
			
		//}
		//else
		//{
			//keyinValue=keyValue;
		//}
		//String value=_mapping.getComponentTypeDescription(keyinValue);
		
			//val+=(keyinValue+":"+value+""+delim);
		////delim="=";
		
	//}
	
	//valueList.add(val);
	
	//if(valueList.size()>0)
	//{
		
		//pnameBuffer.append(valueList.toString().substring(1,valueList.toString().indexOf("]")));
		
		//isName=true;
	//}
	//end
	boolean isName = true;
	String compCategoryMapping="";
	String pnameBuffer="";
	eGComponentCategory compCategoryObj = eGComponentCategory.getInstance();
	for(int i=0;i<postionArrList.size();i++)
	{
		String line=(String)postionArrList.get(i);
		StringTokenizer tokenizer = new StringTokenizer(line,",");
		String var=tokenizer.nextToken();
		if(var.startsWith("egurkha.physical.topology"))
			continue;
		String comp_Type=var.substring(0,var.indexOf(":"));
		String category  ="";
		if(comp_Type.equals("Group"))
		{
			category="group";
		}
		else if(comp_Type.endsWith("_ex"))
		{
			category = udTests.getValue("COMP_DISPLAYIMAGE_NICK",comp_Type);
		}
		else if(comp_Type.toLowerCase().startsWith("agg_"))
		{
			category="AGGREGATES";
		}
		else
		{
			category=compCategoryObj.getCategoryforCompType(comp_Type);
		}
		compCategoryMapping+=(comp_Type+":"+category+"=");
		if(comp_Type.indexOf("Agg_")==0)
		{
			comp_Type=comp_Type.substring(4);
		}
		String value=_mapping.getComponentTypeDescription(comp_Type);
		pnameBuffer+=(comp_Type+":"+value+"=");
		
	}
	if(compCategoryMapping.endsWith("="))
	{
		compCategoryMapping=compCategoryMapping.substring(0,compCategoryMapping.lastIndexOf("="));
	}
	if(pnameBuffer.endsWith("="))
	{
		pnameBuffer=pnameBuffer.substring(0,pnameBuffer.lastIndexOf("="));
	}
	// ...... List of new & unmanage components (Begin)...........................//
	TreeSet newCompList = new TreeSet();
	TreeSet unManageList = new TreeSet();
	StringBuffer newCompBuffer = new StringBuffer();
	StringBuffer unManageBuffer = new StringBuffer();
	if(isEntry)
	{
		Hashtable resultTable = getUnmanageAndNewComponents(segmentName);
		newCompList = (TreeSet) resultTable.get("NEW");
		unManageList = (TreeSet) resultTable.get("UNMANAGE");
		if(newCompList!=null && newCompList.size() > 0)
			newCompBuffer.append(newCompList.toString().substring(1,newCompList.toString().indexOf("]")));
		if(unManageList!=null && unManageList.size() > 0)
			unManageBuffer.append(unManageList.toString().substring(1,unManageList.toString().indexOf("]")));
	}
	// ...... List of new & unmanage components (End)...........................//

	String popup_topright = isMSIE6?"popup_topright_noshade":"popup_topright";
	String popup_rightbg = isMSIE6?"popup_rightbg_noshade":"popup_rightbg";
	String popup_bottomleft = isMSIE6?"popup_bottomleft_noshade":"popup_bottomleft";
	String popup_bottombg = isMSIE6?"popup_bottombg_noshade":"popup_bottombg";
	String popup_bottomright = isMSIE6?"popup_bottomright_noshade":"popup_bottomright";
%>

<input type="hidden" id="h_title" name="h_title" value="">
<input type="hidden" id="h_src" name="h_src" value="">
<input type="hidden" id="h_status" name="h_status" value="">
<input type="hidden" id="lorn" name="lorn" value="">

<body style="overflow:hidden;" id="space6" onLoad="javascript:pageHeightWidth();" >
<input type="hidden" name="zoomTxt" id="zoomTxt" value="100%" size="5" class="linesquare" readonly="readonly">
<div id ="loading_image" style = "position:absolute;top:100px;left:150px;visibility:visible;display:none;border:0px solid #ff0000;"> 
	<table height="100%">
		<tr>
			<td height="100%" valign="middle"> 
				<img src='/final/admin/eg_images/indicator_medium.gif'>
			</td>
		</tr>
	</table>
</div>
<div id="mainDiv" name="mainDiv">
<table border="0" align="center" cellspacing="0" cellpadding="0" width="100%" >
	<input type="hidden" id="zone" name="zone" value="<%=zone%>">
	<input type="hidden" id="segment" name="segment" value="<%=segmentName%>">
	<tr>
		<td width="100%" align="center" height="100%" valign="top" >
			<table align="center" cellspacing="0" cellpadding="4" width="100%" border="0" >
				<tr>
					<td align="center">
						<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0">

							<tr>
								<td class="topoBg linesquare" >
									<div id="container" class="div_scroll" style="width:100%;height:100%;border:0px solid red;overflow:auto">
<%
	if(isEntry)
	{
%>
										<div  id="paper"  name="paper" style="width:100%;z-index:10;border:0px solid green"></div>
<script type="text/javascript">

var zom = parseInt('<%=zoomLevel%>')/100;
var width = 916;
var height = 520;
//var gifWidth = 50*zom;
//var gifHeight = 50*zom;
//var gifWidth = 50*zom;
//var gifHeight = 72*zom;
//var userWidth = 50*zom;
//var userHeight = 72*zom;
var newWidth = 19*zom;
var newHeight =  18*zom;
var gifWidth = 48*zom;
var gifHeight = 48*zom;

var userWidth = 48*zom;
var userHeight = 48*zom;
var rectShape ='';

var el;
var newUnmanageMap = new Map;
var connectionArr = new Array();
var eGComps = new Array();
var stateCircles = new Array();
var allCompNames = new Array();
var newUnmanageLables = new Array();

var compIndexMap = new Map();
var topostring ='<%=finalTopoStr%>';
var sessionstring = '<%=sessionString%>';
var positionString ='<%=outPutBuffer%>';
var newcompstring = '<%=newCompBuffer%>';
var unmanagerstring ='<%=unManageBuffer%>';
var iniMaxW = 0;
var iniMaxH = 0;
// addding

var egtop_iniMap = new Map();
var alltpNames = new Array();
//end
r = Raphael("paper", width, height);
r.initZoom();
var compCategoryMapping='<%=compCategoryMapping%>';
var compGroupMap = new Map();

//Zoom supports from 10% to 150%
function setZoomLevel(val)
{
	var zoomTxt = document.getElementById("zoomTxt").value;
	var zoomHidden = document.getElementById("zoom").value;

	if(val == '1') //	ZoomIn
	{
		var zInt = parseInt(zoomHidden);
		if(zInt >10)
		{
			zInt = zInt - 10;
			zInt = zInt.toFixed();
			document.getElementById("zoom").value = zInt;
			document.getElementById("zoomTxt").value = zInt +"%";
			setZoom(zInt / 100);
		}
	}
	else if(val == '-1') //ZoomOut
	{
		var zInt = parseInt(zoomHidden);
		if(zInt < 150)
		{
			zInt = zInt + 10;
			zInt = zInt.toFixed();
			document.getElementById("zoom").value = zInt;
			document.getElementById("zoomTxt").value = zInt +"%";
			setZoom(zInt / 100);
		}
	}
	//$j("#connectDiv").hide("slow");
}

function setZoom(zoom)
{
	var holderDiv = document.getElementById("paper");
	var holderH = document.getElementById("paper").clientHeight;
	var holderW = document.getElementById("paper").clientWidth;
	zom = zoom;
	var regW = holderW>iniMaxW?holderW:iniMaxW;
	var regH = holderH>iniMaxH?holderH:iniMaxH;
	if(regW < 916) regW = 916;
	if(regH < 512) regH = 512;
	holderDiv.style.width = regW;
	holderDiv.style.height = regH;
	if(zoom <=1)
	{
		r.setSize(regW, regH);
	}
	else
	{
		r.setSize(1.2*regW*zoom,regH*zoom);
	}
	r.setZoom(zoom);
	document.getElementById("zoomTxt").value = (zom * 100).toFixed() +"%";
	if(parent.document.getElementById("zoomValue")!=null)
		parent.document.getElementById("zoomValue").value= (zom * 100).toFixed();
}

setZoom(zom);

function resizePaperDiv(w, h)
{
	var intW = w;
	var intH = h;
	var resize = "false";
	var holderDiv = document.getElementById("paper");
	var holderH = document.getElementById("paper").clientHeight;
	var holderW = document.getElementById("paper").clientWidth;
	
	if(intW > 916){
		resize = "true";
	}
	else{
		intW = 916;
	}

	if(intH > 520){
		resize ="true";
	}
	else{
		intH = 520;
	}
	if(resize == "true"){
		r.setSize(intW*zom,intH*zom);
	}
}

function getMapDetails(posString, newcomString, unmanageString)
{
	//alert("test");
	var changeHeight = '<%=divHeight%>';
	var changeWidth = '<%=divWidth%>';

	var intW = parseInt(changeWidth);
	var intH = parseInt(changeHeight);
	resizePaperDiv(intW, intH);
	//adding Data
		
		var isname = '<%=isName%>';
		var inidataArr = new Array();
		if(isname=='true')
		{
			var positionName = '<%=pnameBuffer.toString()%>';
			inidataArr=positionName.split("=");
		}
		for(var i=0;i<inidataArr.length;i++)
		{
			var arrElement =  inidataArr[i];
			
			var iniMapKey =  arrElement.substring(0,arrElement.indexOf(":"));
			var iniMapValue = arrElement.substring(arrElement.indexOf(":")+1);
			
			egtop_iniMap.put(iniMapKey,iniMapValue);
			
			
		}
	//end
	var compGrpArr = new Array();
	if(compCategoryMapping!=null )
	{
		compGrpArr=compCategoryMapping.split("=")
		for(var i=0;i<compGrpArr.length;i++)
		{
			var arrElement =  compGrpArr[i];
			var iniMapKey =  arrElement.substring(0,arrElement.indexOf(":"));
			var iniMapValue = arrElement.substring(arrElement.indexOf(":")+1);
			compGroupMap.put(iniMapKey,iniMapValue);
		}
	}
	//Store new comp details ....(Begin)
	if(newcomString!=null && newcomString.length > 0)
	{
		var tmptokens = newcomString.split(", ");
		for(var i=0; i<tmptokens.length;i++)
		{
			var tokvalue = tmptokens[i];
			newUnmanageMap.put(tokvalue,"NEW");
		}
	}
	//Store new comp details ....(End)
	//Store UnManager Comp Details (Start)
	if(unmanageString!=null && unmanageString.length > 0)
	{
		var tmptokens = unmanageString.split(", ");
		for(var i=0; i<tmptokens.length;i++)
		{
			var tokvalue = tmptokens[i];
			newUnmanageMap.put(tokvalue,"UNMANAGE");
		}
	}
	//Store UnManager Comp Details (End)

	var tokens = posString.split(", ");
	var compInd = 0;
	var resize = "false";
	iniMaxW = intW;
	iniMaxH = intH;

	for(var i=0; i<tokens.length;i++)
	{
		var tokvalue = tokens[i];
		var key = tokvalue.substring(0,tokvalue.indexOf("="));
		var rhs = tokvalue.substring(tokvalue.indexOf("=")+1);

		if(key.indexOf(":")==0){
			key = 'egurkha.physical.topology';
		}
		if(key == 'egurkha.physical.topology') //User
		{
			var xy = rhs;
			var xPos = parseInt(xy.substring(0,xy.indexOf("#")));
			var yPos = parseInt(xy.substring(xy.indexOf("#")+1));

			var userImage = r.image('<%=contextPath%>'+'user_image.png', xPos*zom, yPos*zom , userWidth , userHeight).attr({title :"User"});
			
			eGComps.push(userImage);
			stateCircles.push("egurkha.physical.topology");
			allCompNames.push("egurkha.physical.topology");
			alltpNames.push("egurkha.physical.topology");
		}
		else
		{
			var xy = rhs;
			var xPos = parseInt(xy.substring(0,xy.indexOf("#")));
			var ystate = xy.substring(xy.indexOf("#")+1);
			var yPos = parseInt(ystate.substring(0,ystate.indexOf("#")));
			var state = xy.substring(xy.lastIndexOf("#")+1);

			var comptype = key.substring(0,key.indexOf(":")); 
			var compCategory=compGroupMap.get(comptype);
			var comptip = key.substring(key.indexOf(":")+1);
			if(comptip.indexOf(":NULL")>0)
				comptip = comptip.substring(0,comptip.indexOf(":NULL"));

			var coX = xPos*zom;
			var coY = yPos*zom;
			// Component Image (Begin)
			//var compImage = r.image('<%=contextPath%>'+comptype+'.gif', coX, coY , gifWidth , gifHeight).attr({title : comptip});
			var compImage='';
			if(comptype == 'Group')
			{
				compImage = r.image('<%=contextPath1%>'+'group.png', coX, coY , gifWidth , gifHeight).attr({title : comptip});
			}
			//else if(comptype.indexOf("Agg_")==0)
			//{
				//compImage = r.image('<%=contextPath%>aggregate.png', coX, coY , gifWidth , gifHeight).attr({title : comptip});
			//}
			else if(comptype.match("_ex$")=="_ex")
			{
				 compImage = r.image('<%=ICImagePath%>'+compCategory+'.png', coX, coY , gifWidth , gifHeight).attr({title : comptip});
			}
			else
			{
				 compImage = r.image('<%=contextPath%>'+compCategory+'.png', coX, coY , gifWidth , gifHeight).attr({title : comptip});
			}

			//If this is highlighted comp, Draw BOX .... (Begin)
			/*if('<%=hlc_type%>' == comptype && '<%=hlc%>' == comptip)
			{
				rectShape = r.rect (compImage.attr("x")-5*zom, compImage.attr("y")-5*zom, compImage.attr('width')+10*zom,compImage.attr('height')+5*zom).attr({
					"stroke-width": 2, 
					"stroke" : '#<%=dark%>'
				});
			}*/
			//If this is highlighted comp, Draw BOX .... (End)
			eGComps.push(compImage);
			// Component Image (End)

			// State Image (Begin)
			var mySet = r.set();
			//var scir = r.image('<%=contextPath%>'+'server_gray.gif',coX,coY,gifWidth,gifHeight);
			//var scir = r.image('<%=contextPath%>'+'server_gray.png',coX,coY,gifWidth,gifHeight);
			var latest = "";
			if(sessionstring.indexOf(key) < 0)
			{
				//scir.attr({opacity: 0.4});
				//latest = r.image('/final/admin/eg_images/'+'icon_recently_component.png',coX+30*zom,coY-8*zom,newWidth,newHeight);
			}
			//scir.toBack();
			//mySet.push(scir);
			mySet.push(latest);
			stateCircles.push(mySet);
			// State Image (End)
			//getting component name
			var textMsg;
			
			var msg=key.substring(0,key.indexOf(":"));
			if(msg.indexOf('Agg_') == 0) {
				msg=msg.substring(4);
				textMsg=egtop_iniMap.get(msg);
				textMsg=textMsg+" "+"Aggregate";
			}
			else
			{
				textMsg=egtop_iniMap.get(msg);
			}
			var compTextName=textMsg;
			var typeFlag=false;
			if(textMsg.length > 22)
			{
				var midval ;
				if(compTextName.length % 2 == 0)
					midval = compTextName.length / 2;
				else
					midval = (compTextName.length + 1) / 2;
				compTextName = textMsg.substring(0,midval)+"\n"+textMsg.substring(midval);
				typeFlag=true;
			}
			var cmpString ="";
			//end
			//Component Name (Begin)
			var compFlag=false;
			var textstr = comptip;
			if(comptip.length > 22)
			{
				var mid ;
				if(textstr.length % 2 == 0)
					mid = textstr.length / 2;
				else
					mid = (textstr.length + 1) / 2;
				textstr = comptip.substring(0,mid)+"\n"+comptip.substring(mid);
				compFlag=true;
			}
			var tX = parseInt(coX);
			var tY = parseInt(coY);

			var txtString = "";
			//Component Name (End)
			/*if((textMsg.length > 22) || (comptip.length > 22))
			{
				cmpString = r.text(coX+29*zom,coY+63*zom,compTextName).attr({"font-size" : 11*zom ,'font-weight': 'bold',"font-family":"Tahoma"});
			}
			else
			{
				cmpString = r.text(coX+29*zom,coY+56*zom,compTextName).attr({"font-size" : 11*zom ,'font-weight': 'bold',"font-family":"Tahoma"});
			}
			if((textMsg.length > 22) || (comptip.length > 22))
			{
				txtString = r.text(coX+29*zom,coY+92*zom,textstr).attr({"font-size" : 11*zom });
			}
			else
			{
				txtString = r.text(coX+29*zom,coY+72*zom,textstr).attr({"font-size" : 11*zom });
			}*/
			if(!typeFlag && !compFlag ) //1 1
			{
				cmpString = r.text(coX+23*zom,coY+55*zom,compTextName).attr({"font-size" : 10*zom,"fill": "<%=compNameColor%>","font-family":"<%=fontFamilyBold%>"});

				txtString =r.text(coX+23*zom,coY+70*zom,textstr).attr({"font-size" : 10*zom , "fill": "<%=compNameColor%>", "font-family":"<%=fontFamily%>"});
			}
			else if(!typeFlag && compFlag) // 1 2
			{
				cmpString = r.text(coX+23*zom,coY+60*zom,compTextName).attr({"font-size" : 10*zom,"fill": "<%=compNameColor%>","font-family":"<%=fontFamilyBold%>"});

				txtString =r.text(coX+23*zom,coY+80*zom,textstr).attr({"font-size" : 10*zom , "fill": "<%=compNameColor%>", "font-family":"<%=fontFamily%>"});
			}
			else if(typeFlag && !compFlag) // 2 1
			{
				cmpString = r.text(coX+23*zom,coY+60*zom,compTextName).attr({"font-size" : 10*zom,"fill": "<%=compNameColor%>","font-family":"<%=fontFamilyBold%>"});

				txtString =r.text(coX+23*zom,coY+80*zom,textstr).attr({"font-size" : 10*zom , "fill": "<%=compNameColor%>", "font-family":"<%=fontFamily%>"});
			}
			else if(typeFlag && compFlag) // 2 2
			{
				cmpString = r.text(coX+23*zom,coY+60*zom,compTextName).attr({"font-size" : 10*zom,"fill": "<%=compNameColor%>","font-family":"<%=fontFamilyBold%>"});

				txtString =r.text(coX+23*zom,coY+88*zom,textstr).attr({"font-size" : 10*zom , "fill": "<%=compNameColor%>", "font-family":"<%=fontFamily%>"});
			}
			alltpNames.push(cmpString);
			allCompNames.push(txtString);
			//Labels for new & unmanage components...(Begin)
			var isnew = newUnmanageMap.get(key);
			if(isnew!=null)
			{
				if(isnew == "NEW"){
					var newimg = r.image('/final/admin/eg_images/'+'icon_new_component.png',coX-5*zom,coY-8*zom,newWidth,newHeight);
					newUnmanageLables.push(newimg);
				}
				else if(isnew == "UNMANAGE"){
					var unmanageimg = r.image('/final/admin/eg_images/'+'icon_unmanaged_component.png',coX,coY+22*zom,newWidth,newHeight)
					newUnmanageLables.push(unmanageimg);
				}
			}
			else{
				newUnmanageLables.push("noimg");
			}
			//Labels for new & unmanage components...(End)
		}
		compIndexMap.put(key,compInd);
		compInd = compInd + 1;
	}

	if(resize == "true"){
		resizePaperDiv(iniMaxW, iniMaxH);
	}
	// Creating connections between components.......
	createConnections(topostring);
}

function createConnections(topostr)
{
	var tokens = topostr.split("|");
	for(var i = 0;i<tokens.length;i++)
	{
		var tokvalue = tokens[i];
		var lhs = tokvalue.substring(0,tokvalue.indexOf("="));
		var rhs = tokvalue.substring(tokvalue.indexOf("=")+1);
		var key = lhs;

		if(i==0){
			key = "egurkha.physical.topology";
		}
		var lhsInd = compIndexMap.get(key);
		if(rhs != 'null')
		{
			var rhsArr = rhs.split(",");
			for(var j=0;j<rhsArr.length;j++)
			{
				var element = rhsArr[j];
				element = element.substring(0,element.lastIndexOf(":"));
				var LorN = element.substring(element.lastIndexOf(":")+1);
				element = element.substring(0,element.lastIndexOf(":"));
				var elementInd = compIndexMap.get(element);
				connectionArr.push(lhsInd+":"+LorN+">"+elementInd);
			}
		}
	}
}

function drawComponents(){
	return this.eGComps;
}

function drawCompNames (){
	return allCompNames;
}
function drawimgNames ()
{
	return alltpNames;
}
function drawNewLabels(){
	return newUnmanageLables;
}

function drawStateCircles(){
	return stateCircles;
}

window.onload = mainFunction;

function mainFunction ()
{
	if("<%=isEntry%>" == "true")
	{
		getMapDetails(positionString, newcompstring, unmanagerstring);
		var connections = [],
		shapes = drawComponents(),
		stateCircle = drawStateCircles(),
		compNames = drawCompNames(),
		newImage = drawNewLabels();
		for (var i = 0, ii = shapes.length; i < ii; i++){
			beatFunction(shapes, i, connections, compNames);
			/*shapes[i].hover(function () {
			this.stop().animate({'scale' : '1.2 1.2'}, 500);
			},  function () {
				this.stop().attr({'scale' : '1 1'});
			});*/
		}

		for(var k=0;k<connectionArr.length;k++)
		{
			var link = connectionArr[k];
			var lorn = link.substring(link.indexOf(":")+1, link.indexOf(">"));
			var ind1 = link.substring(0,link.indexOf(":"));
			var ind2 = link.substring(link.indexOf(">")+1);
			connections.push(r.connection('#<%=color%>',shapes[ind1], shapes[ind2], "#<%=color%>","#<%=color%>|1",lorn)); 
		}
	}
	pageHeightWidth();
}

function beatFunction(shapesObj,index, connectionObj)
{
	shapesObj[index].mouseover (function (event) {
		for(var k=0;k<connectionArr.length;k++)
		{
			var link = connectionArr[k];
			var lorn = link.substring(link.indexOf(":")+1, link.indexOf(">"));
			var ind1 = link.substring(0,link.indexOf(":"));
			var ind2 = link.substring(link.indexOf(">")+1);

			if(ind1 == index || ind2 == index)
			{
				if(connectionObj[k]!=null)
				{
					//connectionObj[k].line.toFront();
					//connectionObj[k].tri.toFront();
					connectionObj[k].line.animate({'stroke' : '#<%=dark%>', 'stroke-width' : 2*zom},500);
					connectionObj[k].tri.animate({'stroke' : '#<%=dark%>','fill' : '#<%=dark%>', 'stroke-width' : 2*zom},500);
				}
			}
		}
	});

	shapesObj[index].mouseout (function (event){
		for(var k=0;k<connectionArr.length;k++)
		{
			var link = connectionArr[k];
			var lorn = link.substring(link.indexOf(":")+1, link.indexOf(">"));
			var ind1 = link.substring(0,link.indexOf(":"));
			var ind2 = link.substring(link.indexOf(">")+1);

			if(ind1 == index || ind2 == index)
			{
				if(connectionObj[k]!=null)
				{
					//connectionObj[k].line.toBack();
					//connectionObj[k].tri.toBack();
					connectionObj[k].line.animate({'stroke' : '#<%=color%>', 'stroke-width' : 1*zom},500);
					connectionObj[k].tri.animate({'stroke' : '#<%=color%>','fill' : '#<%=color%>', 'stroke-width' : 1*zom},500);
				}
			}
		}
	});

	shapesObj[index].mousedown (function (event){
		var isShow = false;
		var isDiv = false;
		var browser = navigator.appName;
		//$j("#menudiv").hide("slow");
		if(browser == "Microsoft Internet Explorer"){		// Browser	Left Click	Middle Click	Right Click
			if(event.button == 2)							// Firefox		0			1				2
				isShow = true;								//	IE			1			4				2
			else if(event.button == 1)
				isDiv = true;
		}
		else{
			if(event.button == 2)
				isShow = true;
			else if(event.button == 0)
				isDiv = true;
		}
		var src = this.attr("src");
		var title = this.attr("title");
		var status ="MANAGED";
		if(isShow || isDiv)
		{
			if(src.indexOf("Unknown_server") < 0){
				var comptype = '';
				if (src.indexOf(".gif")>0)
					first = src.substring(src.lastIndexOf("/")+1,src.indexOf(".gif"));
				else if (src.indexOf(".png")>0)
					first = src.substring(src.lastIndexOf("/")+1,src.indexOf(".png"));
				var second = title;
				if(title.indexOf(":") < 0)
					second = second+":"+"NULL";
				var key = first +":"+ second;
				var newstr = newUnmanageMap.get(key);
				if(newstr!=null)
				{
					if(newstr == 'NEW')
					{
						status = "NEW";
					}
					else if(newstr == 'UNMANAGE')
					{
						status = "UNMANAGE";
					}
				}
			}
			else{
				status ="UNKNOWN";
			}
			document.getElementById('h_title').value = title;
			document.getElementById('h_src').value = src;
			document.getElementById('h_status').value = status;
			
			if(title == 'User')
				status = "User";
		}

		if(isShow){
			if(rectShape!='')
				rectShape.remove();			
		}		
	});

}
</script>
<%
	}
%>
									</div> 
								</td>
							</tr>


<input type="hidden" name="zoom" id="zoom" value='<%=zoomLevel%>'>
							
						</table>
					</td>
				</tr>
			</table>
		</td>
	</tr>
</table>
</div>
</body>
</html>

<%
}
catch(Exception e){
	System.out.println("Exception in EgAutoMainPage.jsp....");
	e.printStackTrace();
}
%>

<%!
	/*
		This method returns, list of New & Unmanaged components form the given segment name
	*/
	private Hashtable getUnmanageAndNewComponents(String segmentName)
	{
		String iniFilePath = EgInstallInfo.getInstallDir() + "/manager/config/eg_autotopology.ini";
		String disIniFilePath = EgInstallInfo.getInstallDir() + "/manager/config/eg_discover.ini";
		IniFile iniFile = new IniFile(iniFilePath);
		IniFile disIniFile = new IniFile(disIniFilePath);
		String newstr = "#New|";
		String unmanagestr = "#Unmanage|";
		
		Hashtable result = new Hashtable();
		//ArrayList newList = new ArrayList();
		//ArrayList unmanageList = new ArrayList();

		Set newSet = new TreeSet();
		Set unmanageSet = new TreeSet();

		String[] varArray = iniFile.getVariables(segmentName);

		for(int k=0;k<varArray.length;k++)
		{
			String varName = varArray[k];
			String thisCompName = varName.substring(0,varName.indexOf(":"));
			String newValue = disIniFile.getValue(thisCompName,newstr+varName);
			if(newValue!=null && newValue.length() > 0)	// Check for new component
			{
				newSet.add(varName);
			}
			else	// Check for unmanage component
			{
				String unmanageValue = disIniFile.getValue(thisCompName,unmanagestr+varName);
				if(unmanageValue!=null && unmanageValue.length() > 0)
				{
					unmanageSet.add(varName);
				}
			}

			String valName = iniFile.getValue(segmentName,varName);
			if(valName!=null && valName.equals("null"))
				continue;
			StringTokenizer st = new StringTokenizer(valName,",");
			while(st.hasMoreTokens())
			{
				String tok = st.nextToken();
				String tmpcompname = tok.substring(0,tok.indexOf(":"));
				String tmpvar = tok.substring(0,tok.lastIndexOf(":"));
				String newval = disIniFile.getValue(tmpcompname,newstr+tmpvar);
				if(newval!=null && newval.length() > 0)
				{
					newSet.add(tmpvar);
				}
				else
				{
					String unmanageValue = disIniFile.getValue(tmpcompname,unmanagestr+tmpvar);
					if(unmanageValue!=null && unmanageValue.length() > 0)
					{
						unmanageSet.add(tmpvar);
					}
				}
			}
		}

		/*if(newSet!=null && newSet.size() > 0)
			newList = new ArrayList(newSet);
		if(unmanageSet!=null && unmanageSet.size() > 0)
			unmanageList = new ArrayList(unmanageSet);*/
		result.put("NEW" , newSet);
		result.put("UNMANAGE" , unmanageSet);
		return result;
	}

	private String getTopologyString(String segmentName, String site , String phyTopology)
	{
		String iniFilePath = EgInstallInfo.getInstallDir() + "/manager/config/eg_autotopology.ini";
		IniFile iniFile = new IniFile(iniFilePath);
		//EgCrawler strBean = new EgCrawler(iniFile);
		String str = null;
		if (phyTopology.equals("1"))
		{
			String[] lines = iniFile.getLinesUnderSubject(segmentName);
			if(lines!=null)
			{
				//str = strBean.getPhysicalTopology(segmentName ,lines);
				str = getPhysicalTopology(segmentName ,lines);
			}
		}
		AlarmPriorities ap = AlarmPriorities.getInstance();
		String newString = null;
		if (StringUtils.isNull(str))
			newString = EgConstants.BLANK_SPACE;
		else
			//newString = str; //ap.getTopologyPriority(str, site);
			newString = ap.getTopologyPriority(str, site);
		newString = sortTopoString(newString);
		return newString;
	}

	public String getPhysicalTopology(String s_segment, String[] lines)
	{
		if(lines==null)
			return "";
		StringBuffer s_pt = new StringBuffer("Web_site:egurkha.physical.topology=");
		try
		{
			String[] s_var = null;
			ArrayList valList = new ArrayList();
			Hashtable myHt = new Hashtable();
			String state = "NO";
			if (s_segment != null && (!s_segment.equals("null")))
			{
				//s_subject = s_segment;
				for(int i=0;i<lines.length;i++)
				{
					String thisLine = lines[i];
					String thisvar = thisLine.substring(0,thisLine.indexOf("="));
					String thisval = thisLine.substring(thisLine.indexOf("=")+1);
					valList.add(thisvar);
					myHt.put(thisvar,thisval);
				}
				s_var = (String []) valList.toArray (new String [valList.size ()]);
			}
			if (s_var == null || s_var.length < 1)
			{
				return "";
			}
			//setConnection();
			Vector v_com =  new Vector(); //getAllValues(s_subject, s_var, "NO");

			//Get All Values (Begin)
			for (int q = 0; q < s_var.length; q++)
			{
				String thisVar = s_var[q];
				if (thisVar.startsWith("#"))
				{
					continue;
				}
				String s_temp = (String) myHt.get(thisVar);
				if (s_temp.indexOf(",") > 0)
				{
					StringTokenizer st = new StringTokenizer(s_temp, ",");
					while (st.hasMoreTokens())
					{
						if (state.equals("YES"))
						{
							v_com.addElement(st.nextToken());
						}
						else
						{
							String ss = st.nextToken();
							v_com.addElement(ss.substring(0, ss.lastIndexOf(":")));
						}
					}
				}
				else if (!s_temp.equals("null"))
				{
					if (state.equals("YES"))
					{
						v_com.addElement(s_temp);
					}
					else
					{
						v_com.addElement(s_temp.substring(0, s_temp.lastIndexOf(":")));
					}
				}
			}
			//Get All Values (End)

			Vector v_unAssgnList=new Vector();
			StringBuffer s_fline = new StringBuffer();
			int maxCount = s_var.length;

			for (int j = 0; j < maxCount; j++)
			{
				if (s_var[j].startsWith("#"))
					continue;

				if (!v_com.contains(s_var[j]))
				{
					//s_fline.append(s_var[j] +":N:"+ getState(s_var[j], "NULL") +",");
					s_fline.append(s_var[j] +":N:"+ "GOOD" +",");
					v_unAssgnList.add(s_var[j]);
				}
			}
			if (s_fline.toString().endsWith(","))
			{
				int bufferLength = s_fline.length();
				s_fline.delete(bufferLength-1, bufferLength);
			}

			s_pt.append(s_fline.toString());

			while(v_unAssgnList.size()>0)
			{
				String s_key = (String)v_unAssgnList.get(0);
				String s_val = (String) myHt.get(s_key);
				if (s_val==null || s_val=="")			//if there cud be any issue with end component of topology node
					s_val = "null";

				s_pt.append("|" + s_key + "=");

				if(!s_val.equalsIgnoreCase("null"))
				{
					if(s_val.indexOf(",") > -1)
					{
						StringTokenizer st = new StringTokenizer(s_val,",");
						while(st.hasMoreTokens())
						{
							String s_token= st.nextToken().trim();
							String s_comp=s_token.substring(0, s_token.lastIndexOf(":"));
							s_pt.append(s_token + ":" + "GOOD");
							if (st.hasMoreTokens())
								s_pt.append(",");
							if(!v_unAssgnList.contains(s_comp)) v_unAssgnList.add(s_comp);
						}
					}
					else
					{
						String s_comp = s_val.substring(0, s_val.lastIndexOf(":"));
						s_pt.append(s_val +":"+"GOOD");
						if(!v_unAssgnList.contains(s_comp)) v_unAssgnList.add(s_comp);
					}
				}
				else
				{
					s_pt.append("null");
				}
				v_unAssgnList.removeElementAt(0);
			}
			//releaseConnection(false);
		}
		catch (Exception e)
		{
			System.out.println("Exception in getPhysicalTopology............");
			e.printStackTrace();
			//releaseConnection(true);
			return "";
		}
		return s_pt.toString();
	}

	/*
	To sort the topology string so that the new topology applet will understand
	*/
	public String sortTopoString(String topoStr) 
	{
		if(topoStr==null)
			return null;
		Hashtable h = new Hashtable();

		String [] topoToks = StringUtils.getTokens(topoStr, "|");

		ArrayList finalLhs = new ArrayList();
		ArrayList finalRhs = new ArrayList();
		ArrayList leftOver = new ArrayList();
		boolean changesOccured = false;
		while (!changesOccured)	 //loop until sorted properly changesOccured becomes true
		{
			changesOccured = true;	
			for (int i=0;i<topoToks.length ;i++ )
			{
				String [] relation = StringUtils.getTokens(topoToks[i], "=");
				String thisLhs ="";
				String thisRhs ="";
				if(relation!=null && relation.length==2)
				{
				 thisLhs = relation[0];
				 thisRhs = relation[1];	//Network_node:Core_Switch_1:NULL:N:GOOD,Network_node:Core_Switch_2:NULL:N:GOOD
				}
				else if(relation!=null && relation.length==1)
				{
					thisLhs = relation[0];
				}
				//System.out.println("! thisLhs:"+thisLhs);
				if (i==0)
				{
					//add first component
					if (finalLhs.indexOf(thisLhs)==-1)	 //if lhs is already added, skip
					{
						finalLhs.add(thisLhs);
						finalRhs.add(getRhsList(thisRhs, thisLhs, h));
					}
				}else
				{
					Object rhsObj = h.get(thisLhs);
					/*
						if rhsObj is null, it means that we get a wrong entry, i.e. the component comes in improper order. 
						a component which havnt come in rhs, has been given as lhs. so dont add it right now. wait until the 
						necessary rhs is getting added.
					*/
					if (rhsObj!=null && finalLhs.indexOf(thisLhs)==-1)
					{
						finalLhs.add(thisLhs);
						finalRhs.add(getRhsList(thisRhs, thisLhs, h));
					}else
					{
						if (rhsObj==null)				//if rhsObj is null, it means that some component is not yet added
							changesOccured = false;
					}
				}
			}
		}

		StringBuffer sb = new StringBuffer();
		for (int i=0;i<finalLhs.size() ;i++ )
		{
			String thisStr = (String)finalLhs.get(i);
			ArrayList rhsList = (ArrayList) finalRhs.get(i);
			Iterator myIter = rhsList.iterator();
			StringBuffer sb2 = new StringBuffer();
			while (myIter.hasNext())
			{
				TopoRhsComp thisRhsComp = (TopoRhsComp) myIter.next();
				sb2.append(thisRhsComp.getComponent());
				if (myIter.hasNext())
					sb2.append(",");
			}
			sb.append(finalLhs.get(i));
			sb.append("=");
			sb.append(sb2.toString());
			sb.append("|");
		}
		String result = sb.toString();
		if (result.endsWith("|"))
		{
			result = result.substring(0, result.lastIndexOf("|"));
		}
		return result;
	}

	public ArrayList getRhsList(String thisRhs, String thisLhs, Hashtable h)
	{
		ArrayList result = new ArrayList();
		if(thisRhs!=null && !thisRhs.equals(""))
		{
			String [] toks = StringUtils.getTokens(thisRhs, ",");
			for (int i=0;i<toks.length ;i++ )
			{
				String thisStr = toks[i];
				TopoRhsComp rhsCmp = new TopoRhsComp(thisStr);
				result.add(rhsCmp);
				//System.out.println("$$$$$:"+rhsCmp.toString()+"\t"+thisLhs);
				if (!rhsCmp.toString().equals("null"))
				{
					h.put(rhsCmp.toString(), thisLhs);
				}
			}
		}
		return result;
	}

	public Hashtable getSegmentComps(String segment)
	{
		Hashtable result = new Hashtable();
		IniFile autoTopoIniFile = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_autotopology.ini");

		String[] thisSegVar = autoTopoIniFile.getVariables(segment);
		if(thisSegVar!=null && thisSegVar.length > 0)
		{
			for(int k=0;k<thisSegVar.length;k++)
			{
				String varName = thisSegVar[k];
				String thisServerType = varName.substring(0,varName.indexOf(":"));
				String compName =  varName.substring(varName.indexOf(":")+1);

				if(result.containsKey(thisServerType))
				{
					ArrayList tmpList = (ArrayList) result.get(thisServerType);
					if(!tmpList.contains(compName))
					{
						tmpList.add(compName);
						result.put(thisServerType,tmpList);
					}
				}
				else
				{
					ArrayList tmpList =new ArrayList();
					tmpList.add(compName);
					result.put(thisServerType,tmpList);
				}

				String thisSegValue = autoTopoIniFile.getValue(segment, varName);
				StringTokenizer st = new StringTokenizer(thisSegValue,",");
				while(st.hasMoreTokens())
				{
					String thistoken = st.nextToken();
					if(thistoken!=null && thistoken.equals("null"))
						continue;
					String thiscomp = thistoken.substring(0,thistoken.lastIndexOf(":"));
					String this_server_type = thiscomp.substring(0,thiscomp.indexOf(":"));
					String this_compname = thiscomp.substring(thiscomp.indexOf(":")+1);
					if(result.containsKey(this_server_type))
					{
						ArrayList tmpList = (ArrayList) result.get(this_server_type);
						if(!tmpList.contains(this_compname))
						{
							tmpList.add(this_compname);
							result.put(this_server_type,tmpList);
						}
					}
					else
					{
						ArrayList tmpList =new ArrayList();
						tmpList.add(this_compname);
						result.put(this_server_type,tmpList);
					}
				}
			}
		}
		return result;
	}

	private Hashtable getGroupDetails(EgGroupInfo egGroupInfo)
	{
		// Collect Group Details, if Group Exists
		Hashtable result = new Hashtable();
		List groupList = new ArrayList();
		String[] groupComponents = egGroupInfo.getAllComponentsFromGroups();
		if(groupComponents!=null && groupComponents.length > 0)
		{
			for(int k=0;k<groupComponents.length;k++)
			{
				String groupVariable = groupComponents[k];
				String groupValue = egGroupInfo.getValue("GROUP_DETAILS", groupVariable);
				result.put(groupVariable , groupValue);
			}
		}
		return result;
	}

	public Hashtable getStartCompsFromTopoAuto(ArrayList allZoneCompList)
	{
		Hashtable result = new Hashtable();
		IniFile autoTopoIniFile = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_autotopology.ini");
		String autoSubject = "Topo_Auto";
		String[] autoVar = autoTopoIniFile.getVariables(autoSubject);
		EgGroupInfo egGroupInfo = new EgGroupInfo();

		Hashtable groupTable = getGroupDetails(egGroupInfo);
		boolean isGroupExists = false;
		if(groupTable!=null && groupTable.size() > 0)
			isGroupExists = true;

		for(int k=0;k<autoVar.length;k++)
		{
			String varName = autoVar[k];
			String valName = autoTopoIniFile.getValue(autoSubject,varName);
			if(allZoneCompList.contains(varName))
				continue;

			StringTokenizer st = new StringTokenizer(valName,",");
			boolean isValid = false;
			while(st.hasMoreTokens())
			{
				String tok = st.nextToken();
				tok = tok.substring(0,tok.lastIndexOf(":"));
				if(!allZoneCompList.contains(tok))
				{
					isValid = true;
					break;
				}
			}

			if(isValid)
			{
				String thisServerType = "";
				String compName = "";

				if(isGroupExists && groupTable.containsKey(varName))
				{
					String groupName = (String) groupTable.get(varName);
					boolean checkFlag = checkFunction(valName, groupName, egGroupInfo);
					if(checkFlag)
					{
						thisServerType = "Group";
						compName = groupName+":"+"NULL";
					}
				}
				else
				{
					thisServerType = varName.substring(0,varName.indexOf(":"));
					compName =  varName.substring(varName.indexOf(":")+1);
				}

				if(thisServerType.equals(""))
					continue;

				if(result.containsKey(thisServerType))
				{
					ArrayList tmpList = (ArrayList) result.get(thisServerType);
					if(!tmpList.contains(compName))
					{
						tmpList.add(compName);
						result.put(thisServerType,tmpList);
					}
				}
				else
				{
					ArrayList tmpList =new ArrayList();
					tmpList.add(compName);
					result.put(thisServerType,tmpList);
				}
			}
		}
		return result;
	}

	private boolean checkFunction(String valueString, String groupName , EgGroupInfo egGroupInfo)
	{
		boolean flag = false;
		StringTokenizer strTokenizer = new StringTokenizer(valueString,",");
		ArrayList groupCompList = egGroupInfo.getAllComponentsUnderGroup(groupName);
		while(strTokenizer.hasMoreTokens())
		{
			String val = strTokenizer.nextToken();
			val = val.substring(0,val.lastIndexOf(":"));
			if(!groupCompList.contains(val))
			{
				flag = true;
				break;
			}
		}
		return flag;
	}
%>