<%
/*******************************************************************************
 *      File name               :   Egassignagentsp.jsp
 *      Purpose                 :   Process page for assigning external agents
 *      Version                 :   1.0
 *      Creation Date           :   08-05-2004
 *      Last Modified Date      :
 *				:
 *      Author                  :   Saravanan.K
 ******************************************************************************/
%>

<%@ include file = "../../../admin/EgTrackerAJSON.jsp" %>
<%@ page import = "java.util.*"%>
<%@ page import = "java.io.*"%>
<%@ page import = "com.eg.EgDiscInfo"%>
<%@ page import = "com.eg.EgManagersIniForManager"%>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page language = "java" contentType = "text/html; charset=UTF-8" pageEncoding = "UTF-8" %>
<%@ page import = "net.sf.json.*"%>
<%
	JSONObject rootJson = new JSONObject();
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json");

	/* code for auditlog starts */
	AuditLogThread auditLogThread = new AuditLogThread();	
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",_user.getLoginID());
	auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
	auditLogThread.setValue("Session_id",session.getId());
	auditLogThread.setValue("Module","Redundant Manager");
	auditLogThread.setValue("Activity","Assign Agents");		
	/* code for auditlog ends */

	/*
	ASSUMPTIONS....
	1. Agents reporting to the Primary manager cannot be Unmanaged.
	    But they can be associated to some other manager.
	2. Agents Disassociated from any of the secondary manager will automatically
	    be associated to Primary manager.

	*/

	EgDiscInfo 	discInfo = new EgDiscInfo("manager");
	Hashtable 	ipNickMap = discInfo.getIpNickMap();
	Hashtable 	nickIpMap = discInfo.getNickIpMap();

	String strAgntToAssociate = request.getParameter("agentsForOtherManagers");
	String[] agentsToAssociate = new String[0];
	List agentsToAssociateList = new ArrayList();
	if (strAgntToAssociate != null)
	{
		StringTokenizer st1 = new StringTokenizer(strAgntToAssociate,",");
		while (st1.hasMoreTokens())
		{
			agentsToAssociateList.add(st1.nextToken());
		}
		agentsToAssociate = (String[])agentsToAssociateList.toArray(new String[0]);
	}
	String selectedManagerIP = request.getParameter("managerIP");
	String primaryManagerIP = request.getParameter("primaryManagerIP");

	// No agents have been managed or unmanaged...so no work here...go back
	if(agentsToAssociate == null)
	{
		/* code for auditlog starts */
		auditLogThread.setValue("Description","No agents have been managed or unmanaged");
		auditLogThread.sendItToDB();
		/* code for auditlog ends */
	}

	// To associate this agent to a manager...
	// Disassociate this agent from the manager its currently reporting to..
	// Associate this agent to the manager selected..
	if(agentsToAssociate != null && agentsToAssociate.length > 0)
	{
		//String [] ipNicks = new String[associate.size()];
		EgManagersIniForManager mgrIni = EgManagersIniForManager.getInstance();
		mgrIni.manageTheseAgents(agentsToAssociate, selectedManagerIP);
		/* code for auditlog starts */
		auditLogThread.setCurrentValue("Manager IP",selectedManagerIP);
		if(agentsToAssociate != null && agentsToAssociate.length>0)
		{
			for(int i=0;i<agentsToAssociate.length;i++)
				auditLogThread.setCurrentValue("Associated Agent(s)",agentsToAssociate[i]);
		}
		auditLogThread.setValue("Description","Agents have been associated to manager");
		auditLogThread.sendItToDB();
		/* code for auditlog ends */
	}

	rootJson.put("requestStatus","success");
	JSONObject resultMsg = new JSONObject();
	resultMsg.put("title",_mapping.getTextDescription("admin.test.ASSIGN - AGENTS"));
	resultMsg.put("message1",_mapping.getTextDescription("admin.test.Agents have been assigned successfully")+".");
	rootJson.put("result",resultMsg);

	System.out.println("rootJson_____"+rootJson);
	out.println(rootJson.toString());
%>



