<%/*******************************************************************************
 *	File name			:	EgAssetConfiguration.jsp
 *	Purpose				:	to configure the asset information.
 *  Author				:   Nirmala Ganesan
 *	Creation Date		:	Dec-03-2013
 ******************************************************************************/
%>

<%@ page import = "java.io.*"%>
<%@ page import = "java.util.*" %>

<%@ include file= "../../../admin/EgTrackerAJSON.jsp"%>
<%@ page import = "com.eg.EgConfigInfo"%>
<%@ page import = "com.eg.EgStartStopDisc"%>
<%@ page import = "com.eg.EgName"%>
<%@ page import = "com.eg.EgInstallInfo"%>
<%@ page import = "com.eg.MappingNameSorter"%>
<%@ page import = "com.eg.EgDiscInfo"%> 
<%@ page import = "com.eg.EgAggregateInfo"%>
<%@ page import = "com.eg.EgTopoInfo"%>
<%@ page import="com.egurkha.ini.IniUI"%>
<%@ page import="com.egurkha.admin.EgAssetManagementDAO"%>
<%@ page import="com.egurkha.admin.EgAssetManagementModel"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@	taglib prefix =	"egui" uri = "../../../WEB-INF/eg-taglib.tld"	%>
<%@ page import="java.util.Date"%>
<%@ page import="net.sf.json.*"%>
<%@ page import="java.text.SimpleDateFormat" %>

<jsp:useBean id="menu" scope="request" class="egurkha.ConfigBean"/>
<%@ page language="java" contentType="application/json;charset=UTF-8" pageEncoding="UTF-8" %>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
try
{
	//System.out.println("The Asset Configuration request is "+ErUtils.prepareQueryString(request.getParameterMap()));
	JSONObject rootJson = new JSONObject();
	JSONObject screenLabels = new JSONObject();
	JSONObject selectedValues = new JSONObject();
	JSONObject comboValues = new JSONObject();
	JSONObject allAssetNames = new JSONObject();

	EgDiscInfo egDisc = new EgDiscInfo("Manager");
	EgAssetManagementDAO assetMgmtDAO = new EgAssetManagementDAO();
	EgAssetManagementModel assetMgmtModel=new EgAssetManagementModel();
	EgMappingInfo egMappingInfo=new EgMappingInfo(trackerLanguage);
	EgTopoInfo topoInfo = new EgTopoInfo(trackerLanguage);
	String[] servertypes;
	String component_with_type = "";
	String serverType = request.getParameter("serverType");
	String serverName = request.getParameter("serverName");
	String action = request.getParameter("action");
	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile egUI = new IniFile(s_iniFile_dir + uiFile);
	IniFile servicesIni = new IniFile(s_iniFile_dir + "eg_services.ini");
	String currentDateFormat = egUI.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	String scriptValueForCustom = "";
	int customColCount = 0;

	Hashtable assetDataForComp = new Hashtable();
	ArrayList assetDataListForComp = new ArrayList();
	Hashtable assetCustomData = new Hashtable();
	Hashtable customFields = new Hashtable();
	ArrayList customColumn = new ArrayList();

	String userDateFormat = _user.getUserDateFormat();
	if(userDateFormat!=null && userDateFormat.equalsIgnoreCase("default"))
	{
		userDateFormat=currentDateFormat;
	}
	SimpleDateFormat userFormat=new SimpleDateFormat(userDateFormat);

	if(currentDateFormat.indexOf("MMM") >= 0)
	{
		for(int i=0; i < currentDateFormat.length();i++)
		{
			if(String.valueOf(currentDateFormat.charAt(i)).equals("M"))
			{
				currentDateFormat = currentDateFormat.replace('M','N');
			}
		}
	}
	Vector configData=new Vector();
	String asset_macAddr = "";
	String asset_OS = "";
	String asset_ipAddess = "";
	asset_ipAddess = request.getParameter("hostIp");
	if (!StringUtils.isNull(serverType) && !StringUtils.isNull(serverName))
	{
		configData =assetMgmtModel.getSystemConfig(serverName,serverType);
	}
	if(configData!=null && configData.size()>0)
	{
		for(int c=0;c<configData.size();c=c+2)
		{
			String testMeasure=(String)configData.get(c);
			String configration=(String)configData.get(c+1);
			if(testMeasure.equalsIgnoreCase("OsInfoTest_cf:Caption") && (configration!=null))
			{
				asset_OS=configration;
			}
			else if(testMeasure.equalsIgnoreCase("IpSettings_cf:Phy_add") && (configration!=null))
			{
				asset_macAddr=configration;
			}
			else if(testMeasure.equalsIgnoreCase("IpSettings_cf:Ip_add")  && (configration!=null))
			{
			asset_ipAddess=configration;
			}
		}
	}
	if (!StringUtils.isNull(serverType) && !StringUtils.isNull(serverName))
	{
		String sernamewithport=serverName;
		if(serverName.indexOf(":NULL") > -1)
		sernamewithport=serverName.substring(0,serverName.indexOf(":NULL"));
		component_with_type = serverType+":"+sernamewithport;
		assetDataForComp = assetMgmtDAO.getAssetInfoForComponent(component_with_type);
		Vector assetNames = assetMgmtDAO.getAllAssetNames();

		if(assetNames.size()>0){
		allAssetNames.put("AssetName",(String)assetNames.get(0));
		}else{
			allAssetNames.put("AssetName","");
		}

	}
	if (assetDataForComp != null && !assetDataForComp.isEmpty())
	{
		assetDataListForComp = (ArrayList)assetDataForComp.get("data");
		assetCustomData = (Hashtable)assetDataForComp.get("cols");
		if (assetCustomData != null && !assetCustomData.isEmpty())
		 {
			Iterator itr = assetCustomData.keySet().iterator();
			while (itr.hasNext())
			{
				String colName = (String)itr.next();
				String colVal = (String)assetCustomData.get(colName);
				if (StringUtils.isNull(colVal) || colVal.equalsIgnoreCase("none"))
					continue;
				customFields.put(colName,colVal);
			}
		}
		if ( customFields !=  null && !customFields.isEmpty())
		{
			customColumn = new ArrayList(customFields.keySet());
			customColCount = customColumn.size();
		}
		Collections.sort(customColumn);
		 JSONArray customArr = new JSONArray();
		for( int c = 0; c < customColumn.size() ; c++)
		{
			JSONObject customObj = new JSONObject();
			String colName = (String)customColumn.get(c);
			String colValues = (String)customFields.get(colName);
			customObj.put("CustomDisplay",colName);
			customObj.put("CustomValue",colValues);
			scriptValueForCustom = scriptValueForCustom +colName+"~@~"+colValues;
			if (c < customColumn.size()-1)
				scriptValueForCustom = scriptValueForCustom+"#~#";
			customArr.add(customObj);
		}
		selectedValues.put("CUSTOM_ATTRIBUTES",customArr);
	}
	String asset_name = "";
	String asset_type = "";
	String asset_location = "";
	String asset_manufacturer = "";
	String asset_suppotGroup = "";
	String asset_BusinessImpct = "";
	String asset_description = "";
	String asset_state = "";
	String asset_owner = "";
	String asset_businessService = "";
	String asset_phNo = "";
	String asset_emailAddr = "";
	String asset_licnsExpDate = "";
	String asset_ASMExpDate = "";
	String asset_serialNum = "";
	String asset_licnsSerialNum = "";
	if (assetDataListForComp != null && !assetDataListForComp.isEmpty())
	{
		asset_name = (String)assetDataListForComp.get(0);
		asset_description = (String)assetDataListForComp.get(1);
		asset_type = (String)assetDataListForComp.get(2);
		asset_state = (String)assetDataListForComp.get(3);
		asset_location = (String)assetDataListForComp.get(4);
		//if (StringUtils.isNull(asset_ipAddess))
		asset_ipAddess = (String)assetDataListForComp.get(5);
		asset_macAddr = (String)assetDataListForComp.get(6);
		asset_OS = (String)assetDataListForComp.get(7);
		asset_manufacturer = (String)assetDataListForComp.get(8);
		asset_owner = (String)assetDataListForComp.get(9);
		asset_suppotGroup = (String)assetDataListForComp.get(10);
		asset_phNo = (String)assetDataListForComp.get(11);
		asset_emailAddr = (String)assetDataListForComp.get(12);
		asset_licnsExpDate = (String)assetDataListForComp.get(13);
		asset_ASMExpDate = (String)assetDataListForComp.get(14);
		asset_serialNum = (String)assetDataListForComp.get(15);
		asset_licnsSerialNum = (String)assetDataListForComp.get(16);
		asset_businessService = (String)assetDataListForComp.get(17);
		asset_BusinessImpct = (String)assetDataListForComp.get(18);
		
		if(!StringUtils.isNull(asset_ASMExpDate) && !asset_ASMExpDate.equalsIgnoreCase("NONE") && !asset_ASMExpDate.equals("") )
		{
		try
			{
			Date ASMExpiryDate = new Date(asset_ASMExpDate);
			asset_ASMExpDate = userFormat.format(ASMExpiryDate);
			}catch(Exception e){
			System.out.println("Exception while date formating ");
			}
		}
		if(!StringUtils.isNull(asset_licnsExpDate) && !asset_licnsExpDate.equals("-1")  && !asset_licnsExpDate.equalsIgnoreCase("NONE")
			&& !asset_licnsExpDate.equals("") )
		{
			
			try
			{
				Date licenseExpiryDate = new Date(asset_licnsExpDate);
				asset_licnsExpDate = userFormat.format(licenseExpiryDate);  
			}catch(Exception e){
				System.out.println("Exception while date formating");
			}
		}
	}
	if (StringUtils.isNull(serverType) || serverType.equalsIgnoreCase("NONE"))
		serverType = "";
	if (StringUtils.isNull(serverName) || serverName.equalsIgnoreCase("NONE"))
		serverName = "";
	if (StringUtils.isNull(asset_name) || asset_name.equalsIgnoreCase("NONE"))
		asset_name = "";
	if (StringUtils.isNull(asset_type) || asset_type.equalsIgnoreCase("NONE"))
		asset_type = "";
	if (StringUtils.isNull(asset_location) || asset_location.equalsIgnoreCase("NONE"))
		asset_location = "";
	if (StringUtils.isNull(asset_macAddr) || asset_macAddr.equalsIgnoreCase("NONE"))
		asset_macAddr = "";
	if (StringUtils.isNull(asset_manufacturer) || asset_manufacturer.equalsIgnoreCase("NONE"))
		asset_manufacturer = "";
	if (StringUtils.isNull(asset_suppotGroup) || asset_suppotGroup.equalsIgnoreCase("NONE"))
		asset_suppotGroup = "";
	if (StringUtils.isNull(asset_BusinessImpct) || asset_BusinessImpct.equalsIgnoreCase("NONE"))
		asset_BusinessImpct = "";
	if (StringUtils.isNull(asset_description) || asset_description.equalsIgnoreCase("NONE"))
		asset_description = "";
	if (StringUtils.isNull(asset_ipAddess) || asset_ipAddess.equalsIgnoreCase("NONE"))
		asset_ipAddess = "";
	if (StringUtils.isNull(asset_state) || asset_state.equalsIgnoreCase("NONE"))
		asset_state = "";
	if (StringUtils.isNull(asset_OS) || asset_OS.equalsIgnoreCase("NONE"))
		asset_OS = "";
	if (StringUtils.isNull(asset_owner) || asset_owner.equalsIgnoreCase("NONE"))
		asset_owner = "";
	if (StringUtils.isNull(asset_businessService) || asset_businessService.equalsIgnoreCase("NONE"))
		asset_businessService = "";
	if (StringUtils.isNull(asset_phNo) || asset_phNo.equalsIgnoreCase("NONE"))
		asset_phNo = "";
	if (StringUtils.isNull(asset_emailAddr) || asset_emailAddr.equalsIgnoreCase("NONE"))
		asset_emailAddr = "";
	if (StringUtils.isNull(asset_licnsExpDate) || asset_licnsExpDate.equalsIgnoreCase("NONE"))
		asset_licnsExpDate = "";
	if (StringUtils.isNull(asset_ASMExpDate) || asset_ASMExpDate.equalsIgnoreCase("NONE"))
		asset_ASMExpDate = "";
	if (StringUtils.isNull(asset_serialNum) || asset_serialNum.equalsIgnoreCase("NONE"))
		asset_serialNum = "";
	if (StringUtils.isNull(asset_licnsSerialNum) || asset_licnsSerialNum.equalsIgnoreCase("NONE"))
		asset_licnsSerialNum = "";
	////Starts here
	String userLanguage = _user.getLanguage();
	MappingNameSorter sorter = new MappingNameSorter(userLanguage);
	ArrayList serviceList = topoInfo.getSitesForComponent(serverType+":"+serverName);
	menu.createFile("eg_discover.ini");
	servertypes = menu.getServerTypes();
	ArrayList serverTypeList = new ArrayList();
	ArrayList a_server_types = new ArrayList();
	String [] s_arr = null;
	for(int z=0;z < servertypes.length;z++)
	{
		s_arr = menu.getVariables(servertypes[z]);
		if(s_arr.length > 1)
		{
			a_server_types.add(servertypes[z]);
		}
	}
	String s_tmp = "";
	for (int j=0; j<a_server_types.size(); j++)
	{
		s_tmp = (String)a_server_types.get(j);
		if(s_tmp.equals("Site_servers"))
		{
			continue;
		}
		serverTypeList.add(s_tmp);
	}
	serverTypeList = sorter.getSortedCompTypeList(serverTypeList);
	String CompTypeLabel = egMappingInfo.getTextDescription("admin.asset.Component Type");
	screenLabels.put("COMPTYPELABEL",CompTypeLabel);
	JSONArray compTypeArr = new JSONArray();
	JSONObject cmptype = new JSONObject(); 
	cmptype.put("valueField", "-1");
	cmptype.put("displayField",egMappingInfo.getTextDescription("admin.server.Please select a Component Type"));
	
	compTypeArr.add(cmptype);
	String selected="";
	JSONObject selectedCmpType=new JSONObject();
	for(int i=0 ;i<serverTypeList.size();i++)
	{
		JSONObject comptypeObj = new JSONObject();
		EgName nameObj = (EgName)serverTypeList.get(i);
		String actualNameForCompType = nameObj.getActualName();
		String displyNameForCompType = nameObj.getLocalName();
		if (!StringUtils.isNull(serverType) && serverType.equals(actualNameForCompType))
		{
			selectedValues.put("Selected_CmpType",actualNameForCompType);
		}
		
		else
		selected = "";
		
		comptypeObj.put("valueField", actualNameForCompType);
		comptypeObj.put("displayField", displyNameForCompType);
		compTypeArr.add(comptypeObj);
	}
	comboValues.put("COMPTYPE_VAL", compTypeArr);
	String[] servers = null;
	ArrayList serversList = new ArrayList();
	if (serverType != null )
	{
		servers = egDisc.getAllServersOfType(serverType);

		Arrays.sort(servers,String.CASE_INSENSITIVE_ORDER);
		serversList = new ArrayList(Arrays.asList(servers));
	}
	String CompNameLabel = egMappingInfo.getTextDescription("admin.asset.Component Name");
	screenLabels.put("COMPNAMELABEL",CompNameLabel);
	
	String selectedServer = "";
	JSONArray compNameArr = new JSONArray();
	if (serversList == null || serversList.isEmpty())
	{
		
		JSONObject cmpname = new JSONObject(); 
		cmptype.put("valueField", "-1");
		cmpname.put("displayField",egMappingInfo.getTextDescription("admin.server.Please select a Component "));
		compNameArr.add(cmpname);
	}
	if( serversList != null && !serversList.isEmpty())
	{
		selected = "";
		for ( int c = 0 ; c < serversList.size() ; c++ )
		{
			JSONObject compNameObj = new JSONObject();
			String comp_with_type = (String)serversList.get(c);
						
			String server = "";
			JSONObject selectedCmpNam = new JSONObject();
			if (!StringUtils.isNull(comp_with_type) && comp_with_type.indexOf(":") > -1)
			{
				server = comp_with_type.substring(comp_with_type.indexOf(":")+1);
				String actualServer = server;
				if (!StringUtils.isNull(serverName) && serverName.equals(server))
				{
					selectedServer = server;
					selected = "selected";
					selectedValues.put("Selected_Comp",server);
				
				}
				else
					selected = "";
				if (StringUtils.isNull(serverName) && !serversList.isEmpty())
				{
					if (c == 0)
					{
						selectedServer = server;
						selected = "selected";
						selectedValues.put("Selected_Comp",server);
					
					}
				}
				if (!StringUtils.isNull(server) && server.indexOf(":NULL") > -1)
					server = server.substring(0,server.indexOf(":NULL"));
				compNameObj.put("valueField", actualServer);
				compNameObj.put("displayField", server);
				compNameArr.add(compNameObj);
			}
		}
		comboValues.put("COMPNAME_VAL", compNameArr);
		
		String AssetDetailLabel = egMappingInfo.getTextDescription("admin.asset.Asset Details");
		screenLabels.put("ASSET_DETAILS",AssetDetailLabel);
		String assetName = egMappingInfo.getTextDescription("admin.asset.Asset Name");
		String assetType = egMappingInfo.getTextDescription("admin.asset.Asset Type");
		String assetLocation = egMappingInfo.getTextDescription("admin.asset.Asset location");
		String assetDescp = egMappingInfo.getTextDescription("admin.asset.Asset Description");
		String assetState = egMappingInfo.getTextDescription("admin.asset.Asset State");
		String technicalDetails = egMappingInfo.getTextDescription("admin.asset.Technical Details");
		String hostName= egMappingInfo.getTextDescription("admin.asset.Host IP/Name");
		String os = egMappingInfo.getTextDescription("admin.asset.Operating System");
		String serialNumber = egMappingInfo.getTextDescription("admin.asset.Serial number");

		// Note: FieldLabel Changed as ASM Expiry Date to Maintenance Expiry Date.
		String ASMExpdate = egMappingInfo.getTextDescription("admin.asset.Maintenance Expiry date");
		String macAddress = egMappingInfo.getTextDescription("admin.asset.MAC Address");
		String manufacturer = egMappingInfo.getTextDescription("admin.asset.Manufacturer");
		String licenseSerialNumber = egMappingInfo.getTextDescription("admin.asset.License serial number");
		String expDate = egMappingInfo.getTextDescription("admin.asset.License Expiry date");
		String misc = egMappingInfo.getTextDescription("admin.asset.Misc");
		String owner = egMappingInfo.getTextDescription("admin.asset.Owner/user");
		String emailAddress = egMappingInfo.getTextDescription("admin.asset.Email Address");
		String businessImpact = egMappingInfo.getTextDescription("admin.asset.Business Impact");
		String supportGroup = egMappingInfo.getTextDescription("admin.asset.Support Group");
		String phNumber = egMappingInfo.getTextDescription("admin.asset.Phone number");
		String businessService = egMappingInfo.getTextDescription("admin.asset.Business Service");
		
		screenLabels.put("ASSET_NAME",assetName);
		screenLabels.put("assetType",assetType);
		screenLabels.put("assetLocation",assetLocation);
		screenLabels.put("assetDescp",assetDescp);
		screenLabels.put("assetState",assetState);
		screenLabels.put("technicalDetails",technicalDetails);
		screenLabels.put("hostName",hostName);
		screenLabels.put("os",os);
		screenLabels.put("serialNumber",serialNumber);
		screenLabels.put("ASMExpdate",ASMExpdate);
		screenLabels.put("macAddress",macAddress);
		screenLabels.put("manufacturer",manufacturer);
		screenLabels.put("licenseSerialNumber",licenseSerialNumber);
		screenLabels.put("expDate",expDate);
		screenLabels.put("misc",misc);
		screenLabels.put("owner",owner);
		screenLabels.put("emailAddress",emailAddress);
		screenLabels.put("businessImpact",businessImpact);
		screenLabels.put("supportGroup",supportGroup);
		screenLabels.put("phNumber",phNumber);
		screenLabels.put("businessService",businessService);
		
		String useSelected = "";
		String maintenanceSelected = "";
		String repairSelected = "";
		String decommisionedSelected = "";
		JSONArray userArray = new JSONArray();
		JSONObject  userObj = new JSONObject();
		if (!StringUtils.isNull(asset_state) && asset_state.equalsIgnoreCase("In Use"))
		{
			useSelected = "selected";
			selectedValues.put("Selected_state",asset_state);
		}
		if (!StringUtils.isNull(asset_state) && asset_state.equalsIgnoreCase("Maintenance"))
		{
			maintenanceSelected = "selected";
			selectedValues.put("Selected_state",asset_state);
		}
		if (!StringUtils.isNull(asset_state) && asset_state.equalsIgnoreCase("Decommisioned"))
		{
			decommisionedSelected = "selected";
			selectedValues.put("Selected_state",asset_state);
		}
		selectedValues.put("Selected_state",asset_state);
		//userArray.add(selecteduserObj);		
		userObj.put("valueField", "In Use");
		userObj.put("displayField", "In Use");
		userArray.add(userObj);
		userObj.put("valueField", "Maintenance");
		userObj.put("displayField", "Maintenance");
		userArray.add(userObj);
		userObj.put("valueField", "Repair");
		userObj.put("displayField", "Repair");
		userArray.add(userObj);
		userObj.put("valueField", "Decommisioned");
		userObj.put("displayField", "Decommisioned");
		userArray.add(userObj);
		
		comboValues.put("ACESS_STATE", userArray);
		if(!StringUtils.isNull(asset_OS))
			{
			 ////Get the value from user
			}
		else
			{
				String osNames = servicesIni.getValue("ASSET_MANAGEMENT","Asset_system_supported_os");
				String[] osSubjects = null;
				osSubjects = StringUtils.getTrimmedTokens(osNames,",");
				JSONArray osArray = new JSONArray();
				if ( osSubjects != null)
				{
					for ( int inc = 0 ; inc < osSubjects.length ; inc++ )
					{ 
						JSONObject osObj = new JSONObject();
						String osName = osSubjects[inc];
						if (!StringUtils.isNull(osName) && asset_OS.equals(osName))
						{	
							selectedValues.put("Selected_osVal",asset_OS);
						}
						else
							selected = "";
							
						osObj.put("valueField", osName);
						osObj.put("displayField", osName);
						osArray.add(osObj);
					}
					comboValues.put("OS_VALUE", osArray);
				}
			}
			String highSelected = "";
			String mediumSelected = "";
			String lowSelected = "";
			JSONObject  businessObj = new JSONObject();
			JSONArray businessArray = new JSONArray();
			if (!StringUtils.isNull(asset_BusinessImpct) && asset_BusinessImpct.equalsIgnoreCase("high"))
			{
				highSelected = "selected";
				selectedValues.put("Selected_BusinessImpact", asset_BusinessImpct);
			}
			if (!StringUtils.isNull(asset_BusinessImpct) && asset_BusinessImpct.equalsIgnoreCase("medium"))
			{
				mediumSelected = "selected";
				selectedValues.put("Selected_BusinessImpact", asset_BusinessImpct);
			}
			if (!StringUtils.isNull(asset_BusinessImpct) && asset_BusinessImpct.equalsIgnoreCase("Low"))
			{
				lowSelected = "selected";
				selectedValues.put("Selected_BusinessImpact", asset_BusinessImpct);
			}
			businessObj.put("valueField", "High");
			businessObj.put("displayField", "High");
			businessArray.add(businessObj);
			businessObj.put("valueField", "Medium");
			businessObj.put("displayField", "Medium");
			businessArray.add(businessObj);
			businessObj.put("valueField", "Low");
			businessObj.put("displayField", "Low");
			businessArray.add(businessObj);
			comboValues.put("BUSINESS_IMPACT", businessArray);///////////Ends here
		
			selectedValues.put("Asset_Name",asset_name);
			selectedValues.put("Asset_type",asset_type);
			selectedValues.put("Asset_location",asset_location);
			selectedValues.put("Asset_description",asset_description);
			selectedValues.put("Asset_ipAddess",asset_ipAddess);
			selectedValues.put("Asset_OS",asset_OS);
			selectedValues.put("Asset_serialNum",asset_serialNum);
			selectedValues.put("Asset_ASMExpDate",asset_ASMExpDate);
			selectedValues.put("Asset_macAddr",asset_macAddr);
			selectedValues.put("Asset_manufacturer",asset_manufacturer);
			selectedValues.put("Asset_licnsSerialNum",asset_licnsSerialNum);
			selectedValues.put("Asset_licnsExpDate",asset_licnsExpDate);
			selectedValues.put("Licens_No_expry",asset_licnsExpDate);//for  checking never expiry date
			selectedValues.put("Asset_emailAddr",asset_emailAddr);
			selectedValues.put("Asset_suppotGroup",asset_suppotGroup);
			selectedValues.put("Asset_phNo",asset_phNo);
			selectedValues.put("Asset_businessService",asset_businessService);
			selectedValues.put("Asset_Owner",asset_owner);
			
			String actualServerName = selectedServer;
			if (!StringUtils.isNull(selectedServer) && selectedServer.indexOf(":NULL") > -1)
			selectedServer = selectedServer.substring(0,selectedServer.indexOf(":NULL"));
			ArrayList serverTypeForSameNick = new ArrayList(egDisc.getServerTypesForNick(selectedServer));
			if ( serverTypeForSameNick != null && serverTypeForSameNick.size() > 1 )
			{
				JSONArray serverArray = new JSONArray();
				String AppliAllTiTle= "Apply Asset Information to all other servers";
				for ( int s = 0 ; s < serverTypeForSameNick.size() ; s++ )
				{
					JSONObject serverObj = new JSONObject();
					String actualServerType = (String)serverTypeForSameNick.get(s);
					String actualServerWithType = actualServerType+":"+actualServerName;
					if (StringUtils.isNull(actualServerWithType) || component_with_type.equals(actualServerWithType))
						continue;
					String dispalyServerWithType = egMappingInfo.getComponentTypeDescription(actualServerType)+":"+selectedServer;
					serverObj.put("valueField", actualServerWithType);
					serverObj.put("displayField", dispalyServerWithType);
					serverArray.add(serverObj);
					
				}
				comboValues.put("ApplyAll_Server", serverArray);
			}
			String nick = "";
			if (!StringUtils.isNull(serverName))
			{
				if (serverName.indexOf(":NULL") > -1)
					nick = serverName.substring(0,serverName.indexOf(":NULL"));
				String assetCmp = egMappingInfo.getTextDescription("admin.asset.Business Services for"+nick+"admin.asset.component");
				selectedValues.put("Asset_BusinessService_Component",assetCmp);
			}
			
			if (serviceList != null && !serviceList.isEmpty())
			{
				JSONArray serviceArray = new JSONArray();
				for ( int s = 0 ; s < serviceList.size() ; s++)
				{
					JSONObject serviceObj = new JSONObject();
					String service = (String)serviceList.get(s);
					serviceObj.put("valueField", service);
					serviceObj.put("displayField", service);
					serviceArray.add(serviceObj);
				}
				comboValues.put("ApplyAll_Service", serviceArray);
			}
			screenLabels.put("ArrtibuteDisplay",egMappingInfo.getTextDescription("admin.asset.Custom Attribute Display"));
			screenLabels.put("ArrtibuteValue",egMappingInfo.getTextDescription("admin.asset.Custom Attribute value"));
		
		rootJson.put("ALL_ASSET_NAMES", allAssetNames);
		rootJson.put("SCREEN_LABELS", screenLabels);
		rootJson.put("COMBO_VALUES", comboValues);
		rootJson.put("SELECTED_VALUES", selectedValues);
		out.println(rootJson.toString());
		
		String requestData = ErUtils.prepareEncodedQueryString(request.getParameterMap());
		if(requestData!=null)
		{
			if(session!=null)
			{
				session.setAttribute("adminLastAccessedURL","/final/admin/EgAssetInfo.jsp?"+requestData);
			}
		}
		else
		{
			session.setAttribute("adminLastAccessedURL","/final/admin/EgAssetInfo.jsp");
		}
	}
}
catch(Throwable e ){
	e.printStackTrace();	
}
%>
	